/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.server;

import java.io.File;
import java.util.logging.Logger;
import org.apache.hadoop.eclipse.Activator;
import org.apache.hadoop.eclipse.ErrorMessageDialog;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class JarModule
implements IRunnableWithProgress {
    static Logger log = Logger.getLogger(JarModule.class.getName());
    private IResource resource;
    private File jarFile;

    public JarModule(IResource resource) {
        this.resource = resource;
    }

    public String getName() {
        return this.resource.getProject().getName() + "/" + this.resource.getName();
    }

    public void run(IProgressMonitor monitor) {
        log.fine("Build jar");
        JarPackageData jarrer = new JarPackageData();
        jarrer.setExportJavaFiles(true);
        jarrer.setExportClassFiles(true);
        jarrer.setExportOutputFolders(true);
        jarrer.setOverwrite(true);
        try {
            Object element = this.resource.getAdapter(IJavaElement.class);
            IType type = ((ICompilationUnit)element).findPrimaryType();
            jarrer.setManifestMainClass(type);
            File baseDir = Activator.getDefault().getStateLocation().toFile();
            String prefix = String.format("%s_%s-", this.resource.getProject().getName(), this.resource.getName());
            File jarFile = File.createTempFile(prefix, ".jar", baseDir);
            jarrer.setJarLocation((IPath)new Path(jarFile.getAbsolutePath()));
            jarrer.setElements((Object[])this.resource.getProject().members(1));
            IJarExportRunnable runnable = jarrer.createJarExportRunnable(Display.getDefault().getActiveShell());
            runnable.run(monitor);
            this.jarFile = jarFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public static File createJarPackage(IResource resource) {
        JarModule jarModule = new JarModule(resource);
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, true, (IRunnableWithProgress)jarModule);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        File jarFile = jarModule.getJarFile();
        if (jarFile == null) {
            ErrorMessageDialog.display((String)"Run on Hadoop", (String)"Unable to create or locate the JAR file for the Job");
            return null;
        }
        return jarFile;
    }
}

