/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.servers;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.eclipse.server.ConfProp;
import org.apache.hadoop.eclipse.server.HadoopServer;
import org.apache.hadoop.eclipse.servers.HadoopLocationWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class HadoopLocationWizard
extends WizardPage {
    Image circle;
    private HadoopServer location;
    private HadoopServer original;

    public HadoopLocationWizard() {
        super("Hadoop Server", "New Hadoop Location", null);
        this.original = null;
        this.location = new HadoopServer();
        this.location.setLocationName("");
    }

    public HadoopLocationWizard(HadoopServer server) {
        super("Create a new Hadoop location", "Edit Hadoop Location", null);
        this.original = server;
        this.location = new HadoopServer(server);
    }

    public HadoopServer performFinish() {
        try {
            if (this.original == null) {
                Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                return this.location;
            }
            String originalName = this.original.getLocationName();
            this.original.load(this.location);
            Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            return this.original;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setMessage("Invalid server location values", 3);
            return null;
        }
    }

    private void testLocation() {
        this.setMessage("Not implemented yet", 2);
    }

    public boolean isPageComplete() {
        boolean ok;
        String locName = this.location.getConfProp(ConfProp.PI_LOCATION_NAME);
        if (locName == null || locName.length() == 0 || locName.contains("/")) {
            this.setMessage("Bad location name: the location name should not contain any character prohibited in a file name.", 2);
            return false;
        }
        String master = this.location.getConfProp(ConfProp.PI_JOB_TRACKER_HOST);
        if (master == null || master.length() == 0) {
            this.setMessage("Bad master host name: the master host name refers to the machine that runs the Job tracker.", 2);
            return false;
        }
        String jobTracker = this.location.getConfProp(ConfProp.JOB_TRACKER_URI);
        String[] strs = jobTracker.split(":");
        boolean bl = ok = strs.length == 2;
        if (ok) {
            try {
                int port = Integer.parseInt(strs[1]);
                ok = port >= 0 && port < 65536;
            }
            catch (NumberFormatException nfe) {
                ok = false;
            }
        }
        if (!ok) {
            this.setMessage("The job tracker information (" + ConfProp.JOB_TRACKER_URI.name + ") is invalid. " + "This usually looks like \"host:port\"", 2);
            return false;
        }
        String fsDefaultURI = this.location.getConfProp(ConfProp.FS_DEFAULT_URI);
        try {
            URI uri = new URI(fsDefaultURI);
        }
        catch (URISyntaxException e) {
            this.setMessage("The default file system URI is invalid. This usually looks like \"hdfs://host:port/\" or \"file:///dir/\"", 2);
        }
        this.setMessage("Define the location of a Hadoop infrastructure for running MapReduce applications.");
        return true;
    }

    public void createControl(Composite parent) {
        this.setTitle("Define Hadoop location");
        this.setDescription("Define the location of a Hadoop infrastructure for running MapReduce applications.");
        Composite panel = new Composite(parent, 4);
        GridLayout glayout = new GridLayout(2, false);
        panel.setLayout((Layout)glayout);
        TabMediator mediator = new TabMediator(this, panel);
        GridData gdata = new GridData(1808);
        gdata.horizontalSpan = 2;
        mediator.folder.setLayoutData((Object)gdata);
        this.setControl((Control)panel);
        Button btn = new Button(panel, 0);
        btn.setText("&Load from file");
        btn.setEnabled(false);
        btn.setToolTipText("Not yet implemented");
        btn.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        Button validate = new Button(panel, 0);
        validate.setText("&Validate location");
        validate.setEnabled(false);
        validate.setToolTipText("Not yet implemented");
        validate.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Text createConfText(ModifyListener listener, Composite parent, ConfProp prop) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(768);
        text.setLayoutData((Object)data);
        text.setData("hProp", (Object)prop);
        text.setText(this.location.getConfProp(prop));
        text.addModifyListener(listener);
        return text;
    }

    private Button createConfCheckButton(SelectionListener listener, Composite parent, ConfProp prop, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        button.setData("hProp", (Object)prop);
        button.setSelection(this.location.getConfProp(prop).equalsIgnoreCase("yes"));
        button.addSelectionListener(listener);
        return button;
    }

    private Text createConfLabelText(ModifyListener listener, Composite parent, ConfProp prop, String labelText) {
        Label label = new Label(parent, 0);
        if (labelText == null) {
            labelText = prop.name;
        }
        label.setText(labelText);
        return this.createConfText(listener, parent, prop);
    }

    private Text createConfNameEditor(ModifyListener listener, Composite parent, String propName, String labelText) {
        ConfProp prop = ConfProp.getByName((String)propName);
        if (prop != null) {
            return this.createConfLabelText(listener, parent, prop, labelText);
        }
        Label label = new Label(parent, 0);
        if (labelText == null) {
            labelText = propName;
        }
        label.setText(labelText);
        Text text = new Text(parent, 2052);
        GridData data = new GridData(768);
        text.setLayoutData((Object)data);
        text.setData("hPropName", (Object)propName);
        text.setText(this.location.getConfProp(propName));
        text.addModifyListener(listener);
        return text;
    }

    static /* synthetic */ HadoopServer access$000(HadoopLocationWizard x0) {
        return x0.location;
    }

    static /* synthetic */ void access$100(HadoopLocationWizard x0) {
        x0.testLocation();
    }

    static /* synthetic */ IWizardContainer access$200(HadoopLocationWizard x0) {
        return x0.getContainer();
    }

    static /* synthetic */ Text access$300(HadoopLocationWizard x0, ModifyListener x1, Composite x2, ConfProp x3, String x4) {
        return x0.createConfLabelText(x1, x2, x3, x4);
    }

    static /* synthetic */ Text access$400(HadoopLocationWizard x0, ModifyListener x1, Composite x2, ConfProp x3) {
        return x0.createConfText(x1, x2, x3);
    }

    static /* synthetic */ Button access$500(HadoopLocationWizard x0, SelectionListener x1, Composite x2, ConfProp x3, String x4) {
        return x0.createConfCheckButton(x1, x2, x3, x4);
    }

    static /* synthetic */ Text access$600(HadoopLocationWizard x0, ModifyListener x1, Composite x2, String x3, String x4) {
        return x0.createConfNameEditor(x1, x2, x3, x4);
    }
}

