/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.servers;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.eclipse.Activator;
import org.apache.hadoop.eclipse.ErrorMessageDialog;
import org.apache.hadoop.eclipse.server.HadoopServer;
import org.apache.hadoop.eclipse.server.JarModule;
import org.apache.hadoop.eclipse.servers.HadoopLocationWizard;
import org.apache.hadoop.eclipse.servers.RunOnHadoopWizard;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

/*
 * Exception performing whole class analysis ignored.
 */
public class RunOnHadoopWizard
extends Wizard {
    private MainWizardPage mainPage;
    private HadoopLocationWizard createNewPage;
    private IFile resource;
    private ILaunchConfigurationWorkingCopy iConf;
    private IProgressMonitor progressMonitor;

    public RunOnHadoopWizard(IFile resource, ILaunchConfigurationWorkingCopy iConf) {
        this.resource = resource;
        this.iConf = iConf;
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Run on Hadoop");
    }

    public void addPages() {
        this.mainPage = new MainWizardPage(this);
        this.addPage((IWizardPage)this.mainPage);
        this.createNewPage = new HadoopLocationWizard();
        this.addPage((IWizardPage)this.createNewPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performFinish() {
        File confDir;
        HadoopServer location = null;
        if (MainWizardPage.access$000((MainWizardPage)this.mainPage).getSelection()) {
            location = this.createNewPage.performFinish();
        } else if (MainWizardPage.access$100((MainWizardPage)this.mainPage).getSelection().length == 1) {
            location = (HadoopServer)MainWizardPage.access$100((MainWizardPage)this.mainPage).getSelection()[0].getData();
        }
        if (location == null) {
            return false;
        }
        File baseDir = Activator.getDefault().getStateLocation().toFile();
        File jarFile = JarModule.createJarPackage((IResource)this.resource);
        if (jarFile == null) {
            ErrorMessageDialog.display((String)"Run on Hadoop", (String)"Unable to create or locate the JAR file for the Job");
            return false;
        }
        try {
            confDir = File.createTempFile("hadoop-conf-", "", baseDir);
            confDir.delete();
            confDir.mkdirs();
            if (!confDir.isDirectory()) {
                ErrorMessageDialog.display((String)"Run on Hadoop", (String)("Cannot create temporary directory: " + confDir));
                return false;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        JobConf conf = new JobConf(location.getConfiguration());
        conf.setJar(jarFile.getAbsolutePath());
        try {
            File confFile = new File(confDir, "core-site.xml");
            FileOutputStream fos = new FileOutputStream(confFile);
            try {
                conf.writeXml((OutputStream)fos);
                fos.close();
                fos = null;
            }
            finally {
                IOUtils.closeStream((Closeable)fos);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        try {
            List classPath = this.iConf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, new ArrayList());
            Path confIPath = new Path(confDir.getAbsolutePath());
            IRuntimeClasspathEntry cpEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)confIPath);
            classPath.add(0, cpEntry.getMemento());
            this.iConf.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classPath);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void refreshButtons() {
        this.getContainer().updateButtons();
    }

    public boolean canFinish() {
        if (this.mainPage != null) {
            return this.mainPage.canFinish();
        }
        return false;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    static /* synthetic */ void access$200(RunOnHadoopWizard x0) {
        x0.refreshButtons();
    }
}

