/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.servers;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.eclipse.Activator;
import org.apache.hadoop.eclipse.server.HadoopServer;
import org.apache.hadoop.eclipse.servers.IHadoopServerListener;
import org.apache.hadoop.eclipse.servers.ServerRegistry;
import org.eclipse.jface.dialogs.MessageDialog;

public class ServerRegistry {
    private static final ServerRegistry INSTANCE = new ServerRegistry();
    public static final int SERVER_ADDED = 0;
    public static final int SERVER_REMOVED = 1;
    public static final int SERVER_STATE_CHANGED = 2;
    private final File baseDir = Activator.getDefault().getStateLocation().toFile();
    private final File saveDir = new File(this.baseDir, "locations");
    private Map<String, HadoopServer> servers;
    private Set<IHadoopServerListener> listeners = new HashSet();

    private ServerRegistry() {
        if (this.saveDir.exists() && !this.saveDir.isDirectory()) {
            this.saveDir.delete();
        }
        if (!this.saveDir.exists()) {
            this.saveDir.mkdirs();
        }
        this.load();
    }

    public static ServerRegistry getInstance() {
        return INSTANCE;
    }

    public synchronized Collection<HadoopServer> getServers() {
        return Collections.unmodifiableCollection(this.servers.values());
    }

    private synchronized void load() {
        TreeMap<String, HadoopServer> map = new TreeMap<String, HadoopServer>();
        for (File file : this.saveDir.listFiles()) {
            try {
                HadoopServer server = new HadoopServer(file);
                map.put(server.getLocationName(), server);
            }
            catch (Exception exn) {
                System.err.println(exn);
            }
        }
        this.servers = map;
    }

    private synchronized void store() {
        try {
            File dir = File.createTempFile("locations", "new", this.baseDir);
            dir.delete();
            dir.mkdirs();
            for (HadoopServer server : this.servers.values()) {
                server.storeSettingsToFile(new File(dir, server.getLocationName() + ".xml"));
            }
            1 XMLFilter = new /* Unavailable Anonymous Inner Class!! */;
            File backup = new File(this.baseDir, "locations.backup");
            if (backup.exists()) {
                for (File file : backup.listFiles((FilenameFilter)XMLFilter)) {
                    if (file.delete()) continue;
                    throw new IOException("Unable to delete backup location file: " + file);
                }
                if (!backup.delete()) {
                    throw new IOException("Unable to delete backup location directory: " + backup);
                }
            }
            this.saveDir.renameTo(backup);
            dir.renameTo(this.saveDir);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            MessageDialog.openError(null, (String)"Saving configuration of Hadoop locations failed", (String)ioe.toString());
        }
    }

    public void dispose() {
        for (HadoopServer server : this.getServers()) {
            server.dispose();
        }
    }

    public synchronized HadoopServer getServer(String location) {
        return (HadoopServer)this.servers.get(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IHadoopServerListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IHadoopServerListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners(HadoopServer location, int kind) {
        Set set = this.listeners;
        synchronized (set) {
            for (IHadoopServerListener listener : this.listeners) {
                listener.serverChanged(location, kind);
            }
        }
    }

    public synchronized void removeServer(HadoopServer server) {
        this.servers.remove(server.getLocationName());
        this.store();
        this.fireListeners(server, 1);
    }

    public synchronized void addServer(HadoopServer server) {
        this.servers.put(server.getLocationName(), server);
        this.store();
        this.fireListeners(server, 0);
    }

    public synchronized void updateServer(String originalName, HadoopServer server) {
        if (!server.getLocationName().equals(originalName)) {
            this.servers.remove(originalName);
            this.servers.put(server.getLocationName(), server);
        }
        this.store();
        this.fireListeners(server, 2);
    }
}

