/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.view.servers;

import java.util.Collection;
import org.apache.hadoop.eclipse.ImageLibrary;
import org.apache.hadoop.eclipse.actions.EditLocationAction;
import org.apache.hadoop.eclipse.actions.NewLocationAction;
import org.apache.hadoop.eclipse.server.HadoopJob;
import org.apache.hadoop.eclipse.server.HadoopServer;
import org.apache.hadoop.eclipse.server.IJobListener;
import org.apache.hadoop.eclipse.server.JarModule;
import org.apache.hadoop.eclipse.servers.IHadoopServerListener;
import org.apache.hadoop.eclipse.servers.ServerRegistry;
import org.apache.hadoop.eclipse.view.servers.ServerView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class ServerView
extends ViewPart
implements ITreeContentProvider,
ITableLabelProvider,
IJobListener,
IHadoopServerListener {
    private static final Object CONTENT_ROOT = new Object();
    private final IAction deleteAction = new DeleteAction(this);
    private final IAction editServerAction = new EditLocationAction(this);
    private final IAction newLocationAction = new NewLocationAction();
    private TreeViewer viewer;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void dispose() {
        ServerRegistry.getInstance().removeListener((IHadoopServerListener)this);
    }

    public void createPartControl(Composite parent) {
        Tree main = new Tree(parent, 66308);
        main.setHeaderVisible(true);
        main.setLinesVisible(false);
        main.setLayoutData((Object)new GridData(1808));
        TreeColumn serverCol = new TreeColumn(main, 4);
        serverCol.setText("Location");
        serverCol.setWidth(300);
        serverCol.setResizable(true);
        TreeColumn locationCol = new TreeColumn(main, 4);
        locationCol.setText("Master node");
        locationCol.setWidth(185);
        locationCol.setResizable(true);
        TreeColumn stateCol = new TreeColumn(main, 4);
        stateCol.setText("State");
        stateCol.setWidth(95);
        stateCol.setResizable(true);
        TreeColumn statusCol = new TreeColumn(main, 4);
        statusCol.setText("Status");
        statusCol.setWidth(300);
        statusCol.setResizable(true);
        this.viewer = new TreeViewer(main);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)this);
        this.viewer.setInput(CONTENT_ROOT);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteAction);
        this.getViewSite().getActionBars().getToolBarManager().add(this.editServerAction);
        this.getViewSite().getActionBars().getToolBarManager().add(this.newLocationAction);
        this.createActions();
        this.createContextMenu();
    }

    private void createActions() {
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addItem() {
        System.out.printf("ADD ITEM\n", new Object[0]);
    }

    private void updateActionEnablement() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add(this.newLocationAction);
        mgr.add(this.editServerAction);
        mgr.add(this.deleteAction);
    }

    public void setFocus() {
    }

    public void serverChanged(HadoopServer location, int type) {
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput == CONTENT_ROOT) {
            ServerRegistry.getInstance().removeListener((IHadoopServerListener)this);
        }
        if (newInput == CONTENT_ROOT) {
            ServerRegistry.getInstance().addListener((IHadoopServerListener)this);
        }
    }

    public Object[] getElements(Object inputElement) {
        return ServerRegistry.getInstance().getServers().toArray();
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof HadoopServer) {
            HadoopServer location = (HadoopServer)parent;
            location.addJobListener((IJobListener)this);
            Collection jobs = location.getJobs();
            return jobs.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof HadoopServer) {
            return CONTENT_ROOT;
        }
        if (element instanceof HadoopJob) {
            return ((HadoopJob)element).getLocation();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof HadoopServer;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof HadoopServer) {
            return ImageLibrary.getImage((String)"server.view.location.entry");
        }
        if (columnIndex == 0 && element instanceof HadoopJob) {
            return ImageLibrary.getImage((String)"server.view.job.entry");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof HadoopServer) {
            HadoopServer server = (HadoopServer)element;
            switch (columnIndex) {
                case 0: {
                    return server.getLocationName();
                }
                case 1: {
                    return server.getMasterHostName().toString();
                }
                case 2: {
                    return server.getState();
                }
                case 3: {
                    return "";
                }
            }
        } else if (element instanceof HadoopJob) {
            HadoopJob job = (HadoopJob)element;
            switch (columnIndex) {
                case 0: {
                    return job.getJobID().toString();
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return job.getState().toString();
                }
                case 3: {
                    return job.getStatus();
                }
            }
        } else if (element instanceof JarModule) {
            JarModule jar = (JarModule)element;
            switch (columnIndex) {
                case 0: {
                    return jar.toString();
                }
                case 1: {
                    return "Publishing jar to server..";
                }
                case 2: {
                    return "";
                }
            }
        }
        return null;
    }

    public void jobAdded(HadoopJob job) {
        this.viewer.refresh();
    }

    public void jobRemoved(HadoopJob job) {
        this.viewer.refresh();
    }

    public void jobChanged(HadoopJob job) {
        this.viewer.refresh((Object)job);
    }

    public void publishDone(JarModule jar) {
        this.viewer.refresh();
    }

    public void publishStart(JarModule jar) {
        this.viewer.refresh();
    }

    public HadoopServer getSelectedServer() {
        ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
        Object first = selection.getFirstElement();
        if (first instanceof HadoopServer) {
            return (HadoopServer)first;
        }
        return null;
    }

    static /* synthetic */ void access$000(ServerView x0) {
        x0.updateActionEnablement();
    }

    static /* synthetic */ void access$100(ServerView x0, IMenuManager x1) {
        x0.fillContextMenu(x1);
    }

    static /* synthetic */ TreeViewer access$200(ServerView x0) {
        return x0.viewer;
    }
}

