#include "infcache.h"

InfoCache::InfoCache()
{
	nowno = 0;
	for (int i=0; i<INFOCACHE_MAX; i++) {
		arcinfo[i].hinfo = NULL;
	}
}

InfoCache::~InfoCache()
{
	for (int i=0; i<INFOCACHE_MAX; i++) {
		if (arcinfo[i].hinfo) LocalFree(arcinfo[i].hinfo);
	}
}

void InfoCache::Clear(void)
{
	cs.Enter();
	for (int i=0; i<INFOCACHE_MAX; i++) {
		if (arcinfo[i].hinfo) {
			LocalFree(arcinfo[i].hinfo);
			arcinfo[i].hinfo = NULL;
		}
	}
	nowno = 0;
	cs.Leave();
}

//LbVǉ
//filepath:t@CpX
//ph:nhւ̃|C^
//INFOCACHE_MAXÂ̂͏
void InfoCache::Add(char *filepath, HLOCAL *ph)
{
	cs.Enter();
	if (arcinfo[nowno].hinfo) LocalFree(arcinfo[nowno].hinfo);
	arcinfo[nowno].hinfo = *ph;
	lstrcpy(arcinfo[nowno].path, filepath);
	nowno = (nowno+1)%INFOCACHE_MAX;
	cs.Leave();
}

//LbVɂ΃nhԂ
bool InfoCache::GetCache(char *filepath, HLOCAL *ph)
{
	bool ret = false;
	int no = nowno-1;
	if (no < 0) no = INFOCACHE_MAX -1;
	for (int i=0; i<INFOCACHE_MAX; i++) {
		if (arcinfo[no].hinfo == NULL) break;
		if (lstrcmpi(arcinfo[no].path, filepath) == 0) {
			*ph = arcinfo[no].hinfo;
			ret = true;
			break;
		}
		no--;
		if (no < 0) no = INFOCACHE_MAX -1;
	}
	return ret;
}

//LbVɂ΃Rs[
//ph:A[JCu󂯎nhւ̃|C^
//pinfo:A[JCũt@C󂯎|C^
//      炩 pinfo  filename  position ZbgĂB
//      LbV filename(position) ̈vԂB
//LbVɂȂ΁ASPI_NO_FUNCTION ԂB
//LbVɂ SPI_ALL_RIGHT ԂB
//A[JCu̓LbVɂ邪Afilename(position) vȂꍇ
//SPI_NOT_SUPPORT ԂBG[̏ꍇ̓G[R[hԂB
int InfoCache::Dupli(char *filepath, HLOCAL *ph, fileInfo *pinfo)
{
	cs.Enter();
	HLOCAL hinfo;
	int ret = GetCache(filepath, &hinfo);

if (ret) {
	ret = SPI_ALL_RIGHT;
	if (ph != NULL) {
		UINT size = LocalSize(hinfo);
		/* o͗p̃̊蓖 */
		*ph = LocalAlloc(LMEM_FIXED, size);
		if (*ph == NULL) {
			ret = SPI_NO_MEMORY;
		} else {
			memcpy(*ph, (void*)hinfo, size);
		}
	} else {
		fileInfo *ptmp = (fileInfo *)hinfo;
		if (pinfo->filename[0] != '\0') {
			for (;;) {
				if (ptmp->method[0] == '\0') {
					ret = SPI_NOT_SUPPORT;
					break;
				}
				if (lstrcmpi(ptmp->filename, pinfo->filename) == 0) break;
				ptmp++;
			}
		} else {
			for (;;) {
				if (ptmp->method[0] == '\0') {
					ret = SPI_NOT_SUPPORT;
					break;
				}
				if (ptmp->position == pinfo->position) break;
				ptmp++;
			}
		}
		if (ret == SPI_ALL_RIGHT) *pinfo = *ptmp;
	}
} else {
	ret = SPI_NO_FUNCTION;
}

	cs.Leave();
	return ret;
}

//////////////////////////////////////////
// Ch
//////////////////////////////////////////
InfoCacheW::InfoCacheW()
{
	nowno = 0;
	for (int i=0; i<INFOCACHE_MAX; i++) {
		arcinfo[i].hinfo = NULL;
	}
}

InfoCacheW::~InfoCacheW()
{
	for (int i=0; i<INFOCACHE_MAX; i++) {
		if (arcinfo[i].hinfo) LocalFree(arcinfo[i].hinfo);
	}
}

void InfoCacheW::Clear(void)
{
	cs.Enter();
	for (int i=0; i<INFOCACHE_MAX; i++) {
		if (arcinfo[i].hinfo) {
			LocalFree(arcinfo[i].hinfo);
			arcinfo[i].hinfo = NULL;
		}
	}
	nowno = 0;
	cs.Leave();
}

//LbVǉ
//filepath:t@CpX
//ph:nhւ̃|C^
//INFOCACHE_MAXÂ̂͏
void InfoCacheW::Add(wchar_t *filepath, HLOCAL *ph)
{
	cs.Enter();
	if (arcinfo[nowno].hinfo) LocalFree(arcinfo[nowno].hinfo);
	arcinfo[nowno].hinfo = *ph;
	wcscpy(arcinfo[nowno].path, filepath);
	nowno = (nowno+1)%INFOCACHE_MAX;
	cs.Leave();
}

//LbVɂ΃nhԂ
bool InfoCacheW::GetCache(wchar_t *filepath, HLOCAL *ph)
{
	bool ret = false;
	int no = nowno-1;
	if (no < 0) no = INFOCACHE_MAX -1;
	for (int i=0; i<INFOCACHE_MAX; i++) {
		if (arcinfo[no].hinfo == NULL) break;
		if (wcsicmp(arcinfo[no].path, filepath) == 0) {
			*ph = arcinfo[no].hinfo;
			ret = true;
			break;
		}
		no--;
		if (no < 0) no = INFOCACHE_MAX -1;
	}
	return ret;
}

//LbVɂ΃Rs[
//ph:A[JCu󂯎nhւ̃|C^
//pinfo:A[JCũt@C󂯎|C^
//      炩 pinfo  filename  position ZbgĂB
//      LbV filename(position) ̈vԂB
//LbVɂȂ΁ASPI_NO_FUNCTION ԂB
//LbVɂ SPI_ALL_RIGHT ԂB
//A[JCu̓LbVɂ邪Afilename(position) vȂꍇ
//SPI_NOT_SUPPORT ԂBG[̏ꍇ̓G[R[hԂB
int InfoCacheW::Dupli(wchar_t *filepath, HLOCAL *ph, fileInfoW *pinfo)
{
	cs.Enter();
	HLOCAL hinfo;
	int ret = GetCache(filepath, &hinfo);

    if (ret) {
        ret = SPI_ALL_RIGHT;
        if (ph != NULL) {
            UINT size = LocalSize(hinfo);
            /* o͗p̃̊蓖 */
            *ph = LocalAlloc(LMEM_FIXED, size);
            if (*ph == NULL) {
                ret = SPI_NO_MEMORY;
            } else {
                memcpy(*ph, (void*)hinfo, size);
            }
        } else {
            fileInfoW *ptmp = (fileInfoW *)hinfo;
            if (pinfo->filename[0] != L'\0') {
                for (;;) {
                    if (ptmp->method[0] == '\0') {
                        ret = SPI_NOT_SUPPORT;
                        break;
                    }
                    if (wcsicmp(ptmp->filename, pinfo->filename) == 0) break;
                    ptmp++;
                }
            } else {
                for (;;) {
                    if (ptmp->method[0] == '\0') {
                        ret = SPI_NOT_SUPPORT;
                        break;
                    }
                    if (ptmp->position == pinfo->position) break;
                    ptmp++;
                }
            }
            if (ret == SPI_ALL_RIGHT) *pinfo = *ptmp;
        }
    } else {
        ret = SPI_NO_FUNCTION;
    }

	cs.Leave();
	return ret;
}
