#include "common.fxh"

const uniform float4x4 ModelViewProjMatrix;
const uniform float4 OneTexelDiff;
const uniform float2 TextureSize;
const bool DISABLE_HALF_PIXEL_OFFSET = true;

texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

// bi-cubic filter
// ref) http://www.t-pot.com/
void VertexProgram(
  in float4 position : POSITION,
  in float4 color : COLOR0,
  in float2 texCoord : TEXCOORD0,
  out float4 positionO : POSITION,
  out float4 colorO : COLOR0,
  out TexCoord2D_42 texCoordO)
{
    positionO = mul(ModelViewProjMatrix, position);
    colorO = color;
    float4 diff0 = OneTexelDiff / 2;
    float4 diff1 = OneTexelDiff * 1.5;
    texCoordO.cod00 = texCoord + float2(-diff1.x, -diff1.y);
    texCoordO.cod01 = texCoord + float2(-diff0.x, -diff1.y);
    texCoordO.cod10 = texCoord + float2(-diff1.x, -diff0.y);
    texCoordO.cod11 = texCoord + float2(-diff0.x, -diff0.y);
    texCoordO.cod20 = texCoord + float2(-diff1.x,  diff0.y);
    texCoordO.cod21 = texCoord + float2(-diff0.x,  diff0.y);
    texCoordO.cod30 = texCoord + float2(-diff1.x,  diff1.y);
    texCoordO.cod31 = texCoord + float2(-diff0.x,  diff1.y);
}

void FragmentProgram(
  in float4 color : COLOR0,
  in TexCoord2D_42 texCoord,
  out float4 colorO : COLOR0)
{
#if 0
    // Catmull-Rom patch
    const float4 w3 = float4(-0.5, 1.5,-1.5, 0.5);
    const float4 w2 = float4( 1.0,-2.5, 2.0,-0.5);
    const float4 w1 = float4(-0.5, 0.0, 0.5, 0.0);
    const float4 w0 = float4( 0.0, 1.0, 0.0, 0.0);
#else
    const float4 w3 = float4(-1, 1,-1, 1);
    const float4 w2 = float4( 2,-2, 1,-1);
    const float4 w1 = float4(-1, 0, 1, 0);
    const float4 w0 = float4( 0, 1, 0, 0);
#endif

    float2 fUV = frac (texCoord.cod11 * TextureSize);
    float2 fUV2 = fUV * fUV;
    float2 fUV3 = fUV * fUV2;
    float4 u = fUV3.x * w3 + fUV2.x * w2 + fUV.x * w1 + w0;
    float4 v = fUV3.y * w3 + fUV2.y * w2 + fUV.y * w1 + w0;

    float4 col00 = tex2D(PictureSampler, texCoord.cod00);
    float4 col01 = tex2D(PictureSampler, texCoord.cod01);
    float4 col10 = tex2D(PictureSampler, texCoord.cod10);
    float4 col11 = tex2D(PictureSampler, texCoord.cod11);
    float4 col20 = tex2D(PictureSampler, texCoord.cod20);
    float4 col21 = tex2D(PictureSampler, texCoord.cod21);
    float4 col30 = tex2D(PictureSampler, texCoord.cod30);
    float4 col31 = tex2D(PictureSampler, texCoord.cod31);
    
    float2 d = float2(2 * OneTexelDiff.x, 0);
    float4 col02 = tex2D(PictureSampler, texCoord.cod00 + d);
    float4 col03 = tex2D(PictureSampler, texCoord.cod01 + d);
    float4 col12 = tex2D(PictureSampler, texCoord.cod10 + d);
    float4 col13 = tex2D(PictureSampler, texCoord.cod11 + d);
    float4 col22 = tex2D(PictureSampler, texCoord.cod20 + d);
    float4 col23 = tex2D(PictureSampler, texCoord.cod21 + d);
    float4 col32 = tex2D(PictureSampler, texCoord.cod30 + d);
    float4 col33 = tex2D(PictureSampler, texCoord.cod31 + d);

    float4 col0 = u.x * col00 + u.y * col01 + u.z * col02 + u.w * col03;
    float4 col1 = u.x * col10 + u.y * col11 + u.z * col12 + u.w * col13;
    float4 col2 = u.x * col20 + u.y * col21 + u.z * col22 + u.w * col23;
    float4 col3 = u.x * col30 + u.y * col31 + u.z * col32 + u.w * col33;
    
    colorO = v.x * col0 + v.y * col1 + v.z * col2 + v.w * col3;
    colorO.a *= color.a;
}

technique technique_hamana
{
   pass P0
   {        
      VertexShader = compile vs_2_0 VertexProgram();
      PixelShader  = compile ps_2_0 FragmentProgram();
   }
}
