#ifndef _H_HAMANA_COMMON
#define _H_HAMANA_COMMON

// common types
struct TexCoord2D_22
{
    float2 cod00 : TEXCOORD0;
    float2 cod01 : TEXCOORD1;
    float2 cod10 : TEXCOORD2;
    float2 cod11 : TEXCOORD3;
};
struct TexCoord2D_33
{
    float2 cod00 : TEXCOORD0;
    float2 cod01 : TEXCOORD1;
    float2 cod02 : TEXCOORD2;
    float2 cod10 : TEXCOORD3;
    float2 cod11 : TEXCOORD4;
    float2 cod12 : TEXCOORD5;
    float2 cod20 : TEXCOORD6;
    float2 cod21 : TEXCOORD7;
    float2 cod22 : TEXCOORD8;
};
struct TexCoord2D_42
{
    float2 cod00 : TEXCOORD0;
    float2 cod01 : TEXCOORD1;
    float2 cod10 : TEXCOORD2;
    float2 cod11 : TEXCOORD3;
    float2 cod20 : TEXCOORD4;
    float2 cod21 : TEXCOORD5;
    float2 cod30 : TEXCOORD6;
    float2 cod31 : TEXCOORD7;
};

// common constant
const float3x3 rgb2yuv = { float3(0.299, 0.587, 0.114),
                           float3(-0.147, -0.289, 0.436),
                           float3(0.615, -0.515, -0.1) };
const float3x3 yuv2rgb = { float3(1.0, 0.0, 1.140),
                           float3(1.0, -0.396, -0.581),
                           float3(1.0, 2.029, 0.0) };
const float PI = 3.14159265358979323846f;

// common functions
/** get Y */
float getY(float4 c)
{
    return(dot(c.rgb, float3(0.299, 0.587, 0.114)));
}

float4 getGray(float4 c)
{
    return(dot(c.rgb,((0.33333).xxx)));
}
float4 getGray2(float4 c)
{
    return(dot(c.rgb,((0.66666).xxx)));
}

/** swap a and b */
void swap(inout float2 a, inout float2 b) {
    float2 tmp;
    tmp = a;
    a = b;
    b = tmp;
}

#endif // _H_HAMANA_COMMON
