#include "common.fxh"

const uniform float4x4 ModelViewProjMatrix;
const uniform float4 OneTexelDiff;

texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
};

// edge
void VertexProgram(
  in float4 position : POSITION,
  in float4 color : COLOR0,
  in float2 texCoord : TEXCOORD0,
  out float4 positionO : POSITION,
  out float4 colorO : COLOR0,
  out float2 texCoordO00 : TEXCOORD0,
  out float2 texCoordO01 : TEXCOORD1,
  out float2 texCoordO02 : TEXCOORD2,
  out float2 texCoordO10 : TEXCOORD3,
  out float2 texCoordO12 : TEXCOORD4,
  out float2 texCoordO20 : TEXCOORD5,
  out float2 texCoordO21 : TEXCOORD6,
  out float2 texCoordO22 : TEXCOORD7)
{
  float4 texelDiff = OneTexelDiff * 1;
  positionO = mul(ModelViewProjMatrix, position);
  colorO = color;
  texCoordO00 = texCoord - texelDiff.xy;
  texCoordO01 = texCoord - float2(0, texelDiff.y);
  texCoordO02 = texCoord + texelDiff.zw;
  texCoordO10 = texCoord - float2(texelDiff.x, 0);
  texCoordO12 = texCoord + float2(texelDiff.x, 0);
  texCoordO20 = texCoord - texelDiff.zw;
  texCoordO21 = texCoord + float2(0, texelDiff.y);
  texCoordO22 = texCoord + texelDiff.xy;
}

void FragmentProgram(
  in float4 color : COLOR0,
  in float2 texCoord0 : TEXCOORD0,
  in float2 texCoord1 : TEXCOORD1,
  in float2 texCoord2 : TEXCOORD2,
  in float2 texCoord3 : TEXCOORD3,
  in float2 texCoord4 : TEXCOORD4,
  in float2 texCoord5 : TEXCOORD5,
  in float2 texCoord6 : TEXCOORD6,
  in float2 texCoord7 : TEXCOORD7,
  out float4 colorO : COLOR0)
{
	float4 CC;
	CC = tex2D(PictureSampler,texCoord0); float4 g00 = getGray(CC);
	CC = tex2D(PictureSampler,texCoord1); float4 g01 = getGray2(CC);
	CC = tex2D(PictureSampler,texCoord2); float4 g02 = getGray(CC);
	CC = tex2D(PictureSampler,texCoord3); float4 g10 = getGray2(CC);
	CC = tex2D(PictureSampler,texCoord4); float4 g12 = getGray2(CC);
	CC = tex2D(PictureSampler,texCoord5); float4 g20 = getGray(CC);
	CC = tex2D(PictureSampler,texCoord6); float4 g21 = getGray2(CC);
	CC = tex2D(PictureSampler,texCoord7); float4 g22 = getGray(CC);
	float4 sx = 0;
	sx -= g00;
	sx -= g01;
	sx -= g02;
	sx += g20;
	sx += g21;
	sx += g22;
	float4 sy = 0;
	sy -= g00;
	sy += g02;
	sy -= g10;
	sy += g12;
	sy -= g20;
	sy += g22;
	float4 dist = (sx*sx+sy*sy);
	float4 result = 1;
	const float T = 0.2;
	if (dist.x > T * T) {
	  result = float4(0, 0, 0, 1);
	}
	colorO = result;
	colorO.a = color.a;
}

technique technique_hamana
{
   pass P0
   {        
      VertexShader = compile vs_2_0 VertexProgram();
      PixelShader  = compile ps_2_0 FragmentProgram();
   }
}
