#include "common.fxh"

const uniform float4x4 ModelViewProjMatrix;
const uniform float4 OneTexelDiff;

texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
};

// for edge + color
void VertexProgram(
  in float4 position : POSITION,
  in float4 color : COLOR0,
  in float2 texCoord : TEXCOORD0,
  out float4 positionO : POSITION,
  out float4 colorO : COLOR0,
  out TexCoord2D_33 texCoordO)
{
  float4 texelDiff = OneTexelDiff * 1;
  positionO = mul(ModelViewProjMatrix, position);
  colorO = color;
  texCoordO.cod00 = texCoord - texelDiff.xy;
  texCoordO.cod01 = texCoord - float2(0, texelDiff.y);
  texCoordO.cod02 = texCoord + texelDiff.zw;
  texCoordO.cod10 = texCoord - float2(texelDiff.x, 0);
  texCoordO.cod11 = texCoord;
  texCoordO.cod12 = texCoord + float2(texelDiff.x, 0);
  texCoordO.cod20 = texCoord - texelDiff.zw;
  texCoordO.cod21 = texCoord + float2(0, texelDiff.y);
  texCoordO.cod22 = texCoord + texelDiff.xy;
}

void FragmentProgram(
  in float4 color : COLOR0,
  in TexCoord2D_33 texCoord,
  out float4 colorO : COLOR0)
{
	float4 cc00 = tex2D(PictureSampler,texCoord.cod00);
	float4 cc01 = tex2D(PictureSampler,texCoord.cod01);
	float4 cc02 = tex2D(PictureSampler,texCoord.cod02);
	float4 cc10 = tex2D(PictureSampler,texCoord.cod10);
	float4 cc11 = tex2D(PictureSampler,texCoord.cod11);
	float4 cc12 = tex2D(PictureSampler,texCoord.cod12);
	float4 cc20 = tex2D(PictureSampler,texCoord.cod20);
	float4 cc21 = tex2D(PictureSampler,texCoord.cod21);
	float4 cc22 = tex2D(PictureSampler,texCoord.cod22);
	float4 sx = 0;
	sx -= cc00;
	sx -= cc01 * 2;
	sx -= cc02;
	sx += cc20;
	sx += cc21 * 2;
	sx += cc22;
	float4 sy = 0;
	sy -= cc00;
	sy += cc02;
	sy -= cc10 * 2;
	sy += cc12 * 2;
	sy -= cc20;
	sy += cc22;
	float4 dist = (sx*sx+sy*sy);
	float4 result = 1;
	const float T = 0.4;
    const float T2 = T * T;
	float f = dist.x <= T2;
	f *= dist.y <= T2;
	f *= dist.z <= T2;
	colorO = cc11 * ((f + 1) / 2);
	colorO.a = cc11.a * color.a;
}

technique technique_hamana
{
   pass P0
   {        
      VertexShader = compile vs_3_0 VertexProgram();
      PixelShader  = compile ps_3_0 FragmentProgram();
   }
}
