#include "common.fxh"

const uniform float4x4 ModelViewProjMatrix;
const uniform float4 OneTexelDiff;
const bool DISABLE_HALF_PIXEL_OFFSET = true;

texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

float Lanczos2(float d)
{
    const float ZERO_TOL = 1.0e-6;
    float result = 1.0f;
    
    if (d > ZERO_TOL) {
        float pd = PI * d;
        float pd2 = pd / 2;
        result = sin(pd) * sin(pd2) / (pd * pd2);
    }
    return result;
}

// lanczos2 filter
void VertexProgram(
  in float4 position : POSITION,
  in float4 color : COLOR0,
  in float2 texCoord : TEXCOORD0,
  out float4 positionO : POSITION,
  out float4 colorO : COLOR0,
  out TexCoord2D_42 texCoordO)
{
    positionO = mul(ModelViewProjMatrix, position);
    colorO = color;
    float4 diff0 = OneTexelDiff / 2;
    float4 diff1 = OneTexelDiff + diff0;
    texCoordO.cod00 = texCoord + float2(-diff1.x, -diff1.y);
    texCoordO.cod01 = texCoord + float2(-diff0.x, -diff1.y);
    texCoordO.cod10 = texCoord + float2(-diff1.x, -diff0.y);
    texCoordO.cod11 = texCoord + float2(-diff0.x, -diff0.y);
    texCoordO.cod20 = texCoord + float2(-diff1.x,  diff0.y);
    texCoordO.cod21 = texCoord + float2(-diff0.x,  diff0.y);
    texCoordO.cod30 = texCoord + float2(-diff1.x,  diff1.y);
    texCoordO.cod31 = texCoord + float2(-diff0.x,  diff1.y);
}

void FragmentProgram(
  in float4 color : COLOR0,
  in TexCoord2D_42 texCoord,
  out float4 colorO : COLOR0)
{
    float2 fUV = frac (texCoord.cod11 / OneTexelDiff);
    float4 u, v;
    u.x = Lanczos2(1 + fUV.x);
    u.y = Lanczos2(fUV.x);
    u.z = Lanczos2(1 - fUV.x);
    u.w = Lanczos2(2 - fUV.x);
    v.x = Lanczos2(1 + fUV.y);
    v.y = Lanczos2(fUV.y);
    v.z = Lanczos2(1 - fUV.y);
    v.w = Lanczos2(2 - fUV.y);

    float4 col00 = tex2D(PictureSampler, texCoord.cod00);
    float4 col01 = tex2D(PictureSampler, texCoord.cod01);
    float4 col10 = tex2D(PictureSampler, texCoord.cod10);
    float4 col11 = tex2D(PictureSampler, texCoord.cod11);
    float4 col20 = tex2D(PictureSampler, texCoord.cod20);
    float4 col21 = tex2D(PictureSampler, texCoord.cod21);
    float4 col30 = tex2D(PictureSampler, texCoord.cod30);
    float4 col31 = tex2D(PictureSampler, texCoord.cod31);
    
    float2 d = float2(OneTexelDiff.x * 2, 0);
    float4 col02 = tex2D(PictureSampler, texCoord.cod00 + d);
    float4 col03 = tex2D(PictureSampler, texCoord.cod01 + d);
    float4 col12 = tex2D(PictureSampler, texCoord.cod10 + d);
    float4 col13 = tex2D(PictureSampler, texCoord.cod11 + d);
    float4 col22 = tex2D(PictureSampler, texCoord.cod20 + d);
    float4 col23 = tex2D(PictureSampler, texCoord.cod21 + d);
    float4 col32 = tex2D(PictureSampler, texCoord.cod30 + d);
    float4 col33 = tex2D(PictureSampler, texCoord.cod31 + d);

    float4 col0 = u.x * col00 + u.y * col01 + u.z * col02 + u.w * col03;
    float4 col1 = u.x * col10 + u.y * col11 + u.z * col12 + u.w * col13;
    float4 col2 = u.x * col20 + u.y * col21 + u.z * col22 + u.w * col23;
    float4 col3 = u.x * col30 + u.y * col31 + u.z * col32 + u.w * col33;
    
    colorO = v.x * col0 + v.y * col1 + v.z * col2 + v.w * col3;
    colorO.a *= color.a;
}

technique technique_hamana
{
   pass P0
   {        
      VertexShader = compile vs_3_0 VertexProgram();
      PixelShader  = compile ps_3_0 FragmentProgram();
   }
}
