#include "common.fxh"

const uniform float4x4 ModelViewProjMatrix;
const uniform float4 OneTexelDiff;
const bool DISABLE_HALF_PIXEL_OFFSET = true;

texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

float Lanczos3(float d)
{
    const float ZERO_TOL = 1.0e-6;
    float result = 1.0f;
    
    if (d > ZERO_TOL) {
        float pd = PI * d;
        float pd3 = pd / 3;
        result = sin(pd) * sin(pd3) / (pd * pd3);
    }
    return result;
}

// lanczos3 filter
void VertexProgram(
  in float4 position : POSITION,
  in float4 color : COLOR0,
  in float2 texCoord : TEXCOORD0,
  out float4 positionO : POSITION,
  out float4 colorO : COLOR0,
  out TexCoord2D_33 texCoordO)
{
    positionO = mul(ModelViewProjMatrix, position);
    colorO = color;
    float4 diff0 = OneTexelDiff / -2;
    float4 diff1 = diff0 - OneTexelDiff;
    float4 diff2 = diff1 - OneTexelDiff;
    texCoordO.cod00 = texCoord + float2(diff2.x, diff2.y);
    texCoordO.cod01 = texCoord + float2(diff1.x, diff2.y);
    texCoordO.cod02 = texCoord + float2(diff0.x, diff2.y);
    texCoordO.cod10 = texCoord + float2(diff2.x, diff1.y);
    texCoordO.cod11 = texCoord + float2(diff1.x, diff1.y);
    texCoordO.cod12 = texCoord + float2(diff0.x, diff1.y);
    texCoordO.cod20 = texCoord + float2(diff2.x, diff0.y);
    texCoordO.cod21 = texCoord + float2(diff1.x, diff0.y);
    texCoordO.cod22 = texCoord + float2(diff0.x, diff0.y);
}

void FragmentProgram(
  in float4 color : COLOR0,
  in TexCoord2D_33 texCoord,
  out float4 colorO : COLOR0)
{
    float2 fUV = frac (texCoord.cod22 / OneTexelDiff);
    float u[6], v[6];
    u[0] = Lanczos3(2 + fUV.x);
    u[1] = Lanczos3(1 + fUV.x);
    u[2] = Lanczos3(0 + fUV.x);
    u[3] = Lanczos3(1 - fUV.x);
    u[4] = Lanczos3(2 - fUV.x);
    u[5] = Lanczos3(3 - fUV.x);
    v[0] = Lanczos3(2 + fUV.y);
    v[1] = Lanczos3(1 + fUV.y);
    v[2] = Lanczos3(0 + fUV.y);
    v[3] = Lanczos3(1 - fUV.y);
    v[4] = Lanczos3(2 - fUV.y);
    v[5] = Lanczos3(3 - fUV.y);

    float4 col00 = tex2D(PictureSampler, texCoord.cod00);
    float4 col01 = tex2D(PictureSampler, texCoord.cod01);
    float4 col02 = tex2D(PictureSampler, texCoord.cod02);
    float4 col10 = tex2D(PictureSampler, texCoord.cod10);
    float4 col11 = tex2D(PictureSampler, texCoord.cod11);
    float4 col12 = tex2D(PictureSampler, texCoord.cod12);
    float4 col20 = tex2D(PictureSampler, texCoord.cod20);
    float4 col21 = tex2D(PictureSampler, texCoord.cod21);
    float4 col22 = tex2D(PictureSampler, texCoord.cod22);
    
    float2 d = float2(OneTexelDiff.x * 3, 0);
    float4 col03 = tex2D(PictureSampler, texCoord.cod00 + d);
    float4 col04 = tex2D(PictureSampler, texCoord.cod01 + d);
    float4 col05 = tex2D(PictureSampler, texCoord.cod02 + d);
    float4 col13 = tex2D(PictureSampler, texCoord.cod10 + d);
    float4 col14 = tex2D(PictureSampler, texCoord.cod11 + d);
    float4 col15 = tex2D(PictureSampler, texCoord.cod12 + d);
    float4 col23 = tex2D(PictureSampler, texCoord.cod20 + d);
    float4 col24 = tex2D(PictureSampler, texCoord.cod21 + d);
    float4 col25 = tex2D(PictureSampler, texCoord.cod22 + d);
    
    d.y = OneTexelDiff.y * 3;
    float4 col33 = tex2D(PictureSampler, texCoord.cod00 + d);
    float4 col34 = tex2D(PictureSampler, texCoord.cod01 + d);
    float4 col35 = tex2D(PictureSampler, texCoord.cod02 + d);
    float4 col43 = tex2D(PictureSampler, texCoord.cod10 + d);
    float4 col44 = tex2D(PictureSampler, texCoord.cod11 + d);
    float4 col45 = tex2D(PictureSampler, texCoord.cod12 + d);
    float4 col53 = tex2D(PictureSampler, texCoord.cod20 + d);
    float4 col54 = tex2D(PictureSampler, texCoord.cod21 + d);
    float4 col55 = tex2D(PictureSampler, texCoord.cod22 + d);

    d.x = 0;
    float4 col30 = tex2D(PictureSampler, texCoord.cod00 + d);
    float4 col31 = tex2D(PictureSampler, texCoord.cod01 + d);
    float4 col32 = tex2D(PictureSampler, texCoord.cod02 + d);
    float4 col40 = tex2D(PictureSampler, texCoord.cod10 + d);
    float4 col41 = tex2D(PictureSampler, texCoord.cod11 + d);
    float4 col42 = tex2D(PictureSampler, texCoord.cod12 + d);
    float4 col50 = tex2D(PictureSampler, texCoord.cod20 + d);
    float4 col51 = tex2D(PictureSampler, texCoord.cod21 + d);
    float4 col52 = tex2D(PictureSampler, texCoord.cod22 + d);

    float4 col0 = u[0] * col00 + u[1] * col01 + u[2] * col02 + u[3] * col03 + u[4] * col04 + u[5] * col05;
    float4 col1 = u[0] * col10 + u[1] * col11 + u[2] * col12 + u[3] * col13 + u[4] * col14 + u[5] * col15;
    float4 col2 = u[0] * col20 + u[1] * col21 + u[2] * col22 + u[3] * col23 + u[4] * col24 + u[5] * col25;
    float4 col3 = u[0] * col30 + u[1] * col31 + u[2] * col32 + u[3] * col33 + u[4] * col34 + u[5] * col35;
    float4 col4 = u[0] * col40 + u[1] * col41 + u[2] * col42 + u[3] * col43 + u[4] * col44 + u[5] * col45;
    float4 col5 = u[0] * col50 + u[1] * col51 + u[2] * col52 + u[3] * col53 + u[4] * col54 + u[5] * col55;
    
    colorO = v[0] * col0 + v[1] * col1 + v[2] * col2 + v[3] * col3 + v[4] * col4 + v[5] * col5;
    colorO.a *= color.a;
}

technique technique_hamana
{
   pass P0
   {        
      VertexShader = compile vs_3_0 VertexProgram();
      PixelShader  = compile ps_3_0 FragmentProgram();
   }
}
