#include "common.fxh"

const uniform float4x4 ModelViewProjMatrix;
const uniform float4 OneTexelDiff;

texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

// median filter
void VertexProgram(
  in float4 position : POSITION,
  in float4 color : COLOR0,
  in float2 texCoord : TEXCOORD0,
  out float4 positionO : POSITION,
  out float4 colorO : COLOR0,
  out float2 texCoordO11 : TEXCOORD0,
  out float2 texCoordO01 : TEXCOORD1,
  out float2 texCoordO10 : TEXCOORD2,
  out float2 texCoordO12 : TEXCOORD3,
  out float2 texCoordO21 : TEXCOORD4)
{
  float4 texelDiff = OneTexelDiff * 1;
  positionO = mul(ModelViewProjMatrix, position);
  colorO = color;
  texCoordO11 = texCoord;
  texCoordO01 = texCoord - float2(0, texelDiff.y);
  texCoordO10 = texCoord - float2(texelDiff.x, 0);
  texCoordO12 = texCoord + float2(texelDiff.x, 0);
  texCoordO21 = texCoord + float2(0, texelDiff.y);
}

#define POPUP_MIN(a, b) if (a.x > b.x) swap(a, b);

void FragmentProgram(
  in float4 color : COLOR0,
  in float2 texCoord11 : TEXCOORD0,
  in float2 texCoord01 : TEXCOORD1,
  in float2 texCoord10 : TEXCOORD2,
  in float2 texCoord12 : TEXCOORD3,
  in float2 texCoord21 : TEXCOORD4,
  out float4 colorO : COLOR0)
{
	float4 col11 = tex2D(PictureSampler,texCoord11); float2 y0 = float2(getY(col11), 0.0);
	float4 col01 = tex2D(PictureSampler,texCoord01); float2 y1 = float2(getY(col01), 1.0);
	float4 col10 = tex2D(PictureSampler,texCoord10); float2 y2 = float2(getY(col10), 2.0);
	float4 col12 = tex2D(PictureSampler,texCoord12); float2 y3 = float2(getY(col12), 3.0);
	float4 col21 = tex2D(PictureSampler,texCoord21); float2 y4 = float2(getY(col21), 4.0);

    // pass1
    POPUP_MIN(y3, y4);
    POPUP_MIN(y2, y3);
    POPUP_MIN(y1, y2);
    POPUP_MIN(y0, y1);
    // pass2
    POPUP_MIN(y3, y4);
    POPUP_MIN(y2, y3);
    POPUP_MIN(y1, y2);
    // pass3
    POPUP_MIN(y3, y4);
    POPUP_MIN(y2, y3);
    
    colorO = (y2.y > 3.5) ? col21 :
            ((y2.y > 2.5) ? col12 :
            ((y2.y > 1.5) ? col10 :
            ((y2.y > 0.5) ? col01 : col11)));
    colorO.a *= color.a;
}

technique technique_hamana
{
   pass P0
   {        
      VertexShader = compile vs_3_0 VertexProgram();
      PixelShader  = compile ps_3_0 FragmentProgram();
   }
}

