#include "common.fxh"

const uniform float4x4 ModelViewProjMatrix;
const uniform float4 OneTexelDiff;
const uniform float2 TextureSize;

texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

// median filter
void VertexProgram(
  in float4 position : POSITION,
  in float4 color : COLOR0,
  in float2 texCoord : TEXCOORD0,
  out float4 positionO : POSITION,
  out float4 colorO : COLOR0,
  out TexCoord2D_33 texCoordO)
{
  float4 texelDiff = OneTexelDiff * 1;
  positionO = mul(ModelViewProjMatrix, position);
  colorO = color;
  texCoordO.cod00 = texCoord - texelDiff.xy;
  texCoordO.cod01 = texCoord - float2(0, texelDiff.y);
  texCoordO.cod02 = texCoord + texelDiff.zw;
  texCoordO.cod10 = texCoord - float2(texelDiff.x, 0);
  texCoordO.cod11 = texCoord;
  texCoordO.cod12 = texCoord + float2(texelDiff.x, 0);
  texCoordO.cod20 = texCoord - texelDiff.zw;
  texCoordO.cod21 = texCoord + float2(0, texelDiff.y);
  texCoordO.cod22 = texCoord + texelDiff.xy;
}

#define POPUP_MIN(a, b) if (a.x > b.x) swap(a, b);

// median filter
void FragmentProgram(
  in float4 color : COLOR0,
  in TexCoord2D_33 texCoord,
  out float4 colorO : COLOR0)
{
	float4 col00 = tex2D(PictureSampler,texCoord.cod00); float2 y0 = float2(getY(col00), 0.0);
	float4 col01 = tex2D(PictureSampler,texCoord.cod01); float2 y1 = float2(getY(col01), 1.0);
	float4 col02 = tex2D(PictureSampler,texCoord.cod02); float2 y2 = float2(getY(col02), 2.0);
	float4 col10 = tex2D(PictureSampler,texCoord.cod10); float2 y3 = float2(getY(col10), 3.0);
	float4 col11 = tex2D(PictureSampler,texCoord.cod11); float2 y4 = float2(getY(col11), 4.0);
	float4 col12 = tex2D(PictureSampler,texCoord.cod12); float2 y5 = float2(getY(col12), 5.0);
	float4 col20 = tex2D(PictureSampler,texCoord.cod20); float2 y6 = float2(getY(col20), 6.0);
	float4 col21 = tex2D(PictureSampler,texCoord.cod21); float2 y7 = float2(getY(col21), 7.0);
	float4 col22 = tex2D(PictureSampler,texCoord.cod22); float2 y8 = float2(getY(col22), 8.0);
	
    // pass1
    POPUP_MIN(y7, y8);
    POPUP_MIN(y6, y7);
    POPUP_MIN(y5, y6);
    POPUP_MIN(y4, y5);
    POPUP_MIN(y3, y4);
    POPUP_MIN(y2, y3);
    POPUP_MIN(y1, y2);
    POPUP_MIN(y0, y1);
    // pass2
    POPUP_MIN(y7, y8);
    POPUP_MIN(y6, y7);
    POPUP_MIN(y5, y6);
    POPUP_MIN(y4, y5);
    POPUP_MIN(y3, y4);
    POPUP_MIN(y2, y3);
    POPUP_MIN(y1, y2);
    // pass3
    POPUP_MIN(y7, y8);
    POPUP_MIN(y6, y7);
    POPUP_MIN(y5, y6);
    POPUP_MIN(y4, y5);
    POPUP_MIN(y3, y4);
    POPUP_MIN(y2, y3);
    // pass4
    POPUP_MIN(y7, y8);
    POPUP_MIN(y6, y7);
    POPUP_MIN(y5, y6);
    POPUP_MIN(y4, y5);
    POPUP_MIN(y3, y4);
    // pass5
    POPUP_MIN(y7, y8);
    POPUP_MIN(y6, y7);
    POPUP_MIN(y5, y6);
    POPUP_MIN(y4, y5);
    
    colorO = (y2.y > 7.5) ? col22 :
            ((y2.y > 6.5) ? col21 :
            ((y2.y > 5.5) ? col20 :
            ((y2.y > 4.5) ? col12 :
            ((y2.y > 3.5) ? col11 :
            ((y2.y > 2.5) ? col10 :
            ((y2.y > 1.5) ? col02 :
            ((y2.y > 0.5) ? col01 : col00)))))));
    colorO.a *= color.a;
}

technique technique_hamana
{
   pass P0
   {        
      VertexShader = compile vs_3_0 VertexProgram();
      PixelShader  = compile ps_3_0 FragmentProgram();
   }
}

