const uniform float4x4 ModelViewProjMatrix;
const uniform float4 OneTexelDiff;

texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
};

void VertexProgram(
  in float4 position : POSITION,
  in float4 color : COLOR0,
  in float2 texCoord : TEXCOORD0,
  out float4 positionO : POSITION,
  out float4 colorO : COLOR0,
  out float2 texCoordO0 : TEXCOORD0,
  out float2 texCoordO1 : TEXCOORD1,
  out float2 texCoordO2 : TEXCOORD2,
  out float2 texCoordO3 : TEXCOORD3,
  out float2 texCoordO4 : TEXCOORD4)
{
  positionO = mul(ModelViewProjMatrix, position);
  colorO = color;
  texCoordO0 = texCoord;
  texCoordO1 = texCoord - OneTexelDiff.xy;
  texCoordO2 = texCoord + OneTexelDiff.xy;
  texCoordO3 = texCoord - OneTexelDiff.zw;
  texCoordO4 = texCoord + OneTexelDiff.zw;
}

void FragmentProgram(
  in float4 color : COLOR0,
  in float2 texCoord0 : TEXCOORD0,
  in float2 texCoord1 : TEXCOORD1,
  in float2 texCoord2 : TEXCOORD2,
  in float2 texCoord3 : TEXCOORD3,
  in float2 texCoord4 : TEXCOORD4,
  out float4 colorO : COLOR0)
{
  float4 texCol = tex2D(PictureSampler, texCoord1);
  texCol += tex2D(PictureSampler, texCoord2);
  texCol += tex2D(PictureSampler, texCoord3);
  texCol += tex2D(PictureSampler, texCoord4);
  texCol *= -0.2;
  texCol += tex2D(PictureSampler, texCoord0) * 1.8;
  colorO = texCol;
  colorO.a = color.a * texCol.a;
}

technique technique_hamana
{
   pass P0
   {        
      VertexShader = compile vs_2_0 VertexProgram();
      PixelShader  = compile ps_2_0 FragmentProgram();
   }
}
