#include "../common.fxh"

texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
};

void FragmentProgram(
  in float4 color : COLOR0,
  in float2 texCoord : TEXCOORD0,
  out float4 colorO : COLOR0)
{
  float4 texCol = tex2D(PictureSampler, texCoord);
  float y = dot(texCol, rgb2yuv[0]);
  colorO.rgb = y;
  colorO.a = color.a * texCol.a;
}

technique technique_hamana
{
   pass P0
   {        
      PixelShader  = compile ps_1_1 FragmentProgram();
   }
}
