texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
};

texture ToneCurveTexture;
sampler ToneCurveSampler = sampler_state
{
    Texture = <ToneCurveTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

void FragmentProgram(
  in float4 color : COLOR0,
  in float2 texCoord0 : TEXCOORD0,
  out float4 colorO : COLOR0)
{
  float4 texCol = tex2D(PictureSampler, texCoord0);
  colorO.r = tex2D(ToneCurveSampler, texCol.rg).r;
  colorO.g = tex2D(ToneCurveSampler, texCol.gg).g;
  colorO.b = tex2D(ToneCurveSampler, texCol.bg).b;
  colorO.a = texCol.a * color.a;
}

technique technique_hamana
{
   pass P0
   {        
      PixelShader  = compile ps_2_0 FragmentProgram();
   }
}
