#include "../common.fxh"

texture PictureTexture;
sampler PictureSampler = sampler_state
{
    Texture = <PictureTexture>;
};

texture ToneCurveTexture;
sampler ToneCurveSampler = sampler_state
{
    Texture = <ToneCurveTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = CLAMP;
    AddressV = CLAMP;
};

void FragmentProgram(
  in float4 color : COLOR0,
  in float2 texCoord0 : TEXCOORD0,
  out float4 colorO : COLOR0)
{
  float4 texCol = tex2D(PictureSampler, texCoord0);
  float3 yuv = mul(rgb2yuv, texCol.rgb);
  yuv.r = tex2D(ToneCurveSampler, yuv.rr).r;
  colorO.rgb = mul(yuv2rgb, yuv);
  colorO.a = texCol.a * color.a;
}

technique technique_hamana
{
   pass P0
   {        
      PixelShader  = compile ps_2_0 FragmentProgram();
   }
}
