/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;
import mx4j.log.Log;
import mx4j.log.Logger;

public class MBeanServerFactory {
    private static ArrayList servers = new ArrayList();
    static /* synthetic */ Class class$javax$management$MBeanServerFactory;
    static /* synthetic */ Class class$javax$management$MBeanServerBuilder;

    private MBeanServerFactory() {
    }

    private static Logger getLogger() {
        return Log.getLogger((class$javax$management$MBeanServerFactory == null ? (class$javax$management$MBeanServerFactory = MBeanServerFactory.class$("javax.management.MBeanServerFactory")) : class$javax$management$MBeanServerFactory).getName());
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer createMBeanServer(String defaultDomain) {
        MBeanServer server = MBeanServerFactory.createMBeanServerImpl(defaultDomain, "createMBeanServer");
        ArrayList arrayList = servers;
        synchronized (arrayList) {
            servers.add(server);
        }
        Logger logger = MBeanServerFactory.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("MBeanServer " + server + " registered successfully");
        }
        return server;
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    public static MBeanServer newMBeanServer(String defaultDomain) {
        return MBeanServerFactory.createMBeanServerImpl(defaultDomain, "newMBeanServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseMBeanServer(MBeanServer server) {
        block14: {
            Logger logger = MBeanServerFactory.getLogger();
            try {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Releasing MBeanServer " + server);
                }
                if (server != null) {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new MBeanServerPermission("releaseMBeanServer"));
                    }
                    boolean removed = false;
                    ArrayList arrayList = servers;
                    synchronized (arrayList) {
                        removed = servers.remove(server);
                    }
                    if (removed) {
                        if (logger.isEnabledFor(0)) {
                            logger.trace("MBeanServer " + server + " released successfully");
                        }
                    } else if (logger.isEnabledFor(20)) {
                        logger.info("MBeanServer " + server + " not released, cannot find it");
                    }
                    break block14;
                }
                if (logger.isEnabledFor(10)) {
                    logger.debug("Cannot release a null MBeanServer");
                }
            }
            catch (SecurityException x) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Security Exception caught while releasing MBeanServer " + server, x);
                }
                throw x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList findMBeanServer(String id) {
        Logger logger = MBeanServerFactory.getLogger();
        ArrayList<MBeanServer> list = null;
        try {
            SecurityManager sm;
            if (logger.isEnabledFor(0)) {
                logger.trace("Finding MBeanServer with ID: " + id);
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission(new MBeanServerPermission("findMBeanServer"));
            }
            if (id == null) {
                list = (ArrayList<MBeanServer>)servers.clone();
            } else {
                list = new ArrayList<MBeanServer>();
                ArrayList arrayList = servers;
                synchronized (arrayList) {
                    for (int i = 0; i < servers.size(); ++i) {
                        MBeanServer server = (MBeanServer)servers.get(i);
                        String serverId = MBeanServerFactory.getMBeanServerId(server);
                        if (!id.equals(serverId)) continue;
                        list.add(server);
                        if (!logger.isEnabledFor(0)) continue;
                        logger.trace("Found matching MBeanServer: " + server);
                    }
                }
            }
            if (logger.isEnabledFor(0)) {
                logger.trace("MBeanServer(s) found: " + list);
            }
            return list;
        }
        catch (SecurityException x) {
            if (logger.isEnabledFor(0)) {
                logger.trace("Security Exception caught while finding MBeanServer with ID: " + id, x);
            }
            throw x;
        }
    }

    private static String getMBeanServerId(MBeanServer server) {
        try {
            return (String)server.getAttribute(ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
        }
        catch (Exception x) {
            Logger logger = MBeanServerFactory.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("No permission to get MBeanServerID", x);
            }
            return null;
        }
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        return server.getClassLoaderRepository();
    }

    private static MBeanServer createMBeanServerImpl(String domain, String permission) {
        Logger logger = MBeanServerFactory.getLogger();
        boolean trace = logger.isEnabledFor(0);
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new MBeanServerPermission(permission));
            }
            if (trace) {
                logger.trace("Obtaining MBeanServerBuilder");
            }
            MBeanServerBuilder builder = MBeanServerFactory.createMBeanServerBuilder();
            if (trace) {
                logger.trace("Using MBeanServerBuilder " + builder.getClass());
            }
            if (trace) {
                logger.trace("Creating MBeanServerDelegate...");
            }
            MBeanServerDelegate delegate = builder.newMBeanServerDelegate();
            if (trace) {
                logger.trace("MBeanServerDelegate " + delegate.getClass() + " created successfully");
            }
            if (trace) {
                logger.trace("Creating MBeanServer...");
            }
            MBeanServer mbs = builder.newMBeanServer(domain, null, delegate);
            if (trace) {
                logger.trace("MBeanServer " + mbs + " created successfully");
            }
            if (logger.isEnabledFor(20)) {
                String mbeanServerId = MBeanServerFactory.getMBeanServerId(mbs);
                if (mbeanServerId != null) {
                    logger.info("Created MBeanServer with ID: " + mbeanServerId);
                } else {
                    logger.info("Created MBeanServer");
                }
            }
            return mbs;
        }
        catch (SecurityException x) {
            if (trace) {
                logger.trace("Security Exception caught while creating an MBeanServer", x);
            }
            throw x;
        }
    }

    private static MBeanServerBuilder createMBeanServerBuilder() {
        Class builderClass = MBeanServerFactory.loadMBeanServerBuilderClass();
        try {
            return (MBeanServerBuilder)builderClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new JMRuntimeException("Specified MBeanServerBuilder must be a subclass of MBeanServerBuilder: " + builderClass);
        }
        catch (IllegalAccessException e) {
            throw new JMRuntimeException("Can't instantiate MBeanServerBuilder " + builderClass + ": " + e);
        }
        catch (InstantiationException e) {
            throw new JMRuntimeException("Can't instantiate MBeanServerBuilder " + builderClass + ": " + e);
        }
    }

    private static Class loadMBeanServerBuilderClass() {
        String builderClassName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("javax.management.builder.initial");
            }
        });
        if (builderClassName == null || builderClassName.length() == 0) {
            return class$javax$management$MBeanServerBuilder == null ? (class$javax$management$MBeanServerBuilder = MBeanServerFactory.class$("javax.management.MBeanServerBuilder")) : class$javax$management$MBeanServerBuilder;
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(builderClassName);
            }
            return Class.forName(builderClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JMRuntimeException("MBeanServerBuilder class not found: " + builderClassName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

