/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.RuntimeOperationsException;
import mx4j.log.Log;
import mx4j.log.Logger;

public class NotificationBroadcasterSupport
implements NotificationEmitter {
    private static final NotificationFilter NULL_FILTER = new NotificationFilter(){

        public boolean isNotificationEnabled(Notification notification) {
            return true;
        }

        public String toString() {
            return "null filter";
        }
    };
    private static final Object NULL_HANDBACK = new Object(){

        public String toString() {
            return "null handback";
        }
    };
    private HashMap m_listeners = new HashMap();

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Adding notification listener: " + listener + ", filter: " + filter + ", handback: " + handback + " to " + this);
        }
        if (listener == null) {
            throw new IllegalArgumentException("Notification listener cannot be null");
        }
        if (filter == null) {
            filter = NULL_FILTER;
        }
        if (handback == null) {
            handback = NULL_HANDBACK;
        }
        FilterHandbackPair pair = new FilterHandbackPair(filter, handback);
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            ArrayList<FilterHandbackPair> pairs = (ArrayList<FilterHandbackPair>)this.m_listeners.get(listener);
            if (pairs == null) {
                pairs = new ArrayList<FilterHandbackPair>();
                pairs.add(pair);
                this.m_listeners.put(listener, pairs);
            } else {
                for (int i = 0; i < pairs.size(); ++i) {
                    FilterHandbackPair other = (FilterHandbackPair)pairs.get(i);
                    if (!pair.filter.equals(other.filter) || !pair.handback.equals(other.handback)) continue;
                    throw new RuntimeOperationsException(new IllegalArgumentException("Notification listener is already registered"));
                }
                pairs.add(pair);
            }
            if (logger.isEnabledFor(0)) {
                logger.trace("Filters - Handbacks for this listener: " + pairs);
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("Notification listener added successfully to " + this);
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Removing notification listener: " + listener);
        }
        int removed = this.removeNotificationListenerImpl(listener, null, null);
        if (logger.isEnabledFor(0)) {
            logger.trace(removed + " notification listener(s) removed successfully from " + this);
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Removing notification listener: " + listener + ", filter: " + filter + ", handback: " + handback);
        }
        if (filter == null) {
            filter = NULL_FILTER;
        }
        if (handback == null) {
            handback = NULL_HANDBACK;
        }
        int removed = this.removeNotificationListenerImpl(listener, filter, handback);
        if (logger.isEnabledFor(0)) {
            logger.trace(removed + " notification listener(s) removed successfully from " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeNotificationListenerImpl(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        Logger logger = this.getLogger();
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            ArrayList pairs;
            if (logger.isEnabledFor(0)) {
                logger.trace("Listeners for " + this + " are: " + this.m_listeners);
            }
            if ((pairs = (ArrayList)this.m_listeners.get(listener)) == null) {
                throw new ListenerNotFoundException("NotificationListener " + listener + " not found");
            }
            if (filter == null) {
                if (handback == null) {
                    ArrayList removed = (ArrayList)this.m_listeners.remove(listener);
                    return removed.size();
                }
                int count = 0;
                for (int i = 0; i < pairs.size(); ++i) {
                    Object hand = ((FilterHandbackPair)pairs.get(i)).handback;
                    if (!handback.equals(hand)) continue;
                    pairs.remove(i);
                    ++count;
                }
                if (count == 0) {
                    throw new ListenerNotFoundException("NotificationListener " + listener + " with handback " + handback + " not found");
                }
                if (pairs.isEmpty()) {
                    this.m_listeners.remove(listener);
                }
                return count;
            }
            if (handback == null) {
                int count = 0;
                for (int i = 0; i < pairs.size(); ++i) {
                    NotificationFilter filt = ((FilterHandbackPair)pairs.get(i)).filter;
                    if (!filter.equals(filt)) continue;
                    pairs.remove(i);
                    ++count;
                }
                if (count == 0) {
                    throw new ListenerNotFoundException("NotificationListener " + listener + " with filter " + filter + " not found");
                }
                if (pairs.isEmpty()) {
                    this.m_listeners.remove(listener);
                }
                return count;
            }
            int count = 0;
            for (int i = 0; i < pairs.size(); ++i) {
                FilterHandbackPair pair = (FilterHandbackPair)pairs.get(i);
                if (!filter.equals(pair.filter) || !handback.equals(pair.handback)) continue;
                pairs.remove(i);
                ++count;
            }
            if (count == 0) {
                throw new ListenerNotFoundException("NotificationListener " + listener + " with filter " + filter + " and handback " + handback + " not found");
            }
            if (pairs.isEmpty()) {
                this.m_listeners.remove(listener);
            }
            return count;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Notification notification) {
        Logger logger = this.getLogger();
        boolean trace = logger.isEnabledFor(0);
        boolean info = logger.isEnabledFor(20);
        HashMap listeners = null;
        NotificationBroadcasterSupport notificationBroadcasterSupport = this;
        synchronized (notificationBroadcasterSupport) {
            listeners = (HashMap)this.m_listeners.clone();
        }
        Iterator i = listeners.keySet().iterator();
        if (i.hasNext() && trace) {
            logger.trace("Sending notifications from " + this);
        }
        while (i.hasNext()) {
            NotificationListener listener = (NotificationListener)i.next();
            if (trace) {
                logger.trace("\tListener is: " + listener);
            }
            ArrayList pairs = null;
            NotificationBroadcasterSupport notificationBroadcasterSupport2 = this;
            synchronized (notificationBroadcasterSupport2) {
                pairs = (ArrayList)this.m_listeners.get(listener);
                pairs = (ArrayList)pairs.clone();
            }
            if (trace) {
                logger.trace("\tFilters - Handback for this listener: " + pairs);
            }
            for (int j = 0; j < pairs.size(); ++j) {
                boolean enabled;
                Object handback;
                NotificationFilter filter;
                block19: {
                    FilterHandbackPair pair = (FilterHandbackPair)pairs.get(j);
                    filter = pair.filter;
                    handback = pair.handback;
                    if (filter == NULL_FILTER) {
                        filter = null;
                    }
                    if (handback == NULL_HANDBACK) {
                        handback = null;
                    }
                    enabled = false;
                    try {
                        enabled = filter == null || filter.isNotificationEnabled(notification);
                    }
                    catch (RuntimeException x) {
                        if (!info) break block19;
                        logger.info("RuntimeException caught from isNotificationEnabled", x);
                    }
                }
                if (trace) {
                    logger.trace("\t\tFilter is: " + filter + ", enabled: " + enabled);
                }
                if (!enabled) continue;
                if (trace) {
                    logger.debug("\t\tHandback is: " + handback);
                    logger.debug("\t\tSending notification " + notification);
                }
                try {
                    this.handleNotification(listener, notification, handback);
                    continue;
                }
                catch (RuntimeException x) {
                    if (!info) continue;
                    logger.info("RuntimeException caught from handleNotification", x);
                }
            }
        }
    }

    protected void handleNotification(NotificationListener listener, Notification notification, Object handback) {
        listener.handleNotification(notification, handback);
    }

    private static class FilterHandbackPair {
        private NotificationFilter filter;
        private Object handback;

        private FilterHandbackPair(NotificationFilter filter, Object handback) {
            this.filter = filter;
            this.handback = handback;
        }
    }
}

