/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcaster;
import javax.management.loading.MLet;
import mx4j.MBeanDescription;
import mx4j.MBeanDescriptionAdapter;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.server.BCELMBeanInvoker;
import mx4j.server.MBeanInvoker;
import mx4j.server.MBeanMetaData;
import mx4j.server.ReflectedMBeanInvoker;
import mx4j.util.Utils;

public class MBeanIntrospector {
    private static MBeanDescriptionAdapter DEFAULT_DESCRIPTION = new MBeanDescriptionAdapter();
    private boolean m_useExtendedMBeanInterfaces = false;
    private boolean m_bcelClassesAvailable = false;
    private final String m_customMBeanInvoker;
    static /* synthetic */ Class class$javax$management$loading$MLet;

    public MBeanIntrospector() {
        String strict = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("mx4j.strict.mbean.interface");
            }
        });
        if (strict != null && !Boolean.valueOf(strict).booleanValue()) {
            this.m_useExtendedMBeanInterfaces = true;
        }
        try {
            this.getClass().getClassLoader().loadClass("org.apache.bcel.generic.Type");
            this.m_bcelClassesAvailable = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_customMBeanInvoker = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("mx4j.mbean.invoker");
            }
        });
    }

    public void introspect(MBeanMetaData metadata) {
        this.introspectType(metadata);
        this.introspectMBeanInfo(metadata);
    }

    public boolean isMBeanCompliant(MBeanMetaData metadata) {
        return this.isMBeanClassCompliant(metadata) && this.isMBeanTypeCompliant(metadata) && this.isMBeanInfoCompliant(metadata);
    }

    private boolean testCompliance(MBeanMetaData metadata) {
        this.introspect(metadata);
        return this.isMBeanCompliant(metadata);
    }

    private boolean isMBeanClassCompliant(MBeanMetaData metadata) {
        return true;
    }

    private boolean isMBeanTypeCompliant(MBeanMetaData metadata) {
        Logger logger = this.getLogger();
        if (metadata.standard && metadata.dynamic) {
            if (logger.isEnabledFor(10)) {
                logger.debug("MBean is both standard and dynamic");
            }
            return false;
        }
        if (!metadata.standard && !metadata.dynamic) {
            if (logger.isEnabledFor(10)) {
                logger.debug("MBean is not standard nor dynamic");
            }
            return false;
        }
        return true;
    }

    private boolean isMBeanInfoCompliant(MBeanMetaData metadata) {
        Logger logger = this.getLogger();
        if (metadata.info == null) {
            if (logger.isEnabledFor(10)) {
                logger.debug("MBeanInfo is null");
            }
            return false;
        }
        return true;
    }

    private void introspectType(MBeanMetaData metadata) {
        if (metadata.standard) {
            this.introspectStandardMBean(metadata);
            return;
        }
        if (metadata.mbean instanceof DynamicMBean) {
            metadata.dynamic = true;
            return;
        }
        metadata.dynamic = false;
        this.introspectStandardMBean(metadata);
    }

    private void introspectStandardMBean(MBeanMetaData metadata) {
        Class<?> cls;
        if (metadata.management != null) {
            if (metadata.management.isInstance(metadata.mbean)) {
                if (metadata.invoker == null) {
                    metadata.invoker = this.createInvoker(metadata);
                }
                return;
            }
            metadata.standard = false;
            metadata.management = null;
            metadata.invoker = null;
            return;
        }
        for (Class<?> c = cls = metadata.mbean.getClass(); c != null; c = c.getSuperclass()) {
            Class<?>[] intfs = c.getInterfaces();
            for (int i = 0; i < intfs.length; ++i) {
                Class<?> intf = intfs[i];
                if (!this.implementsMBean(c.getName(), intf.getName())) continue;
                metadata.standard = true;
                metadata.management = intf;
                metadata.invoker = this.createInvoker(metadata);
                return;
            }
        }
        metadata.standard = false;
        metadata.management = null;
        metadata.invoker = null;
    }

    private void introspectMBeanInfo(MBeanMetaData metadata) {
        metadata.info = metadata.dynamic ? this.getDynamicMBeanInfo(metadata) : (metadata.standard ? this.createStandardMBeanInfo(metadata) : null);
    }

    private MBeanInfo getDynamicMBeanInfo(MBeanMetaData metadata) {
        MBeanInfo info;
        Logger logger;
        block5: {
            logger = this.getLogger();
            info = null;
            try {
                info = ((DynamicMBean)metadata.mbean).getMBeanInfo();
            }
            catch (Exception x) {
                if (!logger.isEnabledFor(10)) break block5;
                logger.debug("getMBeanInfo threw: " + x.toString());
            }
        }
        if (logger.isEnabledFor(0)) {
            logger.trace("Dynamic MBeanInfo is: " + info);
        }
        if (info == null) {
            if (logger.isEnabledFor(10)) {
                logger.debug("MBeanInfo cannot be null");
            }
            return null;
        }
        return info;
    }

    private MBeanInfo createStandardMBeanInfo(MBeanMetaData metadata) {
        MBeanDescription description = this.createMBeanDescription(metadata);
        MBeanConstructorInfo[] ctors = this.createMBeanConstructorInfo(metadata, description);
        if (ctors == null) {
            return null;
        }
        MBeanAttributeInfo[] attrs = this.createMBeanAttributeInfo(metadata, description);
        if (attrs == null) {
            return null;
        }
        MBeanOperationInfo[] opers = this.createMBeanOperationInfo(metadata, description);
        if (opers == null) {
            return null;
        }
        MBeanNotificationInfo[] notifs = this.createMBeanNotificationInfo(metadata);
        if (notifs == null) {
            return null;
        }
        return new MBeanInfo(metadata.mbean.getClass().getName(), description.getMBeanDescription(), attrs, ctors, opers, notifs);
    }

    private MBeanDescription createMBeanDescription(MBeanMetaData metadata) {
        Class<?> mbeanClass;
        String clsName;
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Looking for standard MBean description...");
        }
        for (Class<?> cls = mbeanClass = metadata.mbean.getClass(); cls != null && !(clsName = cls.getName()).startsWith("java."); cls = cls.getSuperclass()) {
            String descrClassName = clsName + "MBeanDescription";
            try {
                Class<Object> descrClass = null;
                ClassLoader loader = metadata.classloader;
                descrClass = loader != null ? (loader.getClass() == (class$javax$management$loading$MLet == null ? MBeanIntrospector.class$("javax.management.loading.MLet") : class$javax$management$loading$MLet) ? ((MLet)loader).loadClass(descrClassName, null) : loader.loadClass(descrClassName)) : Class.forName(descrClassName, false, null);
                Object descrInstance = descrClass.newInstance();
                if (!(descrInstance instanceof MBeanDescription)) continue;
                MBeanDescription description = (MBeanDescription)descrInstance;
                if (logger.isEnabledFor(0)) {
                    logger.trace("Found provided standard MBean description: " + description);
                }
                return description;
            }
            catch (ClassNotFoundException ignored) {
                continue;
            }
            catch (InstantiationException ignored) {
                continue;
            }
            catch (IllegalAccessException ignored) {
                // empty catch block
            }
        }
        MBeanDescriptionAdapter description = DEFAULT_DESCRIPTION;
        if (logger.isEnabledFor(0)) {
            logger.trace("Cannot find standard MBean description, using default: " + description);
        }
        return description;
    }

    private MBeanOperationInfo[] createMBeanOperationInfo(MBeanMetaData metadata, MBeanDescription description) {
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        Method[] methods = metadata.management.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Method method = methods[j];
            if (Utils.isAttributeGetter(method) || Utils.isAttributeSetter(method)) continue;
            String descr = description == null ? null : description.getOperationDescription(method);
            Class<?>[] params = method.getParameterTypes();
            MBeanParameterInfo[] paramsInfo = new MBeanParameterInfo[params.length];
            for (int k = 0; k < params.length; ++k) {
                Class<?> param = params[k];
                String paramName = description == null ? null : description.getOperationParameterName(method, k);
                String paramDescr = description == null ? null : description.getOperationParameterDescription(method, k);
                paramsInfo[k] = new MBeanParameterInfo(paramName, param.getName(), paramDescr);
            }
            MBeanOperationInfo info = new MBeanOperationInfo(method.getName(), descr, paramsInfo, method.getReturnType().getName(), 3);
            operations.add(info);
        }
        return operations.toArray(new MBeanOperationInfo[operations.size()]);
    }

    private MBeanAttributeInfo[] createMBeanAttributeInfo(MBeanMetaData metadata, MBeanDescription description) {
        Logger logger = this.getLogger();
        HashMap<String, MBeanAttributeInfo> attributes = new HashMap<String, MBeanAttributeInfo>();
        HashMap<String, Method> getterNames = new HashMap<String, Method>();
        Method[] methods = metadata.management.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            String name;
            Method method = methods[j];
            if (Utils.isAttributeGetter(method)) {
                name = method.getName();
                boolean isIs = name.startsWith("is");
                String attribute = null;
                attribute = isIs ? name.substring(2) : name.substring(3);
                String descr = description == null ? null : description.getAttributeDescription(attribute);
                MBeanAttributeInfo info = (MBeanAttributeInfo)attributes.get(attribute);
                if (info != null) {
                    if (!info.getType().equals(method.getReturnType().getName())) {
                        if (logger.isEnabledFor(10)) {
                            logger.debug("MBean is not compliant: has overloaded attribute " + attribute);
                        }
                        return null;
                    }
                    if (getterNames.get(name) != null) continue;
                    if (info.isReadable()) {
                        if (logger.isEnabledFor(10)) {
                            logger.debug("MBean is not compliant: has overloaded attribute " + attribute);
                        }
                        return null;
                    }
                    info = new MBeanAttributeInfo(attribute, info.getType(), info.getDescription(), true, info.isWritable(), isIs);
                } else {
                    info = new MBeanAttributeInfo(attribute, method.getReturnType().getName(), descr, true, false, isIs);
                }
                attributes.put(attribute, info);
                getterNames.put(name, method);
                continue;
            }
            if (!Utils.isAttributeSetter(method)) continue;
            name = method.getName();
            String attribute = name.substring(3);
            String descr = description == null ? null : description.getAttributeDescription(attribute);
            MBeanAttributeInfo info = (MBeanAttributeInfo)attributes.get(attribute);
            if (info != null) {
                if (!info.getType().equals(method.getParameterTypes()[0].getName())) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("MBean is not compliant: has overloaded attribute " + attribute);
                    }
                    return null;
                }
                info = new MBeanAttributeInfo(info.getName(), info.getType(), info.getDescription(), info.isReadable(), true, info.isIs());
            } else {
                info = new MBeanAttributeInfo(attribute, method.getParameterTypes()[0].getName(), descr, false, true, false);
            }
            attributes.put(attribute, info);
        }
        return attributes.values().toArray(new MBeanAttributeInfo[attributes.size()]);
    }

    private MBeanNotificationInfo[] createMBeanNotificationInfo(MBeanMetaData metadata) {
        MBeanNotificationInfo[] notifs = null;
        if (metadata.mbean instanceof NotificationBroadcaster) {
            notifs = ((NotificationBroadcaster)metadata.mbean).getNotificationInfo();
        }
        if (notifs == null) {
            notifs = new MBeanNotificationInfo[]{};
        }
        return notifs;
    }

    private MBeanConstructorInfo[] createMBeanConstructorInfo(MBeanMetaData metadata, MBeanDescription descrs) {
        Class<?> mbeanClass = metadata.mbean.getClass();
        Constructor<?>[] ctors = mbeanClass.getConstructors();
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[ctors.length];
        for (int i = 0; i < ctors.length; ++i) {
            MBeanConstructorInfo info;
            Constructor<?> constructor = ctors[i];
            String descr = descrs == null ? null : descrs.getConstructorDescription(constructor);
            Class<?>[] params = constructor.getParameterTypes();
            MBeanParameterInfo[] paramsInfo = new MBeanParameterInfo[params.length];
            for (int j = 0; j < params.length; ++j) {
                Class<?> param = params[j];
                String paramName = descrs == null ? null : descrs.getConstructorParameterName(constructor, j);
                String paramDescr = descrs == null ? null : descrs.getConstructorParameterDescription(constructor, j);
                paramsInfo[j] = new MBeanParameterInfo(paramName, param.getName(), paramDescr);
            }
            String ctorName = constructor.getName();
            constructors[i] = info = new MBeanConstructorInfo(ctorName.substring(ctorName.lastIndexOf(46) + 1), descr, paramsInfo);
        }
        return constructors;
    }

    private boolean implementsMBean(String clsName, String intfName) {
        if (intfName.equals(clsName + "MBean")) {
            return true;
        }
        if (this.m_useExtendedMBeanInterfaces) {
            int intfDollar;
            int intfDot;
            int clsDot = clsName.lastIndexOf(46);
            if (clsDot > 0) {
                clsName = clsName.substring(clsDot + 1);
            }
            if ((intfDot = intfName.lastIndexOf(46)) > 0) {
                intfName = intfName.substring(intfDot + 1);
            }
            if (intfName.equals(clsName + "MBean")) {
                return true;
            }
            int clsDollar = clsName.lastIndexOf(36);
            if (clsDollar > 0) {
                clsName = clsName.substring(clsDollar + 1);
            }
            if ((intfDollar = intfName.lastIndexOf(36)) > 0) {
                intfName = intfName.substring(intfDollar + 1);
            }
            if (intfName.equals(clsName + "MBean")) {
                return true;
            }
        }
        return false;
    }

    private MBeanInvoker createInvoker(MBeanMetaData metadata) {
        Logger logger;
        block8: {
            logger = this.getLogger();
            if (this.m_customMBeanInvoker != null) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Custom MBeanInvoker class is: " + this.m_customMBeanInvoker);
                }
                try {
                    MBeanInvoker mbeanInvoker = (MBeanInvoker)Thread.currentThread().getContextClassLoader().loadClass(this.m_customMBeanInvoker).newInstance();
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Using custom MBeanInvoker: " + mbeanInvoker);
                    }
                    return mbeanInvoker;
                }
                catch (Exception x) {
                    if (!logger.isEnabledFor(10)) break block8;
                    logger.debug("Cannot instantiate custom MBeanInvoker, using default", x);
                }
            }
        }
        if (this.m_bcelClassesAvailable) {
            MBeanInvoker mbeanInvoker = BCELMBeanInvoker.create(metadata);
            if (logger.isEnabledFor(0)) {
                logger.trace("Using default BCEL MBeanInvoker for MBean " + metadata.name + ", " + mbeanInvoker);
            }
            return mbeanInvoker;
        }
        ReflectedMBeanInvoker mbeanInvoker = new ReflectedMBeanInvoker();
        if (logger.isEnabledFor(0)) {
            logger.trace("Using default Reflection MBeanInvoker for MBean " + metadata.name + ", " + mbeanInvoker);
        }
        return mbeanInvoker;
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

