/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import mx4j.ImplementationException;
import mx4j.server.MBeanInvoker;
import mx4j.server.MBeanMetaData;
import mx4j.util.MethodTernaryTree;
import mx4j.util.Utils;

public class ReflectedMBeanInvoker
implements MBeanInvoker {
    private static final String[] EMPTY_PARAMS = new String[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final Map attributes = new HashMap();
    private final Map attributeNames = new HashMap();
    private final MethodTernaryTree operations = new MethodTernaryTree();
    private final MethodTernaryTree methods = new MethodTernaryTree();

    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        MBeanOperationInfo oper = this.getStandardOperationInfo(metadata, method, params);
        if (oper != null) {
            try {
                return this.invokeImpl(metadata, method, params, args);
            }
            catch (IllegalArgumentException x) {
                throw new RuntimeOperationsException(x);
            }
        }
        throw new ReflectionException(new NoSuchMethodException("Operation " + method + " does not belong to the management interface"));
    }

    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        MBeanAttributeInfo attr = this.getStandardAttributeInfo(metadata, attribute, false);
        if (attr != null) {
            String attributeName = this.getAttributeName(attr, true);
            try {
                return this.invokeImpl(metadata, attributeName, EMPTY_PARAMS, EMPTY_ARGS);
            }
            catch (IllegalArgumentException x) {
                throw new ImplementationException();
            }
        }
        throw new AttributeNotFoundException(attribute);
    }

    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        String name = attribute.getName();
        MBeanAttributeInfo attr = this.getStandardAttributeInfo(metadata, name, true);
        if (attr != null) {
            String attributeName = this.getAttributeName(attr, false);
            try {
                this.invokeImpl(metadata, attributeName, new String[]{attr.getType()}, new Object[]{attribute.getValue()});
            }
            catch (IllegalArgumentException x) {
                throw new InvalidAttributeValueException("Invalid value for attribute " + name + ": " + attribute.getValue());
            }
        } else {
            throw new AttributeNotFoundException(name);
        }
    }

    protected Object invokeImpl(MBeanMetaData metadata, String method, String[] signature, Object[] args) throws ReflectionException, MBeanException, IllegalArgumentException {
        Method m = this.getStandardManagementMethod(metadata, method, signature);
        try {
            return m.invoke(metadata.mbean, args);
        }
        catch (IllegalAccessException x) {
            throw new ReflectionException(x);
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
            if (t instanceof JMRuntimeException) {
                throw (JMRuntimeException)t;
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            throw new MBeanException((Exception)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanAttributeInfo getStandardAttributeInfo(MBeanMetaData metadata, String attribute, boolean isWritable) {
        MBeanAttributeInfo attr = null;
        Map map = this.attributes;
        synchronized (map) {
            attr = (MBeanAttributeInfo)this.attributes.get(attribute);
        }
        if (attr != null) {
            if (isWritable && attr.isWritable()) {
                return attr;
            }
            if (!isWritable && attr.isReadable()) {
                return attr;
            }
        } else {
            MBeanAttributeInfo[] attrs = metadata.info.getAttributes();
            if (attrs != null) {
                for (int i = 0; i < attrs.length; ++i) {
                    attr = attrs[i];
                    String name = attr.getName();
                    if (!attribute.equals(name)) continue;
                    Map map2 = this.attributes;
                    synchronized (map2) {
                        this.attributes.put(attribute, attr);
                    }
                    if (isWritable && attr.isWritable()) {
                        return attr;
                    }
                    if (isWritable || !attr.isReadable()) continue;
                    return attr;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanOperationInfo getStandardOperationInfo(MBeanMetaData metadata, String method, String[] signature) {
        MBeanOperationInfo oper = null;
        MethodTernaryTree methodTernaryTree = this.operations;
        synchronized (methodTernaryTree) {
            oper = (MBeanOperationInfo)this.operations.get(method, signature);
        }
        if (oper != null) {
            return oper;
        }
        MBeanInfo info = metadata.info;
        MBeanOperationInfo[] opers = info.getOperations();
        if (opers != null) {
            for (int i = 0; i < opers.length; ++i) {
                MBeanParameterInfo[] params;
                oper = opers[i];
                String name = oper.getName();
                if (!method.equals(name) || signature.length != (params = oper.getSignature()).length) continue;
                boolean match = true;
                for (int j = 0; j < params.length; ++j) {
                    MBeanParameterInfo param = params[j];
                    if (signature[j].equals(param.getType())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                MethodTernaryTree methodTernaryTree2 = this.operations;
                synchronized (methodTernaryTree2) {
                    this.operations.put(method, signature, oper);
                }
                return oper;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getStandardManagementMethod(MBeanMetaData metadata, String name, String[] signature) throws ReflectionException {
        Method method = null;
        MethodTernaryTree methodTernaryTree = this.methods;
        synchronized (methodTernaryTree) {
            method = (Method)this.methods.get(name, signature);
        }
        if (method != null) {
            return method;
        }
        try {
            Class[] params = Utils.loadClasses(metadata.classloader, signature);
            method = metadata.mbean.getClass().getMethod(name, params);
            MethodTernaryTree methodTernaryTree2 = this.methods;
            synchronized (methodTernaryTree2) {
                this.methods.put(name, signature, method);
            }
            return method;
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (NoSuchMethodException x) {
            throw new ReflectionException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAttributeName(MBeanAttributeInfo attribute, boolean getter) {
        AttributeName attributeName = null;
        String name = attribute.getName();
        Map map = this.attributeNames;
        synchronized (map) {
            attributeName = (AttributeName)this.attributeNames.get(name);
        }
        if (attributeName == null) {
            String prefix = attribute.isIs() ? "is" : "get";
            attributeName = new AttributeName(prefix + name, "set" + name);
            Map map2 = this.attributeNames;
            synchronized (map2) {
                this.attributeNames.put(name, attributeName);
            }
        }
        if (getter) {
            return attributeName.getter;
        }
        return attributeName.setter;
    }

    private static class AttributeName {
        private final String getter;
        private final String setter;

        public AttributeName(String getter, String setter) {
            this.getter = getter;
            this.setter = setter;
        }
    }
}

