/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import mx4j.ImplementationException;
import mx4j.log.Logger;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;
import mx4j.server.interceptor.InvokerMBeanServerInterceptorMBean;
import mx4j.util.Utils;

public class InvokerMBeanServerInterceptor
extends DefaultMBeanServerInterceptor
implements InvokerMBeanServerInterceptorMBean {
    private MBeanServer outerServer;

    public InvokerMBeanServerInterceptor(MBeanServer outerServer) {
        this.outerServer = outerServer;
    }

    public String getType() {
        return "invoker";
    }

    public boolean isEnabled() {
        return true;
    }

    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        ((NotificationBroadcaster)metadata.mbean).addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener) throws ListenerNotFoundException {
        ((NotificationBroadcaster)metadata.mbean).removeNotificationListener(listener);
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        ((NotificationEmitter)metadata.mbean).removeNotificationListener(listener, filter, handback);
    }

    public void instantiate(MBeanMetaData metadata, String className, String[] params, Object[] args) throws ReflectionException, MBeanException {
        try {
            ClassLoader loader = metadata.classloader;
            Class<?> cls = null;
            cls = loader != null ? loader.loadClass(className) : Class.forName(className, false, null);
            Class[] signature = Utils.loadClasses(loader, params);
            Constructor<?> ctor = cls.getConstructor(signature);
            metadata.mbean = ctor.newInstance(args);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (NoSuchMethodException x) {
            throw new ReflectionException(x);
        }
        catch (InstantiationException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalAccessException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalArgumentException x) {
            throw new ReflectionException(x);
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            throw new MBeanException((Exception)t);
        }
    }

    public void registration(MBeanMetaData metadata, int operation) throws MBeanRegistrationException {
        if (!(metadata.mbean instanceof MBeanRegistration)) {
            return;
        }
        MBeanRegistration registrable = (MBeanRegistration)metadata.mbean;
        try {
            switch (operation) {
                case 1: {
                    ObjectName objName;
                    metadata.name = objName = registrable.preRegister(this.outerServer, metadata.name);
                    break;
                }
                case 2: {
                    registrable.postRegister(Boolean.TRUE);
                    break;
                }
                case 3: {
                    registrable.postRegister(Boolean.FALSE);
                    break;
                }
                case 4: {
                    registrable.preDeregister();
                    break;
                }
                case 5: {
                    registrable.postDeregister();
                    break;
                }
                default: {
                    throw new ImplementationException();
                }
            }
        }
        catch (RuntimeException x) {
            throw new RuntimeMBeanException(x);
        }
        catch (Exception x) {
            if (x instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)x;
            }
            throw new MBeanRegistrationException(x);
        }
    }

    public MBeanInfo getMBeanInfo(MBeanMetaData metadata) {
        if (metadata.dynamic) {
            MBeanInfo info = null;
            try {
                info = ((DynamicMBean)metadata.mbean).getMBeanInfo();
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            if (info == null) {
                return null;
            }
            metadata.info = info;
            String className = info.getClassName();
            if (!metadata.instance.getClassName().equals(className)) {
                metadata.instance = new ObjectInstance(metadata.name, className);
            }
        }
        return (MBeanInfo)metadata.info.clone();
    }

    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        if (metadata.dynamic) {
            try {
                return ((DynamicMBean)metadata.mbean).invoke(method, args, params);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        return metadata.invoker.invoke(metadata, method, params, args);
    }

    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (metadata.dynamic) {
            try {
                return ((DynamicMBean)metadata.mbean).getAttribute(attribute);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        return metadata.invoker.getAttribute(metadata, attribute);
    }

    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        if (metadata.dynamic) {
            try {
                ((DynamicMBean)metadata.mbean).setAttribute(attribute);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        } else {
            metadata.invoker.setAttribute(metadata, attribute);
        }
    }

    public AttributeList getAttributes(MBeanMetaData metadata, String[] attributes) {
        if (metadata.dynamic) {
            try {
                return ((DynamicMBean)metadata.mbean).getAttributes(attributes);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            try {
                Object value = this.getAttribute(metadata, name);
                Attribute attr = new Attribute(name, value);
                list.add(attr);
                continue;
            }
            catch (Exception ignored) {
                Logger logger = this.getLogger();
                if (!logger.isEnabledFor(10)) continue;
                logger.debug("Exception caught from getAttributes(), ignoring attribute " + name);
            }
        }
        return list;
    }

    public AttributeList setAttributes(MBeanMetaData metadata, AttributeList attributes) {
        if (metadata.dynamic) {
            try {
                return ((DynamicMBean)metadata.mbean).setAttributes(attributes);
            }
            catch (JMRuntimeException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new RuntimeMBeanException(x);
            }
            catch (Error x) {
                throw new RuntimeErrorException(x);
            }
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            try {
                this.setAttribute(metadata, attr);
                list.add(attr);
                continue;
            }
            catch (Exception ignored) {
                Logger logger = this.getLogger();
                if (!logger.isEnabledFor(10)) continue;
                logger.debug("Exception caught from setAttributes(), ignoring attribute " + attr, ignored);
            }
        }
        return list;
    }
}

