/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server.interceptor;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanTrustPermission;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import mx4j.server.MBeanMetaData;
import mx4j.server.interceptor.DefaultMBeanServerInterceptor;
import mx4j.server.interceptor.SecurityMBeanServerInterceptorMBean;

public class SecurityMBeanServerInterceptor
extends DefaultMBeanServerInterceptor
implements SecurityMBeanServerInterceptorMBean {
    public String getType() {
        return "security";
    }

    public boolean isEnabled() {
        return true;
    }

    public void addNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) {
        this.checkPermission(metadata.info.getClassName(), null, metadata.name, "addNotificationListener");
        super.addNotificationListener(metadata, listener, filter, handback);
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener) throws ListenerNotFoundException {
        this.checkPermission(metadata.info.getClassName(), null, metadata.name, "removeNotificationListener");
        super.removeNotificationListener(metadata, listener);
    }

    public void removeNotificationListener(MBeanMetaData metadata, NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.checkPermission(metadata.info.getClassName(), null, metadata.name, "removeNotificationListener");
        super.removeNotificationListener(metadata, listener, filter, handback);
    }

    public void instantiate(MBeanMetaData metadata, String className, String[] params, Object[] args) throws ReflectionException, MBeanException {
        this.checkPermission(className, null, metadata.name, "instantiate");
        super.instantiate(metadata, className, params, args);
    }

    public MBeanInfo getMBeanInfo(MBeanMetaData metadata) {
        this.checkPermission(metadata.info.getClassName(), null, metadata.name, "getMBeanInfo");
        return super.getMBeanInfo(metadata);
    }

    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        this.checkPermission(metadata.info.getClassName(), method, metadata.name, "invoke");
        return super.invoke(metadata, method, params, args);
    }

    public AttributeList getAttributes(MBeanMetaData metadata, String[] attributes) {
        Object[] secured = this.filterAttributes(metadata.info.getClassName(), metadata.name, attributes, true);
        String[] array = new String[secured.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String)secured[i];
        }
        return super.getAttributes(metadata, array);
    }

    public AttributeList setAttributes(MBeanMetaData metadata, AttributeList attributes) {
        Object[] secured = this.filterAttributes(metadata.info.getClassName(), metadata.name, attributes.toArray(), false);
        AttributeList list = new AttributeList();
        for (int i = 0; i < secured.length; ++i) {
            list.add(secured[i]);
        }
        return super.setAttributes(metadata, list);
    }

    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        this.checkPermission(metadata.info.getClassName(), attribute, metadata.name, "getAttribute");
        return super.getAttribute(metadata, attribute);
    }

    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        this.checkPermission(metadata.info.getClassName(), attribute.getName(), metadata.name, "setAttribute");
        super.setAttribute(metadata, attribute);
    }

    public void registration(MBeanMetaData metadata, int operation) throws MBeanRegistrationException {
        switch (operation) {
            case 1: {
                this.checkPermission(metadata.info.getClassName(), null, metadata.name, "registerMBean");
                this.checkTrustRegistration(metadata.mbean.getClass());
                break;
            }
            case 2: {
                this.checkPermission(metadata.info.getClassName(), null, metadata.name, "registerMBean");
                break;
            }
            case 4: {
                this.checkPermission(metadata.info.getClassName(), null, metadata.name, "unregisterMBean");
                break;
            }
        }
        super.registration(metadata, operation);
    }

    private void checkPermission(String className, String methodName, ObjectName objectname, String action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MBeanPermission(className, methodName, objectname, action));
        }
    }

    private void checkTrustRegistration(final Class cls) {
        MBeanTrustPermission permission;
        ProtectionDomain domain;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && !(domain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cls.getProtectionDomain();
            }
        })).implies(permission = new MBeanTrustPermission("register"))) {
            throw new AccessControlException("Access denied " + permission + ": MBean class " + cls.getName() + " is not trusted for registration");
        }
    }

    private Object[] filterAttributes(String className, ObjectName objectName, Object[] attributes, boolean isGet) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return attributes;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < attributes.length; ++i) {
            Object attribute = attributes[i];
            String name = isGet ? (String)attribute : ((Attribute)attribute).getName();
            try {
                this.checkPermission(className, name, objectName, isGet ? "getAttribute" : "setAttribute");
                list.add(attribute);
                continue;
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
        }
        return list.toArray();
    }
}

