/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import java.util.AbstractCollection;
import java.util.HashSet;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class BaseAttributeFilter
implements NotificationFilter {
    private HashSet names = new HashSet();

    public BaseAttributeFilter(String name) {
        if (name != null) {
            this.addAttribute(name);
        }
    }

    public void addAttribute(String name) {
        HashSet hashSet = this.names;
        synchronized (hashSet) {
            this.names.add(name);
        }
    }

    public void clear() {
        HashSet hashSet = this.names;
        synchronized (hashSet) {
            this.names.clear();
        }
    }

    public String[] getNames() {
        HashSet hashSet = this.names;
        synchronized (hashSet) {
            String[] stringArray = ((AbstractCollection)this.names).toArray(new String[this.names.size()]);
            return stringArray;
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (notification == null) {
            return false;
        }
        if (!(notification instanceof AttributeChangeNotification)) {
            return false;
        }
        AttributeChangeNotification acn = (AttributeChangeNotification)notification;
        if (!"jmx.attribute.change".equals(acn.getType())) {
            return false;
        }
        HashSet hashSet = this.names;
        synchronized (hashSet) {
            if (this.names.size() < 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.names.contains(acn.getAttributeName());
            return bl;
        }
    }

    public void removeAttribute(String name) {
        HashSet hashSet = this.names;
        synchronized (hashSet) {
            this.names.remove(name);
        }
    }
}

