/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.commons.modeler.BaseAttributeFilter;
import org.apache.commons.modeler.BaseNotificationBroadcaster;

public class BaseModelMBean
implements ModelMBean {
    protected BaseNotificationBroadcaster attributeBroadcaster = null;
    protected BaseNotificationBroadcaster generalBroadcaster = null;
    protected ModelMBeanInfo info = null;
    protected Object resource = null;

    public BaseModelMBean() throws MBeanException, RuntimeOperationsException {
        this.setModelMBeanInfo(this.createDefaultModelMBeanInfo());
    }

    public BaseModelMBean(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        this.setModelMBeanInfo(info);
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name is null"), "Attribute name is null");
        }
        ModelMBeanAttributeInfo attrInfo = this.info.getAttribute(name);
        if (attrInfo == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + name);
        }
        Descriptor attrDesc = attrInfo.getDescriptor();
        if (attrDesc == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + name + " descriptor");
        }
        String getMethod = (String)attrDesc.getFieldValue("getMethod");
        if (getMethod == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + name + " get method name");
        }
        return this.invoke(getMethod, new Object[0], new String[0]);
    }

    public AttributeList getAttributes(String[] names) {
        if (names == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names list is null"), "Attribute names list is null");
        }
        AttributeList response = new AttributeList();
        int i = 0;
        while (i < names.length) {
            try {
                response.add(this.getAttribute(names[i]));
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return response;
    }

    public MBeanInfo getMBeanInfo() {
        return (MBeanInfo)this.info.clone();
    }

    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Method name is null"), "Method name is null");
        }
        if (params == null) {
            params = new Object[]{};
        }
        if (signature == null) {
            signature = new String[]{};
        }
        if (params.length != signature.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Inconsistent arguments and signature"), "Inconsistent arguments and signature");
        }
        ModelMBeanOperationInfo opInfo = this.info.getOperation(name);
        if (opInfo == null) {
            throw new MBeanException(new ServiceNotFoundException("Cannot find operation " + name), "Cannot find operation " + name);
        }
        Class[] types = new Class[signature.length];
        int i = 0;
        while (i < signature.length) {
            if (signature[i].equals(Boolean.TYPE.getName())) {
                types[i] = Boolean.TYPE;
            } else if (signature[i].equals(Byte.TYPE.getName())) {
                types[i] = Byte.TYPE;
            } else if (signature[i].equals(Character.TYPE.getName())) {
                types[i] = Character.TYPE;
            } else if (signature[i].equals(Double.TYPE.getName())) {
                types[i] = Double.TYPE;
            } else if (signature[i].equals(Float.TYPE.getName())) {
                types[i] = Float.TYPE;
            } else if (signature[i].equals(Integer.TYPE.getName())) {
                types[i] = Integer.TYPE;
            } else if (signature[i].equals(Long.TYPE.getName())) {
                types[i] = Long.TYPE;
            } else if (signature[i].equals(Short.TYPE.getName())) {
                types[i] = Short.TYPE;
            } else {
                try {
                    types[i] = Class.forName(signature[i]);
                }
                catch (ClassNotFoundException e) {
                    throw new ReflectionException(e, "Cannot find Class for " + signature[i]);
                }
            }
            ++i;
        }
        Method method = null;
        Object object = null;
        NoSuchMethodException exception = null;
        try {
            object = this;
            method = object.getClass().getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            exception = e;
        }
        try {
            if (method == null && this.resource != null) {
                object = this.resource;
                method = object.getClass().getMethod(name, types);
            }
        }
        catch (NoSuchMethodException e) {
            exception = e;
        }
        if (method == null) {
            throw new ReflectionException(exception, "Cannot find method " + name + " with this signature");
        }
        Object result = null;
        try {
            result = method.invoke(object, params);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)t, "Exception invoking method " + name);
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error invoking method " + name);
            }
            throw new MBeanException(e, "Exception invoking method " + name);
        }
        catch (Exception e) {
            throw new MBeanException(e, "Exception invoking method " + name);
        }
        return result;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute is null"), "Attribute is null");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name is null"), "Attribute name is null");
        }
        ModelMBeanAttributeInfo attrInfo = this.info.getAttribute(name);
        if (attrInfo == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + name);
        }
        Descriptor attrDesc = attrInfo.getDescriptor();
        if (attrDesc == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + name + " descriptor");
        }
        String setMethod = (String)attrDesc.getFieldValue("setMethod");
        if (setMethod == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + name + " set method name");
        }
        this.invoke(setMethod, new Object[]{value}, new String[]{attrInfo.getType()});
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes list is null"), "Attributes list is null");
        }
        AttributeList response = new AttributeList();
        String[] names = new String[attributes.size()];
        int n = 0;
        Iterator items = ((AbstractList)attributes).iterator();
        while (items.hasNext()) {
            Attribute item = (Attribute)items.next();
            names[n++] = item.getName();
            try {
                this.setAttribute(item);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.getAttributes(names);
    }

    public Object getManagedResource() throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        if (this.resource == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Managed resource is null"), "Managed resource is null");
        }
        return this.resource;
    }

    public void setManagedResource(Object resource, String type) throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        if (resource == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Managed resource is null"), "Managed resource is null");
        }
        if (!"objectreference".equalsIgnoreCase(type)) {
            throw new InvalidTargetObjectTypeException(type);
        }
        this.resource = resource;
    }

    public void setModelMBeanInfo(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        if (info == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo is null"), "ModelMBeanInfo is null");
        }
        if (!this.isModelMBeanInfoValid(info)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo is invalid"), "ModelMBeanInfo is invalid");
        }
        this.info = (ModelMBeanInfo)info.clone();
    }

    public void addAttributeChangeNotificationListener(NotificationListener listener, String name, Object handback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        BaseAttributeFilter filter = new BaseAttributeFilter(name);
        this.attributeBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String name) throws ListenerNotFoundException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        this.attributeBroadcaster.removeNotificationListener(listener);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws ListenerNotFoundException {
        this.removeAttributeChangeNotificationListener(listener, attributeName);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification is null"), "Notification is null");
        }
        if (this.attributeBroadcaster == null) {
            return;
        }
        this.attributeBroadcaster.sendNotification(notification);
    }

    public void sendAttributeChangeNotification(Attribute oldValue, Attribute newValue) throws MBeanException, RuntimeOperationsException {
        String type = null;
        if (newValue.getValue() != null) {
            type = newValue.getValue().getClass().getName();
        } else if (oldValue.getValue() != null) {
            type = oldValue.getValue().getClass().getName();
        } else {
            return;
        }
        AttributeChangeNotification notification = new AttributeChangeNotification(this, 1L, System.currentTimeMillis(), "Attribute value has changed", oldValue.getName(), type, oldValue.getValue(), newValue.getValue());
        this.sendAttributeChangeNotification(notification);
    }

    public void sendNotification(Notification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification is null"), "Notification is null");
        }
        if (this.generalBroadcaster == null) {
            return;
        }
        this.generalBroadcaster.sendNotification(notification);
    }

    public void sendNotification(String message) throws MBeanException, RuntimeOperationsException {
        if (message == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Message is null"), "Message is null");
        }
        Notification notification = new Notification("jmx.modelmbean.generic", (Object)this, 1L, message);
        this.sendNotification(notification);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new BaseNotificationBroadcaster();
        }
        this.generalBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] current = this.info.getNotifications();
        if (current == null) {
            current = new MBeanNotificationInfo[]{};
        }
        MBeanNotificationInfo[] response = new MBeanNotificationInfo[current.length + 2];
        DescriptorSupport descriptor = null;
        descriptor = new DescriptorSupport("name=GENERIC", "descriptorType=notification", "log=T", "severity=5", "displayName=jmx.modelmbean.generic");
        response[0] = new ModelMBeanNotificationInfo(new String[]{"jmx.modelmbean.generic"}, "GENERIC", "Text message notification from the managed resource", descriptor);
        descriptor = new DescriptorSupport("name=ATTRIBUTE_CHANGE", "descriptorType=notification", "log=T", "severity=5", "displayName=jmx.attribute.change");
        response[1] = new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "ATTRIBUTE_CHANGE", "Observed MBean attribute value has changed", descriptor);
        System.arraycopy(current, 0, response, 2, current.length);
        return response;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new BaseNotificationBroadcaster();
        }
        this.generalBroadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, Object handback) throws ListenerNotFoundException {
        this.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.removeNotificationListener(listener);
    }

    public void load() throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        throw new MBeanException(new IllegalStateException("Persistence is not supported"), "Persistence is not supported");
    }

    public void store() throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        throw new MBeanException(new IllegalStateException("Persistence is not supported"), "Persistence is not supported");
    }

    protected ModelMBeanInfo createDefaultModelMBeanInfo() {
        return new ModelMBeanInfoSupport(this.getClass().getName(), "Default ModelMBean", null, null, null, null);
    }

    protected boolean isModelMBeanInfoValid(ModelMBeanInfo info) {
        return true;
    }
}

