unit General;

interface

Uses Lists, FileCtrl, Classes, Forms, Windows, SysUtils;

function ExtendedDelete(TheDelPath:String):Boolean;
function ExtendedCopy(Source,Destination:String;EraseDes:Boolean):Boolean;
function StrFindChar(S:String;Ch:Char;FromPos:Word):Word;

implementation

function ExtendedDelete(TheDelPath:String):Boolean;
var
  i,j:integer;
  FileList:TStringList;
begin
  ExtendedDelete:=True;

  if not DirectoryExists(TheDelPath) then
  begin
    ExtendedDelete:=False; // source directory does not exists
    Exit;
  end;
  Application.CreateForm(TListsForm,ListsForm);
  with ListsForm.TheFileList do
  begin
    Drive:=Char(TheDelPath[1]);
    Directory:=TheDelPath;
  end;

  with ListsForm.TheDirList do
  begin
    Drive:=Char(TheDelPath[1]);
    Directory:=TheDelPath;
    OpenCurrent;
  end;

  TheSrcList:=TStringList.Create;
  TheSrcList.Add(TheDelPath); // first folder to copy in the list
  DigIn(TheDelPath,'',False); // No CopyOperation - don't use the 'TheDesList' var

  // in order to enable the delete directory we must move to another folder otherwise the delete will fail.
  ListsForm.TheDirList.Drive:='c';
  ListsForm.TheDirList.Directory:='c:\';
  ListsForm.TheDirList.OpenCurrent;

  FileList:=TStringList.Create;
  for i:=TheSrcList.Count-1 downto 0 do
  begin
    ListsForm.TheFileList.Drive:=Char(TheSrcList.Strings[i][1]);
    ListsForm.TheFileList.Directory:=TheSrcList.Strings[i];
    // in order to enable the delete directory we must move to another folder otherwise the delete will fail.
    FileList.Clear;
    for j:=0 to (ListsForm.TheFileList.Items.Count-1) do
    begin
      FileList.Add(ListsForm.TheFileList.Items.Strings[j]);
    end;
    ListsForm.TheFileList.Drive:='c';
    ListsForm.TheFileList.Directory:='c:\';
    for j:=0 to (FileList.Count-1) do
    begin
      SetFileAttributes(PChar(TheSrcList.Strings[i]+'\'+FileList.Strings[j]),FILE_ATTRIBUTE_ARCHIVE);
      DeleteFile(TheSrcList.Strings[i]+'\'+FileList.Strings[j]);
    end;
    RemoveDir(TheSrcList.Strings[i]); // deletes the current folder
  end;
  TheSrcList.Free;
  FileList.Free;
  ListsForm.Free;
end;

function ExtendedCopy(Source,Destination:String;EraseDes:Boolean):Boolean;
var
  i,j:integer;
begin
  ExtendedCopy:=True;

  if not DirectoryExists(Source) then
  begin
    ExtendedCopy:=False; // source directory does not exists
    Exit;
  end;

  if DirectoryExists(Destination) and EraseDes then
  begin
    ExtendedDelete(Destination); // To provide a clean copy
  end;

  Application.CreateForm(TListsForm,ListsForm);
  with ListsForm.TheFileList do
  begin
    Drive:=Char(Source[1]);
    Directory:=Source;
  end;

  with ListsForm.TheDirList do
  begin
    Drive:=Char(Source[1]);
    Directory:=Source;
    OpenCurrent;
  end;

  TheSrcList:=TStringList.Create;
  TheDesList:=TStringList.Create;
  TheSrcList.Add(Source); // first folder to copy in the list
  TheDesList.Add(Destination); // first folder to copy in the list

  DigIn(Source,Destination,True); // copyoperation enabled

  for i:=0 to TheSrcList.Count-1 do
  begin
    ListsForm.TheFileList.Drive:=Char(TheSrcList.Strings[i][1]);
    ListsForm.TheFileList.Directory:=TheSrcList.Strings[i];
    if not DirectoryExists(TheDesList.Strings[i]) then
      ForceDirectories(TheDesList.Strings[i]);
    if ListsForm.TheFileList.Items.Count>0 then
    begin
      for j:=0 to (ListsForm.TheFileList.Items.Count-1) do
      begin //           src folder                   src file                       des folder                   des file
        CopyFile(PChar(TheSrcList.Strings[i]+'\'+ListsForm.TheFileList.Items[j]),PChar(TheDesList.Strings[i]+'\'+ListsForm.TheFileList.Items[j]),False); // overwrite if exists
      end;
    end
  end;
  TheSrcList.Free;
  ListsForm.Free;
end;

function StrFindChar(S:String;Ch:Char;FromPos:Word):Word;
var
  L,i,Count:integer;
begin
  L:=Length(S);
  Count:=FromPos-1;
  for i:=FromPos to L do
  begin
    if S[i]=Ch then
      Break
    else
      Inc(Count);
  end;
  if Count=L then
    i:=0;
  StrFindChar:=i;
end;


end.
