unit Installs;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, IniFiles, ComCtrls;

type
  TInstallsForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    TheListView: TListView;
    AddBtn: TButton;
    RemoveBtn: TButton;
    procedure FormShow(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure RemoveBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  InstallsForm: TInstallsForm;
  TheIniFile:TIniFile;

implementation

Uses InstDataM, General;

{$R *.DFM}

procedure TInstallsForm.FormShow(Sender: TObject);
var
  i:integer;
  TheListItem:TListItem;
  Flag_Stop:Boolean;
begin
  TheListView.Items.Clear;
  if not FileExists(ExtractFilePath(Application.ExeName)+'Installs\Details.ini') then
    Exit;
  TheIniFile:=TIniFile.Create(ExtractFilePath(Application.ExeName)+'Installs\Details.ini');

  i:=0;
  Flag_Stop:=False;
  While not Flag_Stop do
  begin
    if TheIniFile.ReadString('Buttons','Install'+IntToStr(i),'')<>'' then
    begin
      TheListItem:=TheListView.Items.Add;
      TheListItem.Caption:=TheIniFile.ReadString('Buttons','Install'+IntToStr(i),'');

      if TheIniFile.ReadString('Descriptions','Install'+IntToStr(i),'')<>'' then
        TheListItem.SubItems.Add(TheIniFile.ReadString('Descriptions','Install'+IntToStr(i),''));

      if TheIniFile.ReadString('Actions','Install'+IntToStr(i),'')<>'' then
        TheListItem.SubItems.Add(TheIniFile.ReadString('Actions','Install'+IntToStr(i),''));
    end
    else
      Flag_Stop:=True;
    Inc(i);
  end;
end;

procedure TInstallsForm.AddBtnClick(Sender: TObject);
var
  FolderS,
  DesS:String;
  i:integer;
begin
  InstDataModule.InstOpenDialog.Title:='Add to the Install Maker''s list';
  InstDataModule.InstOpenDialog.Filter:='';
  InstDataModule.InstOpenDialog.InitialDir:=ExtractFilePath(Application.ExeName);
  InstDataModule.InstOpenDialog.FileName:='';

  if not InstDataModule.InstOpenDialog.Execute then Exit;

  FolderS:=InputBox('Add','Folder''s name','');
  DesS:=InputBox('Add','Description',FolderS);

  ExtendedCopy(ExtractFilePath(InstDataModule.InstOpenDialog.FileName),ExtractFilePath(Application.ExeName)+'Installs\'+FolderS,True);

  if not FileExists(ExtractFilePath(Application.ExeName)+'Installs\Details.ini') then Exit;

  TheIniFile:=TIniFile.Create(ExtractFilePath(Application.ExeName)+'Installs\Details.ini');

  i:=0;
  While TheIniFile.ReadString('Buttons','Install'+IntToStr(i),'')<>'' do Inc(i);

  TheIniFile.WriteString('Buttons','Install'+IntToStr(i),FolderS);
  TheIniFile.WriteString('Descriptions','Install'+IntToStr(i),DesS);
  TheIniFile.WriteString('Actions','Install'+IntToStr(i),ExtractFilePath(Application.ExeName)+'Installs\'+ExtractFileName(InstDataModule.InstOpenDialog.FileName));
  TheIniFile.Free;

  FormShow(Sender);
end;

procedure TInstallsForm.RemoveBtnClick(Sender: TObject);
var
  j,i:Byte;
  TempIniFile:TIniFile;
begin
  if MessageDlg('Are you sure you want to remove the Checked items?',mtConfirmation,[mbYes,mbNo],0)=mrNo then Exit;

  if not FileExists(ExtractFilePath(Application.ExeName)+'Installs\Details.ini') then Exit;

  TheIniFile:=TIniFile.Create(ExtractFilePath(Application.ExeName)+'Installs\Details.ini');

  TempIniFile:=TIniFile.Create(ExtractFilePath(Application.ExeName)+'Installs\TempDetails.ini');
  j:=0;
  for i:=0 to TheListView.Items.Count-1 do
  begin
    if not InstallsForm.TheListView.Items.Item[i].Checked then
    begin
      TempIniFile.WriteString('Buttons','Install'+IntToStr(j),TheIniFile.ReadString('Buttons','Install'+IntToStr(i),''));
      TempIniFile.WriteString('Descriptions','Install'+IntToStr(j),TheIniFile.ReadString('Descriptions','Install'+IntToStr(i),''));
      TempIniFile.WriteString('Actions','Install'+IntToStr(j),TheIniFile.ReadString('Actions','Install'+IntToStr(i),''));
      Inc(j);
    end;
  end;
  TheIniFile.Free;
  TempIniFile.Free;

  CopyFile(PChar(ExtractFilePath(Application.ExeName)+'Installs\TempDetails.ini'),PChar(ExtractFilePath(Application.ExeName)+'Installs\Details.ini'),False);
  DeleteFile(ExtractFilePath(Application.ExeName)+'Installs\TempDetails.ini');

  FormShow(Sender);
end;

end.
