unit Lists;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FileCtrl, StdCtrls;

type
  TListsForm = class(TForm)
    TheFileList: TFileListBox;
    TheDirList: TDirectoryListBox;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ListsForm: TListsForm;
  TheSrcList:TStringList;
  TheDesList:TStringList;

procedure DigIn(TheSrcPath,TheDesPath:String;CopyOperation:Boolean); // retrieves the whole subdirectories in the given Path and puts it in TStringList TheList (Created in ExtendedCopy) this procedure is used by ExtendedCopy


implementation

{$R *.DFM}

procedure DigIn(TheSrcPath,TheDesPath:String;CopyOperation:Boolean);
var
  i,j:integer;
  TempList:TStringList;
begin
  TempList:=TStringList.Create;
  ListsForm.TheDirList.Drive:=TheSrcPath[1];
  ListsForm.TheDirList.Directory:=TheSrcPath;
  ListsForm.TheDirList.OpenCurrent;

  for i:=(ListsForm.TheDirList.ItemIndex+1) to (ListsForm.TheDirList.Items.Count-1) do
  begin
    TheSrcList.Add(TheSrcPath+'\'+ListsForm.TheDirList.Items[i]);
    if CopyOperation then
      TheDesList.Add(TheDesPath+'\'+ListsForm.TheDirList.Items[i]);
    TempList.Add(ListsForm.TheDirList.Items[i]);
  end;

  if TempList.Count>0 then
    for j:=0 to TempList.Count-1 do
      DigIn(TheSrcPath+'\'+TempList.Strings[j],TheDesPath+'\'+TempList.Strings[j],CopyOperation);

  TempList.Free;
end;

end.

