unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, IniFiles, Menus, FileCtrl, ExtCtrls;

type
  TInstMakerForm = class(TForm)
    Button11: TButton;
    Button12: TButton;
    Button9: TButton;
    InstMainMenu: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save2: TMenuItem;
    Save1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    TitleEdit: TEdit;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit4: TEdit;
    Edit3: TEdit;
    Edit8: TEdit;
    Edit7: TEdit;
    Edit6: TEdit;
    Edit5: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox6: TCheckBox;
    Button1: TButton;
    Button2: TButton;
    Button4: TButton;
    Button3: TButton;
    Button6: TButton;
    Button5: TButton;
    Button8: TButton;
    Button7: TButton;
    Edit1Des: TEdit;
    Edit2Des: TEdit;
    Edit3Des: TEdit;
    Edit4Des: TEdit;
    Edit5Des: TEdit;
    Edit6Des: TEdit;
    Edit7Des: TEdit;
    Edit8Des: TEdit;
    Preview1: TMenuItem;
    Options1: TMenuItem;
    Button10: TButton;
    Build1: TMenuItem;
    Installs1: TMenuItem;
    ButtonsPopupMenu: TPopupMenu;
    InsertFromInstalls1: TMenuItem;
    ClearButton1: TMenuItem;
    procedure Button12Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Preview1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure InstActionOpen(Sender: TObject);
    procedure SaveProject(Sender: TObject);
    procedure BringOptions(Sender: TObject);
    procedure BuildProject(Sender: TObject);
    procedure SaveAsProject(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Installs1Click(Sender: TObject);
    procedure InsertFromInstalls1Click(Sender: TObject);
    procedure TakeTheIndex(Sender: TObject);
    procedure Edit1ContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure ClearButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    procedure WriteIni;
    procedure ReadIni;
    function CreateNewProject(NameOfProject:String):Boolean;
    procedure MakeUnAvialiable;
    procedure MakeAvialiable;
    procedure InsertPrograms;
    procedure Add2Log(TheStr:String);
    { Public declarations }
  end;

var
  InstMakerForm: TInstMakerForm;
  InstMakerINI:TIniFile;
  DemoFile,CurrentProjectName:String;
  ButtonIndex:Byte;


implementation

Uses General, New, Options, InstDataM, MainPrev, Log, Installs;

{$R *.DFM}

procedure TInstMakerForm.FormShow(Sender: TObject);
begin
  MakeUnAvialiable;
end;

procedure TInstMakerForm.Button12Click(Sender: TObject);
begin
  Close;
end;

procedure TInstMakerForm.New1Click(Sender: TObject);
begin
  New.NewForm.Caption:='New Project';
  if (New.NewForm.ShowModal=mrYes) and (New.NewForm.Edit1.Text<>'') then
  begin
    if not CreateNewProject(New.NewForm.Edit1.Text) then
    begin
      MakeUnAvialiable;
      ShowMessage('Project Allready Exists!!');
    end
    else
      MakeAvialiable;
  end;
end;

procedure TInstMakerForm.InstActionOpen(Sender: TObject);
begin
  TakeTheIndex(Sender);
  InstDataModule.InstOpenDialog.Title:=TEdit(FindComponent('Edit'+IntToStr(ButtonIndex))).Text;
  InstDataModule.InstOpenDialog.Filter:='';
  InstDataModule.InstOpenDialog.InitialDir:=ExtractFilePath(TButton(FindComponent('Button'+IntToStr(ButtonIndex))).Hint);
  if InstDataModule.InstOpenDialog.Execute then
    TButton(FindComponent('Button'+IntToStr(ButtonIndex))).Hint:=InstDataModule.InstOpenDialog.FileName;
end;

procedure TInstMakerForm.WriteIni;
var
  i:integer;
begin
  Add2Log('Creating Project Directory...');
  if not DirectoryExists(ExtractFilePath(Application.ExeName)+CurrentProjectName) then
  begin
    CreateDir(ExtractFilePath(Application.ExeName)+CurrentProjectName);
    Add2Log(' # New Directory Created.');
  end
  else
    Add2Log(' # Directory allready exists.');

  Add2Log('.');
  Add2Log('Creating LUM File...');
  InstMakerINI:=TIniFile.Create(ExtractFilePath(Application.ExeName)+CurrentProjectName+'\InstAP.Lum');
  With InstMakerINI do
  begin
    WriteString('Title','Caption',TitleEdit.Text);

    WriteString('Options','DemoFileName',DemoFile);

    for i:=1 to 8 do
    begin
      WriteString('ButtonsCaption','Button'+IntToStr(i)+'Caption',TEdit(FindComponent('Edit'+IntToStr(i))).Text);
      WriteString('ButtonsDescription','Button'+IntToStr(i)+'Description',TEdit(FindComponent('Edit'+IntToStr(i)+'Des')).Text);
      WriteString('ButtonsAction','Button'+IntToStr(i)+'Action','Inst0'+IntToStr(i)+'\'+ExtractFileName(TButton(FindComponent('Button'+IntToStr(i))).Hint));

      WriteString('History','ActionTakenFrom'+IntToStr(i),TButton(FindComponent('Button'+IntToStr(i))).Hint);

      if TCheckBox(FindComponent('CheckBox'+IntToStr(i))).Checked and
         (TEdit(FindComponent('Edit'+IntToStr(i))).Text<>'') then
        WriteString('ButtonsVisible','Button'+IntToStr(i)+'Visible','True')
      else
        WriteString('ButtonsVisible','Button'+IntToStr(i)+'Visible','False');
    end;
  end;
  InstMakerINI.Free;
  Add2Log(' # LUM file Created.');
end;

procedure TInstMakerForm.ReadIni;
var
  i:integer;
begin
  if not FileExists(ExtractFilePath(Application.ExeName)+CurrentProjectName+'\InstAP.Lum') then
    Exit;
  InstMakerINI:=TIniFile.Create(ExtractFilePath(Application.ExeName)+CurrentProjectName+'\InstAP.Lum');
  With InstMakerINI do
  begin
    TitleEdit.Text:=ReadString('Title','Caption','');

    DemoFile:=ReadString('Options','DemoFileName','');
    Options.OptionsForm.DemoFileEdit.Text:=DemoFile;
    
    for i:=1 to 8 do
    begin
      TEdit(FindComponent('Edit'+IntToStr(i))).Text:=ReadString('ButtonsCaption','Button'+IntToStr(i)+'Caption','');
      TEdit(FindComponent('Edit'+IntToStr(i)+'Des')).Text:=ReadString('ButtonsDescription','Button'+IntToStr(i)+'Description','');
      ReadString('ButtonsAction','Button'+IntToStr(i)+'Action','');

      TButton(FindComponent('Button'+IntToStr(i))).Hint:=ReadString('History','ActionTakenFrom'+IntToStr(i),'');

      if ReadString('ButtonsVisible','Button'+IntToStr(i)+'Visible','True')='True' then
        TCheckBox(FindComponent('CheckBox'+IntToStr(i))).Checked:=True
      else
        TCheckBox(FindComponent('CheckBox'+IntToStr(i))).Checked:=False;
    end;
  end;
  InstMakerINI.Free;
end;

function TInstMakerForm.CreateNewProject(NameOfProject: String): Boolean;
begin
  if DirectoryExists(ExtractFilePath(Application.ExeName)+NameOfProject) then
    CreateNewProject:=False
  else
    CreateNewProject:=True;
  CurrentProjectName:=NameOfProject;
end;

// Create a dir in the project dir ...
// ex: ApplicationPath\NewProject\inst01  - button1
//     ApplicationPath\NewProject\inst02  - button2
procedure TInstMakerForm.InsertPrograms;
var
  i:byte;
  TempPath:String;
begin
  Add2Log('.');
  Add2Log('Copying common files...');
  // copying common files - contains the common bitmap files.
  TempPath:=ExtractFilePath(Application.ExeName)+CurrentProjectName+'\Wiz';
  if DirectoryExists(ExtractFilePath(Application.ExeName)+'Wiz') then
  begin
    ExtendedCopy(ExtractFilePath(Application.ExeName)+'Wiz',TempPath,True);
    Add2Log(' # Done.');
  end
  else
  begin
    Add2Log(' # Error: Wiz directory does not exists!');
  end;
  Add2Log('.');

  Add2Log('Copying Logo file...');
  // -=============================-
  // Logo file copy
  TempPath:=ExtractFilePath(Application.ExeName)+CurrentProjectName+'\InstDemo\'+ExtractFileName(DemoFile);
  if DemoFile<>'' then
  begin
    if not DirectoryExists(ExtractFilePath(TempPath)) then CreateDir(ExtractFilePath(TempPath));
    if not CopyFile(PChar(DemoFile),PChar(TempPath),True) then
      Add2Log(' # Warning: Selected demo directory does not exists!')
    else
      Add2Log(' # Done.');
  end;
  Add2Log('.');

  Add2Log('Copying Installer.exe file...');
  // -=============================-
  // installer program copy
  if FileExists(ExtractFilePath(Application.ExeName)+'installer.exe') then
  begin
    CopyFile(PChar(ExtractFilePath(Application.ExeName)+'installer.exe'),PChar(ExtractFilePath(Application.ExeName)+CurrentProjectName+'\installer.exe'),False);
    Add2Log(' # Done.');
  end
  else
  begin
    Add2Log(' # Error: Installer.exe does not exists!');
  end;

  Add2Log('.');
  Add2Log('Copying Autorun.inf file...');

  if FileExists(ExtractFilePath(Application.ExeName)+'Autorun.inf') then
  begin
    CopyFile(PChar(ExtractFilePath(Application.ExeName)+'Autorun.inf'),PChar(ExtractFilePath(Application.ExeName)+CurrentProjectName+'\Autorun.inf'),False);
    Add2Log(' # Done.');
  end
  else
  begin
    Add2Log(' # Error: Autorun.inf does not exists!');
  end;


  Add2Log('.');
  Add2Log('Creating Buttons Directories...');
  // -=============================-
  // creating button folders
  for i:=1 to 8 do
  begin
    if TButton(FindComponent('Button'+IntToStr(i))).Hint='' then Continue;
    TempPath:=ExtractFilePath(Application.ExeName)+CurrentProjectName+'\'+'Inst0'+IntToStr(i);
    ExtendedDelete(TempPath);
    if TCheckBox(FindComponent('CheckBox'+IntToStr(i))).Checked then
      if DirectoryExists(ExtractFilePath(TButton(FindComponent('Button'+IntToStr(i))).Hint)) then
        ExtendedCopy(ExtractFilePath(TButton(FindComponent('Button'+IntToStr(i))).Hint),TempPath,True)
      else
        Add2Log('   ** Wanrning Folder :'+ExtractFilePath(TButton(FindComponent('Button'+IntToStr(i))).Hint)+'Does not Exists!');
  end;
  Add2Log(' # Done.');
end;

procedure TInstMakerForm.MakeAvialiable;
begin
  Panel1.Enabled:=True;
  Button9.Enabled:=True;
  Button10.Enabled:=True;
  Button11.Enabled:=True;
  Options1.Enabled:=True;
  Preview1.Enabled:=True;
  Installs1.Enabled:=True;
  Build1.Enabled:=True;
end;

procedure TInstMakerForm.MakeUnAvialiable;
begin
  Panel1.Enabled:=False;
  Button9.Enabled:=False;
  Button10.Enabled:=False;
  Button11.Enabled:=False;
  Options1.Enabled:=False;
  Preview1.Enabled:=False;
  Installs1.Enabled:=False;
  Build1.Enabled:=False;
end;

procedure TInstMakerForm.Open1Click(Sender: TObject);
var
  Drive:Char;
  Path,FileName:String;
  FoundPos,j:ShortInt;
begin
  InstDataModule.InstOpenDialog.Title:='Open Project';
  InstDataModule.InstOpenDialog.Filter:='Lum Files|*.lum';
  InstDataModule.InstOpenDialog.InitialDir:=ExtractFilePath(Application.ExeName);
  if not InstDataModule.InstOpenDialog.Execute then
    Exit;
  ProcessPath(InstDataModule.InstOpenDialog.FileName,Drive,Path,FileName); // take apart the full filename
  j:=1;
  FoundPos:=1;
  While j>0 do
  begin
    FoundPos:=j;
    j:=StrFindChar(Path,'\',FoundPos+1);
  end;
  CurrentProjectName:=Copy(Path,FoundPos+1,Length(Path)-FoundPos);
  ReadIni;
  MakeAvialiable;
end;

procedure TInstMakerForm.Preview1Click(Sender: TObject);
begin
  if not DirectoryExists(ExtractFilePath(Application.ExeName)+CurrentProjectName) then
  begin
    if MessageDlg('Project not saved! Do you wish to save & build it in order to preview?',mtConfirmation,[mbYes,mbNo],0)=mrYes then
    begin
      SaveProject(Sender);
      BuildProject(Sender);
    end
    else
      Exit;
  end;
  MainPrev.GivenProject:=CurrentProjectName;
  MainPrev.MainForm.ShowModal;
end;

procedure TInstMakerForm.About1Click(Sender: TObject);
begin
  InstDataModule.InstAboutDlg.Execute;
end;

procedure TInstMakerForm.Add2Log(TheStr: String);
begin
  LogForm.LogListBox.Items.Add(TheStr);
  LogForm.LogListBox.Refresh;
end;

procedure TInstMakerForm.SaveProject(Sender: TObject);
begin
  if CurrentProjectName='' then
    Exit;
  LogForm.LogListBox.Items.Clear;
  LogForm.Button1.Enabled:=False;
  LogForm.Show;
  LogForm.Refresh;
  WriteIni;
  LogForm.Button1.Enabled:=True;
end;

procedure TInstMakerForm.BringOptions(Sender: TObject);
begin
  Options.OptionsForm.ShowModal;
  DemoFile:=Options.OptionsForm.DemoFileEdit.Text;
end;

procedure TInstMakerForm.BuildProject(Sender: TObject);
begin
  if CurrentProjectName='' then
    Exit;
  LogForm.LogListBox.Items.Clear;
  LogForm.Button1.Enabled:=False;
  LogForm.Show;
  LogForm.Refresh;
  WriteIni;

  LogForm.Button1.Enabled:=False;
  LogForm.Show;
  LogForm.Refresh;
  InsertPrograms;
  LogForm.Button1.Enabled:=True;
end;

procedure TInstMakerForm.SaveAsProject(Sender: TObject);
begin
  if CurrentProjectName='' then
    Exit;
  New.NewForm.Caption:='Save As...';
  if (New.NewForm.ShowModal=mrYes) and (New.NewForm.Edit1.Text<>'') then
  begin
    if not CreateNewProject(New.NewForm.Edit1.Text) then
    begin
      MakeUnAvialiable;
      ShowMessage('Project Allready Exists!!');
    end
    else
      MakeAvialiable;
  end;
end;

procedure TInstMakerForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TInstMakerForm.Installs1Click(Sender: TObject);
var
  i,j:integer;
begin
  if InstallsForm.ShowModal=mrOk then
  begin
    j:=1;
    for i:=0 to InstallsForm.TheListView.Items.Count-1 do
    begin
      if InstallsForm.TheListView.Items.Item[i].Checked then
      begin
        TEdit(FindComponent('Edit'+IntToStr(j))).Text:=InstallsForm.TheListView.Items.Item[i].Caption;
        TEdit(FindComponent('Edit'+IntToStr(j)+'Des')).Text:=InstallsForm.TheListView.Items.Item[i].SubItems[0];
        TButton(FindComponent('Button'+IntToStr(j))).Hint:=ExtractFilePath(Application.ExeName)+'Installs\'+InstallsForm.TheListView.Items.Item[i].SubItems[1];
        TCheckBox(FindComponent('CheckBox'+IntToStr(j))).Checked:=True;
        Inc(j);
      end;
    end;
  end;
end;

procedure TInstMakerForm.InsertFromInstalls1Click(Sender: TObject);
var
  j,i:Byte;
begin
  if InstallsForm.ShowModal<>mrOk then
    Exit;
  j:=ButtonIndex;
  for i:=0 to InstallsForm.TheListView.Items.Count-1 do
  begin
    if InstallsForm.TheListView.Items.Item[i].Checked then
    begin
      TEdit(FindComponent('Edit'+IntToStr(j))).Text:=InstallsForm.TheListView.Items.Item[i].Caption;
      TEdit(FindComponent('Edit'+IntToStr(j)+'Des')).Text:=InstallsForm.TheListView.Items.Item[i].SubItems[0];
      TButton(FindComponent('Button'+IntToStr(j))).Hint:=ExtractFilePath(Application.ExeName)+'Installs\'+InstallsForm.TheListView.Items.Item[i].SubItems[1];
      TCheckBox(FindComponent('CheckBox'+IntToStr(j))).Checked:=True;
      Inc(j);
    end;
  end;
end;

// could be replaced by tag property... but need to set the tag also
procedure TInstMakerForm.TakeTheIndex(Sender: TObject);
begin
  ButtonIndex:=0;

  if Sender=Button1 then
    ButtonIndex:=1;
  if Sender=Button2 then
    ButtonIndex:=2;
  if Sender=Button3 then
    ButtonIndex:=3;
  if Sender=Button4 then
    ButtonIndex:=4;
  if Sender=Button5 then
    ButtonIndex:=5;
  if Sender=Button6 then
    ButtonIndex:=6;
  if Sender=Button7 then
    ButtonIndex:=7;
  if Sender=Button8 then
    ButtonIndex:=8;

  if Sender=Edit1 then
    ButtonIndex:=1;
  if Sender=Edit2 then
    ButtonIndex:=2;
  if Sender=Edit3 then
    ButtonIndex:=3;
  if Sender=Edit4 then
    ButtonIndex:=4;
  if Sender=Edit5 then
    ButtonIndex:=5;
  if Sender=Edit6 then
    ButtonIndex:=6;
  if Sender=Edit7 then
    ButtonIndex:=7;
  if Sender=Edit8 then
    ButtonIndex:=8;

  if Sender=Edit1Des then
    ButtonIndex:=1;
  if Sender=Edit2Des then
    ButtonIndex:=2;
  if Sender=Edit3Des then
    ButtonIndex:=3;
  if Sender=Edit4Des then
    ButtonIndex:=4;
  if Sender=Edit5Des then
    ButtonIndex:=5;
  if Sender=Edit6Des then
    ButtonIndex:=6;
  if Sender=Edit7Des then
    ButtonIndex:=7;
  if Sender=Edit8Des then
    ButtonIndex:=8;
end;

procedure TInstMakerForm.Edit1ContextPopup(Sender: TObject;
  MousePos: TPoint; var Handled: Boolean);
begin
  TakeTheIndex(Sender);
end;

procedure TInstMakerForm.ClearButton1Click(Sender: TObject);
begin
  TEdit(FindComponent('Edit'+IntToStr(ButtonIndex))).Text:='';
  TEdit(FindComponent('Edit'+IntToStr(ButtonIndex)+'Des')).Text:='';
  TButton(FindComponent('Button'+IntToStr(ButtonIndex))).Hint:='';
  TCheckBox(FindComponent('CheckBox'+IntToStr(ButtonIndex))).Checked:=False;
end;

end.
