unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  lmdctrl, lmdextcS, ExtCtrls, lmdbtn, lmdcctrl, lmdctrlA, 
  StdCtrls, IniFiles;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    LMDPanelFill1: TLMDPanelFill;
    Button1: TLMDSpeedButton;
    Button2: TLMDSpeedButton;
    Button3: TLMDSpeedButton;
    Button4: TLMDSpeedButton;
    Button5: TLMDSpeedButton;
    Button6: TLMDSpeedButton;
    Button7: TLMDSpeedButton;
    LMDSpeedButton0: TLMDSpeedButton;
    Button8: TLMDSpeedButton;
    LMDPanelFill2: TLMDPanelFill;
    TitleLabel: TLabel;
    Panel5: TPanel;
    LMDPanelFill3: TLMDPanelFill;
    DesLabel: TLabel;
    LogoImage: TImage;
    Label1: TLabel;
    procedure LMDSpeedButton0Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure LMDSpeedButton0MouseEnter(Sender: TObject);
    procedure LMDSpeedButton0MouseExit(Sender: TObject);
    procedure ClearDesLabel(Sender: TObject);
    procedure CallAction(Sender: TObject);
    procedure CallDes(Sender: TObject);
  private
    { Private declarations }
  public
    procedure ReadIniFile;
    procedure InitBitmap;
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  InstIniFile:TIniFile;
  ExitGlyph:TBitmap;
  ArrayOfButtonDes:Array [1..8] of String;

implementation

Uses InstDataM;

{$R *.DFM}

procedure TMainForm.LMDSpeedButton0Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  InitBitmap;
  ReadIniFile;
end;

procedure TMainForm.ReadIniFile;
var
  i:Byte;
begin
  InstIniFile:=TIniFile.Create(ExtractFilePath(Application.ExeName)+'InstAP.Lum');
  With InstIniFile do
  begin
    TitleLabel.Caption:=ReadString('Title','Caption','');
    if ReadString('Options','DemoFileName','')<>'' then
      LogoImage.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+'\InstDemo\'+ExtractFileName(ReadString('Options','DemoFileName','')));
    for i:=1 to 8 do
    begin
      TLMDSpeedButton(FindComponent('Button'+IntToStr(i))).Caption:=ReadString('ButtonsCaption','Button'+IntToStr(i)+'Caption','');
      ArrayOfButtonDes[i]:=ReadString('ButtonsDescription','Button'+IntToStr(i)+'Description','');
      TLMDSpeedButton(FindComponent('Button'+IntToStr(i))).Hint:=ExtractFilePath(Application.ExeName)+ReadString('ButtonsAction','Button'+IntToStr(i)+'Action','');
      if ReadString('ButtonsVisible','Button'+IntToStr(i)+'Visible','False')='True' then
        TLMDSpeedButton(FindComponent('Button'+IntToStr(i))).Visible:=True
      else
        TLMDSpeedButton(FindComponent('Button'+IntToStr(i))).Visible:=False;
    end;
  end;
  InstIniFile.Free;
end;

procedure TMainForm.LMDSpeedButton0MouseEnter(Sender: TObject);
begin
  ExitGlyph.LoadFromFile(ExtractFilePath(Application.ExeName)+'Wiz\Exit2.bmp');
  LMDSpeedButton0.Glyph:=ExitGlyph;
end;

procedure TMainForm.LMDSpeedButton0MouseExit(Sender: TObject);
begin
  ExitGlyph.LoadFromFile(ExtractFilePath(Application.ExeName)+'Wiz\Exit1.bmp');
  LMDSpeedButton0.Glyph:=ExitGlyph;
end;

procedure TMainForm.InitBitmap;
begin
  ExitGlyph:=TBitmap.Create;
  ExitGlyph.LoadFromFile(ExtractFilePath(Application.ExeName)+'Wiz\Exit1.bmp');
end;

procedure TMainForm.CallAction(Sender: TObject);
var
  ButtonIndex:Byte;
begin
  ButtonIndex:=0;

  if Sender=Button1 then
    ButtonIndex:=1;
  if Sender=Button2 then
    ButtonIndex:=2;
  if Sender=Button3 then
    ButtonIndex:=3;
  if Sender=Button4 then
    ButtonIndex:=4;
  if Sender=Button5 then
    ButtonIndex:=5;
  if Sender=Button6 then
    ButtonIndex:=6;
  if Sender=Button7 then
    ButtonIndex:=7;
  if Sender=Button8 then
    ButtonIndex:=8;

  if ButtonIndex=0 then
    Exit;

  InstDataM.InstallerDataModule.InstallerStarter.Command:=TLMDSpeedButton(FindComponent('Button'+IntToStr(ButtonIndex))).Hint;

  if not FileExists(InstDataM.InstallerDataModule.InstallerStarter.Command) then
    Exit;

  InstDataM.InstallerDataModule.InstallerStarter.Execute;
end;

procedure TMainForm.CallDes(Sender: TObject);
var
  ButtonIndex:Byte;
begin
  ButtonIndex:=0;

  if Sender=Button1 then
    ButtonIndex:=1;
  if Sender=Button2 then
    ButtonIndex:=2;
  if Sender=Button3 then
    ButtonIndex:=3;
  if Sender=Button4 then
    ButtonIndex:=4;
  if Sender=Button5 then
    ButtonIndex:=5;
  if Sender=Button6 then
    ButtonIndex:=6;
  if Sender=Button7 then
    ButtonIndex:=7;
  if Sender=Button8 then
    ButtonIndex:=8;

  if ButtonIndex=0 then
    Exit;

  DesLabel.Caption:=ArrayOfButtonDes[ButtonIndex];
end;

procedure TMainForm.ClearDesLabel(Sender: TObject);
begin
  DesLabel.Caption:='';
end;

end.
