--[[ Unique Starting Inventory by macetaru and updated by DaNy3LL
This is my personal tweaked version of tehMugwump's Starter Inventory. All credit goes to him for the code and original idea. Also thanks to no_signal for helping tehMugwump with the code.

I tried to give each character a different feel and try to follow closely to their personality when choosing their equipment. Enjoy!

P.S. If you disagree with any of my selections or simply are inspired to create your own starting equipment combinations, feel free to change the items to your liking below!
-]]

----------------------------------------------------------------------------------------------------
local default_inv = {"twigs", "twigs", "flint", "flint"} 
local function setStarterInventory(inst, custom_inv)
	local st_inv = inst.components.inventory.starting_inventory
	if (st_inv) then 
		for k,v in pairs(default_inv) do
			table.insert(st_inv, v)
		end
	else 
		inst.components.inventory.starting_inventory = default_inv
	end
	if (custom_inv) then 
		for k,v in pairs(custom_inv)  do
			table.insert(inst.components.inventory.starting_inventory, v)
		end
	end
end

local function makePostInit(custom_inv)
	return function (inst)
		setStarterInventory(inst, custom_inv)
	end
end

--[[
This section contains all of the items given to each character at creation. 

Be careful to only add items by their debugSpawn code and not their in-game name as these are often different. You can search for these codes on the Don't Starve Wiki.
--]]
local wilson_inv = {"sweatervest", "razor", "researchlab2_blueprint", "diviningrod_blueprint", "lightning_rod_blueprint", "winterometer_blueprint", "rainometer_blueprint"}
local willow_inv = {"charcoal", "charcoal", "gunpowder", "gunpowder", "gunpowder", "gunpowder", "torch", "blowdart_fire", "blowdart_fire", "blowdart_fire", "blowdart_fire", "blowdart_fire", "trunkvest_summer", "gunpowder_blueprint"}
local wendy_inv = {"umbrella", "flowerhat", "purpleamulet", "book_brimstone", "pumpkin_lantern_blueprint"}
local wolfgang_inv = {"tophat", "greenamulet", "hammer", "rope_blueprint", "spear_blueprint"}
local wx78_inv = {"gears", "gears", "gears", "slurtlehat", "trinket_11", "boomerang", "umbrella_blueprint"}
local wickerbottom_inv = {"papyrus", "papyrus", "book_gardening", "book_birds", "sewing_kit", "lantern", "featherhat", "birdcage_blueprint"}
local wes_inv = {"walrushat", "bugnet", "panflute", "trinket_1", "umbrella_blueprint", "tent_blueprint"}
local waxwell_inv = {"cane", "telestaff", "trinket_12", "resurrectionstatue_blueprint"}
local woodie_inv = {"pinecone", "pinecone", "bedroll_furry", "fishingrod", "backpack", "strawhat", "trap_teeth_blueprint"}
local webber_inv = {"spidereggsack", "silk", "silk", "silk", "silk", "silk", "spiderhat", "tent_blueprint"}
local wathgrithr_inv = {"armorwood_blueprint", "rope_blueprint", "blowdart_sleep", "blowdart_sleep", "blowdart_sleep", "blowdart_sleep", "blowdart_sleep"}

AddPrefabPostInit("wilson", makePostInit(wilson_inv) )
AddPrefabPostInit("willow", makePostInit(willow_inv) )
AddPrefabPostInit("wendy", makePostInit(wendy_inv) )
AddPrefabPostInit("wolfgang", makePostInit(wolfgang_inv) )
AddPrefabPostInit("wickerbottom", makePostInit(wickerbottom_inv) )
AddPrefabPostInit("woodie", makePostInit(woodie_inv) )
AddPrefabPostInit("wx78", makePostInit(wx78_inv) )
AddPrefabPostInit("wes", makePostInit(wes_inv) )
AddPrefabPostInit("waxwell", makePostInit(waxwell_inv) )
AddPrefabPostInit("webber", makePostInit(webber_inv) )
AddPrefabPostInit("wathgrithr", makePostInit(wathgrithr_inv) )





