JuneManage={
IniFile = "interface/JunePony/JuneManage.ini",
}
function JuneManage.OnFrameCreate()
	JuneManage.UpdateAnchor(this)
	this:Lookup("","Text_Title"):SetText("ؼ¼")
end
function JuneManage.UpdateAnchor(frame)
	frame:SetPoint("CENTER", 0, 0, "CENTER", 0, -150)
	frame:CorrectPos()
end
function JuneManage.OpenPanel()
    local frame = Station.Lookup("Normal/JuneManage")
    if not frame then
        frame = Wnd.OpenWindow(JuneManage.IniFile, "JuneManage")
    end
end
function JuneManage.OutText(tList)
    local frame = Station.Lookup("Normal/JuneManage")
    if not frame then
        frame = Wnd.OpenWindow(JuneManage.IniFile, "JuneManage")
    end
	local textContent = frame:Lookup("Edit_Content")
    local szText = ""
	local nCount = 0
    if tList == "PonyTime" and not IsEmpty(JunePony.PonyTime) then
	    local nFrame = GetLogicFrameCount()
        table.sort(JunePony.PonyTime,function(a,b) return a.startTime > b.startTime end)
		for nIndex,aInfo in ipairs(JunePony.PonyTime) do
			if not aInfo.endTime then
				szText = szText.."{\n"
				szText = szText.."startFrame = "..aInfo.startFrame.." ,\n"
				szText = szText.."startTime = "..aInfo.startTime.." ,\n"
				szText = szText.."endFrame = "..aInfo.endFrame.." ,\n"
				szText = szText.."szMap = "..aInfo.szMap.." ,\n"
				szText = szText.."},\n"
				nCount = nCount + 1
			end
		end
	elseif tList == "PonyPos" and not IsEmpty(JunePony.PonyPos) then
		for nIndex,aInfo in ipairs(JunePony.PonyPos) do
				szText = szText.."{\n"
				szText = szText.."dwMapID = "..aInfo.dwMapID.." ,\n"
				szText = szText.."PosX = "..aInfo.PosX.." ,\n"
				szText = szText.."PosY = "..aInfo.PosY.." ,\n"
				szText = szText.."},\n"
				nCount = nCount + 1
		end
	end
	if szText == "" then
		OutputMessage("MSG_SYS","֣¼ʱûзļ¼\n")
	else
		OutputMessage("MSG_SYS","֣ι¼"..nCount.."\n")
	end
	textContent:SetText(szText)
end
function JuneManage.LoadText(tList)
    local frame = Station.Lookup("Normal/JuneManage")
    if not frame then
        return
    end
	local textContent = frame:Lookup("Edit_Content")
    local szContent = textContent:GetText()
	szContent = string.gsub(szContent, "%c", "")
	szContent = string.gsub(szContent, "[%[\"%]]", "")
	szContent = string.gsub(szContent, " ", "")
	szContent = string.gsub(szContent, "", ",")
	szContent = string.gsub(szContent, ",,", ",")
	if not string.find(szContent,"%b{}") then
		OutputMessage("MSG_SYS","֣ؼ¼ʱûзļ¼\n")
		return
	end
	local new = {}
	local nCount = 0
	local nInsert = 0
    for a in string.gmatch(szContent,"%{(.-)%}") do
		local t = {}
		a = string.gsub(a, "[%{%}]", "")
        for c, d in string.gmatch(a,"(.-)=(.-),") do
		    if (c and c ~= "") and (d and d ~= "") then
			    if tonumber(d) then
				    d = tonumber(d)
			    end
				if not t[c] then
        	        t[c]=d
				end
		    end
        end
		local bInsert = true
		if tList == "PonyTime" and t.szMap then
			if not IsEmpty(JunePony.PonyTime) then
				for nIndex,aInfo in ipairs(JunePony.PonyTime) do
					if aInfo.szMap == t.szMap and aInfo.startFrame == t.startFrame then
						bInsert = false
						break
					end
				end
			end
			if bInsert then
				table.insert(JunePony.PonyTime,t)
				nInsert = nInsert + 1
			end
		elseif tList == "PonyPos" and t.dwMapID then
			if not IsEmpty(JunePony.PonyPos) then
                for nIndex,aInfo in ipairs(JunePony.PonyPos) do
                    if aInfo.dwMapID == t.dwMapID then
                        local nDist = (((t.PosX - aInfo.PosX) ^ 2 + (t.PosY - aInfo.PosY) ^ 2) ^ 0.5)/64
                        if nDist < 50 then
                            bInsert = false
							OutputMessage("MSG_SYS","֣("..Table_GetMapName(t.dwMapID)..","..t.PosX..","..t.PosY..")ʧܣбǵ("..aInfo.PosX..","..aInfo.PosY..")಻50ߣ\n")
                            break
                        end
                    end
                end
            end
			if bInsert then
				t["szFinder"] = ""
				t["szPony"] = ""
				table.insert(JunePony.PonyPos,t)
				nInsert = nInsert + 1
			end
		end
		nCount = nCount + 1
    end
	OutputMessage("MSG_SYS","֣ιؼ¼"..nCount.."Ч¼"..nInsert.."\n")
end
function JuneManage.OnLButtonClick()
	local szName = this:GetName()
	if szName == "Btn_Close" then
		Wnd.CloseWindow("JuneManage")
	end
end
function JuneManage.OnItemLButtonClick()
	local szName = this:GetName()
	local xA, yA = this:GetAbsPos()
	local w, h = this:GetSize()
	local menu =
	{
		nMiniWidth = w,
		x = xA, y = yA + h,
	}
	if szName == "Handle_Out" then
		table.insert(menu, {szOption = "δץʱ",bCheck = false,fnAction = function() JuneManage.OutText("PonyTime") end})
		table.insert(menu, {szOption = "б",bCheck = false,fnAction = function() JuneManage.OutText("PonyPos") end})
		if menu and #menu > 0 then
			PopupMenu(menu)
		end
	elseif szName == "Handle_Load" then
		table.insert(menu, {szOption = "صˢʱ",bCheck = false,fnAction = function() JuneManage.LoadText("PonyTime") end})
		table.insert(menu, {szOption = "صб",bCheck = false,fnAction = function() JuneManage.LoadText("PonyPos") end})
		if menu and #menu > 0 then
			PopupMenu(menu)
		end
	end
end