/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;
import sun.misc.FpUtils;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static Random randomNumberGenerator;
    private static long negativeZeroFloatBits;
    private static long negativeZeroDoubleBits;

    private Math() {
    }

    public static double sin(double d) {
        return StrictMath.sin(d);
    }

    public static double cos(double d) {
        return StrictMath.cos(d);
    }

    public static double tan(double d) {
        return StrictMath.tan(d);
    }

    public static double asin(double d) {
        return StrictMath.asin(d);
    }

    public static double acos(double d) {
        return StrictMath.acos(d);
    }

    public static double atan(double d) {
        return StrictMath.atan(d);
    }

    public static double toRadians(double d) {
        return d / 180.0 * Math.PI;
    }

    public static double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double exp(double d) {
        return StrictMath.exp(d);
    }

    public static double log(double d) {
        return StrictMath.log(d);
    }

    public static double log10(double d) {
        return StrictMath.log10(d);
    }

    public static double sqrt(double d) {
        return StrictMath.sqrt(d);
    }

    public static double cbrt(double d) {
        return StrictMath.cbrt(d);
    }

    public static double IEEEremainder(double d, double d2) {
        return StrictMath.IEEEremainder(d, d2);
    }

    public static double ceil(double d) {
        return StrictMath.ceil(d);
    }

    public static double floor(double d) {
        return StrictMath.floor(d);
    }

    public static double rint(double d) {
        return StrictMath.rint(d);
    }

    public static double atan2(double d, double d2) {
        return StrictMath.atan2(d, d2);
    }

    public static double pow(double d, double d2) {
        return StrictMath.pow(d, d2);
    }

    public static int round(float f) {
        if (f != 0.49999997f) {
            return (int)Math.floor(f + 0.5f);
        }
        return 0;
    }

    public static long round(double d) {
        if (d != 0.49999999999999994) {
            return (long)Math.floor(d + 0.5);
        }
        return 0L;
    }

    private static synchronized Random initRNG() {
        Random random = randomNumberGenerator;
        return random == null ? (randomNumberGenerator = new Random()) : random;
    }

    public static double random() {
        Random random = randomNumberGenerator;
        if (random == null) {
            random = Math.initRNG();
        }
        return random.nextDouble();
    }

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static float abs(float f) {
        return f <= 0.0f ? 0.0f - f : f;
    }

    public static double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    public static int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    public static long max(long l, long l2) {
        return l >= l2 ? l : l2;
    }

    public static float max(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && (long)Float.floatToIntBits(f) == negativeZeroFloatBits) {
            return f2;
        }
        return f >= f2 ? f : f2;
    }

    public static double max(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToLongBits(d) == negativeZeroDoubleBits) {
            return d2;
        }
        return d >= d2 ? d : d2;
    }

    public static int min(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    public static long min(long l, long l2) {
        return l <= l2 ? l : l2;
    }

    public static float min(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && (long)Float.floatToIntBits(f2) == negativeZeroFloatBits) {
            return f2;
        }
        return f <= f2 ? f : f2;
    }

    public static double min(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToLongBits(d2) == negativeZeroDoubleBits) {
            return d2;
        }
        return d <= d2 ? d : d2;
    }

    public static double ulp(double d) {
        return FpUtils.ulp((double)d);
    }

    public static float ulp(float f) {
        return FpUtils.ulp((float)f);
    }

    public static double signum(double d) {
        return FpUtils.signum((double)d);
    }

    public static float signum(float f) {
        return FpUtils.signum((float)f);
    }

    public static double sinh(double d) {
        return StrictMath.sinh(d);
    }

    public static double cosh(double d) {
        return StrictMath.cosh(d);
    }

    public static double tanh(double d) {
        return StrictMath.tanh(d);
    }

    public static double hypot(double d, double d2) {
        return StrictMath.hypot(d, d2);
    }

    public static double expm1(double d) {
        return StrictMath.expm1(d);
    }

    public static double log1p(double d) {
        return StrictMath.log1p(d);
    }

    public static double copySign(double d, double d2) {
        return FpUtils.rawCopySign((double)d, (double)d2);
    }

    public static float copySign(float f, float f2) {
        return FpUtils.rawCopySign((float)f, (float)f2);
    }

    public static int getExponent(float f) {
        return FpUtils.getExponent((float)f);
    }

    public static int getExponent(double d) {
        return FpUtils.getExponent((double)d);
    }

    public static double nextAfter(double d, double d2) {
        return FpUtils.nextAfter((double)d, (double)d2);
    }

    public static float nextAfter(float f, double d) {
        return FpUtils.nextAfter((float)f, (double)d);
    }

    public static double nextUp(double d) {
        return FpUtils.nextUp((double)d);
    }

    public static float nextUp(float f) {
        return FpUtils.nextUp((float)f);
    }

    public static double scalb(double d, int n) {
        return FpUtils.scalb((double)d, (int)n);
    }

    public static float scalb(float f, int n) {
        return FpUtils.scalb((float)f, (int)n);
    }

    static {
        negativeZeroFloatBits = Float.floatToIntBits(-0.0f);
        negativeZeroDoubleBits = Double.doubleToLongBits(-0.0);
    }
}

