/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.Hashing;

public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private final char[] value;
    private int hash;
    private static final long serialVersionUID = -6849794470754667710L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
    private static final int HASHING_SEED;
    private transient int hash32 = 0;

    public String() {
        this.value = new char[0];
    }

    public String(String string) {
        this.value = string.value;
        this.hash = string.hash;
    }

    public String(char[] cArray) {
        this.value = Arrays.copyOf(cArray, cArray.length);
    }

    public String(char[] cArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        this.value = Arrays.copyOfRange(cArray, n, n + n2);
    }

    public String(int[] nArray, int n, int n2) {
        int n3;
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > nArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        int n4 = n + n2;
        int n5 = n2;
        for (int i = n; i < n4; ++i) {
            n3 = nArray[i];
            if (Character.isBmpCodePoint(n3)) continue;
            if (Character.isValidCodePoint(n3)) {
                ++n5;
                continue;
            }
            throw new IllegalArgumentException(Integer.toString(n3));
        }
        char[] cArray = new char[n5];
        n3 = n;
        int n6 = 0;
        while (n3 < n4) {
            int n7 = nArray[n3];
            if (Character.isBmpCodePoint(n7)) {
                cArray[n6] = (char)n7;
            } else {
                Character.toSurrogates(n7, cArray, n6++);
            }
            ++n3;
            ++n6;
        }
        this.value = cArray;
    }

    @Deprecated
    public String(byte[] byArray, int n, int n2, int n3) {
        String.checkBounds(byArray, n2, n3);
        char[] cArray = new char[n3];
        if (n == 0) {
            int n4 = n3;
            while (n4-- > 0) {
                cArray[n4] = (char)(byArray[n4 + n2] & 0xFF);
            }
        } else {
            n <<= 8;
            int n5 = n3;
            while (n5-- > 0) {
                cArray[n5] = (char)(n | byArray[n5 + n2] & 0xFF);
            }
        }
        this.value = cArray;
    }

    @Deprecated
    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    private static void checkBounds(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > byArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException("charsetName");
        }
        String.checkBounds(byArray, n, n2);
        this.value = StringCoding.decode((String)string, (byte[])byArray, (int)n, (int)n2);
    }

    public String(byte[] byArray, int n, int n2, Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        String.checkBounds(byArray, n, n2);
        this.value = StringCoding.decode((Charset)charset, (byte[])byArray, (int)n, (int)n2);
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, Charset charset) {
        this(byArray, 0, byArray.length, charset);
    }

    public String(byte[] byArray, int n, int n2) {
        String.checkBounds(byArray, n, n2);
        this.value = StringCoding.decode((byte[])byArray, (int)n, (int)n2);
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            this.value = Arrays.copyOf(stringBuffer.getValue(), stringBuffer.length());
        }
    }

    public String(StringBuilder stringBuilder) {
        this.value = Arrays.copyOf(stringBuilder.getValue(), stringBuilder.length());
    }

    String(char[] cArray, boolean bl) {
        this.value = cArray;
    }

    @Deprecated
    String(int n, int n2, char[] cArray) {
        this(cArray, n, n2);
    }

    @Override
    public int length() {
        return this.value.length;
    }

    public boolean isEmpty() {
        return this.value.length == 0;
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || n >= this.value.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    public int codePointAt(int n) {
        if (n < 0 || n >= this.value.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return Character.codePointAtImpl(this.value, n, this.value.length);
    }

    public int codePointBefore(int n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.value.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return Character.codePointBeforeImpl(this.value, n, 0);
    }

    public int codePointCount(int n, int n2) {
        if (n < 0 || n2 > this.value.length || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(this.value, n, n2 - n);
    }

    public int offsetByCodePoints(int n, int n2) {
        if (n < 0 || n > this.value.length) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(this.value, 0, this.value.length, n, n2);
    }

    void getChars(char[] cArray, int n) {
        System.arraycopy(this.value, 0, cArray, n, this.value.length);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.value.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        System.arraycopy(this.value, n, cArray, n3, n2 - n);
    }

    @Deprecated
    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.value.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        int n4 = n3;
        int n5 = n2;
        int n6 = n;
        char[] cArray = this.value;
        while (n6 < n5) {
            byArray[n4++] = (byte)cArray[n6++];
        }
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode((String)string, (char[])this.value, (int)0, (int)this.value.length);
    }

    public byte[] getBytes(Charset charset) {
        if (charset == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode((Charset)charset, (char[])this.value, (int)0, (int)this.value.length);
    }

    public byte[] getBytes() {
        return StringCoding.encode((char[])this.value, (int)0, (int)this.value.length);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n = this.value.length;
            if (n == string.value.length) {
                char[] cArray = this.value;
                char[] cArray2 = string.value;
                int n2 = 0;
                while (n-- != 0) {
                    if (cArray[n2] != cArray2[n2]) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            return this.contentEquals((CharSequence)stringBuffer);
        }
    }

    public boolean contentEquals(CharSequence charSequence) {
        if (this.value.length != charSequence.length()) {
            return false;
        }
        if (charSequence instanceof AbstractStringBuilder) {
            char[] cArray = this.value;
            char[] cArray2 = ((AbstractStringBuilder)charSequence).getValue();
            int n = 0;
            int n2 = this.value.length;
            while (n2-- != 0) {
                if (cArray[n] != cArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (charSequence.equals(this)) {
            return true;
        }
        char[] cArray = this.value;
        int n = 0;
        int n3 = this.value.length;
        while (n3-- != 0) {
            if (cArray[n] != charSequence.charAt(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        return this == string ? true : string != null && string.value.length == this.value.length && this.regionMatches(true, 0, string, 0, this.value.length);
    }

    @Override
    public int compareTo(String string) {
        int n = this.value.length;
        int n2 = string.value.length;
        int n3 = Math.min(n, n2);
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        for (int i = 0; i < n3; ++i) {
            char c = cArray[i];
            char c2 = cArray2[i];
            if (c == c2) continue;
            return c - c2;
        }
        return n - n2;
    }

    public int compareToIgnoreCase(String string) {
        return CASE_INSENSITIVE_ORDER.compare(this, string);
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        char[] cArray = this.value;
        int n4 = n;
        char[] cArray2 = string.value;
        int n5 = n2;
        if (n2 < 0 || n < 0 || (long)n > (long)this.value.length - (long)n3 || (long)n2 > (long)string.value.length - (long)n3) {
            return false;
        }
        while (n3-- > 0) {
            if (cArray[n4++] == cArray2[n5++]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        char[] cArray = this.value;
        int n4 = n;
        char[] cArray2 = string.value;
        int n5 = n2;
        if (n2 < 0 || n < 0 || (long)n > (long)this.value.length - (long)n3 || (long)n2 > (long)string.value.length - (long)n3) {
            return false;
        }
        while (n3-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n4++]) == (c3 = cArray2[n5++]) || bl && ((c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string, int n) {
        char[] cArray = this.value;
        int n2 = n;
        char[] cArray2 = string.value;
        int n3 = 0;
        int n4 = string.value.length;
        if (n < 0 || n > this.value.length - n4) {
            return false;
        }
        while (--n4 >= 0) {
            if (cArray[n2++] == cArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean endsWith(String string) {
        return this.startsWith(string, this.value.length - string.value.length);
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0 && this.value.length > 0) {
            char[] cArray = this.value;
            for (int i = 0; i < this.value.length; ++i) {
                n = 31 * n + cArray[i];
            }
            this.hash = n;
        }
        return n;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        int n3 = this.value.length;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= n3) {
            return -1;
        }
        if (n < 65536) {
            char[] cArray = this.value;
            for (int i = n2; i < n3; ++i) {
                if (cArray[i] != n) continue;
                return i;
            }
            return -1;
        }
        return this.indexOfSupplementary(n, n2);
    }

    private int indexOfSupplementary(int n, int n2) {
        if (Character.isValidCodePoint(n)) {
            char[] cArray = this.value;
            char c = Character.highSurrogate(n);
            char c2 = Character.lowSurrogate(n);
            int n3 = cArray.length - 1;
            for (int i = n2; i < n3; ++i) {
                if (cArray[i] != c || cArray[i + 1] != c2) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.value.length - 1);
    }

    public int lastIndexOf(int n, int n2) {
        if (n < 65536) {
            char[] cArray = this.value;
            for (int i = Math.min(n2, cArray.length - 1); i >= 0; --i) {
                if (cArray[i] != n) continue;
                return i;
            }
            return -1;
        }
        return this.lastIndexOfSupplementary(n, n2);
    }

    private int lastIndexOfSupplementary(int n, int n2) {
        if (Character.isValidCodePoint(n)) {
            char[] cArray = this.value;
            char c = Character.highSurrogate(n);
            char c2 = Character.lowSurrogate(n);
            for (int i = Math.min(n2, cArray.length - 2); i >= 0; --i) {
                if (cArray[i] != c || cArray[i + 1] != c2) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        return String.indexOf(this.value, 0, this.value.length, string.value, 0, string.value.length, n);
    }

    static int indexOf(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, int n5) {
        if (n5 >= n2) {
            return n4 == 0 ? n2 : -1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 == 0) {
            return n5;
        }
        char c = cArray2[n3];
        int n6 = n + (n2 - n4);
        for (int i = n + n5; i <= n6; ++i) {
            if (cArray[i] != c) {
                while (++i <= n6 && cArray[i] != c) {
                }
            }
            if (i > n6) continue;
            int n7 = i + 1;
            int n8 = n7 + n4 - 1;
            int n9 = n3 + 1;
            while (n7 < n8 && cArray[n7] == cArray2[n9]) {
                ++n7;
                ++n9;
            }
            if (n7 != n8) continue;
            return i - n;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.value.length);
    }

    public int lastIndexOf(String string, int n) {
        return String.lastIndexOf(this.value, 0, this.value.length, string.value, 0, string.value.length, n);
    }

    static int lastIndexOf(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, int n5) {
        int n6;
        int n7 = n2 - n4;
        if (n5 < 0) {
            return -1;
        }
        if (n5 > n7) {
            n5 = n7;
        }
        if (n4 == 0) {
            return n5;
        }
        int n8 = n3 + n4 - 1;
        char c = cArray2[n8];
        int n9 = n + n4 - 1;
        int n10 = n9 + n5;
        block0: while (true) {
            if (n10 >= n9 && cArray[n10] != c) {
                --n10;
                continue;
            }
            if (n10 < n9) {
                return -1;
            }
            int n11 = n10 - 1;
            n6 = n11 - (n4 - 1);
            int n12 = n8 - 1;
            while (n11 > n6) {
                if (cArray[n11--] == cArray2[n12--]) continue;
                --n10;
                continue block0;
            }
            break;
        }
        return n6 - n + 1;
    }

    public String substring(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = this.value.length - n;
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return n == 0 ? this : new String(this.value, n, n2);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.value.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        return n == 0 && n2 == this.value.length ? this : new String(this.value, n, n3);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String concat(String string) {
        int n = string.length();
        if (n == 0) {
            return this;
        }
        int n2 = this.value.length;
        char[] cArray = Arrays.copyOf(this.value, n2 + n);
        string.getChars(cArray, n2);
        return new String(cArray, true);
    }

    public String replace(char c, char n) {
        if (c != n) {
            int n2 = this.value.length;
            int n3 = -1;
            char[] cArray = this.value;
            while (++n3 < n2 && cArray[n3] != c) {
            }
            if (n3 < n2) {
                int n4;
                char[] cArray2 = new char[n2];
                for (n4 = 0; n4 < n3; ++n4) {
                    cArray2[n4] = cArray[n4];
                }
                while (n3 < n2) {
                    n4 = cArray[n3];
                    cArray2[n3] = n4 == c ? n : n4;
                    ++n3;
                }
                return new String(cArray2, true);
            }
        }
        return this;
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public boolean contains(CharSequence charSequence) {
        return this.indexOf(charSequence.toString()) > -1;
    }

    public String replaceFirst(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceFirst(string2);
    }

    public String replaceAll(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceAll(string2);
    }

    public String replace(CharSequence charSequence, CharSequence charSequence2) {
        return Pattern.compile(charSequence.toString(), 16).matcher(this).replaceAll(Matcher.quoteReplacement(charSequence2.toString()));
    }

    public String[] split(String string, int n) {
        char c = '\u0000';
        if ((string.value.length == 1 && ".$|()[{^?*+\\".indexOf(c = string.charAt(0)) == -1 || string.length() == 2 && string.charAt(0) == '\\' && ((c = string.charAt(1)) - 48 | 57 - c) < 0 && (c - 97 | 122 - c) < 0 && (c - 65 | 90 - c) < 0) && (c < '\ud800' || c > '\udfff')) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            boolean bl = n > 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((n4 = this.indexOf(c, n3)) != -1) {
                if (!bl || arrayList.size() < n - 1) {
                    arrayList.add(this.substring(n3, n4));
                    n3 = n4 + 1;
                    continue;
                }
                arrayList.add(this.substring(n3, this.value.length));
                n3 = this.value.length;
                break;
            }
            if (n3 == 0) {
                return new String[]{this};
            }
            if (!bl || arrayList.size() < n) {
                arrayList.add(this.substring(n3, this.value.length));
            }
            if (n == 0) {
                for (n2 = arrayList.size(); n2 > 0 && ((String)arrayList.get(n2 - 1)).length() == 0; --n2) {
                }
            }
            String[] stringArray = new String[n2];
            return arrayList.subList(0, n2).toArray(stringArray);
        }
        return Pattern.compile(string).split(this, n);
    }

    public String[] split(String string) {
        return this.split(string, 0);
    }

    public String toLowerCase(Locale locale) {
        int n;
        int n2;
        int n3;
        int n4;
        block15: {
            if (locale == null) {
                throw new NullPointerException();
            }
            n4 = this.value.length;
            n3 = 0;
            while (n3 < n4) {
                char c = this.value[n3];
                if (c >= '\ud800' && c <= '\udbff') {
                    n2 = this.codePointAt(n3);
                    if (n2 == Character.toLowerCase(n2)) {
                        n3 += Character.charCount(n2);
                        continue;
                    }
                } else if (c == Character.toLowerCase(c)) {
                    ++n3;
                    continue;
                }
                break block15;
            }
            return this;
        }
        char[] cArray = new char[n4];
        n2 = 0;
        System.arraycopy(this.value, 0, cArray, 0, n3);
        String string = locale.getLanguage();
        boolean bl = string == "tr" || string == "az" || string == "lt";
        for (int i = n3; i < n4; i += n) {
            int n5 = this.value[i];
            if ((char)n5 >= '\ud800' && (char)n5 <= '\udbff') {
                n5 = this.codePointAt(i);
                n = Character.charCount(n5);
            } else {
                n = 1;
            }
            int n6 = bl || n5 == 931 ? ConditionalSpecialCasing.toLowerCaseEx(this, i, locale) : (n5 == 304 ? -1 : Character.toLowerCase(n5));
            if (n6 == -1 || n6 >= 65536) {
                char[] cArray2;
                if (n6 == -1) {
                    cArray2 = !bl && n5 == 304 ? ConditionalSpecialCasing.toLowerCaseCharArray(this, i, Locale.ENGLISH) : ConditionalSpecialCasing.toLowerCaseCharArray(this, i, locale);
                } else {
                    if (n == 2) {
                        n2 += Character.toChars(n6, cArray, i + n2) - n;
                        continue;
                    }
                    cArray2 = Character.toChars(n6);
                }
                int n7 = cArray2.length;
                if (n7 > n) {
                    char[] cArray3 = new char[cArray.length + n7 - n];
                    System.arraycopy(cArray, 0, cArray3, 0, i + n2);
                    cArray = cArray3;
                }
                for (int j = 0; j < n7; ++j) {
                    cArray[i + n2 + j] = cArray2[j];
                }
                n2 += n7 - n;
                continue;
            }
            cArray[i + n2] = (char)n6;
        }
        return new String(cArray, 0, n4 + n2);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        int n;
        int n2;
        int n3;
        int n4;
        block14: {
            if (locale == null) {
                throw new NullPointerException();
            }
            n4 = this.value.length;
            for (n2 = 0; n2 < n4; n2 += n3) {
                int n5 = this.value[n2];
                if (n5 >= 55296 && n5 <= 56319) {
                    n5 = this.codePointAt(n2);
                    n3 = Character.charCount(n5);
                } else {
                    n3 = 1;
                }
                int n6 = Character.toUpperCaseEx(n5);
                if (n6 != -1 && n5 == n6) {
                    continue;
                }
                break block14;
            }
            return this;
        }
        char[] cArray = new char[n4];
        n3 = 0;
        System.arraycopy(this.value, 0, cArray, 0, n2);
        String string = locale.getLanguage();
        boolean bl = string == "tr" || string == "az" || string == "lt";
        for (int i = n2; i < n4; i += n) {
            int n7 = this.value[i];
            if ((char)n7 >= '\ud800' && (char)n7 <= '\udbff') {
                n7 = this.codePointAt(i);
                n = Character.charCount(n7);
            } else {
                n = 1;
            }
            int n8 = bl ? ConditionalSpecialCasing.toUpperCaseEx(this, i, locale) : Character.toUpperCaseEx(n7);
            if (n8 == -1 || n8 >= 65536) {
                char[] cArray2;
                if (n8 == -1) {
                    cArray2 = bl ? ConditionalSpecialCasing.toUpperCaseCharArray(this, i, locale) : Character.toUpperCaseCharArray(n7);
                } else {
                    if (n == 2) {
                        n3 += Character.toChars(n8, cArray, i + n3) - n;
                        continue;
                    }
                    cArray2 = Character.toChars(n8);
                }
                int n9 = cArray2.length;
                if (n9 > n) {
                    char[] cArray3 = new char[cArray.length + n9 - n];
                    System.arraycopy(cArray, 0, cArray3, 0, i + n3);
                    cArray = cArray3;
                }
                for (int j = 0; j < n9; ++j) {
                    cArray[i + n3 + j] = cArray2[j];
                }
                n3 += n9 - n;
                continue;
            }
            cArray[i + n3] = (char)n8;
        }
        return new String(cArray, 0, n4 + n3);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        int n;
        int n2 = this.value.length;
        char[] cArray = this.value;
        for (n = 0; n < n2 && cArray[n] <= ' '; ++n) {
        }
        while (n < n2 && cArray[n2 - 1] <= ' ') {
            --n2;
        }
        return n > 0 || n2 < this.value.length ? this.substring(n, n2) : this;
    }

    @Override
    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.value.length];
        System.arraycopy(this.value, 0, cArray, 0, this.value.length);
        return cArray;
    }

    public static String format(String string, Object ... objectArray) {
        return new Formatter().format(string, objectArray).toString();
    }

    public static String format(Locale locale, String string, Object ... objectArray) {
        return new Formatter(locale).format(string, objectArray).toString();
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] cArray = new char[]{c};
        return new String(cArray, true);
    }

    public static String valueOf(int n) {
        return Integer.toString(n);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();

    int hash32() {
        int n = this.hash32;
        if (0 == n) {
            n = Hashing.murmur3_32((int)HASHING_SEED, (char[])this.value, (int)0, (int)this.value.length);
            this.hash32 = n = 0 != n ? n : 1;
        }
        return n;
    }

    static {
        long l = System.nanoTime();
        long l2 = System.currentTimeMillis();
        int[] nArray = new int[]{System.identityHashCode(String.class), System.identityHashCode(System.class), (int)(l >>> 32), (int)l, (int)(l2 >>> 32), (int)l2, (int)(System.nanoTime() >>> 2)};
        int n = 0;
        for (int n2 : nArray) {
            n2 *= -862048943;
            n2 = n2 << 15 | n2 >>> 17;
            n ^= (n2 *= 461845907);
            n = n << 13 | n >>> 19;
            n = n * 5 + -430675100;
        }
        n ^= nArray.length * 4;
        n ^= n >>> 16;
        n *= -2048144789;
        n ^= n >>> 13;
        n *= -1028477387;
        n ^= n >>> 16;
        HASHING_SEED = n;
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = string.length();
            int n2 = string2.length();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                char c2 = string.charAt(i);
                if (c2 == (c = string2.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
                return c2 - c;
            }
            return n - n2;
        }
    }
}

