class Controller {
    var result = "fail"
    suspend fun <V> suspendHere(v: V, x: Continuation<V>) {
        x.resume(v)
    }

    operator fun handleResult(x: String, c: Continuation<Nothing>) {
        result = x
    }

    // INTERCEPT_RESUME_PLACEHOLDER
}

fun builder(coroutine c: Controller.() -> Continuation<Unit>): String {
    val controller = Controller()
    c(controller).resume(Unit)

    return controller.result
}

fun foo(): String = builder {
    // A piece of code for next statement:
    // INVOKEVIRTUAL suspendHere
    // CHECKCAST [B
    //
    // Analyzer uses `newValue` method for estimation of type generated by CHECKCAST insn,
    // but for arrays `newValue` returned just Basic.REFERENCE_VALUE, thus we didn't add necessary checkcasts
    // for variables spilled into fields
    val data2 = suspendHere(ByteArray(2))

    suspendHere("<ignored>")
    data2.size.toString()
}

fun box(): String {
    if (foo() != "2") return "fail 1"
    return "OK"
}
