/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.codegen.ir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/box")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class IrBlackBoxCodegenTestGenerated extends AbstractIrBlackBoxCodegenTest {
    public void testAllFilesPresentInBox() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
    }

    @TestMetadata("compiler/testData/codegen/box/annotations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Annotations extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInAnnotations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("annotatedEnumEntry.kt")
        public void testAnnotatedEnumEntry() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/annotatedEnumEntry.kt");
            doTest(fileName);
        }

        @TestMetadata("annotatedObjectLiteral.kt")
        public void testAnnotatedObjectLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/annotatedObjectLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("annotationWithKotlinProperty.kt")
        public void testAnnotationWithKotlinProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/annotationWithKotlinProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("annotationWithKotlinPropertyFromInterfaceCompanion.kt")
        public void testAnnotationWithKotlinPropertyFromInterfaceCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/annotationWithKotlinPropertyFromInterfaceCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("annotationsOnDefault.kt")
        public void testAnnotationsOnDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/annotationsOnDefault.kt");
            doTest(fileName);
        }

        @TestMetadata("annotationsOnTypeAliases.kt")
        public void testAnnotationsOnTypeAliases() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/annotationsOnTypeAliases.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultParameterValues.kt")
        public void testDefaultParameterValues() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/defaultParameterValues.kt");
            doTest(fileName);
        }

        @TestMetadata("delegatedPropertySetter.kt")
        public void testDelegatedPropertySetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/delegatedPropertySetter.kt");
            doTest(fileName);
        }

        @TestMetadata("fileClassWithFileAnnotation.kt")
        public void testFileClassWithFileAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/fileClassWithFileAnnotation.kt");
            doTest(fileName);
        }

        @TestMetadata("jvmAnnotationFlags.kt")
        public void testJvmAnnotationFlags() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/jvmAnnotationFlags.kt");
            doTest(fileName);
        }

        @TestMetadata("kotlinPropertyFromClassObjectAsParameter.kt")
        public void testKotlinPropertyFromClassObjectAsParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/kotlinPropertyFromClassObjectAsParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("kotlinTopLevelPropertyAsParameter.kt")
        public void testKotlinTopLevelPropertyAsParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/kotlinTopLevelPropertyAsParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10136.kt")
        public void testKt10136() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/kt10136.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedClassPropertyAsParameter.kt")
        public void testNestedClassPropertyAsParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/nestedClassPropertyAsParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("parameterWithPrimitiveType.kt")
        public void testParameterWithPrimitiveType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/parameterWithPrimitiveType.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithPropertyInInitializerAsParameter.kt")
        public void testPropertyWithPropertyInInitializerAsParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/propertyWithPropertyInInitializerAsParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("resolveWithLowPriorityAnnotation.kt")
        public void testResolveWithLowPriorityAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/resolveWithLowPriorityAnnotation.kt");
            doTest(fileName);
        }

        @TestMetadata("varargInAnnotationParameter.kt")
        public void testVarargInAnnotationParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/varargInAnnotationParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/annotations/annotatedLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotatedLambda extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInAnnotatedLambda() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/annotations/annotatedLambda"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("funExpression.kt")
            public void testFunExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/annotatedLambda/funExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/annotatedLambda/lambda.kt");
                doTest(fileName);
            }

            @TestMetadata("samFunExpression.kt")
            public void testSamFunExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/annotatedLambda/samFunExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("samLambda.kt")
            public void testSamLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/annotations/annotatedLambda/samLambda.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArgumentOrder extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arguments.kt")
        public void testArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/arguments.kt");
            doTest(fileName);
        }

        @TestMetadata("captured.kt")
        public void testCaptured() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/captured.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedInExtension.kt")
        public void testCapturedInExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/capturedInExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("defaults.kt")
        public void testDefaults() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/defaults.kt");
            doTest(fileName);
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/extension.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionInClass.kt")
        public void testExtensionInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/extensionInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9277.kt")
        public void testKt9277() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/kt9277.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaMigration.kt")
        public void testLambdaMigration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/lambdaMigration.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaMigrationInClass.kt")
        public void testLambdaMigrationInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/lambdaMigrationInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleInClass.kt")
        public void testSimpleInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/argumentOrder/simpleInClass.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/arrays")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Arrays extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInArrays() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/arrays"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayConstructorsSimple.kt")
        public void testArrayConstructorsSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/arrayConstructorsSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayGetAssignMultiIndex.kt")
        public void testArrayGetAssignMultiIndex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/arrayGetAssignMultiIndex.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayGetMultiIndex.kt")
        public void testArrayGetMultiIndex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/arrayGetMultiIndex.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayInstanceOf.kt")
        public void testArrayInstanceOf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/arrayInstanceOf.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayPlusAssign.kt")
        public void testArrayPlusAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/arrayPlusAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("arraysAreCloneable.kt")
        public void testArraysAreCloneable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/arraysAreCloneable.kt");
            doTest(fileName);
        }

        @TestMetadata("cloneArray.kt")
        public void testCloneArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/cloneArray.kt");
            doTest(fileName);
        }

        @TestMetadata("clonePrimitiveArrays.kt")
        public void testClonePrimitiveArrays() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/clonePrimitiveArrays.kt");
            doTest(fileName);
        }

        @TestMetadata("collectionAssignGetMultiIndex.kt")
        public void testCollectionAssignGetMultiIndex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/collectionAssignGetMultiIndex.kt");
            doTest(fileName);
        }

        @TestMetadata("collectionGetMultiIndex.kt")
        public void testCollectionGetMultiIndex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/collectionGetMultiIndex.kt");
            doTest(fileName);
        }

        @TestMetadata("forEachBooleanArray.kt")
        public void testForEachBooleanArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/forEachBooleanArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forEachByteArray.kt")
        public void testForEachByteArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/forEachByteArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forEachCharArray.kt")
        public void testForEachCharArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/forEachCharArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forEachDoubleArray.kt")
        public void testForEachDoubleArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/forEachDoubleArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forEachFloatArray.kt")
        public void testForEachFloatArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/forEachFloatArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forEachIntArray.kt")
        public void testForEachIntArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/forEachIntArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forEachLongArray.kt")
        public void testForEachLongArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/forEachLongArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forEachShortArray.kt")
        public void testForEachShortArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/forEachShortArray.kt");
            doTest(fileName);
        }

        @TestMetadata("hashMap.kt")
        public void testHashMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/hashMap.kt");
            doTest(fileName);
        }

        @TestMetadata("inProjectionAsParameter.kt")
        public void testInProjectionAsParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/inProjectionAsParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("inProjectionOfArray.kt")
        public void testInProjectionOfArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/inProjectionOfArray.kt");
            doTest(fileName);
        }

        @TestMetadata("inProjectionOfList.kt")
        public void testInProjectionOfList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/inProjectionOfList.kt");
            doTest(fileName);
        }

        @TestMetadata("indices.kt")
        public void testIndices() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/indices.kt");
            doTest(fileName);
        }

        @TestMetadata("indicesChar.kt")
        public void testIndicesChar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/indicesChar.kt");
            doTest(fileName);
        }

        @TestMetadata("iterator.kt")
        public void testIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iterator.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorBooleanArray.kt")
        public void testIteratorBooleanArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iteratorBooleanArray.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorByteArray.kt")
        public void testIteratorByteArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iteratorByteArray.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorByteArrayNextByte.kt")
        public void testIteratorByteArrayNextByte() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iteratorByteArrayNextByte.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorCharArray.kt")
        public void testIteratorCharArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iteratorCharArray.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorDoubleArray.kt")
        public void testIteratorDoubleArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iteratorDoubleArray.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorFloatArray.kt")
        public void testIteratorFloatArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iteratorFloatArray.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorIntArray.kt")
        public void testIteratorIntArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iteratorIntArray.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorLongArray.kt")
        public void testIteratorLongArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iteratorLongArray.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorLongArrayNextLong.kt")
        public void testIteratorLongArrayNextLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iteratorLongArrayNextLong.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorShortArray.kt")
        public void testIteratorShortArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/iteratorShortArray.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1291.kt")
        public void testKt1291() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt1291.kt");
            doTest(fileName);
        }

        @TestMetadata("kt238.kt")
        public void testKt238() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt238.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2997.kt")
        public void testKt2997() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt2997.kt");
            doTest(fileName);
        }

        @TestMetadata("kt33.kt")
        public void testKt33() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt33.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3771.kt")
        public void testKt3771() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt3771.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4118.kt")
        public void testKt4118() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt4118.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4348.kt")
        public void testKt4348() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt4348.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4357.kt")
        public void testKt4357() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt4357.kt");
            doTest(fileName);
        }

        @TestMetadata("kt503.kt")
        public void testKt503() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt503.kt");
            doTest(fileName);
        }

        @TestMetadata("kt594.kt")
        public void testKt594() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt594.kt");
            doTest(fileName);
        }

        @TestMetadata("kt602.kt")
        public void testKt602() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt602.kt");
            doTest(fileName);
        }

        @TestMetadata("kt7009.kt")
        public void testKt7009() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt7009.kt");
            doTest(fileName);
        }

        @TestMetadata("kt7288.kt")
        public void testKt7288() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt7288.kt");
            doTest(fileName);
        }

        @TestMetadata("kt7338.kt")
        public void testKt7338() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt7338.kt");
            doTest(fileName);
        }

        @TestMetadata("kt779.kt")
        public void testKt779() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt779.kt");
            doTest(fileName);
        }

        @TestMetadata("kt945.kt")
        public void testKt945() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt945.kt");
            doTest(fileName);
        }

        @TestMetadata("kt950.kt")
        public void testKt950() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/kt950.kt");
            doTest(fileName);
        }

        @TestMetadata("longAsIndex.kt")
        public void testLongAsIndex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/longAsIndex.kt");
            doTest(fileName);
        }

        @TestMetadata("multiArrayConstructors.kt")
        public void testMultiArrayConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiArrayConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("nonLocalReturnArrayConstructor.kt")
        public void testNonLocalReturnArrayConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/nonLocalReturnArrayConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("nonNullArray.kt")
        public void testNonNullArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/nonNullArray.kt");
            doTest(fileName);
        }

        @TestMetadata("stdlib.kt")
        public void testStdlib() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/stdlib.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MultiDecl extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInMultiDecl() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("MultiDeclFor.kt")
            public void testMultiDeclFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclFor.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForComponentExtensions.kt")
            public void testMultiDeclForComponentExtensions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentExtensions.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
            public void testMultiDeclForComponentMemberExtensions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensions.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
            public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForValCaptured.kt")
            public void testMultiDeclForValCaptured() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForValCaptured.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/int")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Int extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInInt() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/int"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensionsValCaptured.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/long")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Long extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInLong() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/long"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensionsValCaptured.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    doTest(fileName);
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/binaryOp")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BinaryOp extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInBinaryOp() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/binaryOp"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("bitwiseOp.kt")
        public void testBitwiseOp() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/bitwiseOp.kt");
            doTest(fileName);
        }

        @TestMetadata("bitwiseOpAny.kt")
        public void testBitwiseOpAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/bitwiseOpAny.kt");
            doTest(fileName);
        }

        @TestMetadata("bitwiseOpNullable.kt")
        public void testBitwiseOpNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/bitwiseOpNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("call.kt")
        public void testCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/call.kt");
            doTest(fileName);
        }

        @TestMetadata("callAny.kt")
        public void testCallAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/callAny.kt");
            doTest(fileName);
        }

        @TestMetadata("callNullable.kt")
        public void testCallNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/callNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("compareWithBoxedDouble.kt")
        public void testCompareWithBoxedDouble() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/compareWithBoxedDouble.kt");
            doTest(fileName);
        }

        @TestMetadata("compareWithBoxedLong.kt")
        public void testCompareWithBoxedLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/compareWithBoxedLong.kt");
            doTest(fileName);
        }

        @TestMetadata("divisionByZero.kt")
        public void testDivisionByZero() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/divisionByZero.kt");
            doTest(fileName);
        }

        @TestMetadata("intrinsic.kt")
        public void testIntrinsic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/intrinsic.kt");
            doTest(fileName);
        }

        @TestMetadata("intrinsicAny.kt")
        public void testIntrinsicAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/intrinsicAny.kt");
            doTest(fileName);
        }

        @TestMetadata("intrinsicNullable.kt")
        public void testIntrinsicNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/intrinsicNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11163.kt")
        public void testKt11163() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/kt11163.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6747_identityEquals.kt")
        public void testKt6747_identityEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/kt6747_identityEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("overflowChar.kt")
        public void testOverflowChar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/overflowChar.kt");
            doTest(fileName);
        }

        @TestMetadata("overflowInt.kt")
        public void testOverflowInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/overflowInt.kt");
            doTest(fileName);
        }

        @TestMetadata("overflowLong.kt")
        public void testOverflowLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/binaryOp/overflowLong.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/boxingOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BoxingOptimization extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInBoxingOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("casts.kt")
        public void testCasts() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/casts.kt");
            doTest(fileName);
        }

        @TestMetadata("checkcastAndInstanceOf.kt")
        public void testCheckcastAndInstanceOf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/checkcastAndInstanceOf.kt");
            doTest(fileName);
        }

        @TestMetadata("fold.kt")
        public void testFold() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/fold.kt");
            doTest(fileName);
        }

        @TestMetadata("foldRange.kt")
        public void testFoldRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/foldRange.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5493.kt")
        public void testKt5493() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/kt5493.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5588.kt")
        public void testKt5588() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/kt5588.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5844.kt")
        public void testKt5844() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/kt5844.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6047.kt")
        public void testKt6047() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/kt6047.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6842.kt")
        public void testKt6842() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/kt6842.kt");
            doTest(fileName);
        }

        @TestMetadata("nullCheck.kt")
        public void testNullCheck() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/nullCheck.kt");
            doTest(fileName);
        }

        @TestMetadata("progressions.kt")
        public void testProgressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/progressions.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCallWithElvis.kt")
        public void testSafeCallWithElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvis.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleUninitializedMerge.kt")
        public void testSimpleUninitializedMerge() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/simpleUninitializedMerge.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeRemoving.kt")
        public void testUnsafeRemoving() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/unsafeRemoving.kt");
            doTest(fileName);
        }

        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/boxingOptimization/variables.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/bridges")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Bridges extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInBridges() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/bridges"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("complexMultiInheritance.kt")
        public void testComplexMultiInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/complexMultiInheritance.kt");
            doTest(fileName);
        }

        @TestMetadata("complexTraitImpl.kt")
        public void testComplexTraitImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/complexTraitImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("delegation.kt")
        public void testDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/delegation.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationComplex.kt")
        public void testDelegationComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/delegationComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationComplexWithList.kt")
        public void testDelegationComplexWithList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/delegationComplexWithList.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationProperty.kt")
        public void testDelegationProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/delegationProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("diamond.kt")
        public void testDiamond() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/diamond.kt");
            doTest(fileName);
        }

        @TestMetadata("fakeCovariantOverride.kt")
        public void testFakeCovariantOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/fakeCovariantOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("fakeGenericCovariantOverride.kt")
        public void testFakeGenericCovariantOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("fakeGenericCovariantOverrideWithDelegation.kt")
        public void testFakeGenericCovariantOverrideWithDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverrideWithDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("fakeOverrideOfTraitImpl.kt")
        public void testFakeOverrideOfTraitImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/fakeOverrideOfTraitImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("fakeOverrideWithSeveralSuperDeclarations.kt")
        public void testFakeOverrideWithSeveralSuperDeclarations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/fakeOverrideWithSeveralSuperDeclarations.kt");
            doTest(fileName);
        }

        @TestMetadata("fakeOverrideWithSynthesizedImplementation.kt")
        public void testFakeOverrideWithSynthesizedImplementation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/fakeOverrideWithSynthesizedImplementation.kt");
            doTest(fileName);
        }

        @TestMetadata("genericProperty.kt")
        public void testGenericProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/genericProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("kt12416.kt")
        public void testKt12416() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/kt12416.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1939.kt")
        public void testKt1939() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/kt1939.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1959.kt")
        public void testKt1959() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/kt1959.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2498.kt")
        public void testKt2498() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/kt2498.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2702.kt")
        public void testKt2702() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/kt2702.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2833.kt")
        public void testKt2833() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/kt2833.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2920.kt")
        public void testKt2920() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/kt2920.kt");
            doTest(fileName);
        }

        @TestMetadata("kt318.kt")
        public void testKt318() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/kt318.kt");
            doTest(fileName);
        }

        @TestMetadata("longChainOneBridge.kt")
        public void testLongChainOneBridge() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/longChainOneBridge.kt");
            doTest(fileName);
        }

        @TestMetadata("manyTypeArgumentsSubstitutedSuccessively.kt")
        public void testManyTypeArgumentsSubstitutedSuccessively() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/manyTypeArgumentsSubstitutedSuccessively.kt");
            doTest(fileName);
        }

        @TestMetadata("methodFromTrait.kt")
        public void testMethodFromTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/methodFromTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("noBridgeOnMutableCollectionInheritance.kt")
        public void testNoBridgeOnMutableCollectionInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/noBridgeOnMutableCollectionInheritance.kt");
            doTest(fileName);
        }

        @TestMetadata("objectClone.kt")
        public void testObjectClone() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/objectClone.kt");
            doTest(fileName);
        }

        @TestMetadata("overrideAbstractProperty.kt")
        public void testOverrideAbstractProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/overrideAbstractProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("overrideReturnType.kt")
        public void testOverrideReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/overrideReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessorsWithoutBody.kt")
        public void testPropertyAccessorsWithoutBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/propertyAccessorsWithoutBody.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyDiamond.kt")
        public void testPropertyDiamond() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/propertyDiamond.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyInConstructor.kt")
        public void testPropertyInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/propertyInConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/propertySetter.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleEnum.kt")
        public void testSimpleEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/simpleEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleGenericMethod.kt")
        public void testSimpleGenericMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/simpleGenericMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/simpleObject.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleReturnType.kt")
        public void testSimpleReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/simpleReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleTraitImpl.kt")
        public void testSimpleTraitImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/simpleTraitImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleUpperBound.kt")
        public void testSimpleUpperBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/simpleUpperBound.kt");
            doTest(fileName);
        }

        @TestMetadata("strListContains.kt")
        public void testStrListContains() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/strListContains.kt");
            doTest(fileName);
        }

        @TestMetadata("traitImplInheritsTraitImpl.kt")
        public void testTraitImplInheritsTraitImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/traitImplInheritsTraitImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("twoParentsWithDifferentMethodsTwoBridges.kt")
        public void testTwoParentsWithDifferentMethodsTwoBridges() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges.kt");
            doTest(fileName);
        }

        @TestMetadata("twoParentsWithDifferentMethodsTwoBridges2.kt")
        public void testTwoParentsWithDifferentMethodsTwoBridges2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges2.kt");
            doTest(fileName);
        }

        @TestMetadata("twoParentsWithTheSameMethodOneBridge.kt")
        public void testTwoParentsWithTheSameMethodOneBridge() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/twoParentsWithTheSameMethodOneBridge.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SubstitutionInSuperClass extends AbstractIrBlackBoxCodegenTest {
            @TestMetadata("abstractFun.kt")
            public void testAbstractFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/abstractFun.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInSubstitutionInSuperClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/bridges/substitutionInSuperClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("boundedTypeArguments.kt")
            public void testBoundedTypeArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/boundedTypeArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("delegation.kt")
            public void testDelegation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/delegation.kt");
                doTest(fileName);
            }

            @TestMetadata("differentErasureInSuperClass.kt")
            public void testDifferentErasureInSuperClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClass.kt");
                doTest(fileName);
            }

            @TestMetadata("differentErasureInSuperClassComplex.kt")
            public void testDifferentErasureInSuperClassComplex() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClassComplex.kt");
                doTest(fileName);
            }

            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/enum.kt");
                doTest(fileName);
            }

            @TestMetadata("genericMethod.kt")
            public void testGenericMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/genericMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/object.kt");
                doTest(fileName);
            }

            @TestMetadata("property.kt")
            public void testProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/property.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("upperBound.kt")
            public void testUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass/upperBound.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/builtinStubMethods")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BuiltinStubMethods extends AbstractIrBlackBoxCodegenTest {
        @TestMetadata("abstractMember.kt")
        public void testAbstractMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/abstractMember.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInBuiltinStubMethods() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("Collection.kt")
        public void testCollection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/Collection.kt");
            doTest(fileName);
        }

        @TestMetadata("customReadOnlyIterator.kt")
        public void testCustomReadOnlyIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/customReadOnlyIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationToArrayList.kt")
        public void testDelegationToArrayList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/delegationToArrayList.kt");
            doTest(fileName);
        }

        @TestMetadata("immutableRemove.kt")
        public void testImmutableRemove() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/immutableRemove.kt");
            doTest(fileName);
        }

        @TestMetadata("implementationInTrait.kt")
        public void testImplementationInTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/implementationInTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritedImplementations.kt")
        public void testInheritedImplementations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/inheritedImplementations.kt");
            doTest(fileName);
        }

        @TestMetadata("Iterator.kt")
        public void testIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/Iterator.kt");
            doTest(fileName);
        }

        @TestMetadata("IteratorWithRemove.kt")
        public void testIteratorWithRemove() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/IteratorWithRemove.kt");
            doTest(fileName);
        }

        @TestMetadata("List.kt")
        public void testList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/List.kt");
            doTest(fileName);
        }

        @TestMetadata("ListIterator.kt")
        public void testListIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/ListIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("ListWithAllImplementations.kt")
        public void testListWithAllImplementations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/ListWithAllImplementations.kt");
            doTest(fileName);
        }

        @TestMetadata("ListWithAllInheritedImplementations.kt")
        public void testListWithAllInheritedImplementations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/ListWithAllInheritedImplementations.kt");
            doTest(fileName);
        }

        @TestMetadata("manyTypeParametersWithUpperBounds.kt")
        public void testManyTypeParametersWithUpperBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/manyTypeParametersWithUpperBounds.kt");
            doTest(fileName);
        }

        @TestMetadata("Map.kt")
        public void testMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/Map.kt");
            doTest(fileName);
        }

        @TestMetadata("MapEntry.kt")
        public void testMapEntry() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/MapEntry.kt");
            doTest(fileName);
        }

        @TestMetadata("MapEntryWithSetValue.kt")
        public void testMapEntryWithSetValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/MapEntryWithSetValue.kt");
            doTest(fileName);
        }

        @TestMetadata("MapWithAllImplementations.kt")
        public void testMapWithAllImplementations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/MapWithAllImplementations.kt");
            doTest(fileName);
        }

        @TestMetadata("nonTrivialSubstitution.kt")
        public void testNonTrivialSubstitution() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/nonTrivialSubstitution.kt");
            doTest(fileName);
        }

        @TestMetadata("nonTrivialUpperBound.kt")
        public void testNonTrivialUpperBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/nonTrivialUpperBound.kt");
            doTest(fileName);
        }

        @TestMetadata("substitutedIterable.kt")
        public void testSubstitutedIterable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/substitutedIterable.kt");
            doTest(fileName);
        }

        @TestMetadata("SubstitutedList.kt")
        public void testSubstitutedList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/SubstitutedList.kt");
            doTest(fileName);
        }

        @TestMetadata("substitutedListWithExtraSuperInterface.kt")
        public void testSubstitutedListWithExtraSuperInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/substitutedListWithExtraSuperInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExtendJavaCollections extends AbstractIrBlackBoxCodegenTest {
            @TestMetadata("abstractList.kt")
            public void testAbstractList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/abstractList.kt");
                doTest(fileName);
            }

            @TestMetadata("abstractMap.kt")
            public void testAbstractMap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/abstractMap.kt");
                doTest(fileName);
            }

            @TestMetadata("abstractSet.kt")
            public void testAbstractSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/abstractSet.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInExtendJavaCollections() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("arrayList.kt")
            public void testArrayList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/arrayList.kt");
                doTest(fileName);
            }

            @TestMetadata("hashMap.kt")
            public void testHashMap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/hashMap.kt");
                doTest(fileName);
            }

            @TestMetadata("hashSet.kt")
            public void testHashSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/hashSet.kt");
                doTest(fileName);
            }

            @TestMetadata("mapEntry.kt")
            public void testMapEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaCollections/mapEntry.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInCallableReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/bound")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bound extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInBound() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("enumEntryMember.kt")
            public void testEnumEntryMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/bound/enumEntryMember.kt");
                doTest(fileName);
            }

            @TestMetadata("kCallableNameIntrinsic.kt")
            public void testKCallableNameIntrinsic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/bound/kCallableNameIntrinsic.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12738.kt")
            public void testKt12738() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/bound/kt12738.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleFunction.kt")
            public void testSimpleFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/bound/simpleFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleProperty.kt")
            public void testSimpleProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/bound/simpleProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("syntheticExtensionOnLHS.kt")
            public void testSyntheticExtensionOnLHS() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/bound/syntheticExtensionOnLHS.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/bound/inline")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inline extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInInline() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound/inline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/bound/inline/simple.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleVal.kt")
                public void testSimpleVal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/bound/inline/simpleVal.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractIrBlackBoxCodegenTest {
            @TestMetadata("abstractClassMember.kt")
            public void testAbstractClassMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/abstractClassMember.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("booleanNotIntrinsic.kt")
            public void testBooleanNotIntrinsic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/booleanNotIntrinsic.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromClass.kt")
            public void testClassMemberFromClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/classMemberFromClass.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromExtension.kt")
            public void testClassMemberFromExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/classMemberFromExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromTopLevelStringNoArgs.kt")
            public void testClassMemberFromTopLevelStringNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromTopLevelStringOneStringArg.kt")
            public void testClassMemberFromTopLevelStringOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromTopLevelUnitNoArgs.kt")
            public void testClassMemberFromTopLevelUnitNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromTopLevelUnitOneStringArg.kt")
            public void testClassMemberFromTopLevelUnitOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorFromTopLevelNoArgs.kt")
            public void testConstructorFromTopLevelNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorFromTopLevelOneStringArg.kt")
            public void testConstructorFromTopLevelOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("enumValueOfMethod.kt")
            public void testEnumValueOfMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/enumValueOfMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("equalsIntrinsic.kt")
            public void testEqualsIntrinsic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/equalsIntrinsic.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromClass.kt")
            public void testExtensionFromClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/extensionFromClass.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromExtension.kt")
            public void testExtensionFromExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/extensionFromExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromTopLevelStringNoArgs.kt")
            public void testExtensionFromTopLevelStringNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromTopLevelStringOneStringArg.kt")
            public void testExtensionFromTopLevelStringOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromTopLevelUnitNoArgs.kt")
            public void testExtensionFromTopLevelUnitNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromTopLevelUnitOneStringArg.kt")
            public void testExtensionFromTopLevelUnitOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("genericMember.kt")
            public void testGenericMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/genericMember.kt");
                doTest(fileName);
            }

            @TestMetadata("getArityViaFunctionImpl.kt")
            public void testGetArityViaFunctionImpl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/getArityViaFunctionImpl.kt");
                doTest(fileName);
            }

            @TestMetadata("innerConstructorFromClass.kt")
            public void testInnerConstructorFromClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/innerConstructorFromClass.kt");
                doTest(fileName);
            }

            @TestMetadata("innerConstructorFromExtension.kt")
            public void testInnerConstructorFromExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/innerConstructorFromExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("innerConstructorFromTopLevelNoArgs.kt")
            public void testInnerConstructorFromTopLevelNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("innerConstructorFromTopLevelOneStringArg.kt")
            public void testInnerConstructorFromTopLevelOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("javaCollectionsStaticMethod.kt")
            public void testJavaCollectionsStaticMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/javaCollectionsStaticMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedConstructorFromClass.kt")
            public void testNestedConstructorFromClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromClass.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedConstructorFromTopLevelNoArgs.kt")
            public void testNestedConstructorFromTopLevelNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedConstructorFromTopLevelOneStringArg.kt")
            public void testNestedConstructorFromTopLevelOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("newArray.kt")
            public void testNewArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/newArray.kt");
                doTest(fileName);
            }

            @TestMetadata("overloadedFun.kt")
            public void testOverloadedFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/overloadedFun.kt");
                doTest(fileName);
            }

            @TestMetadata("overloadedFunVsVal.kt")
            public void testOverloadedFunVsVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/overloadedFunVsVal.kt");
                doTest(fileName);
            }

            @TestMetadata("privateClassMember.kt")
            public void testPrivateClassMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/privateClassMember.kt");
                doTest(fileName);
            }

            @TestMetadata("sortListOfStrings.kt")
            public void testSortListOfStrings() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/sortListOfStrings.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFromClass.kt")
            public void testTopLevelFromClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/topLevelFromClass.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFromExtension.kt")
            public void testTopLevelFromExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/topLevelFromExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFromTopLevelStringNoArgs.kt")
            public void testTopLevelFromTopLevelStringNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFromTopLevelStringOneStringArg.kt")
            public void testTopLevelFromTopLevelStringOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFromTopLevelUnitNoArgs.kt")
            public void testTopLevelFromTopLevelUnitNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFromTopLevelUnitOneStringArg.kt")
            public void testTopLevelFromTopLevelUnitOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("traitImplMethodWithClassReceiver.kt")
            public void testTraitImplMethodWithClassReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/traitImplMethodWithClassReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("traitMember.kt")
            public void testTraitMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/traitMember.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/box/callableReference/function/local")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Local extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInLocal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function/local"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("captureOuter.kt")
                public void testCaptureOuter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/captureOuter.kt");
                    doTest(fileName);
                }

                @TestMetadata("classMember.kt")
                public void testClassMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/classMember.kt");
                    doTest(fileName);
                }

                @TestMetadata("closureWithSideEffect.kt")
                public void testClosureWithSideEffect() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/closureWithSideEffect.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructor.kt")
                public void testConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/constructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructorWithInitializer.kt")
                public void testConstructorWithInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/constructorWithInitializer.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumExtendsTrait.kt")
                public void testEnumExtendsTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/enumExtendsTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("extension.kt")
                public void testExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/extension.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionToLocalClass.kt")
                public void testExtensionToLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/extensionToLocalClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionToPrimitive.kt")
                public void testExtensionToPrimitive() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/extensionToPrimitive.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionWithClosure.kt")
                public void testExtensionWithClosure() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/extensionWithClosure.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericMember.kt")
                public void testGenericMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/genericMember.kt");
                    doTest(fileName);
                }

                @TestMetadata("localClassMember.kt")
                public void testLocalClassMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/localClassMember.kt");
                    doTest(fileName);
                }

                @TestMetadata("localFunctionName.kt")
                public void testLocalFunctionName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/localFunctionName.kt");
                    doTest(fileName);
                }

                @TestMetadata("localLocal.kt")
                public void testLocalLocal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/localLocal.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveClosure.kt")
                public void testRecursiveClosure() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/recursiveClosure.kt");
                    doTest(fileName);
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/simple.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleClosure.kt")
                public void testSimpleClosure() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/simpleClosure.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWithArg.kt")
                public void testSimpleWithArg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/simpleWithArg.kt");
                    doTest(fileName);
                }

                @TestMetadata("unitWithSideEffect.kt")
                public void testUnitWithSideEffect() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/function/local/unitWithSideEffect.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/callableReference/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractIrBlackBoxCodegenTest {
            @TestMetadata("accessViaSubclass.kt")
            public void testAccessViaSubclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/accessViaSubclass.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/callableReference/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("delegated.kt")
            public void testDelegated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/delegated.kt");
                doTest(fileName);
            }

            @TestMetadata("delegatedMutable.kt")
            public void testDelegatedMutable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/delegatedMutable.kt");
                doTest(fileName);
            }

            @TestMetadata("enumNameOrdinal.kt")
            public void testEnumNameOrdinal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/enumNameOrdinal.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionToArray.kt")
            public void testExtensionToArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/extensionToArray.kt");
                doTest(fileName);
            }

            @TestMetadata("genericProperty.kt")
            public void testGenericProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/genericProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("invokePropertyReference.kt")
            public void testInvokePropertyReference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/invokePropertyReference.kt");
                doTest(fileName);
            }

            @TestMetadata("javaBeanConvention.kt")
            public void testJavaBeanConvention() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/javaBeanConvention.kt");
                doTest(fileName);
            }

            @TestMetadata("kClassInstanceIsInitializedFirst.kt")
            public void testKClassInstanceIsInitializedFirst() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/kClassInstanceIsInitializedFirst.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12982_protectedPropertyReference.kt")
            public void testKt12982_protectedPropertyReference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/kt12982_protectedPropertyReference.kt");
                doTest(fileName);
            }

            @TestMetadata("kt14330.kt")
            public void testKt14330() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/kt14330.kt");
                doTest(fileName);
            }

            @TestMetadata("kt14330_2.kt")
            public void testKt14330_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/kt14330_2.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6870_privatePropertyReference.kt")
            public void testKt6870_privatePropertyReference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/kt6870_privatePropertyReference.kt");
                doTest(fileName);
            }

            @TestMetadata("listOfStringsMapLength.kt")
            public void testListOfStringsMapLength() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/listOfStringsMapLength.kt");
                doTest(fileName);
            }

            @TestMetadata("localClassVar.kt")
            public void testLocalClassVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/localClassVar.kt");
                doTest(fileName);
            }

            @TestMetadata("overriddenInSubclass.kt")
            public void testOverriddenInSubclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/overriddenInSubclass.kt");
                doTest(fileName);
            }

            @TestMetadata("privateSetterInsideClass.kt")
            public void testPrivateSetterInsideClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/privateSetterInsideClass.kt");
                doTest(fileName);
            }

            @TestMetadata("privateSetterOutsideClass.kt")
            public void testPrivateSetterOutsideClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/privateSetterOutsideClass.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleExtension.kt")
            public void testSimpleExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/simpleExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleMember.kt")
            public void testSimpleMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/simpleMember.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleMutableExtension.kt")
            public void testSimpleMutableExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/simpleMutableExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleMutableMember.kt")
            public void testSimpleMutableMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/simpleMutableMember.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleMutableTopLevel.kt")
            public void testSimpleMutableTopLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/simpleMutableTopLevel.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleTopLevel.kt")
            public void testSimpleTopLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/callableReference/property/simpleTopLevel.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/casts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Casts extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInCasts() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/casts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("as.kt")
        public void testAs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/as.kt");
            doTest(fileName);
        }

        @TestMetadata("asForConstants.kt")
        public void testAsForConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/asForConstants.kt");
            doTest(fileName);
        }

        @TestMetadata("asSafe.kt")
        public void testAsSafe() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/asSafe.kt");
            doTest(fileName);
        }

        @TestMetadata("asSafeFail.kt")
        public void testAsSafeFail() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/asSafeFail.kt");
            doTest(fileName);
        }

        @TestMetadata("asSafeForConstants.kt")
        public void testAsSafeForConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/asSafeForConstants.kt");
            doTest(fileName);
        }

        @TestMetadata("asUnit.kt")
        public void testAsUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/asUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("asWithGeneric.kt")
        public void testAsWithGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/asWithGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("castGenericNull.kt")
        public void testCastGenericNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/castGenericNull.kt");
            doTest(fileName);
        }

        @TestMetadata("intersectionTypeMultipleBounds.kt")
        public void testIntersectionTypeMultipleBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/intersectionTypeMultipleBounds.kt");
            doTest(fileName);
        }

        @TestMetadata("intersectionTypeSmartcast.kt")
        public void testIntersectionTypeSmartcast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/intersectionTypeSmartcast.kt");
            doTest(fileName);
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/is.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaToUnitCast.kt")
        public void testLambdaToUnitCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/lambdaToUnitCast.kt");
            doTest(fileName);
        }

        @TestMetadata("notIs.kt")
        public void testNotIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/notIs.kt");
            doTest(fileName);
        }

        @TestMetadata("unitAsAny.kt")
        public void testUnitAsAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/unitAsAny.kt");
            doTest(fileName);
        }

        @TestMetadata("unitAsInt.kt")
        public void testUnitAsInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/unitAsInt.kt");
            doTest(fileName);
        }

        @TestMetadata("unitAsSafeAny.kt")
        public void testUnitAsSafeAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/unitAsSafeAny.kt");
            doTest(fileName);
        }

        @TestMetadata("unitNullableCast.kt")
        public void testUnitNullableCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/unitNullableCast.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/casts/functions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Functions extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInFunctions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/casts/functions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("asFunKBig.kt")
            public void testAsFunKBig() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/asFunKBig.kt");
                doTest(fileName);
            }

            @TestMetadata("asFunKSmall.kt")
            public void testAsFunKSmall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/asFunKSmall.kt");
                doTest(fileName);
            }

            @TestMetadata("isFunKBig.kt")
            public void testIsFunKBig() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/isFunKBig.kt");
                doTest(fileName);
            }

            @TestMetadata("isFunKSmall.kt")
            public void testIsFunKSmall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/isFunKSmall.kt");
                doTest(fileName);
            }

            @TestMetadata("javaTypeIsFunK.kt")
            public void testJavaTypeIsFunK() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/javaTypeIsFunK.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedAsFunKBig.kt")
            public void testReifiedAsFunKBig() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/reifiedAsFunKBig.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedAsFunKSmall.kt")
            public void testReifiedAsFunKSmall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/reifiedAsFunKSmall.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedIsFunKBig.kt")
            public void testReifiedIsFunKBig() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/reifiedIsFunKBig.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedIsFunKSmall.kt")
            public void testReifiedIsFunKSmall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/reifiedIsFunKSmall.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedSafeAsFunKBig.kt")
            public void testReifiedSafeAsFunKBig() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKBig.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedSafeAsFunKSmall.kt")
            public void testReifiedSafeAsFunKSmall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKSmall.kt");
                doTest(fileName);
            }

            @TestMetadata("safeAsFunKBig.kt")
            public void testSafeAsFunKBig() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/safeAsFunKBig.kt");
                doTest(fileName);
            }

            @TestMetadata("safeAsFunKSmall.kt")
            public void testSafeAsFunKSmall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/functions/safeAsFunKSmall.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LiteralExpressionAsGenericArgument extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInLiteralExpressionAsGenericArgument() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("binaryExpressionCast.kt")
            public void testBinaryExpressionCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/binaryExpressionCast.kt");
                doTest(fileName);
            }

            @TestMetadata("javaBox.kt")
            public void testJavaBox() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/javaBox.kt");
                doTest(fileName);
            }

            @TestMetadata("labeledExpressionCast.kt")
            public void testLabeledExpressionCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/labeledExpressionCast.kt");
                doTest(fileName);
            }

            @TestMetadata("parenthesizedExpressionCast.kt")
            public void testParenthesizedExpressionCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/parenthesizedExpressionCast.kt");
                doTest(fileName);
            }

            @TestMetadata("superConstructor.kt")
            public void testSuperConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/superConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("unaryExpressionCast.kt")
            public void testUnaryExpressionCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/unaryExpressionCast.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/vararg.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/casts/mutableCollections")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MutableCollections extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInMutableCollections() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/casts/mutableCollections"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("asWithMutable.kt")
            public void testAsWithMutable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/mutableCollections/asWithMutable.kt");
                doTest(fileName);
            }

            @TestMetadata("isWithMutable.kt")
            public void testIsWithMutable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/mutableCollections/isWithMutable.kt");
                doTest(fileName);
            }

            @TestMetadata("mutabilityMarkerInterfaces.kt")
            public void testMutabilityMarkerInterfaces() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/mutableCollections/mutabilityMarkerInterfaces.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedAsWithMutable.kt")
            public void testReifiedAsWithMutable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/mutableCollections/reifiedAsWithMutable.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedIsWithMutable.kt")
            public void testReifiedIsWithMutable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/mutableCollections/reifiedIsWithMutable.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedSafeAsWithMutable.kt")
            public void testReifiedSafeAsWithMutable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/mutableCollections/reifiedSafeAsWithMutable.kt");
                doTest(fileName);
            }

            @TestMetadata("safeAsWithMutable.kt")
            public void testSafeAsWithMutable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/mutableCollections/safeAsWithMutable.kt");
                doTest(fileName);
            }

            @TestMetadata("weirdMutableCasts.kt")
            public void testWeirdMutableCasts() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/casts/mutableCollections/weirdMutableCasts.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/classLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ClassLiteral extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInClassLiteral() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/classLiteral"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("primitiveKClassEquality.kt")
        public void testPrimitiveKClassEquality() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/primitiveKClassEquality.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/classLiteral/bound")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bound extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInBound() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/bound"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("javaIntrinsicWithSideEffect.kt")
            public void testJavaIntrinsicWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/bound/javaIntrinsicWithSideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("primitives.kt")
            public void testPrimitives() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/bound/primitives.kt");
                doTest(fileName);
            }

            @TestMetadata("sideEffect.kt")
            public void testSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/bound/sideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/bound/simple.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/classLiteral/java")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Java extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInJava() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/java"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("java.kt")
            public void testJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/java/java.kt");
                doTest(fileName);
            }

            @TestMetadata("javaObjectType.kt")
            public void testJavaObjectType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/java/javaObjectType.kt");
                doTest(fileName);
            }

            @TestMetadata("javaObjectTypeReified.kt")
            public void testJavaObjectTypeReified() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/java/javaObjectTypeReified.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPrimitiveType.kt")
            public void testJavaPrimitiveType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/java/javaPrimitiveType.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPrimitiveTypeReified.kt")
            public void testJavaPrimitiveTypeReified() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/java/javaPrimitiveTypeReified.kt");
                doTest(fileName);
            }

            @TestMetadata("javaReified.kt")
            public void testJavaReified() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/java/javaReified.kt");
                doTest(fileName);
            }

            @TestMetadata("kt11943.kt")
            public void testKt11943() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/java/kt11943.kt");
                doTest(fileName);
            }

            @TestMetadata("objectSuperConstructorCall.kt")
            public void testObjectSuperConstructorCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classLiteral/java/objectSuperConstructorCall.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/classes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Classes extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/classes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("boxPrimitiveTypeInClinitOfClassObject.kt")
        public void testBoxPrimitiveTypeInClinitOfClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/boxPrimitiveTypeInClinitOfClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("classCompanionInitializationWithJava.kt")
        public void testClassCompanionInitializationWithJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classCompanionInitializationWithJava.kt");
            doTest(fileName);
        }

        @TestMetadata("classNamedAsOldPackageFacade.kt")
        public void testClassNamedAsOldPackageFacade() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classNamedAsOldPackageFacade.kt");
            doTest(fileName);
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classObject.kt");
            doTest(fileName);
        }

        @TestMetadata("classObjectAsExtensionReceiver.kt")
        public void testClassObjectAsExtensionReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classObjectAsExtensionReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("classObjectAsStaticInitializer.kt")
        public void testClassObjectAsStaticInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classObjectAsStaticInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("classObjectField.kt")
        public void testClassObjectField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classObjectField.kt");
            doTest(fileName);
        }

        @TestMetadata("classObjectInTrait.kt")
        public void testClassObjectInTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classObjectInTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("classObjectNotOfEnum.kt")
        public void testClassObjectNotOfEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classObjectNotOfEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("classObjectToString.kt")
        public void testClassObjectToString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classObjectToString.kt");
            doTest(fileName);
        }

        @TestMetadata("classObjectWithPrivateGenericMember.kt")
        public void testClassObjectWithPrivateGenericMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classObjectWithPrivateGenericMember.kt");
            doTest(fileName);
        }

        @TestMetadata("classObjectsWithParentClasses.kt")
        public void testClassObjectsWithParentClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/classObjectsWithParentClasses.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultObjectSameNamesAsInOuter.kt")
        public void testDefaultObjectSameNamesAsInOuter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/defaultObjectSameNamesAsInOuter.kt");
            doTest(fileName);
        }

        @TestMetadata("delegation2.kt")
        public void testDelegation2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/delegation2.kt");
            doTest(fileName);
        }

        @TestMetadata("delegation3.kt")
        public void testDelegation3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/delegation3.kt");
            doTest(fileName);
        }

        @TestMetadata("delegation4.kt")
        public void testDelegation4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/delegation4.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationGenericArg.kt")
        public void testDelegationGenericArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/delegationGenericArg.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationGenericArgUpperBound.kt")
        public void testDelegationGenericArgUpperBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/delegationGenericArgUpperBound.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationGenericLongArg.kt")
        public void testDelegationGenericLongArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/delegationGenericLongArg.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationJava.kt")
        public void testDelegationJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/delegationJava.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationMethodsWithArgs.kt")
        public void testDelegationMethodsWithArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/delegationMethodsWithArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("exceptionConstructor.kt")
        public void testExceptionConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/exceptionConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionOnNamedClassObject.kt")
        public void testExtensionOnNamedClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/extensionOnNamedClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("funDelegation.kt")
        public void testFunDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/funDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("implementComparableInSubclass.kt")
        public void testImplementComparableInSubclass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/implementComparableInSubclass.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritSetAndHashSet.kt")
        public void testInheritSetAndHashSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/inheritSetAndHashSet.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritance.kt")
        public void testInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/inheritance.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritedInnerClass.kt")
        public void testInheritedInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/inheritedInnerClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritedMethod.kt")
        public void testInheritedMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/inheritedMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("initializerBlock.kt")
        public void testInitializerBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/initializerBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("initializerBlockDImpl.kt")
        public void testInitializerBlockDImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/initializerBlockDImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/innerClass.kt");
            doTest(fileName);
        }

        @TestMetadata("interfaceCompanionInitializationWithJava.kt")
        public void testInterfaceCompanionInitializationWithJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/interfaceCompanionInitializationWithJava.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1018.kt")
        public void testKt1018() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1018.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1120.kt")
        public void testKt1120() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1120.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1134.kt")
        public void testKt1134() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1134.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1157.kt")
        public void testKt1157() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1157.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1247.kt")
        public void testKt1247() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1247.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1345.kt")
        public void testKt1345() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1345.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1439.kt")
        public void testKt1439() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1439.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1535.kt")
        public void testKt1535() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1535.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1538.kt")
        public void testKt1538() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1538.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1578.kt")
        public void testKt1578() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1578.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1611.kt")
        public void testKt1611() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1611.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1721.kt")
        public void testKt1721() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1721.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1726.kt")
        public void testKt1726() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1726.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1759.kt")
        public void testKt1759() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1759.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1891.kt")
        public void testKt1891() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1891.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1918.kt")
        public void testKt1918() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1918.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1976.kt")
        public void testKt1976() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1976.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1980.kt")
        public void testKt1980() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt1980.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2224.kt")
        public void testKt2224() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2224.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2288.kt")
        public void testKt2288() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2288.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2384.kt")
        public void testKt2384() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2384.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2390.kt")
        public void testKt2390() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2390.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2391.kt")
        public void testKt2391() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2391.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2395.kt")
        public void testKt2395() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2395.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2417.kt")
        public void testKt2417() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2417.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2477.kt")
        public void testKt2477() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2477.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2480.kt")
        public void testKt2480() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2480.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2482.kt")
        public void testKt2482() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2482.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2485.kt")
        public void testKt2485() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2485.kt");
            doTest(fileName);
        }

        @TestMetadata("kt249.kt")
        public void testKt249() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt249.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2532.kt")
        public void testKt2532() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2532.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2566.kt")
        public void testKt2566() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2566.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2566_2.kt")
        public void testKt2566_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2566_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2607.kt")
        public void testKt2607() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2607.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2626.kt")
        public void testKt2626() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2626.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2711.kt")
        public void testKt2711() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2711.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2784.kt")
        public void testKt2784() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt2784.kt");
            doTest(fileName);
        }

        @TestMetadata("kt285.kt")
        public void testKt285() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt285.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3001.kt")
        public void testKt3001() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt3001.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3114.kt")
        public void testKt3114() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt3114.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3414.kt")
        public void testKt3414() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt3414.kt");
            doTest(fileName);
        }

        @TestMetadata("kt343.kt")
        public void testKt343() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt343.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3546.kt")
        public void testKt3546() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt3546.kt");
            doTest(fileName);
        }

        @TestMetadata("kt454.kt")
        public void testKt454() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt454.kt");
            doTest(fileName);
        }

        @TestMetadata("kt471.kt")
        public void testKt471() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt471.kt");
            doTest(fileName);
        }

        @TestMetadata("kt48.kt")
        public void testKt48() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt48.kt");
            doTest(fileName);
        }

        @TestMetadata("kt496.kt")
        public void testKt496() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt496.kt");
            doTest(fileName);
        }

        @TestMetadata("kt500.kt")
        public void testKt500() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt500.kt");
            doTest(fileName);
        }

        @TestMetadata("kt501.kt")
        public void testKt501() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt501.kt");
            doTest(fileName);
        }

        @TestMetadata("kt504.kt")
        public void testKt504() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt504.kt");
            doTest(fileName);
        }

        @TestMetadata("kt508.kt")
        public void testKt508() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt508.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5347.kt")
        public void testKt5347() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt5347.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6136.kt")
        public void testKt6136() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt6136.kt");
            doTest(fileName);
        }

        @TestMetadata("kt633.kt")
        public void testKt633() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt633.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6816.kt")
        public void testKt6816() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt6816.kt");
            doTest(fileName);
        }

        @TestMetadata("kt707.kt")
        public void testKt707() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt707.kt");
            doTest(fileName);
        }

        @TestMetadata("kt723.kt")
        public void testKt723() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt723.kt");
            doTest(fileName);
        }

        @TestMetadata("kt725.kt")
        public void testKt725() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt725.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8011.kt")
        public void testKt8011() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt8011.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8011a.kt")
        public void testKt8011a() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt8011a.kt");
            doTest(fileName);
        }

        @TestMetadata("kt903.kt")
        public void testKt903() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt903.kt");
            doTest(fileName);
        }

        @TestMetadata("kt940.kt")
        public void testKt940() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt940.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9642.kt")
        public void testKt9642() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/kt9642.kt");
            doTest(fileName);
        }

        @TestMetadata("namedClassObject.kt")
        public void testNamedClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/namedClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("outerThis.kt")
        public void testOuterThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/outerThis.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadBinaryOperator.kt")
        public void testOverloadBinaryOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/overloadBinaryOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadPlusAssign.kt")
        public void testOverloadPlusAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/overloadPlusAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadPlusAssignReturn.kt")
        public void testOverloadPlusAssignReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/overloadPlusAssignReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadPlusToPlusAssign.kt")
        public void testOverloadPlusToPlusAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/overloadPlusToPlusAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadUnaryOperator.kt")
        public void testOverloadUnaryOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/overloadUnaryOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("privateOuterFunctions.kt")
        public void testPrivateOuterFunctions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/privateOuterFunctions.kt");
            doTest(fileName);
        }

        @TestMetadata("privateOuterProperty.kt")
        public void testPrivateOuterProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/privateOuterProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("privateToThis.kt")
        public void testPrivateToThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/privateToThis.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyDelegation.kt")
        public void testPropertyDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/propertyDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyInInitializer.kt")
        public void testPropertyInInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/propertyInInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("rightHandOverride.kt")
        public void testRightHandOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/rightHandOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("sealedInSameFile.kt")
        public void testSealedInSameFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/sealedInSameFile.kt");
            doTest(fileName);
        }

        @TestMetadata("selfcreate.kt")
        public void testSelfcreate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/selfcreate.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleBox.kt")
        public void testSimpleBox() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/simpleBox.kt");
            doTest(fileName);
        }

        @TestMetadata("typedDelegation.kt")
        public void testTypedDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/typedDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/classes/inner")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inner extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInInner() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/classes/inner"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("instantiateInDerived.kt")
            public void testInstantiateInDerived() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/inner/instantiateInDerived.kt");
                doTest(fileName);
            }

            @TestMetadata("instantiateInDerivedLabeled.kt")
            public void testInstantiateInDerivedLabeled() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/inner/instantiateInDerivedLabeled.kt");
                doTest(fileName);
            }

            @TestMetadata("instantiateInSameClass.kt")
            public void testInstantiateInSameClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/inner/instantiateInSameClass.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6708.kt")
            public void testKt6708() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/inner/kt6708.kt");
                doTest(fileName);
            }

            @TestMetadata("properOuter.kt")
            public void testProperOuter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/inner/properOuter.kt");
                doTest(fileName);
            }

            @TestMetadata("properSuperLinking.kt")
            public void testProperSuperLinking() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/classes/inner/properSuperLinking.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/closures")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Closures extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInClosures() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/closures"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("captureExtensionReceiver.kt")
        public void testCaptureExtensionReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/captureExtensionReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedLocalGenericFun.kt")
        public void testCapturedLocalGenericFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/capturedLocalGenericFun.kt");
            doTest(fileName);
        }

        @TestMetadata("closureInsideConstrucor.kt")
        public void testClosureInsideConstrucor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureInsideConstrucor.kt");
            doTest(fileName);
        }

        @TestMetadata("closureOnTopLevel1.kt")
        public void testClosureOnTopLevel1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureOnTopLevel1.kt");
            doTest(fileName);
        }

        @TestMetadata("closureOnTopLevel2.kt")
        public void testClosureOnTopLevel2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureOnTopLevel2.kt");
            doTest(fileName);
        }

        @TestMetadata("closureWithParameter.kt")
        public void testClosureWithParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureWithParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("closureWithParameterAndBoxing.kt")
        public void testClosureWithParameterAndBoxing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureWithParameterAndBoxing.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleEnclosedLocalVariable.kt")
        public void testDoubleEnclosedLocalVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/doubleEnclosedLocalVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("enclosingLocalVariable.kt")
        public void testEnclosingLocalVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/enclosingLocalVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("enclosingThis.kt")
        public void testEnclosingThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/enclosingThis.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionClosure.kt")
        public void testExtensionClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/extensionClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10044.kt")
        public void testKt10044() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt10044.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11634.kt")
        public void testKt11634() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt11634.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11634_2.kt")
        public void testKt11634_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt11634_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11634_3.kt")
        public void testKt11634_3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt11634_3.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11634_4.kt")
        public void testKt11634_4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt11634_4.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2151.kt")
        public void testKt2151() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt2151.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3152.kt")
        public void testKt3152() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt3152.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3523.kt")
        public void testKt3523() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt3523.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3738.kt")
        public void testKt3738() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt3738.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3905.kt")
        public void testKt3905() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt3905.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4106.kt")
        public void testKt4106() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt4106.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4137.kt")
        public void testKt4137() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt4137.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5589.kt")
        public void testKt5589() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/kt5589.kt");
            doTest(fileName);
        }

        @TestMetadata("localClassFunClosure.kt")
        public void testLocalClassFunClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/localClassFunClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("localClassLambdaClosure.kt")
        public void testLocalClassLambdaClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/localClassLambdaClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("localFunctionInFunction.kt")
        public void testLocalFunctionInFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/localFunctionInFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("localFunctionInInitializer.kt")
        public void testLocalFunctionInInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/localFunctionInInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("localGenericFun.kt")
        public void testLocalGenericFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/localGenericFun.kt");
            doTest(fileName);
        }

        @TestMetadata("localReturn.kt")
        public void testLocalReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/localReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("localReturnWithAutolabel.kt")
        public void testLocalReturnWithAutolabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/localReturnWithAutolabel.kt");
            doTest(fileName);
        }

        @TestMetadata("noRefToOuter.kt")
        public void testNoRefToOuter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/noRefToOuter.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveClosure.kt")
        public void testRecursiveClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/recursiveClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("simplestClosure.kt")
        public void testSimplestClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/simplestClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("simplestClosureAndBoxing.kt")
        public void testSimplestClosureAndBoxing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/simplestClosureAndBoxing.kt");
            doTest(fileName);
        }

        @TestMetadata("subclosuresWithinInitializers.kt")
        public void testSubclosuresWithinInitializers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/subclosuresWithinInitializers.kt");
            doTest(fileName);
        }

        @TestMetadata("underscoreParameters.kt")
        public void testUnderscoreParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/underscoreParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/closures/captureOuterProperty")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CaptureOuterProperty extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInCaptureOuterProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/closures/captureOuterProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("captureFunctionInProperty.kt")
            public void testCaptureFunctionInProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/captureOuterProperty/captureFunctionInProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("inFunction.kt")
            public void testInFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/captureOuterProperty/inFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("inProperty.kt")
            public void testInProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/captureOuterProperty/inProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("inPropertyDeepObjectChain.kt")
            public void testInPropertyDeepObjectChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyDeepObjectChain.kt");
                doTest(fileName);
            }

            @TestMetadata("inPropertyFromSuperClass.kt")
            public void testInPropertyFromSuperClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperClass.kt");
                doTest(fileName);
            }

            @TestMetadata("inPropertyFromSuperSuperClass.kt")
            public void testInPropertyFromSuperSuperClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperSuperClass.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4176.kt")
            public void testKt4176() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/captureOuterProperty/kt4176.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4656.kt")
            public void testKt4656() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/captureOuterProperty/kt4656.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/closures/closureInsideClosure")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClosureInsideClosure extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInClosureInsideClosure() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/closures/closureInsideClosure"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("localFunInsideLocalFun.kt")
            public void testLocalFunInsideLocalFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFun.kt");
                doTest(fileName);
            }

            @TestMetadata("localFunInsideLocalFunDifferentSignatures.kt")
            public void testLocalFunInsideLocalFunDifferentSignatures() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFunDifferentSignatures.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyAndFunctionNameClash.kt")
            public void testPropertyAndFunctionNameClash() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureInsideClosure/propertyAndFunctionNameClash.kt");
                doTest(fileName);
            }

            @TestMetadata("threeLevels.kt")
            public void testThreeLevels() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevels.kt");
                doTest(fileName);
            }

            @TestMetadata("threeLevelsDifferentSignatures.kt")
            public void testThreeLevelsDifferentSignatures() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevelsDifferentSignatures.kt");
                doTest(fileName);
            }

            @TestMetadata("varAsFunInsideLocalFun.kt")
            public void testVarAsFunInsideLocalFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/closures/closureInsideClosure/varAsFunInsideLocalFun.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/collections")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Collections extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInCollections() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/collections"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("charSequence.kt")
        public void testCharSequence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/charSequence.kt");
            doTest(fileName);
        }

        @TestMetadata("implementCollectionThroughKotlin.kt")
        public void testImplementCollectionThroughKotlin() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/implementCollectionThroughKotlin.kt");
            doTest(fileName);
        }

        @TestMetadata("inSetWithSmartCast.kt")
        public void testInSetWithSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/inSetWithSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("irrelevantImplCharSequence.kt")
        public void testIrrelevantImplCharSequence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/irrelevantImplCharSequence.kt");
            doTest(fileName);
        }

        @TestMetadata("irrelevantImplCharSequenceKotlin.kt")
        public void testIrrelevantImplCharSequenceKotlin() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/irrelevantImplCharSequenceKotlin.kt");
            doTest(fileName);
        }

        @TestMetadata("irrelevantImplMutableList.kt")
        public void testIrrelevantImplMutableList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/irrelevantImplMutableList.kt");
            doTest(fileName);
        }

        @TestMetadata("irrelevantImplMutableListKotlin.kt")
        public void testIrrelevantImplMutableListKotlin() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/irrelevantImplMutableListKotlin.kt");
            doTest(fileName);
        }

        @TestMetadata("irrelevantImplMutableListSubstitution.kt")
        public void testIrrelevantImplMutableListSubstitution() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/irrelevantImplMutableListSubstitution.kt");
            doTest(fileName);
        }

        @TestMetadata("irrelevantRemoveAtOverrideInJava.kt")
        public void testIrrelevantRemoveAtOverrideInJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/irrelevantRemoveAtOverrideInJava.kt");
            doTest(fileName);
        }

        @TestMetadata("irrelevantSizeOverrideInJava.kt")
        public void testIrrelevantSizeOverrideInJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/irrelevantSizeOverrideInJava.kt");
            doTest(fileName);
        }

        @TestMetadata("mutableList.kt")
        public void testMutableList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/mutableList.kt");
            doTest(fileName);
        }

        @TestMetadata("noStubsInJavaSuperClass.kt")
        public void testNoStubsInJavaSuperClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/noStubsInJavaSuperClass.kt");
            doTest(fileName);
        }

        @TestMetadata("platformValueContains.kt")
        public void testPlatformValueContains() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/platformValueContains.kt");
            doTest(fileName);
        }

        @TestMetadata("readOnlyList.kt")
        public void testReadOnlyList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/readOnlyList.kt");
            doTest(fileName);
        }

        @TestMetadata("readOnlyMap.kt")
        public void testReadOnlyMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/readOnlyMap.kt");
            doTest(fileName);
        }

        @TestMetadata("removeAtInt.kt")
        public void testRemoveAtInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/removeAtInt.kt");
            doTest(fileName);
        }

        @TestMetadata("strList.kt")
        public void testStrList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/strList.kt");
            doTest(fileName);
        }

        @TestMetadata("toArrayInJavaClass.kt")
        public void testToArrayInJavaClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/collections/toArrayInJavaClass.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/compatibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Compatibility extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInCompatibility() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/compatibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("dataClassEqualsHashCodeToString.kt")
        public void testDataClassEqualsHashCodeToString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/compatibility/dataClassEqualsHashCodeToString.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/constants")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constants extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInConstants() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/constants"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("constantsInWhen.kt")
        public void testConstantsInWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/constants/constantsInWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/constants/float.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9532.kt")
        public void testKt9532() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/constants/kt9532.kt");
            doTest(fileName);
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/constants/long.kt");
            doTest(fileName);
        }

        @TestMetadata("privateConst.kt")
        public void testPrivateConst() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/constants/privateConst.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/controlStructures")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ControlStructures extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInControlStructures() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("bottles.kt")
        public void testBottles() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/bottles.kt");
            doTest(fileName);
        }

        @TestMetadata("breakInFinally.kt")
        public void testBreakInFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakInFinally.kt");
            doTest(fileName);
        }

        @TestMetadata("compareBoxedIntegerToZero.kt")
        public void testCompareBoxedIntegerToZero() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/compareBoxedIntegerToZero.kt");
            doTest(fileName);
        }

        @TestMetadata("conditionOfEmptyIf.kt")
        public void testConditionOfEmptyIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/conditionOfEmptyIf.kt");
            doTest(fileName);
        }

        @TestMetadata("continueInExpr.kt")
        public void testContinueInExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/continueInExpr.kt");
            doTest(fileName);
        }

        @TestMetadata("continueInFor.kt")
        public void testContinueInFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/continueInFor.kt");
            doTest(fileName);
        }

        @TestMetadata("continueInForCondition.kt")
        public void testContinueInForCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/continueInForCondition.kt");
            doTest(fileName);
        }

        @TestMetadata("continueInWhile.kt")
        public void testContinueInWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/continueInWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("continueToLabelInFor.kt")
        public void testContinueToLabelInFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/continueToLabelInFor.kt");
            doTest(fileName);
        }

        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/doWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("doWhileFib.kt")
        public void testDoWhileFib() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/doWhileFib.kt");
            doTest(fileName);
        }

        @TestMetadata("doWhileWithContinue.kt")
        public void testDoWhileWithContinue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/doWhileWithContinue.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyDoWhile.kt")
        public void testEmptyDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/emptyDoWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyFor.kt")
        public void testEmptyFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/emptyFor.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyWhile.kt")
        public void testEmptyWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/emptyWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("factorialTest.kt")
        public void testFactorialTest() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/factorialTest.kt");
            doTest(fileName);
        }

        @TestMetadata("finallyOnEmptyReturn.kt")
        public void testFinallyOnEmptyReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/finallyOnEmptyReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("forArrayList.kt")
        public void testForArrayList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/forArrayList.kt");
            doTest(fileName);
        }

        @TestMetadata("forArrayListMultiDecl.kt")
        public void testForArrayListMultiDecl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/forArrayListMultiDecl.kt");
            doTest(fileName);
        }

        @TestMetadata("forInSmartCastToArray.kt")
        public void testForInSmartCastToArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/forInSmartCastToArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forIntArray.kt")
        public void testForIntArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/forIntArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forLoopMemberExtensionAll.kt")
        public void testForLoopMemberExtensionAll() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionAll.kt");
            doTest(fileName);
        }

        @TestMetadata("forLoopMemberExtensionHasNext.kt")
        public void testForLoopMemberExtensionHasNext() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionHasNext.kt");
            doTest(fileName);
        }

        @TestMetadata("forLoopMemberExtensionNext.kt")
        public void testForLoopMemberExtensionNext() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionNext.kt");
            doTest(fileName);
        }

        @TestMetadata("forNullableIntArray.kt")
        public void testForNullableIntArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/forNullableIntArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forPrimitiveIntArray.kt")
        public void testForPrimitiveIntArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/forPrimitiveIntArray.kt");
            doTest(fileName);
        }

        @TestMetadata("forUserType.kt")
        public void testForUserType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/forUserType.kt");
            doTest(fileName);
        }

        @TestMetadata("inRangeConditionsInWhen.kt")
        public void testInRangeConditionsInWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/inRangeConditionsInWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("kt12908.kt")
        public void testKt12908() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt12908.kt");
            doTest(fileName);
        }

        @TestMetadata("kt12908_2.kt")
        public void testKt12908_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt12908_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1441.kt")
        public void testKt1441() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt1441.kt");
            doTest(fileName);
        }

        @TestMetadata("kt14839.kt")
        public void testKt14839() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt14839.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1688.kt")
        public void testKt1688() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt1688.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1742.kt")
        public void testKt1742() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt1742.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1899.kt")
        public void testKt1899() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt1899.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2147.kt")
        public void testKt2147() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt2147.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2259.kt")
        public void testKt2259() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt2259.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2291.kt")
        public void testKt2291() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt2291.kt");
            doTest(fileName);
        }

        @TestMetadata("kt237.kt")
        public void testKt237() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt237.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2416.kt")
        public void testKt2416() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt2416.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2423.kt")
        public void testKt2423() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt2423.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2577.kt")
        public void testKt2577() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt2577.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2597.kt")
        public void testKt2597() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt2597.kt");
            doTest(fileName);
        }

        @TestMetadata("kt299.kt")
        public void testKt299() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt299.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3087.kt")
        public void testKt3087() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt3087.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3203_1.kt")
        public void testKt3203_1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt3203_1.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3203_2.kt")
        public void testKt3203_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt3203_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3273.kt")
        public void testKt3273() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt3273.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3280.kt")
        public void testKt3280() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt3280.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3574.kt")
        public void testKt3574() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt3574.kt");
            doTest(fileName);
        }

        @TestMetadata("kt416.kt")
        public void testKt416() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt416.kt");
            doTest(fileName);
        }

        @TestMetadata("kt513.kt")
        public void testKt513() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt513.kt");
            doTest(fileName);
        }

        @TestMetadata("kt628.kt")
        public void testKt628() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt628.kt");
            doTest(fileName);
        }

        @TestMetadata("kt769.kt")
        public void testKt769() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt769.kt");
            doTest(fileName);
        }

        @TestMetadata("kt772.kt")
        public void testKt772() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt772.kt");
            doTest(fileName);
        }

        @TestMetadata("kt773.kt")
        public void testKt773() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt773.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8148.kt")
        public void testKt8148() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt8148.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8148_break.kt")
        public void testKt8148_break() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt8148_break.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8148_continue.kt")
        public void testKt8148_continue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt8148_continue.kt");
            doTest(fileName);
        }

        @TestMetadata("kt870.kt")
        public void testKt870() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt870.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9022Return.kt")
        public void testKt9022Return() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt9022Return.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9022Throw.kt")
        public void testKt9022Throw() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt9022Throw.kt");
            doTest(fileName);
        }

        @TestMetadata("kt910.kt")
        public void testKt910() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt910.kt");
            doTest(fileName);
        }

        @TestMetadata("kt958.kt")
        public void testKt958() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/kt958.kt");
            doTest(fileName);
        }

        @TestMetadata("longRange.kt")
        public void testLongRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/longRange.kt");
            doTest(fileName);
        }

        @TestMetadata("quicksort.kt")
        public void testQuicksort() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/quicksort.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatchFinallyChain.kt")
        public void testTryCatchFinallyChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchFinallyChain.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BreakContinueInExpressions extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInBreakContinueInExpressions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("breakFromOuter.kt")
            public void testBreakFromOuter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakFromOuter.kt");
                doTest(fileName);
            }

            @TestMetadata("breakInDoWhile.kt")
            public void testBreakInDoWhile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInDoWhile.kt");
                doTest(fileName);
            }

            @TestMetadata("breakInExpr.kt")
            public void testBreakInExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInExpr.kt");
                doTest(fileName);
            }

            @TestMetadata("continueInDoWhile.kt")
            public void testContinueInDoWhile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInDoWhile.kt");
                doTest(fileName);
            }

            @TestMetadata("continueInExpr.kt")
            public void testContinueInExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInExpr.kt");
                doTest(fileName);
            }

            @TestMetadata("inlineWithStack.kt")
            public void testInlineWithStack() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlineWithStack.kt");
                doTest(fileName);
            }

            @TestMetadata("innerLoopWithStack.kt")
            public void testInnerLoopWithStack() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/innerLoopWithStack.kt");
                doTest(fileName);
            }

            @TestMetadata("kt14581.kt")
            public void testKt14581() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt14581.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9022And.kt")
            public void testKt9022And() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022And.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9022Or.kt")
            public void testKt9022Or() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022Or.kt");
                doTest(fileName);
            }

            @TestMetadata("popSizes.kt")
            public void testPopSizes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/popSizes.kt");
                doTest(fileName);
            }

            @TestMetadata("tryFinally1.kt")
            public void testTryFinally1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally1.kt");
                doTest(fileName);
            }

            @TestMetadata("tryFinally2.kt")
            public void testTryFinally2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally2.kt");
                doTest(fileName);
            }

            @TestMetadata("whileTrueBreak.kt")
            public void testWhileTrueBreak() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/whileTrueBreak.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReturnsNothing extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInReturnsNothing() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/returnsNothing"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("ifElse.kt")
            public void testIfElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing/ifElse.kt");
                doTest(fileName);
            }

            @TestMetadata("inlineMethod.kt")
            public void testInlineMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing/inlineMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyGetter.kt")
            public void testPropertyGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing/propertyGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("tryCatch.kt")
            public void testTryCatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing/tryCatch.kt");
                doTest(fileName);
            }

            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing/when.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TryCatchInExpressions extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInTryCatchInExpressions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("catch.kt")
            public void testCatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/catch.kt");
                doTest(fileName);
            }

            @TestMetadata("complexChain.kt")
            public void testComplexChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/complexChain.kt");
                doTest(fileName);
            }

            @TestMetadata("deadTryCatch.kt")
            public void testDeadTryCatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/deadTryCatch.kt");
                doTest(fileName);
            }

            @TestMetadata("differentTypes.kt")
            public void testDifferentTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/differentTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("expectException.kt")
            public void testExpectException() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/expectException.kt");
                doTest(fileName);
            }

            @TestMetadata("finally.kt")
            public void testFinally() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/finally.kt");
                doTest(fileName);
            }

            @TestMetadata("inlineTryCatch.kt")
            public void testInlineTryCatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryCatch.kt");
                doTest(fileName);
            }

            @TestMetadata("inlineTryExpr.kt")
            public void testInlineTryExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryExpr.kt");
                doTest(fileName);
            }

            @TestMetadata("inlineTryFinally.kt")
            public void testInlineTryFinally() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryFinally.kt");
                doTest(fileName);
            }

            @TestMetadata("kt8608.kt")
            public void testKt8608() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt8608.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9644try.kt")
            public void testKt9644try() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt9644try.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleCatchBlocks.kt")
            public void testMultipleCatchBlocks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/multipleCatchBlocks.kt");
                doTest(fileName);
            }

            @TestMetadata("splitTry.kt")
            public void testSplitTry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTry.kt");
                doTest(fileName);
            }

            @TestMetadata("splitTryCorner1.kt")
            public void testSplitTryCorner1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTryCorner1.kt");
                doTest(fileName);
            }

            @TestMetadata("splitTryCorner2.kt")
            public void testSplitTryCorner2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTryCorner2.kt");
                doTest(fileName);
            }

            @TestMetadata("try.kt")
            public void testTry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/try.kt");
                doTest(fileName);
            }

            @TestMetadata("tryAfterTry.kt")
            public void testTryAfterTry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAfterTry.kt");
                doTest(fileName);
            }

            @TestMetadata("tryAndBreak.kt")
            public void testTryAndBreak() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndBreak.kt");
                doTest(fileName);
            }

            @TestMetadata("tryAndContinue.kt")
            public void testTryAndContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("tryInsideCatch.kt")
            public void testTryInsideCatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideCatch.kt");
                doTest(fileName);
            }

            @TestMetadata("tryInsideTry.kt")
            public void testTryInsideTry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideTry.kt");
                doTest(fileName);
            }

            @TestMetadata("unmatchedInlineMarkers.kt")
            public void testUnmatchedInlineMarkers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/unmatchedInlineMarkers.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Coroutines extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInCoroutines() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("beginWithException.kt")
        public void testBeginWithException() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/beginWithException.kt");
            doTest(fileName);
        }

        @TestMetadata("beginWithExceptionNoHandleException.kt")
        public void testBeginWithExceptionNoHandleException() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/beginWithExceptionNoHandleException.kt");
            doTest(fileName);
        }

        @TestMetadata("coercionToUnit.kt")
        public void testCoercionToUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/coercionToUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("controllerAccessFromInnerLambda.kt")
        public void testControllerAccessFromInnerLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controllerAccessFromInnerLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultParametersInSuspend.kt")
        public void testDefaultParametersInSuspend() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/defaultParametersInSuspend.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyClosure.kt")
        public void testEmptyClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/emptyClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("falseUnitCoercion.kt")
        public void testFalseUnitCoercion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/falseUnitCoercion.kt");
            doTest(fileName);
        }

        @TestMetadata("generate.kt")
        public void testGenerate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/generate.kt");
            doTest(fileName);
        }

        @TestMetadata("handleException.kt")
        public void testHandleException() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/handleException.kt");
            doTest(fileName);
        }

        @TestMetadata("handleResultCallEmptyBody.kt")
        public void testHandleResultCallEmptyBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/handleResultCallEmptyBody.kt");
            doTest(fileName);
        }

        @TestMetadata("handleResultNonUnitExpression.kt")
        public void testHandleResultNonUnitExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/handleResultNonUnitExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("handleResultSuspended.kt")
        public void testHandleResultSuspended() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/handleResultSuspended.kt");
            doTest(fileName);
        }

        @TestMetadata("illegalState.kt")
        public void testIllegalState() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/illegalState.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineSuspendFunction.kt")
        public void testInlineSuspendFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/inlineSuspendFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("inlinedTryCatchFinally.kt")
        public void testInlinedTryCatchFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/inlinedTryCatchFinally.kt");
            doTest(fileName);
        }

        @TestMetadata("innerSuspensionCalls.kt")
        public void testInnerSuspensionCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/innerSuspensionCalls.kt");
            doTest(fileName);
        }

        @TestMetadata("instanceOfContinuation.kt")
        public void testInstanceOfContinuation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/instanceOfContinuation.kt");
            doTest(fileName);
        }

        @TestMetadata("iterateOverArray.kt")
        public void testIterateOverArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/iterateOverArray.kt");
            doTest(fileName);
        }

        @TestMetadata("kt12958.kt")
        public void testKt12958() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/kt12958.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaParameters.kt")
        public void testLambdaParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/lambdaParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("lastExpressionIsLoop.kt")
        public void testLastExpressionIsLoop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/lastExpressionIsLoop.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatementInc.kt")
        public void testLastStatementInc() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/lastStatementInc.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStementAssignment.kt")
        public void testLastStementAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/lastStementAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("lastUnitExpression.kt")
        public void testLastUnitExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/lastUnitExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("manualContinuationImpl.kt")
        public void testManualContinuationImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/manualContinuationImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleInvokeCalls.kt")
        public void testMultipleInvokeCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/multipleInvokeCalls.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda1.kt")
        public void testMultipleInvokeCallsInsideInlineLambda1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda1.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda2.kt")
        public void testMultipleInvokeCallsInsideInlineLambda2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda2.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleInvokeCallsInsideInlineLambda3.kt")
        public void testMultipleInvokeCallsInsideInlineLambda3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda3.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedTryCatch.kt")
        public void testNestedTryCatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/nestedTryCatch.kt");
            doTest(fileName);
        }

        @TestMetadata("noSuspensionPoints.kt")
        public void testNoSuspensionPoints() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/noSuspensionPoints.kt");
            doTest(fileName);
        }

        @TestMetadata("nonLocalReturnFromInlineLambda.kt")
        public void testNonLocalReturnFromInlineLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("nonLocalReturnFromInlineLambdaDeep.kt")
        public void testNonLocalReturnFromInlineLambdaDeep() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambdaDeep.kt");
            doTest(fileName);
        }

        @TestMetadata("returnByLabel.kt")
        public void testReturnByLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/returnByLabel.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleException.kt")
        public void testSimpleException() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/simpleException.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleWithHandleResult.kt")
        public void testSimpleWithHandleResult() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/simpleWithHandleResult.kt");
            doTest(fileName);
        }

        @TestMetadata("statementLikeLastExpression.kt")
        public void testStatementLikeLastExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/statementLikeLastExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("suspendDelegation.kt")
        public void testSuspendDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/suspendDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("suspendExtension.kt")
        public void testSuspendExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/suspendExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("suspendFromInlineLambda.kt")
        public void testSuspendFromInlineLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/suspendFromInlineLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("suspendInCycle.kt")
        public void testSuspendInCycle() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/suspendInCycle.kt");
            doTest(fileName);
        }

        @TestMetadata("suspendInTheMiddleOfObjectConstruction.kt")
        public void testSuspendInTheMiddleOfObjectConstruction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstruction.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatchFinallyWithHandleResult.kt")
        public void testTryCatchFinallyWithHandleResult() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/tryCatchFinallyWithHandleResult.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatchWithHandleResult.kt")
        public void testTryCatchWithHandleResult() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/tryCatchWithHandleResult.kt");
            doTest(fileName);
        }

        @TestMetadata("tryFinallyInsideInlineLambda.kt")
        public void testTryFinallyInsideInlineLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/tryFinallyInsideInlineLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("tryFinallyWithHandleResult.kt")
        public void testTryFinallyWithHandleResult() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/tryFinallyWithHandleResult.kt");
            doTest(fileName);
        }

        @TestMetadata("varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/varValueConflictsWithTable.kt");
            doTest(fileName);
        }

        @TestMetadata("varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/varValueConflictsWithTableSameSort.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/controlFlow")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ControlFlow extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInControlFlow() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/controlFlow"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("breakFinally.kt")
            public void testBreakFinally() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controlFlow/breakFinally.kt");
                doTest(fileName);
            }

            @TestMetadata("breakStatement.kt")
            public void testBreakStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controlFlow/breakStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("doWhileStatement.kt")
            public void testDoWhileStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controlFlow/doWhileStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("forContinue.kt")
            public void testForContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controlFlow/forContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("forStatement.kt")
            public void testForStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controlFlow/forStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("ifStatement.kt")
            public void testIfStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controlFlow/ifStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("switchLikeWhen.kt")
            public void testSwitchLikeWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controlFlow/switchLikeWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("throwFromCatch.kt")
            public void testThrowFromCatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controlFlow/throwFromCatch.kt");
                doTest(fileName);
            }

            @TestMetadata("throwInTryWithHandleResult.kt")
            public void testThrowInTryWithHandleResult() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controlFlow/throwInTryWithHandleResult.kt");
                doTest(fileName);
            }

            @TestMetadata("whileStatement.kt")
            public void testWhileStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/controlFlow/whileStatement.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntLikeVarSpilling extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInIntLikeVarSpilling() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("complicatedMerge.kt")
            public void testComplicatedMerge() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/complicatedMerge.kt");
                doTest(fileName);
            }

            @TestMetadata("i2bResult.kt")
            public void testI2bResult() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/i2bResult.kt");
                doTest(fileName);
            }

            @TestMetadata("loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
                doTest(fileName);
            }

            @TestMetadata("loadFromByteArray.kt")
            public void testLoadFromByteArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
                doTest(fileName);
            }

            @TestMetadata("noVariableInTable.kt")
            public void testNoVariableInTable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/noVariableInTable.kt");
                doTest(fileName);
            }

            @TestMetadata("sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
                doTest(fileName);
            }

            @TestMetadata("usedInArrayStore.kt")
            public void testUsedInArrayStore() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
                doTest(fileName);
            }

            @TestMetadata("usedInMethodCall.kt")
            public void testUsedInMethodCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
                doTest(fileName);
            }

            @TestMetadata("usedInPutfield.kt")
            public void testUsedInPutfield() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInPutfield.kt");
                doTest(fileName);
            }

            @TestMetadata("usedInVarStore.kt")
            public void testUsedInVarStore() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInVarStore.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/coroutines/multiModule")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MultiModule extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInMultiModule() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/coroutines/multiModule"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/multiModule/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("suspendExtension.kt")
            public void testSuspendExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/coroutines/multiModule/suspendExtension.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/dataClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DataClasses extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInDataClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/dataClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayParams.kt")
        public void testArrayParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/arrayParams.kt");
            doTest(fileName);
        }

        @TestMetadata("changingVarParam.kt")
        public void testChangingVarParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/changingVarParam.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleParam.kt")
        public void testDoubleParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/doubleParam.kt");
            doTest(fileName);
        }

        @TestMetadata("floatParam.kt")
        public void testFloatParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/floatParam.kt");
            doTest(fileName);
        }

        @TestMetadata("genericParam.kt")
        public void testGenericParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/genericParam.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5002.kt")
        public void testKt5002() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/kt5002.kt");
            doTest(fileName);
        }

        @TestMetadata("mixedParams.kt")
        public void testMixedParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/mixedParams.kt");
            doTest(fileName);
        }

        @TestMetadata("multiDeclaration.kt")
        public void testMultiDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/multiDeclaration.kt");
            doTest(fileName);
        }

        @TestMetadata("multiDeclarationFor.kt")
        public void testMultiDeclarationFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/multiDeclarationFor.kt");
            doTest(fileName);
        }

        @TestMetadata("nonTrivialFinalMemberInSuperClass.kt")
        public void testNonTrivialFinalMemberInSuperClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/nonTrivialFinalMemberInSuperClass.kt");
            doTest(fileName);
        }

        @TestMetadata("nonTrivialMemberInSuperClass.kt")
        public void testNonTrivialMemberInSuperClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/nonTrivialMemberInSuperClass.kt");
            doTest(fileName);
        }

        @TestMetadata("privateValParams.kt")
        public void testPrivateValParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/privateValParams.kt");
            doTest(fileName);
        }

        @TestMetadata("twoValParams.kt")
        public void testTwoValParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/twoValParams.kt");
            doTest(fileName);
        }

        @TestMetadata("twoVarParams.kt")
        public void testTwoVarParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/twoVarParams.kt");
            doTest(fileName);
        }

        @TestMetadata("unitComponent.kt")
        public void testUnitComponent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/unitComponent.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/copy")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Copy extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInCopy() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/copy"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("constructorWithDefaultParam.kt")
            public void testConstructorWithDefaultParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/copy/constructorWithDefaultParam.kt");
                doTest(fileName);
            }

            @TestMetadata("copyInObjectNestedDataClass.kt")
            public void testCopyInObjectNestedDataClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/copy/copyInObjectNestedDataClass.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12708.kt")
            public void testKt12708() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/copy/kt12708.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3033.kt")
            public void testKt3033() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/copy/kt3033.kt");
                doTest(fileName);
            }

            @TestMetadata("valInConstructorParams.kt")
            public void testValInConstructorParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/copy/valInConstructorParams.kt");
                doTest(fileName);
            }

            @TestMetadata("varInConstructorParams.kt")
            public void testVarInConstructorParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/copy/varInConstructorParams.kt");
                doTest(fileName);
            }

            @TestMetadata("withGenericParameter.kt")
            public void testWithGenericParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/copy/withGenericParameter.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/equals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Equals extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInEquals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/equals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclared.kt");
                doTest(fileName);
            }

            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclaredWrongSignature.kt");
                doTest(fileName);
            }

            @TestMetadata("genericarray.kt")
            public void testGenericarray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/equals/genericarray.kt");
                doTest(fileName);
            }

            @TestMetadata("intarray.kt")
            public void testIntarray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/equals/intarray.kt");
                doTest(fileName);
            }

            @TestMetadata("nullother.kt")
            public void testNullother() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/equals/nullother.kt");
                doTest(fileName);
            }

            @TestMetadata("sameinstance.kt")
            public void testSameinstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/equals/sameinstance.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/hashCode")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class HashCode extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInHashCode() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/hashCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclared.kt");
                doTest(fileName);
            }

            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclaredWrongSignature.kt");
                doTest(fileName);
            }

            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/array.kt");
                doTest(fileName);
            }

            @TestMetadata("boolean.kt")
            public void testBoolean() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/boolean.kt");
                doTest(fileName);
            }

            @TestMetadata("byte.kt")
            public void testByte() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/byte.kt");
                doTest(fileName);
            }

            @TestMetadata("char.kt")
            public void testChar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/char.kt");
                doTest(fileName);
            }

            @TestMetadata("double.kt")
            public void testDouble() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/double.kt");
                doTest(fileName);
            }

            @TestMetadata("float.kt")
            public void testFloat() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/float.kt");
                doTest(fileName);
            }

            @TestMetadata("genericNull.kt")
            public void testGenericNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/genericNull.kt");
                doTest(fileName);
            }

            @TestMetadata("int.kt")
            public void testInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/int.kt");
                doTest(fileName);
            }

            @TestMetadata("long.kt")
            public void testLong() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/long.kt");
                doTest(fileName);
            }

            @TestMetadata("null.kt")
            public void testNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/null.kt");
                doTest(fileName);
            }

            @TestMetadata("short.kt")
            public void testShort() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/hashCode/short.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/dataClasses/toString")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ToString extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInToString() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/toString"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclared.kt");
                doTest(fileName);
            }

            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclaredWrongSignature.kt");
                doTest(fileName);
            }

            @TestMetadata("arrayParams.kt")
            public void testArrayParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/toString/arrayParams.kt");
                doTest(fileName);
            }

            @TestMetadata("changingVarParam.kt")
            public void testChangingVarParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/toString/changingVarParam.kt");
                doTest(fileName);
            }

            @TestMetadata("genericParam.kt")
            public void testGenericParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/toString/genericParam.kt");
                doTest(fileName);
            }

            @TestMetadata("mixedParams.kt")
            public void testMixedParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/toString/mixedParams.kt");
                doTest(fileName);
            }

            @TestMetadata("unitComponent.kt")
            public void testUnitComponent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/dataClasses/toString/unitComponent.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/deadCodeElimination")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeadCodeElimination extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInDeadCodeElimination() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("emptyVariableRange.kt")
        public void testEmptyVariableRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/deadCodeElimination/emptyVariableRange.kt");
            doTest(fileName);
        }

        @TestMetadata("intersectingVariableRange.kt")
        public void testIntersectingVariableRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRange.kt");
            doTest(fileName);
        }

        @TestMetadata("intersectingVariableRangeInFinally.kt")
        public void testIntersectingVariableRangeInFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRangeInFinally.kt");
            doTest(fileName);
        }

        @TestMetadata("kt14357.kt")
        public void testKt14357() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/deadCodeElimination/kt14357.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DefaultArguments extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("kt6382.kt")
        public void testKt6382() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/kt6382.kt");
            doTest(fileName);
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/protected.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleFromOtherFile.kt")
        public void testSimpleFromOtherFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/simpleFromOtherFile.kt");
            doTest(fileName);
        }

        @TestMetadata("superCallCheck.kt")
        public void testSuperCallCheck() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/superCallCheck.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/constructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructor extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInConstructor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/constructor"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotation.kt")
            public void testAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/annotation.kt");
                doTest(fileName);
            }

            @TestMetadata("checkIfConstructorIsSynthetic.kt")
            public void testCheckIfConstructorIsSynthetic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/checkIfConstructorIsSynthetic.kt");
                doTest(fileName);
            }

            @TestMetadata("defArgs1.kt")
            public void testDefArgs1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1.kt");
                doTest(fileName);
            }

            @TestMetadata("defArgs1InnerClass.kt")
            public void testDefArgs1InnerClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1InnerClass.kt");
                doTest(fileName);
            }

            @TestMetadata("defArgs2.kt")
            public void testDefArgs2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/defArgs2.kt");
                doTest(fileName);
            }

            @TestMetadata("doubleDefArgs1InnerClass.kt")
            public void testDoubleDefArgs1InnerClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/doubleDefArgs1InnerClass.kt");
                doTest(fileName);
            }

            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/enum.kt");
                doTest(fileName);
            }

            @TestMetadata("enumWithOneDefArg.kt")
            public void testEnumWithOneDefArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/enumWithOneDefArg.kt");
                doTest(fileName);
            }

            @TestMetadata("enumWithTwoDefArgs.kt")
            public void testEnumWithTwoDefArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDefArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("enumWithTwoDoubleDefArgs.kt")
            public void testEnumWithTwoDoubleDefArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDoubleDefArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2852.kt")
            public void testKt2852() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/kt2852.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3060.kt")
            public void testKt3060() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/kt3060.kt");
                doTest(fileName);
            }

            @TestMetadata("manyArgs.kt")
            public void testManyArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/constructor/manyArgs.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/convention")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Convention extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInConvention() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/convention"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("incWithDefaultInGetter.kt")
            public void testIncWithDefaultInGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/convention/incWithDefaultInGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9140.kt")
            public void testKt9140() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/convention/kt9140.kt");
                doTest(fileName);
            }

            @TestMetadata("plusAssignWithDefaultInGetter.kt")
            public void testPlusAssignWithDefaultInGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/convention/plusAssignWithDefaultInGetter.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractIrBlackBoxCodegenTest {
            @TestMetadata("abstractClass.kt")
            public void testAbstractClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/abstractClass.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/function"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("covariantOverride.kt")
            public void testCovariantOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/covariantOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("covariantOverrideGeneric.kt")
            public void testCovariantOverrideGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/covariantOverrideGeneric.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFunctionManyArgs.kt")
            public void testExtensionFunctionManyArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/extensionFunctionManyArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("extentionFunction.kt")
            public void testExtentionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/extentionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("extentionFunctionDouble.kt")
            public void testExtentionFunctionDouble() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDouble.kt");
                doTest(fileName);
            }

            @TestMetadata("extentionFunctionDoubleTwoArgs.kt")
            public void testExtentionFunctionDoubleTwoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDoubleTwoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("extentionFunctionInClassObject.kt")
            public void testExtentionFunctionInClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("extentionFunctionInObject.kt")
            public void testExtentionFunctionInObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInObject.kt");
                doTest(fileName);
            }

            @TestMetadata("extentionFunctionWithOneDefArg.kt")
            public void testExtentionFunctionWithOneDefArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionWithOneDefArg.kt");
                doTest(fileName);
            }

            @TestMetadata("funInTrait.kt")
            public void testFunInTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/funInTrait.kt");
                doTest(fileName);
            }

            @TestMetadata("innerExtentionFunction.kt")
            public void testInnerExtentionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("innerExtentionFunctionDouble.kt")
            public void testInnerExtentionFunctionDouble() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDouble.kt");
                doTest(fileName);
            }

            @TestMetadata("innerExtentionFunctionDoubleTwoArgs.kt")
            public void testInnerExtentionFunctionDoubleTwoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDoubleTwoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("innerExtentionFunctionManyArgs.kt")
            public void testInnerExtentionFunctionManyArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionManyArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("kt5232.kt")
            public void testKt5232() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/kt5232.kt");
                doTest(fileName);
            }

            @TestMetadata("memberFunctionManyArgs.kt")
            public void testMemberFunctionManyArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/memberFunctionManyArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("mixingNamedAndPositioned.kt")
            public void testMixingNamedAndPositioned() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/mixingNamedAndPositioned.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelManyArgs.kt")
            public void testTopLevelManyArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/topLevelManyArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("trait.kt")
            public void testTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/function/trait.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/private")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Private extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInPrivate() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/private"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("memberExtensionFunction.kt")
            public void testMemberExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/private/memberExtensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("memberFunction.kt")
            public void testMemberFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/private/memberFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/private/primaryConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/private/secondaryConstructor.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/defaultArguments/signature")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Signature extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInSignature() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/signature"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("kt2789.kt")
            public void testKt2789() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/signature/kt2789.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9428.kt")
            public void testKt9428() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/signature/kt9428.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9924.kt")
            public void testKt9924() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/defaultArguments/signature/kt9924.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DelegatedProperty extends AbstractIrBlackBoxCodegenTest {
        @TestMetadata("accessTopLevelDelegatedPropertyInClinit.kt")
        public void testAccessTopLevelDelegatedPropertyInClinit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/accessTopLevelDelegatedPropertyInClinit.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("capturePropertyInClosure.kt")
        public void testCapturePropertyInClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/capturePropertyInClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("castGetReturnType.kt")
        public void testCastGetReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/castGetReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("castSetParameter.kt")
        public void testCastSetParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/castSetParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateAsInnerClass.kt")
        public void testDelegateAsInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/delegateAsInnerClass.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateByOtherProperty.kt")
        public void testDelegateByOtherProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/delegateByOtherProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateByTopLevelFun.kt")
        public void testDelegateByTopLevelFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelFun.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateByTopLevelProperty.kt")
        public void testDelegateByTopLevelProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateForExtProperty.kt")
        public void testDelegateForExtProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/delegateForExtProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateForExtPropertyInClass.kt")
        public void testDelegateForExtPropertyInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/delegateForExtPropertyInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateWithPrivateSet.kt")
        public void testDelegateWithPrivateSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/delegateWithPrivateSet.kt");
            doTest(fileName);
        }

        @TestMetadata("genericDelegate.kt")
        public void testGenericDelegate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/genericDelegate.kt");
            doTest(fileName);
        }

        @TestMetadata("getAsExtensionFun.kt")
        public void testGetAsExtensionFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFun.kt");
            doTest(fileName);
        }

        @TestMetadata("getAsExtensionFunInClass.kt")
        public void testGetAsExtensionFunInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFunInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inClassVal.kt")
        public void testInClassVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/inClassVal.kt");
            doTest(fileName);
        }

        @TestMetadata("inClassVar.kt")
        public void testInClassVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/inClassVar.kt");
            doTest(fileName);
        }

        @TestMetadata("inTrait.kt")
        public void testInTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/inTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("inferredPropertyType.kt")
        public void testInferredPropertyType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/inferredPropertyType.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4138.kt")
        public void testKt4138() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/kt4138.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6722.kt")
        public void testKt6722() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/kt6722.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9712.kt")
        public void testKt9712() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/kt9712.kt");
            doTest(fileName);
        }

        @TestMetadata("privateSetterKPropertyIsNotMutable.kt")
        public void testPrivateSetterKPropertyIsNotMutable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/privateSetterKPropertyIsNotMutable.kt");
            doTest(fileName);
        }

        @TestMetadata("privateVar.kt")
        public void testPrivateVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/privateVar.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyMetadataShouldBeCached.kt")
        public void testPropertyMetadataShouldBeCached() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/propertyMetadataShouldBeCached.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedVarWithPrivateSet.kt")
        public void testProtectedVarWithPrivateSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/protectedVarWithPrivateSet.kt");
            doTest(fileName);
        }

        @TestMetadata("setAsExtensionFun.kt")
        public void testSetAsExtensionFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFun.kt");
            doTest(fileName);
        }

        @TestMetadata("setAsExtensionFunInClass.kt")
        public void testSetAsExtensionFunInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFunInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("stackOverflowOnCallFromGetValue.kt")
        public void testStackOverflowOnCallFromGetValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/stackOverflowOnCallFromGetValue.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelVal.kt")
        public void testTopLevelVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/topLevelVal.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelVar.kt")
        public void testTopLevelVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/topLevelVar.kt");
            doTest(fileName);
        }

        @TestMetadata("twoPropByOneDelegete.kt")
        public void testTwoPropByOneDelegete() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/twoPropByOneDelegete.kt");
            doTest(fileName);
        }

        @TestMetadata("useKPropertyLater.kt")
        public void testUseKPropertyLater() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/useKPropertyLater.kt");
            doTest(fileName);
        }

        @TestMetadata("useReflectionOnKProperty.kt")
        public void testUseReflectionOnKProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/useReflectionOnKProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("valInInnerClass.kt")
        public void testValInInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/valInInnerClass.kt");
            doTest(fileName);
        }

        @TestMetadata("varInInnerClass.kt")
        public void testVarInInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/varInInnerClass.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/local")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Local extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInLocal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/local"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("capturedLocalVal.kt")
            public void testCapturedLocalVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVal.kt");
                doTest(fileName);
            }

            @TestMetadata("capturedLocalValNoInline.kt")
            public void testCapturedLocalValNoInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalValNoInline.kt");
                doTest(fileName);
            }

            @TestMetadata("capturedLocalVar.kt")
            public void testCapturedLocalVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVar.kt");
                doTest(fileName);
            }

            @TestMetadata("capturedLocalVarNoInline.kt")
            public void testCapturedLocalVarNoInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVarNoInline.kt");
                doTest(fileName);
            }

            @TestMetadata("inlineGetValue.kt")
            public void testInlineGetValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/inlineGetValue.kt");
                doTest(fileName);
            }

            @TestMetadata("inlineOperators.kt")
            public void testInlineOperators() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/inlineOperators.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12891.kt")
            public void testKt12891() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/kt12891.kt");
                doTest(fileName);
            }

            @TestMetadata("kt13557.kt")
            public void testKt13557() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/kt13557.kt");
                doTest(fileName);
            }

            @TestMetadata("localVal.kt")
            public void testLocalVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/localVal.kt");
                doTest(fileName);
            }

            @TestMetadata("localValNoExplicitType.kt")
            public void testLocalValNoExplicitType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/localValNoExplicitType.kt");
                doTest(fileName);
            }

            @TestMetadata("localVar.kt")
            public void testLocalVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/localVar.kt");
                doTest(fileName);
            }

            @TestMetadata("localVarNoExplicitType.kt")
            public void testLocalVarNoExplicitType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegatedProperty/local/localVarNoExplicitType.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/delegation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Delegation extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInDelegation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/delegation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("delegationToVal.kt")
        public void testDelegationToVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegation/delegationToVal.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8154.kt")
        public void testKt8154() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/delegation/kt8154.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DestructuringDeclInLambdaParam extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInDestructuringDeclInLambdaParam() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/destructuringDeclInLambdaParam"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("extensionComponents.kt")
        public void testExtensionComponents() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam/extensionComponents.kt");
            doTest(fileName);
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam/generic.kt");
            doTest(fileName);
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam/inline.kt");
            doTest(fileName);
        }

        @TestMetadata("otherParameters.kt")
        public void testOtherParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam/otherParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("stdlibUsages.kt")
        public void testStdlibUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam/stdlibUsages.kt");
            doTest(fileName);
        }

        @TestMetadata("underscoreNames.kt")
        public void testUnderscoreNames() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam/underscoreNames.kt");
            doTest(fileName);
        }

        @TestMetadata("withIndexed.kt")
        public void testWithIndexed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam/withIndexed.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/diagnostics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Diagnostics extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInDiagnostics() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/diagnostics/functions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Functions extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInFunctions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/inference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inference extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInInference() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/inference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("kt6176.kt")
                public void testKt6176() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/inference/kt6176.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invoke extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInInvoke() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnObjects extends AbstractIrBlackBoxCodegenTest {
                    public void testAllFilesPresentInOnObjects() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("invokeOnClassObject1.kt")
                    public void testInvokeOnClassObject1() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject1.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("invokeOnClassObject2.kt")
                    public void testInvokeOnClassObject2() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject2.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("invokeOnClassObjectOfNestedClass1.kt")
                    public void testInvokeOnClassObjectOfNestedClass1() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass1.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("invokeOnClassObjectOfNestedClass2.kt")
                    public void testInvokeOnClassObjectOfNestedClass2() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass2.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("invokeOnEnum1.kt")
                    public void testInvokeOnEnum1() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum1.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("invokeOnEnum2.kt")
                    public void testInvokeOnEnum2() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum2.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("invokeOnImportedEnum1.kt")
                    public void testInvokeOnImportedEnum1() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum1.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("invokeOnImportedEnum2.kt")
                    public void testInvokeOnImportedEnum2() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum2.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("invokeOnObject1.kt")
                    public void testInvokeOnObject1() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject1.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("invokeOnObject2.kt")
                    public void testInvokeOnObject2() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject2.kt");
                        doTest(fileName);
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TailRecursion extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInTailRecursion() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/tailRecursion"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("defaultArgs.kt")
                public void testDefaultArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("defaultArgsOverridden.kt")
                public void testDefaultArgsOverridden() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsOverridden.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionTailCall.kt")
                public void testExtensionTailCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/extensionTailCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionWithNoTails.kt")
                public void testFunctionWithNoTails() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNoTails.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionWithNonTailRecursions.kt")
                public void testFunctionWithNonTailRecursions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNonTailRecursions.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionWithoutAnnotation.kt")
                public void testFunctionWithoutAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithoutAnnotation.kt");
                    doTest(fileName);
                }

                @TestMetadata("infixCall.kt")
                public void testInfixCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("infixRecursiveCall.kt")
                public void testInfixRecursiveCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixRecursiveCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("insideElvis.kt")
                public void testInsideElvis() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/insideElvis.kt");
                    doTest(fileName);
                }

                @TestMetadata("labeledThisReferences.kt")
                public void testLabeledThisReferences() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/labeledThisReferences.kt");
                    doTest(fileName);
                }

                @TestMetadata("loops.kt")
                public void testLoops() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/loops.kt");
                    doTest(fileName);
                }

                @TestMetadata("multilevelBlocks.kt")
                public void testMultilevelBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/multilevelBlocks.kt");
                    doTest(fileName);
                }

                @TestMetadata("realIteratorFoldl.kt")
                public void testRealIteratorFoldl() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realIteratorFoldl.kt");
                    doTest(fileName);
                }

                @TestMetadata("realStringEscape.kt")
                public void testRealStringEscape() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringEscape.kt");
                    doTest(fileName);
                }

                @TestMetadata("realStringRepeat.kt")
                public void testRealStringRepeat() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringRepeat.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveCallInLambda.kt")
                public void testRecursiveCallInLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveCallInLocalFunction.kt")
                public void testRecursiveCallInLocalFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLocalFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveInnerFunction.kt")
                public void testRecursiveInnerFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveInnerFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnIf.kt")
                public void testReturnIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnInCatch.kt")
                public void testReturnInCatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInCatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnInFinally.kt")
                public void testReturnInFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnInIfInFinally.kt")
                public void testReturnInIfInFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInIfInFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnInParentheses.kt")
                public void testReturnInParentheses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInParentheses.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnInTry.kt")
                public void testReturnInTry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInTry.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleBlock.kt")
                public void testSimpleBlock() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleBlock.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleReturn.kt")
                public void testSimpleReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturn.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleReturnWithElse.kt")
                public void testSimpleReturnWithElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturnWithElse.kt");
                    doTest(fileName);
                }

                @TestMetadata("sum.kt")
                public void testSum() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/sum.kt");
                    doTest(fileName);
                }

                @TestMetadata("tailCallInBlockInParentheses.kt")
                public void testTailCallInBlockInParentheses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInBlockInParentheses.kt");
                    doTest(fileName);
                }

                @TestMetadata("tailCallInParentheses.kt")
                public void testTailCallInParentheses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInParentheses.kt");
                    doTest(fileName);
                }

                @TestMetadata("tailRecursionInFinally.kt")
                public void testTailRecursionInFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailRecursionInFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisReferences.kt")
                public void testThisReferences() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/thisReferences.kt");
                    doTest(fileName);
                }

                @TestMetadata("unitBlocks.kt")
                public void testUnitBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/unitBlocks.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithCondition.kt")
                public void testWhenWithCondition() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithCondition.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithInRange.kt")
                public void testWhenWithInRange() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithInRange.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithIs.kt")
                public void testWhenWithIs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithIs.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithoutCondition.kt")
                public void testWhenWithoutCondition() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithoutCondition.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/diagnostics/vararg")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Vararg extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInVararg() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/vararg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("kt4172.kt")
            public void testKt4172() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/diagnostics/vararg/kt4172.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/elvis")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Elvis extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInElvis() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/elvis"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/elvis/genericNull.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6694ExactAnnotationForElvis.kt")
        public void testKt6694ExactAnnotationForElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/elvis/kt6694ExactAnnotationForElvis.kt");
            doTest(fileName);
        }

        @TestMetadata("nullNullOk.kt")
        public void testNullNullOk() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/elvis/nullNullOk.kt");
            doTest(fileName);
        }

        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/elvis/primitive.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/enum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Enum extends AbstractIrBlackBoxCodegenTest {
        @TestMetadata("abstractMethodInEnum.kt")
        public void testAbstractMethodInEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/abstractMethodInEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractNestedClass.kt")
        public void testAbstractNestedClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/abstractNestedClass.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInEnum() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/enum"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("asReturnExpression.kt")
        public void testAsReturnExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/asReturnExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("classForEnumEntry.kt")
        public void testClassForEnumEntry() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/classForEnumEntry.kt");
            doTest(fileName);
        }

        @TestMetadata("companionObjectInEnum.kt")
        public void testCompanionObjectInEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/companionObjectInEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyConstructor.kt")
        public void testEmptyConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/emptyConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyEnumValuesValueOf.kt")
        public void testEmptyEnumValuesValueOf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/emptyEnumValuesValueOf.kt");
            doTest(fileName);
        }

        @TestMetadata("enumInheritedFromTrait.kt")
        public void testEnumInheritedFromTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/enumInheritedFromTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("enumShort.kt")
        public void testEnumShort() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/enumShort.kt");
            doTest(fileName);
        }

        @TestMetadata("enumWithLambdaParameter.kt")
        public void testEnumWithLambdaParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/enumWithLambdaParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("inPackage.kt")
        public void testInPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/inPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("inclassobj.kt")
        public void testInclassobj() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/inclassobj.kt");
            doTest(fileName);
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/inner.kt");
            doTest(fileName);
        }

        @TestMetadata("innerWithExistingClassObject.kt")
        public void testInnerWithExistingClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/innerWithExistingClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1119.kt")
        public void testKt1119() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/kt1119.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2350.kt")
        public void testKt2350() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/kt2350.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9711.kt")
        public void testKt9711() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/kt9711.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9711_2.kt")
        public void testKt9711_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/kt9711_2.kt");
            doTest(fileName);
        }

        @TestMetadata("modifierFlags.kt")
        public void testModifierFlags() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/modifierFlags.kt");
            doTest(fileName);
        }

        @TestMetadata("noClassForSimpleEnum.kt")
        public void testNoClassForSimpleEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/noClassForSimpleEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInEnum.kt")
        public void testObjectInEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/objectInEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("ordinal.kt")
        public void testOrdinal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/ordinal.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("sortEnumEntries.kt")
        public void testSortEnumEntries() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/sortEnumEntries.kt");
            doTest(fileName);
        }

        @TestMetadata("superCallInEnumLiteral.kt")
        public void testSuperCallInEnumLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/superCallInEnumLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/toString.kt");
            doTest(fileName);
        }

        @TestMetadata("valueof.kt")
        public void testValueof() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/enum/valueof.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/evaluate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Evaluate extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInEvaluate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/evaluate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("char.kt")
        public void testChar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/char.kt");
            doTest(fileName);
        }

        @TestMetadata("divide.kt")
        public void testDivide() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/divide.kt");
            doTest(fileName);
        }

        @TestMetadata("intrinsics.kt")
        public void testIntrinsics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/intrinsics.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9443.kt")
        public void testKt9443() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/kt9443.kt");
            doTest(fileName);
        }

        @TestMetadata("maxValue.kt")
        public void testMaxValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/maxValue.kt");
            doTest(fileName);
        }

        @TestMetadata("maxValueByte.kt")
        public void testMaxValueByte() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/maxValueByte.kt");
            doTest(fileName);
        }

        @TestMetadata("maxValueInt.kt")
        public void testMaxValueInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/maxValueInt.kt");
            doTest(fileName);
        }

        @TestMetadata("minus.kt")
        public void testMinus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/minus.kt");
            doTest(fileName);
        }

        @TestMetadata("mod.kt")
        public void testMod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/mod.kt");
            doTest(fileName);
        }

        @TestMetadata("multiply.kt")
        public void testMultiply() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/multiply.kt");
            doTest(fileName);
        }

        @TestMetadata("parenthesized.kt")
        public void testParenthesized() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/parenthesized.kt");
            doTest(fileName);
        }

        @TestMetadata("plus.kt")
        public void testPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/plus.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleCallBinary.kt")
        public void testSimpleCallBinary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/simpleCallBinary.kt");
            doTest(fileName);
        }

        @TestMetadata("unaryMinus.kt")
        public void testUnaryMinus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/unaryMinus.kt");
            doTest(fileName);
        }

        @TestMetadata("unaryPlus.kt")
        public void testUnaryPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/evaluate/unaryPlus.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/exclExcl")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExclExcl extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInExclExcl() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/exclExcl"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/exclExcl/genericNull.kt");
            doTest(fileName);
        }

        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/exclExcl/primitive.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/extensionFunctions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionFunctions extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInExtensionFunctions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("executionOrder.kt")
        public void testExecutionOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/executionOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1061.kt")
        public void testKt1061() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt1061.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1249.kt")
        public void testKt1249() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt1249.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1290.kt")
        public void testKt1290() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt1290.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1776.kt")
        public void testKt1776() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt1776.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1953.kt")
        public void testKt1953() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt1953.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1953_class.kt")
        public void testKt1953_class() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt1953_class.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3285.kt")
        public void testKt3285() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt3285.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3298.kt")
        public void testKt3298() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt3298.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3646.kt")
        public void testKt3646() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt3646.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3969.kt")
        public void testKt3969() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt3969.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4228.kt")
        public void testKt4228() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt4228.kt");
            doTest(fileName);
        }

        @TestMetadata("kt475.kt")
        public void testKt475() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt475.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5467.kt")
        public void testKt5467() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt5467.kt");
            doTest(fileName);
        }

        @TestMetadata("kt606.kt")
        public void testKt606() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt606.kt");
            doTest(fileName);
        }

        @TestMetadata("kt865.kt")
        public void testKt865() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/kt865.kt");
            doTest(fileName);
        }

        @TestMetadata("nested2.kt")
        public void testNested2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/nested2.kt");
            doTest(fileName);
        }

        @TestMetadata("shared.kt")
        public void testShared() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/shared.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("thisMethodInObjectLiteral.kt")
        public void testThisMethodInObjectLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/thisMethodInObjectLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("virtual.kt")
        public void testVirtual() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/virtual.kt");
            doTest(fileName);
        }

        @TestMetadata("whenFail.kt")
        public void testWhenFail() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionFunctions/whenFail.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/extensionProperties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionProperties extends AbstractIrBlackBoxCodegenTest {
        @TestMetadata("accessorForPrivateSetter.kt")
        public void testAccessorForPrivateSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/accessorForPrivateSetter.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInExtensionProperties() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/extensionProperties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("genericValForPrimitiveType.kt")
        public void testGenericValForPrimitiveType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/genericValForPrimitiveType.kt");
            doTest(fileName);
        }

        @TestMetadata("genericValMultipleUpperBounds.kt")
        public void testGenericValMultipleUpperBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/genericValMultipleUpperBounds.kt");
            doTest(fileName);
        }

        @TestMetadata("genericVarForPrimitiveType.kt")
        public void testGenericVarForPrimitiveType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/genericVarForPrimitiveType.kt");
            doTest(fileName);
        }

        @TestMetadata("inClass.kt")
        public void testInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/inClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inClassLongTypeInReceiver.kt")
        public void testInClassLongTypeInReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/inClassLongTypeInReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("inClassWithGetter.kt")
        public void testInClassWithGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/inClassWithGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("inClassWithPrivateGetter.kt")
        public void testInClassWithPrivateGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("inClassWithPrivateSetter.kt")
        public void testInClassWithPrivateSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("inClassWithSetter.kt")
        public void testInClassWithSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/inClassWithSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9897.kt")
        public void testKt9897() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/kt9897.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9897_topLevel.kt")
        public void testKt9897_topLevel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/kt9897_topLevel.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevel.kt")
        public void testTopLevel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/topLevel.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelLongTypeInReceiver.kt")
        public void testTopLevelLongTypeInReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/extensionProperties/topLevelLongTypeInReceiver.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/external")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class External extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInExternal() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/external"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("jvmStaticExternal.kt")
        public void testJvmStaticExternal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/external/jvmStaticExternal.kt");
            doTest(fileName);
        }

        @TestMetadata("jvmStaticExternalPrivate.kt")
        public void testJvmStaticExternalPrivate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/external/jvmStaticExternalPrivate.kt");
            doTest(fileName);
        }

        @TestMetadata("withDefaultArg.kt")
        public void testWithDefaultArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/external/withDefaultArg.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fakeOverride")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FakeOverride extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInFakeOverride() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/fakeOverride"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("diamondFunction.kt")
        public void testDiamondFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fakeOverride/diamondFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fakeOverride/function.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyGetter.kt")
        public void testPropertyGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fakeOverride/propertyGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fakeOverride/propertySetter.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fieldRename")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FieldRename extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInFieldRename() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/fieldRename"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("constructorAndClassObject.kt")
        public void testConstructorAndClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fieldRename/constructorAndClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("delegates.kt")
        public void testDelegates() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fieldRename/delegates.kt");
            doTest(fileName);
        }

        @TestMetadata("genericPropertyWithItself.kt")
        public void testGenericPropertyWithItself() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fieldRename/genericPropertyWithItself.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/finally")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Finally extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInFinally() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/finally"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("finallyAndFinally.kt")
        public void testFinallyAndFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/finallyAndFinally.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3549.kt")
        public void testKt3549() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/kt3549.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3706.kt")
        public void testKt3706() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/kt3706.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3867.kt")
        public void testKt3867() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/kt3867.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3874.kt")
        public void testKt3874() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/kt3874.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3894.kt")
        public void testKt3894() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/kt3894.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4134.kt")
        public void testKt4134() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/kt4134.kt");
            doTest(fileName);
        }

        @TestMetadata("loopAndFinally.kt")
        public void testLoopAndFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/loopAndFinally.kt");
            doTest(fileName);
        }

        @TestMetadata("notChainCatch.kt")
        public void testNotChainCatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/notChainCatch.kt");
            doTest(fileName);
        }

        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/tryFinally.kt");
            doTest(fileName);
        }

        @TestMetadata("tryLoopTry.kt")
        public void testTryLoopTry() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/finally/tryLoopTry.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/fullJdk")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FullJdk extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInFullJdk() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/fullJdk"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("charBuffer.kt")
        public void testCharBuffer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fullJdk/charBuffer.kt");
            doTest(fileName);
        }

        @TestMetadata("classpath.kt")
        public void testClasspath() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fullJdk/classpath.kt");
            doTest(fileName);
        }

        @TestMetadata("ifInWhile.kt")
        public void testIfInWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fullJdk/ifInWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("intCountDownLatchExtension.kt")
        public void testIntCountDownLatchExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fullJdk/intCountDownLatchExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("kt434.kt")
        public void testKt434() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fullJdk/kt434.kt");
            doTest(fileName);
        }

        @TestMetadata("platformTypeAssertionStackTrace.kt")
        public void testPlatformTypeAssertionStackTrace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fullJdk/platformTypeAssertionStackTrace.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/fullJdk/native")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Native extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInNative() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/native"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("nativePropertyAccessors.kt")
            public void testNativePropertyAccessors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fullJdk/native/nativePropertyAccessors.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleNative.kt")
            public void testSimpleNative() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fullJdk/native/simpleNative.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevel.kt")
            public void testTopLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fullJdk/native/topLevel.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/fullJdk/regressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Regressions extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInRegressions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/regressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("kt1770.kt")
            public void testKt1770() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/fullJdk/regressions/kt1770.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/functions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Functions extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInFunctions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/functions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("coerceVoidToArray.kt")
        public void testCoerceVoidToArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/coerceVoidToArray.kt");
            doTest(fileName);
        }

        @TestMetadata("coerceVoidToObject.kt")
        public void testCoerceVoidToObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/coerceVoidToObject.kt");
            doTest(fileName);
        }

        @TestMetadata("dataLocalVariable.kt")
        public void testDataLocalVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/dataLocalVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultargs.kt")
        public void testDefaultargs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/defaultargs.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultargs1.kt")
        public void testDefaultargs1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/defaultargs1.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultargs2.kt")
        public void testDefaultargs2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/defaultargs2.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultargs3.kt")
        public void testDefaultargs3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/defaultargs3.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultargs4.kt")
        public void testDefaultargs4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/defaultargs4.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultargs5.kt")
        public void testDefaultargs5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/defaultargs5.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultargs6.kt")
        public void testDefaultargs6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/defaultargs6.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultargs7.kt")
        public void testDefaultargs7() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/defaultargs7.kt");
            doTest(fileName);
        }

        @TestMetadata("ea33909.kt")
        public void testEa33909() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/ea33909.kt");
            doTest(fileName);
        }

        @TestMetadata("fakeDescriptorWithSeveralOverridenOne.kt")
        public void testFakeDescriptorWithSeveralOverridenOne() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/fakeDescriptorWithSeveralOverridenOne.kt");
            doTest(fileName);
        }

        @TestMetadata("functionNtoString.kt")
        public void testFunctionNtoString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/functionNtoString.kt");
            doTest(fileName);
        }

        @TestMetadata("functionNtoStringGeneric.kt")
        public void testFunctionNtoStringGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/functionNtoStringGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("functionNtoStringNoReflect.kt")
        public void testFunctionNtoStringNoReflect() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/functionNtoStringNoReflect.kt");
            doTest(fileName);
        }

        @TestMetadata("infixRecursiveCall.kt")
        public void testInfixRecursiveCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/infixRecursiveCall.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1038.kt")
        public void testKt1038() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt1038.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1199.kt")
        public void testKt1199() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt1199.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1413.kt")
        public void testKt1413() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt1413.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1649_1.kt")
        public void testKt1649_1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt1649_1.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1649_2.kt")
        public void testKt1649_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt1649_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1739.kt")
        public void testKt1739() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt1739.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2270.kt")
        public void testKt2270() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt2270.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2271.kt")
        public void testKt2271() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt2271.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2280.kt")
        public void testKt2280() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt2280.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2481.kt")
        public void testKt2481() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt2481.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2716.kt")
        public void testKt2716() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt2716.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2739.kt")
        public void testKt2739() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt2739.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2929.kt")
        public void testKt2929() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt2929.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3214.kt")
        public void testKt3214() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt3214.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3313.kt")
        public void testKt3313() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt3313.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3573.kt")
        public void testKt3573() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt3573.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3724.kt")
        public void testKt3724() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt3724.kt");
            doTest(fileName);
        }

        @TestMetadata("kt395.kt")
        public void testKt395() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt395.kt");
            doTest(fileName);
        }

        @TestMetadata("kt785.kt")
        public void testKt785() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt785.kt");
            doTest(fileName);
        }

        @TestMetadata("kt873.kt")
        public void testKt873() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/kt873.kt");
            doTest(fileName);
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("localReturnInsideFunctionExpression.kt")
        public void testLocalReturnInsideFunctionExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localReturnInsideFunctionExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("nothisnoclosure.kt")
        public void testNothisnoclosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/nothisnoclosure.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixRecursiveCall.kt")
        public void testPrefixRecursiveCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/prefixRecursiveCall.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveCompareTo.kt")
        public void testRecursiveCompareTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/recursiveCompareTo.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveIncrementCall.kt")
        public void testRecursiveIncrementCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/recursiveIncrementCall.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/functions/functionExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionExpression extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInFunctionExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/functions/functionExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("functionExpression.kt")
            public void testFunctionExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/functionExpression/functionExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("functionExpressionWithThisReference.kt")
            public void testFunctionExpressionWithThisReference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/functionExpression/functionExpressionWithThisReference.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralExpression.kt")
            public void testFunctionLiteralExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/functionExpression/functionLiteralExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("underscoreParameters.kt")
            public void testUnderscoreParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/functionExpression/underscoreParameters.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/invoke")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Invoke extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInInvoke() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/functions/invoke"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("castFunctionToExtension.kt")
            public void testCastFunctionToExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/castFunctionToExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionInvokeOnExpr.kt")
            public void testExtensionInvokeOnExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/extensionInvokeOnExpr.kt");
                doTest(fileName);
            }

            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/invoke.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeOnExprByConvention.kt")
            public void testInvokeOnExprByConvention() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/invokeOnExprByConvention.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeOnSyntheticProperty.kt")
            public void testInvokeOnSyntheticProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/invokeOnSyntheticProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3189.kt")
            public void testKt3189() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/kt3189.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3190.kt")
            public void testKt3190() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/kt3190.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3297.kt")
            public void testKt3297() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/kt3297.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3450getAndInvoke.kt")
            public void testKt3450getAndInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/kt3450getAndInvoke.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3631invokeOnString.kt")
            public void testKt3631invokeOnString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/kt3631invokeOnString.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3772.kt")
            public void testKt3772() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/kt3772.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3821invokeOnThis.kt")
            public void testKt3821invokeOnThis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/kt3821invokeOnThis.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3822invokeOnThis.kt")
            public void testKt3822invokeOnThis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/invoke/kt3822invokeOnThis.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/functions/localFunctions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LocalFunctions extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInLocalFunctions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/functions/localFunctions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("callInlineLocalInLambda.kt")
            public void testCallInlineLocalInLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/callInlineLocalInLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("definedWithinLambda.kt")
            public void testDefinedWithinLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("definedWithinLambdaInnerUsage1.kt")
            public void testDefinedWithinLambdaInnerUsage1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage1.kt");
                doTest(fileName);
            }

            @TestMetadata("definedWithinLambdaInnerUsage2.kt")
            public void testDefinedWithinLambdaInnerUsage2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage2.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2895.kt")
            public void testKt2895() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/kt2895.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3308.kt")
            public void testKt3308() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/kt3308.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3978.kt")
            public void testKt3978() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/kt3978.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4119.kt")
            public void testKt4119() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/kt4119.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4119_2.kt")
            public void testKt4119_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/kt4119_2.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4514.kt")
            public void testKt4514() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/kt4514.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4777.kt")
            public void testKt4777() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/kt4777.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4783.kt")
            public void testKt4783() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/kt4783.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4784.kt")
            public void testKt4784() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/kt4784.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4989.kt")
            public void testKt4989() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/kt4989.kt");
                doTest(fileName);
            }

            @TestMetadata("localExtensionOnNullableParameter.kt")
            public void testLocalExtensionOnNullableParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/localExtensionOnNullableParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("localFunctionInConstructor.kt")
            public void testLocalFunctionInConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/functions/localFunctions/localFunctionInConstructor.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/hashPMap")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class HashPMap extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInHashPMap() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/hashPMap"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("empty.kt")
        public void testEmpty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/hashPMap/empty.kt");
            doTest(fileName);
        }

        @TestMetadata("manyNumbers.kt")
        public void testManyNumbers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/hashPMap/manyNumbers.kt");
            doTest(fileName);
        }

        @TestMetadata("rewriteWithDifferent.kt")
        public void testRewriteWithDifferent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/hashPMap/rewriteWithDifferent.kt");
            doTest(fileName);
        }

        @TestMetadata("rewriteWithEqual.kt")
        public void testRewriteWithEqual() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/hashPMap/rewriteWithEqual.kt");
            doTest(fileName);
        }

        @TestMetadata("simplePlusGet.kt")
        public void testSimplePlusGet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/hashPMap/simplePlusGet.kt");
            doTest(fileName);
        }

        @TestMetadata("simplePlusMinus.kt")
        public void testSimplePlusMinus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/hashPMap/simplePlusMinus.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/increment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Increment extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInIncrement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/increment"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayElement.kt")
        public void testArrayElement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/arrayElement.kt");
            doTest(fileName);
        }

        @TestMetadata("assignPlusOnSmartCast.kt")
        public void testAssignPlusOnSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/assignPlusOnSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("augmentedAssignmentWithComplexRhs.kt")
        public void testAugmentedAssignmentWithComplexRhs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/augmentedAssignmentWithComplexRhs.kt");
            doTest(fileName);
        }

        @TestMetadata("classNaryGetSet.kt")
        public void testClassNaryGetSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/classNaryGetSet.kt");
            doTest(fileName);
        }

        @TestMetadata("classWithGetSet.kt")
        public void testClassWithGetSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/classWithGetSet.kt");
            doTest(fileName);
        }

        @TestMetadata("extOnLong.kt")
        public void testExtOnLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/extOnLong.kt");
            doTest(fileName);
        }

        @TestMetadata("genericClassWithGetSet.kt")
        public void testGenericClassWithGetSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/genericClassWithGetSet.kt");
            doTest(fileName);
        }

        @TestMetadata("memberExtOnLong.kt")
        public void testMemberExtOnLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/memberExtOnLong.kt");
            doTest(fileName);
        }

        @TestMetadata("mutableListElement.kt")
        public void testMutableListElement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/mutableListElement.kt");
            doTest(fileName);
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/nullable.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixIncrementDoubleSmartCast.kt")
        public void testPostfixIncrementDoubleSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/postfixIncrementDoubleSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixIncrementOnClass.kt")
        public void testPostfixIncrementOnClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/postfixIncrementOnClass.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixIncrementOnClassSmartCast.kt")
        public void testPostfixIncrementOnClassSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/postfixIncrementOnClassSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixIncrementOnShortSmartCast.kt")
        public void testPostfixIncrementOnShortSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/postfixIncrementOnShortSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixIncrementOnSmartCast.kt")
        public void testPostfixIncrementOnSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/postfixIncrementOnSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixNullableClassIncrement.kt")
        public void testPostfixNullableClassIncrement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/postfixNullableClassIncrement.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixNullableIncrement.kt")
        public void testPostfixNullableIncrement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/postfixNullableIncrement.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixIncrementOnClass.kt")
        public void testPrefixIncrementOnClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/prefixIncrementOnClass.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixIncrementOnClassSmartCast.kt")
        public void testPrefixIncrementOnClassSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/prefixIncrementOnClassSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixIncrementOnSmartCast.kt")
        public void testPrefixIncrementOnSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/prefixIncrementOnSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixNullableClassIncrement.kt")
        public void testPrefixNullableClassIncrement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/prefixNullableClassIncrement.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixNullableIncrement.kt")
        public void testPrefixNullableIncrement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/increment/prefixNullableIncrement.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/innerNested")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InnerNested extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInInnerNested() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/innerNested"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("createNestedClass.kt")
        public void testCreateNestedClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/createNestedClass.kt");
            doTest(fileName);
        }

        @TestMetadata("createdNestedInOuterMember.kt")
        public void testCreatedNestedInOuterMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/createdNestedInOuterMember.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionFun.kt")
        public void testExtensionFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/extensionFun.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionToNested.kt")
        public void testExtensionToNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/extensionToNested.kt");
            doTest(fileName);
        }

        @TestMetadata("importNestedClass.kt")
        public void testImportNestedClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/importNestedClass.kt");
            doTest(fileName);
        }

        @TestMetadata("innerGeneric.kt")
        public void testInnerGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/innerGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("innerGenericClassFromJava.kt")
        public void testInnerGenericClassFromJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/innerGenericClassFromJava.kt");
            doTest(fileName);
        }

        @TestMetadata("innerJavaClass.kt")
        public void testInnerJavaClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/innerJavaClass.kt");
            doTest(fileName);
        }

        @TestMetadata("innerLabeledThis.kt")
        public void testInnerLabeledThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/innerLabeledThis.kt");
            doTest(fileName);
        }

        @TestMetadata("innerSimple.kt")
        public void testInnerSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/innerSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3132.kt")
        public void testKt3132() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/kt3132.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3927.kt")
        public void testKt3927() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/kt3927.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5363.kt")
        public void testKt5363() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/kt5363.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6804.kt")
        public void testKt6804() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/kt6804.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedClassInObject.kt")
        public void testNestedClassInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/nestedClassInObject.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedClassObject.kt")
        public void testNestedClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/nestedClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedEnumConstant.kt")
        public void testNestedEnumConstant() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/nestedEnumConstant.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedGeneric.kt")
        public void testNestedGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/nestedGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedInPackage.kt")
        public void testNestedInPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/nestedInPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedObjects.kt")
        public void testNestedObjects() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/nestedObjects.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedSimple.kt")
        public void testNestedSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/nestedSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedNestedClass.kt")
        public void testProtectedNestedClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/protectedNestedClass.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedNestedClassFromJava.kt")
        public void testProtectedNestedClassFromJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/protectedNestedClassFromJava.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SuperConstructorCall extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInSuperConstructorCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/innerNested/superConstructorCall"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("deepInnerHierarchy.kt")
            public void testDeepInnerHierarchy() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/deepInnerHierarchy.kt");
                doTest(fileName);
            }

            @TestMetadata("deepLocalHierarchy.kt")
            public void testDeepLocalHierarchy() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/deepLocalHierarchy.kt");
                doTest(fileName);
            }

            @TestMetadata("innerExtendsInnerViaSecondaryConstuctor.kt")
            public void testInnerExtendsInnerViaSecondaryConstuctor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/innerExtendsInnerViaSecondaryConstuctor.kt");
                doTest(fileName);
            }

            @TestMetadata("innerExtendsInnerWithProperOuterCapture.kt")
            public void testInnerExtendsInnerWithProperOuterCapture() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/innerExtendsInnerWithProperOuterCapture.kt");
                doTest(fileName);
            }

            @TestMetadata("innerExtendsOuter.kt")
            public void testInnerExtendsOuter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/innerExtendsOuter.kt");
                doTest(fileName);
            }

            @TestMetadata("kt11833_1.kt")
            public void testKt11833_1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/kt11833_1.kt");
                doTest(fileName);
            }

            @TestMetadata("kt11833_2.kt")
            public void testKt11833_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/kt11833_2.kt");
                doTest(fileName);
            }

            @TestMetadata("localClassOuterDiffersFromInnerOuter.kt")
            public void testLocalClassOuterDiffersFromInnerOuter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/localClassOuterDiffersFromInnerOuter.kt");
                doTest(fileName);
            }

            @TestMetadata("localExtendsInner.kt")
            public void testLocalExtendsInner() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/localExtendsInner.kt");
                doTest(fileName);
            }

            @TestMetadata("localExtendsLocalWithClosure.kt")
            public void testLocalExtendsLocalWithClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/localExtendsLocalWithClosure.kt");
                doTest(fileName);
            }

            @TestMetadata("localWithClosureExtendsLocalWithClosure.kt")
            public void testLocalWithClosureExtendsLocalWithClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/localWithClosureExtendsLocalWithClosure.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExtendsClassDefaultArgument.kt")
            public void testObjectExtendsClassDefaultArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsClassDefaultArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExtendsClassVararg.kt")
            public void testObjectExtendsClassVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsClassVararg.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExtendsInner.kt")
            public void testObjectExtendsInner() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInner.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExtendsInnerDefaultArgument.kt")
            public void testObjectExtendsInnerDefaultArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInnerDefaultArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExtendsInnerOfLocalVarargAndDefault.kt")
            public void testObjectExtendsInnerOfLocalVarargAndDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInnerOfLocalVarargAndDefault.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExtendsInnerOfLocalWithCapture.kt")
            public void testObjectExtendsInnerOfLocalWithCapture() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsInnerOfLocalWithCapture.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExtendsLocalCaptureInSuperCall.kt")
            public void testObjectExtendsLocalCaptureInSuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsLocalCaptureInSuperCall.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExtendsLocalWithClosure.kt")
            public void testObjectExtendsLocalWithClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/objectExtendsLocalWithClosure.kt");
                doTest(fileName);
            }

            @TestMetadata("objectOuterDiffersFromInnerOuter.kt")
            public void testObjectOuterDiffersFromInnerOuter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/innerNested/superConstructorCall/objectOuterDiffersFromInnerOuter.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/instructions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Instructions extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInInstructions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/instructions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/instructions/swap")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Swap extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInSwap() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/instructions/swap"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("swapRefToSharedVarInt.kt")
            public void testSwapRefToSharedVarInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/instructions/swap/swapRefToSharedVarInt.kt");
                doTest(fileName);
            }

            @TestMetadata("swapRefToSharedVarLong.kt")
            public void testSwapRefToSharedVarLong() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/instructions/swap/swapRefToSharedVarLong.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/intrinsics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Intrinsics extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInIntrinsics() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/intrinsics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("charToInt.kt")
        public void testCharToInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/charToInt.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultObjectMapping.kt")
        public void testDefaultObjectMapping() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/defaultObjectMapping.kt");
            doTest(fileName);
        }

        @TestMetadata("ea35953.kt")
        public void testEa35953() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/ea35953.kt");
            doTest(fileName);
        }

        @TestMetadata("incWithLabel.kt")
        public void testIncWithLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/incWithLabel.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10131.kt")
        public void testKt10131() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/kt10131.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10131a.kt")
        public void testKt10131a() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/kt10131a.kt");
            doTest(fileName);
        }

        @TestMetadata("kt12125.kt")
        public void testKt12125() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/kt12125.kt");
            doTest(fileName);
        }

        @TestMetadata("kt12125_2.kt")
        public void testKt12125_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/kt12125_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt12125_inc.kt")
        public void testKt12125_inc() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/kt12125_inc.kt");
            doTest(fileName);
        }

        @TestMetadata("kt12125_inc_2.kt")
        public void testKt12125_inc_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/kt12125_inc_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5937.kt")
        public void testKt5937() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/kt5937.kt");
            doTest(fileName);
        }

        @TestMetadata("longRangeWithExplicitDot.kt")
        public void testLongRangeWithExplicitDot() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/longRangeWithExplicitDot.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixIncDec.kt")
        public void testPrefixIncDec() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/prefixIncDec.kt");
            doTest(fileName);
        }

        @TestMetadata("rangeFromCollection.kt")
        public void testRangeFromCollection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/rangeFromCollection.kt");
            doTest(fileName);
        }

        @TestMetadata("stringFromCollection.kt")
        public void testStringFromCollection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/stringFromCollection.kt");
            doTest(fileName);
        }

        @TestMetadata("throwable.kt")
        public void testThrowable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/throwable.kt");
            doTest(fileName);
        }

        @TestMetadata("throwableCallableReference.kt")
        public void testThrowableCallableReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/throwableCallableReference.kt");
            doTest(fileName);
        }

        @TestMetadata("throwableParamOrder.kt")
        public void testThrowableParamOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/throwableParamOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("tostring.kt")
        public void testTostring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/intrinsics/tostring.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/javaInterop")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JavaInterop extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInJavaInterop() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/javaInterop"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("lambdaInstanceOf.kt")
        public void testLambdaInstanceOf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/lambdaInstanceOf.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/javaInterop/generics")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Generics extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInGenerics() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/generics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("allWildcardsOnClass.kt")
            public void testAllWildcardsOnClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/generics/allWildcardsOnClass.kt");
                doTest(fileName);
            }

            @TestMetadata("covariantOverrideWithDeclarationSiteProjection.kt")
            public void testCovariantOverrideWithDeclarationSiteProjection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/generics/covariantOverrideWithDeclarationSiteProjection.kt");
                doTest(fileName);
            }

            @TestMetadata("invariantArgumentsNoWildcard.kt")
            public void testInvariantArgumentsNoWildcard() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/generics/invariantArgumentsNoWildcard.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/javaInterop/notNullAssertions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NotNullAssertions extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInNotNullAssertions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/notNullAssertions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("extensionReceiverParameter.kt")
            public void testExtensionReceiverParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/notNullAssertions/extensionReceiverParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("mapPut.kt")
            public void testMapPut() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/notNullAssertions/mapPut.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/javaInterop/objectMethods")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ObjectMethods extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInObjectMethods() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/javaInterop/objectMethods"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("cloneCallsConstructor.kt")
            public void testCloneCallsConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/objectMethods/cloneCallsConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("cloneCallsSuper.kt")
            public void testCloneCallsSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/objectMethods/cloneCallsSuper.kt");
                doTest(fileName);
            }

            @TestMetadata("cloneCallsSuperAndModifies.kt")
            public void testCloneCallsSuperAndModifies() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/objectMethods/cloneCallsSuperAndModifies.kt");
                doTest(fileName);
            }

            @TestMetadata("cloneHashSet.kt")
            public void testCloneHashSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/objectMethods/cloneHashSet.kt");
                doTest(fileName);
            }

            @TestMetadata("cloneHierarchy.kt")
            public void testCloneHierarchy() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/objectMethods/cloneHierarchy.kt");
                doTest(fileName);
            }

            @TestMetadata("cloneableClassWithoutClone.kt")
            public void testCloneableClassWithoutClone() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/javaInterop/objectMethods/cloneableClassWithoutClone.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jdk")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Jdk extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInJdk() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jdk"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayList.kt")
        public void testArrayList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jdk/arrayList.kt");
            doTest(fileName);
        }

        @TestMetadata("hashMap.kt")
        public void testHashMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jdk/hashMap.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratingOverHashMap.kt")
        public void testIteratingOverHashMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jdk/iteratingOverHashMap.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1397.kt")
        public void testKt1397() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jdk/kt1397.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmField")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmField extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInJvmField() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmField"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("captureClassFields.kt")
        public void testCaptureClassFields() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/captureClassFields.kt");
            doTest(fileName);
        }

        @TestMetadata("capturePackageFields.kt")
        public void testCapturePackageFields() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/capturePackageFields.kt");
            doTest(fileName);
        }

        @TestMetadata("checkNoAccessors.kt")
        public void testCheckNoAccessors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/checkNoAccessors.kt");
            doTest(fileName);
        }

        @TestMetadata("classFieldReference.kt")
        public void testClassFieldReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/classFieldReference.kt");
            doTest(fileName);
        }

        @TestMetadata("classFieldReflection.kt")
        public void testClassFieldReflection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/classFieldReflection.kt");
            doTest(fileName);
        }

        @TestMetadata("constructorProperty.kt")
        public void testConstructorProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/constructorProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("publicField.kt")
        public void testPublicField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/publicField.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleMemberProperty.kt")
        public void testSimpleMemberProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/simpleMemberProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("superCall.kt")
        public void testSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/superCall.kt");
            doTest(fileName);
        }

        @TestMetadata("superCall2.kt")
        public void testSuperCall2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/superCall2.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelFieldReference.kt")
        public void testTopLevelFieldReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/topLevelFieldReference.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelFieldReflection.kt")
        public void testTopLevelFieldReflection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/topLevelFieldReflection.kt");
            doTest(fileName);
        }

        @TestMetadata("visibility.kt")
        public void testVisibility() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/visibility.kt");
            doTest(fileName);
        }

        @TestMetadata("writeFieldReference.kt")
        public void testWriteFieldReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmField/writeFieldReference.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmName extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInJvmName() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmName"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("callableReference.kt")
        public void testCallableReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/callableReference.kt");
            doTest(fileName);
        }

        @TestMetadata("clashingErasure.kt")
        public void testClashingErasure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/clashingErasure.kt");
            doTest(fileName);
        }

        @TestMetadata("classMembers.kt")
        public void testClassMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/classMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("fakeJvmNameInJava.kt")
        public void testFakeJvmNameInJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/fakeJvmNameInJava.kt");
            doTest(fileName);
        }

        @TestMetadata("functionName.kt")
        public void testFunctionName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/functionName.kt");
            doTest(fileName);
        }

        @TestMetadata("multifileClass.kt")
        public void testMultifileClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/multifileClass.kt");
            doTest(fileName);
        }

        @TestMetadata("multifileClassWithLocalClass.kt")
        public void testMultifileClassWithLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/multifileClassWithLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("multifileClassWithLocalGeneric.kt")
        public void testMultifileClassWithLocalGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/multifileClassWithLocalGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessorsUseSite.kt")
        public void testPropertyAccessorsUseSite() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/propertyAccessorsUseSite.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyName.kt")
        public void testPropertyName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/propertyName.kt");
            doTest(fileName);
        }

        @TestMetadata("renamedFileClass.kt")
        public void testRenamedFileClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/renamedFileClass.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/jvmName/fileFacades")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FileFacades extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInFileFacades() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmName/fileFacades"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("differentFiles.kt")
            public void testDifferentFiles() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/fileFacades/differentFiles.kt");
                doTest(fileName);
            }

            @TestMetadata("javaAnnotationOnFileFacade.kt")
            public void testJavaAnnotationOnFileFacade() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/fileFacades/javaAnnotationOnFileFacade.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmName/fileFacades/simple.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmOverloads")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmOverloads extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInJvmOverloads() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmOverloads"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("companionObject.kt")
        public void testCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/companionObject.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultsNotAtEnd.kt")
        public void testDefaultsNotAtEnd() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/defaultsNotAtEnd.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleParameters.kt")
        public void testDoubleParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/doubleParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionMethod.kt")
        public void testExtensionMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/extensionMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/generics.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/innerClass.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleDefaultParameters.kt")
        public void testMultipleDefaultParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/multipleDefaultParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("nonDefaultParameter.kt")
        public void testNonDefaultParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/nonDefaultParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("primaryConstructor.kt")
        public void testPrimaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/primaryConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("privateClass.kt")
        public void testPrivateClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/privateClass.kt");
            doTest(fileName);
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/secondaryConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleJavaCall.kt")
        public void testSimpleJavaCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/simpleJavaCall.kt");
            doTest(fileName);
        }

        @TestMetadata("varargs.kt")
        public void testVarargs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmOverloads/varargs.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/jvmStatic")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JvmStatic extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInJvmStatic() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/jvmStatic"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("annotations.kt")
        public void testAnnotations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/annotations.kt");
            doTest(fileName);
        }

        @TestMetadata("closure.kt")
        public void testClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/closure.kt");
            doTest(fileName);
        }

        @TestMetadata("companionObject.kt")
        public void testCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/companionObject.kt");
            doTest(fileName);
        }

        @TestMetadata("convention.kt")
        public void testConvention() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/convention.kt");
            doTest(fileName);
        }

        @TestMetadata("default.kt")
        public void testDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/default.kt");
            doTest(fileName);
        }

        @TestMetadata("enumCompanion.kt")
        public void testEnumCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/enumCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("explicitObject.kt")
        public void testExplicitObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/explicitObject.kt");
            doTest(fileName);
        }

        @TestMetadata("funAccess.kt")
        public void testFunAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/funAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("importStaticMemberFromObject.kt")
        public void testImportStaticMemberFromObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/importStaticMemberFromObject.kt");
            doTest(fileName);
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/inline.kt");
            doTest(fileName);
        }

        @TestMetadata("inlinePropertyAccessors.kt")
        public void testInlinePropertyAccessors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/inlinePropertyAccessors.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9897_static.kt")
        public void testKt9897_static() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/kt9897_static.kt");
            doTest(fileName);
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/object.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixInc.kt")
        public void testPostfixInc() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/postfixInc.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixInc.kt")
        public void testPrefixInc() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/prefixInc.kt");
            doTest(fileName);
        }

        @TestMetadata("privateMethod.kt")
        public void testPrivateMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/privateMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("privateSetter.kt")
        public void testPrivateSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/privateSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccess.kt")
        public void testPropertyAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/propertyAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessorsCompanion.kt")
        public void testPropertyAccessorsCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/propertyAccessorsCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessorsObject.kt")
        public void testPropertyAccessorsObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/propertyAccessorsObject.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAsDefault.kt")
        public void testPropertyAsDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/propertyAsDefault.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("syntheticAccessor.kt")
        public void testSyntheticAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/jvmStatic/syntheticAccessor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/labels")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Labels extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInLabels() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/labels"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("labeledDeclarations.kt")
        public void testLabeledDeclarations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/labels/labeledDeclarations.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessor.kt")
        public void testPropertyAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/labels/propertyAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessorFunctionLiteral.kt")
        public void testPropertyAccessorFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/labels/propertyAccessorFunctionLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessorInnerExtensionFun.kt")
        public void testPropertyAccessorInnerExtensionFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/labels/propertyAccessorInnerExtensionFun.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessorObject.kt")
        public void testPropertyAccessorObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/labels/propertyAccessorObject.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyInClassAccessor.kt")
        public void testPropertyInClassAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/labels/propertyInClassAccessor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/lazyCodegen")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LazyCodegen extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInLazyCodegen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/lazyCodegen"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("exceptionInFieldInitializer.kt")
        public void testExceptionInFieldInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/exceptionInFieldInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("ifElse.kt")
        public void testIfElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/ifElse.kt");
            doTest(fileName);
        }

        @TestMetadata("increment.kt")
        public void testIncrement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/increment.kt");
            doTest(fileName);
        }

        @TestMetadata("safeAssign.kt")
        public void testSafeAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/safeAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("safeAssignComplex.kt")
        public void testSafeAssignComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/safeAssignComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCallAndArray.kt")
        public void testSafeCallAndArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/safeCallAndArray.kt");
            doTest(fileName);
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/toString.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatchExpression.kt")
        public void testTryCatchExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/tryCatchExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/when.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Optimizations extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInOptimizations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/lazyCodegen/optimizations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("negateConstantCompare.kt")
            public void testNegateConstantCompare() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations/negateConstantCompare.kt");
                doTest(fileName);
            }

            @TestMetadata("negateFalse.kt")
            public void testNegateFalse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations/negateFalse.kt");
                doTest(fileName);
            }

            @TestMetadata("negateFalseVar.kt")
            public void testNegateFalseVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations/negateFalseVar.kt");
                doTest(fileName);
            }

            @TestMetadata("negateFalseVarChain.kt")
            public void testNegateFalseVarChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations/negateFalseVarChain.kt");
                doTest(fileName);
            }

            @TestMetadata("negateObjectComp.kt")
            public void testNegateObjectComp() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations/negateObjectComp.kt");
                doTest(fileName);
            }

            @TestMetadata("negateObjectComp2.kt")
            public void testNegateObjectComp2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations/negateObjectComp2.kt");
                doTest(fileName);
            }

            @TestMetadata("negateTrue.kt")
            public void testNegateTrue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations/negateTrue.kt");
                doTest(fileName);
            }

            @TestMetadata("negateTrueVar.kt")
            public void testNegateTrueVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations/negateTrueVar.kt");
                doTest(fileName);
            }

            @TestMetadata("noOptimization.kt")
            public void testNoOptimization() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/lazyCodegen/optimizations/noOptimization.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/localClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LocalClasses extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInLocalClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/localClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("anonymousObjectInInitializer.kt")
        public void testAnonymousObjectInInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/anonymousObjectInInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectInParameterInitializer.kt")
        public void testAnonymousObjectInParameterInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/anonymousObjectInParameterInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("closureOfLambdaInLocalClass.kt")
        public void testClosureOfLambdaInLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/closureOfLambdaInLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inExtensionFunction.kt")
        public void testInExtensionFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/inExtensionFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("inExtensionProperty.kt")
        public void testInExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/inExtensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("inLocalExtensionFunction.kt")
        public void testInLocalExtensionFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/inLocalExtensionFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("inLocalExtensionProperty.kt")
        public void testInLocalExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/inLocalExtensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClassInLocalClass.kt")
        public void testInnerClassInLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/innerClassInLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("innerOfLocalCaptureExtensionReceiver.kt")
        public void testInnerOfLocalCaptureExtensionReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/innerOfLocalCaptureExtensionReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2700.kt")
        public void testKt2700() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/kt2700.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2873.kt")
        public void testKt2873() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/kt2873.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3210.kt")
        public void testKt3210() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/kt3210.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3389.kt")
        public void testKt3389() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/kt3389.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3584.kt")
        public void testKt3584() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/kt3584.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4174.kt")
        public void testKt4174() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/kt4174.kt");
            doTest(fileName);
        }

        @TestMetadata("localClass.kt")
        public void testLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/localClass.kt");
            doTest(fileName);
        }

        @TestMetadata("localClassCaptureExtensionReceiver.kt")
        public void testLocalClassCaptureExtensionReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/localClassCaptureExtensionReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("localClassInInitializer.kt")
        public void testLocalClassInInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/localClassInInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("localClassInParameterInitializer.kt")
        public void testLocalClassInParameterInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/localClassInParameterInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("localDataClass.kt")
        public void testLocalDataClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/localDataClass.kt");
            doTest(fileName);
        }

        @TestMetadata("localExtendsInnerAndReferencesOuterMember.kt")
        public void testLocalExtendsInnerAndReferencesOuterMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/localExtendsInnerAndReferencesOuterMember.kt");
            doTest(fileName);
        }

        @TestMetadata("noclosure.kt")
        public void testNoclosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/noclosure.kt");
            doTest(fileName);
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/object.kt");
            doTest(fileName);
        }

        @TestMetadata("ownClosureOfInnerLocalClass.kt")
        public void testOwnClosureOfInnerLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/ownClosureOfInnerLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("withclosure.kt")
        public void testWithclosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/localClasses/withclosure.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/mangling")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Mangling extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInMangling() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/mangling"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("field.kt")
        public void testField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/mangling/field.kt");
            doTest(fileName);
        }

        @TestMetadata("fun.kt")
        public void testFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/mangling/fun.kt");
            doTest(fileName);
        }

        @TestMetadata("internalOverride.kt")
        public void testInternalOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/mangling/internalOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("internalOverrideSuperCall.kt")
        public void testInternalOverrideSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/mangling/internalOverrideSuperCall.kt");
            doTest(fileName);
        }

        @TestMetadata("noOverrideWithJava.kt")
        public void testNoOverrideWithJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/mangling/noOverrideWithJava.kt");
            doTest(fileName);
        }

        @TestMetadata("publicOverride.kt")
        public void testPublicOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/mangling/publicOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("publicOverrideSuperCall.kt")
        public void testPublicOverrideSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/mangling/publicOverrideSuperCall.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/multiDecl")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultiDecl extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInMultiDecl() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("ComplexInitializer.kt")
        public void testComplexInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/ComplexInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("component.kt")
        public void testComponent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/component.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9828_hashMap.kt")
        public void testKt9828_hashMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/kt9828_hashMap.kt");
            doTest(fileName);
        }

        @TestMetadata("returnInElvis.kt")
        public void testReturnInElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/returnInElvis.kt");
            doTest(fileName);
        }

        @TestMetadata("SimpleVals.kt")
        public void testSimpleVals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/SimpleVals.kt");
            doTest(fileName);
        }

        @TestMetadata("SimpleValsExtensions.kt")
        public void testSimpleValsExtensions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/SimpleValsExtensions.kt");
            doTest(fileName);
        }

        @TestMetadata("SimpleVarsExtensions.kt")
        public void testSimpleVarsExtensions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/SimpleVarsExtensions.kt");
            doTest(fileName);
        }

        @TestMetadata("UnderscoreNames.kt")
        public void testUnderscoreNames() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/UnderscoreNames.kt");
            doTest(fileName);
        }

        @TestMetadata("ValCapturedInFunctionLiteral.kt")
        public void testValCapturedInFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/ValCapturedInFunctionLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("ValCapturedInLocalFunction.kt")
        public void testValCapturedInLocalFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/ValCapturedInLocalFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("ValCapturedInObjectLiteral.kt")
        public void testValCapturedInObjectLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/ValCapturedInObjectLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("VarCapturedInFunctionLiteral.kt")
        public void testVarCapturedInFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/VarCapturedInFunctionLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("VarCapturedInLocalFunction.kt")
        public void testVarCapturedInLocalFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/VarCapturedInLocalFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("VarCapturedInObjectLiteral.kt")
        public void testVarCapturedInObjectLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/VarCapturedInObjectLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/multiDecl/forIterator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForIterator extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInForIterator() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forIterator"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("MultiDeclFor.kt")
            public void testMultiDeclFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forIterator/MultiDeclFor.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForComponentExtensions.kt")
            public void testMultiDeclForComponentExtensions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forIterator/MultiDeclForComponentExtensions.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
            public void testMultiDeclForComponentMemberExtensions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forIterator/MultiDeclForComponentMemberExtensions.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
            public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forIterator/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForValCaptured.kt")
            public void testMultiDeclForValCaptured() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forIterator/MultiDeclForValCaptured.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/box/multiDecl/forIterator/longIterator")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class LongIterator extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInLongIterator() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forIterator/longIterator"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forIterator/longIterator/MultiDeclForComponentExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forIterator/longIterator/MultiDeclForComponentExtensionsValCaptured.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forIterator/longIterator/MultiDeclForComponentMemberExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forIterator/longIterator/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForRange extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInForRange() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("MultiDeclFor.kt")
            public void testMultiDeclFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/MultiDeclFor.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForComponentExtensions.kt")
            public void testMultiDeclForComponentExtensions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/MultiDeclForComponentExtensions.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
            public void testMultiDeclForComponentMemberExtensions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/MultiDeclForComponentMemberExtensions.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
            public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclForValCaptured.kt")
            public void testMultiDeclForValCaptured() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/MultiDeclForValCaptured.kt");
                doTest(fileName);
            }

            @TestMetadata("UnderscoreNames.kt")
            public void testUnderscoreNames() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/UnderscoreNames.kt");
                doTest(fileName);
            }

            @TestMetadata("UnderscoreNamesDontCallComponent.kt")
            public void testUnderscoreNamesDontCallComponent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/UnderscoreNamesDontCallComponent.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ExplicitRangeTo extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInExplicitRangeTo() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclFor.kt")
                public void testMultiDeclFor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/MultiDeclFor.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/MultiDeclForComponentExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/MultiDeclForComponentMemberExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForValCaptured.kt")
                public void testMultiDeclForValCaptured() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/MultiDeclForValCaptured.kt");
                    doTest(fileName);
                }

                @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Int extends AbstractIrBlackBoxCodegenTest {
                    public void testAllFilesPresentInInt() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("MultiDeclForComponentExtensions.kt")
                    public void testMultiDeclForComponentExtensions() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int/MultiDeclForComponentExtensions.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                    public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int/MultiDeclForComponentExtensionsValCaptured.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                    public void testMultiDeclForComponentMemberExtensions() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int/MultiDeclForComponentMemberExtensions.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                    public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                        doTest(fileName);
                    }
                }

                @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Long extends AbstractIrBlackBoxCodegenTest {
                    public void testAllFilesPresentInLong() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("MultiDeclForComponentExtensions.kt")
                    public void testMultiDeclForComponentExtensions() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long/MultiDeclForComponentExtensions.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                    public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long/MultiDeclForComponentExtensionsValCaptured.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                    public void testMultiDeclForComponentMemberExtensions() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long/MultiDeclForComponentMemberExtensions.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                    public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeTo/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                        doTest(fileName);
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ExplicitRangeToWithDot extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInExplicitRangeToWithDot() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclFor.kt")
                public void testMultiDeclFor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/MultiDeclFor.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/MultiDeclForComponentExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/MultiDeclForComponentMemberExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForValCaptured.kt")
                public void testMultiDeclForValCaptured() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/MultiDeclForValCaptured.kt");
                    doTest(fileName);
                }

                @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Int extends AbstractIrBlackBoxCodegenTest {
                    public void testAllFilesPresentInInt() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("MultiDeclForComponentExtensions.kt")
                    public void testMultiDeclForComponentExtensions() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int/MultiDeclForComponentExtensions.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                    public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int/MultiDeclForComponentExtensionsValCaptured.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                    public void testMultiDeclForComponentMemberExtensions() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int/MultiDeclForComponentMemberExtensions.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                    public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                        doTest(fileName);
                    }
                }

                @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Long extends AbstractIrBlackBoxCodegenTest {
                    public void testAllFilesPresentInLong() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                    }

                    @TestMetadata("MultiDeclForComponentExtensions.kt")
                    public void testMultiDeclForComponentExtensions() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long/MultiDeclForComponentExtensions.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                    public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long/MultiDeclForComponentExtensionsValCaptured.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                    public void testMultiDeclForComponentMemberExtensions() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long/MultiDeclForComponentMemberExtensions.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                    public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/explicitRangeToWithDot/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                        doTest(fileName);
                    }
                }
            }

            @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/int")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Int extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInInt() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/int"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/int/MultiDeclForComponentExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/int/MultiDeclForComponentExtensionsValCaptured.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/int/MultiDeclForComponentMemberExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/multiDecl/forRange/long")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Long extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInLong() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multiDecl/forRange/long"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/long/MultiDeclForComponentExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/long/MultiDeclForComponentExtensionsValCaptured.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/long/MultiDeclForComponentMemberExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multiDecl/forRange/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                    doTest(fileName);
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultifileClasses extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("callMultifileClassMemberFromOtherPackage.kt")
        public void testCallMultifileClassMemberFromOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/callMultifileClassMemberFromOtherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("callsToMultifileClassFromOtherPackage.kt")
        public void testCallsToMultifileClassFromOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/callsToMultifileClassFromOtherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("constPropertyReferenceFromMultifileClass.kt")
        public void testConstPropertyReferenceFromMultifileClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/constPropertyReferenceFromMultifileClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineMultifileClassMemberFromOtherPackage.kt")
        public void testInlineMultifileClassMemberFromOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/inlineMultifileClassMemberFromOtherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("multifileClassPartsInitialization.kt")
        public void testMultifileClassPartsInitialization() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/multifileClassPartsInitialization.kt");
            doTest(fileName);
        }

        @TestMetadata("multifileClassWith2Files.kt")
        public void testMultifileClassWith2Files() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/multifileClassWith2Files.kt");
            doTest(fileName);
        }

        @TestMetadata("multifileClassWithCrossCall.kt")
        public void testMultifileClassWithCrossCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/multifileClassWithCrossCall.kt");
            doTest(fileName);
        }

        @TestMetadata("multifileClassWithPrivate.kt")
        public void testMultifileClassWithPrivate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/multifileClassWithPrivate.kt");
            doTest(fileName);
        }

        @TestMetadata("privateConstVal.kt")
        public void testPrivateConstVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/privateConstVal.kt");
            doTest(fileName);
        }

        @TestMetadata("samePartNameDifferentFacades.kt")
        public void testSamePartNameDifferentFacades() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/samePartNameDifferentFacades.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/multifileClasses/optimized")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Optimized extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInOptimized() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/multifileClasses/optimized"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("callableRefToFun.kt")
            public void testCallableRefToFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/callableRefToFun.kt");
                doTest(fileName);
            }

            @TestMetadata("callableRefToInternalValInline.kt")
            public void testCallableRefToInternalValInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/callableRefToInternalValInline.kt");
                doTest(fileName);
            }

            @TestMetadata("callableRefToPrivateVal.kt")
            public void testCallableRefToPrivateVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/callableRefToPrivateVal.kt");
                doTest(fileName);
            }

            @TestMetadata("callableRefToVal.kt")
            public void testCallableRefToVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/callableRefToVal.kt");
                doTest(fileName);
            }

            @TestMetadata("calls.kt")
            public void testCalls() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/calls.kt");
                doTest(fileName);
            }

            @TestMetadata("deferredStaticInitialization.kt")
            public void testDeferredStaticInitialization() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/deferredStaticInitialization.kt");
                doTest(fileName);
            }

            @TestMetadata("delegatedVal.kt")
            public void testDelegatedVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/delegatedVal.kt");
                doTest(fileName);
            }

            @TestMetadata("initializePrivateVal.kt")
            public void testInitializePrivateVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/initializePrivateVal.kt");
                doTest(fileName);
            }

            @TestMetadata("initializePublicVal.kt")
            public void testInitializePublicVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/initializePublicVal.kt");
                doTest(fileName);
            }

            @TestMetadata("overlappingFuns.kt")
            public void testOverlappingFuns() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/overlappingFuns.kt");
                doTest(fileName);
            }

            @TestMetadata("overlappingVals.kt")
            public void testOverlappingVals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/overlappingVals.kt");
                doTest(fileName);
            }

            @TestMetadata("valAccessFromInlineFunCalledFromJava.kt")
            public void testValAccessFromInlineFunCalledFromJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/valAccessFromInlineFunCalledFromJava.kt");
                doTest(fileName);
            }

            @TestMetadata("valAccessFromInlinedToDifferentPackage.kt")
            public void testValAccessFromInlinedToDifferentPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/valAccessFromInlinedToDifferentPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("valWithAccessor.kt")
            public void testValWithAccessor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/multifileClasses/optimized/valWithAccessor.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/nonLocalReturns")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NonLocalReturns extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInNonLocalReturns() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("kt6895.kt")
        public void testKt6895() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/nonLocalReturns/kt6895.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9644let.kt")
        public void testKt9644let() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/nonLocalReturns/kt9644let.kt");
            doTest(fileName);
        }

        @TestMetadata("use.kt")
        public void testUse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/nonLocalReturns/use.kt");
            doTest(fileName);
        }

        @TestMetadata("useWithException.kt")
        public void testUseWithException() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/nonLocalReturns/useWithException.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/objectIntrinsics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ObjectIntrinsics extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInObjectIntrinsics() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/objectIntrinsics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("objects.kt")
        public void testObjects() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objectIntrinsics/objects.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/objects")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Objects extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInObjects() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/objects"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("anonymousObjectPropertyInitialization.kt")
        public void testAnonymousObjectPropertyInitialization() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/anonymousObjectPropertyInitialization.kt");
            doTest(fileName);
        }

        @TestMetadata("classCallsProtectedInheritedByCompanion.kt")
        public void testClassCallsProtectedInheritedByCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/classCallsProtectedInheritedByCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("flist.kt")
        public void testFlist() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/flist.kt");
            doTest(fileName);
        }

        @TestMetadata("initializationOrder.kt")
        public void testInitializationOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/initializationOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1047.kt")
        public void testKt1047() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt1047.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11117.kt")
        public void testKt11117() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt11117.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1136.kt")
        public void testKt1136() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt1136.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1186.kt")
        public void testKt1186() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt1186.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1600.kt")
        public void testKt1600() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt1600.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1737.kt")
        public void testKt1737() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt1737.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2398.kt")
        public void testKt2398() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt2398.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2663.kt")
        public void testKt2663() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt2663.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2663_2.kt")
        public void testKt2663_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt2663_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2675.kt")
        public void testKt2675() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt2675.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2719.kt")
        public void testKt2719() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt2719.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2822.kt")
        public void testKt2822() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt2822.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3238.kt")
        public void testKt3238() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt3238.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3684.kt")
        public void testKt3684() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt3684.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4086.kt")
        public void testKt4086() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt4086.kt");
            doTest(fileName);
        }

        @TestMetadata("kt535.kt")
        public void testKt535() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt535.kt");
            doTest(fileName);
        }

        @TestMetadata("kt560.kt")
        public void testKt560() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt560.kt");
            doTest(fileName);
        }

        @TestMetadata("kt694.kt")
        public void testKt694() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/kt694.kt");
            doTest(fileName);
        }

        @TestMetadata("localFunctionInObjectInitializer_kt4516.kt")
        public void testLocalFunctionInObjectInitializer_kt4516() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/localFunctionInObjectInitializer_kt4516.kt");
            doTest(fileName);
        }

        @TestMetadata("methodOnObject.kt")
        public void testMethodOnObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/methodOnObject.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedDerivedClassCallsProtectedFromCompanion.kt")
        public void testNestedDerivedClassCallsProtectedFromCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/nestedDerivedClassCallsProtectedFromCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedObjectWithSuperclass.kt")
        public void testNestedObjectWithSuperclass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/nestedObjectWithSuperclass.kt");
            doTest(fileName);
        }

        @TestMetadata("objectExtendsInnerAndReferencesOuterMember.kt")
        public void testObjectExtendsInnerAndReferencesOuterMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/objectExtendsInnerAndReferencesOuterMember.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInLocalAnonymousObject.kt")
        public void testObjectInLocalAnonymousObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/objectInLocalAnonymousObject.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInitialization_kt5523.kt")
        public void testObjectInitialization_kt5523() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/objectInitialization_kt5523.kt");
            doTest(fileName);
        }

        @TestMetadata("objectLiteral.kt")
        public void testObjectLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/objectLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("objectLiteralInClosure.kt")
        public void testObjectLiteralInClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/objectLiteralInClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("objectVsClassInitialization_kt5291.kt")
        public void testObjectVsClassInitialization_kt5291() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/objectVsClassInitialization_kt5291.kt");
            doTest(fileName);
        }

        @TestMetadata("objectWithSuperclass.kt")
        public void testObjectWithSuperclass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/objectWithSuperclass.kt");
            doTest(fileName);
        }

        @TestMetadata("objectWithSuperclassAndTrait.kt")
        public void testObjectWithSuperclassAndTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/objectWithSuperclassAndTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("privateExtensionFromInitializer_kt4543.kt")
        public void testPrivateExtensionFromInitializer_kt4543() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/privateExtensionFromInitializer_kt4543.kt");
            doTest(fileName);
        }

        @TestMetadata("privateFunctionFromClosureInInitializer_kt5582.kt")
        public void testPrivateFunctionFromClosureInInitializer_kt5582() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/privateFunctionFromClosureInInitializer_kt5582.kt");
            doTest(fileName);
        }

        @TestMetadata("receiverInConstructor.kt")
        public void testReceiverInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/receiverInConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("safeAccess.kt")
        public void testSafeAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/safeAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/simpleObject.kt");
            doTest(fileName);
        }

        @TestMetadata("thisInConstructor.kt")
        public void testThisInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/thisInConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("useAnonymousObjectAsIterator.kt")
        public void testUseAnonymousObjectAsIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/useAnonymousObjectAsIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("useImportedMember.kt")
        public void testUseImportedMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/useImportedMember.kt");
            doTest(fileName);
        }

        @TestMetadata("useImportedMemberFromCompanion.kt")
        public void testUseImportedMemberFromCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/objects/useImportedMemberFromCompanion.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/operatorConventions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class OperatorConventions extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInOperatorConventions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/operatorConventions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("assignmentOperations.kt")
        public void testAssignmentOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/assignmentOperations.kt");
            doTest(fileName);
        }

        @TestMetadata("incDecOnObject.kt")
        public void testIncDecOnObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/incDecOnObject.kt");
            doTest(fileName);
        }

        @TestMetadata("kt14201.kt")
        public void testKt14201() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/kt14201.kt");
            doTest(fileName);
        }

        @TestMetadata("kt14201_2.kt")
        public void testKt14201_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/kt14201_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4152.kt")
        public void testKt4152() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/kt4152.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4987.kt")
        public void testKt4987() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/kt4987.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedMaps.kt")
        public void testNestedMaps() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/nestedMaps.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadedSet.kt")
        public void testOverloadedSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/overloadedSet.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/operatorConventions/compareTo")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompareTo extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInCompareTo() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/operatorConventions/compareTo"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("boolean.kt")
            public void testBoolean() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/compareTo/boolean.kt");
                doTest(fileName);
            }

            @TestMetadata("comparable.kt")
            public void testComparable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/compareTo/comparable.kt");
                doTest(fileName);
            }

            @TestMetadata("doubleInt.kt")
            public void testDoubleInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/compareTo/doubleInt.kt");
                doTest(fileName);
            }

            @TestMetadata("doubleLong.kt")
            public void testDoubleLong() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/compareTo/doubleLong.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionArray.kt")
            public void testExtensionArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/compareTo/extensionArray.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionObject.kt")
            public void testExtensionObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/compareTo/extensionObject.kt");
                doTest(fileName);
            }

            @TestMetadata("intDouble.kt")
            public void testIntDouble() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/compareTo/intDouble.kt");
                doTest(fileName);
            }

            @TestMetadata("intLong.kt")
            public void testIntLong() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/compareTo/intLong.kt");
                doTest(fileName);
            }

            @TestMetadata("longDouble.kt")
            public void testLongDouble() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/compareTo/longDouble.kt");
                doTest(fileName);
            }

            @TestMetadata("longInt.kt")
            public void testLongInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/operatorConventions/compareTo/longInt.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/package")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Package extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInPackage() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/package"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("boxPrimitiveTypeInClinit.kt")
        public void testBoxPrimitiveTypeInClinit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/package/boxPrimitiveTypeInClinit.kt");
            doTest(fileName);
        }

        @TestMetadata("checkCast.kt")
        public void testCheckCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/package/checkCast.kt");
            doTest(fileName);
        }

        @TestMetadata("incrementProperty.kt")
        public void testIncrementProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/package/incrementProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("initializationOrder.kt")
        public void testInitializationOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/package/initializationOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("invokespecial.kt")
        public void testInvokespecial() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/package/invokespecial.kt");
            doTest(fileName);
        }

        @TestMetadata("mainInFiles.kt")
        public void testMainInFiles() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/package/mainInFiles.kt");
            doTest(fileName);
        }

        @TestMetadata("nullablePrimitiveNoFieldInitializer.kt")
        public void testNullablePrimitiveNoFieldInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/package/nullablePrimitiveNoFieldInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("packageLocalClassNotImportedWithDefaultImport.kt")
        public void testPackageLocalClassNotImportedWithDefaultImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/package/packageLocalClassNotImportedWithDefaultImport.kt");
            doTest(fileName);
        }

        @TestMetadata("packageQualifiedMethod.kt")
        public void testPackageQualifiedMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/package/packageQualifiedMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("privateTopLevelPropAndVarInInner.kt")
        public void testPrivateTopLevelPropAndVarInInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/package/privateTopLevelPropAndVarInInner.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/platformTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PlatformTypes extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInPlatformTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/platformTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/platformTypes/primitives")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Primitives extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInPrimitives() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/platformTypes/primitives"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("assign.kt")
            public void testAssign() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/assign.kt");
                doTest(fileName);
            }

            @TestMetadata("compareTo.kt")
            public void testCompareTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/compareTo.kt");
                doTest(fileName);
            }

            @TestMetadata("dec.kt")
            public void testDec() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/dec.kt");
                doTest(fileName);
            }

            @TestMetadata("div.kt")
            public void testDiv() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/div.kt");
                doTest(fileName);
            }

            @TestMetadata("equals.kt")
            public void testEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/equals.kt");
                doTest(fileName);
            }

            @TestMetadata("hashCode.kt")
            public void testHashCode() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/hashCode.kt");
                doTest(fileName);
            }

            @TestMetadata("identityEquals.kt")
            public void testIdentityEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/identityEquals.kt");
                doTest(fileName);
            }

            @TestMetadata("inc.kt")
            public void testInc() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/inc.kt");
                doTest(fileName);
            }

            @TestMetadata("minus.kt")
            public void testMinus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/minus.kt");
                doTest(fileName);
            }

            @TestMetadata("mod.kt")
            public void testMod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/mod.kt");
                doTest(fileName);
            }

            @TestMetadata("not.kt")
            public void testNot() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/not.kt");
                doTest(fileName);
            }

            @TestMetadata("notEquals.kt")
            public void testNotEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/notEquals.kt");
                doTest(fileName);
            }

            @TestMetadata("plus.kt")
            public void testPlus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/plus.kt");
                doTest(fileName);
            }

            @TestMetadata("plusAssign.kt")
            public void testPlusAssign() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/plusAssign.kt");
                doTest(fileName);
            }

            @TestMetadata("rangeTo.kt")
            public void testRangeTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/rangeTo.kt");
                doTest(fileName);
            }

            @TestMetadata("times.kt")
            public void testTimes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/times.kt");
                doTest(fileName);
            }

            @TestMetadata("toShort.kt")
            public void testToShort() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/toShort.kt");
                doTest(fileName);
            }

            @TestMetadata("toString.kt")
            public void testToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/toString.kt");
                doTest(fileName);
            }

            @TestMetadata("unaryMinus.kt")
            public void testUnaryMinus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/unaryMinus.kt");
                doTest(fileName);
            }

            @TestMetadata("unaryPlus.kt")
            public void testUnaryPlus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/platformTypes/primitives/unaryPlus.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/primitiveTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PrimitiveTypes extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInPrimitiveTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/primitiveTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("comparisonWithNaN.kt")
        public void testComparisonWithNaN() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/comparisonWithNaN.kt");
            doTest(fileName);
        }

        @TestMetadata("comparisonWithNullCallsFun.kt")
        public void testComparisonWithNullCallsFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/comparisonWithNullCallsFun.kt");
            doTest(fileName);
        }

        @TestMetadata("ea35963.kt")
        public void testEa35963() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/ea35963.kt");
            doTest(fileName);
        }

        @TestMetadata("equalsHashCodeToString.kt")
        public void testEqualsHashCodeToString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/equalsHashCodeToString.kt");
            doTest(fileName);
        }

        @TestMetadata("incrementByteCharShort.kt")
        public void testIncrementByteCharShort() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/incrementByteCharShort.kt");
            doTest(fileName);
        }

        @TestMetadata("intLiteralIsNotNull.kt")
        public void testIntLiteralIsNotNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/intLiteralIsNotNull.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1054.kt")
        public void testKt1054() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt1054.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1055.kt")
        public void testKt1055() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt1055.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1093.kt")
        public void testKt1093() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt1093.kt");
            doTest(fileName);
        }

        @TestMetadata("kt13023.kt")
        public void testKt13023() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt13023.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1508.kt")
        public void testKt1508() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt1508.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1634.kt")
        public void testKt1634() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt1634.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2251.kt")
        public void testKt2251() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt2251.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2269.kt")
        public void testKt2269() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt2269.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2275.kt")
        public void testKt2275() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt2275.kt");
            doTest(fileName);
        }

        @TestMetadata("kt239.kt")
        public void testKt239() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt239.kt");
            doTest(fileName);
        }

        @TestMetadata("kt242.kt")
        public void testKt242() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt242.kt");
            doTest(fileName);
        }

        @TestMetadata("kt243.kt")
        public void testKt243() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt243.kt");
            doTest(fileName);
        }

        @TestMetadata("kt248.kt")
        public void testKt248() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt248.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2768.kt")
        public void testKt2768() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt2768.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2794.kt")
        public void testKt2794() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt2794.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3078.kt")
        public void testKt3078() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt3078.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3517.kt")
        public void testKt3517() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt3517.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3576.kt")
        public void testKt3576() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt3576.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3613.kt")
        public void testKt3613() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt3613.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4097.kt")
        public void testKt4097() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt4097.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4098.kt")
        public void testKt4098() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt4098.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4210.kt")
        public void testKt4210() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt4210.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4251.kt")
        public void testKt4251() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt4251.kt");
            doTest(fileName);
        }

        @TestMetadata("kt446.kt")
        public void testKt446() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt446.kt");
            doTest(fileName);
        }

        @TestMetadata("kt518.kt")
        public void testKt518() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt518.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6590_identityEquals.kt")
        public void testKt6590_identityEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt6590_identityEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("kt665.kt")
        public void testKt665() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt665.kt");
            doTest(fileName);
        }

        @TestMetadata("kt684.kt")
        public void testKt684() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt684.kt");
            doTest(fileName);
        }

        @TestMetadata("kt711.kt")
        public void testKt711() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt711.kt");
            doTest(fileName);
        }

        @TestMetadata("kt737.kt")
        public void testKt737() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt737.kt");
            doTest(fileName);
        }

        @TestMetadata("kt752.kt")
        public void testKt752() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt752.kt");
            doTest(fileName);
        }

        @TestMetadata("kt753.kt")
        public void testKt753() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt753.kt");
            doTest(fileName);
        }

        @TestMetadata("kt756.kt")
        public void testKt756() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt756.kt");
            doTest(fileName);
        }

        @TestMetadata("kt757.kt")
        public void testKt757() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt757.kt");
            doTest(fileName);
        }

        @TestMetadata("kt828.kt")
        public void testKt828() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt828.kt");
            doTest(fileName);
        }

        @TestMetadata("kt877.kt")
        public void testKt877() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt877.kt");
            doTest(fileName);
        }

        @TestMetadata("kt882.kt")
        public void testKt882() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt882.kt");
            doTest(fileName);
        }

        @TestMetadata("kt887.kt")
        public void testKt887() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt887.kt");
            doTest(fileName);
        }

        @TestMetadata("kt935.kt")
        public void testKt935() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/kt935.kt");
            doTest(fileName);
        }

        @TestMetadata("nullAsNullableIntIsNull.kt")
        public void testNullAsNullableIntIsNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/nullAsNullableIntIsNull.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableCharBoolean.kt")
        public void testNullableCharBoolean() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/nullableCharBoolean.kt");
            doTest(fileName);
        }

        @TestMetadata("number.kt")
        public void testNumber() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/number.kt");
            doTest(fileName);
        }

        @TestMetadata("rangeTo.kt")
        public void testRangeTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/rangeTo.kt");
            doTest(fileName);
        }

        @TestMetadata("substituteIntForGeneric.kt")
        public void testSubstituteIntForGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/substituteIntForGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("unboxComparable.kt")
        public void testUnboxComparable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/primitiveTypes/unboxComparable.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/private")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Private extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInPrivate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/private"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayConvention.kt")
        public void testArrayConvention() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/private/arrayConvention.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9855.kt")
        public void testKt9855() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/private/kt9855.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/privateConstructors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PrivateConstructors extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInPrivateConstructors() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/privateConstructors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("base.kt")
        public void testBase() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/base.kt");
            doTest(fileName);
        }

        @TestMetadata("captured.kt")
        public void testCaptured() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/captured.kt");
            doTest(fileName);
        }

        @TestMetadata("companion.kt")
        public void testCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/companion.kt");
            doTest(fileName);
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/inline.kt");
            doTest(fileName);
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/inner.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4860.kt")
        public void testKt4860() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/kt4860.kt");
            doTest(fileName);
        }

        @TestMetadata("secondary.kt")
        public void testSecondary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/secondary.kt");
            doTest(fileName);
        }

        @TestMetadata("synthetic.kt")
        public void testSynthetic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/synthetic.kt");
            doTest(fileName);
        }

        @TestMetadata("withArguments.kt")
        public void testWithArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/withArguments.kt");
            doTest(fileName);
        }

        @TestMetadata("withDefault.kt")
        public void testWithDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/withDefault.kt");
            doTest(fileName);
        }

        @TestMetadata("withLinkedClasses.kt")
        public void testWithLinkedClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/withLinkedClasses.kt");
            doTest(fileName);
        }

        @TestMetadata("withLinkedObjects.kt")
        public void testWithLinkedObjects() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/withLinkedObjects.kt");
            doTest(fileName);
        }

        @TestMetadata("withVarargs.kt")
        public void testWithVarargs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/privateConstructors/withVarargs.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/properties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Properties extends AbstractIrBlackBoxCodegenTest {
        @TestMetadata("accessToPrivateProperty.kt")
        public void testAccessToPrivateProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/accessToPrivateProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("accessToPrivateSetter.kt")
        public void testAccessToPrivateSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/accessToPrivateSetter.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInProperties() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/properties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("augmentedAssignmentsAndIncrements.kt")
        public void testAugmentedAssignmentsAndIncrements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/augmentedAssignmentsAndIncrements.kt");
            try {
                doTest(fileName);
            }
            catch (Throwable ignore) {
                return;
            }
            throw new AssertionError("Looks like this test can be unmuted. Remove IGNORE_BACKEND directive for that.");
        }

        @TestMetadata("classArtificialFieldInsideNested.kt")
        public void testClassArtificialFieldInsideNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/classArtificialFieldInsideNested.kt");
            doTest(fileName);
        }

        @TestMetadata("classFieldInsideLambda.kt")
        public void testClassFieldInsideLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/classFieldInsideLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("classFieldInsideLocalInSetter.kt")
        public void testClassFieldInsideLocalInSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/classFieldInsideLocalInSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("classFieldInsideNested.kt")
        public void testClassFieldInsideNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/classFieldInsideNested.kt");
            doTest(fileName);
        }

        @TestMetadata("classObjectProperties.kt")
        public void testClassObjectProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/classObjectProperties.kt");
            doTest(fileName);
        }

        @TestMetadata("classPrivateArtificialFieldInsideNested.kt")
        public void testClassPrivateArtificialFieldInsideNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/classPrivateArtificialFieldInsideNested.kt");
            doTest(fileName);
        }

        @TestMetadata("collectionSize.kt")
        public void testCollectionSize() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/collectionSize.kt");
            doTest(fileName);
        }

        @TestMetadata("commonPropertiesKJK.kt")
        public void testCommonPropertiesKJK() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/commonPropertiesKJK.kt");
            doTest(fileName);
        }

        @TestMetadata("companionFieldInsideLambda.kt")
        public void testCompanionFieldInsideLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/companionFieldInsideLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("companionObjectAccessor.kt")
        public void testCompanionObjectAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/companionObjectAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("companionObjectPropertiesFromJava.kt")
        public void testCompanionObjectPropertiesFromJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/companionObjectPropertiesFromJava.kt");
            doTest(fileName);
        }

        @TestMetadata("companionPrivateField.kt")
        public void testCompanionPrivateField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/companionPrivateField.kt");
            doTest(fileName);
        }

        @TestMetadata("companionPrivateFieldInsideLambda.kt")
        public void testCompanionPrivateFieldInsideLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/companionPrivateFieldInsideLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("field.kt")
        public void testField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/field.kt");
            doTest(fileName);
        }

        @TestMetadata("fieldInClass.kt")
        public void testFieldInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/fieldInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("fieldInsideField.kt")
        public void testFieldInsideField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/fieldInsideField.kt");
            doTest(fileName);
        }

        @TestMetadata("fieldInsideLambda.kt")
        public void testFieldInsideLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/fieldInsideLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("fieldInsideNested.kt")
        public void testFieldInsideNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/fieldInsideNested.kt");
            doTest(fileName);
        }

        @TestMetadata("fieldSimple.kt")
        public void testFieldSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/fieldSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("generalAccess.kt")
        public void testGeneralAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/generalAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("javaPropertyBoxedGetter.kt")
        public void testJavaPropertyBoxedGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/javaPropertyBoxedGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("javaPropertyBoxedSetter.kt")
        public void testJavaPropertyBoxedSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/javaPropertyBoxedSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10715.kt")
        public void testKt10715() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt10715.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10729.kt")
        public void testKt10729() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt10729.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1159.kt")
        public void testKt1159() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt1159.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1165.kt")
        public void testKt1165() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt1165.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1168.kt")
        public void testKt1168() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt1168.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1170.kt")
        public void testKt1170() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt1170.kt");
            doTest(fileName);
        }

        @TestMetadata("kt12200.kt")
        public void testKt12200() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt12200.kt");
            doTest(fileName);
        }

        @TestMetadata("kt12200Const.kt")
        public void testKt12200Const() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt12200Const.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1398.kt")
        public void testKt1398() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt1398.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1417.kt")
        public void testKt1417() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt1417.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1482_2279.kt")
        public void testKt1482_2279() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt1482_2279.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1714.kt")
        public void testKt1714() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt1714.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1714_minimal.kt")
        public void testKt1714_minimal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt1714_minimal.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1892.kt")
        public void testKt1892() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt1892.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2331.kt")
        public void testKt2331() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt2331.kt");
            doTest(fileName);
        }

        @TestMetadata("kt257.kt")
        public void testKt257() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt257.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2655.kt")
        public void testKt2655() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt2655.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2786.kt")
        public void testKt2786() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt2786.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2892.kt")
        public void testKt2892() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt2892.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3118.kt")
        public void testKt3118() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt3118.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3524.kt")
        public void testKt3524() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt3524.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3551.kt")
        public void testKt3551() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt3551.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3556.kt")
        public void testKt3556() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt3556.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3930.kt")
        public void testKt3930() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt3930.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4140.kt")
        public void testKt4140() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt4140.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4252.kt")
        public void testKt4252() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt4252.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4252_2.kt")
        public void testKt4252_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt4252_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4340.kt")
        public void testKt4340() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt4340.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4373.kt")
        public void testKt4373() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt4373.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4383.kt")
        public void testKt4383() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt4383.kt");
            doTest(fileName);
        }

        @TestMetadata("kt613.kt")
        public void testKt613() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt613.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8928.kt")
        public void testKt8928() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt8928.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9603.kt")
        public void testKt9603() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/kt9603.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveOverrideDefaultAccessor.kt")
        public void testPrimitiveOverrideDefaultAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/primitiveOverrideDefaultAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveOverrideDelegateAccessor.kt")
        public void testPrimitiveOverrideDelegateAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/primitiveOverrideDelegateAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("privatePropertyInConstructor.kt")
        public void testPrivatePropertyInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/privatePropertyInConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("privatePropertyWithoutBackingField.kt")
        public void testPrivatePropertyWithoutBackingField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/privatePropertyWithoutBackingField.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedJavaFieldInInline.kt")
        public void testProtectedJavaFieldInInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/protectedJavaFieldInInline.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedJavaProperty.kt")
        public void testProtectedJavaProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/protectedJavaProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedJavaPropertyInCompanion.kt")
        public void testProtectedJavaPropertyInCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/protectedJavaPropertyInCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("substituteJavaSuperField.kt")
        public void testSubstituteJavaSuperField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/substituteJavaSuperField.kt");
            doTest(fileName);
        }

        @TestMetadata("twoAnnotatedExtensionPropertiesWithoutBackingFields.kt")
        public void testTwoAnnotatedExtensionPropertiesWithoutBackingFields() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/twoAnnotatedExtensionPropertiesWithoutBackingFields.kt");
            doTest(fileName);
        }

        @TestMetadata("typeInferredFromGetter.kt")
        public void testTypeInferredFromGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/typeInferredFromGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/properties/const")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Const extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInConst() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/properties/const"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("constFlags.kt")
            public void testConstFlags() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/const/constFlags.kt");
                doTest(fileName);
            }

            @TestMetadata("constValInAnnotationDefault.kt")
            public void testConstValInAnnotationDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/const/constValInAnnotationDefault.kt");
                doTest(fileName);
            }

            @TestMetadata("interfaceCompanion.kt")
            public void testInterfaceCompanion() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/const/interfaceCompanion.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/properties/lateinit")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Lateinit extends AbstractIrBlackBoxCodegenTest {
            @TestMetadata("accessor.kt")
            public void testAccessor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/lateinit/accessor.kt");
                doTest(fileName);
            }

            @TestMetadata("accessorException.kt")
            public void testAccessorException() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/lateinit/accessorException.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInLateinit() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/properties/lateinit"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("exceptionField.kt")
            public void testExceptionField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/lateinit/exceptionField.kt");
                doTest(fileName);
            }

            @TestMetadata("exceptionGetter.kt")
            public void testExceptionGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/lateinit/exceptionGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("override.kt")
            public void testOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/lateinit/override.kt");
                doTest(fileName);
            }

            @TestMetadata("overrideException.kt")
            public void testOverrideException() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/lateinit/overrideException.kt");
                doTest(fileName);
            }

            @TestMetadata("privateSetter.kt")
            public void testPrivateSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/lateinit/privateSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("privateSetterFromLambda.kt")
            public void testPrivateSetterFromLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/lateinit/privateSetterFromLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleVar.kt")
            public void testSimpleVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/lateinit/simpleVar.kt");
                doTest(fileName);
            }

            @TestMetadata("visibility.kt")
            public void testVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/properties/lateinit/visibility.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/ranges")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Ranges extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInRanges() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("forByteProgressionWithIntIncrement.kt")
        public void testForByteProgressionWithIntIncrement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forByteProgressionWithIntIncrement.kt");
            doTest(fileName);
        }

        @TestMetadata("forInRangeWithImplicitReceiver.kt")
        public void testForInRangeWithImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInRangeWithImplicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("forIntRange.kt")
        public void testForIntRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forIntRange.kt");
            doTest(fileName);
        }

        @TestMetadata("forNullableIntInRangeWithImplicitReceiver.kt")
        public void testForNullableIntInRangeWithImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forNullableIntInRangeWithImplicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("multiAssignmentIterationOverIntRange.kt")
        public void testMultiAssignmentIterationOverIntRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/multiAssignmentIterationOverIntRange.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCallRangeTo.kt")
        public void testSafeCallRangeTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/safeCallRangeTo.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/contains")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Contains extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInContains() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/contains"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("inComparableRange.kt")
            public void testInComparableRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inComparableRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inExtensionRange.kt")
            public void testInExtensionRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inExtensionRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inIntRange.kt")
            public void testInIntRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inIntRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inOptimizableDoubleRange.kt")
            public void testInOptimizableDoubleRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inOptimizableDoubleRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inOptimizableFloatRange.kt")
            public void testInOptimizableFloatRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inOptimizableFloatRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inOptimizableIntRange.kt")
            public void testInOptimizableIntRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inOptimizableIntRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inOptimizableLongRange.kt")
            public void testInOptimizableLongRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inOptimizableLongRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inRangeWithCustomContains.kt")
            public void testInRangeWithCustomContains() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inRangeWithCustomContains.kt");
                doTest(fileName);
            }

            @TestMetadata("inRangeWithImplicitReceiver.kt")
            public void testInRangeWithImplicitReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inRangeWithImplicitReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("inRangeWithNonmatchingArguments.kt")
            public void testInRangeWithNonmatchingArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inRangeWithNonmatchingArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("inRangeWithSmartCast.kt")
            public void testInRangeWithSmartCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/inRangeWithSmartCast.kt");
                doTest(fileName);
            }

            @TestMetadata("rangeContainsString.kt")
            public void testRangeContainsString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/contains/rangeContainsString.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/expression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Expression extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/expression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("emptyDownto.kt")
            public void testEmptyDownto() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/emptyDownto.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyRange.kt")
            public void testEmptyRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/emptyRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inexactDownToMinValue.kt")
            public void testInexactDownToMinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/inexactDownToMinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("inexactSteppedDownTo.kt")
            public void testInexactSteppedDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/inexactSteppedDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("inexactSteppedRange.kt")
            public void testInexactSteppedRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/inexactSteppedRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inexactToMaxValue.kt")
            public void testInexactToMaxValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/inexactToMaxValue.kt");
                doTest(fileName);
            }

            @TestMetadata("maxValueMinusTwoToMaxValue.kt")
            public void testMaxValueMinusTwoToMaxValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/maxValueMinusTwoToMaxValue.kt");
                doTest(fileName);
            }

            @TestMetadata("maxValueToMaxValue.kt")
            public void testMaxValueToMaxValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/maxValueToMaxValue.kt");
                doTest(fileName);
            }

            @TestMetadata("maxValueToMinValue.kt")
            public void testMaxValueToMinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/maxValueToMinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("oneElementDownTo.kt")
            public void testOneElementDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/oneElementDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("oneElementRange.kt")
            public void testOneElementRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/oneElementRange.kt");
                doTest(fileName);
            }

            @TestMetadata("openRange.kt")
            public void testOpenRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/openRange.kt");
                doTest(fileName);
            }

            @TestMetadata("progressionDownToMinValue.kt")
            public void testProgressionDownToMinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/progressionDownToMinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("progressionMaxValueMinusTwoToMaxValue.kt")
            public void testProgressionMaxValueMinusTwoToMaxValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/progressionMaxValueMinusTwoToMaxValue.kt");
                doTest(fileName);
            }

            @TestMetadata("progressionMaxValueToMaxValue.kt")
            public void testProgressionMaxValueToMaxValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/progressionMaxValueToMaxValue.kt");
                doTest(fileName);
            }

            @TestMetadata("progressionMaxValueToMinValue.kt")
            public void testProgressionMaxValueToMinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/progressionMaxValueToMinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("progressionMinValueToMinValue.kt")
            public void testProgressionMinValueToMinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/progressionMinValueToMinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedBackSequence.kt")
            public void testReversedBackSequence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/reversedBackSequence.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedEmptyBackSequence.kt")
            public void testReversedEmptyBackSequence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/reversedEmptyBackSequence.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedEmptyRange.kt")
            public void testReversedEmptyRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/reversedEmptyRange.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedInexactSteppedDownTo.kt")
            public void testReversedInexactSteppedDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/reversedInexactSteppedDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedRange.kt")
            public void testReversedRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/reversedRange.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedSimpleSteppedRange.kt")
            public void testReversedSimpleSteppedRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/reversedSimpleSteppedRange.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleDownTo.kt")
            public void testSimpleDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/simpleDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleRange.kt")
            public void testSimpleRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/simpleRange.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleRangeWithNonConstantEnds.kt")
            public void testSimpleRangeWithNonConstantEnds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/simpleRangeWithNonConstantEnds.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleSteppedDownTo.kt")
            public void testSimpleSteppedDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/simpleSteppedDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleSteppedRange.kt")
            public void testSimpleSteppedRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/expression/simpleSteppedRange.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/forInDownTo")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInDownTo extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInForInDownTo() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/forInDownTo"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forIntInDownTo.kt")
            public void testForIntInDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInDownTo/forIntInDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("forIntInNonOptimizedDownTo.kt")
            public void testForIntInNonOptimizedDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInDownTo/forIntInNonOptimizedDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("forLongInDownTo.kt")
            public void testForLongInDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInDownTo/forLongInDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("forNullableIntInDownTo.kt")
            public void testForNullableIntInDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInDownTo/forNullableIntInDownTo.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/forInIndices")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInIndices extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInForInIndices() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/forInIndices"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("forInCharSequenceIndices.kt")
            public void testForInCharSequenceIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/forInCharSequenceIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forInCollectionImplicitReceiverIndices.kt")
            public void testForInCollectionImplicitReceiverIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/forInCollectionImplicitReceiverIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forInCollectionIndices.kt")
            public void testForInCollectionIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/forInCollectionIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forInNonOptimizedIndices.kt")
            public void testForInNonOptimizedIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/forInNonOptimizedIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forInObjectArrayIndices.kt")
            public void testForInObjectArrayIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/forInObjectArrayIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forInPrimitiveArrayIndices.kt")
            public void testForInPrimitiveArrayIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/forInPrimitiveArrayIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forNullableIntInArrayIndices.kt")
            public void testForNullableIntInArrayIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/forNullableIntInArrayIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forNullableIntInCollectionIndices.kt")
            public void testForNullableIntInCollectionIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/forNullableIntInCollectionIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12983_forInGenericArrayIndices.kt")
            public void testKt12983_forInGenericArrayIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/kt12983_forInGenericArrayIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12983_forInGenericCollectionIndices.kt")
            public void testKt12983_forInGenericCollectionIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/kt12983_forInGenericCollectionIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12983_forInSpecificArrayIndices.kt")
            public void testKt12983_forInSpecificArrayIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/kt12983_forInSpecificArrayIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12983_forInSpecificCollectionIndices.kt")
            public void testKt12983_forInSpecificCollectionIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/kt12983_forInSpecificCollectionIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("kt13241_Array.kt")
            public void testKt13241_Array() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/kt13241_Array.kt");
                doTest(fileName);
            }

            @TestMetadata("kt13241_CharSequence.kt")
            public void testKt13241_CharSequence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/kt13241_CharSequence.kt");
                doTest(fileName);
            }

            @TestMetadata("kt13241_Collection.kt")
            public void testKt13241_Collection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/forInIndices/kt13241_Collection.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/literal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Literal extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInLiteral() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/literal"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("emptyDownto.kt")
            public void testEmptyDownto() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/emptyDownto.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyRange.kt")
            public void testEmptyRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/emptyRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inexactDownToMinValue.kt")
            public void testInexactDownToMinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/inexactDownToMinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("inexactSteppedDownTo.kt")
            public void testInexactSteppedDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/inexactSteppedDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("inexactSteppedRange.kt")
            public void testInexactSteppedRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/inexactSteppedRange.kt");
                doTest(fileName);
            }

            @TestMetadata("inexactToMaxValue.kt")
            public void testInexactToMaxValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/inexactToMaxValue.kt");
                doTest(fileName);
            }

            @TestMetadata("maxValueMinusTwoToMaxValue.kt")
            public void testMaxValueMinusTwoToMaxValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/maxValueMinusTwoToMaxValue.kt");
                doTest(fileName);
            }

            @TestMetadata("maxValueToMaxValue.kt")
            public void testMaxValueToMaxValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/maxValueToMaxValue.kt");
                doTest(fileName);
            }

            @TestMetadata("maxValueToMinValue.kt")
            public void testMaxValueToMinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/maxValueToMinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("oneElementDownTo.kt")
            public void testOneElementDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/oneElementDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("oneElementRange.kt")
            public void testOneElementRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/oneElementRange.kt");
                doTest(fileName);
            }

            @TestMetadata("openRange.kt")
            public void testOpenRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/openRange.kt");
                doTest(fileName);
            }

            @TestMetadata("progressionDownToMinValue.kt")
            public void testProgressionDownToMinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/progressionDownToMinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("progressionMaxValueMinusTwoToMaxValue.kt")
            public void testProgressionMaxValueMinusTwoToMaxValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/progressionMaxValueMinusTwoToMaxValue.kt");
                doTest(fileName);
            }

            @TestMetadata("progressionMaxValueToMaxValue.kt")
            public void testProgressionMaxValueToMaxValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/progressionMaxValueToMaxValue.kt");
                doTest(fileName);
            }

            @TestMetadata("progressionMaxValueToMinValue.kt")
            public void testProgressionMaxValueToMinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/progressionMaxValueToMinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("progressionMinValueToMinValue.kt")
            public void testProgressionMinValueToMinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/progressionMinValueToMinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedBackSequence.kt")
            public void testReversedBackSequence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/reversedBackSequence.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedEmptyBackSequence.kt")
            public void testReversedEmptyBackSequence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/reversedEmptyBackSequence.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedEmptyRange.kt")
            public void testReversedEmptyRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/reversedEmptyRange.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedInexactSteppedDownTo.kt")
            public void testReversedInexactSteppedDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/reversedInexactSteppedDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedRange.kt")
            public void testReversedRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/reversedRange.kt");
                doTest(fileName);
            }

            @TestMetadata("reversedSimpleSteppedRange.kt")
            public void testReversedSimpleSteppedRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/reversedSimpleSteppedRange.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleDownTo.kt")
            public void testSimpleDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/simpleDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleRange.kt")
            public void testSimpleRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/simpleRange.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleRangeWithNonConstantEnds.kt")
            public void testSimpleRangeWithNonConstantEnds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/simpleRangeWithNonConstantEnds.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleSteppedDownTo.kt")
            public void testSimpleSteppedDownTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/simpleSteppedDownTo.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleSteppedRange.kt")
            public void testSimpleSteppedRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/literal/simpleSteppedRange.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/ranges/nullableLoopParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NullableLoopParameter extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInNullableLoopParameter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/ranges/nullableLoopParameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("progressionExpression.kt")
            public void testProgressionExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/nullableLoopParameter/progressionExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("rangeExpression.kt")
            public void testRangeExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/nullableLoopParameter/rangeExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("rangeLiteral.kt")
            public void testRangeLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/ranges/nullableLoopParameter/rangeLiteral.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/reflection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Reflection extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInReflection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/annotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotations extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotationRetentionAnnotation.kt")
            public void testAnnotationRetentionAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/annotations/annotationRetentionAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("annotationsOnJavaMembers.kt")
            public void testAnnotationsOnJavaMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/annotations/annotationsOnJavaMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyAccessors.kt")
            public void testPropertyAccessors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/annotations/propertyAccessors.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyWithoutBackingField.kt")
            public void testPropertyWithoutBackingField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/annotations/propertyWithoutBackingField.kt");
                doTest(fileName);
            }

            @TestMetadata("retentions.kt")
            public void testRetentions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/annotations/retentions.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleClassAnnotation.kt")
            public void testSimpleClassAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/annotations/simpleClassAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleConstructorAnnotation.kt")
            public void testSimpleConstructorAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/annotations/simpleConstructorAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleFunAnnotation.kt")
            public void testSimpleFunAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/annotations/simpleFunAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleParamAnnotation.kt")
            public void testSimpleParamAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/annotations/simpleParamAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleValAnnotation.kt")
            public void testSimpleValAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/annotations/simpleValAnnotation.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/call")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Call extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/call"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("callInstanceJavaMethod.kt")
            public void testCallInstanceJavaMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/callInstanceJavaMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("callPrivateJavaMethod.kt")
            public void testCallPrivateJavaMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/callPrivateJavaMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("callStaticJavaMethod.kt")
            public void testCallStaticJavaMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/callStaticJavaMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("cannotCallEnumConstructor.kt")
            public void testCannotCallEnumConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/cannotCallEnumConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("disallowNullValueForNotNullField.kt")
            public void testDisallowNullValueForNotNullField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/disallowNullValueForNotNullField.kt");
                doTest(fileName);
            }

            @TestMetadata("equalsHashCodeToString.kt")
            public void testEqualsHashCodeToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/equalsHashCodeToString.kt");
                doTest(fileName);
            }

            @TestMetadata("exceptionHappened.kt")
            public void testExceptionHappened() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/exceptionHappened.kt");
                doTest(fileName);
            }

            @TestMetadata("fakeOverride.kt")
            public void testFakeOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/fakeOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("fakeOverrideSubstituted.kt")
            public void testFakeOverrideSubstituted() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/fakeOverrideSubstituted.kt");
                doTest(fileName);
            }

            @TestMetadata("incorrectNumberOfArguments.kt")
            public void testIncorrectNumberOfArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/incorrectNumberOfArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("innerClassConstructor.kt")
            public void testInnerClassConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/innerClassConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmStatic.kt")
            public void testJvmStatic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/jvmStatic.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmStaticInObjectIncorrectReceiver.kt")
            public void testJvmStaticInObjectIncorrectReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/jvmStaticInObjectIncorrectReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("localClassMember.kt")
            public void testLocalClassMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/localClassMember.kt");
                doTest(fileName);
            }

            @TestMetadata("memberOfGenericClass.kt")
            public void testMemberOfGenericClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/memberOfGenericClass.kt");
                doTest(fileName);
            }

            @TestMetadata("privateProperty.kt")
            public void testPrivateProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/privateProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyAccessors.kt")
            public void testPropertyAccessors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/propertyAccessors.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyGetterAndGetFunctionDifferentReturnType.kt")
            public void testPropertyGetterAndGetFunctionDifferentReturnType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/propertyGetterAndGetFunctionDifferentReturnType.kt");
                doTest(fileName);
            }

            @TestMetadata("returnUnit.kt")
            public void testReturnUnit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/returnUnit.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleConstructor.kt")
            public void testSimpleConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/simpleConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleMemberFunction.kt")
            public void testSimpleMemberFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/simpleMemberFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleTopLevelFunctions.kt")
            public void testSimpleTopLevelFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/call/simpleTopLevelFunctions.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/callBy")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CallBy extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInCallBy() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/callBy"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("companionObject.kt")
            public void testCompanionObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/companionObject.kt");
                doTest(fileName);
            }

            @TestMetadata("defaultAndNonDefaultIntertwined.kt")
            public void testDefaultAndNonDefaultIntertwined() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/defaultAndNonDefaultIntertwined.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFunction.kt")
            public void testExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/extensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmStaticInCompanionObject.kt")
            public void testJvmStaticInCompanionObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/jvmStaticInCompanionObject.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmStaticInObject.kt")
            public void testJvmStaticInObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/jvmStaticInObject.kt");
                doTest(fileName);
            }

            @TestMetadata("manyArgumentsOnlyOneDefault.kt")
            public void testManyArgumentsOnlyOneDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/manyArgumentsOnlyOneDefault.kt");
                doTest(fileName);
            }

            @TestMetadata("manyMaskArguments.kt")
            public void testManyMaskArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/manyMaskArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("nonDefaultParameterOmitted.kt")
            public void testNonDefaultParameterOmitted() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/nonDefaultParameterOmitted.kt");
                doTest(fileName);
            }

            @TestMetadata("nullValue.kt")
            public void testNullValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/nullValue.kt");
                doTest(fileName);
            }

            @TestMetadata("ordinaryMethodIsInvokedWhenNoDefaultValuesAreUsed.kt")
            public void testOrdinaryMethodIsInvokedWhenNoDefaultValuesAreUsed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/ordinaryMethodIsInvokedWhenNoDefaultValuesAreUsed.kt");
                doTest(fileName);
            }

            @TestMetadata("primitiveDefaultValues.kt")
            public void testPrimitiveDefaultValues() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/primitiveDefaultValues.kt");
                doTest(fileName);
            }

            @TestMetadata("privateMemberFunction.kt")
            public void testPrivateMemberFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/privateMemberFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleConstructor.kt")
            public void testSimpleConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/simpleConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleMemberFunciton.kt")
            public void testSimpleMemberFunciton() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/simpleMemberFunciton.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleTopLevelFunction.kt")
            public void testSimpleTopLevelFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/callBy/simpleTopLevelFunction.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/classLiterals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassLiterals extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInClassLiterals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/classLiterals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotationClassLiteral.kt")
            public void testAnnotationClassLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classLiterals/annotationClassLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("arrays.kt")
            public void testArrays() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classLiterals/arrays.kt");
                doTest(fileName);
            }

            @TestMetadata("builtinClassLiterals.kt")
            public void testBuiltinClassLiterals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classLiterals/builtinClassLiterals.kt");
                doTest(fileName);
            }

            @TestMetadata("genericArrays.kt")
            public void testGenericArrays() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classLiterals/genericArrays.kt");
                doTest(fileName);
            }

            @TestMetadata("genericClass.kt")
            public void testGenericClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classLiterals/genericClass.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedTypeClassLiteral.kt")
            public void testReifiedTypeClassLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classLiterals/reifiedTypeClassLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleClassLiteral.kt")
            public void testSimpleClassLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classLiterals/simpleClassLiteral.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/classes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Classes extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInClasses() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/classes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("classSimpleName.kt")
            public void testClassSimpleName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/classSimpleName.kt");
                doTest(fileName);
            }

            @TestMetadata("companionObject.kt")
            public void testCompanionObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/companionObject.kt");
                doTest(fileName);
            }

            @TestMetadata("createInstance.kt")
            public void testCreateInstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/createInstance.kt");
                doTest(fileName);
            }

            @TestMetadata("declaredMembers.kt")
            public void testDeclaredMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/declaredMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmName.kt")
            public void testJvmName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/jvmName.kt");
                doTest(fileName);
            }

            @TestMetadata("localClassSimpleName.kt")
            public void testLocalClassSimpleName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/localClassSimpleName.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClasses.kt")
            public void testNestedClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/nestedClasses.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClassesJava.kt")
            public void testNestedClassesJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/nestedClassesJava.kt");
                doTest(fileName);
            }

            @TestMetadata("objectInstance.kt")
            public void testObjectInstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/objectInstance.kt");
                doTest(fileName);
            }

            @TestMetadata("primitiveKClassEquality.kt")
            public void testPrimitiveKClassEquality() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/primitiveKClassEquality.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifiedName.kt")
            public void testQualifiedName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/qualifiedName.kt");
                doTest(fileName);
            }

            @TestMetadata("starProjectedType.kt")
            public void testStarProjectedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/classes/starProjectedType.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/constructors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructors extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInConstructors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/constructors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotationClass.kt")
            public void testAnnotationClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/constructors/annotationClass.kt");
                doTest(fileName);
            }

            @TestMetadata("classesWithoutConstructors.kt")
            public void testClassesWithoutConstructors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/constructors/classesWithoutConstructors.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorName.kt")
            public void testConstructorName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/constructors/constructorName.kt");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/constructors/primaryConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleGetConstructors.kt")
            public void testSimpleGetConstructors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/constructors/simpleGetConstructors.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/createAnnotation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateAnnotation extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInCreateAnnotation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/createAnnotation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("annotationType.kt")
            public void testAnnotationType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/annotationType.kt");
                doTest(fileName);
            }

            @TestMetadata("arrayOfKClasses.kt")
            public void testArrayOfKClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/arrayOfKClasses.kt");
                doTest(fileName);
            }

            @TestMetadata("callByJava.kt")
            public void testCallByJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/callByJava.kt");
                doTest(fileName);
            }

            @TestMetadata("callByKotlin.kt")
            public void testCallByKotlin() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/callByKotlin.kt");
                doTest(fileName);
            }

            @TestMetadata("callJava.kt")
            public void testCallJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/callJava.kt");
                doTest(fileName);
            }

            @TestMetadata("callKotlin.kt")
            public void testCallKotlin() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/callKotlin.kt");
                doTest(fileName);
            }

            @TestMetadata("createJdkAnnotationInstance.kt")
            public void testCreateJdkAnnotationInstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/createJdkAnnotationInstance.kt");
                doTest(fileName);
            }

            @TestMetadata("enumKClassAnnotation.kt")
            public void testEnumKClassAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/enumKClassAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("equalsHashCodeToString.kt")
            public void testEqualsHashCodeToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/equalsHashCodeToString.kt");
                doTest(fileName);
            }

            @TestMetadata("floatingPointParameters.kt")
            public void testFloatingPointParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/floatingPointParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("parameterNamedEquals.kt")
            public void testParameterNamedEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/parameterNamedEquals.kt");
                doTest(fileName);
            }

            @TestMetadata("primitivesAndArrays.kt")
            public void testPrimitivesAndArrays() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/createAnnotation/primitivesAndArrays.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/enclosing")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Enclosing extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInEnclosing() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/enclosing"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("anonymousObjectInInlinedLambda.kt")
            public void testAnonymousObjectInInlinedLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/anonymousObjectInInlinedLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("classInLambda.kt")
            public void testClassInLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/classInLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("functionExpressionInProperty.kt")
            public void testFunctionExpressionInProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/functionExpressionInProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6368.kt")
            public void testKt6368() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/kt6368.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6691_lambdaInSamConstructor.kt")
            public void testKt6691_lambdaInSamConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/kt6691_lambdaInSamConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInClassObject.kt")
            public void testLambdaInClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInConstructor.kt")
            public void testLambdaInConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInFunction.kt")
            public void testLambdaInFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInLambda.kt")
            public void testLambdaInLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInLocalClassConstructor.kt")
            public void testLambdaInLocalClassConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInLocalClassConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInLocalClassSuperCall.kt")
            public void testLambdaInLocalClassSuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInLocalClassSuperCall.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInLocalFunction.kt")
            public void testLambdaInLocalFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInLocalFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInMemberFunction.kt")
            public void testLambdaInMemberFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInMemberFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInMemberFunctionInLocalClass.kt")
            public void testLambdaInMemberFunctionInLocalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInMemberFunctionInLocalClass.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInMemberFunctionInNestedClass.kt")
            public void testLambdaInMemberFunctionInNestedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInMemberFunctionInNestedClass.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInObjectDeclaration.kt")
            public void testLambdaInObjectDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInObjectDeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInObjectExpression.kt")
            public void testLambdaInObjectExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInObjectExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInObjectLiteralSuperCall.kt")
            public void testLambdaInObjectLiteralSuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInObjectLiteralSuperCall.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInPackage.kt")
            public void testLambdaInPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInPropertyGetter.kt")
            public void testLambdaInPropertyGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInPropertyGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInPropertySetter.kt")
            public void testLambdaInPropertySetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/lambdaInPropertySetter.kt");
                doTest(fileName);
            }

            @TestMetadata("localClassInTopLevelFunction.kt")
            public void testLocalClassInTopLevelFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/localClassInTopLevelFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("objectInLambda.kt")
            public void testObjectInLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/enclosing/objectInLambda.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/functions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Functions extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInFunctions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/functions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("declaredVsInheritedFunctions.kt")
            public void testDeclaredVsInheritedFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/declaredVsInheritedFunctions.kt");
                doTest(fileName);
            }

            @TestMetadata("functionFromStdlib.kt")
            public void testFunctionFromStdlib() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/functionFromStdlib.kt");
                doTest(fileName);
            }

            @TestMetadata("functionReferenceErasedToKFunction.kt")
            public void testFunctionReferenceErasedToKFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/functionReferenceErasedToKFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("genericOverriddenFunction.kt")
            public void testGenericOverriddenFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/genericOverriddenFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("instanceOfFunction.kt")
            public void testInstanceOfFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/instanceOfFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("javaClassGetFunctions.kt")
            public void testJavaClassGetFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/javaClassGetFunctions.kt");
                doTest(fileName);
            }

            @TestMetadata("javaMethodsSmokeTest.kt")
            public void testJavaMethodsSmokeTest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/javaMethodsSmokeTest.kt");
                doTest(fileName);
            }

            @TestMetadata("platformName.kt")
            public void testPlatformName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/platformName.kt");
                doTest(fileName);
            }

            @TestMetadata("privateMemberFunction.kt")
            public void testPrivateMemberFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/privateMemberFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleGetFunctions.kt")
            public void testSimpleGetFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/simpleGetFunctions.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleNames.kt")
            public void testSimpleNames() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/functions/simpleNames.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/genericSignature")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class GenericSignature extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInGenericSignature() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/genericSignature"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("covariantOverride.kt")
            public void testCovariantOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/genericSignature/covariantOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("defaultImplsGenericSignature.kt")
            public void testDefaultImplsGenericSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/genericSignature/defaultImplsGenericSignature.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralGenericSignature.kt")
            public void testFunctionLiteralGenericSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/genericSignature/functionLiteralGenericSignature.kt");
                doTest(fileName);
            }

            @TestMetadata("genericBackingFieldSignature.kt")
            public void testGenericBackingFieldSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/genericSignature/genericBackingFieldSignature.kt");
                doTest(fileName);
            }

            @TestMetadata("genericMethodSignature.kt")
            public void testGenericMethodSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/genericSignature/genericMethodSignature.kt");
                doTest(fileName);
            }

            @TestMetadata("kt11121.kt")
            public void testKt11121() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/genericSignature/kt11121.kt");
                doTest(fileName);
            }

            @TestMetadata("kt5112.kt")
            public void testKt5112() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/genericSignature/kt5112.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6106.kt")
            public void testKt6106() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/genericSignature/kt6106.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/isInstance")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IsInstance extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInIsInstance() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/isInstance"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("isInstanceCastAndSafeCast.kt")
            public void testIsInstanceCastAndSafeCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/isInstance/isInstanceCastAndSafeCast.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/kClassInAnnotation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KClassInAnnotation extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInKClassInAnnotation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/kClassInAnnotation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/kClassInAnnotation/array.kt");
                doTest(fileName);
            }

            @TestMetadata("arrayInJava.kt")
            public void testArrayInJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/kClassInAnnotation/arrayInJava.kt");
                doTest(fileName);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/kClassInAnnotation/basic.kt");
                doTest(fileName);
            }

            @TestMetadata("basicInJava.kt")
            public void testBasicInJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/kClassInAnnotation/basicInJava.kt");
                doTest(fileName);
            }

            @TestMetadata("checkcast.kt")
            public void testCheckcast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/kClassInAnnotation/checkcast.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/kClassInAnnotation/vararg.kt");
                doTest(fileName);
            }

            @TestMetadata("varargInJava.kt")
            public void testVarargInJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/kClassInAnnotation/varargInJava.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/lambdaClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LambdaClasses extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInLambdaClasses() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/lambdaClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("parameterNamesAndNullability.kt")
            public void testParameterNamesAndNullability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/lambdaClasses/parameterNamesAndNullability.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/mapping")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Mapping extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInMapping() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/mapping"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("constructor.kt")
            public void testConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/constructor.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionProperty.kt")
            public void testExtensionProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/extensionProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("functions.kt")
            public void testFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/functions.kt");
                doTest(fileName);
            }

            @TestMetadata("mappedClassIsEqualToClassLiteral.kt")
            public void testMappedClassIsEqualToClassLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/mappedClassIsEqualToClassLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("memberProperty.kt")
            public void testMemberProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/memberProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyAccessors.kt")
            public void testPropertyAccessors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/propertyAccessors.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyAccessorsWithJvmName.kt")
            public void testPropertyAccessorsWithJvmName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/propertyAccessorsWithJvmName.kt");
                doTest(fileName);
            }

            @TestMetadata("syntheticFields.kt")
            public void testSyntheticFields() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/syntheticFields.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionOtherFile.kt")
            public void testTopLevelFunctionOtherFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/topLevelFunctionOtherFile.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelProperty.kt")
            public void testTopLevelProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/topLevelProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/box/reflection/mapping/fakeOverrides")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FakeOverrides extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInFakeOverrides() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/mapping/fakeOverrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("javaFieldGetterSetter.kt")
                public void testJavaFieldGetterSetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/fakeOverrides/javaFieldGetterSetter.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaMethod.kt")
                public void testJavaMethod() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/fakeOverrides/javaMethod.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/reflection/mapping/jvmStatic")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JvmStatic extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInJvmStatic() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/mapping/jvmStatic"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("companionObjectFunction.kt")
                public void testCompanionObjectFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/jvmStatic/companionObjectFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectFunction.kt")
                public void testObjectFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/jvmStatic/objectFunction.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/reflection/mapping/types")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Types extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/mapping/types"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("annotationConstructorParameters.kt")
                public void testAnnotationConstructorParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/annotationConstructorParameters.kt");
                    doTest(fileName);
                }

                @TestMetadata("array.kt")
                public void testArray() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/array.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructors.kt")
                public void testConstructors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/constructors.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericArrayElementType.kt")
                public void testGenericArrayElementType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/genericArrayElementType.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerGenericTypeArgument.kt")
                public void testInnerGenericTypeArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/innerGenericTypeArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberFunctions.kt")
                public void testMemberFunctions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/memberFunctions.kt");
                    doTest(fileName);
                }

                @TestMetadata("overrideAnyWithPrimitive.kt")
                public void testOverrideAnyWithPrimitive() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/overrideAnyWithPrimitive.kt");
                    doTest(fileName);
                }

                @TestMetadata("parameterizedTypeArgument.kt")
                public void testParameterizedTypeArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/parameterizedTypeArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("parameterizedTypes.kt")
                public void testParameterizedTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/parameterizedTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("propertyAccessors.kt")
                public void testPropertyAccessors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/propertyAccessors.kt");
                    doTest(fileName);
                }

                @TestMetadata("rawTypeArgument.kt")
                public void testRawTypeArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/rawTypeArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("supertypes.kt")
                public void testSupertypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/supertypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelFunctions.kt")
                public void testTopLevelFunctions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/topLevelFunctions.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeParameters.kt")
                public void testTypeParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/typeParameters.kt");
                    doTest(fileName);
                }

                @TestMetadata("unit.kt")
                public void testUnit() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/unit.kt");
                    doTest(fileName);
                }

                @TestMetadata("withNullability.kt")
                public void testWithNullability() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/mapping/types/withNullability.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/methodsFromAny")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MethodsFromAny extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInMethodsFromAny() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/methodsFromAny"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("callableReferencesEqualToCallablesFromAPI.kt")
            public void testCallableReferencesEqualToCallablesFromAPI() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/callableReferencesEqualToCallablesFromAPI.kt");
                doTest(fileName);
            }

            @TestMetadata("classToString.kt")
            public void testClassToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/classToString.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionPropertyReceiverToString.kt")
            public void testExtensionPropertyReceiverToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/extensionPropertyReceiverToString.kt");
                doTest(fileName);
            }

            @TestMetadata("functionEqualsHashCode.kt")
            public void testFunctionEqualsHashCode() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/functionEqualsHashCode.kt");
                doTest(fileName);
            }

            @TestMetadata("functionToString.kt")
            public void testFunctionToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/functionToString.kt");
                doTest(fileName);
            }

            @TestMetadata("memberExtensionToString.kt")
            public void testMemberExtensionToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/memberExtensionToString.kt");
                doTest(fileName);
            }

            @TestMetadata("parametersEqualsHashCode.kt")
            public void testParametersEqualsHashCode() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/parametersEqualsHashCode.kt");
                doTest(fileName);
            }

            @TestMetadata("parametersToString.kt")
            public void testParametersToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/parametersToString.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyEqualsHashCode.kt")
            public void testPropertyEqualsHashCode() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/propertyEqualsHashCode.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyToString.kt")
            public void testPropertyToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/propertyToString.kt");
                doTest(fileName);
            }

            @TestMetadata("typeEqualsHashCode.kt")
            public void testTypeEqualsHashCode() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/typeEqualsHashCode.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParametersEqualsHashCode.kt")
            public void testTypeParametersEqualsHashCode() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/typeParametersEqualsHashCode.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParametersToString.kt")
            public void testTypeParametersToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/typeParametersToString.kt");
                doTest(fileName);
            }

            @TestMetadata("typeToString.kt")
            public void testTypeToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/typeToString.kt");
                doTest(fileName);
            }

            @TestMetadata("typeToStringInnerGeneric.kt")
            public void testTypeToStringInnerGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/methodsFromAny/typeToStringInnerGeneric.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/modifiers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Modifiers extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInModifiers() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/modifiers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("callableModality.kt")
            public void testCallableModality() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/modifiers/callableModality.kt");
                doTest(fileName);
            }

            @TestMetadata("callableVisibility.kt")
            public void testCallableVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/modifiers/callableVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("classModality.kt")
            public void testClassModality() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/modifiers/classModality.kt");
                doTest(fileName);
            }

            @TestMetadata("classVisibility.kt")
            public void testClassVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/modifiers/classVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("classes.kt")
            public void testClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/modifiers/classes.kt");
                doTest(fileName);
            }

            @TestMetadata("functions.kt")
            public void testFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/modifiers/functions.kt");
                doTest(fileName);
            }

            @TestMetadata("javaVisibility.kt")
            public void testJavaVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/modifiers/javaVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("parameters.kt")
            public void testParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/modifiers/parameters.kt");
                doTest(fileName);
            }

            @TestMetadata("properties.kt")
            public void testProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/modifiers/properties.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParameters.kt")
            public void testTypeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/modifiers/typeParameters.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/multifileClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MultifileClasses extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInMultifileClasses() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("callFunctionsInMultifileClass.kt")
            public void testCallFunctionsInMultifileClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/multifileClasses/callFunctionsInMultifileClass.kt");
                doTest(fileName);
            }

            @TestMetadata("callPropertiesInMultifileClass.kt")
            public void testCallPropertiesInMultifileClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/multifileClasses/callPropertiesInMultifileClass.kt");
                doTest(fileName);
            }

            @TestMetadata("javaFieldForVarAndConstVal.kt")
            public void testJavaFieldForVarAndConstVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/multifileClasses/javaFieldForVarAndConstVal.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/noReflectAtRuntime")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NoReflectAtRuntime extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInNoReflectAtRuntime() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/noReflectAtRuntime"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("javaClass.kt")
            public void testJavaClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/noReflectAtRuntime/javaClass.kt");
                doTest(fileName);
            }

            @TestMetadata("primitiveJavaClass.kt")
            public void testPrimitiveJavaClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/noReflectAtRuntime/primitiveJavaClass.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyGetSetName.kt")
            public void testPropertyGetSetName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/noReflectAtRuntime/propertyGetSetName.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyInstanceof.kt")
            public void testPropertyInstanceof() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/noReflectAtRuntime/propertyInstanceof.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedTypeJavaClass.kt")
            public void testReifiedTypeJavaClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/noReflectAtRuntime/reifiedTypeJavaClass.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleClassLiterals.kt")
            public void testSimpleClassLiterals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/noReflectAtRuntime/simpleClassLiterals.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/box/reflection/noReflectAtRuntime/methodsFromAny")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MethodsFromAny extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInMethodsFromAny() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/noReflectAtRuntime/methodsFromAny"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("callableReferences.kt")
                public void testCallableReferences() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/noReflectAtRuntime/methodsFromAny/callableReferences.kt");
                    doTest(fileName);
                }

                @TestMetadata("classReference.kt")
                public void testClassReference() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/noReflectAtRuntime/methodsFromAny/classReference.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/parameters")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Parameters extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInParameters() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/parameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("findParameterByName.kt")
            public void testFindParameterByName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/parameters/findParameterByName.kt");
                doTest(fileName);
            }

            @TestMetadata("functionParameterNameAndIndex.kt")
            public void testFunctionParameterNameAndIndex() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/parameters/functionParameterNameAndIndex.kt");
                doTest(fileName);
            }

            @TestMetadata("instanceExtensionReceiverAndValueParameters.kt")
            public void testInstanceExtensionReceiverAndValueParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/parameters/instanceExtensionReceiverAndValueParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("isMarkedNullable.kt")
            public void testIsMarkedNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/parameters/isMarkedNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("isOptional.kt")
            public void testIsOptional() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/parameters/isOptional.kt");
                doTest(fileName);
            }

            @TestMetadata("javaAnnotationConstructor.kt")
            public void testJavaAnnotationConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/parameters/javaAnnotationConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("javaParametersHaveNoNames.kt")
            public void testJavaParametersHaveNoNames() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/parameters/javaParametersHaveNoNames.kt");
                doTest(fileName);
            }

            @TestMetadata("kinds.kt")
            public void testKinds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/parameters/kinds.kt");
                doTest(fileName);
            }

            @TestMetadata("propertySetter.kt")
            public void testPropertySetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/parameters/propertySetter.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/properties")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Properties extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInProperties() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/properties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("allVsDeclared.kt")
            public void testAllVsDeclared() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/allVsDeclared.kt");
                doTest(fileName);
            }

            @TestMetadata("callPrivatePropertyFromGetProperties.kt")
            public void testCallPrivatePropertyFromGetProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/callPrivatePropertyFromGetProperties.kt");
                doTest(fileName);
            }

            @TestMetadata("declaredVsInheritedProperties.kt")
            public void testDeclaredVsInheritedProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/declaredVsInheritedProperties.kt");
                doTest(fileName);
            }

            @TestMetadata("fakeOverridesInSubclass.kt")
            public void testFakeOverridesInSubclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/fakeOverridesInSubclass.kt");
                doTest(fileName);
            }

            @TestMetadata("genericClassLiteralPropertyReceiverIsStar.kt")
            public void testGenericClassLiteralPropertyReceiverIsStar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/genericClassLiteralPropertyReceiverIsStar.kt");
                doTest(fileName);
            }

            @TestMetadata("genericOverriddenProperty.kt")
            public void testGenericOverriddenProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/genericOverriddenProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("genericProperty.kt")
            public void testGenericProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/genericProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("getExtensionPropertiesMutableVsReadonly.kt")
            public void testGetExtensionPropertiesMutableVsReadonly() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/getExtensionPropertiesMutableVsReadonly.kt");
                doTest(fileName);
            }

            @TestMetadata("getPropertiesMutableVsReadonly.kt")
            public void testGetPropertiesMutableVsReadonly() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/getPropertiesMutableVsReadonly.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeKProperty.kt")
            public void testInvokeKProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/invokeKProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPropertyInheritedInKotlin.kt")
            public void testJavaPropertyInheritedInKotlin() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/javaPropertyInheritedInKotlin.kt");
                doTest(fileName);
            }

            @TestMetadata("javaStaticField.kt")
            public void testJavaStaticField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/javaStaticField.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPropertyInheritedInJava.kt")
            public void testKotlinPropertyInheritedInJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/kotlinPropertyInheritedInJava.kt");
                doTest(fileName);
            }

            @TestMetadata("memberAndMemberExtensionWithSameName.kt")
            public void testMemberAndMemberExtensionWithSameName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/memberAndMemberExtensionWithSameName.kt");
                doTest(fileName);
            }

            @TestMetadata("mutatePrivateJavaInstanceField.kt")
            public void testMutatePrivateJavaInstanceField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/mutatePrivateJavaInstanceField.kt");
                doTest(fileName);
            }

            @TestMetadata("mutatePrivateJavaStaticField.kt")
            public void testMutatePrivateJavaStaticField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/mutatePrivateJavaStaticField.kt");
                doTest(fileName);
            }

            @TestMetadata("noConflictOnKotlinGetterAndJavaField.kt")
            public void testNoConflictOnKotlinGetterAndJavaField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/noConflictOnKotlinGetterAndJavaField.kt");
                doTest(fileName);
            }

            @TestMetadata("overrideKotlinPropertyByJavaMethod.kt")
            public void testOverrideKotlinPropertyByJavaMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/overrideKotlinPropertyByJavaMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("privateClassVal.kt")
            public void testPrivateClassVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/privateClassVal.kt");
                doTest(fileName);
            }

            @TestMetadata("privateClassVar.kt")
            public void testPrivateClassVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/privateClassVar.kt");
                doTest(fileName);
            }

            @TestMetadata("privateFakeOverrideFromSuperclass.kt")
            public void testPrivateFakeOverrideFromSuperclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/privateFakeOverrideFromSuperclass.kt");
                doTest(fileName);
            }

            @TestMetadata("privateJvmStaticVarInObject.kt")
            public void testPrivateJvmStaticVarInObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/privateJvmStaticVarInObject.kt");
                doTest(fileName);
            }

            @TestMetadata("privatePropertyCallIsAccessibleOnAccessors.kt")
            public void testPrivatePropertyCallIsAccessibleOnAccessors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/privatePropertyCallIsAccessibleOnAccessors.kt");
                doTest(fileName);
            }

            @TestMetadata("privateToThisAccessors.kt")
            public void testPrivateToThisAccessors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/privateToThisAccessors.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyOfNestedClassAndArrayType.kt")
            public void testPropertyOfNestedClassAndArrayType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/propertyOfNestedClassAndArrayType.kt");
                doTest(fileName);
            }

            @TestMetadata("protectedClassVar.kt")
            public void testProtectedClassVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/protectedClassVar.kt");
                doTest(fileName);
            }

            @TestMetadata("publicClassValAccessible.kt")
            public void testPublicClassValAccessible() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/publicClassValAccessible.kt");
                doTest(fileName);
            }

            @TestMetadata("referenceToJavaFieldOfKotlinSubclass.kt")
            public void testReferenceToJavaFieldOfKotlinSubclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/referenceToJavaFieldOfKotlinSubclass.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleGetProperties.kt")
            public void testSimpleGetProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/simpleGetProperties.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/box/reflection/properties/accessors")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Accessors extends AbstractIrBlackBoxCodegenTest {
                @TestMetadata("accessorNames.kt")
                public void testAccessorNames() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/accessors/accessorNames.kt");
                    doTest(fileName);
                }

                public void testAllFilesPresentInAccessors() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/properties/accessors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("extensionPropertyAccessors.kt")
                public void testExtensionPropertyAccessors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/accessors/extensionPropertyAccessors.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberExtensions.kt")
                public void testMemberExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/accessors/memberExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberPropertyAccessors.kt")
                public void testMemberPropertyAccessors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/accessors/memberPropertyAccessors.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelPropertyAccessors.kt")
                public void testTopLevelPropertyAccessors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/properties/accessors/topLevelPropertyAccessors.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/specialBuiltIns")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SpecialBuiltIns extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInSpecialBuiltIns() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/specialBuiltIns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("getMembersOfStandardJavaClasses.kt")
            public void testGetMembersOfStandardJavaClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/specialBuiltIns/getMembersOfStandardJavaClasses.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/supertypes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Supertypes extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInSupertypes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/supertypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("builtInClassSupertypes.kt")
            public void testBuiltInClassSupertypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/supertypes/builtInClassSupertypes.kt");
                doTest(fileName);
            }

            @TestMetadata("genericSubstitution.kt")
            public void testGenericSubstitution() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/supertypes/genericSubstitution.kt");
                doTest(fileName);
            }

            @TestMetadata("isSubclassOfIsSuperclassOf.kt")
            public void testIsSubclassOfIsSuperclassOf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/supertypes/isSubclassOfIsSuperclassOf.kt");
                doTest(fileName);
            }

            @TestMetadata("primitives.kt")
            public void testPrimitives() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/supertypes/primitives.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleSupertypes.kt")
            public void testSimpleSupertypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/supertypes/simpleSupertypes.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/typeParameters")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeParameters extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInTypeParameters() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/typeParameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("declarationSiteVariance.kt")
            public void testDeclarationSiteVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/typeParameters/declarationSiteVariance.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParametersAndNames.kt")
            public void testTypeParametersAndNames() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/typeParameters/typeParametersAndNames.kt");
                doTest(fileName);
            }

            @TestMetadata("upperBounds.kt")
            public void testUpperBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/typeParameters/upperBounds.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/reflection/types")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Types extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInTypes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/types"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("classifierIsClass.kt")
            public void testClassifierIsClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/classifierIsClass.kt");
                doTest(fileName);
            }

            @TestMetadata("classifierIsTypeParameter.kt")
            public void testClassifierIsTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/classifierIsTypeParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("classifiersOfBuiltInTypes.kt")
            public void testClassifiersOfBuiltInTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/classifiersOfBuiltInTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("innerGenericArguments.kt")
            public void testInnerGenericArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/innerGenericArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmErasureOfClass.kt")
            public void testJvmErasureOfClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/jvmErasureOfClass.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmErasureOfTypeParameter.kt")
            public void testJvmErasureOfTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/jvmErasureOfTypeParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("platformTypeClassifier.kt")
            public void testPlatformTypeClassifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/platformTypeClassifier.kt");
                doTest(fileName);
            }

            @TestMetadata("platformTypeNotEqualToKotlinType.kt")
            public void testPlatformTypeNotEqualToKotlinType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/platformTypeNotEqualToKotlinType.kt");
                doTest(fileName);
            }

            @TestMetadata("platformTypeToString.kt")
            public void testPlatformTypeToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/platformTypeToString.kt");
                doTest(fileName);
            }

            @TestMetadata("typeArguments.kt")
            public void testTypeArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/typeArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("useSiteVariance.kt")
            public void testUseSiteVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/useSiteVariance.kt");
                doTest(fileName);
            }

            @TestMetadata("withNullability.kt")
            public void testWithNullability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/withNullability.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/box/reflection/types/createType")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CreateType extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInCreateType() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/types/createType"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("equality.kt")
                public void testEquality() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/createType/equality.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerGeneric.kt")
                public void testInnerGeneric() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/createType/innerGeneric.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleCreateType.kt")
                public void testSimpleCreateType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/createType/simpleCreateType.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeParameter.kt")
                public void testTypeParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/createType/typeParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("wrongNumberOfArguments.kt")
                public void testWrongNumberOfArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/createType/wrongNumberOfArguments.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/codegen/box/reflection/types/subtyping")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Subtyping extends AbstractIrBlackBoxCodegenTest {
                public void testAllFilesPresentInSubtyping() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reflection/types/subtyping"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
                }

                @TestMetadata("platformType.kt")
                public void testPlatformType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/subtyping/platformType.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleGenericTypes.kt")
                public void testSimpleGenericTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/subtyping/simpleGenericTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleSubtypeSupertype.kt")
                public void testSimpleSubtypeSupertype() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/subtyping/simpleSubtypeSupertype.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeProjection.kt")
                public void testTypeProjection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reflection/types/subtyping/typeProjection.kt");
                    doTest(fileName);
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/regressions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Regressions extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInRegressions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/regressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("arrayLengthNPE.kt")
        public void testArrayLengthNPE() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/arrayLengthNPE.kt");
            doTest(fileName);
        }

        @TestMetadata("collections.kt")
        public void testCollections() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/collections.kt");
            doTest(fileName);
        }

        @TestMetadata("commonSupertypeContravariant.kt")
        public void testCommonSupertypeContravariant() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/commonSupertypeContravariant.kt");
            doTest(fileName);
        }

        @TestMetadata("commonSupertypeContravariant2.kt")
        public void testCommonSupertypeContravariant2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/commonSupertypeContravariant2.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleMerge.kt")
        public void testDoubleMerge() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/doubleMerge.kt");
            doTest(fileName);
        }

        @TestMetadata("floatMerge.kt")
        public void testFloatMerge() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/floatMerge.kt");
            doTest(fileName);
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/generic.kt");
            doTest(fileName);
        }

        @TestMetadata("getGenericInterfaces.kt")
        public void testGetGenericInterfaces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/getGenericInterfaces.kt");
            doTest(fileName);
        }

        @TestMetadata("hashCodeNPE.kt")
        public void testHashCodeNPE() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/hashCodeNPE.kt");
            doTest(fileName);
        }

        @TestMetadata("internalTopLevelOtherPackage.kt")
        public void testInternalTopLevelOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/internalTopLevelOtherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10143.kt")
        public void testKt10143() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt10143.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10934.kt")
        public void testKt10934() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt10934.kt");
            doTest(fileName);
        }

        @TestMetadata("Kt1149.kt")
        public void testKt1149() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/Kt1149.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1172.kt")
        public void testKt1172() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt1172.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1202.kt")
        public void testKt1202() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt1202.kt");
            doTest(fileName);
        }

        @TestMetadata("kt13381.kt")
        public void testKt13381() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt13381.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1406.kt")
        public void testKt1406() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt1406.kt");
            doTest(fileName);
        }

        @TestMetadata("kt14447.kt")
        public void testKt14447() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt14447.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1515.kt")
        public void testKt1515() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt1515.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1528.kt")
        public void testKt1528() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt1528.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1568.kt")
        public void testKt1568() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt1568.kt");
            doTest(fileName);
        }

        @TestMetadata("Kt1619Test.kt")
        public void testKt1619Test() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/Kt1619Test.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1779.kt")
        public void testKt1779() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt1779.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1800.kt")
        public void testKt1800() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt1800.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1845.kt")
        public void testKt1845() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt1845.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1932.kt")
        public void testKt1932() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt1932.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2017.kt")
        public void testKt2017() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt2017.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2060.kt")
        public void testKt2060() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt2060.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2210.kt")
        public void testKt2210() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt2210.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2246.kt")
        public void testKt2246() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt2246.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2318.kt")
        public void testKt2318() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt2318.kt");
            doTest(fileName);
        }

        @TestMetadata("Kt2495Test.kt")
        public void testKt2495Test() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/Kt2495Test.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2509.kt")
        public void testKt2509() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt2509.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2593.kt")
        public void testKt2593() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt2593.kt");
            doTest(fileName);
        }

        @TestMetadata("kt274.kt")
        public void testKt274() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt274.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3046.kt")
        public void testKt3046() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt3046.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3107.kt")
        public void testKt3107() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt3107.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3421.kt")
        public void testKt3421() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt3421.kt");
            doTest(fileName);
        }

        @TestMetadata("kt344.kt")
        public void testKt344() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt344.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3442.kt")
        public void testKt3442() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt3442.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3587.kt")
        public void testKt3587() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt3587.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3850.kt")
        public void testKt3850() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt3850.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3903.kt")
        public void testKt3903() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt3903.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4142.kt")
        public void testKt4142() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt4142.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4259.kt")
        public void testKt4259() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt4259.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4262.kt")
        public void testKt4262() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt4262.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4281.kt")
        public void testKt4281() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt4281.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5056.kt")
        public void testKt5056() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt5056.kt");
            doTest(fileName);
        }

        @TestMetadata("kt528.kt")
        public void testKt528() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt528.kt");
            doTest(fileName);
        }

        @TestMetadata("kt529.kt")
        public void testKt529() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt529.kt");
            doTest(fileName);
        }

        @TestMetadata("kt533.kt")
        public void testKt533() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt533.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5395.kt")
        public void testKt5395() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt5395.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5445.kt")
        public void testKt5445() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt5445.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5445_2.kt")
        public void testKt5445_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt5445_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5786_privateWithDefault.kt")
        public void testKt5786_privateWithDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt5786_privateWithDefault.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5953.kt")
        public void testKt5953() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt5953.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6153.kt")
        public void testKt6153() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt6153.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6434.kt")
        public void testKt6434() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt6434.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6434_2.kt")
        public void testKt6434_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt6434_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6485.kt")
        public void testKt6485() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt6485.kt");
            doTest(fileName);
        }

        @TestMetadata("kt715.kt")
        public void testKt715() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt715.kt");
            doTest(fileName);
        }

        @TestMetadata("kt7401.kt")
        public void testKt7401() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt7401.kt");
            doTest(fileName);
        }

        @TestMetadata("kt789.kt")
        public void testKt789() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt789.kt");
            doTest(fileName);
        }

        @TestMetadata("kt864.kt")
        public void testKt864() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt864.kt");
            doTest(fileName);
        }

        @TestMetadata("kt998.kt")
        public void testKt998() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/kt998.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedIntersection.kt")
        public void testNestedIntersection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/nestedIntersection.kt");
            doTest(fileName);
        }

        @TestMetadata("objectCaptureOuterConstructorProperty.kt")
        public void testObjectCaptureOuterConstructorProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/objectCaptureOuterConstructorProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("referenceToSelfInLocal.kt")
        public void testReferenceToSelfInLocal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/referenceToSelfInLocal.kt");
            doTest(fileName);
        }

        @TestMetadata("typeCastException.kt")
        public void testTypeCastException() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/regressions/typeCastException.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/reified")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Reified extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInReified() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reified"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("anonymousObject.kt")
        public void testAnonymousObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/anonymousObject.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectNoPropagate.kt")
        public void testAnonymousObjectNoPropagate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/anonymousObjectNoPropagate.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectReifiedSupertype.kt")
        public void testAnonymousObjectReifiedSupertype() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/anonymousObjectReifiedSupertype.kt");
            doTest(fileName);
        }

        @TestMetadata("approximateCapturedTypes.kt")
        public void testApproximateCapturedTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/approximateCapturedTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("asOnPlatformType.kt")
        public void testAsOnPlatformType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/asOnPlatformType.kt");
            doTest(fileName);
        }

        @TestMetadata("checkcast.kt")
        public void testCheckcast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/checkcast.kt");
            doTest(fileName);
        }

        @TestMetadata("copyToArray.kt")
        public void testCopyToArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/copyToArray.kt");
            doTest(fileName);
        }

        @TestMetadata("DIExample.kt")
        public void testDIExample() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/DIExample.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultJavaClass.kt")
        public void testDefaultJavaClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/defaultJavaClass.kt");
            doTest(fileName);
        }

        @TestMetadata("filterIsInstance.kt")
        public void testFilterIsInstance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/filterIsInstance.kt");
            doTest(fileName);
        }

        @TestMetadata("innerAnonymousObject.kt")
        public void testInnerAnonymousObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/innerAnonymousObject.kt");
            doTest(fileName);
        }

        @TestMetadata("instanceof.kt")
        public void testInstanceof() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/instanceof.kt");
            doTest(fileName);
        }

        @TestMetadata("isOnPlatformType.kt")
        public void testIsOnPlatformType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/isOnPlatformType.kt");
            doTest(fileName);
        }

        @TestMetadata("javaClass.kt")
        public void testJavaClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/javaClass.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedReified.kt")
        public void testNestedReified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/nestedReified.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedReifiedSignature.kt")
        public void testNestedReifiedSignature() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/nestedReifiedSignature.kt");
            doTest(fileName);
        }

        @TestMetadata("newArrayInt.kt")
        public void testNewArrayInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/newArrayInt.kt");
            doTest(fileName);
        }

        @TestMetadata("nonInlineableLambdaInReifiedFunction.kt")
        public void testNonInlineableLambdaInReifiedFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/nonInlineableLambdaInReifiedFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveInnerAnonymousObject.kt")
        public void testRecursiveInnerAnonymousObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/recursiveInnerAnonymousObject.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveNewArray.kt")
        public void testRecursiveNewArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/recursiveNewArray.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveNonInlineableLambda.kt")
        public void testRecursiveNonInlineableLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/recursiveNonInlineableLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("reifiedChain.kt")
        public void testReifiedChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/reifiedChain.kt");
            doTest(fileName);
        }

        @TestMetadata("reifiedInlineFunOfObject.kt")
        public void testReifiedInlineFunOfObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/reifiedInlineFunOfObject.kt");
            doTest(fileName);
        }

        @TestMetadata("reifiedInlineFunOfObjectWithinReified.kt")
        public void testReifiedInlineFunOfObjectWithinReified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/reifiedInlineFunOfObjectWithinReified.kt");
            doTest(fileName);
        }

        @TestMetadata("reifiedInlineIntoNonInlineableLambda.kt")
        public void testReifiedInlineIntoNonInlineableLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/reifiedInlineIntoNonInlineableLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("safecast.kt")
        public void testSafecast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/safecast.kt");
            doTest(fileName);
        }

        @TestMetadata("sameIndexRecursive.kt")
        public void testSameIndexRecursive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/sameIndexRecursive.kt");
            doTest(fileName);
        }

        @TestMetadata("spreads.kt")
        public void testSpreads() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/spreads.kt");
            doTest(fileName);
        }

        @TestMetadata("varargs.kt")
        public void testVarargs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/varargs.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/reified/arraysReification")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ArraysReification extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInArraysReification() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/reified/arraysReification"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("instanceOf.kt")
            public void testInstanceOf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/arraysReification/instanceOf.kt");
                doTest(fileName);
            }

            @TestMetadata("instanceOfArrays.kt")
            public void testInstanceOfArrays() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/arraysReification/instanceOfArrays.kt");
                doTest(fileName);
            }

            @TestMetadata("jClass.kt")
            public void testJClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/arraysReification/jClass.kt");
                doTest(fileName);
            }

            @TestMetadata("jaggedArray.kt")
            public void testJaggedArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/arraysReification/jaggedArray.kt");
                doTest(fileName);
            }

            @TestMetadata("jaggedArrayOfNulls.kt")
            public void testJaggedArrayOfNulls() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/arraysReification/jaggedArrayOfNulls.kt");
                doTest(fileName);
            }

            @TestMetadata("jaggedDeep.kt")
            public void testJaggedDeep() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/reified/arraysReification/jaggedDeep.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/safeCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SafeCall extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInSafeCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/safeCall"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/safeCall/genericNull.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1572.kt")
        public void testKt1572() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/safeCall/kt1572.kt");
            doTest(fileName);
        }

        @TestMetadata("kt232.kt")
        public void testKt232() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/safeCall/kt232.kt");
            doTest(fileName);
        }

        @TestMetadata("kt245.kt")
        public void testKt245() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/safeCall/kt245.kt");
            doTest(fileName);
        }

        @TestMetadata("kt247.kt")
        public void testKt247() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/safeCall/kt247.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3430.kt")
        public void testKt3430() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/safeCall/kt3430.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4733.kt")
        public void testKt4733() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/safeCall/kt4733.kt");
            doTest(fileName);
        }

        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/safeCall/primitive.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCallOnLong.kt")
        public void testSafeCallOnLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/safeCall/safeCallOnLong.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/sam")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Sam extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInSam() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/sam"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("compiler/testData/codegen/box/sam/constructors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructors extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInConstructors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/sam/constructors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("comparator.kt")
            public void testComparator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/comparator.kt");
                doTest(fileName);
            }

            @TestMetadata("filenameFilter.kt")
            public void testFilenameFilter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/filenameFilter.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLiteralComparator.kt")
            public void testNonLiteralComparator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/nonLiteralComparator.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLiteralFilenameFilter.kt")
            public void testNonLiteralFilenameFilter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/nonLiteralFilenameFilter.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLiteralRunnable.kt")
            public void testNonLiteralRunnable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/nonLiteralRunnable.kt");
                doTest(fileName);
            }

            @TestMetadata("nonTrivialRunnable.kt")
            public void testNonTrivialRunnable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/nonTrivialRunnable.kt");
                doTest(fileName);
            }

            @TestMetadata("runnable.kt")
            public void testRunnable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/runnable.kt");
                doTest(fileName);
            }

            @TestMetadata("runnableAccessingClosure1.kt")
            public void testRunnableAccessingClosure1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/runnableAccessingClosure1.kt");
                doTest(fileName);
            }

            @TestMetadata("runnableAccessingClosure2.kt")
            public void testRunnableAccessingClosure2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/runnableAccessingClosure2.kt");
                doTest(fileName);
            }

            @TestMetadata("samWrappersDifferentFiles.kt")
            public void testSamWrappersDifferentFiles() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/samWrappersDifferentFiles.kt");
                doTest(fileName);
            }

            @TestMetadata("sameWrapperClass.kt")
            public void testSameWrapperClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/sameWrapperClass.kt");
                doTest(fileName);
            }

            @TestMetadata("syntheticVsReal.kt")
            public void testSyntheticVsReal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sam/constructors/syntheticVsReal.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/box/sealed")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Sealed extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInSealed() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/sealed"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("objects.kt")
        public void testObjects() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sealed/objects.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/sealed/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/secondaryConstructors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SecondaryConstructors extends AbstractIrBlackBoxCodegenTest {
        @TestMetadata("accessToCompanion.kt")
        public void testAccessToCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/accessToCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("accessToNestedObject.kt")
        public void testAccessToNestedObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/accessToNestedObject.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInSecondaryConstructors() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/secondaryConstructors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("basicNoPrimaryManySinks.kt")
        public void testBasicNoPrimaryManySinks() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/basicNoPrimaryManySinks.kt");
            doTest(fileName);
        }

        @TestMetadata("basicNoPrimaryOneSink.kt")
        public void testBasicNoPrimaryOneSink() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/basicNoPrimaryOneSink.kt");
            doTest(fileName);
        }

        @TestMetadata("basicPrimary.kt")
        public void testBasicPrimary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/basicPrimary.kt");
            doTest(fileName);
        }

        @TestMetadata("callFromLocalSubClass.kt")
        public void testCallFromLocalSubClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/callFromLocalSubClass.kt");
            doTest(fileName);
        }

        @TestMetadata("callFromPrimaryWithNamedArgs.kt")
        public void testCallFromPrimaryWithNamedArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/callFromPrimaryWithNamedArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("callFromPrimaryWithOptionalArgs.kt")
        public void testCallFromPrimaryWithOptionalArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/callFromPrimaryWithOptionalArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("callFromSubClass.kt")
        public void testCallFromSubClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/callFromSubClass.kt");
            doTest(fileName);
        }

        @TestMetadata("clashingDefaultConstructors.kt")
        public void testClashingDefaultConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/clashingDefaultConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("dataClasses.kt")
        public void testDataClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/dataClasses.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultArgs.kt")
        public void testDefaultArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/defaultArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultParametersNotDuplicated.kt")
        public void testDefaultParametersNotDuplicated() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/defaultParametersNotDuplicated.kt");
            doTest(fileName);
        }

        @TestMetadata("delegatedThisWithLambda.kt")
        public void testDelegatedThisWithLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/delegatedThisWithLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationWithPrimary.kt")
        public void testDelegationWithPrimary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/delegationWithPrimary.kt");
            doTest(fileName);
        }

        @TestMetadata("enums.kt")
        public void testEnums() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/enums.kt");
            doTest(fileName);
        }

        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/generics.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClasses.kt")
        public void testInnerClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/innerClasses.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClassesInheritance.kt")
        public void testInnerClassesInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/innerClassesInheritance.kt");
            doTest(fileName);
        }

        @TestMetadata("localClasses.kt")
        public void testLocalClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/localClasses.kt");
            doTest(fileName);
        }

        @TestMetadata("superCallPrimary.kt")
        public void testSuperCallPrimary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/superCallPrimary.kt");
            doTest(fileName);
        }

        @TestMetadata("superCallSecondary.kt")
        public void testSuperCallSecondary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/superCallSecondary.kt");
            doTest(fileName);
        }

        @TestMetadata("varargs.kt")
        public void testVarargs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/varargs.kt");
            doTest(fileName);
        }

        @TestMetadata("withGenerics.kt")
        public void testWithGenerics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/withGenerics.kt");
            doTest(fileName);
        }

        @TestMetadata("withNonLocalReturn.kt")
        public void testWithNonLocalReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/withNonLocalReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("withPrimary.kt")
        public void testWithPrimary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/withPrimary.kt");
            doTest(fileName);
        }

        @TestMetadata("withReturn.kt")
        public void testWithReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/withReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("withReturnUnit.kt")
        public void testWithReturnUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/withReturnUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("withVarargs.kt")
        public void testWithVarargs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/withVarargs.kt");
            doTest(fileName);
        }

        @TestMetadata("withoutPrimary.kt")
        public void testWithoutPrimary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/secondaryConstructors/withoutPrimary.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/smap")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Smap extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInSmap() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/smap"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("chainCalls.kt")
        public void testChainCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smap/chainCalls.kt");
            doTest(fileName);
        }

        @TestMetadata("infixCalls.kt")
        public void testInfixCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smap/infixCalls.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleCallWithParams.kt")
        public void testSimpleCallWithParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smap/simpleCallWithParams.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/smartCasts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SmartCasts extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInSmartCasts() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/smartCasts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("falseSmartCast.kt")
        public void testFalseSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/falseSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("genericIntersection.kt")
        public void testGenericIntersection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/genericIntersection.kt");
            doTest(fileName);
        }

        @TestMetadata("genericSet.kt")
        public void testGenericSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/genericSet.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitExtensionReceiver.kt")
        public void testImplicitExtensionReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/implicitExtensionReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitMemberReceiver.kt")
        public void testImplicitMemberReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/implicitMemberReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitReceiver.kt")
        public void testImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/implicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitReceiverInWhen.kt")
        public void testImplicitReceiverInWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/implicitReceiverInWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitToGrandSon.kt")
        public void testImplicitToGrandSon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/implicitToGrandSon.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaArgumentWithoutType.kt")
        public void testLambdaArgumentWithoutType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/lambdaArgumentWithoutType.kt");
            doTest(fileName);
        }

        @TestMetadata("nullSmartCast.kt")
        public void testNullSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/nullSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("smartCastInsideIf.kt")
        public void testSmartCastInsideIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/smartCastInsideIf.kt");
            doTest(fileName);
        }

        @TestMetadata("whenSmartCast.kt")
        public void testWhenSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/smartCasts/whenSmartCast.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/specialBuiltins")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SpecialBuiltins extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInSpecialBuiltins() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/specialBuiltins"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("bridgeNotEmptyMap.kt")
        public void testBridgeNotEmptyMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/bridgeNotEmptyMap.kt");
            doTest(fileName);
        }

        @TestMetadata("bridges.kt")
        public void testBridges() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/bridges.kt");
            doTest(fileName);
        }

        @TestMetadata("collectionImpl.kt")
        public void testCollectionImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/collectionImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("commonBridgesTarget.kt")
        public void testCommonBridgesTarget() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/commonBridgesTarget.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyList.kt")
        public void testEmptyList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/emptyList.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyMap.kt")
        public void testEmptyMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/emptyMap.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyStringMap.kt")
        public void testEmptyStringMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/emptyStringMap.kt");
            doTest(fileName);
        }

        @TestMetadata("entrySetSOE.kt")
        public void testEntrySetSOE() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/entrySetSOE.kt");
            doTest(fileName);
        }

        @TestMetadata("enumAsOrdinaled.kt")
        public void testEnumAsOrdinaled() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/enumAsOrdinaled.kt");
            doTest(fileName);
        }

        @TestMetadata("explicitSuperCall.kt")
        public void testExplicitSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/explicitSuperCall.kt");
            doTest(fileName);
        }

        @TestMetadata("irrelevantRemoveAtOverride.kt")
        public void testIrrelevantRemoveAtOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/irrelevantRemoveAtOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("maps.kt")
        public void testMaps() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/maps.kt");
            doTest(fileName);
        }

        @TestMetadata("noSpecialBridgeInSuperClass.kt")
        public void testNoSpecialBridgeInSuperClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/noSpecialBridgeInSuperClass.kt");
            doTest(fileName);
        }

        @TestMetadata("notEmptyListAny.kt")
        public void testNotEmptyListAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/notEmptyListAny.kt");
            doTest(fileName);
        }

        @TestMetadata("notEmptyMap.kt")
        public void testNotEmptyMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/notEmptyMap.kt");
            doTest(fileName);
        }

        @TestMetadata("redundantStubForSize.kt")
        public void testRedundantStubForSize() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/redundantStubForSize.kt");
            doTest(fileName);
        }

        @TestMetadata("removeAtTwoSpecialBridges.kt")
        public void testRemoveAtTwoSpecialBridges() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/removeAtTwoSpecialBridges.kt");
            doTest(fileName);
        }

        @TestMetadata("throwable.kt")
        public void testThrowable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/throwable.kt");
            doTest(fileName);
        }

        @TestMetadata("throwableImpl.kt")
        public void testThrowableImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/throwableImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("valuesInsideEnum.kt")
        public void testValuesInsideEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/specialBuiltins/valuesInsideEnum.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/statics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Statics extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInStatics() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/statics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("anonymousInitializerIObject.kt")
        public void testAnonymousInitializerIObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/anonymousInitializerIObject.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousInitializerInClassObject.kt")
        public void testAnonymousInitializerInClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/anonymousInitializerInClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("fields.kt")
        public void testFields() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/fields.kt");
            doTest(fileName);
        }

        @TestMetadata("functions.kt")
        public void testFunctions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/functions.kt");
            doTest(fileName);
        }

        @TestMetadata("hidePrivateByPublic.kt")
        public void testHidePrivateByPublic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/hidePrivateByPublic.kt");
            doTest(fileName);
        }

        @TestMetadata("incInClassObject.kt")
        public void testIncInClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/incInClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("incInObject.kt")
        public void testIncInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/incInObject.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritedPropertyInClassObject.kt")
        public void testInheritedPropertyInClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/inheritedPropertyInClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritedPropertyInObject.kt")
        public void testInheritedPropertyInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/inheritedPropertyInObject.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineCallsStaticMethod.kt")
        public void testInlineCallsStaticMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/inlineCallsStaticMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8089.kt")
        public void testKt8089() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/kt8089.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedSamConstructor.kt")
        public void testProtectedSamConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/protectedSamConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedStatic.kt")
        public void testProtectedStatic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/protectedStatic.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedStatic2.kt")
        public void testProtectedStatic2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/protectedStatic2.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedStaticAndInline.kt")
        public void testProtectedStaticAndInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/protectedStaticAndInline.kt");
            doTest(fileName);
        }

        @TestMetadata("syntheticAccessor.kt")
        public void testSyntheticAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/statics/syntheticAccessor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/storeStackBeforeInline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StoreStackBeforeInline extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInStoreStackBeforeInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/storeStackBeforeInline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("differentTypes.kt")
        public void testDifferentTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/storeStackBeforeInline/differentTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveMerge.kt")
        public void testPrimitiveMerge() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/storeStackBeforeInline/primitiveMerge.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/storeStackBeforeInline/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("unreachableMarker.kt")
        public void testUnreachableMarker() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/storeStackBeforeInline/unreachableMarker.kt");
            doTest(fileName);
        }

        @TestMetadata("withLambda.kt")
        public void testWithLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/storeStackBeforeInline/withLambda.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/strings")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Strings extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInStrings() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/strings"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("ea35743.kt")
        public void testEa35743() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/ea35743.kt");
            doTest(fileName);
        }

        @TestMetadata("forInString.kt")
        public void testForInString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/forInString.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolation.kt")
        public void testInterpolation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/interpolation.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2592.kt")
        public void testKt2592() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/kt2592.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3571.kt")
        public void testKt3571() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/kt3571.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3652.kt")
        public void testKt3652() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/kt3652.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5389_stringBuilderGet.kt")
        public void testKt5389_stringBuilderGet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/kt5389_stringBuilderGet.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5956.kt")
        public void testKt5956() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/kt5956.kt");
            doTest(fileName);
        }

        @TestMetadata("kt881.kt")
        public void testKt881() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/kt881.kt");
            doTest(fileName);
        }

        @TestMetadata("kt889.kt")
        public void testKt889() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/kt889.kt");
            doTest(fileName);
        }

        @TestMetadata("kt894.kt")
        public void testKt894() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/kt894.kt");
            doTest(fileName);
        }

        @TestMetadata("multilineStringsWithTemplates.kt")
        public void testMultilineStringsWithTemplates() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/multilineStringsWithTemplates.kt");
            doTest(fileName);
        }

        @TestMetadata("rawStrings.kt")
        public void testRawStrings() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/rawStrings.kt");
            doTest(fileName);
        }

        @TestMetadata("rawStringsWithManyQuotes.kt")
        public void testRawStringsWithManyQuotes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/rawStringsWithManyQuotes.kt");
            doTest(fileName);
        }

        @TestMetadata("stringBuilderAppend.kt")
        public void testStringBuilderAppend() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/stringBuilderAppend.kt");
            doTest(fileName);
        }

        @TestMetadata("stringPlusOnlyWorksOnString.kt")
        public void testStringPlusOnlyWorksOnString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/strings/stringPlusOnlyWorksOnString.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/super")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Super extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInSuper() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/super"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("basicmethodSuperClass.kt")
        public void testBasicmethodSuperClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/basicmethodSuperClass.kt");
            doTest(fileName);
        }

        @TestMetadata("basicmethodSuperTrait.kt")
        public void testBasicmethodSuperTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/basicmethodSuperTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("basicproperty.kt")
        public void testBasicproperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/basicproperty.kt");
            doTest(fileName);
        }

        @TestMetadata("enclosedFun.kt")
        public void testEnclosedFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/enclosedFun.kt");
            doTest(fileName);
        }

        @TestMetadata("enclosedVar.kt")
        public void testEnclosedVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/enclosedVar.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClassLabeledSuper.kt")
        public void testInnerClassLabeledSuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/innerClassLabeledSuper.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClassLabeledSuper2.kt")
        public void testInnerClassLabeledSuper2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/innerClassLabeledSuper2.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClassLabeledSuperProperty.kt")
        public void testInnerClassLabeledSuperProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/innerClassLabeledSuperProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClassLabeledSuperProperty2.kt")
        public void testInnerClassLabeledSuperProperty2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/innerClassLabeledSuperProperty2.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClassQualifiedFunctionCall.kt")
        public void testInnerClassQualifiedFunctionCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/innerClassQualifiedFunctionCall.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClassQualifiedPropertyAccess.kt")
        public void testInnerClassQualifiedPropertyAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/innerClassQualifiedPropertyAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("kt14243.kt")
        public void testKt14243() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt14243.kt");
            doTest(fileName);
        }

        @TestMetadata("kt14243_2.kt")
        public void testKt14243_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt14243_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt14243_class.kt")
        public void testKt14243_class() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt14243_class.kt");
            doTest(fileName);
        }

        @TestMetadata("kt14243_prop.kt")
        public void testKt14243_prop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt14243_prop.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3492ClassFun.kt")
        public void testKt3492ClassFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt3492ClassFun.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3492ClassProperty.kt")
        public void testKt3492ClassProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt3492ClassProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3492TraitFun.kt")
        public void testKt3492TraitFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt3492TraitFun.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3492TraitProperty.kt")
        public void testKt3492TraitProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt3492TraitProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4173.kt")
        public void testKt4173() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt4173.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4173_2.kt")
        public void testKt4173_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt4173_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4173_3.kt")
        public void testKt4173_3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt4173_3.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4982.kt")
        public void testKt4982() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/kt4982.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleSuperTraits.kt")
        public void testMultipleSuperTraits() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/multipleSuperTraits.kt");
            doTest(fileName);
        }

        @TestMetadata("traitproperty.kt")
        public void testTraitproperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/traitproperty.kt");
            doTest(fileName);
        }

        @TestMetadata("unqualifiedSuper.kt")
        public void testUnqualifiedSuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/unqualifiedSuper.kt");
            doTest(fileName);
        }

        @TestMetadata("unqualifiedSuperWithDeeperHierarchies.kt")
        public void testUnqualifiedSuperWithDeeperHierarchies() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/unqualifiedSuperWithDeeperHierarchies.kt");
            doTest(fileName);
        }

        @TestMetadata("unqualifiedSuperWithMethodsOfAny.kt")
        public void testUnqualifiedSuperWithMethodsOfAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/super/unqualifiedSuperWithMethodsOfAny.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/synchronized")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Synchronized extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInSynchronized() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/synchronized"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("changeMonitor.kt")
        public void testChangeMonitor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/changeMonitor.kt");
            doTest(fileName);
        }

        @TestMetadata("exceptionInMonitorExpression.kt")
        public void testExceptionInMonitorExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/exceptionInMonitorExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("finally.kt")
        public void testFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/finally.kt");
            doTest(fileName);
        }

        @TestMetadata("longValue.kt")
        public void testLongValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/longValue.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedDifferentObjects.kt")
        public void testNestedDifferentObjects() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/nestedDifferentObjects.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedSameObject.kt")
        public void testNestedSameObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/nestedSameObject.kt");
            doTest(fileName);
        }

        @TestMetadata("nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/nonLocalReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("objectValue.kt")
        public void testObjectValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/objectValue.kt");
            doTest(fileName);
        }

        @TestMetadata("sync.kt")
        public void testSync() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/sync.kt");
            doTest(fileName);
        }

        @TestMetadata("value.kt")
        public void testValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/value.kt");
            doTest(fileName);
        }

        @TestMetadata("wait.kt")
        public void testWait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/synchronized/wait.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/syntheticAccessors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SyntheticAccessors extends AbstractIrBlackBoxCodegenTest {
        @TestMetadata("accessorForProtected.kt")
        public void testAccessorForProtected() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/syntheticAccessors/accessorForProtected.kt");
            doTest(fileName);
        }

        @TestMetadata("accessorForProtectedInvokeVirtual.kt")
        public void testAccessorForProtectedInvokeVirtual() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/syntheticAccessors/accessorForProtectedInvokeVirtual.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInSyntheticAccessors() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/syntheticAccessors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("kt10047.kt")
        public void testKt10047() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/syntheticAccessors/kt10047.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9717.kt")
        public void testKt9717() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/syntheticAccessors/kt9717.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9717DifferentPackages.kt")
        public void testKt9717DifferentPackages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/syntheticAccessors/kt9717DifferentPackages.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9958.kt")
        public void testKt9958() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/syntheticAccessors/kt9958.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9958Interface.kt")
        public void testKt9958Interface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/syntheticAccessors/kt9958Interface.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedFromLambda.kt")
        public void testProtectedFromLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/syntheticAccessors/protectedFromLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("syntheticAccessorNames.kt")
        public void testSyntheticAccessorNames() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/syntheticAccessors/syntheticAccessorNames.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/toArray")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToArray extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInToArray() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/toArray"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("kt3177-toTypedArray.kt")
        public void testKt3177_toTypedArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/toArray/kt3177-toTypedArray.kt");
            doTest(fileName);
        }

        @TestMetadata("returnToTypedArray.kt")
        public void testReturnToTypedArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/toArray/returnToTypedArray.kt");
            doTest(fileName);
        }

        @TestMetadata("toArray.kt")
        public void testToArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/toArray/toArray.kt");
            doTest(fileName);
        }

        @TestMetadata("toArrayAlreadyPresent.kt")
        public void testToArrayAlreadyPresent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/toArray/toArrayAlreadyPresent.kt");
            doTest(fileName);
        }

        @TestMetadata("toTypedArray.kt")
        public void testToTypedArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/toArray/toTypedArray.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/topLevelPrivate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TopLevelPrivate extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInTopLevelPrivate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/topLevelPrivate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("noPrivateNoAccessorsInMultiFileFacade.kt")
        public void testNoPrivateNoAccessorsInMultiFileFacade() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/topLevelPrivate/noPrivateNoAccessorsInMultiFileFacade.kt");
            doTest(fileName);
        }

        @TestMetadata("noPrivateNoAccessorsInMultiFileFacade2.kt")
        public void testNoPrivateNoAccessorsInMultiFileFacade2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/topLevelPrivate/noPrivateNoAccessorsInMultiFileFacade2.kt");
            doTest(fileName);
        }

        @TestMetadata("privateInInlineNested.kt")
        public void testPrivateInInlineNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/topLevelPrivate/privateInInlineNested.kt");
            doTest(fileName);
        }

        @TestMetadata("privateVisibility.kt")
        public void testPrivateVisibility() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/topLevelPrivate/privateVisibility.kt");
            doTest(fileName);
        }

        @TestMetadata("syntheticAccessor.kt")
        public void testSyntheticAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/topLevelPrivate/syntheticAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("syntheticAccessorInMultiFile.kt")
        public void testSyntheticAccessorInMultiFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/topLevelPrivate/syntheticAccessorInMultiFile.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/traits")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Traits extends AbstractIrBlackBoxCodegenTest {
        @TestMetadata("abstractClassInheritsFromInterface.kt")
        public void testAbstractClassInheritsFromInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/abstractClassInheritsFromInterface.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInTraits() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/traits"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("diamondPropertyAccessors.kt")
        public void testDiamondPropertyAccessors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/diamondPropertyAccessors.kt");
            doTest(fileName);
        }

        @TestMetadata("genericMethod.kt")
        public void testGenericMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/genericMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("indirectlyInheritPropertyGetter.kt")
        public void testIndirectlyInheritPropertyGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/indirectlyInheritPropertyGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritJavaInterface.kt")
        public void testInheritJavaInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/inheritJavaInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritedFun.kt")
        public void testInheritedFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/inheritedFun.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritedVar.kt")
        public void testInheritedVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/inheritedVar.kt");
            doTest(fileName);
        }

        @TestMetadata("interfaceDefaultImpls.kt")
        public void testInterfaceDefaultImpls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/interfaceDefaultImpls.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1936.kt")
        public void testKt1936() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt1936.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1936_1.kt")
        public void testKt1936_1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt1936_1.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2260.kt")
        public void testKt2260() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt2260.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2399.kt")
        public void testKt2399() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt2399.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2541.kt")
        public void testKt2541() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt2541.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3315.kt")
        public void testKt3315() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt3315.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3500.kt")
        public void testKt3500() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt3500.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3579.kt")
        public void testKt3579() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt3579.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3579_2.kt")
        public void testKt3579_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt3579_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5393.kt")
        public void testKt5393() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt5393.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5393_property.kt")
        public void testKt5393_property() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/kt5393_property.kt");
            doTest(fileName);
        }

        @TestMetadata("multiple.kt")
        public void testMultiple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/multiple.kt");
            doTest(fileName);
        }

        @TestMetadata("noPrivateDelegation.kt")
        public void testNoPrivateDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/noPrivateDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("syntheticAccessor.kt")
        public void testSyntheticAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/syntheticAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("traitImplDelegationWithCovariantOverride.kt")
        public void testTraitImplDelegationWithCovariantOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/traitImplDelegationWithCovariantOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("traitImplDiamond.kt")
        public void testTraitImplDiamond() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/traitImplDiamond.kt");
            doTest(fileName);
        }

        @TestMetadata("traitImplGenericDelegation.kt")
        public void testTraitImplGenericDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/traitImplGenericDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("traitWithPrivateExtension.kt")
        public void testTraitWithPrivateExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/traitWithPrivateExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("traitWithPrivateMember.kt")
        public void testTraitWithPrivateMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/traitWithPrivateMember.kt");
            doTest(fileName);
        }

        @TestMetadata("traitWithPrivateMemberAccessFromLambda.kt")
        public void testTraitWithPrivateMemberAccessFromLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/traits/traitWithPrivateMemberAccessFromLambda.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/typeInfo")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeInfo extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInTypeInfo() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/typeInfo"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("asInLoop.kt")
        public void testAsInLoop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeInfo/asInLoop.kt");
            doTest(fileName);
        }

        @TestMetadata("ifOrWhenSpecialCall.kt")
        public void testIfOrWhenSpecialCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeInfo/ifOrWhenSpecialCall.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitSmartCastThis.kt")
        public void testImplicitSmartCastThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeInfo/implicitSmartCastThis.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritance.kt")
        public void testInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeInfo/inheritance.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2811.kt")
        public void testKt2811() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeInfo/kt2811.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveTypeInfo.kt")
        public void testPrimitiveTypeInfo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeInfo/primitiveTypeInfo.kt");
            doTest(fileName);
        }

        @TestMetadata("smartCastThis.kt")
        public void testSmartCastThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeInfo/smartCastThis.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/typeMapping")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeMapping extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInTypeMapping() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/typeMapping"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("enhancedPrimitives.kt")
        public void testEnhancedPrimitives() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeMapping/enhancedPrimitives.kt");
            doTest(fileName);
        }

        @TestMetadata("genericTypeWithNothing.kt")
        public void testGenericTypeWithNothing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeMapping/genericTypeWithNothing.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2831.kt")
        public void testKt2831() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeMapping/kt2831.kt");
            doTest(fileName);
        }

        @TestMetadata("kt309.kt")
        public void testKt309() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeMapping/kt309.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3286.kt")
        public void testKt3286() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeMapping/kt3286.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3863.kt")
        public void testKt3863() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeMapping/kt3863.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3976.kt")
        public void testKt3976() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeMapping/kt3976.kt");
            doTest(fileName);
        }

        @TestMetadata("nothing.kt")
        public void testNothing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeMapping/nothing.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableNothing.kt")
        public void testNullableNothing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeMapping/nullableNothing.kt");
            doTest(fileName);
        }

        @TestMetadata("typeParameterMultipleBounds.kt")
        public void testTypeParameterMultipleBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typeMapping/typeParameterMultipleBounds.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/typealias")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Typealias extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInTypealias() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/typealias"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("genericTypeAliasConstructor.kt")
        public void testGenericTypeAliasConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/genericTypeAliasConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClassTypeAliasConstructor.kt")
        public void testInnerClassTypeAliasConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/innerClassTypeAliasConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClassTypeAliasConstructorInSupertypes.kt")
        public void testInnerClassTypeAliasConstructorInSupertypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/innerClassTypeAliasConstructorInSupertypes.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasAsBareType.kt")
        public void testTypeAliasAsBareType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/typeAliasAsBareType.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasCompanion.kt")
        public void testTypeAliasCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/typeAliasCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasConstructor.kt")
        public void testTypeAliasConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/typeAliasConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasConstructorAccessor.kt")
        public void testTypeAliasConstructorAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/typeAliasConstructorAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasConstructorInSuperCall.kt")
        public void testTypeAliasConstructorInSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/typeAliasConstructorInSuperCall.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasInAnonymousObjectType.kt")
        public void testTypeAliasInAnonymousObjectType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/typeAliasInAnonymousObjectType.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasObject.kt")
        public void testTypeAliasObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/typeAliasObject.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasObjectCallable.kt")
        public void testTypeAliasObjectCallable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/typeAliasObjectCallable.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasSecondaryConstructor.kt")
        public void testTypeAliasSecondaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/typealias/typeAliasSecondaryConstructor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/unaryOp")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnaryOp extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInUnaryOp() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/unaryOp"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("call.kt")
        public void testCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unaryOp/call.kt");
            doTest(fileName);
        }

        @TestMetadata("callNullable.kt")
        public void testCallNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unaryOp/callNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("callWithCommonType.kt")
        public void testCallWithCommonType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unaryOp/callWithCommonType.kt");
            doTest(fileName);
        }

        @TestMetadata("intrinsic.kt")
        public void testIntrinsic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unaryOp/intrinsic.kt");
            doTest(fileName);
        }

        @TestMetadata("intrinsicNullable.kt")
        public void testIntrinsicNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unaryOp/intrinsicNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("longOverflow.kt")
        public void testLongOverflow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unaryOp/longOverflow.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/unit")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Unit extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInUnit() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/unit"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("closureReturnsNullableUnit.kt")
        public void testClosureReturnsNullableUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/closureReturnsNullableUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("ifElse.kt")
        public void testIfElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/ifElse.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3634.kt")
        public void testKt3634() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/kt3634.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4212.kt")
        public void testKt4212() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/kt4212.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4265.kt")
        public void testKt4265() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/kt4265.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableUnit.kt")
        public void testNullableUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/nullableUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableUnitInWhen1.kt")
        public void testNullableUnitInWhen1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/nullableUnitInWhen1.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableUnitInWhen2.kt")
        public void testNullableUnitInWhen2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/nullableUnitInWhen2.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableUnitInWhen3.kt")
        public void testNullableUnitInWhen3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/nullableUnitInWhen3.kt");
            doTest(fileName);
        }

        @TestMetadata("unitClassObject.kt")
        public void testUnitClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/unitClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("UnitValue.kt")
        public void testUnitValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/unit/UnitValue.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/vararg")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Vararg extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInVararg() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/vararg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("kt1978.kt")
        public void testKt1978() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/vararg/kt1978.kt");
            doTest(fileName);
        }

        @TestMetadata("kt581.kt")
        public void testKt581() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/vararg/kt581.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6192.kt")
        public void testKt6192() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/vararg/kt6192.kt");
            doTest(fileName);
        }

        @TestMetadata("kt796_797.kt")
        public void testKt796_797() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/vararg/kt796_797.kt");
            doTest(fileName);
        }

        @TestMetadata("spreadCopiesArray.kt")
        public void testSpreadCopiesArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/vararg/spreadCopiesArray.kt");
            doTest(fileName);
        }

        @TestMetadata("varargInFunParam.kt")
        public void testVarargInFunParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/vararg/varargInFunParam.kt");
            doTest(fileName);
        }

        @TestMetadata("varargInJava.kt")
        public void testVarargInJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/vararg/varargInJava.kt");
            doTest(fileName);
        }

        @TestMetadata("varargsAndFunctionLiterals.kt")
        public void testVarargsAndFunctionLiterals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/vararg/varargsAndFunctionLiterals.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/box/when")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class When extends AbstractIrBlackBoxCodegenTest {
        public void testAllFilesPresentInWhen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/when"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
        }

        @TestMetadata("callProperty.kt")
        public void testCallProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/callProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyWhen.kt")
        public void testEmptyWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/emptyWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("exceptionOnNoMatch.kt")
        public void testExceptionOnNoMatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/exceptionOnNoMatch.kt");
            doTest(fileName);
        }

        @TestMetadata("exhaustiveBoolean.kt")
        public void testExhaustiveBoolean() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/exhaustiveBoolean.kt");
            doTest(fileName);
        }

        @TestMetadata("exhaustiveBreakContinue.kt")
        public void testExhaustiveBreakContinue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/exhaustiveBreakContinue.kt");
            doTest(fileName);
        }

        @TestMetadata("exhaustiveWhenInitialization.kt")
        public void testExhaustiveWhenInitialization() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/exhaustiveWhenInitialization.kt");
            doTest(fileName);
        }

        @TestMetadata("exhaustiveWhenReturn.kt")
        public void testExhaustiveWhenReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/exhaustiveWhenReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitExhaustiveAndReturn.kt")
        public void testImplicitExhaustiveAndReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/implicitExhaustiveAndReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("integralWhenWithNoInlinedConstants.kt")
        public void testIntegralWhenWithNoInlinedConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/integralWhenWithNoInlinedConstants.kt");
            doTest(fileName);
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/is.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2457.kt")
        public void testKt2457() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/kt2457.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2466.kt")
        public void testKt2466() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/kt2466.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5307.kt")
        public void testKt5307() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/kt5307.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5448.kt")
        public void testKt5448() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/kt5448.kt");
            doTest(fileName);
        }

        @TestMetadata("longInRange.kt")
        public void testLongInRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/longInRange.kt");
            doTest(fileName);
        }

        @TestMetadata("matchNotNullAgainstNullable.kt")
        public void testMatchNotNullAgainstNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/matchNotNullAgainstNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleEntries.kt")
        public void testMultipleEntries() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/multipleEntries.kt");
            doTest(fileName);
        }

        @TestMetadata("noElseExhaustive.kt")
        public void testNoElseExhaustive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/noElseExhaustive.kt");
            doTest(fileName);
        }

        @TestMetadata("noElseExhaustiveStatement.kt")
        public void testNoElseExhaustiveStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/noElseExhaustiveStatement.kt");
            doTest(fileName);
        }

        @TestMetadata("noElseExhaustiveUnitExpected.kt")
        public void testNoElseExhaustiveUnitExpected() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/noElseExhaustiveUnitExpected.kt");
            doTest(fileName);
        }

        @TestMetadata("noElseInStatement.kt")
        public void testNoElseInStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/noElseInStatement.kt");
            doTest(fileName);
        }

        @TestMetadata("noElseNoMatch.kt")
        public void testNoElseNoMatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/noElseNoMatch.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableWhen.kt")
        public void testNullableWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/nullableWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("range.kt")
        public void testRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/range.kt");
            doTest(fileName);
        }

        @TestMetadata("sealedWhenInitialization.kt")
        public void testSealedWhenInitialization() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/sealedWhenInitialization.kt");
            doTest(fileName);
        }

        @TestMetadata("switchOptimizationDense.kt")
        public void testSwitchOptimizationDense() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/switchOptimizationDense.kt");
            doTest(fileName);
        }

        @TestMetadata("switchOptimizationMultipleConditions.kt")
        public void testSwitchOptimizationMultipleConditions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/switchOptimizationMultipleConditions.kt");
            doTest(fileName);
        }

        @TestMetadata("switchOptimizationSparse.kt")
        public void testSwitchOptimizationSparse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/switchOptimizationSparse.kt");
            doTest(fileName);
        }

        @TestMetadata("switchOptimizationStatement.kt")
        public void testSwitchOptimizationStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/switchOptimizationStatement.kt");
            doTest(fileName);
        }

        @TestMetadata("switchOptimizationTypes.kt")
        public void testSwitchOptimizationTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/switchOptimizationTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("switchOptimizationUnordered.kt")
        public void testSwitchOptimizationUnordered() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/switchOptimizationUnordered.kt");
            doTest(fileName);
        }

        @TestMetadata("typeDisjunction.kt")
        public void testTypeDisjunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/typeDisjunction.kt");
            doTest(fileName);
        }

        @TestMetadata("whenArgumentIsEvaluatedOnlyOnce.kt")
        public void testWhenArgumentIsEvaluatedOnlyOnce() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/whenArgumentIsEvaluatedOnlyOnce.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/box/when/enumOptimization")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class EnumOptimization extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInEnumOptimization() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/when/enumOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("bigEnum.kt")
            public void testBigEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/bigEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("duplicatingItems.kt")
            public void testDuplicatingItems() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/duplicatingItems.kt");
                doTest(fileName);
            }

            @TestMetadata("enumInsideClassObject.kt")
            public void testEnumInsideClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/enumInsideClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("expression.kt")
            public void testExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/expression.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralInTopLevel.kt")
            public void testFunctionLiteralInTopLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/functionLiteralInTopLevel.kt");
                doTest(fileName);
            }

            @TestMetadata("manyWhensWithinClass.kt")
            public void testManyWhensWithinClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/manyWhensWithinClass.kt");
                doTest(fileName);
            }

            @TestMetadata("nonConstantEnum.kt")
            public void testNonConstantEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/nonConstantEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("nullability.kt")
            public void testNullability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/nullability.kt");
                doTest(fileName);
            }

            @TestMetadata("nullableEnum.kt")
            public void testNullableEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/nullableEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("subjectAny.kt")
            public void testSubjectAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/subjectAny.kt");
                doTest(fileName);
            }

            @TestMetadata("withoutElse.kt")
            public void testWithoutElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/enumOptimization/withoutElse.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/box/when/stringOptimization")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StringOptimization extends AbstractIrBlackBoxCodegenTest {
            public void testAllFilesPresentInStringOptimization() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/box/when/stringOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.JVM, true);
            }

            @TestMetadata("duplicatingItems.kt")
            public void testDuplicatingItems() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/stringOptimization/duplicatingItems.kt");
                doTest(fileName);
            }

            @TestMetadata("duplicatingItemsSameHashCode.kt")
            public void testDuplicatingItemsSameHashCode() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/stringOptimization/duplicatingItemsSameHashCode.kt");
                doTest(fileName);
            }

            @TestMetadata("expression.kt")
            public void testExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/stringOptimization/expression.kt");
                doTest(fileName);
            }

            @TestMetadata("nullability.kt")
            public void testNullability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/stringOptimization/nullability.kt");
                doTest(fileName);
            }

            @TestMetadata("sameHashCode.kt")
            public void testSameHashCode() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/stringOptimization/sameHashCode.kt");
                doTest(fileName);
            }

            @TestMetadata("statement.kt")
            public void testStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/box/when/stringOptimization/statement.kt");
                doTest(fileName);
            }
        }
    }
}
