/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.checkers;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class DiagnosticsTestGenerated extends AbstractDiagnosticsTest {
    @TestMetadata("compiler/testData/diagnostics/tests")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Tests extends AbstractDiagnosticsTest {
        @TestMetadata("Abstract.kt")
        public void testAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Abstract.kt");
            doTest(fileName);
        }

        @TestMetadata("AbstractAccessor.kt")
        public void testAbstractAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/AbstractAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("AbstractInAbstractClass.kt")
        public void testAbstractInAbstractClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/AbstractInAbstractClass.kt");
            doTest(fileName);
        }

        @TestMetadata("AbstractInClass.kt")
        public void testAbstractInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/AbstractInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("AbstractInTrait.kt")
        public void testAbstractInTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/AbstractInTrait.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInTests() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AnonymousInitializerVarAndConstructor.kt")
        public void testAnonymousInitializerVarAndConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/AnonymousInitializerVarAndConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("AnonymousInitializers.kt")
        public void testAnonymousInitializers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/AnonymousInitializers.kt");
            doTest(fileName);
        }

        @TestMetadata("AssignToArrayElement.kt")
        public void testAssignToArrayElement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/AssignToArrayElement.kt");
            doTest(fileName);
        }

        @TestMetadata("AutoCreatedIt.kt")
        public void testAutoCreatedIt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/AutoCreatedIt.kt");
            doTest(fileName);
        }

        @TestMetadata("BacktickNames.kt")
        public void testBacktickNames() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/BacktickNames.kt");
            doTest(fileName);
        }

        @TestMetadata("Basic.kt")
        public void testBasic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Basic.kt");
            doTest(fileName);
        }

        @TestMetadata("BinaryCallsOnNullableValues.kt")
        public void testBinaryCallsOnNullableValues() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/BinaryCallsOnNullableValues.kt");
            doTest(fileName);
        }

        @TestMetadata("Bounds.kt")
        public void testBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Bounds.kt");
            doTest(fileName);
        }

        @TestMetadata("BreakContinue.kt")
        public void testBreakContinue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/BreakContinue.kt");
            doTest(fileName);
        }

        @TestMetadata("BreakContinueInWhen.kt")
        public void testBreakContinueInWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/BreakContinueInWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("Builders.kt")
        public void testBuilders() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Builders.kt");
            doTest(fileName);
        }

        @TestMetadata("Casts.kt")
        public void testCasts() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Casts.kt");
            doTest(fileName);
        }

        @TestMetadata("CharacterLiterals.kt")
        public void testCharacterLiterals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/CharacterLiterals.kt");
            doTest(fileName);
        }

        @TestMetadata("checkType.kt")
        public void testCheckType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/checkType.kt");
            doTest(fileName);
        }

        @TestMetadata("CompareToWithErrorType.kt")
        public void testCompareToWithErrorType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/CompareToWithErrorType.kt");
            doTest(fileName);
        }

        @TestMetadata("Constants.kt")
        public void testConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Constants.kt");
            doTest(fileName);
        }

        @TestMetadata("Constructors.kt")
        public void testConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Constructors.kt");
            doTest(fileName);
        }

        @TestMetadata("ConstructorsOfPrimitives.kt")
        public void testConstructorsOfPrimitives() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ConstructorsOfPrimitives.kt");
            doTest(fileName);
        }

        @TestMetadata("CovariantOverrideType.kt")
        public void testCovariantOverrideType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/CovariantOverrideType.kt");
            doTest(fileName);
        }

        @TestMetadata("DefaultValueForParameterInFunctionType.kt")
        public void testDefaultValueForParameterInFunctionType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/DefaultValueForParameterInFunctionType.kt");
            doTest(fileName);
        }

        @TestMetadata("DefaultValuesTypechecking.kt")
        public void testDefaultValuesTypechecking() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/DefaultValuesTypechecking.kt");
            doTest(fileName);
        }

        @TestMetadata("DeferredTypes.kt")
        public void testDeferredTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/DeferredTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("DeprecatedGetSetPropertyDelegateConvention.kt")
        public void testDeprecatedGetSetPropertyDelegateConvention() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/DeprecatedGetSetPropertyDelegateConvention.kt");
            doTest(fileName);
        }

        @TestMetadata("DeprecatedUnaryOperatorConventions.kt")
        public void testDeprecatedUnaryOperatorConventions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/DeprecatedUnaryOperatorConventions.kt");
            doTest(fileName);
        }

        @TestMetadata("DiamondFunction.kt")
        public void testDiamondFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/DiamondFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("DiamondFunctionGeneric.kt")
        public void testDiamondFunctionGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/DiamondFunctionGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("DiamondProperty.kt")
        public void testDiamondProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/DiamondProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("Dollar.kt")
        public void testDollar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Dollar.kt");
            doTest(fileName);
        }

        @TestMetadata("EnumEntryAsType.kt")
        public void testEnumEntryAsType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/EnumEntryAsType.kt");
            doTest(fileName);
        }

        @TestMetadata("ExtensionCallInvoke.kt")
        public void testExtensionCallInvoke() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ExtensionCallInvoke.kt");
            doTest(fileName);
        }

        @TestMetadata("ExternalAndAbstract.kt")
        public void testExternalAndAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ExternalAndAbstract.kt");
            doTest(fileName);
        }

        @TestMetadata("fileDependencyRecursion.kt")
        public void testFileDependencyRecursion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/fileDependencyRecursion.kt");
            doTest(fileName);
        }

        @TestMetadata("ForRangeConventions.kt")
        public void testForRangeConventions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ForRangeConventions.kt");
            doTest(fileName);
        }

        @TestMetadata("FreeFunctionCalledAsExtension.kt")
        public void testFreeFunctionCalledAsExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/FreeFunctionCalledAsExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionCalleeExpressions.kt")
        public void testFunctionCalleeExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/FunctionCalleeExpressions.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionParameterWithoutType.kt")
        public void testFunctionParameterWithoutType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/FunctionParameterWithoutType.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionReturnTypes.kt")
        public void testFunctionReturnTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/FunctionReturnTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("GenericArgumentConsistency.kt")
        public void testGenericArgumentConsistency() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/GenericArgumentConsistency.kt");
            doTest(fileName);
        }

        @TestMetadata("GenericFunctionIsLessSpecific.kt")
        public void testGenericFunctionIsLessSpecific() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/GenericFunctionIsLessSpecific.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitIntersection.kt")
        public void testImplicitIntersection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/implicitIntersection.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitNestedIntersection.kt")
        public void testImplicitNestedIntersection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/implicitNestedIntersection.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitNothing.kt")
        public void testImplicitNothing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/implicitNothing.kt");
            doTest(fileName);
        }

        @TestMetadata("IncDec.kt")
        public void testIncDec() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/IncDec.kt");
            doTest(fileName);
        }

        @TestMetadata("IncorrectCharacterLiterals.kt")
        public void testIncorrectCharacterLiterals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/IncorrectCharacterLiterals.kt");
            doTest(fileName);
        }

        @TestMetadata("InferNullabilityInThenBlock.kt")
        public void testInferNullabilityInThenBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/InferNullabilityInThenBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("Infix.kt")
        public void testInfix() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Infix.kt");
            doTest(fileName);
        }

        @TestMetadata("InfixModifierApplicability.kt")
        public void testInfixModifierApplicability() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/InfixModifierApplicability.kt");
            doTest(fileName);
        }

        @TestMetadata("InvokeAndRecursiveResolve.kt")
        public void testInvokeAndRecursiveResolve() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/InvokeAndRecursiveResolve.kt");
            doTest(fileName);
        }

        @TestMetadata("IsExpressions.kt")
        public void testIsExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/IsExpressions.kt");
            doTest(fileName);
        }

        @TestMetadata("kt13401.kt")
        public void testKt13401() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/kt13401.kt");
            doTest(fileName);
        }

        @TestMetadata("kt310.kt")
        public void testKt310() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/kt310.kt");
            doTest(fileName);
        }

        @TestMetadata("kt435.kt")
        public void testKt435() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/kt435.kt");
            doTest(fileName);
        }

        @TestMetadata("kt53.kt")
        public void testKt53() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/kt53.kt");
            doTest(fileName);
        }

        @TestMetadata("LValueAssignment.kt")
        public void testLValueAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/LValueAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("LateInit.kt")
        public void testLateInit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/LateInit.kt");
            doTest(fileName);
        }

        @TestMetadata("LateInitSetter.kt")
        public void testLateInitSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/LateInitSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("LiteralAsResult.kt")
        public void testLiteralAsResult() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/LiteralAsResult.kt");
            doTest(fileName);
        }

        @TestMetadata("LocalClassAndShortSubpackageNames.kt")
        public void testLocalClassAndShortSubpackageNames() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/LocalClassAndShortSubpackageNames.kt");
            doTest(fileName);
        }

        @TestMetadata("localInterfaces.kt")
        public void testLocalInterfaces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/localInterfaces.kt");
            doTest(fileName);
        }

        @TestMetadata("MultilineStringTemplates.kt")
        public void testMultilineStringTemplates() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/MultilineStringTemplates.kt");
            doTest(fileName);
        }

        @TestMetadata("MultipleBounds.kt")
        public void testMultipleBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/MultipleBounds.kt");
            doTest(fileName);
        }

        @TestMetadata("NamedFunctionTypeParameterInSupertype.kt")
        public void testNamedFunctionTypeParameterInSupertype() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/NamedFunctionTypeParameterInSupertype.kt");
            doTest(fileName);
        }

        @TestMetadata("Nullability.kt")
        public void testNullability() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Nullability.kt");
            doTest(fileName);
        }

        @TestMetadata("NumberPrefixAndSuffix.kt")
        public void testNumberPrefixAndSuffix() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/NumberPrefixAndSuffix.kt");
            doTest(fileName);
        }

        @TestMetadata("ObjectWithConstructor.kt")
        public void testObjectWithConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ObjectWithConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("OperatorChecks.kt")
        public void testOperatorChecks() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/OperatorChecks.kt");
            doTest(fileName);
        }

        @TestMetadata("Operators.kt")
        public void testOperators() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Operators.kt");
            doTest(fileName);
        }

        @TestMetadata("OperatorsWithWrongNames.kt")
        public void testOperatorsWithWrongNames() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/OperatorsWithWrongNames.kt");
            doTest(fileName);
        }

        @TestMetadata("OverrideFunctionWithParamDefaultValue.kt")
        public void testOverrideFunctionWithParamDefaultValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/OverrideFunctionWithParamDefaultValue.kt");
            doTest(fileName);
        }

        @TestMetadata("OverridenFunctionAndSpecifiedTypeParameter.kt")
        public void testOverridenFunctionAndSpecifiedTypeParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/OverridenFunctionAndSpecifiedTypeParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("OverridenSetterVisibility.kt")
        public void testOverridenSetterVisibility() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/OverridenSetterVisibility.kt");
            doTest(fileName);
        }

        @TestMetadata("OverridingVarByVal.kt")
        public void testOverridingVarByVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/OverridingVarByVal.kt");
            doTest(fileName);
        }

        @TestMetadata("PackageInExpressionPosition.kt")
        public void testPackageInExpressionPosition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/PackageInExpressionPosition.kt");
            doTest(fileName);
        }

        @TestMetadata("PackageInTypePosition.kt")
        public void testPackageInTypePosition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/PackageInTypePosition.kt");
            doTest(fileName);
        }

        @TestMetadata("PackageQualified.kt")
        public void testPackageQualified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/PackageQualified.kt");
            doTest(fileName);
        }

        @TestMetadata("PrimaryConstructors.kt")
        public void testPrimaryConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/PrimaryConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("PrivateFromOuterPackage.kt")
        public void testPrivateFromOuterPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/PrivateFromOuterPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("PrivateSetterForOverridden.kt")
        public void testPrivateSetterForOverridden() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/PrivateSetterForOverridden.kt");
            doTest(fileName);
        }

        @TestMetadata("ProcessingEmptyImport.kt")
        public void testProcessingEmptyImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ProcessingEmptyImport.kt");
            doTest(fileName);
        }

        @TestMetadata("ProjectionOnFunctionArgumentErrror.kt")
        public void testProjectionOnFunctionArgumentErrror() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ProjectionOnFunctionArgumentErrror.kt");
            doTest(fileName);
        }

        @TestMetadata("ProjectionsInSupertypes.kt")
        public void testProjectionsInSupertypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ProjectionsInSupertypes.kt");
            doTest(fileName);
        }

        @TestMetadata("Properties.kt")
        public void testProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Properties.kt");
            doTest(fileName);
        }

        @TestMetadata("PropertyInitializers.kt")
        public void testPropertyInitializers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/PropertyInitializers.kt");
            doTest(fileName);
        }

        @TestMetadata("QualifiedExpressions.kt")
        public void testQualifiedExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/QualifiedExpressions.kt");
            doTest(fileName);
        }

        @TestMetadata("RecursiveResolve.kt")
        public void testRecursiveResolve() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/RecursiveResolve.kt");
            doTest(fileName);
        }

        @TestMetadata("RecursiveTypeInference.kt")
        public void testRecursiveTypeInference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/RecursiveTypeInference.kt");
            doTest(fileName);
        }

        @TestMetadata("ResolveOfJavaGenerics.kt")
        public void testResolveOfJavaGenerics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ResolveOfJavaGenerics.kt");
            doTest(fileName);
        }

        @TestMetadata("ResolveToJava.kt")
        public void testResolveToJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ResolveToJava.kt");
            doTest(fileName);
        }

        @TestMetadata("Return.kt")
        public void testReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Return.kt");
            doTest(fileName);
        }

        @TestMetadata("ReturnInFunctionWithoutBody.kt")
        public void testReturnInFunctionWithoutBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ReturnInFunctionWithoutBody.kt");
            doTest(fileName);
        }

        @TestMetadata("SafeCallInvoke.kt")
        public void testSafeCallInvoke() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/SafeCallInvoke.kt");
            doTest(fileName);
        }

        @TestMetadata("SafeCallNonNullReceiver.kt")
        public void testSafeCallNonNullReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/SafeCallNonNullReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("SafeCallNonNullReceiverReturnNull.kt")
        public void testSafeCallNonNullReceiverReturnNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/SafeCallNonNullReceiverReturnNull.kt");
            doTest(fileName);
        }

        @TestMetadata("SafeCallOnFakePackage.kt")
        public void testSafeCallOnFakePackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/SafeCallOnFakePackage.kt");
            doTest(fileName);
        }

        @TestMetadata("SafeCallOnSuperReceiver.kt")
        public void testSafeCallOnSuperReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/SafeCallOnSuperReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("Serializable.kt")
        public void testSerializable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Serializable.kt");
            doTest(fileName);
        }

        @TestMetadata("SetterVisibility.kt")
        public void testSetterVisibility() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/SetterVisibility.kt");
            doTest(fileName);
        }

        @TestMetadata("ShiftFunctionTypes.kt")
        public void testShiftFunctionTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ShiftFunctionTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("SingleUnderscoreUnsupported.kt")
        public void testSingleUnderscoreUnsupported() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/SingleUnderscoreUnsupported.kt");
            doTest(fileName);
        }

        @TestMetadata("StarsInFunctionCalls.kt")
        public void testStarsInFunctionCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/StarsInFunctionCalls.kt");
            doTest(fileName);
        }

        @TestMetadata("StringPrefixAndSuffix.kt")
        public void testStringPrefixAndSuffix() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/StringPrefixAndSuffix.kt");
            doTest(fileName);
        }

        @TestMetadata("StringTemplates.kt")
        public void testStringTemplates() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/StringTemplates.kt");
            doTest(fileName);
        }

        @TestMetadata("SupertypeListChecks.kt")
        public void testSupertypeListChecks() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/SupertypeListChecks.kt");
            doTest(fileName);
        }

        @TestMetadata("SyntaxErrorInTestHighlighting.kt")
        public void testSyntaxErrorInTestHighlighting() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/SyntaxErrorInTestHighlighting.kt");
            doTest(fileName);
        }

        @TestMetadata("SyntaxErrorInTestHighlightingEof.kt")
        public void testSyntaxErrorInTestHighlightingEof() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/SyntaxErrorInTestHighlightingEof.kt");
            doTest(fileName);
        }

        @TestMetadata("tailRecOverridden.kt")
        public void testTailRecOverridden() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/tailRecOverridden.kt");
            doTest(fileName);
        }

        @TestMetadata("tailRecursionComplex.kt")
        public void testTailRecursionComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/tailRecursionComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("TraitOverrideObjectMethods.kt")
        public void testTraitOverrideObjectMethods() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/TraitOverrideObjectMethods.kt");
            doTest(fileName);
        }

        @TestMetadata("TraitWithConstructor.kt")
        public void testTraitWithConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/TraitWithConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("TypeInference.kt")
        public void testTypeInference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/TypeInference.kt");
            doTest(fileName);
        }

        @TestMetadata("TypeMismatchOnOverrideWithSyntaxErrors.kt")
        public void testTypeMismatchOnOverrideWithSyntaxErrors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/TypeMismatchOnOverrideWithSyntaxErrors.kt");
            doTest(fileName);
        }

        @TestMetadata("Underscore.kt")
        public void testUnderscore() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Underscore.kt");
            doTest(fileName);
        }

        @TestMetadata("UnitByDefaultForFunctionTypes.kt")
        public void testUnitByDefaultForFunctionTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/UnitByDefaultForFunctionTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("UnitValue.kt")
        public void testUnitValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/UnitValue.kt");
            doTest(fileName);
        }

        @TestMetadata("Unresolved.kt")
        public void testUnresolved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Unresolved.kt");
            doTest(fileName);
        }

        @TestMetadata("UnusedInDestructuring.kt")
        public void testUnusedInDestructuring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/UnusedInDestructuring.kt");
            doTest(fileName);
        }

        @TestMetadata("UnusedParameters.kt")
        public void testUnusedParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/UnusedParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("UnusedVariables.kt")
        public void testUnusedVariables() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/UnusedVariables.kt");
            doTest(fileName);
        }

        @TestMetadata("ValAndFunOverrideCompatibilityClash.kt")
        public void testValAndFunOverrideCompatibilityClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/ValAndFunOverrideCompatibilityClash.kt");
            doTest(fileName);
        }

        @TestMetadata("VarargTypes.kt")
        public void testVarargTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/VarargTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("Varargs.kt")
        public void testVarargs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Varargs.kt");
            doTest(fileName);
        }

        @TestMetadata("Variance.kt")
        public void testVariance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/Variance.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/diagnostics/tests/annotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotations extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AmbigiousAnnotationConstructor.kt")
            public void testAmbigiousAnnotationConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AmbigiousAnnotationConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedConstructor.kt")
            public void testAnnotatedConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotatedConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedConstructorParams.kt")
            public void testAnnotatedConstructorParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotatedConstructorParams.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedLocalObjectFun.kt")
            public void testAnnotatedLocalObjectFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotatedLocalObjectFun.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedLocalObjectProperty.kt")
            public void testAnnotatedLocalObjectProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotatedLocalObjectProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedLoop.kt")
            public void testAnnotatedLoop() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotatedLoop.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedResultType.kt")
            public void testAnnotatedResultType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotatedResultType.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedTryCatch.kt")
            public void testAnnotatedTryCatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotatedTryCatch.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotationAsDefaultParameter.kt")
            public void testAnnotationAsDefaultParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotationAsDefaultParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotationForClassTypeParameter.kt")
            public void testAnnotationForClassTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotationForClassTypeParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotationForFunctionTypeParameter.kt")
            public void testAnnotationForFunctionTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotationForFunctionTypeParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotationForObject.kt")
            public void testAnnotationForObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotationForObject.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotationIdentifier.kt")
            public void testAnnotationIdentifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotationIdentifier.kt");
                doTest(fileName);
            }

            @TestMetadata("annotationInheritance.kt")
            public void testAnnotationInheritance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationInheritance.kt");
                doTest(fileName);
            }

            @TestMetadata("annotationModifier.kt")
            public void testAnnotationModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationModifier.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotationOnObject.kt")
            public void testAnnotationOnObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotationOnObject.kt");
                doTest(fileName);
            }

            @TestMetadata("annotationOnParameterInFunctionType.kt")
            public void testAnnotationOnParameterInFunctionType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationOnParameterInFunctionType.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotationsForClasses.kt")
            public void testAnnotationsForClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotationsForClasses.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotationsForPropertyTypeParameter.kt")
            public void testAnnotationsForPropertyTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/AnnotationsForPropertyTypeParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("annotationsOnLambdaAsCallArgument.kt")
            public void testAnnotationsOnLambdaAsCallArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationsOnLambdaAsCallArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("annotationsOnNullableTypes.kt")
            public void testAnnotationsOnNullableTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationsOnNullableTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("atAnnotationResolve.kt")
            public void testAtAnnotationResolve() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/atAnnotationResolve.kt");
                doTest(fileName);
            }

            @TestMetadata("BasicAnnotations.kt")
            public void testBasicAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/BasicAnnotations.kt");
                doTest(fileName);
            }

            @TestMetadata("blockLevelOnTheSameLineWarning.kt")
            public void testBlockLevelOnTheSameLineWarning() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/blockLevelOnTheSameLineWarning.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorCall.kt")
            public void testConstructorCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/ConstructorCall.kt");
                doTest(fileName);
            }

            @TestMetadata("DanglingInScript.kt")
            public void testDanglingInScript() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/DanglingInScript.kt");
                doTest(fileName);
            }

            @TestMetadata("DanglingMixed.kt")
            public void testDanglingMixed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/DanglingMixed.kt");
                doTest(fileName);
            }

            @TestMetadata("DanglingNoBrackets.kt")
            public void testDanglingNoBrackets() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/DanglingNoBrackets.kt");
                doTest(fileName);
            }

            @TestMetadata("DanglingWithBrackets.kt")
            public void testDanglingWithBrackets() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/DanglingWithBrackets.kt");
                doTest(fileName);
            }

            @TestMetadata("Deprecated.kt")
            public void testDeprecated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/Deprecated.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFunctionType.kt")
            public void testExtensionFunctionType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/extensionFunctionType.kt");
                doTest(fileName);
            }

            @TestMetadata("forParameterAnnotationResolve.kt")
            public void testForParameterAnnotationResolve() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/forParameterAnnotationResolve.kt");
                doTest(fileName);
            }

            @TestMetadata("illegalSinceKotlinValue.kt")
            public void testIllegalSinceKotlinValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/illegalSinceKotlinValue.kt");
                doTest(fileName);
            }

            @TestMetadata("invalidTypesInAnnotationConstructor.kt")
            public void testInvalidTypesInAnnotationConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/invalidTypesInAnnotationConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("JavaAnnotationConstructors.kt")
            public void testJavaAnnotationConstructors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/JavaAnnotationConstructors.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1860-negative.kt")
            public void testKt1860_negative() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/kt1860-negative.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1860-positive.kt")
            public void testKt1860_positive() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/kt1860-positive.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1886annotationBody.kt")
            public void testKt1886annotationBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/kt1886annotationBody.kt");
                doTest(fileName);
            }

            @TestMetadata("missingValOnParameter.kt")
            public void testMissingValOnParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/missingValOnParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/MultiDeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("MutuallyRecursivelyAnnotatedGlobalFunction.kt")
            public void testMutuallyRecursivelyAnnotatedGlobalFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/MutuallyRecursivelyAnnotatedGlobalFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("noNameProperty.kt")
            public void testNoNameProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/noNameProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("NonAnnotationClass.kt")
            public void testNonAnnotationClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/NonAnnotationClass.kt");
                doTest(fileName);
            }

            @TestMetadata("onExpression.kt")
            public void testOnExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/onExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("onFunctionParameter.kt")
            public void testOnFunctionParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/onFunctionParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("onInitializer.kt")
            public void testOnInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/onInitializer.kt");
                doTest(fileName);
            }

            @TestMetadata("onLoops.kt")
            public void testOnLoops() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/onLoops.kt");
                doTest(fileName);
            }

            @TestMetadata("onLoopsUnreachable.kt")
            public void testOnLoopsUnreachable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/onLoopsUnreachable.kt");
                doTest(fileName);
            }

            @TestMetadata("onMultiDeclaration.kt")
            public void testOnMultiDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/onMultiDeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursivelyAnnotated.kt")
            public void testRecursivelyAnnotated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotated.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursivelyAnnotatedFunctionParameter.kt")
            public void testRecursivelyAnnotatedFunctionParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedFunctionParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursivelyAnnotatedGlobalFunction.kt")
            public void testRecursivelyAnnotatedGlobalFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedGlobalFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursivelyAnnotatedGlobalProperty.kt")
            public void testRecursivelyAnnotatedGlobalProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedGlobalProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursivelyAnnotatedParameter.kt")
            public void testRecursivelyAnnotatedParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursivelyAnnotatedParameterType.kt")
            public void testRecursivelyAnnotatedParameterType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameterType.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursivelyAnnotatedParameterWithAt.kt")
            public void testRecursivelyAnnotatedParameterWithAt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameterWithAt.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursivelyAnnotatedProperty.kt")
            public void testRecursivelyAnnotatedProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursivelyIncorrectlyAnnotatedParameter.kt")
            public void testRecursivelyIncorrectlyAnnotatedParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/RecursivelyIncorrectlyAnnotatedParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("typeAnnotations.kt")
            public void testTypeAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/typeAnnotations.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParameterAsAnnotation.kt")
            public void testTypeParameterAsAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/typeParameterAsAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("UnresolvedAnnotationOnObject.kt")
            public void testUnresolvedAnnotationOnObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/UnresolvedAnnotationOnObject.kt");
                doTest(fileName);
            }

            @TestMetadata("unresolvedReferenceRange.kt")
            public void testUnresolvedReferenceRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/unresolvedReferenceRange.kt");
                doTest(fileName);
            }

            @TestMetadata("WrongAnnotationArgsOnObject.kt")
            public void testWrongAnnotationArgsOnObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/WrongAnnotationArgsOnObject.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AnnotationParameterMustBeConstant extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInAnnotationParameterMustBeConstant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("booleanLocalVal.kt")
                public void testBooleanLocalVal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/booleanLocalVal.kt");
                    doTest(fileName);
                }

                @TestMetadata("compareAndEquals.kt")
                public void testCompareAndEquals() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/compareAndEquals.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumConst.kt")
                public void testEnumConst() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/enumConst.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaProperties.kt")
                public void testJavaProperties() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/javaProperties.kt");
                    doTest(fileName);
                }

                @TestMetadata("kotlinProperties.kt")
                public void testKotlinProperties() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/kotlinProperties.kt");
                    doTest(fileName);
                }

                @TestMetadata("standaloneInExpression.kt")
                public void testStandaloneInExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/standaloneInExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("strings.kt")
                public void testStrings() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/strings.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/annotations/options")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Options extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInOptions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/options"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationAsArg.kt")
                public void testAnnotationAsArg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/annotationAsArg.kt");
                    doTest(fileName);
                }

                @TestMetadata("annotationAsArgComplex.kt")
                public void testAnnotationAsArgComplex() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/annotationAsArgComplex.kt");
                    doTest(fileName);
                }

                @TestMetadata("assignment.kt")
                public void testAssignment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/assignment.kt");
                    doTest(fileName);
                }

                @TestMetadata("documented.kt")
                public void testDocumented() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/documented.kt");
                    doTest(fileName);
                }

                @TestMetadata("forParam.kt")
                public void testForParam() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/forParam.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionExpression.kt")
                public void testFunctionExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/functionExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("functions.kt")
                public void testFunctions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/functions.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaDocumented.kt")
                public void testJavaDocumented() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/javaDocumented.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaKotlinTargetRetention.kt")
                public void testJavaKotlinTargetRetention() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/javaKotlinTargetRetention.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaretention.kt")
                public void testJavaretention() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/javaretention.kt");
                    doTest(fileName);
                }

                @TestMetadata("multiDeclaration.kt")
                public void testMultiDeclaration() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/multiDeclaration.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectLiteral.kt")
                public void testObjectLiteral() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/objectLiteral.kt");
                    doTest(fileName);
                }

                @TestMetadata("prefix.kt")
                public void testPrefix() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/prefix.kt");
                    doTest(fileName);
                }

                @TestMetadata("repeatable.kt")
                public void testRepeatable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/repeatable.kt");
                    doTest(fileName);
                }

                @TestMetadata("retention.kt")
                public void testRetention() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/retention.kt");
                    doTest(fileName);
                }

                @TestMetadata("setterParam.kt")
                public void testSetterParam() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/setterParam.kt");
                    doTest(fileName);
                }

                @TestMetadata("target.kt")
                public void testTarget() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/target.kt");
                    doTest(fileName);
                }

                @TestMetadata("unrepeatable.kt")
                public void testUnrepeatable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/unrepeatable.kt");
                    doTest(fileName);
                }

                @TestMetadata("compiler/testData/diagnostics/tests/annotations/options/targets")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Targets extends AbstractDiagnosticsTest {
                    @TestMetadata("accessors.kt")
                    public void testAccessors() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/accessors.kt");
                        doTest(fileName);
                    }

                    public void testAllFilesPresentInTargets() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/options/targets"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("annotation.kt")
                    public void testAnnotation() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/annotation.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("classifier.kt")
                    public void testClassifier() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/classifier.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("constructor.kt")
                    public void testConstructor() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/constructor.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("empty.kt")
                    public void testEmpty() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/empty.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("expr.kt")
                    public void testExpr() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/expr.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("field.kt")
                    public void testField() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/field.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("file.kt")
                    public void testFile() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/file.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("function.kt")
                    public void testFunction() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/function.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("funtypeargs.kt")
                    public void testFuntypeargs() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/funtypeargs.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("incorrect.kt")
                    public void testIncorrect() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/incorrect.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("init.kt")
                    public void testInit() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/init.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("java.kt")
                    public void testJava() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/java.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("local.kt")
                    public void testLocal() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/local.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("nested.kt")
                    public void testNested() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/nested.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("property.kt")
                    public void testProperty() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/property.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("returntype.kt")
                    public void testReturntype() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/returntype.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("suppress.kt")
                    public void testSuppress() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/suppress.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("type.kt")
                    public void testType() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/type.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("typeParams.kt")
                    public void testTypeParams() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/typeParams.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("typeargs.kt")
                    public void testTypeargs() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/typeargs.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("valueparam.kt")
                    public void testValueparam() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/options/targets/valueparam.kt");
                        doTest(fileName);
                    }
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WithUseSiteTarget extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInWithUseSiteTarget() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("DelegateAnnotations.kt")
                public void testDelegateAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/DelegateAnnotations.kt");
                    doTest(fileName);
                }

                @TestMetadata("FieldAnnotations.kt")
                public void testFieldAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/FieldAnnotations.kt");
                    doTest(fileName);
                }

                @TestMetadata("FileAnnotations.kt")
                public void testFileAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/FileAnnotations.kt");
                    doTest(fileName);
                }

                @TestMetadata("GetterAnnotations.kt")
                public void testGetterAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/GetterAnnotations.kt");
                    doTest(fileName);
                }

                @TestMetadata("ParamAnnotations.kt")
                public void testParamAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/ParamAnnotations.kt");
                    doTest(fileName);
                }

                @TestMetadata("PropertyAnnotations.kt")
                public void testPropertyAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/PropertyAnnotations.kt");
                    doTest(fileName);
                }

                @TestMetadata("ReceiverAnnotations.kt")
                public void testReceiverAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/ReceiverAnnotations.kt");
                    doTest(fileName);
                }

                @TestMetadata("repeatable.kt")
                public void testRepeatable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/repeatable.kt");
                    doTest(fileName);
                }

                @TestMetadata("SetterAnnotations.kt")
                public void testSetterAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/SetterAnnotations.kt");
                    doTest(fileName);
                }

                @TestMetadata("SparamAnnotations.kt")
                public void testSparamAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/SparamAnnotations.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/backingField")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BackingField extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInBackingField() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/backingField"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("CustomGetSet.kt")
            public void testCustomGetSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/CustomGetSet.kt");
                doTest(fileName);
            }

            @TestMetadata("CustomGetVal.kt")
            public void testCustomGetVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/CustomGetVal.kt");
                doTest(fileName);
            }

            @TestMetadata("CustomGetValGlobal.kt")
            public void testCustomGetValGlobal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/CustomGetValGlobal.kt");
                doTest(fileName);
            }

            @TestMetadata("CustomGetVar.kt")
            public void testCustomGetVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/CustomGetVar.kt");
                doTest(fileName);
            }

            @TestMetadata("CustomSet.kt")
            public void testCustomSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/CustomSet.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtensionProperty.kt")
            public void testExtensionProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/ExtensionProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldAsParam.kt")
            public void testFieldAsParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/FieldAsParam.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldAsProperty.kt")
            public void testFieldAsProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/FieldAsProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldDerived.kt")
            public void testFieldDerived() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/FieldDerived.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldInInterface.kt")
            public void testFieldInInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/FieldInInterface.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldInLocal.kt")
            public void testFieldInLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/FieldInLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldOnVal.kt")
            public void testFieldOnVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/FieldOnVal.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldOnVar.kt")
            public void testFieldOnVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/FieldOnVar.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldReassignment.kt")
            public void testFieldReassignment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/FieldReassignment.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldShadow.kt")
            public void testFieldShadow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/FieldShadow.kt");
                doTest(fileName);
            }

            @TestMetadata("InitCustomSetter.kt")
            public void testInitCustomSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/InitCustomSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("InitOpenSetter.kt")
            public void testInitOpenSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/InitOpenSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("kt782packageLevel.kt")
            public void testKt782packageLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/kt782packageLevel.kt");
                doTest(fileName);
            }

            @TestMetadata("SetterWithExplicitType.kt")
            public void testSetterWithExplicitType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/backingField/SetterWithExplicitType.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/callableReference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CallableReference extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInCallableReference() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("bareType.kt")
            public void testBareType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bareType.kt");
                doTest(fileName);
            }

            @TestMetadata("classVsPackage.kt")
            public void testClassVsPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/classVsPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("ea81649_errorPropertyLHS.kt")
            public void testEa81649_errorPropertyLHS() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/ea81649_errorPropertyLHS.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyLhs.kt")
            public void testEmptyLhs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/emptyLhs.kt");
                doTest(fileName);
            }

            @TestMetadata("kt7430_wrongClassOnLHS.kt")
            public void testKt7430_wrongClassOnLHS() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/kt7430_wrongClassOnLHS.kt");
                doTest(fileName);
            }

            @TestMetadata("memberExtensionsImportedFromObjectsUnsupported.kt")
            public void testMemberExtensionsImportedFromObjectsUnsupported() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/memberExtensionsImportedFromObjectsUnsupported.kt");
                doTest(fileName);
            }

            @TestMetadata("packageInLhs.kt")
            public void testPackageInLhs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/packageInLhs.kt");
                doTest(fileName);
            }

            @TestMetadata("parsingPriorityOfGenericArgumentsVsLess.kt")
            public void testParsingPriorityOfGenericArgumentsVsLess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/parsingPriorityOfGenericArgumentsVsLess.kt");
                doTest(fileName);
            }

            @TestMetadata("sam.kt")
            public void testSam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/sam.kt");
                doTest(fileName);
            }

            @TestMetadata("unused.kt")
            public void testUnused() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/unused.kt");
                doTest(fileName);
            }

            @TestMetadata("whitespacesInExpression.kt")
            public void testWhitespacesInExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/whitespacesInExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/bound")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Bound extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInBound() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classVsStarImportedCompanion.kt")
                public void testClassVsStarImportedCompanion() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/classVsStarImportedCompanion.kt");
                    doTest(fileName);
                }

                @TestMetadata("classVsStarImportedObject.kt")
                public void testClassVsStarImportedObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/classVsStarImportedObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("companionObject.kt")
                public void testCompanionObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/companionObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("controlFlow.kt")
                public void testControlFlow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/controlFlow.kt");
                    doTest(fileName);
                }

                @TestMetadata("dataFlow.kt")
                public void testDataFlow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/dataFlow.kt");
                    doTest(fileName);
                }

                @TestMetadata("expectedType.kt")
                public void testExpectedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/expectedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionCallWithoutArguments.kt")
                public void testFunctionCallWithoutArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/functionCallWithoutArguments.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerNested.kt")
                public void testInnerNested() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/innerNested.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt12843.kt")
                public void testKt12843() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/kt12843.kt");
                    doTest(fileName);
                }

                @TestMetadata("noThisInSuperCall.kt")
                public void testNoThisInSuperCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/noThisInSuperCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("object.kt")
                public void testObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/object.kt");
                    doTest(fileName);
                }

                @TestMetadata("privateToThis.kt")
                public void testPrivateToThis() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/privateToThis.kt");
                    doTest(fileName);
                }

                @TestMetadata("referenceToStaticMethodOnInstance.kt")
                public void testReferenceToStaticMethodOnInstance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/referenceToStaticMethodOnInstance.kt");
                    doTest(fileName);
                }

                @TestMetadata("syntheticExtensionOnLHS.kt")
                public void testSyntheticExtensionOnLHS() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/syntheticExtensionOnLHS.kt");
                    doTest(fileName);
                }

                @TestMetadata("valueOfTypeParameterType.kt")
                public void testValueOfTypeParameterType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/bound/valueOfTypeParameterType.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/function")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Function extends AbstractDiagnosticsTest {
                @TestMetadata("abstractClassConstructors.kt")
                public void testAbstractClassConstructors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/abstractClassConstructors.kt");
                    doTest(fileName);
                }

                public void testAllFilesPresentInFunction() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ambiguityTopLevelVsTopLevel.kt")
                public void testAmbiguityTopLevelVsTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/ambiguityTopLevelVsTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("annotationClassConstructor.kt")
                public void testAnnotationClassConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/annotationClassConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("callableRefrenceOnNestedObject.kt")
                public void testCallableRefrenceOnNestedObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/callableRefrenceOnNestedObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("classMemberVsConstructorLikeFunction.kt")
                public void testClassMemberVsConstructorLikeFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/classMemberVsConstructorLikeFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructorFromClass.kt")
                public void testConstructorFromClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/constructorFromClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructorFromCompanion.kt")
                public void testConstructorFromCompanion() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/constructorFromCompanion.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructorFromExtension.kt")
                public void testConstructorFromExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/constructorFromExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructorFromExtensionInClass.kt")
                public void testConstructorFromExtensionInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/constructorFromExtensionInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructorFromTopLevel.kt")
                public void testConstructorFromTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/constructorFromTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("differentPackageClass.kt")
                public void testDifferentPackageClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/differentPackageClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("differentPackageExtension.kt")
                public void testDifferentPackageExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/differentPackageExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("differentPackageTopLevel.kt")
                public void testDifferentPackageTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/differentPackageTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("empty.kt")
                public void testEmpty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/empty.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionFromTopLevel.kt")
                public void testExtensionFromTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/extensionFromTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionInClassDisallowed.kt")
                public void testExtensionInClassDisallowed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/extensionInClassDisallowed.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionOnNullable.kt")
                public void testExtensionOnNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/extensionOnNullable.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionToSupertype.kt")
                public void testExtensionToSupertype() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/extensionToSupertype.kt");
                    doTest(fileName);
                }

                @TestMetadata("fakeOverrideType.kt")
                public void testFakeOverrideType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/fakeOverrideType.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericClassFromTopLevel.kt")
                public void testGenericClassFromTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/genericClassFromTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("importedInnerConstructor.kt")
                public void testImportedInnerConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/importedInnerConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerConstructorFromClass.kt")
                public void testInnerConstructorFromClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerConstructorFromExtension.kt")
                public void testInnerConstructorFromExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerConstructorFromTopLevel.kt")
                public void testInnerConstructorFromTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaStaticMethod.kt")
                public void testJavaStaticMethod() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/javaStaticMethod.kt");
                    doTest(fileName);
                }

                @TestMetadata("lhsNotAClass.kt")
                public void testLhsNotAClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/lhsNotAClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("localConstructor.kt")
                public void testLocalConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/localConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("localConstructorFromExtensionInLocalClass.kt")
                public void testLocalConstructorFromExtensionInLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromExtensionInLocalClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("localConstructorFromLocalClass.kt")
                public void testLocalConstructorFromLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromLocalClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("localConstructorFromLocalExtension.kt")
                public void testLocalConstructorFromLocalExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromLocalExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("localNamedFun.kt")
                public void testLocalNamedFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/localNamedFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("localNamedFunFromExtensionInLocalClass.kt")
                public void testLocalNamedFunFromExtensionInLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromExtensionInLocalClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("localNamedFunFromLocalClass.kt")
                public void testLocalNamedFunFromLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromLocalClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("localNamedFunFromLocalExtension.kt")
                public void testLocalNamedFunFromLocalExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromLocalExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("longQualifiedName.kt")
                public void testLongQualifiedName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/longQualifiedName.kt");
                    doTest(fileName);
                }

                @TestMetadata("longQualifiedNameGeneric.kt")
                public void testLongQualifiedNameGeneric() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/longQualifiedNameGeneric.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberFromTopLevel.kt")
                public void testMemberFromTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/memberFromTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedConstructorFromClass.kt")
                public void testNestedConstructorFromClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedConstructorFromExtension.kt")
                public void testNestedConstructorFromExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedConstructorFromTopLevel.kt")
                public void testNestedConstructorFromTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("noAmbiguityLocalVsTopLevel.kt")
                public void testNoAmbiguityLocalVsTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityLocalVsTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("noAmbiguityMemberVsExtension.kt")
                public void testNoAmbiguityMemberVsExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityMemberVsExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("noAmbiguityMemberVsTopLevel.kt")
                public void testNoAmbiguityMemberVsTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityMemberVsTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("renameOnImport.kt")
                public void testRenameOnImport() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/renameOnImport.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelFromClass.kt")
                public void testTopLevelFromClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelFromExtension.kt")
                public void testTopLevelFromExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelFromExtensionInClass.kt")
                public void testTopLevelFromExtensionInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromExtensionInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelFromTopLevel.kt")
                public void testTopLevelFromTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("unresolved.kt")
                public void testUnresolved() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/function/unresolved.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/generic")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Generic extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInGeneric() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/generic"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt10968.kt")
                public void testKt10968() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/generic/kt10968.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt11075.kt")
                public void testKt11075() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/generic/kt11075.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt12286.kt")
                public void testKt12286() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/generic/kt12286.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/property")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Property extends AbstractDiagnosticsTest {
                @TestMetadata("abstractPropertyViaSubclasses.kt")
                public void testAbstractPropertyViaSubclasses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/abstractPropertyViaSubclasses.kt");
                    doTest(fileName);
                }

                @TestMetadata("accessViaSubclass.kt")
                public void testAccessViaSubclass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/accessViaSubclass.kt");
                    doTest(fileName);
                }

                public void testAllFilesPresentInProperty() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classFromClass.kt")
                public void testClassFromClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/classFromClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionFromTopLevel.kt")
                public void testExtensionFromTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/extensionFromTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionPropertyOnNullable.kt")
                public void testExtensionPropertyOnNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/extensionPropertyOnNullable.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericClass.kt")
                public void testGenericClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/genericClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaInstanceField.kt")
                public void testJavaInstanceField() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/javaInstanceField.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaStaticFieldViaImport.kt")
                public void testJavaStaticFieldViaImport() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/javaStaticFieldViaImport.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt7564.kt")
                public void testKt7564() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/kt7564.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt7945_unrelatedClass.kt")
                public void testKt7945_unrelatedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/kt7945_unrelatedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("localVariable.kt")
                public void testLocalVariable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/localVariable.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberFromTopLevel.kt")
                public void testMemberFromTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/memberFromTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("protectedVarFromClass.kt")
                public void testProtectedVarFromClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/protectedVarFromClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnTypeDependentOnGenericProperty.kt")
                public void testReturnTypeDependentOnGenericProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/returnTypeDependentOnGenericProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("samePriorityForFunctionsAndProperties.kt")
                public void testSamePriorityForFunctionsAndProperties() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/samePriorityForFunctionsAndProperties.kt");
                    doTest(fileName);
                }

                @TestMetadata("syntheticProperties.kt")
                public void testSyntheticProperties() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/syntheticProperties.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelFromTopLevel.kt")
                public void testTopLevelFromTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/property/topLevelFromTopLevel.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/resolve")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Resolve extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInResolve() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/resolve"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ambiguousWithVararg.kt")
                public void testAmbiguousWithVararg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/ambiguousWithVararg.kt");
                    doTest(fileName);
                }

                @TestMetadata("byArgType.kt")
                public void testByArgType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/byArgType.kt");
                    doTest(fileName);
                }

                @TestMetadata("byGenericArgType.kt")
                public void testByGenericArgType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/byGenericArgType.kt");
                    doTest(fileName);
                }

                @TestMetadata("byValType.kt")
                public void testByValType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/byValType.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructor.kt")
                public void testConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/constructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt10036.kt")
                public void testKt10036() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/kt10036.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt10036_bound.kt")
                public void testKt10036_bound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/kt10036_bound.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt12751.kt")
                public void testKt12751() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/kt12751.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt8596.kt")
                public void testKt8596() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/kt8596.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt9601.kt")
                public void testKt9601() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/kt9601.kt");
                    doTest(fileName);
                }

                @TestMetadata("moreSpecificAmbiguousExtensions.kt")
                public void testMoreSpecificAmbiguousExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/moreSpecificAmbiguousExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("moreSpecificSimple.kt")
                public void testMoreSpecificSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/moreSpecificSimple.kt");
                    doTest(fileName);
                }

                @TestMetadata("noFakeDescriptorForObject.kt")
                public void testNoFakeDescriptorForObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/noFakeDescriptorForObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("overloads.kt")
                public void testOverloads() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/overloads.kt");
                    doTest(fileName);
                }

                @TestMetadata("overloadsBound.kt")
                public void testOverloadsBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/overloadsBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("overloadsMember.kt")
                public void testOverloadsMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/overloadsMember.kt");
                    doTest(fileName);
                }

                @TestMetadata("valVsFun.kt")
                public void testValVsFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/valVsFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("withAs.kt")
                public void testWithAs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/withAs.kt");
                    doTest(fileName);
                }

                @TestMetadata("withExtFun.kt")
                public void testWithExtFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/withExtFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("withGenericFun.kt")
                public void testWithGenericFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/withGenericFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("withPlaceholderTypes.kt")
                public void testWithPlaceholderTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/withPlaceholderTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("withVararg.kt")
                public void testWithVararg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/callableReference/resolve/withVararg.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/cast")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Cast extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInCast() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/cast"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AsArray.kt")
            public void testAsArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/AsArray.kt");
                doTest(fileName);
            }

            @TestMetadata("AsErasedError.kt")
            public void testAsErasedError() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/AsErasedError.kt");
                doTest(fileName);
            }

            @TestMetadata("AsErasedFine.kt")
            public void testAsErasedFine() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/AsErasedFine.kt");
                doTest(fileName);
            }

            @TestMetadata("AsErasedStar.kt")
            public void testAsErasedStar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/AsErasedStar.kt");
                doTest(fileName);
            }

            @TestMetadata("AsErasedWarning.kt")
            public void testAsErasedWarning() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/AsErasedWarning.kt");
                doTest(fileName);
            }

            @TestMetadata("AsInBinaryUnary.kt")
            public void testAsInBinaryUnary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/AsInBinaryUnary.kt");
                doTest(fileName);
            }

            @TestMetadata("AsNothing.kt")
            public void testAsNothing() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/AsNothing.kt");
                doTest(fileName);
            }

            @TestMetadata("AsTypeAlias.kt")
            public void testAsTypeAlias() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/AsTypeAlias.kt");
                doTest(fileName);
            }

            @TestMetadata("AsWithOtherParameter.kt")
            public void testAsWithOtherParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/AsWithOtherParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("constants.kt")
            public void testConstants() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/constants.kt");
                doTest(fileName);
            }

            @TestMetadata("DowncastMap.kt")
            public void testDowncastMap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/DowncastMap.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtensionAsNonExtension.kt")
            public void testExtensionAsNonExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/ExtensionAsNonExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric.kt")
            public void testIsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowForExactSupertypeCheck.kt")
            public void testIsErasedAllowForExactSupertypeCheck() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowForExactSupertypeCheck.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowForOverridenVarianceWithProjection.kt")
            public void testIsErasedAllowForOverridenVarianceWithProjection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowForOverridenVarianceWithProjection.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowForSupertypeCheckWithContrvariance.kt")
            public void testIsErasedAllowForSupertypeCheckWithContrvariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowForSupertypeCheckWithContrvariance.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowForSupertypeCheckWithCovariance.kt")
            public void testIsErasedAllowForSupertypeCheckWithCovariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowForSupertypeCheckWithCovariance.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowForTypeWithIrrelevantMixin.kt")
            public void testIsErasedAllowForTypeWithIrrelevantMixin() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithIrrelevantMixin.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowForTypeWithTwoSameTypeSubstitutions.kt")
            public void testIsErasedAllowForTypeWithTwoSameTypeSubstitutions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithTwoSameTypeSubstitutions.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowForTypeWithoutTypeArguments.kt")
            public void testIsErasedAllowForTypeWithoutTypeArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithoutTypeArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowFromOut.kt")
            public void testIsErasedAllowFromOut() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOut.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowFromOut2.kt")
            public void testIsErasedAllowFromOut2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOut2.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowFromOutAtClass.kt")
            public void testIsErasedAllowFromOutAtClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOutAtClass.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowParameterSubtype.kt")
            public void testIsErasedAllowParameterSubtype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowParameterSubtype.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowSameClassParameter.kt")
            public void testIsErasedAllowSameClassParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowSameClassParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedAllowSameParameterParameter.kt")
            public void testIsErasedAllowSameParameterParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedAllowSameParameterParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("isErasedAnyAndStarred.kt")
            public void testIsErasedAnyAndStarred() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/isErasedAnyAndStarred.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedDisallowDifferentArgInvariantPosition.kt")
            public void testIsErasedDisallowDifferentArgInvariantPosition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedDisallowDifferentArgInvariantPosition.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedDisallowForOverridenVariance.kt")
            public void testIsErasedDisallowForOverridenVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedDisallowForOverridenVariance.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedDisallowForTypeWithConstraints.kt")
            public void testIsErasedDisallowForTypeWithConstraints() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedDisallowForTypeWithConstraints.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedDisallowFromAny.kt")
            public void testIsErasedDisallowFromAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromAny.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedDisallowFromIn.kt")
            public void testIsErasedDisallowFromIn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromIn.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedDisallowFromOut.kt")
            public void testIsErasedDisallowFromOut() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromOut.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedDisallowFromOutAtClass.kt")
            public void testIsErasedDisallowFromOutAtClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromOutAtClass.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid.kt")
            public void testIsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid.kt")
            public void testIsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedNonGeneric.kt")
            public void testIsErasedNonGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedNonGeneric.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedNullableTasT.kt")
            public void testIsErasedNullableTasT() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedNullableTasT.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedStar.kt")
            public void testIsErasedStar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedStar.kt");
                doTest(fileName);
            }

            @TestMetadata("isErasedTAndStarred.kt")
            public void testIsErasedTAndStarred() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/isErasedTAndStarred.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedTasT.kt")
            public void testIsErasedTasT() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedTasT.kt");
                doTest(fileName);
            }

            @TestMetadata("IsErasedToErrorType.kt")
            public void testIsErasedToErrorType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsErasedToErrorType.kt");
                doTest(fileName);
            }

            @TestMetadata("isErasedUnrelatedAndStarred.kt")
            public void testIsErasedUnrelatedAndStarred() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/isErasedUnrelatedAndStarred.kt");
                doTest(fileName);
            }

            @TestMetadata("IsRecursionSustainable.kt")
            public void testIsRecursionSustainable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsRecursionSustainable.kt");
                doTest(fileName);
            }

            @TestMetadata("IsTraits.kt")
            public void testIsTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/IsTraits.kt");
                doTest(fileName);
            }

            @TestMetadata("kt614.kt")
            public void testKt614() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/kt614.kt");
                doTest(fileName);
            }

            @TestMetadata("NullableToNullable.kt")
            public void testNullableToNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/NullableToNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("WhenErasedDisallowFromAny.kt")
            public void testWhenErasedDisallowFromAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/WhenErasedDisallowFromAny.kt");
                doTest(fileName);
            }

            @TestMetadata("WhenWithExpression.kt")
            public void testWhenWithExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/WhenWithExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/cast/bare")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Bare extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInBare() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/cast/bare"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("AsNestedBare.kt")
                public void testAsNestedBare() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/AsNestedBare.kt");
                    doTest(fileName);
                }

                @TestMetadata("AsNullable.kt")
                public void testAsNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/AsNullable.kt");
                    doTest(fileName);
                }

                @TestMetadata("AsNullableNotEnough.kt")
                public void testAsNullableNotEnough() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/AsNullableNotEnough.kt");
                    doTest(fileName);
                }

                @TestMetadata("EitherAs.kt")
                public void testEitherAs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/EitherAs.kt");
                    doTest(fileName);
                }

                @TestMetadata("EitherIs.kt")
                public void testEitherIs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/EitherIs.kt");
                    doTest(fileName);
                }

                @TestMetadata("EitherNotIs.kt")
                public void testEitherNotIs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/EitherNotIs.kt");
                    doTest(fileName);
                }

                @TestMetadata("EitherSafeAs.kt")
                public void testEitherSafeAs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/EitherSafeAs.kt");
                    doTest(fileName);
                }

                @TestMetadata("EitherWhen.kt")
                public void testEitherWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/EitherWhen.kt");
                    doTest(fileName);
                }

                @TestMetadata("ErrorsInSubstitution.kt")
                public void testErrorsInSubstitution() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/ErrorsInSubstitution.kt");
                    doTest(fileName);
                }

                @TestMetadata("FromErrorType.kt")
                public void testFromErrorType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/FromErrorType.kt");
                    doTest(fileName);
                }

                @TestMetadata("NullableAs.kt")
                public void testNullableAs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/NullableAs.kt");
                    doTest(fileName);
                }

                @TestMetadata("NullableAsNotEnough.kt")
                public void testNullableAsNotEnough() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/NullableAsNotEnough.kt");
                    doTest(fileName);
                }

                @TestMetadata("NullableAsNullable.kt")
                public void testNullableAsNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/NullableAsNullable.kt");
                    doTest(fileName);
                }

                @TestMetadata("NullableAsNullableNotEnough.kt")
                public void testNullableAsNullableNotEnough() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/NullableAsNullableNotEnough.kt");
                    doTest(fileName);
                }

                @TestMetadata("RedundantNullable.kt")
                public void testRedundantNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/RedundantNullable.kt");
                    doTest(fileName);
                }

                @TestMetadata("ToErrorType.kt")
                public void testToErrorType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/ToErrorType.kt");
                    doTest(fileName);
                }

                @TestMetadata("UnrelatedAs.kt")
                public void testUnrelatedAs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/UnrelatedAs.kt");
                    doTest(fileName);
                }

                @TestMetadata("UnrelatedColon.kt")
                public void testUnrelatedColon() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/UnrelatedColon.kt");
                    doTest(fileName);
                }

                @TestMetadata("UnrelatedIs.kt")
                public void testUnrelatedIs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/bare/UnrelatedIs.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/cast/neverSucceeds")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NeverSucceeds extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInNeverSucceeds() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/cast/neverSucceeds"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("CastToNotNullSuper.kt")
                public void testCastToNotNullSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/neverSucceeds/CastToNotNullSuper.kt");
                    doTest(fileName);
                }

                @TestMetadata("MappedDirect.kt")
                public void testMappedDirect() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/neverSucceeds/MappedDirect.kt");
                    doTest(fileName);
                }

                @TestMetadata("MappedSubtypes.kt")
                public void testMappedSubtypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/neverSucceeds/MappedSubtypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("NoGenericsRelated.kt")
                public void testNoGenericsRelated() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/neverSucceeds/NoGenericsRelated.kt");
                    doTest(fileName);
                }

                @TestMetadata("NoGenericsUnrelated.kt")
                public void testNoGenericsUnrelated() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cast/neverSucceeds/NoGenericsUnrelated.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/checkArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CheckArguments extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInCheckArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/checkArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrayAccessSet.kt")
            public void testArrayAccessSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/checkArguments/arrayAccessSet.kt");
                doTest(fileName);
            }

            @TestMetadata("arrayAccessSetTooManyArgs.kt")
            public void testArrayAccessSetTooManyArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/checkArguments/arrayAccessSetTooManyArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("booleanExpressions.kt")
            public void testBooleanExpressions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/checkArguments/booleanExpressions.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1897_diagnostic_part.kt")
            public void testKt1897_diagnostic_part() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/checkArguments/kt1897_diagnostic_part.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1940.kt")
            public void testKt1940() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/checkArguments/kt1940.kt");
                doTest(fileName);
            }

            @TestMetadata("overloadedFunction.kt")
            public void testOverloadedFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/checkArguments/overloadedFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("SpreadVarargs.kt")
            public void testSpreadVarargs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/checkArguments/SpreadVarargs.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/classLiteral")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassLiteral extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInClassLiteral() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/classLiteral"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrays.kt")
            public void testArrays() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classLiteral/arrays.kt");
                doTest(fileName);
            }

            @TestMetadata("classLiteralType.kt")
            public void testClassLiteralType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classLiteral/classLiteralType.kt");
                doTest(fileName);
            }

            @TestMetadata("genericArrays.kt")
            public void testGenericArrays() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classLiteral/genericArrays.kt");
                doTest(fileName);
            }

            @TestMetadata("genericClasses.kt")
            public void testGenericClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classLiteral/genericClasses.kt");
                doTest(fileName);
            }

            @TestMetadata("integerValueType.kt")
            public void testIntegerValueType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classLiteral/integerValueType.kt");
                doTest(fileName);
            }

            @TestMetadata("nonClassesOnLHS.kt")
            public void testNonClassesOnLHS() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classLiteral/nonClassesOnLHS.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifiedClassLiteral.kt")
            public void testQualifiedClassLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classLiteral/qualifiedClassLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleClassLiteral.kt")
            public void testSimpleClassLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classLiteral/simpleClassLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("unresolvedClass.kt")
            public void testUnresolvedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classLiteral/unresolvedClass.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/classObjects")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassObjects extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInClassObjects() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/classObjects"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("builtInClassObjects.kt")
            public void testBuiltInClassObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/builtInClassObjects.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectCannotAccessClassFields.kt")
            public void testClassObjectCannotAccessClassFields() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/ClassObjectCannotAccessClassFields.kt");
                doTest(fileName);
            }

            @TestMetadata("classObjectHeader.kt")
            public void testClassObjectHeader() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/classObjectHeader.kt");
                doTest(fileName);
            }

            @TestMetadata("classObjectInLocalClass.kt")
            public void testClassObjectInLocalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/classObjectInLocalClass.kt");
                doTest(fileName);
            }

            @TestMetadata("classObjectRedeclaration.kt")
            public void testClassObjectRedeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/classObjectRedeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectVisibility.kt")
            public void testClassObjectVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/ClassObjectVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassObjects.kt")
            public void testClassObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/ClassObjects.kt");
                doTest(fileName);
            }

            @TestMetadata("companionObjectOfPrivateClassVisibility.kt")
            public void testCompanionObjectOfPrivateClassVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/companionObjectOfPrivateClassVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("importClassInClassObject.kt")
            public void testImportClassInClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/importClassInClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerClassAccessThroughClassObject.kt")
            public void testInnerClassAccessThroughClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerClassAccessThroughEnum.kt")
            public void testInnerClassAccessThroughEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerClassClassObject.kt")
            public void testInnerClassClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/InnerClassClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("invisibleClassObjects.kt")
            public void testInvisibleClassObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/invisibleClassObjects.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3866.kt")
            public void testKt3866() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/kt3866.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleDissallowedDefaultObjects.kt")
            public void testMultipleDissallowedDefaultObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/multipleDissallowedDefaultObjects.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClassInPrivateClassObject.kt")
            public void testNestedClassInPrivateClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/nestedClassInPrivateClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveFunctionInsideClassObject.kt")
            public void testResolveFunctionInsideClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/classObjects/resolveFunctionInsideClassObject.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/constructorConsistency")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConstructorConsistency extends AbstractDiagnosticsTest {
            @TestMetadata("afterInitialization.kt")
            public void testAfterInitialization() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/afterInitialization.kt");
                doTest(fileName);
            }

            @TestMetadata("aliencall.kt")
            public void testAliencall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/aliencall.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInConstructorConsistency() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/constructorConsistency"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignment.kt")
            public void testAssignment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/assignment.kt");
                doTest(fileName);
            }

            @TestMetadata("backing.kt")
            public void testBacking() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/backing.kt");
                doTest(fileName);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/basic.kt");
                doTest(fileName);
            }

            @TestMetadata("companion.kt")
            public void testCompanion() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/companion.kt");
                doTest(fileName);
            }

            @TestMetadata("comparison.kt")
            public void testComparison() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/comparison.kt");
                doTest(fileName);
            }

            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/delegate.kt");
                doTest(fileName);
            }

            @TestMetadata("derived.kt")
            public void testDerived() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/derived.kt");
                doTest(fileName);
            }

            @TestMetadata("derivedProperty.kt")
            public void testDerivedProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/derivedProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("getset.kt")
            public void testGetset() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/getset.kt");
                doTest(fileName);
            }

            @TestMetadata("init.kt")
            public void testInit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/init.kt");
                doTest(fileName);
            }

            @TestMetadata("initwithgetter.kt")
            public void testInitwithgetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/initwithgetter.kt");
                doTest(fileName);
            }

            @TestMetadata("inspection.kt")
            public void testInspection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/inspection.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInObject.kt")
            public void testLambdaInObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/lambdaInObject.kt");
                doTest(fileName);
            }

            @TestMetadata("lateInit.kt")
            public void testLateInit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/lateInit.kt");
                doTest(fileName);
            }

            @TestMetadata("localObject.kt")
            public void testLocalObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/localObject.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleAreNull.kt")
            public void testMultipleAreNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/multipleAreNull.kt");
                doTest(fileName);
            }

            @TestMetadata("nobacking.kt")
            public void testNobacking() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/nobacking.kt");
                doTest(fileName);
            }

            @TestMetadata("open.kt")
            public void testOpen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/open.kt");
                doTest(fileName);
            }

            @TestMetadata("openProperty.kt")
            public void testOpenProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/openProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("outer.kt")
            public void testOuter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/outer.kt");
                doTest(fileName);
            }

            @TestMetadata("property.kt")
            public void testProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/property.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyAccess.kt")
            public void testPropertyAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/propertyAccess.kt");
                doTest(fileName);
            }

            @TestMetadata("twoSecondaryConstructors.kt")
            public void testTwoSecondaryConstructors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/constructorConsistency/twoSecondaryConstructors.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ControlFlowAnalysis extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInControlFlowAnalysis() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignedInFinally.kt")
            public void testAssignedInFinally() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignedInFinally.kt");
                doTest(fileName);
            }

            @TestMetadata("backingFieldInsideGetter.kt")
            public void testBackingFieldInsideGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/backingFieldInsideGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("breakContinueInTryFinally.kt")
            public void testBreakContinueInTryFinally() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakContinueInTryFinally.kt");
                doTest(fileName);
            }

            @TestMetadata("breakInsideLocal.kt")
            public void testBreakInsideLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakInsideLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("breakOrContinueInLoopCondition.kt")
            public void testBreakOrContinueInLoopCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakOrContinueInLoopCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("checkInnerLocalDeclarations.kt")
            public void testCheckInnerLocalDeclarations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/checkInnerLocalDeclarations.kt");
                doTest(fileName);
            }

            @TestMetadata("checkPropertyAccessor.kt")
            public void testCheckPropertyAccessor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/checkPropertyAccessor.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorPropertyInterdependence.kt")
            public void testConstructorPropertyInterdependence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/constructorPropertyInterdependence.kt");
                doTest(fileName);
            }

            @TestMetadata("definiteReturnInWhen.kt")
            public void testDefiniteReturnInWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturnInWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("delegatedPropertyEarlyAccess.kt")
            public void testDelegatedPropertyEarlyAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/delegatedPropertyEarlyAccess.kt");
                doTest(fileName);
            }

            @TestMetadata("doWhileNotDefined.kt")
            public void testDoWhileNotDefined() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/doWhileNotDefined.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisNotProcessed.kt")
            public void testElvisNotProcessed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/elvisNotProcessed.kt");
                doTest(fileName);
            }

            @TestMetadata("enumCompanionInterdependence.kt")
            public void testEnumCompanionInterdependence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumCompanionInterdependence.kt");
                doTest(fileName);
            }

            @TestMetadata("enumInterdependence.kt")
            public void testEnumInterdependence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumInterdependence.kt");
                doTest(fileName);
            }

            @TestMetadata("infiniteLoops.kt")
            public void testInfiniteLoops() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/infiniteLoops.kt");
                doTest(fileName);
            }

            @TestMetadata("initializationInLambda.kt")
            public void testInitializationInLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("initializationInLocalClass.kt")
            public void testInitializationInLocalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalClass.kt");
                doTest(fileName);
            }

            @TestMetadata("initializationInLocalFun.kt")
            public void testInitializationInLocalFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalFun.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1001.kt")
            public void testKt1001() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1001.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1027.kt")
            public void testKt1027() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1027.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1066.kt")
            public void testKt1066() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1066.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10805.kt")
            public void testKt10805() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt10805.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10823.kt")
            public void testKt10823() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt10823.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1156.kt")
            public void testKt1156() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1156.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1185enums.kt")
            public void testKt1185enums() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1185enums.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1189.kt")
            public void testKt1189() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1189.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1191.kt")
            public void testKt1191() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1191.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1219.1301.kt")
            public void testKt1219_1301() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1219.1301.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1571.kt")
            public void testKt1571() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1571.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1977.kt")
            public void testKt1977() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1977.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2166_kt2103.kt")
            public void testKt2166_kt2103() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2166_kt2103.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2226.kt")
            public void testKt2226() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2226.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2330.kt")
            public void testKt2330() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2330.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2334.kt")
            public void testKt2334() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2334.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2369.kt")
            public void testKt2369() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2369.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2845.kt")
            public void testKt2845() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2845.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2960.kt")
            public void testKt2960() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2960.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2972.kt")
            public void testKt2972() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2972.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3444.kt")
            public void testKt3444() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt3444.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3501.kt")
            public void testKt3501() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt3501.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4126.kt")
            public void testKt4126() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt4126.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4405.kt")
            public void testKt4405() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt4405.kt");
                doTest(fileName);
            }

            @TestMetadata("kt510.kt")
            public void testKt510() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt510.kt");
                doTest(fileName);
            }

            @TestMetadata("kt607.kt")
            public void testKt607() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt607.kt");
                doTest(fileName);
            }

            @TestMetadata("kt609.kt")
            public void testKt609() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt609.kt");
                doTest(fileName);
            }

            @TestMetadata("kt610.kt")
            public void testKt610() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt610.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6788.kt")
            public void testKt6788() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt6788.kt");
                doTest(fileName);
            }

            @TestMetadata("kt776.kt")
            public void testKt776() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt776.kt");
                doTest(fileName);
            }

            @TestMetadata("kt843.kt")
            public void testKt843() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt843.kt");
                doTest(fileName);
            }

            @TestMetadata("kt897.kt")
            public void testKt897() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt897.kt");
                doTest(fileName);
            }

            @TestMetadata("localClasses.kt")
            public void testLocalClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/localClasses.kt");
                doTest(fileName);
            }

            @TestMetadata("localObjectInConstructor.kt")
            public void testLocalObjectInConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/localObjectInConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedTryFinally.kt")
            public void testNestedTryFinally() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/nestedTryFinally.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLocalReturnUnreachable.kt")
            public void testNonLocalReturnUnreachable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/nonLocalReturnUnreachable.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLocalReturnWithFinally.kt")
            public void testNonLocalReturnWithFinally() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/nonLocalReturnWithFinally.kt");
                doTest(fileName);
            }

            @TestMetadata("privateSetter.kt")
            public void testPrivateSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/privateSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("propertiesInitWithOtherInstance.kt")
            public void testPropertiesInitWithOtherInstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstance.kt");
                doTest(fileName);
            }

            @TestMetadata("propertiesInitWithOtherInstanceInner.kt")
            public void testPropertiesInitWithOtherInstanceInner() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstanceInner.kt");
                doTest(fileName);
            }

            @TestMetadata("propertiesInitWithOtherInstanceThisLabel.kt")
            public void testPropertiesInitWithOtherInstanceThisLabel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstanceThisLabel.kt");
                doTest(fileName);
            }

            @TestMetadata("propertiesOrderInPackage.kt")
            public void testPropertiesOrderInPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesOrderInPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("reassignmentInTryCatch.kt")
            public void testReassignmentInTryCatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInTryCatch.kt");
                doTest(fileName);
            }

            @TestMetadata("reassignmentInTryCatchWithJumps.kt")
            public void testReassignmentInTryCatchWithJumps() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInTryCatchWithJumps.kt");
                doTest(fileName);
            }

            @TestMetadata("referenceToPropertyInitializer.kt")
            public void testReferenceToPropertyInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/referenceToPropertyInitializer.kt");
                doTest(fileName);
            }

            @TestMetadata("repeatUnitializedErrorOnlyForLocalVars.kt")
            public void testRepeatUnitializedErrorOnlyForLocalVars() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/repeatUnitializedErrorOnlyForLocalVars.kt");
                doTest(fileName);
            }

            @TestMetadata("scopeOfAnonymousInitializer.kt")
            public void testScopeOfAnonymousInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/scopeOfAnonymousInitializer.kt");
                doTest(fileName);
            }

            @TestMetadata("throwInLambda.kt")
            public void testThrowInLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/throwInLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("tryWithAssignmentUsedInCatch.kt")
            public void testTryWithAssignmentUsedInCatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/tryWithAssignmentUsedInCatch.kt");
                doTest(fileName);
            }

            @TestMetadata("uninitializedInLocalDeclarations.kt")
            public void testUninitializedInLocalDeclarations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninitializedInLocalDeclarations.kt");
                doTest(fileName);
            }

            @TestMetadata("UninitializedOrReassignedVariables.kt")
            public void testUninitializedOrReassignedVariables() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/UninitializedOrReassignedVariables.kt");
                doTest(fileName);
            }

            @TestMetadata("unmappedArgs.kt")
            public void testUnmappedArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unmappedArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("unresolvedReference.kt")
            public void testUnresolvedReference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unresolvedReference.kt");
                doTest(fileName);
            }

            @TestMetadata("useUninitializedInLambda.kt")
            public void testUseUninitializedInLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/useUninitializedInLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("varInitializationInIfInCycle.kt")
            public void testVarInitializationInIfInCycle() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/varInitializationInIfInCycle.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DeadCode extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInDeadCode() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("commasAndWhitespaces.kt")
                public void testCommasAndWhitespaces() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/commasAndWhitespaces.kt");
                    doTest(fileName);
                }

                @TestMetadata("commentsInDeadCode.kt")
                public void testCommentsInDeadCode() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/commentsInDeadCode.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCallInInvokeCall.kt")
                public void testDeadCallInInvokeCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCallInInvokeCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCallInReceiver.kt")
                public void testDeadCallInReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCallInReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeDifferentExamples.kt")
                public void testDeadCodeDifferentExamples() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeDifferentExamples.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeFromDifferentSources.kt")
                public void testDeadCodeFromDifferentSources() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeFromDifferentSources.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInArrayAccess.kt")
                public void testDeadCodeInArrayAccess() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInArrayAccess.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInAssignment.kt")
                public void testDeadCodeInAssignment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInAssignment.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInBinaryExpressions.kt")
                public void testDeadCodeInBinaryExpressions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInBinaryExpressions.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInCalls.kt")
                public void testDeadCodeInCalls() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInCalls.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInDeadCode.kt")
                public void testDeadCodeInDeadCode() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInDeadCode.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInIf.kt")
                public void testDeadCodeInIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInInnerExpressions.kt")
                public void testDeadCodeInInnerExpressions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInInnerExpressions.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInLocalDeclarations.kt")
                public void testDeadCodeInLocalDeclarations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInLocalDeclarations.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInLoops.kt")
                public void testDeadCodeInLoops() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInLoops.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInReturn.kt")
                public void testDeadCodeInReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInReturn.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInUnaryExpr.kt")
                public void testDeadCodeInUnaryExpr() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInUnaryExpr.kt");
                    doTest(fileName);
                }

                @TestMetadata("deadCodeInWhileFromBreak.kt")
                public void testDeadCodeInWhileFromBreak() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInWhileFromBreak.kt");
                    doTest(fileName);
                }

                @TestMetadata("expressionInUnitLiteral.kt")
                public void testExpressionInUnitLiteral() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/expressionInUnitLiteral.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2585_1.kt")
                public void testKt2585_1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_1.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2585_2.kt")
                public void testKt2585_2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_2.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2585_3.kt")
                public void testKt2585_3() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_3.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3162tryAsInitializer.kt")
                public void testKt3162tryAsInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt3162tryAsInitializer.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt5200DeadCodeInLambdas.kt")
                public void testKt5200DeadCodeInLambdas() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt5200DeadCodeInLambdas.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DefiniteReturn extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInDefiniteReturn() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt3444_ReturnFromLocalFunctions.kt")
                public void testKt3444_ReturnFromLocalFunctions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/kt3444_ReturnFromLocalFunctions.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt4034.kt")
                public void testKt4034() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/kt4034.kt");
                    doTest(fileName);
                }

                @TestMetadata("ReturnFromFunctionInObject.kt")
                public void testReturnFromFunctionInObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/ReturnFromFunctionInObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleClass.kt")
                public void testSimpleClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/simpleClass.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class UnnecessaryLateinit extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInUnnecessaryLateinit() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("lateinitRecursiveInLambda.kt")
                public void testLateinitRecursiveInLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitRecursiveInLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("lateinitWithConstructor.kt")
                public void testLateinitWithConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("lateinitWithErroneousDelegation.kt")
                public void testLateinitWithErroneousDelegation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithErroneousDelegation.kt");
                    doTest(fileName);
                }

                @TestMetadata("lateinitWithInit.kt")
                public void testLateinitWithInit() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithInit.kt");
                    doTest(fileName);
                }

                @TestMetadata("lateinitWithMultipleConstructors.kt")
                public void testLateinitWithMultipleConstructors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithMultipleConstructors.kt");
                    doTest(fileName);
                }

                @TestMetadata("lateinitWithMultipleConstructorsAndDelegation.kt")
                public void testLateinitWithMultipleConstructorsAndDelegation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithMultipleConstructorsAndDelegation.kt");
                    doTest(fileName);
                }

                @TestMetadata("lateinitWithPlusAssign.kt")
                public void testLateinitWithPlusAssign() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithPlusAssign.kt");
                    doTest(fileName);
                }

                @TestMetadata("lateinitWithPrimaryConstructorAndConstructor.kt")
                public void testLateinitWithPrimaryConstructorAndConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithPrimaryConstructorAndConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("normalLateinit.kt")
                public void testNormalLateinit() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/normalLateinit.kt");
                    doTest(fileName);
                }

                @TestMetadata("normalLateinitWithTwoConstructors.kt")
                public void testNormalLateinitWithTwoConstructors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/normalLateinitWithTwoConstructors.kt");
                    doTest(fileName);
                }

                @TestMetadata("secondaryConstructorDelegateItself.kt")
                public void testSecondaryConstructorDelegateItself() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/secondaryConstructorDelegateItself.kt");
                    doTest(fileName);
                }

                @TestMetadata("secondaryConstructorDelegateLoop.kt")
                public void testSecondaryConstructorDelegateLoop() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/secondaryConstructorDelegateLoop.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/controlStructures")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ControlStructures extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInControlStructures() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/controlStructures"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("catchGenerics.kt")
            public void testCatchGenerics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/catchGenerics.kt");
                doTest(fileName);
            }

            @TestMetadata("commonSupertypeOfT.kt")
            public void testCommonSupertypeOfT() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/commonSupertypeOfT.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyIf.kt")
            public void testEmptyIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/emptyIf.kt");
                doTest(fileName);
            }

            @TestMetadata("ForLoopWithExtensionIteratorOnNullable.kt")
            public void testForLoopWithExtensionIteratorOnNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/ForLoopWithExtensionIteratorOnNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("forLoopWithNullableRange.kt")
            public void testForLoopWithNullableRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/forLoopWithNullableRange.kt");
                doTest(fileName);
            }

            @TestMetadata("forWithNullableIterator.kt")
            public void testForWithNullableIterator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/forWithNullableIterator.kt");
                doTest(fileName);
            }

            @TestMetadata("ForWithoutBraces.kt")
            public void testForWithoutBraces() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/ForWithoutBraces.kt");
                doTest(fileName);
            }

            @TestMetadata("ForbidStatementAsDirectFunctionBody.kt")
            public void testForbidStatementAsDirectFunctionBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/ForbidStatementAsDirectFunctionBody.kt");
                doTest(fileName);
            }

            @TestMetadata("ifElseIntersection.kt")
            public void testIfElseIntersection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/ifElseIntersection.kt");
                doTest(fileName);
            }

            @TestMetadata("ifInResultOfLambda.kt")
            public void testIfInResultOfLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/ifInResultOfLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("ifToAnyDiscriminatingUsages.kt")
            public void testIfToAnyDiscriminatingUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/ifToAnyDiscriminatingUsages.kt");
                doTest(fileName);
            }

            @TestMetadata("ifWhenToAnyComplexExpressions.kt")
            public void testIfWhenToAnyComplexExpressions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/ifWhenToAnyComplexExpressions.kt");
                doTest(fileName);
            }

            @TestMetadata("ifWhenWithoutElse.kt")
            public void testIfWhenWithoutElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/ifWhenWithoutElse.kt");
                doTest(fileName);
            }

            @TestMetadata("improperElseInExpression.kt")
            public void testImproperElseInExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/improperElseInExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("jumpAcrossFunctionBoundary.kt")
            public void testJumpAcrossFunctionBoundary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/jumpAcrossFunctionBoundary.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10322.kt")
            public void testKt10322() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/kt10322.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10706.kt")
            public void testKt10706() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/kt10706.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10717.kt")
            public void testKt10717() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/kt10717.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1075.kt")
            public void testKt1075() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/kt1075.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4310.kt")
            public void testKt4310() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/kt4310.kt");
                doTest(fileName);
            }

            @TestMetadata("kt657.kt")
            public void testKt657() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/kt657.kt");
                doTest(fileName);
            }

            @TestMetadata("kt770.kt351.kt735_StatementType.kt")
            public void testKt770_kt351_kt735_StatementType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/kt770.kt351.kt735_StatementType.kt");
                doTest(fileName);
            }

            @TestMetadata("kt786.kt")
            public void testKt786() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/kt786.kt");
                doTest(fileName);
            }

            @TestMetadata("kt799.kt")
            public void testKt799() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/kt799.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdasInExclExclAndElvis.kt")
            public void testLambdasInExclExclAndElvis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/lambdasInExclExclAndElvis.kt");
                doTest(fileName);
            }

            @TestMetadata("specialConstructsAndPlatformTypes.kt")
            public void testSpecialConstructsAndPlatformTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/specialConstructsAndPlatformTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("specialConstructsWithNullableExpectedType.kt")
            public void testSpecialConstructsWithNullableExpectedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/specialConstructsWithNullableExpectedType.kt");
                doTest(fileName);
            }

            @TestMetadata("tryReturnType.kt")
            public void testTryReturnType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/tryReturnType.kt");
                doTest(fileName);
            }

            @TestMetadata("typeInferenceForExclExcl.kt")
            public void testTypeInferenceForExclExcl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/typeInferenceForExclExcl.kt");
                doTest(fileName);
            }

            @TestMetadata("valVarCatchParameter.kt")
            public void testValVarCatchParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/valVarCatchParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("valVarLoopParameter.kt")
            public void testValVarLoopParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/valVarLoopParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("whenInResultOfLambda.kt")
            public void testWhenInResultOfLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/whenInResultOfLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("whenToAnyDiscriminatingUsages.kt")
            public void testWhenToAnyDiscriminatingUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/whenToAnyDiscriminatingUsages.kt");
                doTest(fileName);
            }

            @TestMetadata("when.kt234.kt973.kt")
            public void testWhen_kt234_kt973() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/controlStructures/when.kt234.kt973.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/coroutines")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Coroutines extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInCoroutines() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("coroutineApplicability.kt")
            public void testCoroutineApplicability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/coroutineApplicability.kt");
                doTest(fileName);
            }

            @TestMetadata("interceptResume.kt")
            public void testInterceptResume() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/interceptResume.kt");
                doTest(fileName);
            }

            @TestMetadata("irrelevantSuspendDeclarations.kt")
            public void testIrrelevantSuspendDeclarations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/irrelevantSuspendDeclarations.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaExpectedType.kt")
            public void testLambdaExpectedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/lambdaExpectedType.kt");
                doTest(fileName);
            }

            @TestMetadata("manyHandleResults.kt")
            public void testManyHandleResults() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/manyHandleResults.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLocalSuspension.kt")
            public void testNonLocalSuspension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/nonLocalSuspension.kt");
                doTest(fileName);
            }

            @TestMetadata("suspendApplicability.kt")
            public void testSuspendApplicability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/suspendApplicability.kt");
                doTest(fileName);
            }

            @TestMetadata("suspendExtensionFunctions.kt")
            public void testSuspendExtensionFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/suspendExtensionFunctions.kt");
                doTest(fileName);
            }

            @TestMetadata("suspendFunctions.kt")
            public void testSuspendFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/suspendFunctions.kt");
                doTest(fileName);
            }

            @TestMetadata("tryCatchLambda.kt")
            public void testTryCatchLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/tryCatchLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("unsupported.kt")
            public void testUnsupported() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/unsupported.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongHandleException.kt")
            public void testWrongHandleException() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/wrongHandleException.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongHandleResult.kt")
            public void testWrongHandleResult() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/coroutines/wrongHandleResult.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CyclicHierarchy extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInCyclicHierarchy() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/cyclicHierarchy"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classIndirectlyInheritsNested.kt")
            public void testClassIndirectlyInheritsNested() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/classIndirectlyInheritsNested.kt");
                doTest(fileName);
            }

            @TestMetadata("classInheritsNested.kt")
            public void testClassInheritsNested() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/classInheritsNested.kt");
                doTest(fileName);
            }

            @TestMetadata("cyclicHierarchy.kt")
            public void testCyclicHierarchy() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/cyclicHierarchy.kt");
                doTest(fileName);
            }

            @TestMetadata("javaJavaCycle.kt")
            public void testJavaJavaCycle() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/javaJavaCycle.kt");
                doTest(fileName);
            }

            @TestMetadata("javaJavaNested.kt")
            public void testJavaJavaNested() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/javaJavaNested.kt");
                doTest(fileName);
            }

            @TestMetadata("javaKotlinJavaCycle.kt")
            public void testJavaKotlinJavaCycle() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/javaKotlinJavaCycle.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinJavaCycle.kt")
            public void testKotlinJavaCycle() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaCycle.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinJavaKotlinCycle.kt")
            public void testKotlinJavaKotlinCycle() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaKotlinCycle.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinJavaNestedCycle.kt")
            public void testKotlinJavaNestedCycle() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaNestedCycle.kt");
                doTest(fileName);
            }

            @TestMetadata("kt303.kt")
            public void testKt303() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/kt303.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClassInSuperClassParameter.kt")
            public void testNestedClassInSuperClassParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/nestedClassInSuperClassParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("twoClassesWithNestedCycle.kt")
            public void testTwoClassesWithNestedCycle() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/twoClassesWithNestedCycle.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/dataClasses")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DataClasses extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInDataClasses() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("componentNamedComponent1.kt")
            public void testComponentNamedComponent1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/componentNamedComponent1.kt");
                doTest(fileName);
            }

            @TestMetadata("conflictingCopyOverloads.kt")
            public void testConflictingCopyOverloads() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/conflictingCopyOverloads.kt");
                doTest(fileName);
            }

            @TestMetadata("conflictingOverloads.kt")
            public void testConflictingOverloads() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/conflictingOverloads.kt");
                doTest(fileName);
            }

            @TestMetadata("copyOfPrivateClass.kt")
            public void testCopyOfPrivateClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/copyOfPrivateClass.kt");
                doTest(fileName);
            }

            @TestMetadata("dataClassNoName.kt")
            public void testDataClassNoName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/dataClassNoName.kt");
                doTest(fileName);
            }

            @TestMetadata("dataClassVarargParam.kt")
            public void testDataClassVarargParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/dataClassVarargParam.kt");
                doTest(fileName);
            }

            @TestMetadata("dataInheritance.kt")
            public void testDataInheritance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/dataInheritance.kt");
                doTest(fileName);
            }

            @TestMetadata("dataObject.kt")
            public void testDataObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/dataObject.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyConstructor.kt")
            public void testEmptyConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/emptyConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionComponentsOnNullable.kt")
            public void testExtensionComponentsOnNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/extensionComponentsOnNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("finalMembersInBaseClass.kt")
            public void testFinalMembersInBaseClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/finalMembersInBaseClass.kt");
                doTest(fileName);
            }

            @TestMetadata("implementMethodsFromInterface.kt")
            public void testImplementMethodsFromInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/implementMethodsFromInterface.kt");
                doTest(fileName);
            }

            @TestMetadata("implementTraitWhichHasComponent1.kt")
            public void testImplementTraitWhichHasComponent1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/implementTraitWhichHasComponent1.kt");
                doTest(fileName);
            }

            @TestMetadata("implementTraitWhichHasFinalComponent1.kt")
            public void testImplementTraitWhichHasFinalComponent1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/implementTraitWhichHasFinalComponent1.kt");
                doTest(fileName);
            }

            @TestMetadata("innerDataClass.kt")
            public void testInnerDataClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/innerDataClass.kt");
                doTest(fileName);
            }

            @TestMetadata("innerOuterDataClass.kt")
            public void testInnerOuterDataClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/innerOuterDataClass.kt");
                doTest(fileName);
            }

            @TestMetadata("multiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/multiDeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("multiDeclarationFor.kt")
            public void testMultiDeclarationFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/multiDeclarationFor.kt");
                doTest(fileName);
            }

            @TestMetadata("noConstructor.kt")
            public void testNoConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/noConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("notADataClass.kt")
            public void testNotADataClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/notADataClass.kt");
                doTest(fileName);
            }

            @TestMetadata("oneValParam.kt")
            public void testOneValParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/oneValParam.kt");
                doTest(fileName);
            }

            @TestMetadata("repeatedProperties.kt")
            public void testRepeatedProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/repeatedProperties.kt");
                doTest(fileName);
            }

            @TestMetadata("sealedDataClass.kt")
            public void testSealedDataClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/sealedDataClass.kt");
                doTest(fileName);
            }

            @TestMetadata("strange.kt")
            public void testStrange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/strange.kt");
                doTest(fileName);
            }

            @TestMetadata("twoValParams.kt")
            public void testTwoValParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/twoValParams.kt");
                doTest(fileName);
            }

            @TestMetadata("twoVarParams.kt")
            public void testTwoVarParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataClasses/twoVarParams.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/dataFlow")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DataFlow extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInDataFlow() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("CalleeExpression.kt")
            public void testCalleeExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/CalleeExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("EmptyIf.kt")
            public void testEmptyIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/EmptyIf.kt");
                doTest(fileName);
            }

            @TestMetadata("IsExpression.kt")
            public void testIsExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/IsExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("WhenSubject.kt")
            public void testWhenSubject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/WhenSubject.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/dataFlow/assignment")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Assignment extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInAssignment() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow/assignment"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("assignToNewVal.kt")
                public void testAssignToNewVal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/assignment/assignToNewVal.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt6118.kt")
                public void testKt6118() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/assignment/kt6118.kt");
                    doTest(fileName);
                }

                @TestMetadata("uninitializedValIsCheck.kt")
                public void testUninitializedValIsCheck() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/assignment/uninitializedValIsCheck.kt");
                    doTest(fileName);
                }

                @TestMetadata("uninitializedValNullability.kt")
                public void testUninitializedValNullability() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/assignment/uninitializedValNullability.kt");
                    doTest(fileName);
                }

                @TestMetadata("when.kt")
                public void testWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/assignment/when.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/dataFlow/local")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Local extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInLocal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow/local"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt2835.kt")
                public void testKt2835() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/kt2835.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalClassBase.kt")
                public void testLocalClassBase() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassBase.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalClassDefaultParameters.kt")
                public void testLocalClassDefaultParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDefaultParameters.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalClassDelegatedProperties.kt")
                public void testLocalClassDelegatedProperties() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDelegatedProperties.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalClassDelegation.kt")
                public void testLocalClassDelegation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDelegation.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalClassFunctions.kt")
                public void testLocalClassFunctions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassFunctions.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalClassInMemberOfLocalClass.kt")
                public void testLocalClassInMemberOfLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassInMemberOfLocalClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalClassInitializer.kt")
                public void testLocalClassInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassInitializer.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalClassProperty.kt")
                public void testLocalClassProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalObject.kt")
                public void testLocalObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/LocalObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalObjectDelegation.kt")
                public void testLocalObjectDelegation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/LocalObjectDelegation.kt");
                    doTest(fileName);
                }

                @TestMetadata("NestedLocalClass.kt")
                public void testNestedLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlow/local/NestedLocalClass.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DataFlowInfoTraversal extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInDataFlowInfoTraversal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlowInfoTraversal"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AndOr.kt")
            public void testAndOr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AndOr.kt");
                doTest(fileName);
            }

            @TestMetadata("ArrayAccess.kt")
            public void testArrayAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayAccess.kt");
                doTest(fileName);
            }

            @TestMetadata("ArrayExpression.kt")
            public void testArrayExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("ArrayGetSetConvention.kt")
            public void testArrayGetSetConvention() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayGetSetConvention.kt");
                doTest(fileName);
            }

            @TestMetadata("ArrayIndices.kt")
            public void testArrayIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("Assignment.kt")
            public void testAssignment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Assignment.kt");
                doTest(fileName);
            }

            @TestMetadata("AssignmentInInitializer.kt")
            public void testAssignmentInInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentInInitializer.kt");
                doTest(fileName);
            }

            @TestMetadata("AssignmentOperation.kt")
            public void testAssignmentOperation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentOperation.kt");
                doTest(fileName);
            }

            @TestMetadata("AssignmentToArrayElement.kt")
            public void testAssignmentToArrayElement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentToArrayElement.kt");
                doTest(fileName);
            }

            @TestMetadata("BinaryExpression.kt")
            public void testBinaryExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("BinaryExpressionBooleanOperations.kt")
            public void testBinaryExpressionBooleanOperations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionBooleanOperations.kt");
                doTest(fileName);
            }

            @TestMetadata("BinaryExpressionCompareToConvention.kt")
            public void testBinaryExpressionCompareToConvention() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionCompareToConvention.kt");
                doTest(fileName);
            }

            @TestMetadata("BinaryExpressionContainsConvention.kt")
            public void testBinaryExpressionContainsConvention() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionContainsConvention.kt");
                doTest(fileName);
            }

            @TestMetadata("BinaryExpressionElvis.kt")
            public void testBinaryExpressionElvis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionElvis.kt");
                doTest(fileName);
            }

            @TestMetadata("BinaryExpressionEqualsConvention.kt")
            public void testBinaryExpressionEqualsConvention() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionEqualsConvention.kt");
                doTest(fileName);
            }

            @TestMetadata("BinaryExpressionIdentifier.kt")
            public void testBinaryExpressionIdentifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionIdentifier.kt");
                doTest(fileName);
            }

            @TestMetadata("BinaryExpressionPlusConvention.kt")
            public void testBinaryExpressionPlusConvention() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionPlusConvention.kt");
                doTest(fileName);
            }

            @TestMetadata("Condition.kt")
            public void testCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Condition.kt");
                doTest(fileName);
            }

            @TestMetadata("ContinueOuterLoop.kt")
            public void testContinueOuterLoop() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ContinueOuterLoop.kt");
                doTest(fileName);
            }

            @TestMetadata("DeepIf.kt")
            public void testDeepIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DeepIf.kt");
                doTest(fileName);
            }

            @TestMetadata("DoWhile.kt")
            public void testDoWhile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DoWhile.kt");
                doTest(fileName);
            }

            @TestMetadata("DoWhileCondition.kt")
            public void testDoWhileCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DoWhileCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("Elvis.kt")
            public void testElvis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Elvis.kt");
                doTest(fileName);
            }

            @TestMetadata("ExclExcl.kt")
            public void testExclExcl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ExclExcl.kt");
                doTest(fileName);
            }

            @TestMetadata("For.kt")
            public void testFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/For.kt");
                doTest(fileName);
            }

            @TestMetadata("ForLoopRange.kt")
            public void testForLoopRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ForLoopRange.kt");
                doTest(fileName);
            }

            @TestMetadata("FunctionLiteral.kt")
            public void testFunctionLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/FunctionLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("IfStatement.kt")
            public void testIfStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("IfThenElse.kt")
            public void testIfThenElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfThenElse.kt");
                doTest(fileName);
            }

            @TestMetadata("IfThenElseBothInvalid.kt")
            public void testIfThenElseBothInvalid() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfThenElseBothInvalid.kt");
                doTest(fileName);
            }

            @TestMetadata("IsExpression.kt")
            public void testIsExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IsExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4332WhenBranches.kt")
            public void testKt4332WhenBranches() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt4332WhenBranches.kt");
                doTest(fileName);
            }

            @TestMetadata("kt5155WhenBranches.kt")
            public void testKt5155WhenBranches() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt5155WhenBranches.kt");
                doTest(fileName);
            }

            @TestMetadata("kt5182WhenBranches.kt")
            public void testKt5182WhenBranches() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt5182WhenBranches.kt");
                doTest(fileName);
            }

            @TestMetadata("ManyIfs.kt")
            public void testManyIfs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ManyIfs.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/MultiDeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("ObjectExpression.kt")
            public void testObjectExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ObjectExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("QualifiedExpression.kt")
            public void testQualifiedExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/QualifiedExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("Return.kt")
            public void testReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Return.kt");
                doTest(fileName);
            }

            @TestMetadata("StringTemplate.kt")
            public void testStringTemplate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/StringTemplate.kt");
                doTest(fileName);
            }

            @TestMetadata("ThisSuper.kt")
            public void testThisSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ThisSuper.kt");
                doTest(fileName);
            }

            @TestMetadata("Throw.kt")
            public void testThrow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Throw.kt");
                doTest(fileName);
            }

            @TestMetadata("TryCatch.kt")
            public void testTryCatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/TryCatch.kt");
                doTest(fileName);
            }

            @TestMetadata("TryFinally.kt")
            public void testTryFinally() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/TryFinally.kt");
                doTest(fileName);
            }

            @TestMetadata("UnaryExpression.kt")
            public void testUnaryExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/UnaryExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("When.kt")
            public void testWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/When.kt");
                doTest(fileName);
            }

            @TestMetadata("WhenEntryAs.kt")
            public void testWhenEntryAs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenEntryAs.kt");
                doTest(fileName);
            }

            @TestMetadata("WhenEntryIs.kt")
            public void testWhenEntryIs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenEntryIs.kt");
                doTest(fileName);
            }

            @TestMetadata("WhenIn.kt")
            public void testWhenIn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenIn.kt");
                doTest(fileName);
            }

            @TestMetadata("WhenSubject.kt")
            public void testWhenSubject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenSubject.kt");
                doTest(fileName);
            }

            @TestMetadata("While.kt")
            public void testWhile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/While.kt");
                doTest(fileName);
            }

            @TestMetadata("WhileCondition.kt")
            public void testWhileCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhileCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Smartcasts extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInSmartcasts() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("SmartcastAmbiguitites.kt")
                public void testSmartcastAmbiguitites() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts/SmartcastAmbiguitites.kt");
                    doTest(fileName);
                }

                @TestMetadata("SmartcastsForStableIdentifiers.kt")
                public void testSmartcastsForStableIdentifiers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts/SmartcastsForStableIdentifiers.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DeclarationChecks extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInDeclarationChecks() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ambiguousObjectExpressionType.kt")
            public void testAmbiguousObjectExpressionType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/ambiguousObjectExpressionType.kt");
                doTest(fileName);
            }

            @TestMetadata("anonymousFunAsLastExpressionInBlock.kt")
            public void testAnonymousFunAsLastExpressionInBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/anonymousFunAsLastExpressionInBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("anonymousFunUnusedLastExpressionInBlock.kt")
            public void testAnonymousFunUnusedLastExpressionInBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/anonymousFunUnusedLastExpressionInBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("ComponentFunctionReturnTypeMismatch.kt")
            public void testComponentFunctionReturnTypeMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/ComponentFunctionReturnTypeMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingAndRedundantProjections.kt")
            public void testConflictingAndRedundantProjections() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/ConflictingAndRedundantProjections.kt");
                doTest(fileName);
            }

            @TestMetadata("DataFlowInMultiDeclInFor.kt")
            public void testDataFlowInMultiDeclInFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/DataFlowInMultiDeclInFor.kt");
                doTest(fileName);
            }

            @TestMetadata("DataFlowInfoInMultiDecl.kt")
            public void testDataFlowInfoInMultiDecl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/DataFlowInfoInMultiDecl.kt");
                doTest(fileName);
            }

            @TestMetadata("FunctionWithMissingNames.kt")
            public void testFunctionWithMissingNames() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/FunctionWithMissingNames.kt");
                doTest(fileName);
            }

            @TestMetadata("illegalModifiersOnClass.kt")
            public void testIllegalModifiersOnClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/illegalModifiersOnClass.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1141.kt")
            public void testKt1141() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/kt1141.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1193.kt")
            public void testKt1193() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/kt1193.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2096.kt")
            public void testKt2096() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/kt2096.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2142.kt")
            public void testKt2142() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/kt2142.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2397.kt")
            public void testKt2397() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/kt2397.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2631_MultipleDeclaration.kt")
            public void testKt2631_MultipleDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/kt2631_MultipleDeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2643MultiDeclInControlFlow.kt")
            public void testKt2643MultiDeclInControlFlow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/kt2643MultiDeclInControlFlow.kt");
                doTest(fileName);
            }

            @TestMetadata("kt559.kt")
            public void testKt559() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/kt559.kt");
                doTest(fileName);
            }

            @TestMetadata("localDeclarationModifiers.kt")
            public void testLocalDeclarationModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/localDeclarationModifiers.kt");
                doTest(fileName);
            }

            @TestMetadata("localFunctionNoInheritVisibility.kt")
            public void testLocalFunctionNoInheritVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/localFunctionNoInheritVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("LocalVariableWithNoTypeInformation.kt")
            public void testLocalVariableWithNoTypeInformation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/LocalVariableWithNoTypeInformation.kt");
                doTest(fileName);
            }

            @TestMetadata("mulitpleVarargParameters.kt")
            public void testMulitpleVarargParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/mulitpleVarargParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDeclarationErrors.kt")
            public void testMultiDeclarationErrors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/MultiDeclarationErrors.kt");
                doTest(fileName);
            }

            @TestMetadata("namedFunAsLastExpressionInBlock.kt")
            public void testNamedFunAsLastExpressionInBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/namedFunAsLastExpressionInBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("packageDeclarationModifiers.kt")
            public void testPackageDeclarationModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/packageDeclarationModifiers.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyInPackageHasNoInheritVisibility.kt")
            public void testPropertyInPackageHasNoInheritVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/propertyInPackageHasNoInheritVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("RedeclarationsInMultiDecl.kt")
            public void testRedeclarationsInMultiDecl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/RedeclarationsInMultiDecl.kt");
                doTest(fileName);
            }

            @TestMetadata("ScalaLikeNamedFun.kt")
            public void testScalaLikeNamedFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/ScalaLikeNamedFun.kt");
                doTest(fileName);
            }

            @TestMetadata("sealedOnMembers.kt")
            public void testSealedOnMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/sealedOnMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("unambiguousObjectExpressionType.kt")
            public void testUnambiguousObjectExpressionType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/unambiguousObjectExpressionType.kt");
                doTest(fileName);
            }

            @TestMetadata("valVarFunctionParameter.kt")
            public void testValVarFunctionParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/valVarFunctionParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("VarianceOnFunctionAndPropertyTypeParameters.kt")
            public void testVarianceOnFunctionAndPropertyTypeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/VarianceOnFunctionAndPropertyTypeParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DestructuringDeclarations extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInDestructuringDeclarations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("destructuringDeclarationAssignedUnresolved.kt")
                public void testDestructuringDeclarationAssignedUnresolved() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/destructuringDeclarationAssignedUnresolved.kt");
                    doTest(fileName);
                }

                @TestMetadata("destructuringDeclarationMissingInitializer.kt")
                public void testDestructuringDeclarationMissingInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/destructuringDeclarationMissingInitializer.kt");
                    doTest(fileName);
                }

                @TestMetadata("DoubleDeclForLoop.kt")
                public void testDoubleDeclForLoop() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/DoubleDeclForLoop.kt");
                    doTest(fileName);
                }

                @TestMetadata("FolLoopTypeComponentTypeMismatch.kt")
                public void testFolLoopTypeComponentTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/FolLoopTypeComponentTypeMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("ForLoopComponentFunctionAmbiguity.kt")
                public void testForLoopComponentFunctionAmbiguity() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopComponentFunctionAmbiguity.kt");
                    doTest(fileName);
                }

                @TestMetadata("ForLoopComponentFunctionMissing.kt")
                public void testForLoopComponentFunctionMissing() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopComponentFunctionMissing.kt");
                    doTest(fileName);
                }

                @TestMetadata("ForLoopMissingLoopParameter.kt")
                public void testForLoopMissingLoopParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopMissingLoopParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("ForLoopWithExtensions.kt")
                public void testForLoopWithExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopWithExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("ForWithExplicitTypes.kt")
                public void testForWithExplicitTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForWithExplicitTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2829.kt")
                public void testKt2829() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/kt2829.kt");
                    doTest(fileName);
                }

                @TestMetadata("RedeclarationInForLoop.kt")
                public void testRedeclarationInForLoop() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/RedeclarationInForLoop.kt");
                    doTest(fileName);
                }

                @TestMetadata("SingleDeclForLoop.kt")
                public void testSingleDeclForLoop() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/SingleDeclForLoop.kt");
                    doTest(fileName);
                }

                @TestMetadata("underscore.kt")
                public void testUnderscore() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/underscore.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FiniteBoundRestriction extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInFiniteBoundRestriction() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("CasesWithOneTypeParameter.kt")
                public void testCasesWithOneTypeParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/CasesWithOneTypeParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("CasesWithTwoTypeParameters.kt")
                public void testCasesWithTwoTypeParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/CasesWithTwoTypeParameters.kt");
                    doTest(fileName);
                }

                @TestMetadata("JavaSuperType.kt")
                public void testJavaSuperType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/JavaSuperType.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NonExpansiveInheritanceRestriction extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInNonExpansiveInheritanceRestriction() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("JavaWithKotlin.kt")
                public void testJavaWithKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/JavaWithKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("JavaWithKotlin2.kt")
                public void testJavaWithKotlin2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/JavaWithKotlin2.kt");
                    doTest(fileName);
                }

                @TestMetadata("PureKotlin.kt")
                public void testPureKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/PureKotlin.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/defaultArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultArguments extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInDefaultArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kt5232.kt")
            public void testKt5232() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/defaultArguments/kt5232.kt");
                doTest(fileName);
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/defaultArguments/superCall.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DelegatedProperty extends AbstractDiagnosticsTest {
            @TestMetadata("absentErrorAboutInitializer.kt")
            public void testAbsentErrorAboutInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/absentErrorAboutInitializer.kt");
                doTest(fileName);
            }

            @TestMetadata("absentErrorAboutType.kt")
            public void testAbsentErrorAboutType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/absentErrorAboutType.kt");
                doTest(fileName);
            }

            @TestMetadata("abstractDelegatedProperty.kt")
            public void testAbstractDelegatedProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/abstractDelegatedProperty.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInDelegatedProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("backingField.kt")
            public void testBackingField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/backingField.kt");
                doTest(fileName);
            }

            @TestMetadata("defaultGetter.kt")
            public void testDefaultGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/defaultGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("defaultSetter.kt")
            public void testDefaultSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/defaultSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("delegatedPropertyOverridedInTrait.kt")
            public void testDelegatedPropertyOverridedInTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/delegatedPropertyOverridedInTrait.kt");
                doTest(fileName);
            }

            @TestMetadata("delegatedPropertyOverridedInTraitTypeMismatch.kt")
            public void testDelegatedPropertyOverridedInTraitTypeMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/delegatedPropertyOverridedInTraitTypeMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("disallowImplInTypeParameter.kt")
            public void testDisallowImplInTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/disallowImplInTypeParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("genericGetter.kt")
            public void testGenericGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/genericGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("getterWithSubtype.kt")
            public void testGetterWithSubtype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/getterWithSubtype.kt");
                doTest(fileName);
            }

            @TestMetadata("inTrait.kt")
            public void testInTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inTrait.kt");
                doTest(fileName);
            }

            @TestMetadata("incompleteTypeInference.kt")
            public void testIncompleteTypeInference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/incompleteTypeInference.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4640.kt")
            public void testKt4640() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/kt4640.kt");
                doTest(fileName);
            }

            @TestMetadata("localVariable.kt")
            public void testLocalVariable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/localVariable.kt");
                doTest(fileName);
            }

            @TestMetadata("localWithSmartCast.kt")
            public void testLocalWithSmartCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/localWithSmartCast.kt");
                doTest(fileName);
            }

            @TestMetadata("missedGetter.kt")
            public void testMissedGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/missedGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("missedSetter.kt")
            public void testMissedSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/missedSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("nonDefaultAccessors.kt")
            public void testNonDefaultAccessors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/nonDefaultAccessors.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyDefferedType.kt")
            public void testPropertyDefferedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/propertyDefferedType.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyDelegatedAmbiguity.kt")
            public void testPropertyDelegatedAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/propertyDelegatedAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyDelegatedIncomplete.kt")
            public void testPropertyDelegatedIncomplete() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/propertyDelegatedIncomplete.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyDelegatedMissing.kt")
            public void testPropertyDelegatedMissing() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/propertyDelegatedMissing.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyDelegatedPrivate.kt")
            public void testPropertyDelegatedPrivate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/propertyDelegatedPrivate.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyDelegatedWrongArguments.kt")
            public void testPropertyDelegatedWrongArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/propertyDelegatedWrongArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("recursiveType.kt")
            public void testRecursiveType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/recursiveType.kt");
                doTest(fileName);
            }

            @TestMetadata("redundantGetter.kt")
            public void testRedundantGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/redundantGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("redundantSetter.kt")
            public void testRedundantSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/redundantSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("setterThisTypeMismatch.kt")
            public void testSetterThisTypeMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/setterThisTypeMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("setterWithSupertype.kt")
            public void testSetterWithSupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/setterWithSupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("thisInDelegate.kt")
            public void testThisInDelegate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/thisInDelegate.kt");
                doTest(fileName);
            }

            @TestMetadata("thisOfAnyType.kt")
            public void testThisOfAnyType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/thisOfAnyType.kt");
                doTest(fileName);
            }

            @TestMetadata("thisOfNothingNullableType.kt")
            public void testThisOfNothingNullableType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/thisOfNothingNullableType.kt");
                doTest(fileName);
            }

            @TestMetadata("thisOfNothingType.kt")
            public void testThisOfNothingType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/thisOfNothingType.kt");
                doTest(fileName);
            }

            @TestMetadata("twoGetMethods.kt")
            public void testTwoGetMethods() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/twoGetMethods.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatchForGetReturnType.kt")
            public void testTypeMismatchForGetReturnType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForGetReturnType.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatchForGetWithGeneric.kt")
            public void testTypeMismatchForGetWithGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForGetWithGeneric.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatchForSetParameter.kt")
            public void testTypeMismatchForSetParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForSetParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatchForThisGetParameter.kt")
            public void testTypeMismatchForThisGetParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForThisGetParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongCountOfParametersInGet.kt")
            public void testWrongCountOfParametersInGet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/wrongCountOfParametersInGet.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongCountOfParametersInSet.kt")
            public void testWrongCountOfParametersInSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/wrongCountOfParametersInSet.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongSetterReturnType.kt")
            public void testWrongSetterReturnType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/wrongSetterReturnType.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inference extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInInference() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty/inference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("differentDelegatedExpressions.kt")
                public void testDifferentDelegatedExpressions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/differentDelegatedExpressions.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionGet.kt")
                public void testExtensionGet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/extensionGet.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionProperty.kt")
                public void testExtensionProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/extensionProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericMethodInGenericClass.kt")
                public void testGenericMethodInGenericClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/genericMethodInGenericClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericMethods.kt")
                public void testGenericMethods() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/genericMethods.kt");
                    doTest(fileName);
                }

                @TestMetadata("labeledDelegatedExpression.kt")
                public void testLabeledDelegatedExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/labeledDelegatedExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("manyIncompleteCandidates.kt")
                public void testManyIncompleteCandidates() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/manyIncompleteCandidates.kt");
                    doTest(fileName);
                }

                @TestMetadata("noErrorsForImplicitConstraints.kt")
                public void testNoErrorsForImplicitConstraints() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/noErrorsForImplicitConstraints.kt");
                    doTest(fileName);
                }

                @TestMetadata("noExpectedTypeForSupertypeConstraint.kt")
                public void testNoExpectedTypeForSupertypeConstraint() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/noExpectedTypeForSupertypeConstraint.kt");
                    doTest(fileName);
                }

                @TestMetadata("useCompleterWithoutExpectedType.kt")
                public void testUseCompleterWithoutExpectedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/useCompleterWithoutExpectedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("useExpectedType.kt")
                public void testUseExpectedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/useExpectedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("useExpectedTypeForVal.kt")
                public void testUseExpectedTypeForVal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference/useExpectedTypeForVal.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/delegation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Delegation extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInDelegation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("DelegationAndOverriding.kt")
            public void testDelegationAndOverriding() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/DelegationAndOverriding.kt");
                doTest(fileName);
            }

            @TestMetadata("DelegationExpectedType.kt")
            public void testDelegationExpectedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/DelegationExpectedType.kt");
                doTest(fileName);
            }

            @TestMetadata("DelegationNotTotrait.kt")
            public void testDelegationNotTotrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/DelegationNotTotrait.kt");
                doTest(fileName);
            }

            @TestMetadata("DelegationToJavaIface.kt")
            public void testDelegationToJavaIface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/DelegationToJavaIface.kt");
                doTest(fileName);
            }

            @TestMetadata("Delegation_ClashingFunctions.kt")
            public void testDelegation_ClashingFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/Delegation_ClashingFunctions.kt");
                doTest(fileName);
            }

            @TestMetadata("Delegation_Hierarchy.kt")
            public void testDelegation_Hierarchy() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/Delegation_Hierarchy.kt");
                doTest(fileName);
            }

            @TestMetadata("Delegation_MultipleDelegates.kt")
            public void testDelegation_MultipleDelegates() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/Delegation_MultipleDelegates.kt");
                doTest(fileName);
            }

            @TestMetadata("Delegation_ScopeInitializationOrder.kt")
            public void testDelegation_ScopeInitializationOrder() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/Delegation_ScopeInitializationOrder.kt");
                doTest(fileName);
            }

            @TestMetadata("kt8154.kt")
            public void testKt8154() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/kt8154.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/delegation/clashes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Clashes extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInClashes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/clashes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("finalMemberOverridden.kt")
                public void testFinalMemberOverridden() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/clashes/finalMemberOverridden.kt");
                    doTest(fileName);
                }

                @TestMetadata("propertyTypeMismatch.kt")
                public void testPropertyTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/clashes/propertyTypeMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnTypeMismatch.kt")
                public void testReturnTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/clashes/returnTypeMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("varOverriddenByVal.kt")
                public void testVarOverriddenByVal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/clashes/varOverriddenByVal.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/delegation/covariantOverrides")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CovariantOverrides extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInCovariantOverrides() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/covariantOverrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("fromClass.kt")
                public void testFromClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/covariantOverrides/fromClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("irrelevant.kt")
                public void testIrrelevant() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/covariantOverrides/irrelevant.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt13952.kt")
                public void testKt13952() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/covariantOverrides/kt13952.kt");
                    doTest(fileName);
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/delegation/covariantOverrides/simple.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/deparenthesize")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Deparenthesize extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInDeparenthesize() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/deparenthesize"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotatedSafeCall.kt")
            public void testAnnotatedSafeCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deparenthesize/annotatedSafeCall.kt");
                doTest(fileName);
            }

            @TestMetadata("checkDeparenthesizedType.kt")
            public void testCheckDeparenthesizedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deparenthesize/checkDeparenthesizedType.kt");
                doTest(fileName);
            }

            @TestMetadata("labeledSafeCall.kt")
            public void testLabeledSafeCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deparenthesize/labeledSafeCall.kt");
                doTest(fileName);
            }

            @TestMetadata("multiParenthesizedSafeCall.kt")
            public void testMultiParenthesizedSafeCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deparenthesize/multiParenthesizedSafeCall.kt");
                doTest(fileName);
            }

            @TestMetadata("parenthesizedSafeCall.kt")
            public void testParenthesizedSafeCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deparenthesize/parenthesizedSafeCall.kt");
                doTest(fileName);
            }

            @TestMetadata("ParenthesizedVariable.kt")
            public void testParenthesizedVariable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deparenthesize/ParenthesizedVariable.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/deprecated")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Deprecated extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInDeprecated() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/deprecated"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotationUsage.kt")
            public void testAnnotationUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/annotationUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("classWithCompanionObject.kt")
            public void testClassWithCompanionObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/classWithCompanionObject.kt");
                doTest(fileName);
            }

            @TestMetadata("companionObjectUsage.kt")
            public void testCompanionObjectUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/companionObjectUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("componentUsage.kt")
            public void testComponentUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/componentUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("deprecatedConstructor.kt")
            public void testDeprecatedConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/deprecatedConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("deprecatedError.kt")
            public void testDeprecatedError() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/deprecatedError.kt");
                doTest(fileName);
            }

            @TestMetadata("deprecatedErrorBuilder.kt")
            public void testDeprecatedErrorBuilder() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/deprecatedErrorBuilder.kt");
                doTest(fileName);
            }

            @TestMetadata("deprecatedHidden.kt")
            public void testDeprecatedHidden() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/deprecatedHidden.kt");
                doTest(fileName);
            }

            @TestMetadata("deprecatedInheritance.kt")
            public void testDeprecatedInheritance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/deprecatedInheritance.kt");
                doTest(fileName);
            }

            @TestMetadata("deprecatedPropertyInheritance.kt")
            public void testDeprecatedPropertyInheritance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/deprecatedPropertyInheritance.kt");
                doTest(fileName);
            }

            @TestMetadata("functionUsage.kt")
            public void testFunctionUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/functionUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("genericConstructorUsage.kt")
            public void testGenericConstructorUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/genericConstructorUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("hiddenPropertyAccessors.kt")
            public void testHiddenPropertyAccessors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/hiddenPropertyAccessors.kt");
                doTest(fileName);
            }

            @TestMetadata("importJavaSamInterface.kt")
            public void testImportJavaSamInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/importJavaSamInterface.kt");
                doTest(fileName);
            }

            @TestMetadata("imports.kt")
            public void testImports() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/imports.kt");
                doTest(fileName);
            }

            @TestMetadata("iteratorUsage.kt")
            public void testIteratorUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/iteratorUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("javaDeprecated.kt")
            public void testJavaDeprecated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/javaDeprecated.kt");
                doTest(fileName);
            }

            @TestMetadata("javaDeprecatedInheritance.kt")
            public void testJavaDeprecatedInheritance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/javaDeprecatedInheritance.kt");
                doTest(fileName);
            }

            @TestMetadata("javaDocDeprecated.kt")
            public void testJavaDocDeprecated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/javaDocDeprecated.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedTypesUsage.kt")
            public void testNestedTypesUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/nestedTypesUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("objectUsage.kt")
            public void testObjectUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/objectUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyUsage.kt")
            public void testPropertyUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/propertyUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyUseSiteTargetedAnnotations.kt")
            public void testPropertyUseSiteTargetedAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/propertyUseSiteTargetedAnnotations.kt");
                doTest(fileName);
            }

            @TestMetadata("typeUsage.kt")
            public void testTypeUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/typeUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("typealiasConstructor.kt")
            public void testTypealiasConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/typealiasConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("typealiasUsage.kt")
            public void testTypealiasUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/typealiasUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("unusedImport.kt")
            public void testUnusedImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/deprecated/unusedImport.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DuplicateJvmSignature extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInDuplicateJvmSignature() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("caseInProperties.kt")
            public void testCaseInProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/caseInProperties.kt");
                doTest(fileName);
            }

            @TestMetadata("missingNames.kt")
            public void testMissingNames() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/missingNames.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/vararg.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AccidentalOverrides extends AbstractDiagnosticsTest {
                @TestMetadata("accidentalOverrideFromGrandparent.kt")
                public void testAccidentalOverrideFromGrandparent() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/accidentalOverrideFromGrandparent.kt");
                    doTest(fileName);
                }

                public void testAllFilesPresentInAccidentalOverrides() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classFunctionOverriddenByProperty.kt")
                public void testClassFunctionOverriddenByProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("classFunctionOverriddenByPropertyInConstructor.kt")
                public void testClassFunctionOverriddenByPropertyInConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyInConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("classFunctionOverriddenByPropertyNoGetter.kt")
                public void testClassFunctionOverriddenByPropertyNoGetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyNoGetter.kt");
                    doTest(fileName);
                }

                @TestMetadata("classPropertyOverriddenByFunction.kt")
                public void testClassPropertyOverriddenByFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classPropertyOverriddenByFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("defaultFunction.kt")
                public void testDefaultFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/defaultFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegatedFunctionOverriddenByProperty.kt")
                public void testDelegatedFunctionOverriddenByProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/delegatedFunctionOverriddenByProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericClassFunction.kt")
                public void testGenericClassFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/genericClassFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("overridesNothing.kt")
                public void testOverridesNothing() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/overridesNothing.kt");
                    doTest(fileName);
                }

                @TestMetadata("privateClassFunctionOverriddenByProperty.kt")
                public void testPrivateClassFunctionOverriddenByProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/privateClassFunctionOverriddenByProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("require.kt")
                public void testRequire() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/require.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitFunctionOverriddenByProperty.kt")
                public void testTraitFunctionOverriddenByProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitFunctionOverriddenByPropertyNoImpl.kt")
                public void testTraitFunctionOverriddenByPropertyNoImpl() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByPropertyNoImpl.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitPropertyOverriddenByFunction.kt")
                public void testTraitPropertyOverriddenByFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitPropertyOverriddenByFunctionNoImpl.kt")
                public void testTraitPropertyOverriddenByFunctionNoImpl() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunctionNoImpl.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Bridges extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInBridges() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("class.kt")
                public void testClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges/class.kt");
                    doTest(fileName);
                }

                @TestMetadata("fakeOverrideTrait.kt")
                public void testFakeOverrideTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges/fakeOverrideTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("trait.kt")
                public void testTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges/trait.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Erasure extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInErasure() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("clashFromInterfaceAndSuperClass.kt")
                public void testClashFromInterfaceAndSuperClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/clashFromInterfaceAndSuperClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("collections.kt")
                public void testCollections() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/collections.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegateToTwoTraits.kt")
                public void testDelegateToTwoTraits() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/delegateToTwoTraits.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegationAndOwnMethod.kt")
                public void testDelegationAndOwnMethod() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/delegationAndOwnMethod.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegationToTraitImplAndOwnMethod.kt")
                public void testDelegationToTraitImplAndOwnMethod() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/delegationToTraitImplAndOwnMethod.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionProperties.kt")
                public void testExtensionProperties() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/extensionProperties.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericType.kt")
                public void testGenericType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/genericType.kt");
                    doTest(fileName);
                }

                @TestMetadata("inheritFromTwoTraits.kt")
                public void testInheritFromTwoTraits() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/inheritFromTwoTraits.kt");
                    doTest(fileName);
                }

                @TestMetadata("kotlinAndJavaCollections.kt")
                public void testKotlinAndJavaCollections() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/kotlinAndJavaCollections.kt");
                    doTest(fileName);
                }

                @TestMetadata("nullableType.kt")
                public void testNullableType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/nullableType.kt");
                    doTest(fileName);
                }

                @TestMetadata("superTraitAndDelegationToTraitImpl.kt")
                public void testSuperTraitAndDelegationToTraitImpl() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/superTraitAndDelegationToTraitImpl.kt");
                    doTest(fileName);
                }

                @TestMetadata("twoTraitsAndOwnFunction.kt")
                public void testTwoTraitsAndOwnFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/twoTraitsAndOwnFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeMappedToJava.kt")
                public void testTypeMappedToJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeMappedToJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeParameter.kt")
                public void testTypeParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeParameterWithBound.kt")
                public void testTypeParameterWithBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameterWithBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeParameterWithTwoBounds.kt")
                public void testTypeParameterWithTwoBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameterWithTwoBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeParameterWithTwoBoundsInWhere.kt")
                public void testTypeParameterWithTwoBoundsInWhere() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameterWithTwoBoundsInWhere.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FinalMembersFromBuiltIns extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInFinalMembersFromBuiltIns() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("enumMembers.kt")
                public void testEnumMembers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns/enumMembers.kt");
                    doTest(fileName);
                }

                @TestMetadata("waitNotifyGetClass.kt")
                public void testWaitNotifyGetClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns/waitNotifyGetClass.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FunctionAndProperty extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInFunctionAndProperty() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("class.kt")
                public void testClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/class.kt");
                    doTest(fileName);
                }

                @TestMetadata("classObject.kt")
                public void testClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/classObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("classPropertyInConstructor.kt")
                public void testClassPropertyInConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/classPropertyInConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionFunctionAndNormalFunction.kt")
                public void testExtensionFunctionAndNormalFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/extensionFunctionAndNormalFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionPropertyAndFunction.kt")
                public void testExtensionPropertyAndFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/extensionPropertyAndFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionAndSetter.kt")
                public void testFunctionAndSetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/functionAndSetter.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionAndVar.kt")
                public void testFunctionAndVar() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/functionAndVar.kt");
                    doTest(fileName);
                }

                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/localClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("localClassInClass.kt")
                public void testLocalClassInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/localClassInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedClass.kt")
                public void testNestedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/nestedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("object.kt")
                public void testObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/object.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectExpression.kt")
                public void testObjectExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/objectExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectExpressionInConstructor.kt")
                public void testObjectExpressionInConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/objectExpressionInConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("privateClassPropertyNoClash.kt")
                public void testPrivateClassPropertyNoClash() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/privateClassPropertyNoClash.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevel.kt")
                public void testTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/topLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelDifferentFiles.kt")
                public void testTopLevelDifferentFiles() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/topLevelDifferentFiles.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelGetter.kt")
                public void testTopLevelGetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/topLevelGetter.kt");
                    doTest(fileName);
                }

                @TestMetadata("trait.kt")
                public void testTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/trait.kt");
                    doTest(fileName);
                }

                @TestMetadata("withErrorTypes.kt")
                public void testWithErrorTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/withErrorTypes.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SpecialNames extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInSpecialNames() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classObject.kt")
                public void testClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/classObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("classObjectCopiedField.kt")
                public void testClassObjectCopiedField() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/classObjectCopiedField.kt");
                    doTest(fileName);
                }

                @TestMetadata("classObjectCopiedFieldObject.kt")
                public void testClassObjectCopiedFieldObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/classObjectCopiedFieldObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("dataClassCopy.kt")
                public void testDataClassCopy() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/dataClassCopy.kt");
                    doTest(fileName);
                }

                @TestMetadata("defaults.kt")
                public void testDefaults() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/defaults.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegationBy.kt")
                public void testDelegationBy() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/delegationBy.kt");
                    doTest(fileName);
                }

                @TestMetadata("enum.kt")
                public void testEnum() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/enum.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerClassField.kt")
                public void testInnerClassField() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/innerClassField.kt");
                    doTest(fileName);
                }

                @TestMetadata("instance.kt")
                public void testInstance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/instance.kt");
                    doTest(fileName);
                }

                @TestMetadata("propertyMetadataCache.kt")
                public void testPropertyMetadataCache() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/propertyMetadataCache.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Statics extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInStatics() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("jjk.kt")
                public void testJjk() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/jjk.kt");
                    doTest(fileName);
                }

                @TestMetadata("jk.kt")
                public void testJk() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/jk.kt");
                    doTest(fileName);
                }

                @TestMetadata("jkjk.kt")
                public void testJkjk() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/jkjk.kt");
                    doTest(fileName);
                }

                @TestMetadata("kotlinMembersVsJavaNonVisibleStatics.kt")
                public void testKotlinMembersVsJavaNonVisibleStatics() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinMembersVsJavaNonVisibleStatics.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/synthesized")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Synthesized extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInSynthesized() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/synthesized"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("enumValuesValueOf.kt")
                public void testEnumValuesValueOf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/synthesized/enumValuesValueOf.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TraitImpl extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInTraitImpl() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("oneTrait.kt")
                public void testOneTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/oneTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitFunctionOverriddenByPropertyInTrait.kt")
                public void testTraitFunctionOverriddenByPropertyInTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/traitFunctionOverriddenByPropertyInTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitPropertyOverriddenByFunctionInTrait.kt")
                public void testTraitPropertyOverriddenByFunctionInTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/traitPropertyOverriddenByFunctionInTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("twoTraits.kt")
                public void testTwoTraits() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/twoTraits.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/dynamicTypes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DynamicTypes extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInDynamicTypes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/dynamicTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegationBy.kt")
            public void testDelegationBy() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dynamicTypes/delegationBy.kt");
                doTest(fileName);
            }

            @TestMetadata("unsupported.kt")
            public void testUnsupported() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dynamicTypes/unsupported.kt");
                doTest(fileName);
            }

            @TestMetadata("withInvisibleSynthesized.kt")
            public void testWithInvisibleSynthesized() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/dynamicTypes/withInvisibleSynthesized.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/enum")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Enum extends AbstractDiagnosticsTest {
            @TestMetadata("AbstractEnum.kt")
            public void testAbstractEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/AbstractEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("AbstractInEnum.kt")
            public void testAbstractInEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/AbstractInEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("AbstractOverrideInEnum.kt")
            public void testAbstractOverrideInEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/AbstractOverrideInEnum.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInEnum() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/enum"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classObjectInEnum.kt")
            public void testClassObjectInEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/classObjectInEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("classObjectInEnumPrivate.kt")
            public void testClassObjectInEnumPrivate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/classObjectInEnumPrivate.kt");
                doTest(fileName);
            }

            @TestMetadata("commonSupertype.kt")
            public void testCommonSupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/commonSupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorCallFromOutside.kt")
            public void testConstructorCallFromOutside() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/ConstructorCallFromOutside.kt");
                doTest(fileName);
            }

            @TestMetadata("dontCreatePackageTypeForEnumEntry.kt")
            public void testDontCreatePackageTypeForEnumEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/dontCreatePackageTypeForEnumEntry.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyConstructor.kt")
            public void testEmptyConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/emptyConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("entryShouldBeOfEnumType.kt")
            public void testEntryShouldBeOfEnumType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/entryShouldBeOfEnumType.kt");
                doTest(fileName);
            }

            @TestMetadata("enumEntryCannotHaveClassObject.kt")
            public void testEnumEntryCannotHaveClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/enumEntryCannotHaveClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("enumEntryInAbstractEnum.kt")
            public void testEnumEntryInAbstractEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/enumEntryInAbstractEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("enumImplementingTrait.kt")
            public void testEnumImplementingTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/enumImplementingTrait.kt");
                doTest(fileName);
            }

            @TestMetadata("enumInheritance.kt")
            public void testEnumInheritance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/enumInheritance.kt");
                doTest(fileName);
            }

            @TestMetadata("enumIsAssignableToBuiltInEnum.kt")
            public void testEnumIsAssignableToBuiltInEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/enumIsAssignableToBuiltInEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("enumMissingName.kt")
            public void testEnumMissingName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/enumMissingName.kt");
                doTest(fileName);
            }

            @TestMetadata("enumModifier.kt")
            public void testEnumModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/enumModifier.kt");
                doTest(fileName);
            }

            @TestMetadata("enumStarImport.kt")
            public void testEnumStarImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/enumStarImport.kt");
                doTest(fileName);
            }

            @TestMetadata("enumWithAnnotationKeyword.kt")
            public void testEnumWithAnnotationKeyword() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/enumWithAnnotationKeyword.kt");
                doTest(fileName);
            }

            @TestMetadata("enumWithEmptyName.kt")
            public void testEnumWithEmptyName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/enumWithEmptyName.kt");
                doTest(fileName);
            }

            @TestMetadata("ExplicitConstructorCall.kt")
            public void testExplicitConstructorCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/ExplicitConstructorCall.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionNamedAsEnumEntry.kt")
            public void testExtensionNamedAsEnumEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/extensionNamedAsEnumEntry.kt");
                doTest(fileName);
            }

            @TestMetadata("ifEnumEntry.kt")
            public void testIfEnumEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/ifEnumEntry.kt");
                doTest(fileName);
            }

            @TestMetadata("importEnumFromJava.kt")
            public void testImportEnumFromJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/importEnumFromJava.kt");
                doTest(fileName);
            }

            @TestMetadata("inheritFromEnumEntry.kt")
            public void testInheritFromEnumEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inheritFromEnumEntry.kt");
                doTest(fileName);
            }

            @TestMetadata("inheritanceFromEnum.kt")
            public void testInheritanceFromEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inheritanceFromEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("inline.kt")
            public void testInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inline.kt");
                doTest(fileName);
            }

            @TestMetadata("InsideEntryConstructorCall.kt")
            public void testInsideEntryConstructorCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/InsideEntryConstructorCall.kt");
                doTest(fileName);
            }

            @TestMetadata("InsideSecondaryConstructorCall.kt")
            public void testInsideSecondaryConstructorCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/InsideSecondaryConstructorCall.kt");
                doTest(fileName);
            }

            @TestMetadata("interfaceWithEnumKeyword.kt")
            public void testInterfaceWithEnumKeyword() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/interfaceWithEnumKeyword.kt");
                doTest(fileName);
            }

            @TestMetadata("isEnumEntry.kt")
            public void testIsEnumEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/isEnumEntry.kt");
                doTest(fileName);
            }

            @TestMetadata("javaEnumValueOfMethod.kt")
            public void testJavaEnumValueOfMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/javaEnumValueOfMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("javaEnumValuesMethod.kt")
            public void testJavaEnumValuesMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/javaEnumValuesMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("javaEnumWithAbstractFun.kt")
            public void testJavaEnumWithAbstractFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/javaEnumWithAbstractFun.kt");
                doTest(fileName);
            }

            @TestMetadata("javaEnumWithFuns.kt")
            public void testJavaEnumWithFuns() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/javaEnumWithFuns.kt");
                doTest(fileName);
            }

            @TestMetadata("javaEnumWithNameClashing.kt")
            public void testJavaEnumWithNameClashing() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/javaEnumWithNameClashing.kt");
                doTest(fileName);
            }

            @TestMetadata("javaEnumWithProperty.kt")
            public void testJavaEnumWithProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/javaEnumWithProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2834.kt")
            public void testKt2834() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/kt2834.kt");
                doTest(fileName);
            }

            @TestMetadata("kt8972_cloneNotAllowed.kt")
            public void testKt8972_cloneNotAllowed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/kt8972_cloneNotAllowed.kt");
                doTest(fileName);
            }

            @TestMetadata("localEnums.kt")
            public void testLocalEnums() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/localEnums.kt");
                doTest(fileName);
            }

            @TestMetadata("modifiersOnEnumEntry.kt")
            public void testModifiersOnEnumEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/modifiersOnEnumEntry.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleConstructors.kt")
            public void testMultipleConstructors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/multipleConstructors.kt");
                doTest(fileName);
            }

            @TestMetadata("NonPrivateConstructor.kt")
            public void testNonPrivateConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/NonPrivateConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("openMemberInEnum.kt")
            public void testOpenMemberInEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/openMemberInEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("overrideFinalEnumMethods.kt")
            public void testOverrideFinalEnumMethods() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/overrideFinalEnumMethods.kt");
                doTest(fileName);
            }

            @TestMetadata("SecondaryConstructorCall.kt")
            public void testSecondaryConstructorCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/SecondaryConstructorCall.kt");
                doTest(fileName);
            }

            @TestMetadata("starImportNestedClassAndEntries.kt")
            public void testStarImportNestedClassAndEntries() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/starImportNestedClassAndEntries.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParametersInEnum.kt")
            public void testTypeParametersInEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/typeParametersInEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("valuesValueOfAndEntriesAccessibility.kt")
            public void testValuesValueOfAndEntriesAccessibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/valuesValueOfAndEntriesAccessibility.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/enum/inner")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inner extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInInner() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/enum/inner"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("existingClassObject.kt")
                public void testExistingClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/existingClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("insideClass.kt")
                public void testInsideClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/insideClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("insideClassObject.kt")
                public void testInsideClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/insideClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("insideEnum.kt")
                public void testInsideEnum() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/insideEnum.kt");
                    doTest(fileName);
                }

                @TestMetadata("insideEnumEntry.kt")
                public void testInsideEnumEntry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/insideEnumEntry.kt");
                    doTest(fileName);
                }

                @TestMetadata("insideInnerClassNotAllowed.kt")
                public void testInsideInnerClassNotAllowed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/insideInnerClassNotAllowed.kt");
                    doTest(fileName);
                }

                @TestMetadata("insideObject.kt")
                public void testInsideObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/insideObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("insideTrait.kt")
                public void testInsideTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/insideTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("redeclarationInClassObject.kt")
                public void testRedeclarationInClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/redeclarationInClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("twoEnums.kt")
                public void testTwoEnums() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/twoEnums.kt");
                    doTest(fileName);
                }

                @TestMetadata("twoEnumsInClassObjectAndInnerClass.kt")
                public void testTwoEnumsInClassObjectAndInnerClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/enum/inner/twoEnumsInClassObjectAndInnerClass.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/evaluate")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Evaluate extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInEvaluate() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/evaluate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("binaryMinusDepOnExpType.kt")
            public void testBinaryMinusDepOnExpType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/binaryMinusDepOnExpType.kt");
                doTest(fileName);
            }

            @TestMetadata("binaryMinusIndepWoExpType.kt")
            public void testBinaryMinusIndepWoExpType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/binaryMinusIndepWoExpType.kt");
                doTest(fileName);
            }

            @TestMetadata("binaryMinusIndependentExpType.kt")
            public void testBinaryMinusIndependentExpType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/binaryMinusIndependentExpType.kt");
                doTest(fileName);
            }

            @TestMetadata("divisionByZero.kt")
            public void testDivisionByZero() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/divisionByZero.kt");
                doTest(fileName);
            }

            @TestMetadata("float.kt")
            public void testFloat() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/float.kt");
                doTest(fileName);
            }

            @TestMetadata("intOverflow.kt")
            public void testIntOverflow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/intOverflow.kt");
                doTest(fileName);
            }

            @TestMetadata("intOverflowWithJavaProperties.kt")
            public void testIntOverflowWithJavaProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/intOverflowWithJavaProperties.kt");
                doTest(fileName);
            }

            @TestMetadata("integer.kt")
            public void testInteger() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/integer.kt");
                doTest(fileName);
            }

            @TestMetadata("logicWithNumber.kt")
            public void testLogicWithNumber() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/logicWithNumber.kt");
                doTest(fileName);
            }

            @TestMetadata("longOverflow.kt")
            public void testLongOverflow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/longOverflow.kt");
                doTest(fileName);
            }

            @TestMetadata("numberBinaryOperations.kt")
            public void testNumberBinaryOperations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperations.kt");
                doTest(fileName);
            }

            @TestMetadata("numberBinaryOperationsCall.kt")
            public void testNumberBinaryOperationsCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperationsCall.kt");
                doTest(fileName);
            }

            @TestMetadata("numberBinaryOperationsInfixCall.kt")
            public void testNumberBinaryOperationsInfixCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperationsInfixCall.kt");
                doTest(fileName);
            }

            @TestMetadata("otherOverflow.kt")
            public void testOtherOverflow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/otherOverflow.kt");
                doTest(fileName);
            }

            @TestMetadata("parentesized.kt")
            public void testParentesized() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/parentesized.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifiedExpressions.kt")
            public void testQualifiedExpressions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/qualifiedExpressions.kt");
                doTest(fileName);
            }

            @TestMetadata("unaryMinusDepOnExpType.kt")
            public void testUnaryMinusDepOnExpType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/unaryMinusDepOnExpType.kt");
                doTest(fileName);
            }

            @TestMetadata("unaryMinusIndepWoExpType.kt")
            public void testUnaryMinusIndepWoExpType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/unaryMinusIndepWoExpType.kt");
                doTest(fileName);
            }

            @TestMetadata("unaryMinusIndependentExpType.kt")
            public void testUnaryMinusIndependentExpType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/unaryMinusIndependentExpType.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongLongSuffix.kt")
            public void testWrongLongSuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/evaluate/wrongLongSuffix.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/exposed")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Exposed extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInExposed() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/exposed"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/delegate.kt");
                doTest(fileName);
            }

            @TestMetadata("exceptionOnFakeInvisible.kt")
            public void testExceptionOnFakeInvisible() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/exceptionOnFakeInvisible.kt");
                doTest(fileName);
            }

            @TestMetadata("functional.kt")
            public void testFunctional() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/functional.kt");
                doTest(fileName);
            }

            @TestMetadata("implements.kt")
            public void testImplements() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/implements.kt");
                doTest(fileName);
            }

            @TestMetadata("inaccessibleType.kt")
            public void testInaccessibleType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/inaccessibleType.kt");
                doTest(fileName);
            }

            @TestMetadata("internal.kt")
            public void testInternal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/internal.kt");
                doTest(fileName);
            }

            @TestMetadata("internalAndProtected.kt")
            public void testInternalAndProtected() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/internalAndProtected.kt");
                doTest(fileName);
            }

            @TestMetadata("internalFromLocal.kt")
            public void testInternalFromLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/internalFromLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/local.kt");
                doTest(fileName);
            }

            @TestMetadata("localFromInternal.kt")
            public void testLocalFromInternal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/localFromInternal.kt");
                doTest(fileName);
            }

            @TestMetadata("localFromPrivate.kt")
            public void testLocalFromPrivate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/localFromPrivate.kt");
                doTest(fileName);
            }

            @TestMetadata("localInFunReturnType.kt")
            public void testLocalInFunReturnType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/localInFunReturnType.kt");
                doTest(fileName);
            }

            @TestMetadata("localInMemberType.kt")
            public void testLocalInMemberType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/localInMemberType.kt");
                doTest(fileName);
            }

            @TestMetadata("localInPropertyType.kt")
            public void testLocalInPropertyType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/localInPropertyType.kt");
                doTest(fileName);
            }

            @TestMetadata("nested.kt")
            public void testNested() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/nested.kt");
                doTest(fileName);
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/object.kt");
                doTest(fileName);
            }

            @TestMetadata("packagePrivate.kt")
            public void testPackagePrivate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/packagePrivate.kt");
                doTest(fileName);
            }

            @TestMetadata("privateFromLocal.kt")
            public void testPrivateFromLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/privateFromLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("protected.kt")
            public void testProtected() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/protected.kt");
                doTest(fileName);
            }

            @TestMetadata("protectedInProtected.kt")
            public void testProtectedInProtected() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/protectedInProtected.kt");
                doTest(fileName);
            }

            @TestMetadata("protectedJava.kt")
            public void testProtectedJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/protectedJava.kt");
                doTest(fileName);
            }

            @TestMetadata("protectedSameWay.kt")
            public void testProtectedSameWay() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/protectedSameWay.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("typeArgs.kt")
            public void testTypeArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/exposed/typeArgs.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/extensions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Extensions extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInExtensions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/extensions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classObject.kt")
            public void testClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/classObject.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtensionFunctions.kt")
            public void testExtensionFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/ExtensionFunctions.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionMemberInClassObject.kt")
            public void testExtensionMemberInClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/extensionMemberInClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionPropertyVsParameter.kt")
            public void testExtensionPropertyVsParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/extensionPropertyVsParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtensionsCalledOnSuper.kt")
            public void testExtensionsCalledOnSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/ExtensionsCalledOnSuper.kt");
                doTest(fileName);
            }

            @TestMetadata("GenericIterator.kt")
            public void testGenericIterator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/GenericIterator.kt");
                doTest(fileName);
            }

            @TestMetadata("GenericIterator2.kt")
            public void testGenericIterator2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/GenericIterator2.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1875.kt")
            public void testKt1875() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/kt1875.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2317.kt")
            public void testKt2317() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/kt2317.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3470.kt")
            public void testKt3470() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/kt3470.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3563.kt")
            public void testKt3563() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/kt3563.kt");
                doTest(fileName);
            }

            @TestMetadata("kt819ExtensionProperties.kt")
            public void testKt819ExtensionProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/kt819ExtensionProperties.kt");
                doTest(fileName);
            }

            @TestMetadata("noClassObjectsInJava.kt")
            public void testNoClassObjectsInJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/noClassObjectsInJava.kt");
                doTest(fileName);
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/object.kt");
                doTest(fileName);
            }

            @TestMetadata("throwOutCandidatesByReceiver.kt")
            public void testThrowOutCandidatesByReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/throwOutCandidatesByReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("throwOutCandidatesByReceiver2.kt")
            public void testThrowOutCandidatesByReceiver2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/throwOutCandidatesByReceiver2.kt");
                doTest(fileName);
            }

            @TestMetadata("variableInvoke.kt")
            public void testVariableInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/extensions/variableInvoke.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/functionAsExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionAsExpression extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInFunctionAsExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/functionAsExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AutoLabels.kt")
            public void testAutoLabels() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/AutoLabels.kt");
                doTest(fileName);
            }

            @TestMetadata("Common.kt")
            public void testCommon() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/Common.kt");
                doTest(fileName);
            }

            @TestMetadata("DifficultInferenceForParameter.kt")
            public void testDifficultInferenceForParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/DifficultInferenceForParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("ForbiddenNonLocalReturn.kt")
            public void testForbiddenNonLocalReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/ForbiddenNonLocalReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("FunctionType.kt")
            public void testFunctionType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/FunctionType.kt");
                doTest(fileName);
            }

            @TestMetadata("InferenceParametersTypes.kt")
            public void testInferenceParametersTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/InferenceParametersTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("MissingParameterTypes.kt")
            public void testMissingParameterTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/MissingParameterTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("NameDeprecation.kt")
            public void testNameDeprecation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/NameDeprecation.kt");
                doTest(fileName);
            }

            @TestMetadata("NoOverloadError.kt")
            public void testNoOverloadError() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/NoOverloadError.kt");
                doTest(fileName);
            }

            @TestMetadata("Parameters.kt")
            public void testParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/Parameters.kt");
                doTest(fileName);
            }

            @TestMetadata("ReceiverByExpectedType.kt")
            public void testReceiverByExpectedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/ReceiverByExpectedType.kt");
                doTest(fileName);
            }

            @TestMetadata("ReturnAndLabels.kt")
            public void testReturnAndLabels() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/ReturnAndLabels.kt");
                doTest(fileName);
            }

            @TestMetadata("ReturnTypeCheck.kt")
            public void testReturnTypeCheck() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/ReturnTypeCheck.kt");
                doTest(fileName);
            }

            @TestMetadata("ScopeCheck.kt")
            public void testScopeCheck() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/ScopeCheck.kt");
                doTest(fileName);
            }

            @TestMetadata("WithGenericParameters.kt")
            public void testWithGenericParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/WithGenericParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("WithOuterGeneric.kt")
            public void testWithOuterGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/WithOuterGeneric.kt");
                doTest(fileName);
            }

            @TestMetadata("WithoutBody.kt")
            public void testWithoutBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionAsExpression/WithoutBody.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionLiterals extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInFunctionLiterals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignmentOperationInLambda.kt")
            public void testAssignmentOperationInLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/assignmentOperationInLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("assignmentOperationInLambdaWithExpectedType.kt")
            public void testAssignmentOperationInLambdaWithExpectedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/assignmentOperationInLambdaWithExpectedType.kt");
                doTest(fileName);
            }

            @TestMetadata("DeprecatedSyntax.kt")
            public void testDeprecatedSyntax() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/DeprecatedSyntax.kt");
                doTest(fileName);
            }

            @TestMetadata("ExpectedParameterTypeMismatchVariance.kt")
            public void testExpectedParameterTypeMismatchVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/ExpectedParameterTypeMismatchVariance.kt");
                doTest(fileName);
            }

            @TestMetadata("ExpectedParametersTypesMismatch.kt")
            public void testExpectedParametersTypesMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/ExpectedParametersTypesMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLIteralInBlockInIf.kt")
            public void testFunctionLIteralInBlockInIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/functionLIteralInBlockInIf.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralInIf.kt")
            public void testFunctionLiteralInIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/functionLiteralInIf.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralWithoutArgumentList.kt")
            public void testFunctionLiteralWithoutArgumentList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/functionLiteralWithoutArgumentList.kt");
                doTest(fileName);
            }

            @TestMetadata("higherOrderCallMissingParameters.kt")
            public void testHigherOrderCallMissingParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/higherOrderCallMissingParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("kt11733.kt")
            public void testKt11733() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/kt11733.kt");
                doTest(fileName);
            }

            @TestMetadata("kt11733_1.kt")
            public void testKt11733_1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/kt11733_1.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2906.kt")
            public void testKt2906() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/kt2906.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3343.kt")
            public void testKt3343() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/kt3343.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4529.kt")
            public void testKt4529() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/kt4529.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6541_extensionForExtensionFunction.kt")
            public void testKt6541_extensionForExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/kt6541_extensionForExtensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6869.kt")
            public void testKt6869() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/kt6869.kt");
                doTest(fileName);
            }

            @TestMetadata("kt7383_starProjectedFunction.kt")
            public void testKt7383_starProjectedFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/kt7383_starProjectedFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("LabeledFunctionLiterals.kt")
            public void testLabeledFunctionLiterals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/LabeledFunctionLiterals.kt");
                doTest(fileName);
            }

            @TestMetadata("returnNull.kt")
            public void testReturnNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/returnNull.kt");
                doTest(fileName);
            }

            @TestMetadata("returnNullWithReturn.kt")
            public void testReturnNullWithReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/returnNullWithReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("underscopeParameters.kt")
            public void testUnderscopeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/underscopeParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("unusedLiteral.kt")
            public void testUnusedLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/unusedLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("unusedLiteralInsideUnitLiteral.kt")
            public void testUnusedLiteralInsideUnitLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/unusedLiteralInsideUnitLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DestructuringInLambdas extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInDestructuringInLambdas() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("complexInference.kt")
                public void testComplexInference() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/complexInference.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionComponents.kt")
                public void testExtensionComponents() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/extensionComponents.kt");
                    doTest(fileName);
                }

                @TestMetadata("inferredFunctionalType.kt")
                public void testInferredFunctionalType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/inferredFunctionalType.kt");
                    doTest(fileName);
                }

                @TestMetadata("modifiers.kt")
                public void testModifiers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/modifiers.kt");
                    doTest(fileName);
                }

                @TestMetadata("noExpectedType.kt")
                public void testNoExpectedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/noExpectedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("redeclaration.kt")
                public void testRedeclaration() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/redeclaration.kt");
                    doTest(fileName);
                }

                @TestMetadata("shadowing.kt")
                public void testShadowing() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/shadowing.kt");
                    doTest(fileName);
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/simple.kt");
                    doTest(fileName);
                }

                @TestMetadata("underscore.kt")
                public void testUnderscore() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/underscore.kt");
                    doTest(fileName);
                }

                @TestMetadata("unsupportedFeature.kt")
                public void testUnsupportedFeature() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/unsupportedFeature.kt");
                    doTest(fileName);
                }

                @TestMetadata("unusedParameters.kt")
                public void testUnusedParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/unusedParameters.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals/return")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Return extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInReturn() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals/return"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("AutoLabels.kt")
                public void testAutoLabels() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/AutoLabels.kt");
                    doTest(fileName);
                }

                @TestMetadata("AutoLabelsNonLocal.kt")
                public void testAutoLabelsNonLocal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/AutoLabelsNonLocal.kt");
                    doTest(fileName);
                }

                @TestMetadata("ForbiddenNonLocalReturnNoType.kt")
                public void testForbiddenNonLocalReturnNoType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/ForbiddenNonLocalReturnNoType.kt");
                    doTest(fileName);
                }

                @TestMetadata("IfInReturnedExpression.kt")
                public void testIfInReturnedExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/IfInReturnedExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("IfWithoutElse.kt")
                public void testIfWithoutElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/IfWithoutElse.kt");
                    doTest(fileName);
                }

                @TestMetadata("IfWithoutElseWithExplicitType.kt")
                public void testIfWithoutElseWithExplicitType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/IfWithoutElseWithExplicitType.kt");
                    doTest(fileName);
                }

                @TestMetadata("LambdaWithParameter.kt")
                public void testLambdaWithParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LambdaWithParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalAndNonLocalReturnInLambda.kt")
                public void testLocalAndNonLocalReturnInLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalAndNonLocalReturnInLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnExplicitLabelNoParens.kt")
                public void testLocalReturnExplicitLabelNoParens() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnExplicitLabelNoParens.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnExplicitLabelParens.kt")
                public void testLocalReturnExplicitLabelParens() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnExplicitLabelParens.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnHasTypeNothing.kt")
                public void testLocalReturnHasTypeNothing() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnHasTypeNothing.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnInNestedFunction.kt")
                public void testLocalReturnInNestedFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnInNestedFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnInNestedLambda.kt")
                public void testLocalReturnInNestedLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnInNestedLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnNoCoercionToUnit.kt")
                public void testLocalReturnNoCoercionToUnit() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnNoCoercionToUnit.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnNull.kt")
                public void testLocalReturnNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnNull.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnSecondUnit.kt")
                public void testLocalReturnSecondUnit() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnSecondUnit.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnUnit.kt")
                public void testLocalReturnUnit() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnit.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnUnitAndDontCareType.kt")
                public void testLocalReturnUnitAndDontCareType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnitAndDontCareType.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnUnitWithBodyExpression.kt")
                public void testLocalReturnUnitWithBodyExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnitWithBodyExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnWithExpectedType.kt")
                public void testLocalReturnWithExpectedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnWithExpectedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnWithExplicitUnit.kt")
                public void testLocalReturnWithExplicitUnit() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnWithExplicitUnit.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalReturnsWithExplicitReturnType.kt")
                public void testLocalReturnsWithExplicitReturnType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnsWithExplicitReturnType.kt");
                    doTest(fileName);
                }

                @TestMetadata("MixedReturnsFromLambda.kt")
                public void testMixedReturnsFromLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/MixedReturnsFromLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("NoCommonSystem.kt")
                public void testNoCommonSystem() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/NoCommonSystem.kt");
                    doTest(fileName);
                }

                @TestMetadata("SmartCast.kt")
                public void testSmartCast() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/SmartCast.kt");
                    doTest(fileName);
                }

                @TestMetadata("SmartCastWithExplicitType.kt")
                public void testSmartCastWithExplicitType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/SmartCastWithExplicitType.kt");
                    doTest(fileName);
                }

                @TestMetadata("unresolvedReferenceInReturnBlock.kt")
                public void testUnresolvedReferenceInReturnBlock() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/functionLiterals/return/unresolvedReferenceInReturnBlock.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/generics")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Generics extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInGenerics() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("argumentsForT.kt")
            public void testArgumentsForT() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/argumentsForT.kt");
                doTest(fileName);
            }

            @TestMetadata("commonSupertypeContravariant.kt")
            public void testCommonSupertypeContravariant() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/commonSupertypeContravariant.kt");
                doTest(fileName);
            }

            @TestMetadata("commonSupertypeContravariant2.kt")
            public void testCommonSupertypeContravariant2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/commonSupertypeContravariant2.kt");
                doTest(fileName);
            }

            @TestMetadata("genericsInType.kt")
            public void testGenericsInType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/genericsInType.kt");
                doTest(fileName);
            }

            @TestMetadata("InconsistentTypeParameterBounds.kt")
            public void testInconsistentTypeParameterBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/InconsistentTypeParameterBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("invalidArgumentsNumberInWhere.kt")
            public void testInvalidArgumentsNumberInWhere() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/invalidArgumentsNumberInWhere.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1575-Class.kt")
            public void testKt1575_Class() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/kt1575-Class.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1575-Function.kt")
            public void testKt1575_Function() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/kt1575-Function.kt");
                doTest(fileName);
            }

            @TestMetadata("kt5508.kt")
            public void testKt5508() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/kt5508.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9985.kt")
            public void testKt9985() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/kt9985.kt");
                doTest(fileName);
            }

            @TestMetadata("Projections.kt")
            public void testProjections() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/Projections.kt");
                doTest(fileName);
            }

            @TestMetadata("PseudoRawTypes.kt")
            public void testPseudoRawTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/PseudoRawTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("RawTypeInIsExpression.kt")
            public void testRawTypeInIsExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/RawTypeInIsExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("RawTypeInIsPattern.kt")
            public void testRawTypeInIsPattern() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/RawTypeInIsPattern.kt");
                doTest(fileName);
            }

            @TestMetadata("recursive.kt")
            public void testRecursive() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/recursive.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursiveUpperBoundCheck.kt")
            public void testRecursiveUpperBoundCheck() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/RecursiveUpperBoundCheck.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursiveUpperBoundWithTwoArguments.kt")
            public void testRecursiveUpperBoundWithTwoArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/RecursiveUpperBoundWithTwoArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveGenericBoundsBeforeSupertypes.kt")
            public void testResolveGenericBoundsBeforeSupertypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/resolveGenericBoundsBeforeSupertypes.kt");
                doTest(fileName);
            }

            @TestMetadata("sameTypeParameterUse.kt")
            public void testSameTypeParameterUse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/sameTypeParameterUse.kt");
                doTest(fileName);
            }

            @TestMetadata("suppressVarianceConflict.kt")
            public void testSuppressVarianceConflict() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/suppressVarianceConflict.kt");
                doTest(fileName);
            }

            @TestMetadata("TypeParameterBounds.kt")
            public void testTypeParameterBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/TypeParameterBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("TypeParametersInTypeParameterBounds.kt")
            public void testTypeParametersInTypeParameterBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/TypeParametersInTypeParameterBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("unresolvedClassifierInWhere.kt")
            public void testUnresolvedClassifierInWhere() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/unresolvedClassifierInWhere.kt");
                doTest(fileName);
            }

            @TestMetadata("wildcardInValueParameter.kt")
            public void testWildcardInValueParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/wildcardInValueParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/capturedParameters")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CapturedParameters extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInCapturedParameters() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/capturedParameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerLocalClass.kt")
                public void testInnerLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/capturedParameters/innerLocalClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/capturedParameters/localClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("localWithTypeParameter.kt")
                public void testLocalWithTypeParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/capturedParameters/localWithTypeParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectLiteral.kt")
                public void testObjectLiteral() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/capturedParameters/objectLiteral.kt");
                    doTest(fileName);
                }

                @TestMetadata("uncheckedCast.kt")
                public void testUncheckedCast() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/capturedParameters/uncheckedCast.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/cyclicBounds")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CyclicBounds extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInCyclicBounds() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/cyclicBounds"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("functions.kt")
                public void testFunctions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/cyclicBounds/functions.kt");
                    doTest(fileName);
                }

                @TestMetadata("inClass.kt")
                public void testInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/cyclicBounds/inClass.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/innerClasses")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InnerClasses extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInInnerClasses() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/innerClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("bareTypes.kt")
                public void testBareTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/bareTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("bareTypesComplex.kt")
                public void testBareTypesComplex() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/bareTypesComplex.kt");
                    doTest(fileName);
                }

                @TestMetadata("checkBoundsOuter.kt")
                public void testCheckBoundsOuter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/checkBoundsOuter.kt");
                    doTest(fileName);
                }

                @TestMetadata("importedInner.kt")
                public void testImportedInner() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/importedInner.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerSuperCall.kt")
                public void testInnerSuperCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/innerSuperCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerSuperCallSecondary.kt")
                public void testInnerSuperCallSecondary() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/innerSuperCallSecondary.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerTP.kt")
                public void testInnerTP() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/innerTP.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerUncheckedCast.kt")
                public void testInnerUncheckedCast() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/innerUncheckedCast.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerVariance.kt")
                public void testInnerVariance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/innerVariance.kt");
                    doTest(fileName);
                }

                @TestMetadata("iterator.kt")
                public void testIterator() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/iterator.kt");
                    doTest(fileName);
                }

                @TestMetadata("j+k.kt")
                public void testJ_k() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/j+k.kt");
                    doTest(fileName);
                }

                @TestMetadata("j+k_complex.kt")
                public void testJ_k_complex() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/j+k_complex.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3357.kt")
                public void testKt3357() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/kt3357.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt408.kt")
                public void testKt408() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/kt408.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt6325.kt")
                public void testKt6325() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/kt6325.kt");
                    doTest(fileName);
                }

                @TestMetadata("outerArgumentsRequired.kt")
                public void testOuterArgumentsRequired() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/outerArgumentsRequired.kt");
                    doTest(fileName);
                }

                @TestMetadata("parameterShadowing.kt")
                public void testParameterShadowing() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/parameterShadowing.kt");
                    doTest(fileName);
                }

                @TestMetadata("qualifiedOuter.kt")
                public void testQualifiedOuter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/qualifiedOuter.kt");
                    doTest(fileName);
                }

                @TestMetadata("qualifiedTypesResolution.kt")
                public void testQualifiedTypesResolution() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/qualifiedTypesResolution.kt");
                    doTest(fileName);
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/simple.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIn.kt")
                public void testSimpleIn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/simpleIn.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleOut.kt")
                public void testSimpleOut() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/simpleOut.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleOutUseSite.kt")
                public void testSimpleOutUseSite() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/simpleOutUseSite.kt");
                    doTest(fileName);
                }

                @TestMetadata("substitutedMemberScope.kt")
                public void testSubstitutedMemberScope() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/substitutedMemberScope.kt");
                    doTest(fileName);
                }

                @TestMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class ImplicitArguments extends AbstractDiagnosticsTest {
                    public void testAllFilesPresentInImplicitArguments() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("fromCompanionObject.kt")
                    public void testFromCompanionObject() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromCompanionObject.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("fromOuterClassInObjectLiteral.kt")
                    public void testFromOuterClassInObjectLiteral() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromOuterClassInObjectLiteral.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("fromSuperClasses.kt")
                    public void testFromSuperClasses() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClasses.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("fromSuperClassesLocal.kt")
                    public void testFromSuperClassesLocal() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesLocal.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("fromSuperClassesLocalInsideInner.kt")
                    public void testFromSuperClassesLocalInsideInner() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesLocalInsideInner.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("fromSuperClassesTransitive.kt")
                    public void testFromSuperClassesTransitive() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesTransitive.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("inStaticScope.kt")
                    public void testInStaticScope() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/inStaticScope.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("secondLevelDepth.kt")
                    public void testSecondLevelDepth() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/secondLevelDepth.kt");
                        doTest(fileName);
                    }
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MultipleBoundsMemberScope extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInMultipleBoundsMemberScope() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("conflictingReturnType.kt")
                public void testConflictingReturnType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/conflictingReturnType.kt");
                    doTest(fileName);
                }

                @TestMetadata("flexibleTypes.kt")
                public void testFlexibleTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/flexibleTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("mostSpecific.kt")
                public void testMostSpecific() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/mostSpecific.kt");
                    doTest(fileName);
                }

                @TestMetadata("properties.kt")
                public void testProperties() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/properties.kt");
                    doTest(fileName);
                }

                @TestMetadata("propertiesConflict.kt")
                public void testPropertiesConflict() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/propertiesConflict.kt");
                    doTest(fileName);
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/simple.kt");
                    doTest(fileName);
                }

                @TestMetadata("validTypeParameters.kt")
                public void testValidTypeParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/validTypeParameters.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/nullability")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Nullability extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInNullability() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/nullability"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("declarationsBoundsViolation.kt")
                public void testDeclarationsBoundsViolation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/declarationsBoundsViolation.kt");
                    doTest(fileName);
                }

                @TestMetadata("expressionsBoundsViolation.kt")
                public void testExpressionsBoundsViolation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/expressionsBoundsViolation.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionalBound.kt")
                public void testFunctionalBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/functionalBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("nullToGeneric.kt")
                public void testNullToGeneric() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/nullToGeneric.kt");
                    doTest(fileName);
                }

                @TestMetadata("smartCastRefinedClass.kt")
                public void testSmartCastRefinedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/smartCastRefinedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("smartCasts.kt")
                public void testSmartCasts() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/smartCasts.kt");
                    doTest(fileName);
                }

                @TestMetadata("smartCastsOnThis.kt")
                public void testSmartCastsOnThis() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/smartCastsOnThis.kt");
                    doTest(fileName);
                }

                @TestMetadata("smartCastsValueArgument.kt")
                public void testSmartCastsValueArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/smartCastsValueArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("tpBoundsViolation.kt")
                public void testTpBoundsViolation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/tpBoundsViolation.kt");
                    doTest(fileName);
                }

                @TestMetadata("tpBoundsViolationVariance.kt")
                public void testTpBoundsViolationVariance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/tpBoundsViolationVariance.kt");
                    doTest(fileName);
                }

                @TestMetadata("tpInBounds.kt")
                public void testTpInBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/tpInBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("useAsReceiver.kt")
                public void testUseAsReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/useAsReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("useAsValueArgument.kt")
                public void testUseAsValueArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/nullability/useAsValueArgument.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ProjectionsScope extends AbstractDiagnosticsTest {
                @TestMetadata("addAll.kt")
                public void testAddAll() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/addAll.kt");
                    doTest(fileName);
                }

                public void testAllFilesPresentInProjectionsScope() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/projectionsScope"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("approximateDispatchReceiver.kt")
                public void testApproximateDispatchReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/approximateDispatchReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionReceiverTypeMismatch.kt")
                public void testExtensionReceiverTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/extensionReceiverTypeMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionResultSubstitution.kt")
                public void testExtensionResultSubstitution() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/extensionResultSubstitution.kt");
                    doTest(fileName);
                }

                @TestMetadata("flexibleProjectedScope.kt")
                public void testFlexibleProjectedScope() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/flexibleProjectedScope.kt");
                    doTest(fileName);
                }

                @TestMetadata("inValueParameter.kt")
                public void testInValueParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/inValueParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("iterateOnExtension.kt")
                public void testIterateOnExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/iterateOnExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt7296.kt")
                public void testKt7296() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/kt7296.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt8647.kt")
                public void testKt8647() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/kt8647.kt");
                    doTest(fileName);
                }

                @TestMetadata("lambdaArgument.kt")
                public void testLambdaArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/lambdaArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("leakedApproximatedType.kt")
                public void testLeakedApproximatedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/leakedApproximatedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("MLOut.kt")
                public void testMLOut() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/MLOut.kt");
                    doTest(fileName);
                }

                @TestMetadata("multipleArgumentProjectedOut.kt")
                public void testMultipleArgumentProjectedOut() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/multipleArgumentProjectedOut.kt");
                    doTest(fileName);
                }

                @TestMetadata("platformSuperClass.kt")
                public void testPlatformSuperClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/platformSuperClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("projectedOutConventions.kt")
                public void testProjectedOutConventions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/projectedOutConventions.kt");
                    doTest(fileName);
                }

                @TestMetadata("projectedOutSmartCast.kt")
                public void testProjectedOutSmartCast() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/projectedOutSmartCast.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveUpperBoundStar.kt")
                public void testRecursiveUpperBoundStar() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/recursiveUpperBoundStar.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveUpperBoundStarOut.kt")
                public void testRecursiveUpperBoundStarOut() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/recursiveUpperBoundStarOut.kt");
                    doTest(fileName);
                }

                @TestMetadata("starNullability.kt")
                public void testStarNullability() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/starNullability.kt");
                    doTest(fileName);
                }

                @TestMetadata("starNullabilityRecursive.kt")
                public void testStarNullabilityRecursive() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/starNullabilityRecursive.kt");
                    doTest(fileName);
                }

                @TestMetadata("superClass.kt")
                public void testSuperClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/superClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeMismatchConventions.kt")
                public void testTypeMismatchConventions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/typeMismatchConventions.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeMismatchInLambda.kt")
                public void testTypeMismatchInLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/typeMismatchInLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeParameterBounds.kt")
                public void testTypeParameterBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/typeParameterBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("unsafeVarianceStar.kt")
                public void testUnsafeVarianceStar() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/unsafeVarianceStar.kt");
                    doTest(fileName);
                }

                @TestMetadata("varargs.kt")
                public void testVarargs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope/varargs.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/starProjections")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class StarProjections extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInStarProjections() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/starProjections"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("checkBounds.kt")
                public void testCheckBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/starProjections/checkBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("collectionInheritedFromJava.kt")
                public void testCollectionInheritedFromJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/starProjections/collectionInheritedFromJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("inheritedFromJava.kt")
                public void testInheritedFromJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/starProjections/inheritedFromJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("inheritedFromKotlin.kt")
                public void testInheritedFromKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/starProjections/inheritedFromKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("invalid.kt")
                public void testInvalid() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/starProjections/invalid.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TpAsReified extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInTpAsReified() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/tpAsReified"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("CapturedAsReified.kt")
                public void testCapturedAsReified() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/CapturedAsReified.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassDereference.kt")
                public void testClassDereference() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/ClassDereference.kt");
                    doTest(fileName);
                }

                @TestMetadata("Conventions.kt")
                public void testConventions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/Conventions.kt");
                    doTest(fileName);
                }

                @TestMetadata("GenericAsReifiedArgument.kt")
                public void testGenericAsReifiedArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/GenericAsReifiedArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("InConstructor.kt")
                public void testInConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/InConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("InFunction.kt")
                public void testInFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/InFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("InProperty.kt")
                public void testInProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/InProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("InType.kt")
                public void testInType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/InType.kt");
                    doTest(fileName);
                }

                @TestMetadata("InlineableReified.kt")
                public void testInlineableReified() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/InlineableReified.kt");
                    doTest(fileName);
                }

                @TestMetadata("LocalFun.kt")
                public void testLocalFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/LocalFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("NotInlineableReified.kt")
                public void testNotInlineableReified() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/NotInlineableReified.kt");
                    doTest(fileName);
                }

                @TestMetadata("ReifiedClass.kt")
                public void testReifiedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified/ReifiedClass.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/generics/varProjection")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class VarProjection extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInVarProjection() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/varProjection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("setterNotProjectedOutAssign.kt")
                public void testSetterNotProjectedOutAssign() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/varProjection/setterNotProjectedOutAssign.kt");
                    doTest(fileName);
                }

                @TestMetadata("setterProjectedOutAssign.kt")
                public void testSetterProjectedOutAssign() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutAssign.kt");
                    doTest(fileName);
                }

                @TestMetadata("setterProjectedOutNoPlusAssign.kt")
                public void testSetterProjectedOutNoPlusAssign() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutNoPlusAssign.kt");
                    doTest(fileName);
                }

                @TestMetadata("setterProjectedOutPlusAssignDefined.kt")
                public void testSetterProjectedOutPlusAssignDefined() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutPlusAssignDefined.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/imports")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Imports extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInImports() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/imports"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AllUnderImportsAmbiguity.kt")
            public void testAllUnderImportsAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/AllUnderImportsAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("AllUnderImportsLessPriority.kt")
            public void testAllUnderImportsLessPriority() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/AllUnderImportsLessPriority.kt");
                doTest(fileName);
            }

            @TestMetadata("AllUnderImportsSamePriorityForFunction.kt")
            public void testAllUnderImportsSamePriorityForFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/AllUnderImportsSamePriorityForFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("AllUnderImportsSamePriorityForProperty.kt")
            public void testAllUnderImportsSamePriorityForProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/AllUnderImportsSamePriorityForProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("CheckJavaVisibility.kt")
            public void testCheckJavaVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/CheckJavaVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("CheckVisibility.kt")
            public void testCheckVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/CheckVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassClash.kt")
            public void testClassClash() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ClassClash.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassClashStarImport.kt")
            public void testClassClashStarImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ClassClashStarImport.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassImportsConflicting.kt")
            public void testClassImportsConflicting() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ClassImportsConflicting.kt");
                doTest(fileName);
            }

            @TestMetadata("CurrentPackageAndAllUnderImport.kt")
            public void testCurrentPackageAndAllUnderImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/CurrentPackageAndAllUnderImport.kt");
                doTest(fileName);
            }

            @TestMetadata("CurrentPackageAndExplicitImport.kt")
            public void testCurrentPackageAndExplicitImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/CurrentPackageAndExplicitImport.kt");
                doTest(fileName);
            }

            @TestMetadata("DefaultImportsPriority.kt")
            public void testDefaultImportsPriority() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/DefaultImportsPriority.kt");
                doTest(fileName);
            }

            @TestMetadata("ExplicitImportsAmbiguity.kt")
            public void testExplicitImportsAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ExplicitImportsAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("ExplicitImportsUnambiguityForFunction.kt")
            public void testExplicitImportsUnambiguityForFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ExplicitImportsUnambiguityForFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("ExplicitPackageImportsAmbiguity.kt")
            public void testExplicitPackageImportsAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ExplicitPackageImportsAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportClassClash.kt")
            public void testImportClassClash() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportClassClash.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportFromCompanionObject.kt")
            public void testImportFromCompanionObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportFromCompanionObject.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportFromCurrentWithDifferentName.kt")
            public void testImportFromCurrentWithDifferentName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportFromCurrentWithDifferentName.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportFromObject.kt")
            public void testImportFromObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportFromObject.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportFromRootPackage.kt")
            public void testImportFromRootPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportFromRootPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("importFunctionWithAllUnderImport.kt")
            public void testImportFunctionWithAllUnderImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/importFunctionWithAllUnderImport.kt");
                doTest(fileName);
            }

            @TestMetadata("importFunctionWithAllUnderImportAfterNamedImport.kt")
            public void testImportFunctionWithAllUnderImportAfterNamedImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/importFunctionWithAllUnderImportAfterNamedImport.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportHidingDefinitionInTheSameFile.kt")
            public void testImportHidingDefinitionInTheSameFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportHidingDefinitionInTheSameFile.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportNestedWithDifferentName.kt")
            public void testImportNestedWithDifferentName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportNestedWithDifferentName.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportObjectAndUseAsSupertype.kt")
            public void testImportObjectAndUseAsSupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportObjectAndUseAsSupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportObjectHidesCurrentPackage.kt")
            public void testImportObjectHidesCurrentPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportObjectHidesCurrentPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportOverloadFunctions.kt")
            public void testImportOverloadFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportOverloadFunctions.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportProtectedClass.kt")
            public void testImportProtectedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportProtectedClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportResolutionOrder.kt")
            public void testImportResolutionOrder() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportResolutionOrder.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportTwoTimes.kt")
            public void testImportTwoTimes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportTwoTimes.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportTwoTimesStar.kt")
            public void testImportTwoTimesStar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportTwoTimesStar.kt");
                doTest(fileName);
            }

            @TestMetadata("Imports.kt")
            public void testImports() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/Imports.kt");
                doTest(fileName);
            }

            @TestMetadata("ImportsConflicting.kt")
            public void testImportsConflicting() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/ImportsConflicting.kt");
                doTest(fileName);
            }

            @TestMetadata("InaccessiblePrivateClass.kt")
            public void testInaccessiblePrivateClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/InaccessiblePrivateClass.kt");
                doTest(fileName);
            }

            @TestMetadata("JavaPackageLocalClassNotImported.kt")
            public void testJavaPackageLocalClassNotImported() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/JavaPackageLocalClassNotImported.kt");
                doTest(fileName);
            }

            @TestMetadata("MalformedImports.kt")
            public void testMalformedImports() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/MalformedImports.kt");
                doTest(fileName);
            }

            @TestMetadata("NestedClassClash.kt")
            public void testNestedClassClash() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/NestedClassClash.kt");
                doTest(fileName);
            }

            @TestMetadata("PackageLocalClassNotImported.kt")
            public void testPackageLocalClassNotImported() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/PackageLocalClassNotImported.kt");
                doTest(fileName);
            }

            @TestMetadata("PackageLocalClassReferencedError.kt")
            public void testPackageLocalClassReferencedError() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/PackageLocalClassReferencedError.kt");
                doTest(fileName);
            }

            @TestMetadata("PackageVsClass.kt")
            public void testPackageVsClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/PackageVsClass.kt");
                doTest(fileName);
            }

            @TestMetadata("PrivateClassNotImported.kt")
            public void testPrivateClassNotImported() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/PrivateClassNotImported.kt");
                doTest(fileName);
            }

            @TestMetadata("PrivateClassReferencedError.kt")
            public void testPrivateClassReferencedError() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/PrivateClassReferencedError.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyClassFileDependencyRecursion.kt")
            public void testPropertyClassFileDependencyRecursion() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/propertyClassFileDependencyRecursion.kt");
                doTest(fileName);
            }

            @TestMetadata("RenameOnImport.kt")
            public void testRenameOnImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/RenameOnImport.kt");
                doTest(fileName);
            }

            @TestMetadata("StarImportFromObject.kt")
            public void testStarImportFromObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/StarImportFromObject.kt");
                doTest(fileName);
            }

            @TestMetadata("SyntaxError.kt")
            public void testSyntaxError() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/SyntaxError.kt");
                doTest(fileName);
            }

            @TestMetadata("TopLevelClassVsPackage.kt")
            public void testTopLevelClassVsPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/TopLevelClassVsPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("WrongImport.kt")
            public void testWrongImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/imports/WrongImport.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/incompleteCode")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IncompleteCode extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInIncompleteCode() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/incompleteCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrayBracketsRange.kt")
            public void testArrayBracketsRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/arrayBracketsRange.kt");
                doTest(fileName);
            }

            @TestMetadata("checkNothingIsSubtype.kt")
            public void testCheckNothingIsSubtype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/checkNothingIsSubtype.kt");
                doTest(fileName);
            }

            @TestMetadata("controlStructuresErrors.kt")
            public void testControlStructuresErrors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/controlStructuresErrors.kt");
                doTest(fileName);
            }

            @TestMetadata("illegalSelectorCallableReference.kt")
            public void testIllegalSelectorCallableReference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/illegalSelectorCallableReference.kt");
                doTest(fileName);
            }

            @TestMetadata("inExpr.kt")
            public void testInExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/inExpr.kt");
                doTest(fileName);
            }

            @TestMetadata("incompleteAssignment.kt")
            public void testIncompleteAssignment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/incompleteAssignment.kt");
                doTest(fileName);
            }

            @TestMetadata("incompleteEquals.kt")
            public void testIncompleteEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/incompleteEquals.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1955.kt")
            public void testKt1955() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/kt1955.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2014.kt")
            public void testKt2014() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/kt2014.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4866UnresolvedArrayAccess.kt")
            public void testKt4866UnresolvedArrayAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/kt4866UnresolvedArrayAccess.kt");
                doTest(fileName);
            }

            @TestMetadata("NoSenselessComparisonForErrorType.kt")
            public void testNoSenselessComparisonForErrorType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/NoSenselessComparisonForErrorType.kt");
                doTest(fileName);
            }

            @TestMetadata("plusOnTheRight.kt")
            public void testPlusOnTheRight() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/plusOnTheRight.kt");
                doTest(fileName);
            }

            @TestMetadata("pseudocodeTraverseNextInstructions.kt")
            public void testPseudocodeTraverseNextInstructions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/pseudocodeTraverseNextInstructions.kt");
                doTest(fileName);
            }

            @TestMetadata("senselessComparisonWithNull.kt")
            public void testSenselessComparisonWithNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/senselessComparisonWithNull.kt");
                doTest(fileName);
            }

            @TestMetadata("SupertypeOfErrorType.kt")
            public void testSupertypeOfErrorType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/SupertypeOfErrorType.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParameterOnLhsOfDot.kt")
            public void testTypeParameterOnLhsOfDot() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/typeParameterOnLhsOfDot.kt");
                doTest(fileName);
            }

            @TestMetadata("unresolvedArguments.kt")
            public void testUnresolvedArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/unresolvedArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("unresolvedOperation.kt")
            public void testUnresolvedOperation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/unresolvedOperation.kt");
                doTest(fileName);
            }

            @TestMetadata("variableDeclarationInSelector.kt")
            public void testVariableDeclarationInSelector() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/variableDeclarationInSelector.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DiagnosticWithSyntaxError extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInDiagnosticWithSyntaxError() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("arrayExpression.kt")
                public void testArrayExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/arrayExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("checkBackingFieldException.kt")
                public void testCheckBackingFieldException() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/checkBackingFieldException.kt");
                    doTest(fileName);
                }

                @TestMetadata("completeFunctionArgumentsOfNestedCalls.kt")
                public void testCompleteFunctionArgumentsOfNestedCalls() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/completeFunctionArgumentsOfNestedCalls.kt");
                    doTest(fileName);
                }

                @TestMetadata("declarationAfterDotSelectorExpected.kt")
                public void testDeclarationAfterDotSelectorExpected() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/declarationAfterDotSelectorExpected.kt");
                    doTest(fileName);
                }

                @TestMetadata("declarationAfterIncompleteElvis.kt")
                public void testDeclarationAfterIncompleteElvis() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/declarationAfterIncompleteElvis.kt");
                    doTest(fileName);
                }

                @TestMetadata("funEquals.kt")
                public void testFunEquals() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funEquals.kt");
                    doTest(fileName);
                }

                @TestMetadata("funKeyword.kt")
                public void testFunKeyword() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funKeyword.kt");
                    doTest(fileName);
                }

                @TestMetadata("funcitonTypes.kt")
                public void testFuncitonTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funcitonTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("incompleteEnumReference.kt")
                public void testIncompleteEnumReference() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteEnumReference.kt");
                    doTest(fileName);
                }

                @TestMetadata("incompleteVal.kt")
                public void testIncompleteVal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteVal.kt");
                    doTest(fileName);
                }

                @TestMetadata("incompleteValWithAccessor.kt")
                public void testIncompleteValWithAccessor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteValWithAccessor.kt");
                    doTest(fileName);
                }

                @TestMetadata("incompleteWhen.kt")
                public void testIncompleteWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteWhen.kt");
                    doTest(fileName);
                }

                @TestMetadata("namedFun.kt")
                public void testNamedFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/namedFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("noTypeParamsInReturnType.kt")
                public void testNoTypeParamsInReturnType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/noTypeParamsInReturnType.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeReferenceError.kt")
                public void testTypeReferenceError() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/typeReferenceError.kt");
                    doTest(fileName);
                }

                @TestMetadata("valNoName.kt")
                public void testValNoName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valNoName.kt");
                    doTest(fileName);
                }

                @TestMetadata("valWithNoNameBeforeNextDeclarationWithModifiers.kt")
                public void testValWithNoNameBeforeNextDeclarationWithModifiers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valWithNoNameBeforeNextDeclarationWithModifiers.kt");
                    doTest(fileName);
                }

                @TestMetadata("valWithNoNameInBlock.kt")
                public void testValWithNoNameInBlock() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valWithNoNameInBlock.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/inference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inference extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInInference() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("cannotCompleteResolveAmbiguity.kt")
            public void testCannotCompleteResolveAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("cannotCompleteResolveFunctionLiteralsNoUse.kt")
            public void testCannotCompleteResolveFunctionLiteralsNoUse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveFunctionLiteralsNoUse.kt");
                doTest(fileName);
            }

            @TestMetadata("cannotCompleteResolveNoInfoForParameter.kt")
            public void testCannotCompleteResolveNoInfoForParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveNoInfoForParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("cannotCompleteResolveNoneApplicable.kt")
            public void testCannotCompleteResolveNoneApplicable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveNoneApplicable.kt");
                doTest(fileName);
            }

            @TestMetadata("cannotCompleteResolveWithFunctionLiterals.kt")
            public void testCannotCompleteResolveWithFunctionLiterals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveWithFunctionLiterals.kt");
                doTest(fileName);
            }

            @TestMetadata("completeInferenceIfManyFailed.kt")
            public void testCompleteInferenceIfManyFailed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/completeInferenceIfManyFailed.kt");
                doTest(fileName);
            }

            @TestMetadata("conflictingSubstitutions.kt")
            public void testConflictingSubstitutions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/conflictingSubstitutions.kt");
                doTest(fileName);
            }

            @TestMetadata("dependOnExpectedType.kt")
            public void testDependOnExpectedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/dependOnExpectedType.kt");
                doTest(fileName);
            }

            @TestMetadata("dependantOnVariance.kt")
            public void testDependantOnVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/dependantOnVariance.kt");
                doTest(fileName);
            }

            @TestMetadata("dependantOnVarianceNullable.kt")
            public void testDependantOnVarianceNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/dependantOnVarianceNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("functionPlaceholderError.kt")
            public void testFunctionPlaceholderError() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/functionPlaceholderError.kt");
                doTest(fileName);
            }

            @TestMetadata("hasErrorInConstrainingTypes.kt")
            public void testHasErrorInConstrainingTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/hasErrorInConstrainingTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("immutableArrayList.kt")
            public void testImmutableArrayList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/immutableArrayList.kt");
                doTest(fileName);
            }

            @TestMetadata("inferInFunctionLiterals.kt")
            public void testInferInFunctionLiterals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/inferInFunctionLiterals.kt");
                doTest(fileName);
            }

            @TestMetadata("inferInFunctionLiteralsWithReturn.kt")
            public void testInferInFunctionLiteralsWithReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/inferInFunctionLiteralsWithReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1293.kt")
            public void testKt1293() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/kt1293.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3184.kt")
            public void testKt3184() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/kt3184.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6175.kt")
            public void testKt6175() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/kt6175.kt");
                doTest(fileName);
            }

            @TestMetadata("kt619.kt")
            public void testKt619() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/kt619.kt");
                doTest(fileName);
            }

            @TestMetadata("listConstructor.kt")
            public void testListConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/listConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("mapFunction.kt")
            public void testMapFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/mapFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("mostSpecificAfterInference.kt")
            public void testMostSpecificAfterInference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/mostSpecificAfterInference.kt");
                doTest(fileName);
            }

            @TestMetadata("NoInferenceFromDeclaredBounds.kt")
            public void testNoInferenceFromDeclaredBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/NoInferenceFromDeclaredBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("noInformationForParameter.kt")
            public void testNoInformationForParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/noInformationForParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("nullableUpperBound.kt")
            public void testNullableUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nullableUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("opposite.kt")
            public void testOpposite() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/opposite.kt");
                doTest(fileName);
            }

            @TestMetadata("possibleCycleOnConstraints.kt")
            public void testPossibleCycleOnConstraints() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/possibleCycleOnConstraints.kt");
                doTest(fileName);
            }

            @TestMetadata("tryNumberLowerBoundsBeforeUpperBounds.kt")
            public void testTryNumberLowerBoundsBeforeUpperBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/tryNumberLowerBoundsBeforeUpperBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("typeConstructorMismatch.kt")
            public void testTypeConstructorMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/typeConstructorMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("typeInferenceExpectedTypeMismatch.kt")
            public void testTypeInferenceExpectedTypeMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/typeInferenceExpectedTypeMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("useFunctionLiteralsToInferType.kt")
            public void testUseFunctionLiteralsToInferType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/useFunctionLiteralsToInferType.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CapturedTypes extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInCapturedTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/capturedTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("cannotCaptureInProjection.kt")
                public void testCannotCaptureInProjection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/cannotCaptureInProjection.kt");
                    doTest(fileName);
                }

                @TestMetadata("captureForNullableTypes.kt")
                public void testCaptureForNullableTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/captureForNullableTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("captureForPlatformTypes.kt")
                public void testCaptureForPlatformTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/captureForPlatformTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("captureFromNullableTypeVariable.kt")
                public void testCaptureFromNullableTypeVariable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromNullableTypeVariable.kt");
                    doTest(fileName);
                }

                @TestMetadata("captureTypeOnlyOnTopLevel.kt")
                public void testCaptureTypeOnlyOnTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/captureTypeOnlyOnTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("capturedType.kt")
                public void testCapturedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("capturedTypeAndApproximation.kt")
                public void testCapturedTypeAndApproximation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeAndApproximation.kt");
                    doTest(fileName);
                }

                @TestMetadata("capturedTypeSubstitutedIntoOppositeProjection.kt")
                public void testCapturedTypeSubstitutedIntoOppositeProjection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeSubstitutedIntoOppositeProjection.kt");
                    doTest(fileName);
                }

                @TestMetadata("expectedTypeMismatchWithInVariance.kt")
                public void testExpectedTypeMismatchWithInVariance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/expectedTypeMismatchWithInVariance.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2570.kt")
                public void testKt2570() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/kt2570.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2872.kt")
                public void testKt2872() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/kt2872.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberScopeOfCaptured.kt")
                public void testMemberScopeOfCaptured() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/memberScopeOfCaptured.kt");
                    doTest(fileName);
                }

                @TestMetadata("noCaptureTypeErrorForNonTopLevel.kt")
                public void testNoCaptureTypeErrorForNonTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/noCaptureTypeErrorForNonTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("notApproximateWhenCopyDescriptors.kt")
                public void testNotApproximateWhenCopyDescriptors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/notApproximateWhenCopyDescriptors.kt");
                    doTest(fileName);
                }

                @TestMetadata("overApproximationForInCaptured.kt")
                public void testOverApproximationForInCaptured() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/overApproximationForInCaptured.kt");
                    doTest(fileName);
                }

                @TestMetadata("overApproximationForOutCaptured.kt")
                public void testOverApproximationForOutCaptured() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes/overApproximationForOutCaptured.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/commonSystem")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CommonSystem extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInCommonSystem() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/commonSystem"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("boundOnNullableVariable.kt")
                public void testBoundOnNullableVariable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/commonSystem/boundOnNullableVariable.kt");
                    doTest(fileName);
                }

                @TestMetadata("dontCaptureTypeVariable.kt")
                public void testDontCaptureTypeVariable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/commonSystem/dontCaptureTypeVariable.kt");
                    doTest(fileName);
                }

                @TestMetadata("fixVariablesInRightOrder.kt")
                public void testFixVariablesInRightOrder() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/commonSystem/fixVariablesInRightOrder.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericCandidateInGenericClass.kt")
                public void testGenericCandidateInGenericClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/commonSystem/genericCandidateInGenericClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inferenceWithUpperBoundsInLambda.kt")
                public void testInferenceWithUpperBoundsInLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/commonSystem/inferenceWithUpperBoundsInLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3372toCollection.kt")
                public void testKt3372toCollection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/commonSystem/kt3372toCollection.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedLambdas.kt")
                public void testNestedLambdas() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/commonSystem/nestedLambdas.kt");
                    doTest(fileName);
                }

                @TestMetadata("theSameFunctionInArgs.kt")
                public void testTheSameFunctionInArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/commonSystem/theSameFunctionInArgs.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/constraints")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Constraints extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInConstraints() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/constraints"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("constraintOnFunctionLiteral.kt")
                public void testConstraintOnFunctionLiteral() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/constraints/constraintOnFunctionLiteral.kt");
                    doTest(fileName);
                }

                @TestMetadata("equalityConstraintOnNullableType.kt")
                public void testEqualityConstraintOnNullableType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/constraints/equalityConstraintOnNullableType.kt");
                    doTest(fileName);
                }

                @TestMetadata("ignoreConstraintFromImplicitInNothing.kt")
                public void testIgnoreConstraintFromImplicitInNothing() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/constraints/ignoreConstraintFromImplicitInNothing.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt6320.kt")
                public void testKt6320() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/constraints/kt6320.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt7351ConstraintFromUnitExpectedType.kt")
                public void testKt7351ConstraintFromUnitExpectedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/constraints/kt7351ConstraintFromUnitExpectedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt7433.kt")
                public void testKt7433() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/constraints/kt7433.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt8879.kt")
                public void testKt8879() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/constraints/kt8879.kt");
                    doTest(fileName);
                }

                @TestMetadata("notNullConstraintOnNullableType.kt")
                public void testNotNullConstraintOnNullableType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/constraints/notNullConstraintOnNullableType.kt");
                    doTest(fileName);
                }

                @TestMetadata("subtypeConstraintOnNullableType.kt")
                public void testSubtypeConstraintOnNullableType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/constraints/subtypeConstraintOnNullableType.kt");
                    doTest(fileName);
                }

                @TestMetadata("supertypeConstraintOnNullableType.kt")
                public void testSupertypeConstraintOnNullableType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/constraints/supertypeConstraintOnNullableType.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NestedCalls extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInNestedCalls() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/nestedCalls"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("arrayAccess.kt")
                public void testArrayAccess() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/arrayAccess.kt");
                    doTest(fileName);
                }

                @TestMetadata("binaryExpressions.kt")
                public void testBinaryExpressions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/binaryExpressions.kt");
                    doTest(fileName);
                }

                @TestMetadata("checkTypesForQualifiedProperties.kt")
                public void testCheckTypesForQualifiedProperties() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/checkTypesForQualifiedProperties.kt");
                    doTest(fileName);
                }

                @TestMetadata("completeNestedCallsForArraySetExpression.kt")
                public void testCompleteNestedCallsForArraySetExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedCallsForArraySetExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("completeNestedCallsInference.kt")
                public void testCompleteNestedCallsInference() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedCallsInference.kt");
                    doTest(fileName);
                }

                @TestMetadata("completeNestedForVariableAsFunctionCall.kt")
                public void testCompleteNestedForVariableAsFunctionCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedForVariableAsFunctionCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("externalTypeParameter.kt")
                public void testExternalTypeParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/externalTypeParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("inferenceForNestedBinaryCall.kt")
                public void testInferenceForNestedBinaryCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/inferenceForNestedBinaryCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3395.kt")
                public void testKt3395() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/kt3395.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3461checkTypes.kt")
                public void testKt3461checkTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/kt3461checkTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("makeNullableIfSafeCall.kt")
                public void testMakeNullableIfSafeCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/makeNullableIfSafeCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("nontrivialCallExpression.kt")
                public void testNontrivialCallExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls/nontrivialCallExpression.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class RecursiveLocalFuns extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInRecursiveLocalFuns() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("localFactorial.kt")
                public void testLocalFactorial() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/localFactorial.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveFun.kt")
                public void testRecursiveFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/recursiveFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveLambda.kt")
                public void testRecursiveLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/recursiveLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("selfCall.kt")
                public void testSelfCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/selfCall.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/regressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Regressions extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInRegressions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/regressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compareBy.kt")
                public void testCompareBy() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/compareBy.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt1029.kt")
                public void testKt1029() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt1029.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt1031.kt")
                public void testKt1031() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt1031.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt1127.kt")
                public void testKt1127() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt1127.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt1145.kt")
                public void testKt1145() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt1145.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt1358.kt")
                public void testKt1358() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt1358.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt1410.kt")
                public void testKt1410() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt1410.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt1718.kt")
                public void testKt1718() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt1718.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt1944.kt")
                public void testKt1944() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt1944.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2057.kt")
                public void testKt2057() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2057.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2179.kt")
                public void testKt2179() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2179.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2200.kt")
                public void testKt2200() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2200.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2283.kt")
                public void testKt2283() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2283.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2286.kt")
                public void testKt2286() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2286.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2294.kt")
                public void testKt2294() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2294.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2320.kt")
                public void testKt2320() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2320.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2324.kt")
                public void testKt2324() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2324.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2407.kt")
                public void testKt2407() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2407.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2445.kt")
                public void testKt2445() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2445.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2459.kt")
                public void testKt2459() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2459.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2484.kt")
                public void testKt2484() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2484.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2505.kt")
                public void testKt2505() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2505.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2514.kt")
                public void testKt2514() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2514.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2588.kt")
                public void testKt2588() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2588.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2741.kt")
                public void testKt2741() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2741.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2754.kt")
                public void testKt2754() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2754.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2838.kt")
                public void testKt2838() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2838.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2841.kt")
                public void testKt2841() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2841.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2841_it.kt")
                public void testKt2841_it() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2841_it.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2841_it_this.kt")
                public void testKt2841_it_this() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2841_it_this.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2841_this.kt")
                public void testKt2841_this() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2841_this.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2842.kt")
                public void testKt2842() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2842.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2883.kt")
                public void testKt2883() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt2883.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3007.kt")
                public void testKt3007() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt3007.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3038.kt")
                public void testKt3038() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt3038.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3150.kt")
                public void testKt3150() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt3150.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3174.kt")
                public void testKt3174() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt3174.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3301.kt")
                public void testKt3301() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt3301.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3344.kt")
                public void testKt3344() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt3344.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3496.kt")
                public void testKt3496() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt3496.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3496_2.kt")
                public void testKt3496_2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt3496_2.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3559.kt")
                public void testKt3559() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt3559.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt4420.kt")
                public void testKt4420() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt4420.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt702.kt")
                public void testKt702() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt702.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt731.kt")
                public void testKt731() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt731.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt742.kt")
                public void testKt742() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt742.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt8132.kt")
                public void testKt8132() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt8132.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt832.kt")
                public void testKt832() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt832.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt943.kt")
                public void testKt943() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt943.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt9461.kt")
                public void testKt9461() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt9461.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt948.kt")
                public void testKt948() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/kt948.kt");
                    doTest(fileName);
                }

                @TestMetadata("noRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor.kt")
                public void testNoRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/regressions/noRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/reportingImprovements")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ReportingImprovements extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInReportingImprovements() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/reportingImprovements"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("cannotInferParameterTypeWithInference.kt")
                public void testCannotInferParameterTypeWithInference() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/reportingImprovements/cannotInferParameterTypeWithInference.kt");
                    doTest(fileName);
                }

                @TestMetadata("ErrorTypeAsGenericParameter.kt")
                public void testErrorTypeAsGenericParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/reportingImprovements/ErrorTypeAsGenericParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunctionPlaceholder.kt")
                public void testFunctionPlaceholder() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/reportingImprovements/FunctionPlaceholder.kt");
                    doTest(fileName);
                }

                @TestMetadata("NoAmbiguityForDifferentFunctionTypes.kt")
                public void testNoAmbiguityForDifferentFunctionTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/reportingImprovements/NoAmbiguityForDifferentFunctionTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("subtypeForInvariantWithErrorGenerics.kt")
                public void testSubtypeForInvariantWithErrorGenerics() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/reportingImprovements/subtypeForInvariantWithErrorGenerics.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/substitutions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Substitutions extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInSubstitutions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/substitutions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegationAndInference.kt")
                public void testDelegationAndInference() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/substitutions/delegationAndInference.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt6081SubstituteIntoClassCorrectly.kt")
                public void testKt6081SubstituteIntoClassCorrectly() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/substitutions/kt6081SubstituteIntoClassCorrectly.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleSubstitutionCheckTypeArgumentsNotTypeParameters.kt")
                public void testSimpleSubstitutionCheckTypeArgumentsNotTypeParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/substitutions/simpleSubstitutionCheckTypeArgumentsNotTypeParameters.kt");
                    doTest(fileName);
                }

                @TestMetadata("substitutionIntoAnonymousClass.kt")
                public void testSubstitutionIntoAnonymousClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/substitutions/substitutionIntoAnonymousClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("substitutionIntoInnerClass.kt")
                public void testSubstitutionIntoInnerClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/substitutions/substitutionIntoInnerClass.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inference/upperBounds")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class UpperBounds extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInUpperBounds() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/upperBounds"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("conflictingSubstitutionsFromUpperBound.kt")
                public void testConflictingSubstitutionsFromUpperBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/upperBounds/conflictingSubstitutionsFromUpperBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("doNotInferFromBoundsOnly.kt")
                public void testDoNotInferFromBoundsOnly() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/upperBounds/doNotInferFromBoundsOnly.kt");
                    doTest(fileName);
                }

                @TestMetadata("intersectUpperBounds.kt")
                public void testIntersectUpperBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/upperBounds/intersectUpperBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt2856.kt")
                public void testKt2856() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/upperBounds/kt2856.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonNullUpperBound.kt")
                public void testNonNullUpperBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/upperBounds/nonNullUpperBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("useBoundsIfUnknownParameters.kt")
                public void testUseBoundsIfUnknownParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/upperBounds/useBoundsIfUnknownParameters.kt");
                    doTest(fileName);
                }

                @TestMetadata("useBoundsToInferTypeParamsSimple.kt")
                public void testUseBoundsToInferTypeParamsSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inference/upperBounds/useBoundsToInferTypeParamsSimple.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/infos")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Infos extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInInfos() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/infos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("PropertiesWithBackingFields.kt")
            public void testPropertiesWithBackingFields() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/infos/PropertiesWithBackingFields.kt");
                doTest(fileName);
            }

            @TestMetadata("SmartCasts.kt")
            public void testSmartCasts() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/infos/SmartCasts.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/inline")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inline extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInInline() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("anonymousObjects.kt")
            public void testAnonymousObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/anonymousObjects.kt");
                doTest(fileName);
            }

            @TestMetadata("assignment.kt")
            public void testAssignment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/assignment.kt");
                doTest(fileName);
            }

            @TestMetadata("capture.kt")
            public void testCapture() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/capture.kt");
                doTest(fileName);
            }

            @TestMetadata("constructor.kt")
            public void testConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/constructor.kt");
                doTest(fileName);
            }

            @TestMetadata("default.kt")
            public void testDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/default.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionOnFunction.kt")
            public void testExtensionOnFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/extensionOnFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("fromInlineToNoInline.kt")
            public void testFromInlineToNoInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/fromInlineToNoInline.kt");
                doTest(fileName);
            }

            @TestMetadata("functions.kt")
            public void testFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/functions.kt");
                doTest(fileName);
            }

            @TestMetadata("inlineReified.kt")
            public void testInlineReified() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/inlineReified.kt");
                doTest(fileName);
            }

            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/invoke.kt");
                doTest(fileName);
            }

            @TestMetadata("isCheck.kt")
            public void testIsCheck() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/isCheck.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4869.kt")
            public void testKt4869() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/kt4869.kt");
                doTest(fileName);
            }

            @TestMetadata("labeled.kt")
            public void testLabeled() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/labeled.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaCast.kt")
            public void testLambdaCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/lambdaCast.kt");
                doTest(fileName);
            }

            @TestMetadata("localFun.kt")
            public void testLocalFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/localFun.kt");
                doTest(fileName);
            }

            @TestMetadata("nonVirtualMembersWithInline.kt")
            public void testNonVirtualMembersWithInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonVirtualMembersWithInline.kt");
                doTest(fileName);
            }

            @TestMetadata("nothingToInline.kt")
            public void testNothingToInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nothingToInline.kt");
                doTest(fileName);
            }

            @TestMetadata("nullabilityOperations.kt")
            public void testNullabilityOperations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nullabilityOperations.kt");
                doTest(fileName);
            }

            @TestMetadata("nullableFunction.kt")
            public void testNullableFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nullableFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("overrideWithInline.kt")
            public void testOverrideWithInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/overrideWithInline.kt");
                doTest(fileName);
            }

            @TestMetadata("parenthesized.kt")
            public void testParenthesized() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/parenthesized.kt");
                doTest(fileName);
            }

            @TestMetadata("privateClass.kt")
            public void testPrivateClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/privateClass.kt");
                doTest(fileName);
            }

            @TestMetadata("propagation.kt")
            public void testPropagation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/propagation.kt");
                doTest(fileName);
            }

            @TestMetadata("recursion.kt")
            public void testRecursion() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/recursion.kt");
                doTest(fileName);
            }

            @TestMetadata("returns.kt")
            public void testReturns() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/returns.kt");
                doTest(fileName);
            }

            @TestMetadata("sam.kt")
            public void testSam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/sam.kt");
                doTest(fileName);
            }

            @TestMetadata("stringTemplate.kt")
            public void testStringTemplate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/stringTemplate.kt");
                doTest(fileName);
            }

            @TestMetadata("unsupportedConstruction.kt")
            public void testUnsupportedConstruction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/unsupportedConstruction.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/vararg.kt");
                doTest(fileName);
            }

            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/when.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongUsage.kt")
            public void testWrongUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/wrongUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class BinaryExpressions extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInBinaryExpressions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/binaryExpressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("andOr.kt")
                public void testAndOr() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions/andOr.kt");
                    doTest(fileName);
                }

                @TestMetadata("arrayAccess.kt")
                public void testArrayAccess() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions/arrayAccess.kt");
                    doTest(fileName);
                }

                @TestMetadata("assignment.kt")
                public void testAssignment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions/assignment.kt");
                    doTest(fileName);
                }

                @TestMetadata("comparison.kt")
                public void testComparison() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions/comparison.kt");
                    doTest(fileName);
                }

                @TestMetadata("componentAccess.kt")
                public void testComponentAccess() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions/componentAccess.kt");
                    doTest(fileName);
                }

                @TestMetadata("contains.kt")
                public void testContains() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions/contains.kt");
                    doTest(fileName);
                }

                @TestMetadata("mathOperations.kt")
                public void testMathOperations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions/mathOperations.kt");
                    doTest(fileName);
                }

                @TestMetadata("rangeTo.kt")
                public void testRangeTo() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions/rangeTo.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NonLocalReturns extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInNonLocalReturns() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("anonymousObjects.kt")
                public void testAnonymousObjects() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/anonymousObjects.kt");
                    doTest(fileName);
                }

                @TestMetadata("anonymousObjectsNested.kt")
                public void testAnonymousObjectsNested() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/anonymousObjectsNested.kt");
                    doTest(fileName);
                }

                @TestMetadata("explicitReturnType.kt")
                public void testExplicitReturnType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/explicitReturnType.kt");
                    doTest(fileName);
                }

                @TestMetadata("fromOnlyLocal.kt")
                public void testFromOnlyLocal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/fromOnlyLocal.kt");
                    doTest(fileName);
                }

                @TestMetadata("inlineLambda.kt")
                public void testInlineLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/inlineLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("labeledReturn.kt")
                public void testLabeledReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/labeledReturn.kt");
                    doTest(fileName);
                }

                @TestMetadata("lambdaAsGeneric.kt")
                public void testLambdaAsGeneric() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaAsGeneric.kt");
                    doTest(fileName);
                }

                @TestMetadata("lambdaAsNonFunction.kt")
                public void testLambdaAsNonFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaAsNonFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("lambdaWithGlobalReturnsInsideOnlyLocalOne.kt")
                public void testLambdaWithGlobalReturnsInsideOnlyLocalOne() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaWithGlobalReturnsInsideOnlyLocalOne.kt");
                    doTest(fileName);
                }

                @TestMetadata("localFun.kt")
                public void testLocalFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/localFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedNonLocals.kt")
                public void testNestedNonLocals() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/nestedNonLocals.kt");
                    doTest(fileName);
                }

                @TestMetadata("noInlineAnnotation.kt")
                public void testNoInlineAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/noInlineAnnotation.kt");
                    doTest(fileName);
                }

                @TestMetadata("noInlineLambda.kt")
                public void testNoInlineLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/noInlineLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonInlinedClass.kt")
                public void testNonInlinedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/nonInlinedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("onlyLocalReturnLambda.kt")
                public void testOnlyLocalReturnLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/onlyLocalReturnLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("onlyLocalReturnLambdaBinaryExpr.kt")
                public void testOnlyLocalReturnLambdaBinaryExpr() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/onlyLocalReturnLambdaBinaryExpr.kt");
                    doTest(fileName);
                }

                @TestMetadata("propertyAccessorsAndConstructor.kt")
                public void testPropertyAccessorsAndConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/propertyAccessorsAndConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("toOnlyLocal.kt")
                public void testToOnlyLocal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns/toOnlyLocal.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NonPublicMember extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInNonPublicMember() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/nonPublicMember"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("inNonPublicClass.kt")
                public void testInNonPublicClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember/inNonPublicClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inNonPublicInnerClass.kt")
                public void testInNonPublicInnerClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember/inNonPublicInnerClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPackage.kt")
                public void testInPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember/inPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPublicClass.kt")
                public void testInPublicClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember/inPublicClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt14887.kt")
                public void testKt14887() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember/kt14887.kt");
                    doTest(fileName);
                }

                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember/localClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("localClass2.kt")
                public void testLocalClass2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember/localClass2.kt");
                    doTest(fileName);
                }

                @TestMetadata("localFun.kt")
                public void testLocalFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember/localFun.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/property")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Property extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInProperty() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("invoke.kt")
                public void testInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/property/invoke.kt");
                    doTest(fileName);
                }

                @TestMetadata("propertyWithBackingField.kt")
                public void testPropertyWithBackingField() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/property/propertyWithBackingField.kt");
                    doTest(fileName);
                }

                @TestMetadata("unsupportedConstruction.kt")
                public void testUnsupportedConstruction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/property/unsupportedConstruction.kt");
                    doTest(fileName);
                }

                @TestMetadata("virtualProperty.kt")
                public void testVirtualProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/property/virtualProperty.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/regressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Regressions extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInRegressions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/regressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt4341.kt")
                public void testKt4341() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/regressions/kt4341.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inline/unaryExpressions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class UnaryExpressions extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInUnaryExpressions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/unaryExpressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("mathOperation.kt")
                public void testMathOperation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/unaryExpressions/mathOperation.kt");
                    doTest(fileName);
                }

                @TestMetadata("notOnCall.kt")
                public void testNotOnCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/unaryExpressions/notOnCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("notOperation.kt")
                public void testNotOperation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inline/unaryExpressions/notOperation.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/inner")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inner extends AbstractDiagnosticsTest {
            @TestMetadata("accessingToJavaNestedClass.kt")
            public void testAccessingToJavaNestedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/accessingToJavaNestedClass.kt");
                doTest(fileName);
            }

            @TestMetadata("accessingToKotlinNestedClass.kt")
            public void testAccessingToKotlinNestedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/accessingToKotlinNestedClass.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInInner() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inner"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classesInClassObjectHeader.kt")
            public void testClassesInClassObjectHeader() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/classesInClassObjectHeader.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorAccess.kt")
            public void testConstructorAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/constructorAccess.kt");
                doTest(fileName);
            }

            @TestMetadata("deepInnerClass.kt")
            public void testDeepInnerClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/deepInnerClass.kt");
                doTest(fileName);
            }

            @TestMetadata("enumEntries.kt")
            public void testEnumEntries() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/enumEntries.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFun.kt")
            public void testExtensionFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/extensionFun.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionLambdaInsideNestedClass.kt")
            public void testExtensionLambdaInsideNestedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/extensionLambdaInsideNestedClass.kt");
                doTest(fileName);
            }

            @TestMetadata("illegalModifier.kt")
            public void testIllegalModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/illegalModifier.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerClassNameClash.kt")
            public void testInnerClassNameClash() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/InnerClassNameClash.kt");
                doTest(fileName);
            }

            @TestMetadata("innerClassesInStaticParameters.kt")
            public void testInnerClassesInStaticParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/innerClassesInStaticParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("innerErrorForClassObjects.kt")
            public void testInnerErrorForClassObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/innerErrorForClassObjects.kt");
                doTest(fileName);
            }

            @TestMetadata("innerErrorForObjects.kt")
            public void testInnerErrorForObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/innerErrorForObjects.kt");
                doTest(fileName);
            }

            @TestMetadata("innerThisSuper.kt")
            public void testInnerThisSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/innerThisSuper.kt");
                doTest(fileName);
            }

            @TestMetadata("kt5854.kt")
            public void testKt5854() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/kt5854.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6026.kt")
            public void testKt6026() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/kt6026.kt");
                doTest(fileName);
            }

            @TestMetadata("localClass.kt")
            public void testLocalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/localClass.kt");
                doTest(fileName);
            }

            @TestMetadata("localClassInsideNested.kt")
            public void testLocalClassInsideNested() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/localClassInsideNested.kt");
                doTest(fileName);
            }

            @TestMetadata("localThisSuper.kt")
            public void testLocalThisSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/localThisSuper.kt");
                doTest(fileName);
            }

            @TestMetadata("modality.kt")
            public void testModality() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/modality.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClassAccessedViaInstanceReference.kt")
            public void testNestedClassAccessedViaInstanceReference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/nestedClassAccessedViaInstanceReference.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClassExtendsOuter.kt")
            public void testNestedClassExtendsOuter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/nestedClassExtendsOuter.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClassExtendsOuterGeneric.kt")
            public void testNestedClassExtendsOuterGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/nestedClassExtendsOuterGeneric.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClassInObject.kt")
            public void testNestedClassInObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/nestedClassInObject.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClassNotAllowed.kt")
            public void testNestedClassNotAllowed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/nestedClassNotAllowed.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedVsInnerAccessOuterMember.kt")
            public void testNestedVsInnerAccessOuterMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/nestedVsInnerAccessOuterMember.kt");
                doTest(fileName);
            }

            @TestMetadata("outerGenericParam.kt")
            public void testOuterGenericParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/outerGenericParam.kt");
                doTest(fileName);
            }

            @TestMetadata("outerProtectedMember.kt")
            public void testOuterProtectedMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/outerProtectedMember.kt");
                doTest(fileName);
            }

            @TestMetadata("outerSuperClassMember.kt")
            public void testOuterSuperClassMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/outerSuperClassMember.kt");
                doTest(fileName);
            }

            @TestMetadata("referenceToSelfInLocal.kt")
            public void testReferenceToSelfInLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/referenceToSelfInLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("resolvePackageClassInObjects.kt")
            public void testResolvePackageClassInObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/resolvePackageClassInObjects.kt");
                doTest(fileName);
            }

            @TestMetadata("selfAnnotationForClassObject.kt")
            public void testSelfAnnotationForClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/selfAnnotationForClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("traits.kt")
            public void testTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/traits.kt");
                doTest(fileName);
            }

            @TestMetadata("visibility.kt")
            public void testVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/visibility.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class QualifiedExpression extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInQualifiedExpression() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/inner/qualifiedExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classObjectOfNestedClass.kt")
                public void testClassObjectOfNestedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression/classObjectOfNestedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructNestedClass.kt")
                public void testConstructNestedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression/constructNestedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("dataLocalVariable.kt")
                public void testDataLocalVariable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression/dataLocalVariable.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumConstant.kt")
                public void testEnumConstant() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression/enumConstant.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericNestedClass.kt")
                public void testGenericNestedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression/genericNestedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("importNestedClass.kt")
                public void testImportNestedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression/importNestedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedClassInPackage.kt")
                public void testNestedClassInPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedClassInPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedEnumConstant.kt")
                public void testNestedEnumConstant() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedEnumConstant.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedObjects.kt")
                public void testNestedObjects() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedObjects.kt");
                    doTest(fileName);
                }

                @TestMetadata("typePosition.kt")
                public void testTypePosition() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression/typePosition.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/j+k")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class J_k extends AbstractDiagnosticsTest {
            @TestMetadata("accessClassObjectFromJava.kt")
            public void testAccessClassObjectFromJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/accessClassObjectFromJava.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInJ_k() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ambiguousSamAdapters.kt")
            public void testAmbiguousSamAdapters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/ambiguousSamAdapters.kt");
                doTest(fileName);
            }

            @TestMetadata("annotationWithArgumentsMissingDependencies.kt")
            public void testAnnotationWithArgumentsMissingDependencies() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/annotationWithArgumentsMissingDependencies.kt");
                doTest(fileName);
            }

            @TestMetadata("arrayOfStarParametrized.kt")
            public void testArrayOfStarParametrized() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/arrayOfStarParametrized.kt");
                doTest(fileName);
            }

            @TestMetadata("canDeclareIfSamAdapterIsInherited.kt")
            public void testCanDeclareIfSamAdapterIsInherited() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/canDeclareIfSamAdapterIsInherited.kt");
                doTest(fileName);
            }

            @TestMetadata("computeIfAbsentConcurrent.kt")
            public void testComputeIfAbsentConcurrent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/computeIfAbsentConcurrent.kt");
                doTest(fileName);
            }

            @TestMetadata("contravariantIterable.kt")
            public void testContravariantIterable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/contravariantIterable.kt");
                doTest(fileName);
            }

            @TestMetadata("differentFilename.kt")
            public void testDifferentFilename() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/differentFilename.kt");
                doTest(fileName);
            }

            @TestMetadata("enumGetOrdinal.kt")
            public void testEnumGetOrdinal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/enumGetOrdinal.kt");
                doTest(fileName);
            }

            @TestMetadata("fieldOverridesField.kt")
            public void testFieldOverridesField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/fieldOverridesField.kt");
                doTest(fileName);
            }

            @TestMetadata("fieldOverridesFieldOfDifferentType.kt")
            public void testFieldOverridesFieldOfDifferentType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/fieldOverridesFieldOfDifferentType.kt");
                doTest(fileName);
            }

            @TestMetadata("fieldOverridesNothing.kt")
            public void testFieldOverridesNothing() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/fieldOverridesNothing.kt");
                doTest(fileName);
            }

            @TestMetadata("finalCollectionSize.kt")
            public void testFinalCollectionSize() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/finalCollectionSize.kt");
                doTest(fileName);
            }

            @TestMetadata("genericConstructorWithMultipleBounds.kt")
            public void testGenericConstructorWithMultipleBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructorWithMultipleBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("GenericsInSupertypes.kt")
            public void testGenericsInSupertypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/GenericsInSupertypes.kt");
                doTest(fileName);
            }

            @TestMetadata("inheritAbstractSamAdapter.kt")
            public void testInheritAbstractSamAdapter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/inheritAbstractSamAdapter.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritedGenericFunction.kt")
            public void testInheritedGenericFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/InheritedGenericFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerClassFromJava.kt")
            public void testInnerClassFromJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/InnerClassFromJava.kt");
                doTest(fileName);
            }

            @TestMetadata("innerNestedClassFromJava.kt")
            public void testInnerNestedClassFromJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/innerNestedClassFromJava.kt");
                doTest(fileName);
            }

            @TestMetadata("invisiblePackagePrivateInheritedMember.kt")
            public void testInvisiblePackagePrivateInheritedMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/invisiblePackagePrivateInheritedMember.kt");
                doTest(fileName);
            }

            @TestMetadata("javaStaticImport.kt")
            public void testJavaStaticImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/javaStaticImport.kt");
                doTest(fileName);
            }

            @TestMetadata("KJKInheritance.kt")
            public void testKJKInheritance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/KJKInheritance.kt");
                doTest(fileName);
            }

            @TestMetadata("KJKInheritanceGeneric.kt")
            public void testKJKInheritanceGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/KJKInheritanceGeneric.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1402.kt")
            public void testKt1402() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt1402.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1431.kt")
            public void testKt1431() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt1431.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1730_implementCharSequence.kt")
            public void testKt1730_implementCharSequence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt1730_implementCharSequence.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2152.kt")
            public void testKt2152() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt2152.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2394.kt")
            public void testKt2394() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt2394.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2606.kt")
            public void testKt2606() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt2606.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2619.kt")
            public void testKt2619() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt2619.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2641.kt")
            public void testKt2641() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt2641.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2890.kt")
            public void testKt2890() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt2890.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3307.kt")
            public void testKt3307() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt3307.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3311.kt")
            public void testKt3311() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt3311.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6720_abstractProperty.kt")
            public void testKt6720_abstractProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt6720_abstractProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("kt7523.kt")
            public void testKt7523() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/kt7523.kt");
                doTest(fileName);
            }

            @TestMetadata("matchers.kt")
            public void testMatchers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/matchers.kt");
                doTest(fileName);
            }

            @TestMetadata("mutableIterator.kt")
            public void testMutableIterator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/mutableIterator.kt");
                doTest(fileName);
            }

            @TestMetadata("overrideRawType.kt")
            public void testOverrideRawType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/overrideRawType.kt");
                doTest(fileName);
            }

            @TestMetadata("OverrideVararg.kt")
            public void testOverrideVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/OverrideVararg.kt");
                doTest(fileName);
            }

            @TestMetadata("overrideWithSamAndTypeParameter.kt")
            public void testOverrideWithSamAndTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/overrideWithSamAndTypeParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("packagePrivateClassStaticMember.kt")
            public void testPackagePrivateClassStaticMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/packagePrivateClassStaticMember.kt");
                doTest(fileName);
            }

            @TestMetadata("packageVisibility.kt")
            public void testPackageVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/packageVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("privateFieldOverridesNothing.kt")
            public void testPrivateFieldOverridesNothing() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/privateFieldOverridesNothing.kt");
                doTest(fileName);
            }

            @TestMetadata("privateNestedClassStaticMember.kt")
            public void testPrivateNestedClassStaticMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/privateNestedClassStaticMember.kt");
                doTest(fileName);
            }

            @TestMetadata("protectedStaticSamePackage.kt")
            public void testProtectedStaticSamePackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/protectedStaticSamePackage.kt");
                doTest(fileName);
            }

            @TestMetadata("recursionWithJavaSyntheticProperty.kt")
            public void testRecursionWithJavaSyntheticProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/recursionWithJavaSyntheticProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("recursiveRawUpperBound.kt")
            public void testRecursiveRawUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("recursiveRawUpperBound2.kt")
            public void testRecursiveRawUpperBound2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound2.kt");
                doTest(fileName);
            }

            @TestMetadata("recursiveRawUpperBound3.kt")
            public void testRecursiveRawUpperBound3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound3.kt");
                doTest(fileName);
            }

            @TestMetadata("samInConstructorWithGenerics.kt")
            public void testSamInConstructorWithGenerics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/samInConstructorWithGenerics.kt");
                doTest(fileName);
            }

            @TestMetadata("serializable.kt")
            public void testSerializable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/serializable.kt");
                doTest(fileName);
            }

            @TestMetadata("shadowingPrimitiveStaticField.kt")
            public void testShadowingPrimitiveStaticField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/shadowingPrimitiveStaticField.kt");
                doTest(fileName);
            }

            @TestMetadata("Simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/Simple.kt");
                doTest(fileName);
            }

            @TestMetadata("specialBridges.kt")
            public void testSpecialBridges() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/specialBridges.kt");
                doTest(fileName);
            }

            @TestMetadata("StaticMembersFromSuperclasses.kt")
            public void testStaticMembersFromSuperclasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/StaticMembersFromSuperclasses.kt");
                doTest(fileName);
            }

            @TestMetadata("SupertypeArgumentsNullability-NotNull-SpecialTypes.kt")
            public void testSupertypeArgumentsNullability_NotNull_SpecialTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-NotNull-SpecialTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("SupertypeArgumentsNullability-NotNull-UserTypes.kt")
            public void testSupertypeArgumentsNullability_NotNull_UserTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-NotNull-UserTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("SupertypeArgumentsNullability-SpecialTypes.kt")
            public void testSupertypeArgumentsNullability_SpecialTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-SpecialTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("SupertypeArgumentsNullability-UserTypes.kt")
            public void testSupertypeArgumentsNullability_UserTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-UserTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("traitDefaultCall.kt")
            public void testTraitDefaultCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/traitDefaultCall.kt");
                doTest(fileName);
            }

            @TestMetadata("UnboxingNulls.kt")
            public void testUnboxingNulls() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/UnboxingNulls.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongVarianceInJava.kt")
            public void testWrongVarianceInJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/wrongVarianceInJava.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/brokenCode")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class BrokenCode extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInBrokenCode() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/brokenCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classDuplicates.kt")
                public void testClassDuplicates() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/brokenCode/classDuplicates.kt");
                    doTest(fileName);
                }

                @TestMetadata("fieldDuplicates.kt")
                public void testFieldDuplicates() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/brokenCode/fieldDuplicates.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CollectionOverrides extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInCollectionOverrides() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/collectionOverrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("charBuffer.kt")
                public void testCharBuffer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/charBuffer.kt");
                    doTest(fileName);
                }

                @TestMetadata("collectionStringImpl.kt")
                public void testCollectionStringImpl() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/collectionStringImpl.kt");
                    doTest(fileName);
                }

                @TestMetadata("commonCollections.kt")
                public void testCommonCollections() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/commonCollections.kt");
                    doTest(fileName);
                }

                @TestMetadata("contains.kt")
                public void testContains() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/contains.kt");
                    doTest(fileName);
                }

                @TestMetadata("containsAll.kt")
                public void testContainsAll() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/containsAll.kt");
                    doTest(fileName);
                }

                @TestMetadata("containsAndOverload.kt")
                public void testContainsAndOverload() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/containsAndOverload.kt");
                    doTest(fileName);
                }

                @TestMetadata("getCharSequence.kt")
                public void testGetCharSequence() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/getCharSequence.kt");
                    doTest(fileName);
                }

                @TestMetadata("irrelevantCharAtAbstract.kt")
                public void testIrrelevantCharAtAbstract() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantCharAtAbstract.kt");
                    doTest(fileName);
                }

                @TestMetadata("irrelevantImplCharSequence.kt")
                public void testIrrelevantImplCharSequence() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplCharSequence.kt");
                    doTest(fileName);
                }

                @TestMetadata("irrelevantImplCharSequenceKotlin.kt")
                public void testIrrelevantImplCharSequenceKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplCharSequenceKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("irrelevantImplMutableList.kt")
                public void testIrrelevantImplMutableList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplMutableList.kt");
                    doTest(fileName);
                }

                @TestMetadata("irrelevantImplMutableListKotlin.kt")
                public void testIrrelevantImplMutableListKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplMutableListKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("irrelevantMapGetAbstract.kt")
                public void testIrrelevantMapGetAbstract() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantMapGetAbstract.kt");
                    doTest(fileName);
                }

                @TestMetadata("mapGetOverride.kt")
                public void testMapGetOverride() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/mapGetOverride.kt");
                    doTest(fileName);
                }

                @TestMetadata("overridesBuiltinNoMagic.kt")
                public void testOverridesBuiltinNoMagic() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/overridesBuiltinNoMagic.kt");
                    doTest(fileName);
                }

                @TestMetadata("removeAt.kt")
                public void testRemoveAt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/removeAt.kt");
                    doTest(fileName);
                }

                @TestMetadata("removeAtInt.kt")
                public void testRemoveAtInt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/removeAtInt.kt");
                    doTest(fileName);
                }

                @TestMetadata("sizeFromKotlinOverriddenInJava.kt")
                public void testSizeFromKotlinOverriddenInJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides/sizeFromKotlinOverriddenInJava.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class GenericConstructor extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInGenericConstructor() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/genericConstructor"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classTypeParameterInferredFromArgument.kt")
                public void testClassTypeParameterInferredFromArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor/classTypeParameterInferredFromArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerClass.kt")
                public void testInnerClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor/innerClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("noClassTypeParameters.kt")
                public void testNoClassTypeParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor/noClassTypeParameters.kt");
                    doTest(fileName);
                }

                @TestMetadata("noClassTypeParametersInvParameter.kt")
                public void testNoClassTypeParametersInvParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor/noClassTypeParametersInvParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursive.kt")
                public void testRecursive() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor/recursive.kt");
                    doTest(fileName);
                }

                @TestMetadata("selfTypes.kt")
                public void testSelfTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor/selfTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("superCall.kt")
                public void testSuperCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor/superCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("superCallImpossibleToInfer.kt")
                public void testSuperCallImpossibleToInfer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor/superCallImpossibleToInfer.kt");
                    doTest(fileName);
                }

                @TestMetadata("withClassTypeParameters.kt")
                public void testWithClassTypeParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor/withClassTypeParameters.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/primitiveOverrides")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PrimitiveOverrides extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInPrimitiveOverrides() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/primitiveOverrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt11140.kt")
                public void testKt11140() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/kt11140.kt");
                    doTest(fileName);
                }

                @TestMetadata("notNullAnnotated.kt")
                public void testNotNullAnnotated() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/notNullAnnotated.kt");
                    doTest(fileName);
                }

                @TestMetadata("specializedMap.kt")
                public void testSpecializedMap() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/specializedMap.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/properties")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Properties extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInProperties() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/properties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("interface.kt")
                public void testInterface() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/properties/interface.kt");
                    doTest(fileName);
                }

                @TestMetadata("isName.kt")
                public void testIsName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/properties/isName.kt");
                    doTest(fileName);
                }

                @TestMetadata("val.kt")
                public void testVal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/properties/val.kt");
                    doTest(fileName);
                }

                @TestMetadata("var.kt")
                public void testVar() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/properties/var.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/sam")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Sam extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInSam() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/sam"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("enhancedSamConstructor.kt")
                public void testEnhancedSamConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/sam/enhancedSamConstructor.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/samByProjectedType")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SamByProjectedType extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInSamByProjectedType() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/samByProjectedType"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("genericInReturnType.kt")
                public void testGenericInReturnType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/samByProjectedType/genericInReturnType.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericInValueParameter.kt")
                public void testGenericInValueParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/samByProjectedType/genericInValueParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericSuperWildcard.kt")
                public void testGenericSuperWildcard() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/samByProjectedType/genericSuperWildcard.kt");
                    doTest(fileName);
                }

                @TestMetadata("noAdapterBecuaseOfRecursiveUpperBound.kt")
                public void testNoAdapterBecuaseOfRecursiveUpperBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/samByProjectedType/noAdapterBecuaseOfRecursiveUpperBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("starProjectionComplexUpperBound.kt")
                public void testStarProjectionComplexUpperBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/samByProjectedType/starProjectionComplexUpperBound.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/j+k/types")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Types extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/types"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("arrayList.kt")
                public void testArrayList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/types/arrayList.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnCollection.kt")
                public void testReturnCollection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/types/returnCollection.kt");
                    doTest(fileName);
                }

                @TestMetadata("shapeMismatchInCovariantPosition.kt")
                public void testShapeMismatchInCovariantPosition() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/types/shapeMismatchInCovariantPosition.kt");
                    doTest(fileName);
                }

                @TestMetadata("shapeMismatchInCovariantPositionGeneric.kt")
                public void testShapeMismatchInCovariantPositionGeneric() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/types/shapeMismatchInCovariantPositionGeneric.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeParameter.kt")
                public void testTypeParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/j+k/types/typeParameter.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/java8Overrides")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Java8Overrides extends AbstractDiagnosticsTest {
            @TestMetadata("abstractBaseClassMemberNotImplemented.kt")
            public void testAbstractBaseClassMemberNotImplemented() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/java8Overrides/abstractBaseClassMemberNotImplemented.kt");
                doTest(fileName);
            }

            @TestMetadata("abstractVsAbstract.kt")
            public void testAbstractVsAbstract() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/java8Overrides/abstractVsAbstract.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInJava8Overrides() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/java8Overrides"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("defaultVsAbstract.kt")
            public void testDefaultVsAbstract() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/java8Overrides/defaultVsAbstract.kt");
                doTest(fileName);
            }

            @TestMetadata("hidingMethodOfAny.kt")
            public void testHidingMethodOfAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/java8Overrides/hidingMethodOfAny.kt");
                doTest(fileName);
            }

            @TestMetadata("implementingMethodOfAny.kt")
            public void testImplementingMethodOfAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/java8Overrides/implementingMethodOfAny.kt");
                doTest(fileName);
            }

            @TestMetadata("notAMethodOfAny.kt")
            public void testNotAMethodOfAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/java8Overrides/notAMethodOfAny.kt");
                doTest(fileName);
            }

            @TestMetadata("overridingMethodOfAnyChain.kt")
            public void testOverridingMethodOfAnyChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/java8Overrides/overridingMethodOfAnyChain.kt");
                doTest(fileName);
            }

            @TestMetadata("overridingMethodOfAnyDiamond.kt")
            public void testOverridingMethodOfAnyDiamond() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/java8Overrides/overridingMethodOfAnyDiamond.kt");
                doTest(fileName);
            }

            @TestMetadata("singleRelevantDefault.kt")
            public void testSingleRelevantDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/java8Overrides/singleRelevantDefault.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/labels")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Labels extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInLabels() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/labels"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kt1703.kt")
            public void testKt1703() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/labels/kt1703.kt");
                doTest(fileName);
            }

            @TestMetadata("kt361.kt")
            public void testKt361() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/labels/kt361.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3920.kt")
            public void testKt3920() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/labels/kt3920.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3988.kt")
            public void testKt3988() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/labels/kt3988.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4247.kt")
            public void testKt4247() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/labels/kt4247.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4586.kt")
            public void testKt4586() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/labels/kt4586.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4603.kt")
            public void testKt4603() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/labels/kt4603.kt");
                doTest(fileName);
            }

            @TestMetadata("kt591.kt")
            public void testKt591() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/labels/kt591.kt");
                doTest(fileName);
            }

            @TestMetadata("labelReferencesInsideObjectExpressions.kt")
            public void testLabelReferencesInsideObjectExpressions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/labels/labelReferencesInsideObjectExpressions.kt");
                doTest(fileName);
            }

            @TestMetadata("labelsMustBeNamed.kt")
            public void testLabelsMustBeNamed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/labels/labelsMustBeNamed.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/library")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Library extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInLibrary() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/library"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("Collections.kt")
            public void testCollections() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/library/Collections.kt");
                doTest(fileName);
            }

            @TestMetadata("kt828.kt")
            public void testKt828() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/library/kt828.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/modifiers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Modifiers extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInModifiers() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/modifiers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotations.kt")
            public void testAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/annotations.kt");
                doTest(fileName);
            }

            @TestMetadata("defaultModifier.kt")
            public void testDefaultModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/defaultModifier.kt");
                doTest(fileName);
            }

            @TestMetadata("IllegalModifiers.kt")
            public void testIllegalModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/IllegalModifiers.kt");
                doTest(fileName);
            }

            @TestMetadata("incompatibleVarianceModifiers.kt")
            public void testIncompatibleVarianceModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/incompatibleVarianceModifiers.kt");
                doTest(fileName);
            }

            @TestMetadata("inlineParameters.kt")
            public void testInlineParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/inlineParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("internalInInterface.kt")
            public void testInternalInInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/internalInInterface.kt");
                doTest(fileName);
            }

            @TestMetadata("modifierOnParameterInFunctionType.kt")
            public void testModifierOnParameterInFunctionType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/modifierOnParameterInFunctionType.kt");
                doTest(fileName);
            }

            @TestMetadata("NoLocalVisibility.kt")
            public void testNoLocalVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/NoLocalVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("openInInterface.kt")
            public void testOpenInInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/openInInterface.kt");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructorMissingKeyword.kt")
            public void testPrimaryConstructorMissingKeyword() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/primaryConstructorMissingKeyword.kt");
                doTest(fileName);
            }

            @TestMetadata("privateInInterface.kt")
            public void testPrivateInInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/privateInInterface.kt");
                doTest(fileName);
            }

            @TestMetadata("protected.kt")
            public void testProtected() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/protected.kt");
                doTest(fileName);
            }

            @TestMetadata("redundantTargets.kt")
            public void testRedundantTargets() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/redundantTargets.kt");
                doTest(fileName);
            }

            @TestMetadata("repeatedModifiers.kt")
            public void testRepeatedModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/repeatedModifiers.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/modifiers/const")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Const extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInConst() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/modifiers/const"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("applicability.kt")
                public void testApplicability() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/const/applicability.kt");
                    doTest(fileName);
                }

                @TestMetadata("constInteraction.kt")
                public void testConstInteraction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/const/constInteraction.kt");
                    doTest(fileName);
                }

                @TestMetadata("fromJava.kt")
                public void testFromJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/const/fromJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("types.kt")
                public void testTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/const/types.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/modifiers/operatorInfix")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class OperatorInfix extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInOperatorInfix() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/modifiers/operatorInfix"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("LocalFunctions.kt")
                public void testLocalFunctions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/operatorInfix/LocalFunctions.kt");
                    doTest(fileName);
                }

                @TestMetadata("MemberFunctions.kt")
                public void testMemberFunctions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/operatorInfix/MemberFunctions.kt");
                    doTest(fileName);
                }

                @TestMetadata("Simple.kt")
                public void testSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/modifiers/operatorInfix/Simple.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/multimodule")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Multimodule extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInMultimodule() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("internal.kt")
            public void testInternal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/internal.kt");
                doTest(fileName);
            }

            @TestMetadata("packagePrivate.kt")
            public void testPackagePrivate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/packagePrivate.kt");
                doTest(fileName);
            }

            @TestMetadata("varargConflict.kt")
            public void testVarargConflict() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/varargConflict.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DuplicateClass extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInDuplicateClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/duplicateClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("collectionMethodStub.kt")
                public void testCollectionMethodStub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/collectionMethodStub.kt");
                    doTest(fileName);
                }

                @TestMetadata("differentGenericArguments.kt")
                public void testDifferentGenericArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/differentGenericArguments.kt");
                    doTest(fileName);
                }

                @TestMetadata("differentGenericArgumentsReversed.kt")
                public void testDifferentGenericArgumentsReversed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/differentGenericArgumentsReversed.kt");
                    doTest(fileName);
                }

                @TestMetadata("duplicateClass.kt")
                public void testDuplicateClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/duplicateClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("duplicateNestedClasses.kt")
                public void testDuplicateNestedClasses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/duplicateNestedClasses.kt");
                    doTest(fileName);
                }

                @TestMetadata("duplicateSuperClass.kt")
                public void testDuplicateSuperClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/duplicateSuperClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericArgumentNumberMismatch.kt")
                public void testGenericArgumentNumberMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/genericArgumentNumberMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericSuperClass.kt")
                public void testGenericSuperClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/genericSuperClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inTheSameModuleWithUsage.kt")
                public void testInTheSameModuleWithUsage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/inTheSameModuleWithUsage.kt");
                    doTest(fileName);
                }

                @TestMetadata("inTheSameModuleWithUsageNoTypeAnnotation.kt")
                public void testInTheSameModuleWithUsageNoTypeAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/inTheSameModuleWithUsageNoTypeAnnotation.kt");
                    doTest(fileName);
                }

                @TestMetadata("members.kt")
                public void testMembers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/members.kt");
                    doTest(fileName);
                }

                @TestMetadata("sameClassNameDifferentPackages.kt")
                public void testSameClassNameDifferentPackages() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/sameClassNameDifferentPackages.kt");
                    doTest(fileName);
                }

                @TestMetadata("sameGenericArguments.kt")
                public void testSameGenericArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass/sameGenericArguments.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DuplicateMethod extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInDuplicateMethod() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/duplicateMethod"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classGenericsInParams.kt")
                public void testClassGenericsInParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("classGenericsInParamsBoundMismatch.kt")
                public void testClassGenericsInParamsBoundMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParamsBoundMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("classGenericsInParamsIndexMismatch.kt")
                public void testClassGenericsInParamsIndexMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParamsIndexMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("classGenericsInParamsNameMismatch.kt")
                public void testClassGenericsInParamsNameMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParamsNameMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("classGenericsInReturnType.kt")
                public void testClassGenericsInReturnType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInReturnType.kt");
                    doTest(fileName);
                }

                @TestMetadata("classVsFunctionGenericsInParamsMismatch.kt")
                public void testClassVsFunctionGenericsInParamsMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classVsFunctionGenericsInParamsMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("covariantReturnTypes.kt")
                public void testCovariantReturnTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/covariantReturnTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("differenceInParamNames.kt")
                public void testDifferenceInParamNames() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differenceInParamNames.kt");
                    doTest(fileName);
                }

                @TestMetadata("differentGenericsInParams.kt")
                public void testDifferentGenericsInParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differentGenericsInParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("differentNumberOfParams.kt")
                public void testDifferentNumberOfParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differentNumberOfParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("differentReturnTypes.kt")
                public void testDifferentReturnTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differentReturnTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionMatch.kt")
                public void testExtensionMatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/extensionMatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionGenericsInParams.kt")
                public void testFunctionGenericsInParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionGenericsInParamsBoundsMismatch.kt")
                public void testFunctionGenericsInParamsBoundsMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsBoundsMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionGenericsInParamsEqNull.kt")
                public void testFunctionGenericsInParamsEqNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsEqNull.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionGenericsInParamsNotIs.kt")
                public void testFunctionGenericsInParamsNotIs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsNotIs.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionGenericsInParamsReturnFooT.kt")
                public void testFunctionGenericsInParamsReturnFooT() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsReturnFooT.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionGenericsInParamsReturnT.kt")
                public void testFunctionGenericsInParamsReturnT() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsReturnT.kt");
                    doTest(fileName);
                }

                @TestMetadata("incompleteCodeNoNoneApplicable.kt")
                public void testIncompleteCodeNoNoneApplicable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/incompleteCodeNoNoneApplicable.kt");
                    doTest(fileName);
                }

                @TestMetadata("noGenericsInParams.kt")
                public void testNoGenericsInParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/noGenericsInParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("noParams.kt")
                public void testNoParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/noParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("sameGenericsInParams.kt")
                public void testSameGenericsInParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/sameGenericsInParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWithInheritance.kt")
                public void testSimpleWithInheritance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/simpleWithInheritance.kt");
                    doTest(fileName);
                }

                @TestMetadata("sinceKotlin.kt")
                public void testSinceKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/sinceKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("substitutedGenericInParams.kt")
                public void testSubstitutedGenericInParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/substitutedGenericInParams.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateSuper")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DuplicateSuper extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInDuplicateSuper() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/duplicateSuper"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("differentSuperTraits.kt")
                public void testDifferentSuperTraits() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/differentSuperTraits.kt");
                    doTest(fileName);
                }

                @TestMetadata("sameSuperTrait.kt")
                public void testSameSuperTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/sameSuperTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("sameSuperTraitDifferentBounds.kt")
                public void testSameSuperTraitDifferentBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/sameSuperTraitDifferentBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("sameSuperTraitGenerics.kt")
                public void testSameSuperTraitGenerics() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/sameSuperTraitGenerics.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/hiddenClass")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class HiddenClass extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInHiddenClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/hiddenClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("deprecatedHiddenImportPriority.kt")
                public void testDeprecatedHiddenImportPriority() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/hiddenClass/deprecatedHiddenImportPriority.kt");
                    doTest(fileName);
                }

                @TestMetadata("deprecatedHiddenMultipleClasses.kt")
                public void testDeprecatedHiddenMultipleClasses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/hiddenClass/deprecatedHiddenMultipleClasses.kt");
                    doTest(fileName);
                }

                @TestMetadata("sinceKotlinImportPriority.kt")
                public void testSinceKotlinImportPriority() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/hiddenClass/sinceKotlinImportPriority.kt");
                    doTest(fileName);
                }

                @TestMetadata("sinceKotlinMultipleClasses.kt")
                public void testSinceKotlinMultipleClasses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/multimodule/hiddenClass/sinceKotlinMultipleClasses.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/namedArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NamedArguments extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInNamedArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/namedArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("allowForJavaAnnotation.kt")
            public void testAllowForJavaAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/allowForJavaAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("ambiguousNamedArguments1.kt")
            public void testAmbiguousNamedArguments1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArguments1.kt");
                doTest(fileName);
            }

            @TestMetadata("ambiguousNamedArguments2.kt")
            public void testAmbiguousNamedArguments2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArguments2.kt");
                doTest(fileName);
            }

            @TestMetadata("ambiguousNamedArgumentsWithGenerics1.kt")
            public void testAmbiguousNamedArgumentsWithGenerics1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArgumentsWithGenerics1.kt");
                doTest(fileName);
            }

            @TestMetadata("ambiguousNamedArgumentsWithGenerics2.kt")
            public void testAmbiguousNamedArgumentsWithGenerics2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArgumentsWithGenerics2.kt");
                doTest(fileName);
            }

            @TestMetadata("ambiguousNamedArgumentsWithGenerics3.kt")
            public void testAmbiguousNamedArgumentsWithGenerics3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArgumentsWithGenerics3.kt");
                doTest(fileName);
            }

            @TestMetadata("disallowForJavaConstructor.kt")
            public void testDisallowForJavaConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/disallowForJavaConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("disallowForJavaMethods.kt")
            public void testDisallowForJavaMethods() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/disallowForJavaMethods.kt");
                doTest(fileName);
            }

            @TestMetadata("disallowForSamAdapterConstructor.kt")
            public void testDisallowForSamAdapterConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/disallowForSamAdapterConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("disallowForSamAdapterFunction.kt")
            public void testDisallowForSamAdapterFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/disallowForSamAdapterFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("namedArgumentsAndDefaultValues.kt")
            public void testNamedArgumentsAndDefaultValues() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/namedArgumentsAndDefaultValues.kt");
                doTest(fileName);
            }

            @TestMetadata("namedArgumentsInOverloads.kt")
            public void testNamedArgumentsInOverloads() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/namedArgumentsInOverloads.kt");
                doTest(fileName);
            }

            @TestMetadata("namedArgumentsInOverrides.kt")
            public void testNamedArgumentsInOverrides() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/namedArguments/namedArgumentsInOverrides.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NullabilityAndSmartCasts extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInNullabilityAndSmartCasts() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AssertNotNull.kt")
            public void testAssertNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/AssertNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("dataFlowInfoAfterExclExcl.kt")
            public void testDataFlowInfoAfterExclExcl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/dataFlowInfoAfterExclExcl.kt");
                doTest(fileName);
            }

            @TestMetadata("equalityUnderNotNullCheck.kt")
            public void testEqualityUnderNotNullCheck() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/equalityUnderNotNullCheck.kt");
                doTest(fileName);
            }

            @TestMetadata("funcLiteralArgsInsideAmbiguity.kt")
            public void testFuncLiteralArgsInsideAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/funcLiteralArgsInsideAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("funcLiteralArgsInsideUnresolvedFunction.kt")
            public void testFuncLiteralArgsInsideUnresolvedFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/funcLiteralArgsInsideUnresolvedFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("InfixCallNullability.kt")
            public void testInfixCallNullability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/InfixCallNullability.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1270.kt")
            public void testKt1270() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt1270.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1680.kt")
            public void testKt1680() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt1680.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1778.kt")
            public void testKt1778() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt1778.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2109.kt")
            public void testKt2109() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2109.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2125.kt")
            public void testKt2125() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2125.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2146.kt")
            public void testKt2146() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2146.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2164.kt")
            public void testKt2164() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2164.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2176.kt")
            public void testKt2176() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2176.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2195.kt")
            public void testKt2195() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2195.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2212.kt")
            public void testKt2212() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2212.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2216.kt")
            public void testKt2216() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2216.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2223.kt")
            public void testKt2223() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2223.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2234.kt")
            public void testKt2234() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2234.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2336.kt")
            public void testKt2336() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt2336.kt");
                doTest(fileName);
            }

            @TestMetadata("kt244.kt")
            public void testKt244() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt244.kt");
                doTest(fileName);
            }

            @TestMetadata("kt362.kt")
            public void testKt362() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/kt362.kt");
                doTest(fileName);
            }

            @TestMetadata("noSenselessNullOnNullableType.kt")
            public void testNoSenselessNullOnNullableType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/noSenselessNullOnNullableType.kt");
                doTest(fileName);
            }

            @TestMetadata("noUnnecessaryNotNullAssertionOnErrorType.kt")
            public void testNoUnnecessaryNotNullAssertionOnErrorType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/noUnnecessaryNotNullAssertionOnErrorType.kt");
                doTest(fileName);
            }

            @TestMetadata("NullableNothingIsExactlyNull.kt")
            public void testNullableNothingIsExactlyNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/NullableNothingIsExactlyNull.kt");
                doTest(fileName);
            }

            @TestMetadata("PreferExtensionsOnNullableReceiver.kt")
            public void testPreferExtensionsOnNullableReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/PreferExtensionsOnNullableReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("QualifiedExpressionNullability.kt")
            public void testQualifiedExpressionNullability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/QualifiedExpressionNullability.kt");
                doTest(fileName);
            }

            @TestMetadata("ReceiverNullability.kt")
            public void testReceiverNullability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/ReceiverNullability.kt");
                doTest(fileName);
            }

            @TestMetadata("SenselessNullInWhen.kt")
            public void testSenselessNullInWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/SenselessNullInWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("senslessComparisonWithNullOnTypeParameters.kt")
            public void testSenslessComparisonWithNullOnTypeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/senslessComparisonWithNullOnTypeParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastReceiverWithGenerics.kt")
            public void testSmartCastReceiverWithGenerics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/smartCastReceiverWithGenerics.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastsAndBooleanExpressions.kt")
            public void testSmartCastsAndBooleanExpressions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/smartCastsAndBooleanExpressions.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/nullableTypes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NullableTypes extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInNullableTypes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/nullableTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("baseWithNullableUpperBound.kt")
            public void testBaseWithNullableUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullableTypes/baseWithNullableUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisOnUnit.kt")
            public void testElvisOnUnit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullableTypes/elvisOnUnit.kt");
                doTest(fileName);
            }

            @TestMetadata("nullAssertOnTypeWithNullableUpperBound.kt")
            public void testNullAssertOnTypeWithNullableUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullableTypes/nullAssertOnTypeWithNullableUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("nullableArgumentForIn.kt")
            public void testNullableArgumentForIn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullableTypes/nullableArgumentForIn.kt");
                doTest(fileName);
            }

            @TestMetadata("redundantNullable.kt")
            public void testRedundantNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullableTypes/redundantNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("redundantNullableInSupertype.kt")
            public void testRedundantNullableInSupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullableTypes/redundantNullableInSupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("safeAccessOnUnit.kt")
            public void testSafeAccessOnUnit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullableTypes/safeAccessOnUnit.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCallOnTypeWithNullableUpperBound.kt")
            public void testSafeCallOnTypeWithNullableUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullableTypes/safeCallOnTypeWithNullableUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCallWithInvoke.kt")
            public void testSafeCallWithInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullableTypes/safeCallWithInvoke.kt");
                doTest(fileName);
            }

            @TestMetadata("uselessElvis.kt")
            public void testUselessElvis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/nullableTypes/uselessElvis.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/numbers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Numbers extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInNumbers() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/numbers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("characterIsNotANumber.kt")
            public void testCharacterIsNotANumber() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/numbers/characterIsNotANumber.kt");
                doTest(fileName);
            }

            @TestMetadata("doublesInSimpleConstraints.kt")
            public void testDoublesInSimpleConstraints() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/numbers/doublesInSimpleConstraints.kt");
                doTest(fileName);
            }

            @TestMetadata("intValuesOutOfRange.kt")
            public void testIntValuesOutOfRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/numbers/intValuesOutOfRange.kt");
                doTest(fileName);
            }

            @TestMetadata("numbersInSimpleConstraints.kt")
            public void testNumbersInSimpleConstraints() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/numbers/numbersInSimpleConstraints.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/objects")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Objects extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInObjects() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/objects"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("invokeOnInnerObject.kt")
            public void testInvokeOnInnerObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/invokeOnInnerObject.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2240.kt")
            public void testKt2240() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/kt2240.kt");
                doTest(fileName);
            }

            @TestMetadata("kt5527.kt")
            public void testKt5527() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/kt5527.kt");
                doTest(fileName);
            }

            @TestMetadata("localObjectInsideObject.kt")
            public void testLocalObjectInsideObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/localObjectInsideObject.kt");
                doTest(fileName);
            }

            @TestMetadata("localObjects.kt")
            public void testLocalObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/localObjects.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClassInAnonymousObject.kt")
            public void testNestedClassInAnonymousObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/nestedClassInAnonymousObject.kt");
                doTest(fileName);
            }

            @TestMetadata("objectInsideFun.kt")
            public void testObjectInsideFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/objectInsideFun.kt");
                doTest(fileName);
            }

            @TestMetadata("objectLiteralExpressionTypeMismatch.kt")
            public void testObjectLiteralExpressionTypeMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/objectLiteralExpressionTypeMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("Objects.kt")
            public void testObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/Objects.kt");
                doTest(fileName);
            }

            @TestMetadata("ObjectsInheritance.kt")
            public void testObjectsInheritance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/ObjectsInheritance.kt");
                doTest(fileName);
            }

            @TestMetadata("ObjectsLocal.kt")
            public void testObjectsLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/ObjectsLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("ObjectsNested.kt")
            public void testObjectsNested() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/ObjectsNested.kt");
                doTest(fileName);
            }

            @TestMetadata("OpenInObject.kt")
            public void testOpenInObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/OpenInObject.kt");
                doTest(fileName);
            }

            @TestMetadata("upperBoundViolated.kt")
            public void testUpperBoundViolated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/objects/upperBoundViolated.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/operatorsOverloading")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OperatorsOverloading extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInOperatorsOverloading() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/operatorsOverloading"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AssignOperatorAmbiguity.kt")
            public void testAssignOperatorAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/AssignOperatorAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("AssignmentOperations.kt")
            public void testAssignmentOperations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/AssignmentOperations.kt");
                doTest(fileName);
            }

            @TestMetadata("assignmentOperationsCheckReturnType.kt")
            public void testAssignmentOperationsCheckReturnType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/assignmentOperationsCheckReturnType.kt");
                doTest(fileName);
            }

            @TestMetadata("compareToNullable.kt")
            public void testCompareToNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/compareToNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("InconsistentGetSet.kt")
            public void testInconsistentGetSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/InconsistentGetSet.kt");
                doTest(fileName);
            }

            @TestMetadata("IteratorAmbiguity.kt")
            public void testIteratorAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/IteratorAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1028.kt")
            public void testKt1028() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/kt1028.kt");
                doTest(fileName);
            }

            @TestMetadata("kt11300.kt")
            public void testKt11300() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/kt11300.kt");
                doTest(fileName);
            }

            @TestMetadata("kt13330.kt")
            public void testKt13330() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/kt13330.kt");
                doTest(fileName);
            }

            @TestMetadata("kt13349.kt")
            public void testKt13349() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/kt13349.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3450.kt")
            public void testKt3450() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/kt3450.kt");
                doTest(fileName);
            }

            @TestMetadata("plusAssignOnArray.kt")
            public void testPlusAssignOnArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/plusAssignOnArray.kt");
                doTest(fileName);
            }

            @TestMetadata("plusAssignOnLocal.kt")
            public void testPlusAssignOnLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/plusAssignOnLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("plusAssignOnProperty.kt")
            public void testPlusAssignOnProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/operatorsOverloading/plusAssignOnProperty.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/overload")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Overload extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInOverload() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/overload"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ConflictingOlverloadsGenericFunctions.kt")
            public void testConflictingOlverloadsGenericFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/ConflictingOlverloadsGenericFunctions.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingOverloadsFunsDifferentReturnInClass.kt")
            public void testConflictingOverloadsFunsDifferentReturnInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsFunsDifferentReturnInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingOverloadsFunsDifferentReturnInPackage.kt")
            public void testConflictingOverloadsFunsDifferentReturnInPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsFunsDifferentReturnInPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingOverloadsIdenticalExtFunsInPackage.kt")
            public void testConflictingOverloadsIdenticalExtFunsInPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsIdenticalExtFunsInPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingOverloadsIdenticalFunsInClass.kt")
            public void testConflictingOverloadsIdenticalFunsInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsIdenticalFunsInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingOverloadsIdenticalFunsTPInClass.kt")
            public void testConflictingOverloadsIdenticalFunsTPInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsIdenticalFunsTPInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingOverloadsIdenticalValsInClass.kt")
            public void testConflictingOverloadsIdenticalValsInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsIdenticalValsInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingOverloadsValsDifferentTypeInClass.kt")
            public void testConflictingOverloadsValsDifferentTypeInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/ConflictingOverloadsValsDifferentTypeInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorVsFunOverload.kt")
            public void testConstructorVsFunOverload() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/ConstructorVsFunOverload.kt");
                doTest(fileName);
            }

            @TestMetadata("defaultParameters.kt")
            public void testDefaultParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/defaultParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("EmptyArgumentListInLambda.kt")
            public void testEmptyArgumentListInLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/EmptyArgumentListInLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtFunDifferentReceiver.kt")
            public void testExtFunDifferentReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/ExtFunDifferentReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("FunNoConflictInDifferentPackages.kt")
            public void testFunNoConflictInDifferentPackages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/FunNoConflictInDifferentPackages.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10939.kt")
            public void testKt10939() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/kt10939.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1998.kt")
            public void testKt1998() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/kt1998.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2493.kt")
            public void testKt2493() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/kt2493.kt");
                doTest(fileName);
            }

            @TestMetadata("kt7068.kt")
            public void testKt7068() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/kt7068.kt");
                doTest(fileName);
            }

            @TestMetadata("kt7068_2.kt")
            public void testKt7068_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/kt7068_2.kt");
                doTest(fileName);
            }

            @TestMetadata("kt7440.kt")
            public void testKt7440() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/kt7440.kt");
                doTest(fileName);
            }

            @TestMetadata("LocalFunctions.kt")
            public void testLocalFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/LocalFunctions.kt");
                doTest(fileName);
            }

            @TestMetadata("OverloadFunRegularAndExt.kt")
            public void testOverloadFunRegularAndExt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/OverloadFunRegularAndExt.kt");
                doTest(fileName);
            }

            @TestMetadata("OverloadVarAndFunInClass.kt")
            public void testOverloadVarAndFunInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/OverloadVarAndFunInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("SyntheticAndNotSynthetic.kt")
            public void testSyntheticAndNotSynthetic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/SyntheticAndNotSynthetic.kt");
                doTest(fileName);
            }

            @TestMetadata("TypeParameterMultipleBounds.kt")
            public void testTypeParameterMultipleBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/TypeParameterMultipleBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("UnsubstitutedJavaGenetics.kt")
            public void testUnsubstitutedJavaGenetics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/overload/UnsubstitutedJavaGenetics.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/override")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Override extends AbstractDiagnosticsTest {
            @TestMetadata("AbstractFunImplemented.kt")
            public void testAbstractFunImplemented() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/AbstractFunImplemented.kt");
                doTest(fileName);
            }

            @TestMetadata("AbstractFunNotImplemented.kt")
            public void testAbstractFunNotImplemented() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/AbstractFunNotImplemented.kt");
                doTest(fileName);
            }

            @TestMetadata("AbstractValImplemented.kt")
            public void testAbstractValImplemented() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/AbstractValImplemented.kt");
                doTest(fileName);
            }

            @TestMetadata("AbstractValNotImplemented.kt")
            public void testAbstractValNotImplemented() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/AbstractValNotImplemented.kt");
                doTest(fileName);
            }

            @TestMetadata("AbstractVarImplemented.kt")
            public void testAbstractVarImplemented() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/AbstractVarImplemented.kt");
                doTest(fileName);
            }

            @TestMetadata("AbstractVarNotImplemented.kt")
            public void testAbstractVarNotImplemented() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/AbstractVarNotImplemented.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInOverride() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/override"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AllPrivateFromSuperTypes.kt")
            public void testAllPrivateFromSuperTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/AllPrivateFromSuperTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("ComplexValRedeclaration.kt")
            public void testComplexValRedeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/ComplexValRedeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingFunctionSignatureFromSuperclass.kt")
            public void testConflictingFunctionSignatureFromSuperclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/ConflictingFunctionSignatureFromSuperclass.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingPropertySignatureFromSuperclass.kt")
            public void testConflictingPropertySignatureFromSuperclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/ConflictingPropertySignatureFromSuperclass.kt");
                doTest(fileName);
            }

            @TestMetadata("DefaultParameterValueInOverride.kt")
            public void testDefaultParameterValueInOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/DefaultParameterValueInOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("DefaultParameterValues-NoErrorsWhenInheritingFromOneTypeTwice.kt")
            public void testDefaultParameterValues_NoErrorsWhenInheritingFromOneTypeTwice() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/DefaultParameterValues-NoErrorsWhenInheritingFromOneTypeTwice.kt");
                doTest(fileName);
            }

            @TestMetadata("Delegation.kt")
            public void testDelegation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/Delegation.kt");
                doTest(fileName);
            }

            @TestMetadata("DelegationFun.kt")
            public void testDelegationFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/DelegationFun.kt");
                doTest(fileName);
            }

            @TestMetadata("DelegationVal.kt")
            public void testDelegationVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/DelegationVal.kt");
                doTest(fileName);
            }

            @TestMetadata("DelegationVar.kt")
            public void testDelegationVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/DelegationVar.kt");
                doTest(fileName);
            }

            @TestMetadata("DuplicateMethod.kt")
            public void testDuplicateMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/DuplicateMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("EqualityOfIntersectionTypes.kt")
            public void testEqualityOfIntersectionTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/EqualityOfIntersectionTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtendFunctionClass.kt")
            public void testExtendFunctionClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/ExtendFunctionClass.kt");
                doTest(fileName);
            }

            @TestMetadata("FakeOverrideAbstractAndNonAbstractFun.kt")
            public void testFakeOverrideAbstractAndNonAbstractFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/FakeOverrideAbstractAndNonAbstractFun.kt");
                doTest(fileName);
            }

            @TestMetadata("FakeOverrideDifferentDeclarationSignatures.kt")
            public void testFakeOverrideDifferentDeclarationSignatures() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/FakeOverrideDifferentDeclarationSignatures.kt");
                doTest(fileName);
            }

            @TestMetadata("FakeOverrideModality1.kt")
            public void testFakeOverrideModality1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/FakeOverrideModality1.kt");
                doTest(fileName);
            }

            @TestMetadata("FakeOverrideModality2.kt")
            public void testFakeOverrideModality2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/FakeOverrideModality2.kt");
                doTest(fileName);
            }

            @TestMetadata("FakeOverrideModality3.kt")
            public void testFakeOverrideModality3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/FakeOverrideModality3.kt");
                doTest(fileName);
            }

            @TestMetadata("Generics.kt")
            public void testGenerics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/Generics.kt");
                doTest(fileName);
            }

            @TestMetadata("InvisiblePotentialOverride.kt")
            public void testInvisiblePotentialOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/InvisiblePotentialOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12358.kt")
            public void testKt12358() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt12358.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12467.kt")
            public void testKt12467() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt12467.kt");
                doTest(fileName);
            }

            @TestMetadata("kt12482.kt")
            public void testKt12482() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt12482.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1862.kt")
            public void testKt1862() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt1862.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2052.kt")
            public void testKt2052() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt2052.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2491.kt")
            public void testKt2491() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt2491.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4763.kt")
            public void testKt4763() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt4763.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4763property.kt")
            public void testKt4763property() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt4763property.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4785.kt")
            public void testKt4785() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt4785.kt");
                doTest(fileName);
            }

            @TestMetadata("kt880.kt")
            public void testKt880() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt880.kt");
                doTest(fileName);
            }

            @TestMetadata("kt8990.kt")
            public void testKt8990() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/kt8990.kt");
                doTest(fileName);
            }

            @TestMetadata("MissingDelegate.kt")
            public void testMissingDelegate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/MissingDelegate.kt");
                doTest(fileName);
            }

            @TestMetadata("MultipleDefaultParametersInSupertypes.kt")
            public void testMultipleDefaultParametersInSupertypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/MultipleDefaultParametersInSupertypes.kt");
                doTest(fileName);
            }

            @TestMetadata("MultipleDefaultParametersInSupertypesNoOverride.kt")
            public void testMultipleDefaultParametersInSupertypesNoOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/MultipleDefaultParametersInSupertypesNoOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("MultipleDefaultsAndNamesInSupertypes.kt")
            public void testMultipleDefaultsAndNamesInSupertypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/MultipleDefaultsAndNamesInSupertypes.kt");
                doTest(fileName);
            }

            @TestMetadata("MultipleDefaultsInSupertypesNoExplicitOverride.kt")
            public void testMultipleDefaultsInSupertypesNoExplicitOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/MultipleDefaultsInSupertypesNoExplicitOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("NonGenerics.kt")
            public void testNonGenerics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/NonGenerics.kt");
                doTest(fileName);
            }

            @TestMetadata("ObjectDelegationManyImpl.kt")
            public void testObjectDelegationManyImpl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/ObjectDelegationManyImpl.kt");
                doTest(fileName);
            }

            @TestMetadata("OverrideWithErrors.kt")
            public void testOverrideWithErrors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/OverrideWithErrors.kt");
                doTest(fileName);
            }

            @TestMetadata("OverridingFinalMember.kt")
            public void testOverridingFinalMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/OverridingFinalMember.kt");
                doTest(fileName);
            }

            @TestMetadata("ParameterDefaultValues-DefaultValueFromOnlyOneSupertype.kt")
            public void testParameterDefaultValues_DefaultValueFromOnlyOneSupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/ParameterDefaultValues-DefaultValueFromOnlyOneSupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("ParentInheritsManyImplementations.kt")
            public void testParentInheritsManyImplementations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/ParentInheritsManyImplementations.kt");
                doTest(fileName);
            }

            @TestMetadata("PropertyInConstructor.kt")
            public void testPropertyInConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/PropertyInConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("ProtectedAndPrivateFromSupertypes.kt")
            public void testProtectedAndPrivateFromSupertypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/ProtectedAndPrivateFromSupertypes.kt");
                doTest(fileName);
            }

            @TestMetadata("SuspiciousCase1.kt")
            public void testSuspiciousCase1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/SuspiciousCase1.kt");
                doTest(fileName);
            }

            @TestMetadata("ToAbstractMembersFromSuper-kt1996.kt")
            public void testToAbstractMembersFromSuper_kt1996() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/ToAbstractMembersFromSuper-kt1996.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ClashesOnInheritance extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInClashesOnInheritance() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/override/clashesOnInheritance"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("covariantOverrides.kt")
                public void testCovariantOverrides() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance/covariantOverrides.kt");
                    doTest(fileName);
                }

                @TestMetadata("flexibleReturnType.kt")
                public void testFlexibleReturnType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance/flexibleReturnType.kt");
                    doTest(fileName);
                }

                @TestMetadata("flexibleReturnTypeIn.kt")
                public void testFlexibleReturnTypeIn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance/flexibleReturnTypeIn.kt");
                    doTest(fileName);
                }

                @TestMetadata("flexibleReturnTypeList.kt")
                public void testFlexibleReturnTypeList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance/flexibleReturnTypeList.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericWithUpperBound.kt")
                public void testGenericWithUpperBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance/genericWithUpperBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt9550.kt")
                public void testKt9550() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance/kt9550.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnTypeMismatch.kt")
                public void testReturnTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance/returnTypeMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("unrelatedInherited.kt")
                public void testUnrelatedInherited() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance/unrelatedInherited.kt");
                    doTest(fileName);
                }

                @TestMetadata("valTypeMismatch.kt")
                public void testValTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance/valTypeMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("varTypeMismatch.kt")
                public void testVarTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/clashesOnInheritance/varTypeMismatch.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/override/parameterNames")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ParameterNames extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInParameterNames() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/override/parameterNames"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("changeOnOverrideDiagnostic.kt")
                public void testChangeOnOverrideDiagnostic() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/parameterNames/changeOnOverrideDiagnostic.kt");
                    doTest(fileName);
                }

                @TestMetadata("differentNamesInSupertypesDiagnostic.kt")
                public void testDifferentNamesInSupertypesDiagnostic() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/parameterNames/differentNamesInSupertypesDiagnostic.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeInFunctionClass.kt")
                public void testInvokeInFunctionClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/parameterNames/invokeInFunctionClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("jjkHierarchy.kt")
                public void testJjkHierarchy() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/parameterNames/jjkHierarchy.kt");
                    doTest(fileName);
                }

                @TestMetadata("kjkHierarchy.kt")
                public void testKjkHierarchy() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/parameterNames/kjkHierarchy.kt");
                    doTest(fileName);
                }

                @TestMetadata("kjkWithSeveralSupers.kt")
                public void testKjkWithSeveralSupers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/parameterNames/kjkWithSeveralSupers.kt");
                    doTest(fileName);
                }

                @TestMetadata("kotlinInheritsBothJavaAndKotlin.kt")
                public void testKotlinInheritsBothJavaAndKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/parameterNames/kotlinInheritsBothJavaAndKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("kotlinInheritsJava.kt")
                public void testKotlinInheritsJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/parameterNames/kotlinInheritsJava.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/override/typeParameters")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TypeParameters extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInTypeParameters() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/override/typeParameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classAndTwoInterfaceBounds.kt")
                public void testClassAndTwoInterfaceBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/typeParameters/classAndTwoInterfaceBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("differentSetsOfBounds.kt")
                public void testDifferentSetsOfBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/typeParameters/differentSetsOfBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt9850.kt")
                public void testKt9850() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/typeParameters/kt9850.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleVisitorTwoAccepts.kt")
                public void testSimpleVisitorTwoAccepts() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/override/typeParameters/simpleVisitorTwoAccepts.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/platformTypes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PlatformTypes extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInPlatformTypes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegateByComplexInheritance.kt")
            public void testDelegateByComplexInheritance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/delegateByComplexInheritance.kt");
                doTest(fileName);
            }

            @TestMetadata("dereference.kt")
            public void testDereference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/dereference.kt");
                doTest(fileName);
            }

            @TestMetadata("elvis.kt")
            public void testElvis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/elvis.kt");
                doTest(fileName);
            }

            @TestMetadata("explicitFlexibleNoPackage.kt")
            public void testExplicitFlexibleNoPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/explicitFlexibleNoPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("explicitFlexibleWithPackage.kt")
            public void testExplicitFlexibleWithPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/explicitFlexibleWithPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("getParentOfType.kt")
            public void testGetParentOfType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/getParentOfType.kt");
                doTest(fileName);
            }

            @TestMetadata("inference.kt")
            public void testInference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/inference.kt");
                doTest(fileName);
            }

            @TestMetadata("intVsIntegerAmbiguity.kt")
            public void testIntVsIntegerAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/intVsIntegerAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("javaEmptyList.kt")
            public void testJavaEmptyList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/javaEmptyList.kt");
                doTest(fileName);
            }

            @TestMetadata("methodTypeParameterDefaultBound.kt")
            public void testMethodTypeParameterDefaultBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodTypeParameterDefaultBound.kt");
                doTest(fileName);
            }

            @TestMetadata("noAnnotationInClassPath.kt")
            public void testNoAnnotationInClassPath() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/noAnnotationInClassPath.kt");
                doTest(fileName);
            }

            @TestMetadata("nullableTypeArgument.kt")
            public void testNullableTypeArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullableTypeArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("override.kt")
            public void testOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/override.kt");
                doTest(fileName);
            }

            @TestMetadata("rawOverrides.kt")
            public void testRawOverrides() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawOverrides.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCall.kt")
            public void testSafeCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/safeCall.kt");
                doTest(fileName);
            }

            @TestMetadata("samAdapterInConstructor.kt")
            public void testSamAdapterInConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/samAdapterInConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("samConstructor.kt")
            public void testSamConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/samConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("supertypeArgumentsExplicit.kt")
            public void testSupertypeArgumentsExplicit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/supertypeArgumentsExplicit.kt");
                doTest(fileName);
            }

            @TestMetadata("supertypeTypeArguments.kt")
            public void testSupertypeTypeArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/supertypeTypeArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/commonSupertype")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CommonSupertype extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInCommonSupertype() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/commonSupertype"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("collectionOrNull.kt")
                public void testCollectionOrNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/collectionOrNull.kt");
                    doTest(fileName);
                }

                @TestMetadata("inferenceWithBound.kt")
                public void testInferenceWithBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/inferenceWithBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("mixedElvis.kt")
                public void testMixedElvis() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/mixedElvis.kt");
                    doTest(fileName);
                }

                @TestMetadata("mixedIf.kt")
                public void testMixedIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/mixedIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveGeneric.kt")
                public void testRecursiveGeneric() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/recursiveGeneric.kt");
                    doTest(fileName);
                }

                @TestMetadata("stringOrNull.kt")
                public void testStringOrNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/stringOrNull.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeOfElvis.kt")
                public void testTypeOfElvis() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/typeOfElvis.kt");
                    doTest(fileName);
                }

                @TestMetadata("withNothing.kt")
                public void testWithNothing() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/commonSupertype/withNothing.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class GenericVarianceViolation extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInGenericVarianceViolation() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("listSuperType.kt")
                public void testListSuperType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/listSuperType.kt");
                    doTest(fileName);
                }

                @TestMetadata("rawTypes.kt")
                public void testRawTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/rawTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/simple.kt");
                    doTest(fileName);
                }

                @TestMetadata("smartCast.kt")
                public void testSmartCast() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/smartCast.kt");
                    doTest(fileName);
                }

                @TestMetadata("strangeVariance.kt")
                public void testStrangeVariance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/strangeVariance.kt");
                    doTest(fileName);
                }

                @TestMetadata("userDefinedOut.kt")
                public void testUserDefinedOut() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/userDefinedOut.kt");
                    doTest(fileName);
                }

                @TestMetadata("valueFromJava.kt")
                public void testValueFromJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/valueFromJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("wildcards.kt")
                public void testWildcards() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/genericVarianceViolation/wildcards.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/intersection")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Intersection extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInIntersection() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/intersection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("map.kt")
                public void testMap() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/intersection/map.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class MethodCall extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInMethodCall() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/methodCall"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("entrySet.kt")
                public void testEntrySet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/entrySet.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericsAndArrays.kt")
                public void testGenericsAndArrays() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/genericsAndArrays.kt");
                    doTest(fileName);
                }

                @TestMetadata("int.kt")
                public void testInt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/int.kt");
                    doTest(fileName);
                }

                @TestMetadata("intArray.kt")
                public void testIntArray() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/intArray.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaCollectionToKotlin.kt")
                public void testJavaCollectionToKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/javaCollectionToKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaToJava.kt")
                public void testJavaToJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/javaToJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaToKotlin.kt")
                public void testJavaToKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/javaToKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("kotlinCollectionToJava.kt")
                public void testKotlinCollectionToJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/kotlinCollectionToJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("list.kt")
                public void testList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/list.kt");
                    doTest(fileName);
                }

                @TestMetadata("multipleExactBounds.kt")
                public void testMultipleExactBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/multipleExactBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("multipleExactBoundsNullable.kt")
                public void testMultipleExactBoundsNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/multipleExactBoundsNullable.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectArray.kt")
                public void testObjectArray() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/objectArray.kt");
                    doTest(fileName);
                }

                @TestMetadata("overloadingForSubclass.kt")
                public void testOverloadingForSubclass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/overloadingForSubclass.kt");
                    doTest(fileName);
                }

                @TestMetadata("sam.kt")
                public void testSam() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/sam.kt");
                    doTest(fileName);
                }

                @TestMetadata("singleton.kt")
                public void testSingleton() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/singleton.kt");
                    doTest(fileName);
                }

                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/string.kt");
                    doTest(fileName);
                }

                @TestMetadata("visitor.kt")
                public void testVisitor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/methodCall/visitor.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NotNullTypeParameter extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInNotNullTypeParameter() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("enhancementFromAnnotation.kt")
                public void testEnhancementFromAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/enhancementFromAnnotation.kt");
                    doTest(fileName);
                }

                @TestMetadata("enhancementFromKotlin.kt")
                public void testEnhancementFromKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/enhancementFromKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("methodTypeParameter.kt")
                public void testMethodTypeParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/methodTypeParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("noInheritanceReturnType.kt")
                public void testNoInheritanceReturnType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/noInheritanceReturnType.kt");
                    doTest(fileName);
                }

                @TestMetadata("noInheritanceValueParameter.kt")
                public void testNoInheritanceValueParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/noInheritanceValueParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("onTypeProjection.kt")
                public void testOnTypeProjection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/onTypeProjection.kt");
                    doTest(fileName);
                }

                @TestMetadata("substitutionInSuperType.kt")
                public void testSubstitutionInSuperType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/notNullTypeParameter/substitutionInSuperType.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NullabilityWarnings extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInNullabilityWarnings() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("arithmetic.kt")
                public void testArithmetic() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/arithmetic.kt");
                    doTest(fileName);
                }

                @TestMetadata("array.kt")
                public void testArray() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/array.kt");
                    doTest(fileName);
                }

                @TestMetadata("assignToVar.kt")
                public void testAssignToVar() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/assignToVar.kt");
                    doTest(fileName);
                }

                @TestMetadata("conditions.kt")
                public void testConditions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/conditions.kt");
                    doTest(fileName);
                }

                @TestMetadata("dataFlowInfo.kt")
                public void testDataFlowInfo() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/dataFlowInfo.kt");
                    doTest(fileName);
                }

                @TestMetadata("defaultParameters.kt")
                public void testDefaultParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/defaultParameters.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegatedProperties.kt")
                public void testDelegatedProperties() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/delegatedProperties.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegation.kt")
                public void testDelegation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/delegation.kt");
                    doTest(fileName);
                }

                @TestMetadata("derefenceExtension.kt")
                public void testDerefenceExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/derefenceExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("derefenceMember.kt")
                public void testDerefenceMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/derefenceMember.kt");
                    doTest(fileName);
                }

                @TestMetadata("elvis.kt")
                public void testElvis() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/elvis.kt");
                    doTest(fileName);
                }

                @TestMetadata("expectedType.kt")
                public void testExpectedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/expectedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("for.kt")
                public void testFor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/for.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionArguments.kt")
                public void testFunctionArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/functionArguments.kt");
                    doTest(fileName);
                }

                @TestMetadata("inferenceInConditionals.kt")
                public void testInferenceInConditionals() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/inferenceInConditionals.kt");
                    doTest(fileName);
                }

                @TestMetadata("invoke.kt")
                public void testInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/invoke.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt6829.kt")
                public void testKt6829() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/kt6829.kt");
                    doTest(fileName);
                }

                @TestMetadata("multiDeclaration.kt")
                public void testMultiDeclaration() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/multiDeclaration.kt");
                    doTest(fileName);
                }

                @TestMetadata("notNullAfterSafeCall.kt")
                public void testNotNullAfterSafeCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/notNullAfterSafeCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("notNullAssertion.kt")
                public void testNotNullAssertion() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/notNullAssertion.kt");
                    doTest(fileName);
                }

                @TestMetadata("notNullAssertionInCall.kt")
                public void testNotNullAssertionInCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/notNullAssertionInCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("notNullTypeMarkedWithNullableAnnotation.kt")
                public void testNotNullTypeMarkedWithNullableAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/notNullTypeMarkedWithNullableAnnotation.kt");
                    doTest(fileName);
                }

                @TestMetadata("passToJava.kt")
                public void testPassToJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/passToJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("primitiveArray.kt")
                public void testPrimitiveArray() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/primitiveArray.kt");
                    doTest(fileName);
                }

                @TestMetadata("safeCall.kt")
                public void testSafeCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/safeCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("senselessComparisonEquals.kt")
                public void testSenselessComparisonEquals() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/senselessComparisonEquals.kt");
                    doTest(fileName);
                }

                @TestMetadata("senselessComparisonIdentityEquals.kt")
                public void testSenselessComparisonIdentityEquals() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/senselessComparisonIdentityEquals.kt");
                    doTest(fileName);
                }

                @TestMetadata("throw.kt")
                public void testThrow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/throw.kt");
                    doTest(fileName);
                }

                @TestMetadata("uselessElvisInCall.kt")
                public void testUselessElvisInCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/uselessElvisInCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("uselessElvisRightIsNull.kt")
                public void testUselessElvisRightIsNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/nullabilityWarnings/uselessElvisRightIsNull.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class RawTypes extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInRawTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/rawTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("arrays.kt")
                public void testArrays() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/arrays.kt");
                    doTest(fileName);
                }

                @TestMetadata("errorType.kt")
                public void testErrorType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/errorType.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericInnerClass.kt")
                public void testGenericInnerClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/genericInnerClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonGenericRawMember.kt")
                public void testNonGenericRawMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/nonGenericRawMember.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonTrivialErasure.kt")
                public void testNonTrivialErasure() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/nonTrivialErasure.kt");
                    doTest(fileName);
                }

                @TestMetadata("rawEnhancment.kt")
                public void testRawEnhancment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/rawEnhancment.kt");
                    doTest(fileName);
                }

                @TestMetadata("rawSupertype.kt")
                public void testRawSupertype() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/rawSupertype.kt");
                    doTest(fileName);
                }

                @TestMetadata("rawSupertypeOverride.kt")
                public void testRawSupertypeOverride() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/rawSupertypeOverride.kt");
                    doTest(fileName);
                }

                @TestMetadata("rawTypeInUpperBound.kt")
                public void testRawTypeInUpperBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/rawTypeInUpperBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("rawWithInProjection.kt")
                public void testRawWithInProjection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/rawWithInProjection.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveBound.kt")
                public void testRecursiveBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/recursiveBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("samRaw.kt")
                public void testSamRaw() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/samRaw.kt");
                    doTest(fileName);
                }

                @TestMetadata("saveRawCapabilitiesAfterSubtitution.kt")
                public void testSaveRawCapabilitiesAfterSubtitution() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/saveRawCapabilitiesAfterSubtitution.kt");
                    doTest(fileName);
                }

                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/simple.kt");
                    doTest(fileName);
                }

                @TestMetadata("starProjectionToRaw.kt")
                public void testStarProjectionToRaw() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/starProjectionToRaw.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeEnhancement.kt")
                public void testTypeEnhancement() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/rawTypes/typeEnhancement.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TypeEnhancement extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInTypeEnhancement() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("overriddenExtensions.kt")
                public void testOverriddenExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement/overriddenExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("saveAnnotationAfterSubstitution.kt")
                public void testSaveAnnotationAfterSubstitution() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement/saveAnnotationAfterSubstitution.kt");
                    doTest(fileName);
                }

                @TestMetadata("supertypeDifferentParameterNullability.kt")
                public void testSupertypeDifferentParameterNullability() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement/supertypeDifferentParameterNullability.kt");
                    doTest(fileName);
                }

                @TestMetadata("supertypeDifferentReturnNullability.kt")
                public void testSupertypeDifferentReturnNullability() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/platformTypes/typeEnhancement/supertypeDifferentReturnNullability.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/privateInFile")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PrivateInFile extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInPrivateInFile() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/privateInFile"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kt12429.kt")
            public void testKt12429() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/privateInFile/kt12429.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelAnnotationCall.kt")
            public void testTopLevelAnnotationCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/privateInFile/topLevelAnnotationCall.kt");
                doTest(fileName);
            }

            @TestMetadata("visibility.kt")
            public void testVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/privateInFile/visibility.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/properties")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Properties extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInProperties() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/properties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InferenceFromGetters extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInInferenceFromGetters() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/properties/inferenceFromGetters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("blockBodyGetter.kt")
                public void testBlockBodyGetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/blockBodyGetter.kt");
                    doTest(fileName);
                }

                @TestMetadata("cantBeInferred.kt")
                public void testCantBeInferred() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/cantBeInferred.kt");
                    doTest(fileName);
                }

                @TestMetadata("explicitGetterType.kt")
                public void testExplicitGetterType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/explicitGetterType.kt");
                    doTest(fileName);
                }

                @TestMetadata("members.kt")
                public void testMembers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/members.kt");
                    doTest(fileName);
                }

                @TestMetadata("nullAsNothing.kt")
                public void testNullAsNothing() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/nullAsNothing.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectExpression.kt")
                public void testObjectExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/objectExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("overrides.kt")
                public void testOverrides() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/overrides.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveGetter.kt")
                public void testRecursiveGetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/recursiveGetter.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevel.kt")
                public void testTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/topLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("vars.kt")
                public void testVars() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/properties/inferenceFromGetters/vars.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/qualifiedExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class QualifiedExpression extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInQualifiedExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/qualifiedExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("GenericClassVsPackage.kt")
            public void testGenericClassVsPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/qualifiedExpression/GenericClassVsPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("JavaQualifier.kt")
            public void testJavaQualifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/qualifiedExpression/JavaQualifier.kt");
                doTest(fileName);
            }

            @TestMetadata("PackageVsClass.kt")
            public void testPackageVsClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/qualifiedExpression/PackageVsClass.kt");
                doTest(fileName);
            }

            @TestMetadata("PackageVsClass2.kt")
            public void testPackageVsClass2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/qualifiedExpression/PackageVsClass2.kt");
                doTest(fileName);
            }

            @TestMetadata("PackageVsRootClass.kt")
            public void testPackageVsRootClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/qualifiedExpression/PackageVsRootClass.kt");
                doTest(fileName);
            }

            @TestMetadata("TypeWithError.kt")
            public void testTypeWithError() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/qualifiedExpression/TypeWithError.kt");
                doTest(fileName);
            }

            @TestMetadata("visibleClassVsQualifiedClass.kt")
            public void testVisibleClassVsQualifiedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/qualifiedExpression/visibleClassVsQualifiedClass.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/reassignment")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Reassignment extends AbstractDiagnosticsTest {
            @TestMetadata("afterfor.kt")
            public void testAfterfor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/reassignment/afterfor.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInReassignment() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/reassignment"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("dowhile.kt")
            public void testDowhile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/reassignment/dowhile.kt");
                doTest(fileName);
            }

            @TestMetadata("else.kt")
            public void testElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/reassignment/else.kt");
                doTest(fileName);
            }

            @TestMetadata("foronly.kt")
            public void testForonly() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/reassignment/foronly.kt");
                doTest(fileName);
            }

            @TestMetadata("if.kt")
            public void testIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/reassignment/if.kt");
                doTest(fileName);
            }

            @TestMetadata("ifelse.kt")
            public void testIfelse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/reassignment/ifelse.kt");
                doTest(fileName);
            }

            @TestMetadata("noifelse.kt")
            public void testNoifelse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/reassignment/noifelse.kt");
                doTest(fileName);
            }

            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/reassignment/when.kt");
                doTest(fileName);
            }

            @TestMetadata("whiletrue.kt")
            public void testWhiletrue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/reassignment/whiletrue.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/recovery")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Recovery extends AbstractDiagnosticsTest {
            @TestMetadata("absentLeftHandSide.kt")
            public void testAbsentLeftHandSide() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/recovery/absentLeftHandSide.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInRecovery() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/recovery"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("emptyTypeArgs.kt")
            public void testEmptyTypeArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/recovery/emptyTypeArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("namelessInJava.kt")
            public void testNamelessInJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/recovery/namelessInJava.kt");
                doTest(fileName);
            }

            @TestMetadata("namelessMembers.kt")
            public void testNamelessMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/recovery/namelessMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("namelessToplevelDeclarations.kt")
            public void testNamelessToplevelDeclarations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/recovery/namelessToplevelDeclarations.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/redeclarations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Redeclarations extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInRedeclarations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/redeclarations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ClassRedeclarationInDifferentFiles.kt")
            public void testClassRedeclarationInDifferentFiles() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/ClassRedeclarationInDifferentFiles.kt");
                doTest(fileName);
            }

            @TestMetadata("ConflictingExtensionProperties.kt")
            public void testConflictingExtensionProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/ConflictingExtensionProperties.kt");
                doTest(fileName);
            }

            @TestMetadata("EnumName.kt")
            public void testEnumName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/EnumName.kt");
                doTest(fileName);
            }

            @TestMetadata("FunVsCtorInDifferentFiles.kt")
            public void testFunVsCtorInDifferentFiles() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/FunVsCtorInDifferentFiles.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2418.kt")
            public void testKt2418() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/kt2418.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2438.kt")
            public void testKt2438() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/kt2438.kt");
                doTest(fileName);
            }

            @TestMetadata("kt470.kt")
            public void testKt470() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/kt470.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiFilePackageRedeclaration.kt")
            public void testMultiFilePackageRedeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/MultiFilePackageRedeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("NoRedeclarationForClassesInDefaultObject.kt")
            public void testNoRedeclarationForClassesInDefaultObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/NoRedeclarationForClassesInDefaultObject.kt");
                doTest(fileName);
            }

            @TestMetadata("NoRedeclarationForEnumEntriesAndDefaultObjectMembers.kt")
            public void testNoRedeclarationForEnumEntriesAndDefaultObjectMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/NoRedeclarationForEnumEntriesAndDefaultObjectMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("PropertyAndFunInClass.kt")
            public void testPropertyAndFunInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/PropertyAndFunInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("PropertyAndInnerClass.kt")
            public void testPropertyAndInnerClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/PropertyAndInnerClass.kt");
                doTest(fileName);
            }

            @TestMetadata("RedeclarationInDefaultObject.kt")
            public void testRedeclarationInDefaultObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/RedeclarationInDefaultObject.kt");
                doTest(fileName);
            }

            @TestMetadata("RedeclarationInMultiFile.kt")
            public void testRedeclarationInMultiFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/RedeclarationInMultiFile.kt");
                doTest(fileName);
            }

            @TestMetadata("RedeclarationMainInFile.kt")
            public void testRedeclarationMainInFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/RedeclarationMainInFile.kt");
                doTest(fileName);
            }

            @TestMetadata("RedeclarationMainInMultiFile.kt")
            public void testRedeclarationMainInMultiFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/RedeclarationMainInMultiFile.kt");
                doTest(fileName);
            }

            @TestMetadata("Redeclarations.kt")
            public void testRedeclarations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/Redeclarations.kt");
                doTest(fileName);
            }

            @TestMetadata("RedeclarationsInObjects.kt")
            public void testRedeclarationsInObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/RedeclarationsInObjects.kt");
                doTest(fileName);
            }

            @TestMetadata("RedeclaredTypeParameters.kt")
            public void testRedeclaredTypeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/RedeclaredTypeParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("RedeclaringPrivateToFile.kt")
            public void testRedeclaringPrivateToFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/RedeclaringPrivateToFile.kt");
                doTest(fileName);
            }

            @TestMetadata("ScriptAndClassConflict.kt")
            public void testScriptAndClassConflict() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/ScriptAndClassConflict.kt");
                doTest(fileName);
            }

            @TestMetadata("SingletonAndFunctionSameName.kt")
            public void testSingletonAndFunctionSameName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/SingletonAndFunctionSameName.kt");
                doTest(fileName);
            }

            @TestMetadata("TopLevelPropertyVsClassifier.kt")
            public void testTopLevelPropertyVsClassifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/TopLevelPropertyVsClassifier.kt");
                doTest(fileName);
            }

            @TestMetadata("TypeAliasCtorVsFun.kt")
            public void testTypeAliasCtorVsFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/TypeAliasCtorVsFun.kt");
                doTest(fileName);
            }

            @TestMetadata("TypeAliasVsClass.kt")
            public void testTypeAliasVsClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/TypeAliasVsClass.kt");
                doTest(fileName);
            }

            @TestMetadata("TypeAliasVsProperty.kt")
            public void testTypeAliasVsProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/TypeAliasVsProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParameterWithTwoBounds.kt")
            public void testTypeParameterWithTwoBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/redeclarations/typeParameterWithTwoBounds.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/reflection")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Reflection extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInReflection() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/reflection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("noReflectionInClassPath.kt")
            public void testNoReflectionInClassPath() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/reflection/noReflectionInClassPath.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/regressions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Regressions extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInRegressions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/regressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AmbiguityOnLazyTypeComputation.kt")
            public void testAmbiguityOnLazyTypeComputation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/AmbiguityOnLazyTypeComputation.kt");
                doTest(fileName);
            }

            @TestMetadata("AssignmentsUnderOperators.kt")
            public void testAssignmentsUnderOperators() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/AssignmentsUnderOperators.kt");
                doTest(fileName);
            }

            @TestMetadata("CoercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/CoercionToUnit.kt");
                doTest(fileName);
            }

            @TestMetadata("DoubleDefine.kt")
            public void testDoubleDefine() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/DoubleDefine.kt");
                doTest(fileName);
            }

            @TestMetadata("ea40964.kt")
            public void testEa40964() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/ea40964.kt");
                doTest(fileName);
            }

            @TestMetadata("ea43298.kt")
            public void testEa43298() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/ea43298.kt");
                doTest(fileName);
            }

            @TestMetadata("ea53340.kt")
            public void testEa53340() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/ea53340.kt");
                doTest(fileName);
            }

            @TestMetadata("ea65509.kt")
            public void testEa65509() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/ea65509.kt");
                doTest(fileName);
            }

            @TestMetadata("ea66984.kt")
            public void testEa66984() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/ea66984.kt");
                doTest(fileName);
            }

            @TestMetadata("ea69735.kt")
            public void testEa69735() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/ea69735.kt");
                doTest(fileName);
            }

            @TestMetadata("ea72837.kt")
            public void testEa72837() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/ea72837.kt");
                doTest(fileName);
            }

            @TestMetadata("ea76264.kt")
            public void testEa76264() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/ea76264.kt");
                doTest(fileName);
            }

            @TestMetadata("ErrorsOnIbjectExpressionsAsParameters.kt")
            public void testErrorsOnIbjectExpressionsAsParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/ErrorsOnIbjectExpressionsAsParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("intchar.kt")
            public void testIntchar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/intchar.kt");
                doTest(fileName);
            }

            @TestMetadata("itselfAsUpperBound.kt")
            public void testItselfAsUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("itselfAsUpperBoundInClass.kt")
            public void testItselfAsUpperBoundInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBoundInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("itselfAsUpperBoundInClassNotNull.kt")
            public void testItselfAsUpperBoundInClassNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBoundInClassNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("itselfAsUpperBoundLocal.kt")
            public void testItselfAsUpperBoundLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBoundLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("itselfAsUpperBoundMember.kt")
            public void testItselfAsUpperBoundMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBoundMember.kt");
                doTest(fileName);
            }

            @TestMetadata("itselfAsUpperBoundNotNull.kt")
            public void testItselfAsUpperBoundNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/itselfAsUpperBoundNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet11.kt")
            public void testJet11() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet11.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet121.kt")
            public void testJet121() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet121.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet124.kt")
            public void testJet124() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet124.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet169.kt")
            public void testJet169() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet169.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet17.kt")
            public void testJet17() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet17.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet183.kt")
            public void testJet183() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet183.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet183-1.kt")
            public void testJet183_1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet183-1.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet53.kt")
            public void testJet53() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet53.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet67.kt")
            public void testJet67() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet67.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet68.kt")
            public void testJet68() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet68.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet69.kt")
            public void testJet69() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet69.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet72.kt")
            public void testJet72() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet72.kt");
                doTest(fileName);
            }

            @TestMetadata("Jet81.kt")
            public void testJet81() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/Jet81.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10243.kt")
            public void testKt10243() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt10243.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10243a.kt")
            public void testKt10243a() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt10243a.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10633.kt")
            public void testKt10633() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt10633.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10824.kt")
            public void testKt10824() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt10824.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10843.kt")
            public void testKt10843() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt10843.kt");
                doTest(fileName);
            }

            @TestMetadata("kt127.kt")
            public void testKt127() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt127.kt");
                doTest(fileName);
            }

            @TestMetadata("kt128.kt")
            public void testKt128() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt128.kt");
                doTest(fileName);
            }

            @TestMetadata("kt13685.kt")
            public void testKt13685() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt13685.kt");
                doTest(fileName);
            }

            @TestMetadata("kt13954.kt")
            public void testKt13954() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt13954.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1489_1728.kt")
            public void testKt1489_1728() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt1489_1728.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1550.kt")
            public void testKt1550() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt1550.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1639-JFrame.kt")
            public void testKt1639_JFrame() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt1639-JFrame.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1647.kt")
            public void testKt1647() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt1647.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1736.kt")
            public void testKt1736() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt1736.kt");
                doTest(fileName);
            }

            @TestMetadata("kt174.kt")
            public void testKt174() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt174.kt");
                doTest(fileName);
            }

            @TestMetadata("kt201.kt")
            public void testKt201() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt201.kt");
                doTest(fileName);
            }

            @TestMetadata("kt235.kt")
            public void testKt235() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt235.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2376.kt")
            public void testKt2376() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt2376.kt");
                doTest(fileName);
            }

            @TestMetadata("kt251.kt")
            public void testKt251() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt251.kt");
                doTest(fileName);
            }

            @TestMetadata("kt258.kt")
            public void testKt258() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt258.kt");
                doTest(fileName);
            }

            @TestMetadata("kt26.kt")
            public void testKt26() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt26.kt");
                doTest(fileName);
            }

            @TestMetadata("kt26-1.kt")
            public void testKt26_1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt26-1.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2768.kt")
            public void testKt2768() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt2768.kt");
                doTest(fileName);
            }

            @TestMetadata("kt282.kt")
            public void testKt282() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt282.kt");
                doTest(fileName);
            }

            @TestMetadata("kt287.kt")
            public void testKt287() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt287.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2956.kt")
            public void testKt2956() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt2956.kt");
                doTest(fileName);
            }

            @TestMetadata("kt302.kt")
            public void testKt302() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt302.kt");
                doTest(fileName);
            }

            @TestMetadata("kt306.kt")
            public void testKt306() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt306.kt");
                doTest(fileName);
            }

            @TestMetadata("kt307.kt")
            public void testKt307() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt307.kt");
                doTest(fileName);
            }

            @TestMetadata("kt312.kt")
            public void testKt312() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt312.kt");
                doTest(fileName);
            }

            @TestMetadata("kt313.kt")
            public void testKt313() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt313.kt");
                doTest(fileName);
            }

            @TestMetadata("kt316.kt")
            public void testKt316() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt316.kt");
                doTest(fileName);
            }

            @TestMetadata("kt328.kt")
            public void testKt328() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt328.kt");
                doTest(fileName);
            }

            @TestMetadata("kt334.kt")
            public void testKt334() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt334.kt");
                doTest(fileName);
            }

            @TestMetadata("kt335.336.kt")
            public void testKt335_336() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt335.336.kt");
                doTest(fileName);
            }

            @TestMetadata("kt337.kt")
            public void testKt337() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt337.kt");
                doTest(fileName);
            }

            @TestMetadata("kt352.kt")
            public void testKt352() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt352.kt");
                doTest(fileName);
            }

            @TestMetadata("kt353.kt")
            public void testKt353() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt353.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3535.kt")
            public void testKt3535() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt3535.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3647.kt")
            public void testKt3647() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt3647.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3731.kt")
            public void testKt3731() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt3731.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3810.kt")
            public void testKt3810() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt3810.kt");
                doTest(fileName);
            }

            @TestMetadata("kt385.109.441.kt")
            public void testKt385_109_441() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt385.109.441.kt");
                doTest(fileName);
            }

            @TestMetadata("kt394.kt")
            public void testKt394() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt394.kt");
                doTest(fileName);
            }

            @TestMetadata("kt398.kt")
            public void testKt398() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt398.kt");
                doTest(fileName);
            }

            @TestMetadata("kt399.kt")
            public void testKt399() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt399.kt");
                doTest(fileName);
            }

            @TestMetadata("kt402.kt")
            public void testKt402() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt402.kt");
                doTest(fileName);
            }

            @TestMetadata("kt41.kt")
            public void testKt41() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt41.kt");
                doTest(fileName);
            }

            @TestMetadata("kt411.kt")
            public void testKt411() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt411.kt");
                doTest(fileName);
            }

            @TestMetadata("kt439.kt")
            public void testKt439() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt439.kt");
                doTest(fileName);
            }

            @TestMetadata("kt442.kt")
            public void testKt442() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt442.kt");
                doTest(fileName);
            }

            @TestMetadata("kt443.kt")
            public void testKt443() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt443.kt");
                doTest(fileName);
            }

            @TestMetadata("kt455.kt")
            public void testKt455() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt455.kt");
                doTest(fileName);
            }

            @TestMetadata("kt456.kt")
            public void testKt456() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt456.kt");
                doTest(fileName);
            }

            @TestMetadata("kt459.kt")
            public void testKt459() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt459.kt");
                doTest(fileName);
            }

            @TestMetadata("kt469.kt")
            public void testKt469() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt469.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4693.kt")
            public void testKt4693() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt4693.kt");
                doTest(fileName);
            }

            @TestMetadata("kt4827.kt")
            public void testKt4827() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt4827.kt");
                doTest(fileName);
            }

            @TestMetadata("kt498.kt")
            public void testKt498() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt498.kt");
                doTest(fileName);
            }

            @TestMetadata("kt524.kt")
            public void testKt524() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt524.kt");
                doTest(fileName);
            }

            @TestMetadata("kt526UnresolvedReferenceInnerStatic.kt")
            public void testKt526UnresolvedReferenceInnerStatic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt526UnresolvedReferenceInnerStatic.kt");
                doTest(fileName);
            }

            @TestMetadata("kt5326.kt")
            public void testKt5326() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt5326.kt");
                doTest(fileName);
            }

            @TestMetadata("kt5362.kt")
            public void testKt5362() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt5362.kt");
                doTest(fileName);
            }

            @TestMetadata("kt549.kt")
            public void testKt549() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt549.kt");
                doTest(fileName);
            }

            @TestMetadata("kt557.kt")
            public void testKt557() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt557.kt");
                doTest(fileName);
            }

            @TestMetadata("kt571.kt")
            public void testKt571() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt571.kt");
                doTest(fileName);
            }

            @TestMetadata("kt575.kt")
            public void testKt575() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt575.kt");
                doTest(fileName);
            }

            @TestMetadata("kt58.kt")
            public void testKt58() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt58.kt");
                doTest(fileName);
            }

            @TestMetadata("kt580.kt")
            public void testKt580() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt580.kt");
                doTest(fileName);
            }

            @TestMetadata("kt588.kt")
            public void testKt588() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt588.kt");
                doTest(fileName);
            }

            @TestMetadata("kt597.kt")
            public void testKt597() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt597.kt");
                doTest(fileName);
            }

            @TestMetadata("kt600.kt")
            public void testKt600() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt600.kt");
                doTest(fileName);
            }

            @TestMetadata("kt604.kt")
            public void testKt604() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt604.kt");
                doTest(fileName);
            }

            @TestMetadata("kt618.kt")
            public void testKt618() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt618.kt");
                doTest(fileName);
            }

            @TestMetadata("kt629.kt")
            public void testKt629() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt629.kt");
                doTest(fileName);
            }

            @TestMetadata("kt630.kt")
            public void testKt630() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt630.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6508.kt")
            public void testKt6508() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt6508.kt");
                doTest(fileName);
            }

            @TestMetadata("kt688.kt")
            public void testKt688() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt688.kt");
                doTest(fileName);
            }

            @TestMetadata("kt691.kt")
            public void testKt691() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt691.kt");
                doTest(fileName);
            }

            @TestMetadata("kt701.kt")
            public void testKt701() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt701.kt");
                doTest(fileName);
            }

            @TestMetadata("kt716.kt")
            public void testKt716() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt716.kt");
                doTest(fileName);
            }

            @TestMetadata("kt743.kt")
            public void testKt743() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt743.kt");
                doTest(fileName);
            }

            @TestMetadata("kt750.kt")
            public void testKt750() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt750.kt");
                doTest(fileName);
            }

            @TestMetadata("kt762.kt")
            public void testKt762() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt762.kt");
                doTest(fileName);
            }

            @TestMetadata("kt7804.kt")
            public void testKt7804() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt7804.kt");
                doTest(fileName);
            }

            @TestMetadata("kt847.kt")
            public void testKt847() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt847.kt");
                doTest(fileName);
            }

            @TestMetadata("kt860.kt")
            public void testKt860() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt860.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9620.kt")
            public void testKt9620() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt9620.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9633.kt")
            public void testKt9633() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt9633.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9682.kt")
            public void testKt9682() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt9682.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9808.kt")
            public void testKt9808() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt9808.kt");
                doTest(fileName);
            }

            @TestMetadata("noThis.kt")
            public void testNoThis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/noThis.kt");
                doTest(fileName);
            }

            @TestMetadata("OrphanStarProjection.kt")
            public void testOrphanStarProjection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/OrphanStarProjection.kt");
                doTest(fileName);
            }

            @TestMetadata("OutProjections.kt")
            public void testOutProjections() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/OutProjections.kt");
                doTest(fileName);
            }

            @TestMetadata("OverrideResolution.kt")
            public void testOverrideResolution() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/OverrideResolution.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveSubclassOfList.kt")
            public void testResolveSubclassOfList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/resolveSubclassOfList.kt");
                doTest(fileName);
            }

            @TestMetadata("SpecififcityByReceiver.kt")
            public void testSpecififcityByReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/SpecififcityByReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("TypeMismatchOnUnaryOperations.kt")
            public void testTypeMismatchOnUnaryOperations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/TypeMismatchOnUnaryOperations.kt");
                doTest(fileName);
            }

            @TestMetadata("TypeParameterAsASupertype.kt")
            public void testTypeParameterAsASupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/TypeParameterAsASupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("UnavaliableQualifiedThis.kt")
            public void testUnavaliableQualifiedThis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/UnavaliableQualifiedThis.kt");
                doTest(fileName);
            }

            @TestMetadata("WrongTraceInCallResolver.kt")
            public void testWrongTraceInCallResolver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/WrongTraceInCallResolver.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/regressions/kt7585")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Kt7585 extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInKt7585() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/regressions/kt7585"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("base.kt")
                public void testBase() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt7585/base.kt");
                    doTest(fileName);
                }

                @TestMetadata("java.kt")
                public void testJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt7585/java.kt");
                    doTest(fileName);
                }

                @TestMetadata("twoparents.kt")
                public void testTwoparents() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/regressions/kt7585/twoparents.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/resolve")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Resolve extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInResolve() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ambiguityOnPropertiesWithTheSamePackageName.kt")
            public void testAmbiguityOnPropertiesWithTheSamePackageName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/ambiguityOnPropertiesWithTheSamePackageName.kt");
                doTest(fileName);
            }

            @TestMetadata("ambiguityWithTwoCorrespondingFunctionTypes.kt")
            public void testAmbiguityWithTwoCorrespondingFunctionTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/ambiguityWithTwoCorrespondingFunctionTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("capturedTypesInLambdaParameter.kt")
            public void testCapturedTypesInLambdaParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/capturedTypesInLambdaParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorVsCompanion.kt")
            public void testConstructorVsCompanion() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/constructorVsCompanion.kt");
                doTest(fileName);
            }

            @TestMetadata("CycleInTypeArgs.kt")
            public void testCycleInTypeArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/CycleInTypeArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("HiddenDeclarations.kt")
            public void testHiddenDeclarations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/HiddenDeclarations.kt");
                doTest(fileName);
            }

            @TestMetadata("implicitReceiverProperty.kt")
            public void testImplicitReceiverProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/implicitReceiverProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("incompleteConstructorInvocation.kt")
            public void testIncompleteConstructorInvocation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/incompleteConstructorInvocation.kt");
                doTest(fileName);
            }

            @TestMetadata("inferenceInLinkedLambdas.kt")
            public void testInferenceInLinkedLambdas() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/inferenceInLinkedLambdas.kt");
                doTest(fileName);
            }

            @TestMetadata("inferenceInLinkedLambdasDependentOnExpectedType.kt")
            public void testInferenceInLinkedLambdasDependentOnExpectedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/inferenceInLinkedLambdasDependentOnExpectedType.kt");
                doTest(fileName);
            }

            @TestMetadata("localObject.kt")
            public void testLocalObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/localObject.kt");
                doTest(fileName);
            }

            @TestMetadata("objectLiteralAsArgument.kt")
            public void testObjectLiteralAsArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/objectLiteralAsArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveAnnotatedLambdaArgument.kt")
            public void testResolveAnnotatedLambdaArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/resolveAnnotatedLambdaArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveTypeArgsForUnresolvedCall.kt")
            public void testResolveTypeArgsForUnresolvedCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/resolveTypeArgsForUnresolvedCall.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveWithFunctionLiteralWithId.kt")
            public void testResolveWithFunctionLiteralWithId() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/resolveWithFunctionLiteralWithId.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveWithFunctionLiterals.kt")
            public void testResolveWithFunctionLiterals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/resolveWithFunctionLiterals.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveWithFunctionLiteralsOverload.kt")
            public void testResolveWithFunctionLiteralsOverload() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/resolveWithFunctionLiteralsOverload.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveWithGenerics.kt")
            public void testResolveWithGenerics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/resolveWithGenerics.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveWithRedeclarationError.kt")
            public void testResolveWithRedeclarationError() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/resolveWithRedeclarationError.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveWithSpecifiedFunctionLiteralWithId.kt")
            public void testResolveWithSpecifiedFunctionLiteralWithId() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/resolveWithSpecifiedFunctionLiteralWithId.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveWithoutGenerics.kt")
            public void testResolveWithoutGenerics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/resolveWithoutGenerics.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongNumberOfTypeArguments.kt")
            public void testWrongNumberOfTypeArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/wrongNumberOfTypeArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongReceiver.kt")
            public void testWrongReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/wrongReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DslMarker extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInDslMarker() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/dslMarker"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotatedTypeArgument.kt")
                public void testAnnotatedTypeArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/annotatedTypeArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("inheritedMarker.kt")
                public void testInheritedMarker() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/inheritedMarker.kt");
                    doTest(fileName);
                }

                @TestMetadata("insideTopLevelExtension.kt")
                public void testInsideTopLevelExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/insideTopLevelExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("insideTopLevelExtensionAnnotatedType.kt")
                public void testInsideTopLevelExtensionAnnotatedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/insideTopLevelExtensionAnnotatedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("markersIntersection.kt")
                public void testMarkersIntersection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/markersIntersection.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedWithSameReceiver.kt")
                public void testNestedWithSameReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/nestedWithSameReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("properties.kt")
                public void testProperties() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/properties.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleAnnotatedClasses.kt")
                public void testSimpleAnnotatedClasses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/simpleAnnotatedClasses.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleAnnotatedTypes.kt")
                public void testSimpleAnnotatedTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/simpleAnnotatedTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("substitutedReceiverAnnotatedClasses.kt")
                public void testSubstitutedReceiverAnnotatedClasses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/substitutedReceiverAnnotatedClasses.kt");
                    doTest(fileName);
                }

                @TestMetadata("substitutedReceiverAnnotatedType.kt")
                public void testSubstitutedReceiverAnnotatedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/substitutedReceiverAnnotatedType.kt");
                    doTest(fileName);
                }

                @TestMetadata("threeImplicitReceivers.kt")
                public void testThreeImplicitReceivers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/threeImplicitReceivers.kt");
                    doTest(fileName);
                }

                @TestMetadata("threeImplicitReceivers2.kt")
                public void testThreeImplicitReceivers2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/threeImplicitReceivers2.kt");
                    doTest(fileName);
                }

                @TestMetadata("twoImplicitReceivers.kt")
                public void testTwoImplicitReceivers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/twoImplicitReceivers.kt");
                    doTest(fileName);
                }

                @TestMetadata("twoLanguages.kt")
                public void testTwoLanguages() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/twoLanguages.kt");
                    doTest(fileName);
                }

                @TestMetadata("unsupportedFeature.kt")
                public void testUnsupportedFeature() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/unsupportedFeature.kt");
                    doTest(fileName);
                }

                @TestMetadata("useOfExtensions.kt")
                public void testUseOfExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/useOfExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("usingWith.kt")
                public void testUsingWith() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/usingWith.kt");
                    doTest(fileName);
                }

                @TestMetadata("usingWithThis.kt")
                public void testUsingWithThis() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/dslMarker/usingWithThis.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/invoke")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invoke extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInInvoke() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/invoke"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("extensionValueAsNonExtension.kt")
                public void testExtensionValueAsNonExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/extensionValueAsNonExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("implicitInvoke.kt")
                public void testImplicitInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/implicitInvoke.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeAndSmartCast.kt")
                public void testInvokeAndSmartCast() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/invokeAndSmartCast.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeAsExtension.kt")
                public void testInvokeAsExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/invokeAsExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeAsMember.kt")
                public void testInvokeAsMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/invokeAsMember.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeAsMemberExtension.kt")
                public void testInvokeAsMemberExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/invokeAsMemberExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeAsMemberExtensionToExplicitReceiver.kt")
                public void testInvokeAsMemberExtensionToExplicitReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/invokeAsMemberExtensionToExplicitReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeNonExtensionLambdaInContext.kt")
                public void testInvokeNonExtensionLambdaInContext() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/invokeNonExtensionLambdaInContext.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeOnVariableWithExtensionFunctionType.kt")
                public void testInvokeOnVariableWithExtensionFunctionType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/invokeOnVariableWithExtensionFunctionType.kt");
                    doTest(fileName);
                }

                @TestMetadata("KT-4372.kt")
                public void testKT_4372() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/KT-4372.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3772.kt")
                public void testKt3772() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/kt3772.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3833-invokeInsideNestedClass.kt")
                public void testKt3833_invokeInsideNestedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/kt3833-invokeInsideNestedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt4204-completeNestedCallsForInvoke.kt")
                public void testKt4204_completeNestedCallsForInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/kt4204-completeNestedCallsForInvoke.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt4321InvokeOnEnum.kt")
                public void testKt4321InvokeOnEnum() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/kt4321InvokeOnEnum.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt9517.kt")
                public void testKt9517() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/kt9517.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt9805.kt")
                public void testKt9805() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/kt9805.kt");
                    doTest(fileName);
                }

                @TestMetadata("valNamedInvoke.kt")
                public void testValNamedInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/valNamedInvoke.kt");
                    doTest(fileName);
                }

                @TestMetadata("wrongInvokeExtension.kt")
                public void testWrongInvokeExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/wrongInvokeExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("compiler/testData/diagnostics/tests/resolve/invoke/errors")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Errors extends AbstractDiagnosticsTest {
                    public void testAllFilesPresentInErrors() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/invoke/errors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("ambiguityForInvoke.kt")
                    public void testAmbiguityForInvoke() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/errors/ambiguityForInvoke.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("invisibleInvoke.kt")
                    public void testInvisibleInvoke() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/errors/invisibleInvoke.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("receiverPresenceErrorForInvoke.kt")
                    public void testReceiverPresenceErrorForInvoke() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/errors/receiverPresenceErrorForInvoke.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("typeInferenceErrorForInvoke.kt")
                    public void testTypeInferenceErrorForInvoke() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/errors/typeInferenceErrorForInvoke.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("unresolvedInvoke.kt")
                    public void testUnresolvedInvoke() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/errors/unresolvedInvoke.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("unsafeCallWithInvoke.kt")
                    public void testUnsafeCallWithInvoke() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/errors/unsafeCallWithInvoke.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("wrongReceiverForInvokeOnExpression.kt")
                    public void testWrongReceiverForInvokeOnExpression() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/errors/wrongReceiverForInvokeOnExpression.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("wrongReceiverTypeForInvoke.kt")
                    public void testWrongReceiverTypeForInvoke() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/invoke/errors/wrongReceiverTypeForInvoke.kt");
                        doTest(fileName);
                    }
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/nestedCalls")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NestedCalls extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInNestedCalls() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/nestedCalls"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("analyzeArgsInFreeExpressionPosition.kt")
                public void testAnalyzeArgsInFreeExpressionPosition() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/nestedCalls/analyzeArgsInFreeExpressionPosition.kt");
                    doTest(fileName);
                }

                @TestMetadata("analyzeUnmappedArguments.kt")
                public void testAnalyzeUnmappedArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/nestedCalls/analyzeUnmappedArguments.kt");
                    doTest(fileName);
                }

                @TestMetadata("argumentsInParentheses.kt")
                public void testArgumentsInParentheses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/nestedCalls/argumentsInParentheses.kt");
                    doTest(fileName);
                }

                @TestMetadata("completeTypeInferenceForNestedInNoneApplicable.kt")
                public void testCompleteTypeInferenceForNestedInNoneApplicable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/nestedCalls/completeTypeInferenceForNestedInNoneApplicable.kt");
                    doTest(fileName);
                }

                @TestMetadata("completeUnmappedArguments.kt")
                public void testCompleteUnmappedArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/nestedCalls/completeUnmappedArguments.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt5971NestedSafeCall.kt")
                public void testKt5971NestedSafeCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/nestedCalls/kt5971NestedSafeCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt7597.kt")
                public void testKt7597() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/nestedCalls/kt7597.kt");
                    doTest(fileName);
                }

                @TestMetadata("twoTypeParameters.kt")
                public void testTwoTypeParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/nestedCalls/twoTypeParameters.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/noCandidates")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NoCandidates extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInNoCandidates() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/noCandidates"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt2787.kt")
                public void testKt2787() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/noCandidates/kt2787.kt");
                    doTest(fileName);
                }

                @TestMetadata("resolvedToClassifier.kt")
                public void testResolvedToClassifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/noCandidates/resolvedToClassifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("resolvedToClassifierWithReceiver.kt")
                public void testResolvedToClassifierWithReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/noCandidates/resolvedToClassifierWithReceiver.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class OverloadConflicts extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInOverloadConflicts() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/overloadConflicts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("allLambdas.kt")
                public void testAllLambdas() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/allLambdas.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionReceiverAndVarargs.kt")
                public void testExtensionReceiverAndVarargs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/extensionReceiverAndVarargs.kt");
                    doTest(fileName);
                }

                @TestMetadata("genericWithProjection.kt")
                public void testGenericWithProjection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/genericWithProjection.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt10472.kt")
                public void testKt10472() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/kt10472.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt10640.kt")
                public void testKt10640() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/kt10640.kt");
                    doTest(fileName);
                }

                @TestMetadata("numberOfDefaults.kt")
                public void testNumberOfDefaults() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/numberOfDefaults.kt");
                    doTest(fileName);
                }

                @TestMetadata("originalExamples.kt")
                public void testOriginalExamples() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/originalExamples.kt");
                    doTest(fileName);
                }

                @TestMetadata("varargWithMoreSpecificSignature.kt")
                public void testVarargWithMoreSpecificSignature() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/varargWithMoreSpecificSignature.kt");
                    doTest(fileName);
                }

                @TestMetadata("varargs.kt")
                public void testVarargs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/varargs.kt");
                    doTest(fileName);
                }

                @TestMetadata("varargsInDifferentPositions.kt")
                public void testVarargsInDifferentPositions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/varargsInDifferentPositions.kt");
                    doTest(fileName);
                }

                @TestMetadata("varargsMixed.kt")
                public void testVarargsMixed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/varargsMixed.kt");
                    doTest(fileName);
                }

                @TestMetadata("varargsWithRecursiveGenerics.kt")
                public void testVarargsWithRecursiveGenerics() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/varargsWithRecursiveGenerics.kt");
                    doTest(fileName);
                }

                @TestMetadata("withVariance.kt")
                public void testWithVariance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/overloadConflicts/withVariance.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/priority")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Priority extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInPriority() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/priority"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("invokeExtensionVsOther.kt")
                public void testInvokeExtensionVsOther() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/invokeExtensionVsOther.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeExtensionVsOther2.kt")
                public void testInvokeExtensionVsOther2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/invokeExtensionVsOther2.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt10219.kt")
                public void testKt10219() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/kt10219.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt10510.kt")
                public void testKt10510() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/kt10510.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt9810.kt")
                public void testKt9810() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/kt9810.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt9965.kt")
                public void testKt9965() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/kt9965.kt");
                    doTest(fileName);
                }

                @TestMetadata("localExtVsNonLocalExt.kt")
                public void testLocalExtVsNonLocalExt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/localExtVsNonLocalExt.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberVsLocalExt.kt")
                public void testMemberVsLocalExt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/memberVsLocalExt.kt");
                    doTest(fileName);
                }

                @TestMetadata("staticVsImplicitReceiverMember.kt")
                public void testStaticVsImplicitReceiverMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/staticVsImplicitReceiverMember.kt");
                    doTest(fileName);
                }

                @TestMetadata("synthesizedMembersVsExtension.kt")
                public void testSynthesizedMembersVsExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/synthesizedMembersVsExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("syntheticPropertiesVsExtensions.kt")
                public void testSyntheticPropertiesVsExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/syntheticPropertiesVsExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("syntheticPropertiesVsMembers.kt")
                public void testSyntheticPropertiesVsMembers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/priority/syntheticPropertiesVsMembers.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/resolve/specialConstructions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SpecialConstructions extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInSpecialConstructions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/resolve/specialConstructions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("constantsInIf.kt")
                public void testConstantsInIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/specialConstructions/constantsInIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("elvisAsCall.kt")
                public void testElvisAsCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/specialConstructions/elvisAsCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("exclExclAsCall.kt")
                public void testExclExclAsCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/specialConstructions/exclExclAsCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("inferenceForElvis.kt")
                public void testInferenceForElvis() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/specialConstructions/inferenceForElvis.kt");
                    doTest(fileName);
                }

                @TestMetadata("multipleSuperClasses.kt")
                public void testMultipleSuperClasses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/specialConstructions/multipleSuperClasses.kt");
                    doTest(fileName);
                }

                @TestMetadata("reportTypeMismatchDeeplyOnBranches.kt")
                public void testReportTypeMismatchDeeplyOnBranches() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/resolve/specialConstructions/reportTypeMismatchDeeplyOnBranches.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/scopes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Scopes extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInScopes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AmbiguityBetweenRootAndPackage.kt")
            public void testAmbiguityBetweenRootAndPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/AmbiguityBetweenRootAndPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("AmbiguousNonExtensions.kt")
            public void testAmbiguousNonExtensions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/AmbiguousNonExtensions.kt");
                doTest(fileName);
            }

            @TestMetadata("genericVsNested.kt")
            public void testGenericVsNested() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/genericVsNested.kt");
                doTest(fileName);
            }

            @TestMetadata("implicitReceiverMemberVsParameter.kt")
            public void testImplicitReceiverMemberVsParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/implicitReceiverMemberVsParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("initializerScopeOfExtensionProperty.kt")
            public void testInitializerScopeOfExtensionProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/initializerScopeOfExtensionProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("invisibleSetter.kt")
            public void testInvisibleSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/invisibleSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1078.kt")
            public void testKt1078() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1078.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1080.kt")
            public void testKt1080() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1080.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1244.kt")
            public void testKt1244() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1244.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1248.kt")
            public void testKt1248() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1248.kt");
                doTest(fileName);
            }

            @TestMetadata("kt151.kt")
            public void testKt151() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt151.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1579.kt")
            public void testKt1579() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1579.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1579_map_entry.kt")
            public void testKt1579_map_entry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1579_map_entry.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1580.kt")
            public void testKt1580() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1580.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1642.kt")
            public void testKt1642() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1642.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1738.kt")
            public void testKt1738() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1738.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1805.kt")
            public void testKt1805() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1805.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1806.kt")
            public void testKt1806() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1806.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1822.kt")
            public void testKt1822() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1822.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1942.kt")
            public void testKt1942() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt1942.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2262.kt")
            public void testKt2262() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt2262.kt");
                doTest(fileName);
            }

            @TestMetadata("kt250.617.10.kt")
            public void testKt250_617_10() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt250.617.10.kt");
                doTest(fileName);
            }

            @TestMetadata("kt323.kt")
            public void testKt323() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt323.kt");
                doTest(fileName);
            }

            @TestMetadata("kt37.kt")
            public void testKt37() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt37.kt");
                doTest(fileName);
            }

            @TestMetadata("kt587.kt")
            public void testKt587() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt587.kt");
                doTest(fileName);
            }

            @TestMetadata("kt900.kt")
            public void testKt900() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt900.kt");
                doTest(fileName);
            }

            @TestMetadata("kt900-1.kt")
            public void testKt900_1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt900-1.kt");
                doTest(fileName);
            }

            @TestMetadata("kt900-2.kt")
            public void testKt900_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt900-2.kt");
                doTest(fileName);
            }

            @TestMetadata("kt939.kt")
            public void testKt939() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt939.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9430.kt")
            public void testKt9430() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/kt9430.kt");
                doTest(fileName);
            }

            @TestMetadata("NoAmbiguityBetweenRootAndPackage.kt")
            public void testNoAmbiguityBetweenRootAndPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/NoAmbiguityBetweenRootAndPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("sameClassNameResolve.kt")
            public void testSameClassNameResolve() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/sameClassNameResolve.kt");
                doTest(fileName);
            }

            @TestMetadata("stopResolutionOnAmbiguity.kt")
            public void testStopResolutionOnAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/stopResolutionOnAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("visibility.kt")
            public void testVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/visibility.kt");
                doTest(fileName);
            }

            @TestMetadata("visibility2.kt")
            public void testVisibility2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/visibility2.kt");
                doTest(fileName);
            }

            @TestMetadata("visibility3.kt")
            public void testVisibility3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/visibility3.kt");
                doTest(fileName);
            }

            @TestMetadata("VisibilityInClassObject.kt")
            public void testVisibilityInClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/VisibilityInClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("VisibilityInheritModifier.kt")
            public void testVisibilityInheritModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/VisibilityInheritModifier.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/scopes/classHeader")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ClassHeader extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInClassHeader() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes/classHeader"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationOnClass.kt")
                public void testAnnotationOnClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/annotationOnClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("annotationOnConstructors.kt")
                public void testAnnotationOnConstructors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/annotationOnConstructors.kt");
                    doTest(fileName);
                }

                @TestMetadata("classGenericParameters.kt")
                public void testClassGenericParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/classGenericParameters.kt");
                    doTest(fileName);
                }

                @TestMetadata("classParents.kt")
                public void testClassParents() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/classParents.kt");
                    doTest(fileName);
                }

                @TestMetadata("companionObjectParents.kt")
                public void testCompanionObjectParents() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/companionObjectParents.kt");
                    doTest(fileName);
                }

                @TestMetadata("companionObjectSuperConstructorArguments.kt")
                public void testCompanionObjectSuperConstructorArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/companionObjectSuperConstructorArguments.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructors.kt")
                public void testConstructors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/constructors.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegation.kt")
                public void testDelegation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/delegation.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectParents.kt")
                public void testObjectParents() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/objectParents.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectSuperConstructorArguments.kt")
                public void testObjectSuperConstructorArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/objectSuperConstructorArguments.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleDelegation.kt")
                public void testSimpleDelegation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/simpleDelegation.kt");
                    doTest(fileName);
                }

                @TestMetadata("superConstructorArguments.kt")
                public void testSuperConstructorArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/superConstructorArguments.kt");
                    doTest(fileName);
                }

                @TestMetadata("superConstructorArgumentsInSecondaryConstructor.kt")
                public void testSuperConstructorArgumentsInSecondaryConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/classHeader/superConstructorArgumentsInSecondaryConstructor.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/scopes/inheritance")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inheritance extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInInheritance() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes/inheritance"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("companionObject.kt")
                public void testCompanionObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/companionObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("companionObjectAfterJava.kt")
                public void testCompanionObjectAfterJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/companionObjectAfterJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("companionObjectsOrder.kt")
                public void testCompanionObjectsOrder() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/companionObjectsOrder.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerClasses.kt")
                public void testInnerClasses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/innerClasses.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt3856.kt")
                public void testKt3856() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/kt3856.kt");
                    doTest(fileName);
                }

                @TestMetadata("methodsPriority.kt")
                public void testMethodsPriority() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/methodsPriority.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedClassesFromInterface.kt")
                public void testNestedClassesFromInterface() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/nestedClassesFromInterface.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedCompanionClass.kt")
                public void testNestedCompanionClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/nestedCompanionClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedCompanionClassVsNested.kt")
                public void testNestedCompanionClassVsNested() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/nestedCompanionClassVsNested.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedCompanionClassVsNestedJava.kt")
                public void testNestedCompanionClassVsNestedJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/nestedCompanionClassVsNestedJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedFromJava.kt")
                public void testNestedFromJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/nestedFromJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedFromJavaAfterKotlin.kt")
                public void testNestedFromJavaAfterKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/nestedFromJavaAfterKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedVsToplevelClass.kt")
                public void testNestedVsToplevelClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/nestedVsToplevelClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("severalCompanions.kt")
                public void testSeveralCompanions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/severalCompanions.kt");
                    doTest(fileName);
                }

                @TestMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Statics extends AbstractDiagnosticsTest {
                    public void testAllFilesPresentInStatics() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes/inheritance/statics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("hidePrivateByPublic.kt")
                    public void testHidePrivateByPublic() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/hidePrivateByPublic.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("jjkj.kt")
                    public void testJjkj() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/jjkj.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("kjk.kt")
                    public void testKjk() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/kjk.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("localVsStatic.kt")
                    public void testLocalVsStatic() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/localVsStatic.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("nameClash0.kt")
                    public void testNameClash0() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/nameClash0.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("nameClash1.kt")
                    public void testNameClash1() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/nameClash1.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("nameClash2.kt")
                    public void testNameClash2() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/nameClash2.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("oneInterfaceManyTimes.kt")
                    public void testOneInterfaceManyTimes() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/oneInterfaceManyTimes.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("overloadStatic.kt")
                    public void testOverloadStatic() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/overloadStatic.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("staticFunVsImport.kt")
                    public void testStaticFunVsImport() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticFunVsImport.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("staticPropertyVsImport.kt")
                    public void testStaticPropertyVsImport() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticPropertyVsImport.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("staticVsCompanion.kt")
                    public void testStaticVsCompanion() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticVsCompanion.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("staticVsMember.kt")
                    public void testStaticVsMember() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticVsMember.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("staticVsOuter.kt")
                    public void testStaticVsOuter() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticVsOuter.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("staticsFromjava.kt")
                    public void testStaticsFromjava() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticsFromjava.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("staticsFromjavaAfterKotlin.kt")
                    public void testStaticsFromjavaAfterKotlin() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/staticsFromjavaAfterKotlin.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class CompanionObject extends AbstractDiagnosticsTest {
                        @TestMetadata("accessToStaticMembersOfParentClass.kt")
                        public void testAccessToStaticMembersOfParentClass() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/accessToStaticMembersOfParentClass.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("accessToStaticMembersOfParentClassJKJ.kt")
                        public void testAccessToStaticMembersOfParentClassJKJ() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/accessToStaticMembersOfParentClassJKJ.kt");
                            doTest(fileName);
                        }

                        public void testAllFilesPresentInCompanionObject() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("inheritFromContainingClass.kt")
                        public void testInheritFromContainingClass() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/inheritFromContainingClass.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("inheritFromJava.kt")
                        public void testInheritFromJava() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/inheritFromJava.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("inheritFromJavaAfterKotlin.kt")
                        public void testInheritFromJavaAfterKotlin() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/inheritance/statics/companionObject/inheritFromJavaAfterKotlin.kt");
                            doTest(fileName);
                        }
                    }
                }
            }

            @TestMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ProtectedVisibility extends AbstractDiagnosticsTest {
                public void testAllFilesPresentInProtectedVisibility() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/scopes/protectedVisibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("complexCompanion.kt")
                public void testComplexCompanion() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/complexCompanion.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructors.kt")
                public void testConstructors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/constructors.kt");
                    doTest(fileName);
                }

                @TestMetadata("constructorsInner.kt")
                public void testConstructorsInner() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/constructorsInner.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerClassInJava.kt")
                public void testInnerClassInJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/innerClassInJava.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerProtectedClass.kt")
                public void testInnerProtectedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/innerProtectedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("javaInheritedInKotlin.kt")
                public void testJavaInheritedInKotlin() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/javaInheritedInKotlin.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt7971.kt")
                public void testKt7971() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/kt7971.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonSuperCallConstructor.kt")
                public void testNonSuperCallConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/nonSuperCallConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonSuperCallConstructorJavaDifferentPackage.kt")
                public void testNonSuperCallConstructorJavaDifferentPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/nonSuperCallConstructorJavaDifferentPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonSuperCallConstructorJavaSamePackage.kt")
                public void testNonSuperCallConstructorJavaSamePackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/nonSuperCallConstructorJavaSamePackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("protectedCallOnSubClass.kt")
                public void testProtectedCallOnSubClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/protectedCallOnSubClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("smartcastOnExtensionReceiver.kt")
                public void testSmartcastOnExtensionReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/smartcastOnExtensionReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("syntheticPropertyExtensions.kt")
                public void testSyntheticPropertyExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/syntheticPropertyExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("syntheticSAMExtensions.kt")
                public void testSyntheticSAMExtensions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/syntheticSAMExtensions.kt");
                    doTest(fileName);
                }

                @TestMetadata("unstableSmartCast.kt")
                public void testUnstableSmartCast() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/unstableSmartCast.kt");
                    doTest(fileName);
                }

                @TestMetadata("withSmartcast.kt")
                public void testWithSmartcast() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/scopes/protectedVisibility/withSmartcast.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/script")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Script extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInScript() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/script"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("varInScript.kt")
            public void testVarInScript() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/script/varInScript.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/sealed")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Sealed extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInSealed() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/sealed"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("DerivedTopLevel.kt")
            public void testDerivedTopLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/DerivedTopLevel.kt");
                doTest(fileName);
            }

            @TestMetadata("DoubleInner.kt")
            public void testDoubleInner() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/DoubleInner.kt");
                doTest(fileName);
            }

            @TestMetadata("ExhaustiveWhen.kt")
            public void testExhaustiveWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("ExhaustiveWhenDoubleInner.kt")
            public void testExhaustiveWhenDoubleInner() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenDoubleInner.kt");
                doTest(fileName);
            }

            @TestMetadata("ExhaustiveWhenMultipleInner.kt")
            public void testExhaustiveWhenMultipleInner() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenMultipleInner.kt");
                doTest(fileName);
            }

            @TestMetadata("ExhaustiveWhenNegated.kt")
            public void testExhaustiveWhenNegated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenNegated.kt");
                doTest(fileName);
            }

            @TestMetadata("ExhaustiveWhenNegatedTwice.kt")
            public void testExhaustiveWhenNegatedTwice() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenNegatedTwice.kt");
                doTest(fileName);
            }

            @TestMetadata("ExhaustiveWhenOnNestedSealed.kt")
            public void testExhaustiveWhenOnNestedSealed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenOnNestedSealed.kt");
                doTest(fileName);
            }

            @TestMetadata("ExhaustiveWhenOnNullable.kt")
            public void testExhaustiveWhenOnNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenOnNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("ExhaustiveWhenWithAdditionalMember.kt")
            public void testExhaustiveWhenWithAdditionalMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenWithAdditionalMember.kt");
                doTest(fileName);
            }

            @TestMetadata("ExhaustiveWhenWithElse.kt")
            public void testExhaustiveWhenWithElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/ExhaustiveWhenWithElse.kt");
                doTest(fileName);
            }

            @TestMetadata("Local.kt")
            public void testLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/Local.kt");
                doTest(fileName);
            }

            @TestMetadata("LocalSealed.kt")
            public void testLocalSealed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/LocalSealed.kt");
                doTest(fileName);
            }

            @TestMetadata("NestedSealed.kt")
            public void testNestedSealed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NestedSealed.kt");
                doTest(fileName);
            }

            @TestMetadata("NeverConstructed.kt")
            public void testNeverConstructed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NeverConstructed.kt");
                doTest(fileName);
            }

            @TestMetadata("NeverDerivedFromNested.kt")
            public void testNeverDerivedFromNested() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NeverDerivedFromNested.kt");
                doTest(fileName);
            }

            @TestMetadata("NeverEnum.kt")
            public void testNeverEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NeverEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("NeverFinal.kt")
            public void testNeverFinal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NeverFinal.kt");
                doTest(fileName);
            }

            @TestMetadata("NeverInterface.kt")
            public void testNeverInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NeverInterface.kt");
                doTest(fileName);
            }

            @TestMetadata("NeverObject.kt")
            public void testNeverObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NeverObject.kt");
                doTest(fileName);
            }

            @TestMetadata("NeverOpen.kt")
            public void testNeverOpen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NeverOpen.kt");
                doTest(fileName);
            }

            @TestMetadata("NonExhaustiveWhen.kt")
            public void testNonExhaustiveWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NonExhaustiveWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("NonExhaustiveWhenNegated.kt")
            public void testNonExhaustiveWhenNegated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NonExhaustiveWhenNegated.kt");
                doTest(fileName);
            }

            @TestMetadata("NonExhaustiveWhenWithAdditionalCase.kt")
            public void testNonExhaustiveWhenWithAdditionalCase() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NonExhaustiveWhenWithAdditionalCase.kt");
                doTest(fileName);
            }

            @TestMetadata("NonExhaustiveWhenWithAnyCase.kt")
            public void testNonExhaustiveWhenWithAnyCase() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NonExhaustiveWhenWithAnyCase.kt");
                doTest(fileName);
            }

            @TestMetadata("NonPrivateConstructor.kt")
            public void testNonPrivateConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NonPrivateConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("NotFinal.kt")
            public void testNotFinal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/NotFinal.kt");
                doTest(fileName);
            }

            @TestMetadata("OperationWhen.kt")
            public void testOperationWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/OperationWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("RedundantAbstract.kt")
            public void testRedundantAbstract() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/RedundantAbstract.kt");
                doTest(fileName);
            }

            @TestMetadata("TreeWhen.kt")
            public void testTreeWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/TreeWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("TreeWhenFunctional.kt")
            public void testTreeWhenFunctional() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/TreeWhenFunctional.kt");
                doTest(fileName);
            }

            @TestMetadata("TreeWhenFunctionalNoIs.kt")
            public void testTreeWhenFunctionalNoIs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/TreeWhenFunctionalNoIs.kt");
                doTest(fileName);
            }

            @TestMetadata("WhenOnEmptySealed.kt")
            public void testWhenOnEmptySealed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/WhenOnEmptySealed.kt");
                doTest(fileName);
            }

            @TestMetadata("WithInterface.kt")
            public void testWithInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/sealed/WithInterface.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/secondaryConstructors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SecondaryConstructors extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInSecondaryConstructors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/secondaryConstructors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("argumentsResolveInBodyAndDelegationCall.kt")
            public void testArgumentsResolveInBodyAndDelegationCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/argumentsResolveInBodyAndDelegationCall.kt");
                doTest(fileName);
            }

            @TestMetadata("classInitializersWithoutPrimary.kt")
            public void testClassInitializersWithoutPrimary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/classInitializersWithoutPrimary.kt");
                doTest(fileName);
            }

            @TestMetadata("companionObjectScope.kt")
            public void testCompanionObjectScope() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/companionObjectScope.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorCallType.kt")
            public void testConstructorCallType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/constructorCallType.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorInObject.kt")
            public void testConstructorInObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/constructorInObject.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorInTrait.kt")
            public void testConstructorInTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/constructorInTrait.kt");
                doTest(fileName);
            }

            @TestMetadata("ctrsAnnotationResolve.kt")
            public void testCtrsAnnotationResolve() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/ctrsAnnotationResolve.kt");
                doTest(fileName);
            }

            @TestMetadata("cyclicDelegationCalls.kt")
            public void testCyclicDelegationCalls() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/cyclicDelegationCalls.kt");
                doTest(fileName);
            }

            @TestMetadata("dataClasses.kt")
            public void testDataClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/dataClasses.kt");
                doTest(fileName);
            }

            @TestMetadata("dataFlowInDelegationCall.kt")
            public void testDataFlowInDelegationCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/dataFlowInDelegationCall.kt");
                doTest(fileName);
            }

            @TestMetadata("delegationByWithoutPrimary.kt")
            public void testDelegationByWithoutPrimary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/delegationByWithoutPrimary.kt");
                doTest(fileName);
            }

            @TestMetadata("enums.kt")
            public void testEnums() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/enums.kt");
                doTest(fileName);
            }

            @TestMetadata("errorsOnEmptyDelegationCall.kt")
            public void testErrorsOnEmptyDelegationCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/errorsOnEmptyDelegationCall.kt");
                doTest(fileName);
            }

            @TestMetadata("expectedPrimaryConstructorCall.kt")
            public void testExpectedPrimaryConstructorCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/expectedPrimaryConstructorCall.kt");
                doTest(fileName);
            }

            @TestMetadata("generics.kt")
            public void testGenerics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/generics.kt");
                doTest(fileName);
            }

            @TestMetadata("generics2.kt")
            public void testGenerics2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/generics2.kt");
                doTest(fileName);
            }

            @TestMetadata("generics3.kt")
            public void testGenerics3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/generics3.kt");
                doTest(fileName);
            }

            @TestMetadata("headerSupertypeInitialization.kt")
            public void testHeaderSupertypeInitialization() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerSupertypeInitialization.kt");
                doTest(fileName);
            }

            @TestMetadata("implicitSuperCallErrorsIfPrimary.kt")
            public void testImplicitSuperCallErrorsIfPrimary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/implicitSuperCallErrorsIfPrimary.kt");
                doTest(fileName);
            }

            @TestMetadata("initializationFromOtherInstance.kt")
            public void testInitializationFromOtherInstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/initializationFromOtherInstance.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6992.kt")
            public void testKt6992() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/kt6992.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6993.kt")
            public void testKt6993() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/kt6993.kt");
                doTest(fileName);
            }

            @TestMetadata("kt6994.kt")
            public void testKt6994() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/kt6994.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaInDelegation.kt")
            public void testLambdaInDelegation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/lambdaInDelegation.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedExtendsInner.kt")
            public void testNestedExtendsInner() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/nestedExtendsInner.kt");
                doTest(fileName);
            }

            @TestMetadata("noDefaultIfEmptySecondary.kt")
            public void testNoDefaultIfEmptySecondary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/noDefaultIfEmptySecondary.kt");
                doTest(fileName);
            }

            @TestMetadata("noPrimaryConstructor.kt")
            public void testNoPrimaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/noPrimaryConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("noSupertypeInitWithSecondaryConstructors.kt")
            public void testNoSupertypeInitWithSecondaryConstructors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/noSupertypeInitWithSecondaryConstructors.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyInitializationWithPrimary.kt")
            public void testPropertyInitializationWithPrimary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/propertyInitializationWithPrimary.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyInitializationWithoutPrimary.kt")
            public void testPropertyInitializationWithoutPrimary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/propertyInitializationWithoutPrimary.kt");
                doTest(fileName);
            }

            @TestMetadata("redeclarations.kt")
            public void testRedeclarations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/redeclarations.kt");
                doTest(fileName);
            }

            @TestMetadata("redeclarationsOfConstructorsIgnored.kt")
            public void testRedeclarationsOfConstructorsIgnored() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/redeclarationsOfConstructorsIgnored.kt");
                doTest(fileName);
            }

            @TestMetadata("reportResolutionErrorOnImplicitOnce.kt")
            public void testReportResolutionErrorOnImplicitOnce() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/reportResolutionErrorOnImplicitOnce.kt");
                doTest(fileName);
            }

            @TestMetadata("resolvePropertyInitializerWithoutPrimary.kt")
            public void testResolvePropertyInitializerWithoutPrimary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/resolvePropertyInitializerWithoutPrimary.kt");
                doTest(fileName);
            }

            @TestMetadata("return.kt")
            public void testReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/return.kt");
                doTest(fileName);
            }

            @TestMetadata("superAnyNonEmpty.kt")
            public void testSuperAnyNonEmpty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/superAnyNonEmpty.kt");
                doTest(fileName);
            }

            @TestMetadata("superSecondaryNonExisting.kt")
            public void testSuperSecondaryNonExisting() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/superSecondaryNonExisting.kt");
                doTest(fileName);
            }

            @TestMetadata("thisNonExisting.kt")
            public void testThisNonExisting() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/thisNonExisting.kt");
                doTest(fileName);
            }

            @TestMetadata("unreachableCode.kt")
            public void testUnreachableCode() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/unreachableCode.kt");
                doTest(fileName);
            }

            @TestMetadata("useOfPropertiesWithPrimary.kt")
            public void testUseOfPropertiesWithPrimary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/useOfPropertiesWithPrimary.kt");
                doTest(fileName);
            }

            @TestMetadata("useOfPropertiesWithoutPrimary.kt")
            public void testUseOfPropertiesWithoutPrimary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/useOfPropertiesWithoutPrimary.kt");
                doTest(fileName);
            }

            @TestMetadata("valOrValAndModifiersInCtr.kt")
            public void testValOrValAndModifiersInCtr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/valOrValAndModifiersInCtr.kt");
                doTest(fileName);
            }

            @TestMetadata("varargsInDelegationCallToPrimary.kt")
            public void testVarargsInDelegationCallToPrimary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/varargsInDelegationCallToPrimary.kt");
                doTest(fileName);
            }

            @TestMetadata("varargsInDelegationCallToSecondary.kt")
            public void testVarargsInDelegationCallToSecondary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/varargsInDelegationCallToSecondary.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class HeaderCallChecker extends AbstractDiagnosticsTest {
                @TestMetadata("accessBaseGenericFromInnerExtendingSameBase.kt")
                public void testAccessBaseGenericFromInnerExtendingSameBase() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/accessBaseGenericFromInnerExtendingSameBase.kt");
                    doTest(fileName);
                }

                @TestMetadata("accessBaseGenericFromInnerExtendingSameBase2.kt")
                public void testAccessBaseGenericFromInnerExtendingSameBase2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/accessBaseGenericFromInnerExtendingSameBase2.kt");
                    doTest(fileName);
                }

                @TestMetadata("accessBaseWithSameExtension.kt")
                public void testAccessBaseWithSameExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/accessBaseWithSameExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("accessGenericBaseWithSameExtension.kt")
                public void testAccessGenericBaseWithSameExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/accessGenericBaseWithSameExtension.kt");
                    doTest(fileName);
                }

                public void testAllFilesPresentInHeaderCallChecker() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerInstanceCreation.kt")
                public void testInnerInstanceCreation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/innerInstanceCreation.kt");
                    doTest(fileName);
                }

                @TestMetadata("lambdaAsArgument.kt")
                public void testLambdaAsArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/lambdaAsArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberFunAccess.kt")
                public void testMemberFunAccess() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/memberFunAccess.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectLiteralAsArgument.kt")
                public void testObjectLiteralAsArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/objectLiteralAsArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectLiteralAsDefaultValueParameter.kt")
                public void testObjectLiteralAsDefaultValueParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/objectLiteralAsDefaultValueParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("operatorCall.kt")
                public void testOperatorCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/operatorCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("passingInstance.kt")
                public void testPassingInstance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/passingInstance.kt");
                    doTest(fileName);
                }

                @TestMetadata("propertyAccess.kt")
                public void testPropertyAccess() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/propertyAccess.kt");
                    doTest(fileName);
                }

                @TestMetadata("propertyAccessUnitialized.kt")
                public void testPropertyAccessUnitialized() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/propertyAccessUnitialized.kt");
                    doTest(fileName);
                }

                @TestMetadata("superFunAccess.kt")
                public void testSuperFunAccess() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/superFunAccess.kt");
                    doTest(fileName);
                }

                @TestMetadata("superFunAccessOverriden.kt")
                public void testSuperFunAccessOverriden() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/superFunAccessOverriden.kt");
                    doTest(fileName);
                }

                @TestMetadata("superPropertyAccess.kt")
                public void testSuperPropertyAccess() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/superPropertyAccess.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisAsExtensionReceiver.kt")
                public void testThisAsExtensionReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/thisAsExtensionReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("usingOuterInstance.kt")
                public void testUsingOuterInstance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/usingOuterInstance.kt");
                    doTest(fileName);
                }

                @TestMetadata("usingOuterProperty.kt")
                public void testUsingOuterProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/secondaryConstructors/headerCallChecker/usingOuterProperty.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/senselessComparison")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SenselessComparison extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInSenselessComparison() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/senselessComparison"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("parenthesized.kt")
            public void testParenthesized() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/senselessComparison/parenthesized.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/shadowing")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Shadowing extends AbstractDiagnosticsTest {
            public void testAllFilesPresentInShadowing() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/shadowing"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ShadowMultiDeclarationWithFunParameter.kt")
            public void testShadowMultiDeclarationWithFunParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/shadowing/ShadowMultiDeclarationWithFunParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("ShadowParameterInFunctionBody.kt")
            public void testShadowParameterInFunctionBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/shadowing/ShadowParameterInFunctionBody.kt");
                doTest(fileName);
            }

            @TestMetadata("ShadowParameterInNestedBlockInFor.kt")
            public void testShadowParameterInNestedBlockInFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/shadowing/ShadowParameterInNestedBlockInFor.kt");
                doTest(fileName);
            }

            @TestMetadata("ShadowPropertyInClosure.kt")
            public void testShadowPropertyInClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/shadowing/ShadowPropertyInClosure.kt");
                doTest(fileName);
            }

            @TestMetadata("ShadowPropertyInFor.kt")
            public void testShadowPropertyInFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/shadowing/ShadowPropertyInFor.kt");
                doTest(fileName);
            }

            @TestMetadata("ShadowPropertyInFunction.kt")
            public void testShadowPropertyInFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/shadowing/ShadowPropertyInFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("ShadowVariableInFor.kt")
            public void testShadowVariableInFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/shadowing/ShadowVariableInFor.kt");
                doTest(fileName);
            }

            @TestMetadata("ShadowVariableInNestedBlock.kt")
            public void testShadowVariableInNestedBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/shadowing/ShadowVariableInNestedBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("ShadowVariableInNestedClosure.kt")
            public void testShadowVariableInNestedClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/shadowing/ShadowVariableInNestedClosure.kt");
                doTest(fileName);
            }

            @TestMetadata("ShadowVariableInNestedClosureParam.kt")
            public void testShadowVariableInNestedClosureParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/shadowing/ShadowVariableInNestedClosureParam.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/tests/smartCasts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SmartCasts extends AbstractDiagnosticsTest {
            @TestMetadata("afterBinaryExpr.kt")
            public void testAfterBinaryExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/afterBinaryExpr.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInSmartCasts() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/tests/smartCasts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("alwaysNull.kt")
            public void testAlwaysNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/alwaysNull.kt");
                doTest(fileName);
            }

            @TestMetadata("alwaysNullWithJava.kt")
            public void testAlwaysNullWithJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/alwaysNullWithJava.kt");
                doTest(fileName);
            }

            @TestMetadata("classObjectMember.kt")
            public void testClassObjectMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/classObjectMember.kt");
                doTest(fileName);
            }

            @TestMetadata("combineWithNoSelectorInfo.kt")
            public void testCombineWithNoSelectorInfo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/combineWithNoSelectorInfo.kt");
                doTest(fileName);
            }

            @TestMetadata("comparisonUnderAnd.kt")
            public void testComparisonUnderAnd() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/comparisonUnderAnd.kt");
                doTest(fileName);
            }

            @TestMetadata("complexComparison.kt")
            public void testComplexComparison() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/complexComparison.kt");
                doTest(fileName);
            }

            @TestMetadata("complexConditionsWithExcl.kt")
            public void testComplexConditionsWithExcl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/complexConditionsWithExcl.kt");
                doTest(fileName);
            }

            @TestMetadata("dataFlowInfoForArguments.kt")
            public void testDataFlowInfoForArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/dataFlowInfoForArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("doubleLambdaArgument.kt")
            public void testDoubleLambdaArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/doubleLambdaArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisExclExcl.kt")
            public void testElvisExclExcl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/elvisExclExcl.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisExclExclMerge.kt")
            public void testElvisExclExclMerge() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/elvisExclExclMerge.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisExclExclPlatform.kt")
            public void testElvisExclExclPlatform() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/elvisExclExclPlatform.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisExprNotNull.kt")
            public void testElvisExprNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/elvisExprNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisNothingRHS.kt")
            public void testElvisNothingRHS() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/elvisNothingRHS.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisRHS.kt")
            public void testElvisRHS() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/elvisRHS.kt");
                doTest(fileName);
            }

            @TestMetadata("exclUnderAnd.kt")
            public void testExclUnderAnd() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/exclUnderAnd.kt");
                doTest(fileName);
            }

            @TestMetadata("explicitDefaultGetter.kt")
            public void testExplicitDefaultGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/explicitDefaultGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionSafeCall.kt")
            public void testExtensionSafeCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/extensionSafeCall.kt");
                doTest(fileName);
            }

            @TestMetadata("fakeSmartCastOnEquality.kt")
            public void testFakeSmartCastOnEquality() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/fakeSmartCastOnEquality.kt");
                doTest(fileName);
            }

            @TestMetadata("falseReceiverSmartCast.kt")
            public void testFalseReceiverSmartCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/falseReceiverSmartCast.kt");
                doTest(fileName);
            }

            @TestMetadata("falseUnnecessaryCall.kt")
            public void testFalseUnnecessaryCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/falseUnnecessaryCall.kt");
                doTest(fileName);
            }

            @TestMetadata("fieldExclExcl.kt")
            public void testFieldExclExcl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/fieldExclExcl.kt");
                doTest(fileName);
            }

            @TestMetadata("fieldInGetter.kt")
            public void testFieldInGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/fieldInGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("fieldPlus.kt")
            public void testFieldPlus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/fieldPlus.kt");
                doTest(fileName);
            }

            @TestMetadata("genericIntersection.kt")
            public void testGenericIntersection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/genericIntersection.kt");
                doTest(fileName);
            }

            @TestMetadata("genericSet.kt")
            public void testGenericSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/genericSet.kt");
                doTest(fileName);
            }

            @TestMetadata("ifCascadeExprNotNull.kt")
            public void testIfCascadeExprNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/ifCascadeExprNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("ifExprInConditionNonNull.kt")
            public void testIfExprInConditionNonNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/ifExprInConditionNonNull.kt");
                doTest(fileName);
            }

            @TestMetadata("ifExprInWhenSubjectNonNull.kt")
            public void testIfExprInWhenSubjectNonNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/ifExprInWhenSubjectNonNull.kt");
                doTest(fileName);
            }

            @TestMetadata("ifExprNonNull.kt")
            public void testIfExprNonNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/ifExprNonNull.kt");
                doTest(fileName);
            }

            @TestMetadata("ifWhenExprNonNull.kt")
            public void testIfWhenExprNonNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/ifWhenExprNonNull.kt");
                doTest(fileName);
            }

            @TestMetadata("implicitReceiver.kt")
            public void testImplicitReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/implicitReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("implicitToGrandSon.kt")
            public void testImplicitToGrandSon() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/implicitToGrandSon.kt");
                doTest(fileName);
            }

            @TestMetadata("incDecToNull.kt")
            public void testIncDecToNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/incDecToNull.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10232.kt")
            public void testKt10232() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/kt10232.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10444.kt")
            public void testKt10444() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/kt10444.kt");
                doTest(fileName);
            }

            @TestMetadata("kt10483.kt")
            public void testKt10483() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/kt10483.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1461.kt")
            public void testKt1461() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/kt1461.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2422.kt")
            public void testKt2422() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/kt2422.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2865.kt")
            public void testKt2865() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/kt2865.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3224.kt")
            public void testKt3224() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/kt3224.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3244.kt")
            public void testKt3244() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/kt3244.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3572.kt")
            public void testKt3572() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/tests/smartCasts/kt3572.kt");
                doTest(fileName);
            }

            @TestMetadata("kt3711.kt")
            public void testKt3711() throws Exception {
                String