/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.checkers;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/diagnostics/testsWithStdLib")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class DiagnosticsTestWithStdLibGenerated extends AbstractDiagnosticsTestWithStdLib {
    @TestMetadata("addAllProjection.kt")
    public void testAddAllProjection() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/addAllProjection.kt");
        doTest(fileName);
    }

    public void testAllFilesPresentInTestsWithStdLib() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("ArrayOfNothing.kt")
    public void testArrayOfNothing() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/ArrayOfNothing.kt");
        doTest(fileName);
    }

    @TestMetadata("CallCompanionProtectedNonStatic.kt")
    public void testCallCompanionProtectedNonStatic() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/CallCompanionProtectedNonStatic.kt");
        doTest(fileName);
    }

    @TestMetadata("CallToMainRedeclaredInMultiFile.kt")
    public void testCallToMainRedeclaredInMultiFile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/CallToMainRedeclaredInMultiFile.kt");
        doTest(fileName);
    }

    @TestMetadata("commonCollections.kt")
    public void testCommonCollections() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/commonCollections.kt");
        doTest(fileName);
    }

    @TestMetadata("elvisOnJavaList.kt")
    public void testElvisOnJavaList() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/elvisOnJavaList.kt");
        doTest(fileName);
    }

    @TestMetadata("elvisOnUnitInLet.kt")
    public void testElvisOnUnitInLet() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/elvisOnUnitInLet.kt");
        doTest(fileName);
    }

    @TestMetadata("ifElseJavaList.kt")
    public void testIfElseJavaList() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/ifElseJavaList.kt");
        doTest(fileName);
    }

    @TestMetadata("implicitCastToAny.kt")
    public void testImplicitCastToAny() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/implicitCastToAny.kt");
        doTest(fileName);
    }

    @TestMetadata("InaccessibleInternalClass.kt")
    public void testInaccessibleInternalClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/InaccessibleInternalClass.kt");
        doTest(fileName);
    }

    @TestMetadata("instar.kt")
    public void testInstar() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/instar.kt");
        doTest(fileName);
    }

    @TestMetadata("javaClassOnCompanion.kt")
    public void testJavaClassOnCompanion() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/javaClassOnCompanion.kt");
        doTest(fileName);
    }

    @TestMetadata("kt9078.kt")
    public void testKt9078() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/kt9078.kt");
        doTest(fileName);
    }

    @TestMetadata("kt9985.kt")
    public void testKt9985() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/kt9985.kt");
        doTest(fileName);
    }

    @TestMetadata("outstar.kt")
    public void testOutstar() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/outstar.kt");
        doTest(fileName);
    }

    @TestMetadata("overrideWithFunctionalType.kt")
    public void testOverrideWithFunctionalType() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/overrideWithFunctionalType.kt");
        doTest(fileName);
    }

    @TestMetadata("PropertyDelegateWithPrivateSet.kt")
    public void testPropertyDelegateWithPrivateSet() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/PropertyDelegateWithPrivateSet.kt");
        doTest(fileName);
    }

    @TestMetadata("pureReifiable.kt")
    public void testPureReifiable() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/pureReifiable.kt");
        doTest(fileName);
    }

    @TestMetadata("pureReifiableArrayOperations.kt")
    public void testPureReifiableArrayOperations() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/pureReifiableArrayOperations.kt");
        doTest(fileName);
    }

    @TestMetadata("RedeclarationMainInMultiFileClass.kt")
    public void testRedeclarationMainInMultiFileClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/RedeclarationMainInMultiFileClass.kt");
        doTest(fileName);
    }

    @TestMetadata("RenameOnImportHidesDefaultImport.kt")
    public void testRenameOnImportHidesDefaultImport() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/RenameOnImportHidesDefaultImport.kt");
        doTest(fileName);
    }

    @TestMetadata("shadowingInDestructuring.kt")
    public void testShadowingInDestructuring() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/shadowingInDestructuring.kt");
        doTest(fileName);
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Annotations extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInAnnotations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ClassObjectAnnotatedWithItsKClass.kt")
        public void testClassObjectAnnotatedWithItsKClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/ClassObjectAnnotatedWithItsKClass.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultValueMustBeConstant.kt")
        public void testDefaultValueMustBeConstant() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/defaultValueMustBeConstant.kt");
            doTest(fileName);
        }

        @TestMetadata("JvmSyntheticOnDelegate.kt")
        public void testJvmSyntheticOnDelegate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/JvmSyntheticOnDelegate.kt");
            doTest(fileName);
        }

        @TestMetadata("qualifiedCallValue.kt")
        public void testQualifiedCallValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/qualifiedCallValue.kt");
            doTest(fileName);
        }

        @TestMetadata("strictfpOnClass.kt")
        public void testStrictfpOnClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/strictfpOnClass.kt");
            doTest(fileName);
        }

        @TestMetadata("Synchronized.kt")
        public void testSynchronized() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/Synchronized.kt");
            doTest(fileName);
        }

        @TestMetadata("targetuse.kt")
        public void testTargetuse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/targetuse.kt");
            doTest(fileName);
        }

        @TestMetadata("TransientOnDelegate.kt")
        public void testTransientOnDelegate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/TransientOnDelegate.kt");
            doTest(fileName);
        }

        @TestMetadata("Volatile.kt")
        public void testVolatile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/Volatile.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationApplicability")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotationApplicability extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInAnnotationApplicability() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationApplicability"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotationsOnUseSiteTargets.kt")
            public void testAnnotationsOnUseSiteTargets() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationApplicability/annotationsOnUseSiteTargets.kt");
                doTest(fileName);
            }

            @TestMetadata("illegalPlatformName.kt")
            public void testIllegalPlatformName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationApplicability/illegalPlatformName.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmName.kt")
            public void testJvmName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationApplicability/jvmName.kt");
                doTest(fileName);
            }

            @TestMetadata("multifileClassPart.kt")
            public void testMultifileClassPart() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationApplicability/multifileClassPart.kt");
                doTest(fileName);
            }

            @TestMetadata("multifileClassPartWithJavaAnnotation.kt")
            public void testMultifileClassPartWithJavaAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationApplicability/multifileClassPartWithJavaAnnotation.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameterMustBeConstant")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotationParameterMustBeConstant extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInAnnotationParameterMustBeConstant() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameterMustBeConstant"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameterMustBeConstant/array.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameterMustBeConstant/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("useOfNonConstVal.kt")
            public void testUseOfNonConstVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameterMustBeConstant/useOfNonConstVal.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameterMustBeConstant/vararg.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameters")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotationParameters extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInAnnotationParameters() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kt10136.kt")
            public void testKt10136() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameters/kt10136.kt");
                doTest(fileName);
            }

            @TestMetadata("orderWithValue.kt")
            public void testOrderWithValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameters/orderWithValue.kt");
                doTest(fileName);
            }

            @TestMetadata("orderWithoutValue.kt")
            public void testOrderWithoutValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameters/orderWithoutValue.kt");
                doTest(fileName);
            }

            @TestMetadata("valueArray.kt")
            public void testValueArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameters/valueArray.kt");
                doTest(fileName);
            }

            @TestMetadata("valueArrayAndOtherDefault.kt")
            public void testValueArrayAndOtherDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameters/valueArrayAndOtherDefault.kt");
                doTest(fileName);
            }

            @TestMetadata("valueArrayOnly.kt")
            public void testValueArrayOnly() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameters/valueArrayOnly.kt");
                doTest(fileName);
            }

            @TestMetadata("valueArrayWithDefault.kt")
            public void testValueArrayWithDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationParameters/valueArrayWithDefault.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationWithVarargParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotationWithVarargParameter extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInAnnotationWithVarargParameter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationWithVarargParameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaAnnotationWithVarargArgument.kt")
            public void testJavaAnnotationWithVarargArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationWithVarargParameter/javaAnnotationWithVarargArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinAnnotationWithVarargArgument.kt")
            public void testKotlinAnnotationWithVarargArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/annotationWithVarargParameter/kotlinAnnotationWithVarargArgument.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaAnnotationsWithKClassParameter extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInJavaAnnotationsWithKClassParameter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotationAsArgument.kt")
            public void testAnnotationAsArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/annotationAsArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("arg.kt")
            public void testArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/arg.kt");
                doTest(fileName);
            }

            @TestMetadata("argAndOtherDefault.kt")
            public void testArgAndOtherDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/argAndOtherDefault.kt");
                doTest(fileName);
            }

            @TestMetadata("argArray.kt")
            public void testArgArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/argArray.kt");
                doTest(fileName);
            }

            @TestMetadata("argWithDefault.kt")
            public void testArgWithDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/argWithDefault.kt");
                doTest(fileName);
            }

            @TestMetadata("argWithDefaultAndOther.kt")
            public void testArgWithDefaultAndOther() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/argWithDefaultAndOther.kt");
                doTest(fileName);
            }

            @TestMetadata("twoArgs.kt")
            public void testTwoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/twoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("value.kt")
            public void testValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/value.kt");
                doTest(fileName);
            }

            @TestMetadata("valueAndOtherDefault.kt")
            public void testValueAndOtherDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/valueAndOtherDefault.kt");
                doTest(fileName);
            }

            @TestMetadata("valueArray.kt")
            public void testValueArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/valueArray.kt");
                doTest(fileName);
            }

            @TestMetadata("valueWithDefault.kt")
            public void testValueWithDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/valueWithDefault.kt");
                doTest(fileName);
            }

            @TestMetadata("valueWithDefaultAndOther.kt")
            public void testValueWithDefaultAndOther() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/javaAnnotationsWithKClassParameter/valueWithDefaultAndOther.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmField")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JvmField extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInJvmField() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmField"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("clashWithCompanionObjectField.kt")
            public void testClashWithCompanionObjectField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmField/clashWithCompanionObjectField.kt");
                doTest(fileName);
            }

            @TestMetadata("inMultiFileFacade.kt")
            public void testInMultiFileFacade() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmField/inMultiFileFacade.kt");
                doTest(fileName);
            }

            @TestMetadata("inSingleFileFacade.kt")
            public void testInSingleFileFacade() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmField/inSingleFileFacade.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmFieldApplicability.kt")
            public void testJvmFieldApplicability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmField/jvmFieldApplicability.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmOverloads")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JvmOverloads extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInJvmOverloads() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmOverloads"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("JvmOverloadWithNoDefaults.kt")
            public void testJvmOverloadWithNoDefaults() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmOverloads/JvmOverloadWithNoDefaults.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmOverloadsOnAbstractMethods.kt")
            public void testJvmOverloadsOnAbstractMethods() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmOverloads/jvmOverloadsOnAbstractMethods.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmOverloadsOnPrivate.kt")
            public void testJvmOverloadsOnPrivate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmOverloads/jvmOverloadsOnPrivate.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmStatic")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JvmStatic extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInJvmStatic() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmStatic"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("constOrJvmFieldProperty.kt")
            public void testConstOrJvmFieldProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmStatic/constOrJvmFieldProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorProperty.kt")
            public void testConstructorProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmStatic/constructorProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("constructors.kt")
            public void testConstructors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmStatic/constructors.kt");
                doTest(fileName);
            }

            @TestMetadata("finalAndAbstract.kt")
            public void testFinalAndAbstract() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmStatic/finalAndAbstract.kt");
                doTest(fileName);
            }

            @TestMetadata("functions.kt")
            public void testFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmStatic/functions.kt");
                doTest(fileName);
            }

            @TestMetadata("localFun.kt")
            public void testLocalFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmStatic/localFun.kt");
                doTest(fileName);
            }

            @TestMetadata("property.kt")
            public void testProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/jvmStatic/property.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/kClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KClass extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInKClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations/kClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kClassArrayInAnnotationsInVariance.kt")
            public void testKClassArrayInAnnotationsInVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/kClass/kClassArrayInAnnotationsInVariance.kt");
                doTest(fileName);
            }

            @TestMetadata("kClassArrayInAnnotationsOutVariance.kt")
            public void testKClassArrayInAnnotationsOutVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/kClass/kClassArrayInAnnotationsOutVariance.kt");
                doTest(fileName);
            }

            @TestMetadata("kClassInAnnotation.kt")
            public void testKClassInAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/kClass/kClassInAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("kClassInAnnotationsInVariance.kt")
            public void testKClassInAnnotationsInVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/kClass/kClassInAnnotationsInVariance.kt");
                doTest(fileName);
            }

            @TestMetadata("kClassInAnnotationsOutVariance.kt")
            public void testKClassInAnnotationsOutVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/kClass/kClassInAnnotationsOutVariance.kt");
                doTest(fileName);
            }

            @TestMetadata("kClassInvariantTP.kt")
            public void testKClassInvariantTP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/kClass/kClassInvariantTP.kt");
                doTest(fileName);
            }

            @TestMetadata("kClassOutArrayInAnnotationsOutVariance.kt")
            public void testKClassOutArrayInAnnotationsOutVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/kClass/kClassOutArrayInAnnotationsOutVariance.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/prohibitPositionedArgument")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProhibitPositionedArgument extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInProhibitPositionedArgument() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/annotations/prohibitPositionedArgument"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kotlinAnnotation.kt")
            public void testKotlinAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/prohibitPositionedArgument/kotlinAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("tooManyArgs.kt")
            public void testTooManyArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/prohibitPositionedArgument/tooManyArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatch.kt")
            public void testTypeMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/prohibitPositionedArgument/typeMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("withValue.kt")
            public void testWithValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/prohibitPositionedArgument/withValue.kt");
                doTest(fileName);
            }

            @TestMetadata("withoutValue.kt")
            public void testWithoutValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/annotations/prohibitPositionedArgument/withoutValue.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/builtins")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Builtins extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInBuiltins() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/builtins"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arraysAreCloneable.kt")
        public void testArraysAreCloneable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/builtins/arraysAreCloneable.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/cast")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Cast extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInCast() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/cast"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AsInsideIn.kt")
        public void testAsInsideIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/cast/AsInsideIn.kt");
            doTest(fileName);
        }

        @TestMetadata("IsArray.kt")
        public void testIsArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/cast/IsArray.kt");
            doTest(fileName);
        }

        @TestMetadata("IsReified.kt")
        public void testIsReified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/cast/IsReified.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DuplicateJvmSignature extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInDuplicateJvmSignature() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("delegatedProperty.kt")
        public void testDelegatedProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/delegatedProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("jvmNames.kt")
        public void testJvmNames() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/jvmNames.kt");
            doTest(fileName);
        }

        @TestMetadata("jvmNamesDuplicate.kt")
        public void testJvmNamesDuplicate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/jvmNamesDuplicate.kt");
            doTest(fileName);
        }

        @TestMetadata("jvmOverloads.kt")
        public void testJvmOverloads() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/jvmOverloads.kt");
            doTest(fileName);
        }

        @TestMetadata("jvmStaticInClassObject.kt")
        public void testJvmStaticInClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/jvmStaticInClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("jvmStaticInObject.kt")
        public void testJvmStaticInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/jvmStaticInObject.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/statics")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Statics extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInStatics() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/statics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("jjk.kt")
            public void testJjk() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/statics/jjk.kt");
                doTest(fileName);
            }

            @TestMetadata("jk.kt")
            public void testJk() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/statics/jk.kt");
                doTest(fileName);
            }

            @TestMetadata("jkjk.kt")
            public void testJkjk() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/statics/jkjk.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinMembersVsJavaNonVisibleStatics.kt")
            public void testKotlinMembersVsJavaNonVisibleStatics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/duplicateJvmSignature/statics/kotlinMembersVsJavaNonVisibleStatics.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/functionLiterals")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FunctionLiterals extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInFunctionLiterals() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/functionLiterals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("pseudocodeMemoryOverhead.kt")
        public void testPseudocodeMemoryOverhead() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/functionLiterals/pseudocodeMemoryOverhead.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/inference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inference extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInInference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/inference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayConstructor.kt")
        public void testArrayConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/arrayConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11266.kt")
        public void testKt11266() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/kt11266.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1558.kt")
        public void testKt1558() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/kt1558.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3458.kt")
        public void testKt3458() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/kt3458.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4975.kt")
        public void testKt4975() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/kt4975.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/annotationsForResolve")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotationsForResolve extends AbstractDiagnosticsTestWithStdLib {
            public void testAllFilesPresentInAnnotationsForResolve() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/inference/annotationsForResolve"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("exactAnnotation.kt")
            public void testExactAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/annotationsForResolve/exactAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("internalAnnotationsOnTypes.kt")
            public void testInternalAnnotationsOnTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/annotationsForResolve/internalAnnotationsOnTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("noInferAndLowPriority.kt")
            public void testNoInferAndLowPriority() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/annotationsForResolve/noInferAndLowPriority.kt");
                doTest(fileName);
            }

            @TestMetadata("noInferAnnotation.kt")
            public void testNoInferAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/annotationsForResolve/noInferAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("onlyInputTypesAndLowPriority.kt")
            public void testOnlyInputTypesAndLowPriority() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/annotationsForResolve/onlyInputTypesAndLowPriority.kt");
                doTest(fileName);
            }

            @TestMetadata("onlyInputTypesAnnotationWithPlatformTypes.kt")
            public void testOnlyInputTypesAnnotationWithPlatformTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/annotationsForResolve/onlyInputTypesAnnotationWithPlatformTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("resolveWithOnlyInputTypesAnnotation.kt")
            public void testResolveWithOnlyInputTypesAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inference/annotationsForResolve/resolveWithOnlyInputTypesAnnotation.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/inline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inline extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/inline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inlineOnlySuppressesNothingToInline.kt")
        public void testInlineOnlySuppressesNothingToInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/inline/inlineOnlySuppressesNothingToInline.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/kt7585")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Kt7585 extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInKt7585() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/kt7585"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("delegate.kt")
        public void testDelegate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/kt7585/delegate.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/native")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Native extends AbstractDiagnosticsTestWithStdLib {
        @TestMetadata("abstract.kt")
        public void testAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/native/abstract.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInNative() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/native"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("body.kt")
        public void testBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/native/body.kt");
            doTest(fileName);
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/native/constructor.kt");
            doTest(fileName);
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/native/inline.kt");
            doTest(fileName);
        }

        @TestMetadata("noBody.kt")
        public void testNoBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/native/noBody.kt");
            doTest(fileName);
        }

        @TestMetadata("override.kt")
        public void testOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/native/override.kt");
            doTest(fileName);
        }

        @TestMetadata("reified.kt")
        public void testReified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/native/reified.kt");
            doTest(fileName);
        }

        @TestMetadata("trait.kt")
        public void testTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/native/trait.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PurelyImplementedCollection extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInPurelyImplementedCollection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayList.kt")
        public void testArrayList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection/arrayList.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayListNullable.kt")
        public void testArrayListNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection/arrayListNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("customClassMutableCollection.kt")
        public void testCustomClassMutableCollection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection/customClassMutableCollection.kt");
            doTest(fileName);
        }

        @TestMetadata("customClassMutableList.kt")
        public void testCustomClassMutableList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection/customClassMutableList.kt");
            doTest(fileName);
        }

        @TestMetadata("invalidFqName.kt")
        public void testInvalidFqName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection/invalidFqName.kt");
            doTest(fileName);
        }

        @TestMetadata("maps.kt")
        public void testMaps() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection/maps.kt");
            doTest(fileName);
        }

        @TestMetadata("mapsWithNullableKey.kt")
        public void testMapsWithNullableKey() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection/mapsWithNullableKey.kt");
            doTest(fileName);
        }

        @TestMetadata("mapsWithNullableValues.kt")
        public void testMapsWithNullableValues() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection/mapsWithNullableValues.kt");
            doTest(fileName);
        }

        @TestMetadata("sets.kt")
        public void testSets() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection/sets.kt");
            doTest(fileName);
        }

        @TestMetadata("wrongTypeParametersCount.kt")
        public void testWrongTypeParametersCount() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/purelyImplementedCollection/wrongTypeParametersCount.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/regression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Regression extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInRegression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/regression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ea63992.kt")
        public void testEa63992() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/regression/ea63992.kt");
            doTest(fileName);
        }

        @TestMetadata("ea65206.kt")
        public void testEa65206() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/regression/ea65206.kt");
            doTest(fileName);
        }

        @TestMetadata("ea66827_dataClassWrongToString.kt")
        public void testEa66827_dataClassWrongToString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/regression/ea66827_dataClassWrongToString.kt");
            doTest(fileName);
        }

        @TestMetadata("ea70485_functionTypeInheritor.kt")
        public void testEa70485_functionTypeInheritor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/regression/ea70485_functionTypeInheritor.kt");
            doTest(fileName);
        }

        @TestMetadata("ea70880_illegalJvmName.kt")
        public void testEa70880_illegalJvmName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/regression/ea70880_illegalJvmName.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10001.kt")
        public void testKt10001() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/regression/kt10001.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2082.kt")
        public void testKt2082() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/regression/kt2082.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9345.kt")
        public void testKt9345() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/regression/kt9345.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9820_javaFunctionTypeInheritor.kt")
        public void testKt9820_javaFunctionTypeInheritor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/regression/kt9820_javaFunctionTypeInheritor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/reified")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Reified extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInReified() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/reified"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayConstruction.kt")
        public void testArrayConstruction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/reified/arrayConstruction.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayOfNullsReified.kt")
        public void testArrayOfNullsReified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/reified/arrayOfNullsReified.kt");
            doTest(fileName);
        }

        @TestMetadata("nonCallableReiefied.kt")
        public void testNonCallableReiefied() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/reified/nonCallableReiefied.kt");
            doTest(fileName);
        }

        @TestMetadata("reifiedNothingSubstitution.kt")
        public void testReifiedNothingSubstitution() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/reified/reifiedNothingSubstitution.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/resolve")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Resolve extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInResolve() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/resolve"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("hidesMembers.kt")
        public void testHidesMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/resolve/hidesMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("hidesMembers2.kt")
        public void testHidesMembers2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/resolve/hidesMembers2.kt");
            doTest(fileName);
        }

        @TestMetadata("javaPackageMembers.kt")
        public void testJavaPackageMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/resolve/javaPackageMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("javaStaticMembers.kt")
        public void testJavaStaticMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/resolve/javaStaticMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10103.kt")
        public void testKt10103() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/resolve/kt10103.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10732a.kt")
        public void testKt10732a() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/resolve/kt10732a.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4711.kt")
        public void testKt4711() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/resolve/kt4711.kt");
            doTest(fileName);
        }

        @TestMetadata("samConstructorVsFun.kt")
        public void testSamConstructorVsFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/resolve/samConstructorVsFun.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Smartcasts extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInSmartcasts() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/smartcasts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("forEachSafe.kt")
        public void testForEachSafe() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/forEachSafe.kt");
            doTest(fileName);
        }

        @TestMetadata("forEachUnsafe.kt")
        public void testForEachUnsafe() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/forEachUnsafe.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10463.kt")
        public void testKt10463() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/kt10463.kt");
            doTest(fileName);
        }

        @TestMetadata("lazyDeclaresAndModifies.kt")
        public void testLazyDeclaresAndModifies() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/lazyDeclaresAndModifies.kt");
            doTest(fileName);
        }

        @TestMetadata("letAlwaysChangesToNotNull.kt")
        public void testLetAlwaysChangesToNotNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/letAlwaysChangesToNotNull.kt");
            doTest(fileName);
        }

        @TestMetadata("letChangesToNotNull.kt")
        public void testLetChangesToNotNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/letChangesToNotNull.kt");
            doTest(fileName);
        }

        @TestMetadata("letChangesToNull.kt")
        public void testLetChangesToNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/letChangesToNull.kt");
            doTest(fileName);
        }

        @TestMetadata("letChangesToNullComplex.kt")
        public void testLetChangesToNullComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/letChangesToNullComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("letMergeNotNull.kt")
        public void testLetMergeNotNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/letMergeNotNull.kt");
            doTest(fileName);
        }

        @TestMetadata("letStable.kt")
        public void testLetStable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/letStable.kt");
            doTest(fileName);
        }

        @TestMetadata("letUsesOwnReceiver.kt")
        public void testLetUsesOwnReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/letUsesOwnReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("listOfGeneric.kt")
        public void testListOfGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/listOfGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("withChangesToNull.kt")
        public void testWithChangesToNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/smartcasts/withChangesToNull.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/typealias")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Typealias extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInTypealias() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/typealias"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("exceptionTypeAliases.kt")
        public void testExceptionTypeAliases() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/typealias/exceptionTypeAliases.kt");
            doTest(fileName);
        }

        @TestMetadata("exceptionTypeAliasesInvisibleWithApiVersion1_0.kt")
        public void testExceptionTypeAliasesInvisibleWithApiVersion1_0() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/typealias/exceptionTypeAliasesInvisibleWithApiVersion1_0.kt");
            doTest(fileName);
        }

        @TestMetadata("exceptionTypeAliasesInvisibleWithoutFeature.kt")
        public void testExceptionTypeAliasesInvisibleWithoutFeature() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/typealias/exceptionTypeAliasesInvisibleWithoutFeature.kt");
            doTest(fileName);
        }

        @TestMetadata("hashMapTypeAlias.kt")
        public void testHashMapTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/typealias/hashMapTypeAlias.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasSamAdapterConstructors.kt")
        public void testTypeAliasSamAdapterConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/typealias/typeAliasSamAdapterConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAliasSamAdapterConstructors2.kt")
        public void testTypeAliasSamAdapterConstructors2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/typealias/typeAliasSamAdapterConstructors2.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/varargs")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Varargs extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInVarargs() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/varargs"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt3213.kt")
        public void testKt3213() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/varargs/kt3213.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4172j.kt")
        public void testKt4172j() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/varargs/kt4172j.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5534.kt")
        public void testKt5534() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/varargs/kt5534.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/diagnostics/testsWithStdLib/when")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class When extends AbstractDiagnosticsTestWithStdLib {
        public void testAllFilesPresentInWhen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/diagnostics/testsWithStdLib/when"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt10192.kt")
        public void testKt10192() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/when/kt10192.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10807.kt")
        public void testKt10807() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/when/kt10807.kt");
            doTest(fileName);
        }

        @TestMetadata("noTypeArgumentsInConstructor.kt")
        public void testNoTypeArgumentsInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/diagnostics/testsWithStdLib/when/noTypeArgumentsInConstructor.kt");
            doTest(fileName);
        }
    }
}
