/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/boxAgainstJava")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BlackBoxAgainstJavaCodegenTestGenerated extends AbstractBlackBoxAgainstJavaCodegenTest {
    public void testAllFilesPresentInBoxAgainstJava() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/annotations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Annotations extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInAnnotations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("javaAnnotationArrayValueDefault.kt")
        public void testJavaAnnotationArrayValueDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/javaAnnotationArrayValueDefault.kt");
            doTest(fileName);
        }

        @TestMetadata("javaAnnotationArrayValueNoDefault.kt")
        public void testJavaAnnotationArrayValueNoDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/javaAnnotationArrayValueNoDefault.kt");
            doTest(fileName);
        }

        @TestMetadata("javaAnnotationCall.kt")
        public void testJavaAnnotationCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/javaAnnotationCall.kt");
            doTest(fileName);
        }

        @TestMetadata("javaAnnotationDefault.kt")
        public void testJavaAnnotationDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/javaAnnotationDefault.kt");
            doTest(fileName);
        }

        @TestMetadata("javaNegativePropertyAsAnnotationParameter.kt")
        public void testJavaNegativePropertyAsAnnotationParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/javaNegativePropertyAsAnnotationParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("javaPropertyAsAnnotationParameter.kt")
        public void testJavaPropertyAsAnnotationParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/javaPropertyAsAnnotationParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("javaPropertyWithIntInitializer.kt")
        public void testJavaPropertyWithIntInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/javaPropertyWithIntInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("retentionInJava.kt")
        public void testRetentionInJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/retentionInJava.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/boxAgainstJava/annotations/kClassMapping")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KClassMapping extends AbstractBlackBoxAgainstJavaCodegenTest {
            public void testAllFilesPresentInKClassMapping() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/annotations/kClassMapping"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrayClassParameter.kt")
            public void testArrayClassParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/kClassMapping/arrayClassParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("arrayClassParameterOnJavaClass.kt")
            public void testArrayClassParameterOnJavaClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/kClassMapping/arrayClassParameterOnJavaClass.kt");
                doTest(fileName);
            }

            @TestMetadata("classParameter.kt")
            public void testClassParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/kClassMapping/classParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("classParameterOnJavaClass.kt")
            public void testClassParameterOnJavaClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/kClassMapping/classParameterOnJavaClass.kt");
                doTest(fileName);
            }

            @TestMetadata("varargClassParameter.kt")
            public void testVarargClassParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/kClassMapping/varargClassParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("varargClassParameterOnJavaClass.kt")
            public void testVarargClassParameterOnJavaClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/annotations/kClassMapping/varargClassParameterOnJavaClass.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInCallableReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/callableReference/constructor.kt");
            doTest(fileName);
        }

        @TestMetadata("publicFinalField.kt")
        public void testPublicFinalField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/callableReference/publicFinalField.kt");
            doTest(fileName);
        }

        @TestMetadata("publicMutableField.kt")
        public void testPublicMutableField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/callableReference/publicMutableField.kt");
            doTest(fileName);
        }

        @TestMetadata("staticMethod.kt")
        public void testStaticMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/callableReference/staticMethod.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/constructor")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constructor extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInConstructor() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/constructor"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("genericConstructor.kt")
        public void testGenericConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/constructor/genericConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/constructor/secondaryConstructor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/delegation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Delegation extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInDelegation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/delegation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("delegationAndInheritanceFromJava.kt")
        public void testDelegationAndInheritanceFromJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/delegation/delegationAndInheritanceFromJava.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/enum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Enum extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInEnum() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/enum"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simpleJavaEnum.kt")
        public void testSimpleJavaEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/enum/simpleJavaEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleJavaEnumWithFunction.kt")
        public void testSimpleJavaEnumWithFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/enum/simpleJavaEnumWithFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleJavaEnumWithStaticImport.kt")
        public void testSimpleJavaEnumWithStaticImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/enum/simpleJavaEnumWithStaticImport.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleJavaInnerEnum.kt")
        public void testSimpleJavaInnerEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/enum/simpleJavaInnerEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("staticField.kt")
        public void testStaticField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/enum/staticField.kt");
            doTest(fileName);
        }

        @TestMetadata("staticMethod.kt")
        public void testStaticMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/enum/staticMethod.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/functions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Functions extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInFunctions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/functions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/functions/constructor.kt");
            doTest(fileName);
        }

        @TestMetadata("max.kt")
        public void testMax() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/functions/max.kt");
            doTest(fileName);
        }

        @TestMetadata("referencesStaticInnerClassMethod.kt")
        public void testReferencesStaticInnerClassMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/functions/referencesStaticInnerClassMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("referencesStaticInnerClassMethodL2.kt")
        public void testReferencesStaticInnerClassMethodL2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/functions/referencesStaticInnerClassMethodL2.kt");
            doTest(fileName);
        }

        @TestMetadata("unrelatedUpperBounds.kt")
        public void testUnrelatedUpperBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/functions/unrelatedUpperBounds.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/innerClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InnerClass extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInInnerClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/innerClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt3532.kt")
        public void testKt3532() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/innerClass/kt3532.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3812.kt")
        public void testKt3812() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/innerClass/kt3812.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4036.kt")
        public void testKt4036() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/innerClass/kt4036.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/interfaces")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Interfaces extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInInterfaces() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/interfaces"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inheritJavaInterface.kt")
        public void testInheritJavaInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/interfaces/inheritJavaInterface.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/notNullAssertions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NotNullAssertions extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInNotNullAssertions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/notNullAssertions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("delegation.kt")
        public void testDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/notNullAssertions/delegation.kt");
            doTest(fileName);
        }

        @TestMetadata("rightElvisOperand.kt")
        public void testRightElvisOperand() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/notNullAssertions/rightElvisOperand.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/platformTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PlatformTypes extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInPlatformTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/platformTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("genericUnit.kt")
        public void testGenericUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/platformTypes/genericUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("specializedMapFull.kt")
        public void testSpecializedMapFull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/platformTypes/specializedMapFull.kt");
            doTest(fileName);
        }

        @TestMetadata("specializedMapPut.kt")
        public void testSpecializedMapPut() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/platformTypes/specializedMapPut.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/property")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Property extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("fieldAccessFromExtensionInTraitImpl.kt")
        public void testFieldAccessFromExtensionInTraitImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/property/fieldAccessFromExtensionInTraitImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("fieldAccessViaSubclass.kt")
        public void testFieldAccessViaSubclass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/property/fieldAccessViaSubclass.kt");
            doTest(fileName);
        }

        @TestMetadata("referenceToJavaFieldViaBridge.kt")
        public void testReferenceToJavaFieldViaBridge() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/property/referenceToJavaFieldViaBridge.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/reflection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Reflection extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInReflection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/reflection"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/codegen/boxAgainstJava/reflection/classLiterals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassLiterals extends AbstractBlackBoxAgainstJavaCodegenTest {
            public void testAllFilesPresentInClassLiterals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/reflection/classLiterals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaClassLiteral.kt")
            public void testJavaClassLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/reflection/classLiterals/javaClassLiteral.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxAgainstJava/reflection/mapping")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Mapping extends AbstractBlackBoxAgainstJavaCodegenTest {
            public void testAllFilesPresentInMapping() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/reflection/mapping"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("jClass2kClass.kt")
            public void testJClass2kClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/reflection/mapping/jClass2kClass.kt");
                doTest(fileName);
            }

            @TestMetadata("javaConstructor.kt")
            public void testJavaConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/reflection/mapping/javaConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("javaFields.kt")
            public void testJavaFields() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/reflection/mapping/javaFields.kt");
                doTest(fileName);
            }

            @TestMetadata("javaMethods.kt")
            public void testJavaMethods() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/reflection/mapping/javaMethods.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxAgainstJava/reflection/properties")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Properties extends AbstractBlackBoxAgainstJavaCodegenTest {
            public void testAllFilesPresentInProperties() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/reflection/properties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("equalsHashCodeToString.kt")
            public void testEqualsHashCodeToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/reflection/properties/equalsHashCodeToString.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/sam")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Sam extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInSam() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/sam"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("differentFqNames.kt")
        public void testDifferentFqNames() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/differentFqNames.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11519.kt")
        public void testKt11519() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/kt11519.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11519Constructor.kt")
        public void testKt11519Constructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/kt11519Constructor.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11696.kt")
        public void testKt11696() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/kt11696.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4753.kt")
        public void testKt4753() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/kt4753.kt");
            doTest(fileName);
        }

        @TestMetadata("kt4753_2.kt")
        public void testKt4753_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/kt4753_2.kt");
            doTest(fileName);
        }

        @TestMetadata("samConstructorGenericSignature.kt")
        public void testSamConstructorGenericSignature() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/samConstructorGenericSignature.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Adapters extends AbstractBlackBoxAgainstJavaCodegenTest {
            public void testAllFilesPresentInAdapters() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/sam/adapters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("bridgesForOverridden.kt")
            public void testBridgesForOverridden() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/bridgesForOverridden.kt");
                doTest(fileName);
            }

            @TestMetadata("bridgesForOverriddenComplex.kt")
            public void testBridgesForOverriddenComplex() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/bridgesForOverriddenComplex.kt");
                doTest(fileName);
            }

            @TestMetadata("callAbstractAdapter.kt")
            public void testCallAbstractAdapter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/callAbstractAdapter.kt");
                doTest(fileName);
            }

            @TestMetadata("comparator.kt")
            public void testComparator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/comparator.kt");
                doTest(fileName);
            }

            @TestMetadata("constructor.kt")
            public void testConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/constructor.kt");
                doTest(fileName);
            }

            @TestMetadata("doubleLongParameters.kt")
            public void testDoubleLongParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/doubleLongParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("fileFilter.kt")
            public void testFileFilter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/fileFilter.kt");
                doTest(fileName);
            }

            @TestMetadata("genericSignature.kt")
            public void testGenericSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/genericSignature.kt");
                doTest(fileName);
            }

            @TestMetadata("implementAdapter.kt")
            public void testImplementAdapter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/implementAdapter.kt");
                doTest(fileName);
            }

            @TestMetadata("inheritedInKotlin.kt")
            public void testInheritedInKotlin() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/inheritedInKotlin.kt");
                doTest(fileName);
            }

            @TestMetadata("inheritedOverriddenAdapter.kt")
            public void testInheritedOverriddenAdapter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/inheritedOverriddenAdapter.kt");
                doTest(fileName);
            }

            @TestMetadata("inheritedSimple.kt")
            public void testInheritedSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/inheritedSimple.kt");
                doTest(fileName);
            }

            @TestMetadata("localClass.kt")
            public void testLocalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/localClass.kt");
                doTest(fileName);
            }

            @TestMetadata("localObjectConstructor.kt")
            public void testLocalObjectConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/localObjectConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("localObjectConstructorWithFnValue.kt")
            public void testLocalObjectConstructorWithFnValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/localObjectConstructorWithFnValue.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLiteralAndLiteralRunnable.kt")
            public void testNonLiteralAndLiteralRunnable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/nonLiteralAndLiteralRunnable.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLiteralComparator.kt")
            public void testNonLiteralComparator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/nonLiteralComparator.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLiteralInConstructor.kt")
            public void testNonLiteralInConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/nonLiteralInConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLiteralNull.kt")
            public void testNonLiteralNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/nonLiteralNull.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLiteralRunnable.kt")
            public void testNonLiteralRunnable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/nonLiteralRunnable.kt");
                doTest(fileName);
            }

            @TestMetadata("protectedFromBase.kt")
            public void testProtectedFromBase() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/protectedFromBase.kt");
                doTest(fileName);
            }

            @TestMetadata("severalSamParameters.kt")
            public void testSeveralSamParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/severalSamParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("simplest.kt")
            public void testSimplest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/simplest.kt");
                doTest(fileName);
            }

            @TestMetadata("superconstructor.kt")
            public void testSuperconstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/superconstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("superconstructorWithClosure.kt")
            public void testSuperconstructorWithClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/superconstructorWithClosure.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParameterOfClass.kt")
            public void testTypeParameterOfClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/typeParameterOfClass.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParameterOfMethod.kt")
            public void testTypeParameterOfMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/typeParameterOfMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("typeParameterOfOuterClass.kt")
            public void testTypeParameterOfOuterClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/typeParameterOfOuterClass.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Operators extends AbstractBlackBoxAgainstJavaCodegenTest {
                public void testAllFilesPresentInOperators() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("augmentedAssignmentPure.kt")
                public void testAugmentedAssignmentPure() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators/augmentedAssignmentPure.kt");
                    doTest(fileName);
                }

                @TestMetadata("augmentedAssignmentViaSimpleBinary.kt")
                public void testAugmentedAssignmentViaSimpleBinary() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators/augmentedAssignmentViaSimpleBinary.kt");
                    doTest(fileName);
                }

                @TestMetadata("binary.kt")
                public void testBinary() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators/binary.kt");
                    doTest(fileName);
                }

                @TestMetadata("compareTo.kt")
                public void testCompareTo() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators/compareTo.kt");
                    doTest(fileName);
                }

                @TestMetadata("contains.kt")
                public void testContains() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators/contains.kt");
                    doTest(fileName);
                }

                @TestMetadata("get.kt")
                public void testGet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators/get.kt");
                    doTest(fileName);
                }

                @TestMetadata("invoke.kt")
                public void testInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators/invoke.kt");
                    doTest(fileName);
                }

                @TestMetadata("multiGetSet.kt")
                public void testMultiGetSet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators/multiGetSet.kt");
                    doTest(fileName);
                }

                @TestMetadata("multiInvoke.kt")
                public void testMultiInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators/multiInvoke.kt");
                    doTest(fileName);
                }

                @TestMetadata("set.kt")
                public void testSet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/sam/adapters/operators/set.kt");
                    doTest(fileName);
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/specialBuiltins")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SpecialBuiltins extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInSpecialBuiltins() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/specialBuiltins"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("charBuffer.kt")
        public void testCharBuffer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/specialBuiltins/charBuffer.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/staticFun")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StaticFun extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInStaticFun() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/staticFun"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classWithNestedEnum.kt")
        public void testClassWithNestedEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/staticFun/classWithNestedEnum.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SyntheticExtensions extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInSyntheticExtensions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/syntheticExtensions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("fromTwoBases.kt")
        public void testFromTwoBases() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions/fromTwoBases.kt");
            doTest(fileName);
        }

        @TestMetadata("getter.kt")
        public void testGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions/getter.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitReceiver.kt")
        public void testImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions/implicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("overrideOnlyGetter.kt")
        public void testOverrideOnlyGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions/overrideOnlyGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("plusPlus.kt")
        public void testPlusPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions/plusPlus.kt");
            doTest(fileName);
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions/protected.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedSetter.kt")
        public void testProtectedSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions/protectedSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("setter.kt")
        public void testSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions/setter.kt");
            doTest(fileName);
        }

        @TestMetadata("setterNonVoid1.kt")
        public void testSetterNonVoid1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions/setterNonVoid1.kt");
            doTest(fileName);
        }

        @TestMetadata("setterNonVoid2.kt")
        public void testSetterNonVoid2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/syntheticExtensions/setterNonVoid2.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/typealias")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Typealias extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInTypealias() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/typealias"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("javaStaticMembersViaTypeAlias.kt")
        public void testJavaStaticMembersViaTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/typealias/javaStaticMembersViaTypeAlias.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxAgainstJava/visibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Visibility extends AbstractBlackBoxAgainstJavaCodegenTest {
        public void testAllFilesPresentInVisibility() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/visibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/codegen/boxAgainstJava/visibility/package")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Package extends AbstractBlackBoxAgainstJavaCodegenTest {
            public void testAllFilesPresentInPackage() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/visibility/package"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kt2781.kt")
            public void testKt2781() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/package/kt2781.kt");
                doTest(fileName);
            }

            @TestMetadata("packageClass.kt")
            public void testPackageClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/package/packageClass.kt");
                doTest(fileName);
            }

            @TestMetadata("packageFun.kt")
            public void testPackageFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/package/packageFun.kt");
                doTest(fileName);
            }

            @TestMetadata("packageProperty.kt")
            public void testPackageProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/package/packageProperty.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedAndPackage")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProtectedAndPackage extends AbstractBlackBoxAgainstJavaCodegenTest {
            public void testAllFilesPresentInProtectedAndPackage() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/visibility/protectedAndPackage"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("overrideProtectedFunInPackage.kt")
            public void testOverrideProtectedFunInPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedAndPackage/overrideProtectedFunInPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("protectedFunInPackage.kt")
            public void testProtectedFunInPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedAndPackage/protectedFunInPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("protectedPropertyInPackage.kt")
            public void testProtectedPropertyInPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedAndPackage/protectedPropertyInPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("protectedStaticClass.kt")
            public void testProtectedStaticClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedAndPackage/protectedStaticClass.kt");
                doTest(fileName);
            }

            @TestMetadata("protectedSuperMethod.kt")
            public void testProtectedSuperMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedAndPackage/protectedSuperMethod.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProtectedStatic extends AbstractBlackBoxAgainstJavaCodegenTest {
            public void testAllFilesPresentInProtectedStatic() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("funCallInConstructor.kt")
            public void testFunCallInConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/funCallInConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("funClassObject.kt")
            public void testFunClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/funClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("funGenericClass.kt")
            public void testFunGenericClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/funGenericClass.kt");
                doTest(fileName);
            }

            @TestMetadata("funNestedStaticClass.kt")
            public void testFunNestedStaticClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/funNestedStaticClass.kt");
                doTest(fileName);
            }

            @TestMetadata("funNestedStaticClass2.kt")
            public void testFunNestedStaticClass2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/funNestedStaticClass2.kt");
                doTest(fileName);
            }

            @TestMetadata("funNestedStaticGenericClass.kt")
            public void testFunNestedStaticGenericClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/funNestedStaticGenericClass.kt");
                doTest(fileName);
            }

            @TestMetadata("funNotDirectSuperClass.kt")
            public void testFunNotDirectSuperClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/funNotDirectSuperClass.kt");
                doTest(fileName);
            }

            @TestMetadata("funObject.kt")
            public void testFunObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/funObject.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleClass.kt")
            public void testSimpleClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/simpleClass.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleClass2.kt")
            public void testSimpleClass2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/simpleClass2.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleFun.kt")
            public void testSimpleFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/simpleFun.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleProperty.kt")
            public void testSimpleProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxAgainstJava/visibility/protectedStatic/simpleProperty.kt");
                doTest(fileName);
            }
        }
    }
}
