/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/boxInline")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BlackBoxInlineCodegenTestGenerated extends AbstractBlackBoxInlineCodegenTest {
    public void testAllFilesPresentInBoxInline() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AnonymousObject extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInAnonymousObject() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousObjectOnCallSite.kt")
        public void testAnonymousObjectOnCallSite() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSite.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectOnCallSiteSuperParams.kt")
        public void testAnonymousObjectOnCallSiteSuperParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSiteSuperParams.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectOnDeclarationSite.kt")
        public void testAnonymousObjectOnDeclarationSite() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSite.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectOnDeclarationSiteSuperParams.kt")
        public void testAnonymousObjectOnDeclarationSiteSuperParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSiteSuperParams.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedLambdaInInline.kt")
        public void testCapturedLambdaInInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedLambdaInInline2.kt")
        public void testCapturedLambdaInInline2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline2.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedLambdaInInline3.kt")
        public void testCapturedLambdaInInline3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline3.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedLambdaInInlineObject.kt")
        public void testCapturedLambdaInInlineObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInlineObject.kt");
            doTest(fileName);
        }

        @TestMetadata("changingReturnType.kt")
        public void testChangingReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/changingReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("constructorVisibility.kt")
        public void testConstructorVisibility() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibility.kt");
            doTest(fileName);
        }

        @TestMetadata("constructorVisibilityInConstLambda.kt")
        public void testConstructorVisibilityInConstLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInConstLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("constructorVisibilityInLambda.kt")
        public void testConstructorVisibilityInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("defineClass.kt")
        public void testDefineClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/defineClass.kt");
            doTest(fileName);
        }

        @TestMetadata("kt13133.kt")
        public void testKt13133() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/kt13133.kt");
            doTest(fileName);
        }

        @TestMetadata("kt13182.kt")
        public void testKt13182() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/kt13182.kt");
            doTest(fileName);
        }

        @TestMetadata("kt13374.kt")
        public void testKt13374() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/kt13374.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6552.kt")
        public void testKt6552() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/kt6552.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8133.kt")
        public void testKt8133() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/kt8133.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9064.kt")
        public void testKt9064() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/kt9064.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9064v2.kt")
        public void testKt9064v2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/kt9064v2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9591.kt")
        public void testKt9591() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/kt9591.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9877.kt")
        public void testKt9877() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/kt9877.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9877_2.kt")
        public void testKt9877_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/kt9877_2.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/safeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCall_2.kt")
        public void testSafeCall_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/safeCall_2.kt");
            doTest(fileName);
        }

        @TestMetadata("sam.kt")
        public void testSam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/sam.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/enumWhen")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class EnumWhen extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInEnumWhen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumWhen"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callSite.kt")
            public void testCallSite() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/callSite.kt");
                doTest(fileName);
            }

            @TestMetadata("declSite.kt")
            public void testDeclSite() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSite.kt");
                doTest(fileName);
            }

            @TestMetadata("declSiteSeveralMappings.kt")
            public void testDeclSiteSeveralMappings() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappings.kt");
                doTest(fileName);
            }

            @TestMetadata("declSiteSeveralMappingsDifOrder.kt")
            public void testDeclSiteSeveralMappingsDifOrder() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappingsDifOrder.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProperRecapturing extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInProperRecapturing() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("inlineChain.kt")
            public void testInlineChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/inlineChain.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaChain.kt")
            public void testLambdaChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaChainSimple.kt")
            public void testLambdaChainSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChainSimple.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaChain_2.kt")
            public void testLambdaChain_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_2.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaChain_3.kt")
            public void testLambdaChain_3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_3.kt");
                doTest(fileName);
            }

            @TestMetadata("noInlineLambda.kt")
            public void testNoInlineLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/noInlineLambda.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProperRecapturingInClass extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInProperRecapturingInClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("inlineChain.kt")
            public void testInlineChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlineChain.kt");
                doTest(fileName);
            }

            @TestMetadata("inlinelambdaChain.kt")
            public void testInlinelambdaChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlinelambdaChain.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaChain.kt")
            public void testLambdaChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaChainSimple.kt")
            public void testLambdaChainSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaChainSimple_2.kt")
            public void testLambdaChainSimple_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple_2.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaChain_2.kt")
            public void testLambdaChain_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_2.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaChain_3.kt")
            public void testLambdaChain_3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_3.kt");
                doTest(fileName);
            }

            @TestMetadata("noCapturedThisOnCallSite.kt")
            public void testNoCapturedThisOnCallSite() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noCapturedThisOnCallSite.kt");
                doTest(fileName);
            }

            @TestMetadata("noInlineLambda.kt")
            public void testNoInlineLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noInlineLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("twoInlineLambda.kt")
            public void testTwoInlineLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("twoInlineLambdaComplex.kt")
            public void testTwoInlineLambdaComplex() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex.kt");
                doTest(fileName);
            }

            @TestMetadata("twoInlineLambdaComplex_2.kt")
            public void testTwoInlineLambdaComplex_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex_2.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TwoCapturedReceivers extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInTwoCapturedReceivers() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kt8668.kt")
            public void testKt8668() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668.kt");
                doTest(fileName);
            }

            @TestMetadata("kt8668_2.kt")
            public void testKt8668_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_2.kt");
                doTest(fileName);
            }

            @TestMetadata("kt8668_3.kt")
            public void testKt8668_3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_3.kt");
                doTest(fileName);
            }

            @TestMetadata("twoDifferentDispatchReceivers.kt")
            public void testTwoDifferentDispatchReceivers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoDifferentDispatchReceivers.kt");
                doTest(fileName);
            }

            @TestMetadata("twoExtensionReceivers.kt")
            public void testTwoExtensionReceivers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoExtensionReceivers.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArgumentOrder extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("boundFunctionReference.kt")
        public void testBoundFunctionReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference.kt");
            doTest(fileName);
        }

        @TestMetadata("boundFunctionReference2.kt")
        public void testBoundFunctionReference2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference2.kt");
            doTest(fileName);
        }

        @TestMetadata("captured.kt")
        public void testCaptured() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/argumentOrder/captured.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedInExtension.kt")
        public void testCapturedInExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/argumentOrder/capturedInExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/argumentOrder/extension.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionInClass.kt")
        public void testExtensionInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/argumentOrder/extensionInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaMigration.kt")
        public void testLambdaMigration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigration.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaMigrationInClass.kt")
        public void testLambdaMigrationInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigrationInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/argumentOrder/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleInClass.kt")
        public void testSimpleInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/argumentOrder/simpleInClass.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/arrayConvention")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArrayConvention extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInArrayConvention() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/arrayConvention"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simpleAccess.kt")
        public void testSimpleAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/arrayConvention/simpleAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleAccessInClass.kt")
        public void testSimpleAccessInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleAccessWithDefault.kt")
        public void testSimpleAccessWithDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefault.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleAccessWithDefaultInClass.kt")
        public void testSimpleAccessWithDefaultInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefaultInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleAccessWithLambda.kt")
        public void testSimpleAccessWithLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleAccessWithLambdaInClass.kt")
        public void testSimpleAccessWithLambdaInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambdaInClass.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/builders")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Builders extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInBuilders() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/builders"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("builders.kt")
        public void testBuilders() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/builders/builders.kt");
            doTest(fileName);
        }

        @TestMetadata("buildersAndLambdaCapturing.kt")
        public void testBuildersAndLambdaCapturing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/builders/buildersAndLambdaCapturing.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInCallableReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classLevel.kt")
        public void testClassLevel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/classLevel.kt");
            doTest(fileName);
        }

        @TestMetadata("classLevel2.kt")
        public void testClassLevel2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/classLevel2.kt");
            doTest(fileName);
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/constructor.kt");
            doTest(fileName);
        }

        @TestMetadata("intrinsic.kt")
        public void testIntrinsic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/intrinsic.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyIntrinsic.kt")
        public void testPropertyIntrinsic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/propertyIntrinsic.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyReference.kt")
        public void testPropertyReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/propertyReference.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevel.kt")
        public void testTopLevel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/topLevel.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelExtension.kt")
        public void testTopLevelExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/topLevelExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/topLevelProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/boxInline/callableReference/bound")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Bound extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInBound() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classProperty.kt")
            public void testClassProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/bound/classProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("expression.kt")
            public void testExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/bound/expression.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionReceiver.kt")
            public void testExtensionReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/bound/extensionReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("filter.kt")
            public void testFilter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/bound/filter.kt");
                doTest(fileName);
            }

            @TestMetadata("intrinsic.kt")
            public void testIntrinsic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/bound/intrinsic.kt");
                doTest(fileName);
            }

            @TestMetadata("map.kt")
            public void testMap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/bound/map.kt");
                doTest(fileName);
            }

            @TestMetadata("objectProperty.kt")
            public void testObjectProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/bound/objectProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyImportedFromObject.kt")
            public void testPropertyImportedFromObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/bound/propertyImportedFromObject.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/bound/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelExtensionProperty.kt")
            public void testTopLevelExtensionProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/callableReference/bound/topLevelExtensionProperty.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/capture")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Capture extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInCapture() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/capture"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("captureInlinable.kt")
        public void testCaptureInlinable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/capture/captureInlinable.kt");
            doTest(fileName);
        }

        @TestMetadata("captureInlinableAndOther.kt")
        public void testCaptureInlinableAndOther() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/capture/captureInlinableAndOther.kt");
            doTest(fileName);
        }

        @TestMetadata("captureThisAndReceiver.kt")
        public void testCaptureThisAndReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/capture/captureThisAndReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/capture/generics.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleCapturingInClass.kt")
        public void testSimpleCapturingInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/capture/simpleCapturingInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleCapturingInPackage.kt")
        public void testSimpleCapturingInPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/capture/simpleCapturingInPackage.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/complex")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Complex extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInComplex() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/complex"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("closureChain.kt")
        public void testClosureChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complex/closureChain.kt");
            doTest(fileName);
        }

        @TestMetadata("forEachLine.kt")
        public void testForEachLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complex/forEachLine.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaInLambda.kt")
        public void testLambdaInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complex/lambdaInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("swapAndWith.kt")
        public void testSwapAndWith() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complex/swapAndWith.kt");
            doTest(fileName);
        }

        @TestMetadata("swapAndWith2.kt")
        public void testSwapAndWith2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complex/swapAndWith2.kt");
            doTest(fileName);
        }

        @TestMetadata("use.kt")
        public void testUse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complex/use.kt");
            doTest(fileName);
        }

        @TestMetadata("with.kt")
        public void testWith() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complex/with.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/complexStack")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ComplexStack extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInComplexStack() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/complexStack"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("asCheck.kt")
        public void testAsCheck() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complexStack/asCheck.kt");
            doTest(fileName);
        }

        @TestMetadata("asCheck2.kt")
        public void testAsCheck2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complexStack/asCheck2.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complexStack/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simple2.kt")
        public void testSimple2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complexStack/simple2.kt");
            doTest(fileName);
        }

        @TestMetadata("simple3.kt")
        public void testSimple3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complexStack/simple3.kt");
            doTest(fileName);
        }

        @TestMetadata("simple4.kt")
        public void testSimple4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complexStack/simple4.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleExtension.kt")
        public void testSimpleExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/complexStack/simpleExtension.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/defaultValues")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DefaultValues extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInDefaultValues() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("defaultInExtension.kt")
        public void testDefaultInExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/defaultValues/defaultInExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultMethod.kt")
        public void testDefaultMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/defaultValues/defaultMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultMethodInClass.kt")
        public void testDefaultMethodInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/defaultValues/defaultMethodInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultParamRemapping.kt")
        public void testDefaultParamRemapping() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/defaultValues/defaultParamRemapping.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineInDefaultParameter.kt")
        public void testInlineInDefaultParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/defaultValues/inlineInDefaultParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11479.kt")
        public void testKt11479() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/defaultValues/kt11479.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11479InlinedDefaultParameter.kt")
        public void testKt11479InlinedDefaultParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/defaultValues/kt11479InlinedDefaultParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5685.kt")
        public void testKt5685() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/defaultValues/kt5685.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleDefaultMethod.kt")
        public void testSimpleDefaultMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/defaultValues/simpleDefaultMethod.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DelegatedProperty extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/delegatedProperty/local.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/enclosingInfo")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class EnclosingInfo extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInEnclosingInfo() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousInLambda.kt")
        public void testAnonymousInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enclosingInfo/anonymousInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineChain.kt")
        public void testInlineChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineChain2.kt")
        public void testInlineChain2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain2.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInInlineFun.kt")
        public void testObjectInInlineFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enclosingInfo/objectInInlineFun.kt");
            doTest(fileName);
        }

        @TestMetadata("transformedConstructor.kt")
        public void testTransformedConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("transformedConstructorWithAdditionalObject.kt")
        public void testTransformedConstructorWithAdditionalObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithAdditionalObject.kt");
            doTest(fileName);
        }

        @TestMetadata("transformedConstructorWithNestedInline.kt")
        public void testTransformedConstructorWithNestedInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithNestedInline.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/enum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Enum extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInEnum() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/enum"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt10569.kt")
        public void testKt10569() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/kt10569.kt");
            doTest(fileName);
        }

        @TestMetadata("valueOf.kt")
        public void testValueOf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/valueOf.kt");
            doTest(fileName);
        }

        @TestMetadata("valueOfCapturedType.kt")
        public void testValueOfCapturedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/valueOfCapturedType.kt");
            doTest(fileName);
        }

        @TestMetadata("valueOfChain.kt")
        public void testValueOfChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/valueOfChain.kt");
            doTest(fileName);
        }

        @TestMetadata("valueOfChainCapturedType.kt")
        public void testValueOfChainCapturedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/valueOfChainCapturedType.kt");
            doTest(fileName);
        }

        @TestMetadata("valueOfNonReified.kt")
        public void testValueOfNonReified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/valueOfNonReified.kt");
            doTest(fileName);
        }

        @TestMetadata("values.kt")
        public void testValues() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/values.kt");
            doTest(fileName);
        }

        @TestMetadata("valuesAsArray.kt")
        public void testValuesAsArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/valuesAsArray.kt");
            doTest(fileName);
        }

        @TestMetadata("valuesCapturedType.kt")
        public void testValuesCapturedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/valuesCapturedType.kt");
            doTest(fileName);
        }

        @TestMetadata("valuesChain.kt")
        public void testValuesChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/valuesChain.kt");
            doTest(fileName);
        }

        @TestMetadata("valuesChainCapturedType.kt")
        public void testValuesChainCapturedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/valuesChainCapturedType.kt");
            doTest(fileName);
        }

        @TestMetadata("valuesNonReified.kt")
        public void testValuesNonReified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/enum/valuesNonReified.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/functionExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FunctionExpression extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInFunctionExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/functionExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/functionExpression/extension.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/innerClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InnerClasses extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInInnerClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/innerClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("innerLambda.kt")
        public void testInnerLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/innerClasses/innerLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10259.kt")
        public void testKt10259() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/innerClasses/kt10259.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/lambdaClassClash")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LambdaClassClash extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInLambdaClassClash() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaClassClash"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("lambdaClassClash.kt")
        public void testLambdaClassClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/lambdaClassClash/lambdaClassClash.kt");
            doTest(fileName);
        }

        @TestMetadata("noInlineLambdaX2.kt")
        public void testNoInlineLambdaX2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/lambdaClassClash/noInlineLambdaX2.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/lambdaTransformation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LambdaTransformation extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInLambdaTransformation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaTransformation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("lambdaCloning.kt")
        public void testLambdaCloning() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaCloning.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaInLambda2.kt")
        public void testLambdaInLambda2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambda2.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaInLambdaNoInline.kt")
        public void testLambdaInLambdaNoInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambdaNoInline.kt");
            doTest(fileName);
        }

        @TestMetadata("regeneratedLambdaName.kt")
        public void testRegeneratedLambdaName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName.kt");
            doTest(fileName);
        }

        @TestMetadata("sameCaptured.kt")
        public void testSameCaptured() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/lambdaTransformation/sameCaptured.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/localFunInLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LocalFunInLambda extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInLocalFunInLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/localFunInLambda"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("localFunInLambda.kt")
        public void testLocalFunInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambda.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultifileClasses extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inlineFromOptimizedMultifileClass.kt")
        public void testInlineFromOptimizedMultifileClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOptimizedMultifileClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineFromOtherPackage.kt")
        public void testInlineFromOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOtherPackage.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/noInline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NoInline extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInNoInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/noInline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("extensionReceiver.kt")
        public void testExtensionReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/noInline/extensionReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaAsGeneric.kt")
        public void testLambdaAsGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/noInline/lambdaAsGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaAsNonFunction.kt")
        public void testLambdaAsNonFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/noInline/lambdaAsNonFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("noInline.kt")
        public void testNoInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/noInline/noInline.kt");
            doTest(fileName);
        }

        @TestMetadata("noInlineLambdaChain.kt")
        public void testNoInlineLambdaChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChain.kt");
            doTest(fileName);
        }

        @TestMetadata("noInlineLambdaChainWithCapturedInline.kt")
        public void testNoInlineLambdaChainWithCapturedInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChainWithCapturedInline.kt");
            doTest(fileName);
        }

        @TestMetadata("withoutInline.kt")
        public void testWithoutInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/noInline/withoutInline.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NonLocalReturns extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInNonLocalReturns() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("explicitLocalReturn.kt")
        public void testExplicitLocalReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/explicitLocalReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("justReturnInLambda.kt")
        public void testJustReturnInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/justReturnInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("kt5199.kt")
        public void testKt5199() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/kt5199.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8948.kt")
        public void testKt8948() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8948v2.kt")
        public void testKt8948v2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948v2.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedNonLocals.kt")
        public void testNestedNonLocals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/nestedNonLocals.kt");
            doTest(fileName);
        }

        @TestMetadata("noInlineLocalReturn.kt")
        public void testNoInlineLocalReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/noInlineLocalReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("nonLocalReturnFromOuterLambda.kt")
        public void testNonLocalReturnFromOuterLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/nonLocalReturnFromOuterLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessors.kt")
        public void testPropertyAccessors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/propertyAccessors.kt");
            doTest(fileName);
        }

        @TestMetadata("returnFromFunctionExpr.kt")
        public void testReturnFromFunctionExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/returnFromFunctionExpr.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleFunctional.kt")
        public void testSimpleFunctional() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/simpleFunctional.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleVoid.kt")
        public void testSimpleVoid() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/simpleVoid.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Deparenthesize extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInDeparenthesize() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("bracket.kt")
            public void testBracket() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/bracket.kt");
                doTest(fileName);
            }

            @TestMetadata("labeled.kt")
            public void testLabeled() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/labeled.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TryFinally extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInTryFinally() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kt6956.kt")
            public void testKt6956() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt6956.kt");
                doTest(fileName);
            }

            @TestMetadata("kt7273.kt")
            public void testKt7273() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt7273.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLocalReturnFromOuterLambda.kt")
            public void testNonLocalReturnFromOuterLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromOuterLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallSite extends AbstractBlackBoxInlineCodegenTest {
                public void testAllFilesPresentInCallSite() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("callSite.kt")
                public void testCallSite() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSite.kt");
                    doTest(fileName);
                }

                @TestMetadata("callSiteComplex.kt")
                public void testCallSiteComplex() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSiteComplex.kt");
                    doTest(fileName);
                }

                @TestMetadata("exceptionTableSplit.kt")
                public void testExceptionTableSplit() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplit.kt");
                    doTest(fileName);
                }

                @TestMetadata("exceptionTableSplitNoReturn.kt")
                public void testExceptionTableSplitNoReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplitNoReturn.kt");
                    doTest(fileName);
                }

                @TestMetadata("finallyInFinally.kt")
                public void testFinallyInFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/finallyInFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("wrongVarInterval.kt")
                public void testWrongVarInterval() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/wrongVarInterval.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Chained extends AbstractBlackBoxInlineCodegenTest {
                public void testAllFilesPresentInChained() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("finallyInFinally.kt")
                public void testFinallyInFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("finallyInFinally2.kt")
                public void testFinallyInFinally2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally2.kt");
                    doTest(fileName);
                }

                @TestMetadata("intReturn.kt")
                public void testIntReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturn.kt");
                    doTest(fileName);
                }

                @TestMetadata("intReturnComplex.kt")
                public void testIntReturnComplex() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex.kt");
                    doTest(fileName);
                }

                @TestMetadata("intReturnComplex2.kt")
                public void testIntReturnComplex2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex2.kt");
                    doTest(fileName);
                }

                @TestMetadata("intReturnComplex3.kt")
                public void testIntReturnComplex3() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex3.kt");
                    doTest(fileName);
                }

                @TestMetadata("intReturnComplex4.kt")
                public void testIntReturnComplex4() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex4.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedLambda.kt")
                public void testNestedLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/nestedLambda.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DeclSite extends AbstractBlackBoxInlineCodegenTest {
                public void testAllFilesPresentInDeclSite() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("complex.kt")
                public void testComplex() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/complex.kt");
                    doTest(fileName);
                }

                @TestMetadata("intReturn.kt")
                public void testIntReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturn.kt");
                    doTest(fileName);
                }

                @TestMetadata("intReturnComplex.kt")
                public void testIntReturnComplex() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturnComplex.kt");
                    doTest(fileName);
                }

                @TestMetadata("longReturn.kt")
                public void testLongReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/longReturn.kt");
                    doTest(fileName);
                }

                @TestMetadata("nested.kt")
                public void testNested() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/nested.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnInFinally.kt")
                public void testReturnInFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnInTry.kt")
                public void testReturnInTry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTry.kt");
                    doTest(fileName);
                }

                @TestMetadata("returnInTryAndFinally.kt")
                public void testReturnInTryAndFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTryAndFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("severalInTry.kt")
                public void testSeveralInTry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTry.kt");
                    doTest(fileName);
                }

                @TestMetadata("severalInTryComplex.kt")
                public void testSeveralInTryComplex() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTryComplex.kt");
                    doTest(fileName);
                }

                @TestMetadata("voidInlineFun.kt")
                public void testVoidInlineFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidInlineFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("voidNonLocal.kt")
                public void testVoidNonLocal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidNonLocal.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ExceptionTable extends AbstractBlackBoxInlineCodegenTest {
                public void testAllFilesPresentInExceptionTable() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("break.kt")
                public void testBreak() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/break.kt");
                    doTest(fileName);
                }

                @TestMetadata("continue.kt")
                public void testContinue() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/continue.kt");
                    doTest(fileName);
                }

                @TestMetadata("exceptionInFinally.kt")
                public void testExceptionInFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/exceptionInFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("forInFinally.kt")
                public void testForInFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/forInFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerAndExternal.kt")
                public void testInnerAndExternal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternal.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerAndExternalNested.kt")
                public void testInnerAndExternalNested() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalNested.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerAndExternalSimple.kt")
                public void testInnerAndExternalSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalSimple.kt");
                    doTest(fileName);
                }

                @TestMetadata("nested.kt")
                public void testNested() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nested.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedWithReturns.kt")
                public void testNestedWithReturns() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturns.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedWithReturnsSimple.kt")
                public void testNestedWithReturnsSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturnsSimple.kt");
                    doTest(fileName);
                }

                @TestMetadata("noFinally.kt")
                public void testNoFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/noFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("severalCatchClause.kt")
                public void testSeveralCatchClause() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/severalCatchClause.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleThrow.kt")
                public void testSimpleThrow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/simpleThrow.kt");
                    doTest(fileName);
                }

                @TestMetadata("synchonized.kt")
                public void testSynchonized() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/synchonized.kt");
                    doTest(fileName);
                }

                @TestMetadata("throwInFinally.kt")
                public void testThrowInFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/throwInFinally.kt");
                    doTest(fileName);
                }

                @TestMetadata("tryCatchInFinally.kt")
                public void testTryCatchInFinally() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/tryCatchInFinally.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Variables extends AbstractBlackBoxInlineCodegenTest {
                public void testAllFilesPresentInVariables() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("kt7792.kt")
                public void testKt7792() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables/kt7792.kt");
                    doTest(fileName);
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/private")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Private extends AbstractBlackBoxInlineCodegenTest {
        @TestMetadata("accessorForConst.kt")
        public void testAccessorForConst() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/accessorForConst.kt");
            doTest(fileName);
        }

        @TestMetadata("accessorStability.kt")
        public void testAccessorStability() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/accessorStability.kt");
            doTest(fileName);
        }

        @TestMetadata("accessorStabilityInClass.kt")
        public void testAccessorStabilityInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/accessorStabilityInClass.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInPrivate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/private"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("effectivePrivate.kt")
        public void testEffectivePrivate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/effectivePrivate.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6453.kt")
        public void testKt6453() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/kt6453.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8094.kt")
        public void testKt8094() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/kt8094.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8095.kt")
        public void testKt8095() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/kt8095.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedInPrivateClass.kt")
        public void testNestedInPrivateClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/nestedInPrivateClass.kt");
            doTest(fileName);
        }

        @TestMetadata("privateClass.kt")
        public void testPrivateClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/privateClass.kt");
            doTest(fileName);
        }

        @TestMetadata("privateClassExtensionLambda.kt")
        public void testPrivateClassExtensionLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/privateClassExtensionLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("privateInInlineInMultiFileFacade.kt")
        public void testPrivateInInlineInMultiFileFacade() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/privateInInlineInMultiFileFacade.kt");
            doTest(fileName);
        }

        @TestMetadata("privateInline.kt")
        public void testPrivateInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/private/privateInline.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/property")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Property extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("property.kt")
        public void testProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/property/property.kt");
            doTest(fileName);
        }

        @TestMetadata("reifiedVal.kt")
        public void testReifiedVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/property/reifiedVal.kt");
            doTest(fileName);
        }

        @TestMetadata("reifiedVar.kt")
        public void testReifiedVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/property/reifiedVar.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/property/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleExtension.kt")
        public void testSimpleExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/property/simpleExtension.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/reified")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Reified extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInReified() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/reified"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("capturedLambda.kt")
        public void testCapturedLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/capturedLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedLambda2.kt")
        public void testCapturedLambda2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/capturedLambda2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11081.kt")
        public void testKt11081() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/kt11081.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11677.kt")
        public void testKt11677() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/kt11677.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6988.kt")
        public void testKt6988() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/kt6988.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6988_2.kt")
        public void testKt6988_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/kt6988_2.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6990.kt")
        public void testKt6990() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/kt6990.kt");
            doTest(fileName);
        }

        @TestMetadata("kt7017.kt")
        public void testKt7017() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/kt7017.kt");
            doTest(fileName);
        }

        @TestMetadata("kt8047.kt")
        public void testKt8047() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/kt8047.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9637.kt")
        public void testKt9637() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/kt9637.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9637_2.kt")
        public void testKt9637_2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/kt9637_2.kt");
            doTest(fileName);
        }

        @TestMetadata("packages.kt")
        public void testPackages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/packages.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/boxInline/reified/checkCast")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CheckCast extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInCheckCast() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/checkCast"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("chain.kt")
            public void testChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/checkCast/chain.kt");
                doTest(fileName);
            }

            @TestMetadata("kt8043.kt")
            public void testKt8043() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/checkCast/kt8043.kt");
                doTest(fileName);
            }

            @TestMetadata("maxStack.kt")
            public void testMaxStack() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/checkCast/maxStack.kt");
                doTest(fileName);
            }

            @TestMetadata("nullable.kt")
            public void testNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/checkCast/nullable.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/checkCast/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleSafe.kt")
            public void testSimpleSafe() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/checkCast/simpleSafe.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/reified/isCheck")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IsCheck extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInIsCheck() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/isCheck"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("chain.kt")
            public void testChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/isCheck/chain.kt");
                doTest(fileName);
            }

            @TestMetadata("nullable.kt")
            public void testNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/isCheck/nullable.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/reified/isCheck/simple.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/signature")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Signature extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInSignature() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/signature"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inProjectionSubstitution.kt")
        public void testInProjectionSubstitution() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/signature/inProjectionSubstitution.kt");
            doTest(fileName);
        }

        @TestMetadata("outProjectionSubstitution.kt")
        public void testOutProjectionSubstitution() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/signature/outProjectionSubstitution.kt");
            doTest(fileName);
        }

        @TestMetadata("recursion.kt")
        public void testRecursion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/signature/recursion.kt");
            doTest(fileName);
        }

        @TestMetadata("sameFormalParameterName.kt")
        public void testSameFormalParameterName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/signature/sameFormalParameterName.kt");
            doTest(fileName);
        }

        @TestMetadata("sameReifiedFormalParameterName.kt")
        public void testSameReifiedFormalParameterName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/signature/sameReifiedFormalParameterName.kt");
            doTest(fileName);
        }

        @TestMetadata("starProjectionSubstitution.kt")
        public void testStarProjectionSubstitution() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/signature/starProjectionSubstitution.kt");
            doTest(fileName);
        }

        @TestMetadata("typeParameterInLambda.kt")
        public void testTypeParameterInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/signature/typeParameterInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("typeParametersSubstitution.kt")
        public void testTypeParametersSubstitution() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution.kt");
            doTest(fileName);
        }

        @TestMetadata("typeParametersSubstitution2.kt")
        public void testTypeParametersSubstitution2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution2.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/simple")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Simple extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInSimple() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/simple"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/classObject.kt");
            doTest(fileName);
        }

        @TestMetadata("destructuring.kt")
        public void testDestructuring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/destructuring.kt");
            doTest(fileName);
        }

        @TestMetadata("destructuringIndexClash.kt")
        public void testDestructuringIndexClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/destructuringIndexClash.kt");
            doTest(fileName);
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/extension.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionLambda.kt")
        public void testExtensionLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/extensionLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("funImportedFromObject.kt")
        public void testFunImportedFromObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/funImportedFromObject.kt");
            doTest(fileName);
        }

        @TestMetadata("params.kt")
        public void testParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/params.kt");
            doTest(fileName);
        }

        @TestMetadata("propImportedFromObject.kt")
        public void testPropImportedFromObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/propImportedFromObject.kt");
            doTest(fileName);
        }

        @TestMetadata("rootConstructor.kt")
        public void testRootConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/rootConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/safeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("severalClosures.kt")
        public void testSeveralClosures() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/severalClosures.kt");
            doTest(fileName);
        }

        @TestMetadata("severalUsage.kt")
        public void testSeveralUsage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/severalUsage.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleDouble.kt")
        public void testSimpleDouble() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/simpleDouble.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleEnum.kt")
        public void testSimpleEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/simpleEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleGenerics.kt")
        public void testSimpleGenerics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/simpleGenerics.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleInt.kt")
        public void testSimpleInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/simpleInt.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleLambda.kt")
        public void testSimpleLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/simpleLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/simpleObject.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/simple/vararg.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/smap")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Smap extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInSmap() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/smap"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assertion.kt")
        public void testAssertion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/assertion.kt");
            doTest(fileName);
        }

        @TestMetadata("classFromDefaultPackage.kt")
        public void testClassFromDefaultPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/classFromDefaultPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("oneFile.kt")
        public void testOneFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/oneFile.kt");
            doTest(fileName);
        }

        @TestMetadata("smap.kt")
        public void testSmap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/smap.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/boxInline/smap/anonymous")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Anonymous extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInAnonymous() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/anonymous"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/anonymous/lambda.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaOnCallSite.kt")
            public void testLambdaOnCallSite() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnCallSite.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaOnInlineCallSite.kt")
            public void testLambdaOnInlineCallSite() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnInlineCallSite.kt");
                doTest(fileName);
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/anonymous/object.kt");
                doTest(fileName);
            }

            @TestMetadata("objectOnCallSite.kt")
            public void testObjectOnCallSite() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/anonymous/objectOnCallSite.kt");
                doTest(fileName);
            }

            @TestMetadata("objectOnInlineCallSite.kt")
            public void testObjectOnInlineCallSite() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite.kt");
                doTest(fileName);
            }

            @TestMetadata("objectOnInlineCallSite2.kt")
            public void testObjectOnInlineCallSite2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite2.kt");
                doTest(fileName);
            }

            @TestMetadata("objectOnInlineCallSiteWithCapture.kt")
            public void testObjectOnInlineCallSiteWithCapture() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSiteWithCapture.kt");
                doTest(fileName);
            }

            @TestMetadata("severalMappingsForDefaultFile.kt")
            public void testSeveralMappingsForDefaultFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/anonymous/severalMappingsForDefaultFile.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/smap/inlineOnly")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InlineOnly extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInInlineOnly() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/inlineOnly"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("noSmap.kt")
            public void testNoSmap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmap.kt");
                doTest(fileName);
            }

            @TestMetadata("reified.kt")
            public void testReified() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/inlineOnly/reified.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/smap/newsmap")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Newsmap extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInNewsmap() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/newsmap"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("differentMapping.kt")
            public void testDifferentMapping() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/newsmap/differentMapping.kt");
                doTest(fileName);
            }

            @TestMetadata("mappingInInlineFunLambda.kt")
            public void testMappingInInlineFunLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/newsmap/mappingInInlineFunLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("mappingInSubInlineLambda.kt")
            public void testMappingInSubInlineLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("mappingInSubInlineLambdaSameFileInline.kt")
            public void testMappingInSubInlineLambdaSameFileInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambdaSameFileInline.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/codegen/boxInline/smap/resolve")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Resolve extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInResolve() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/resolve"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("inlineComponent.kt")
            public void testInlineComponent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/resolve/inlineComponent.kt");
                doTest(fileName);
            }

            @TestMetadata("inlineIterator.kt")
            public void testInlineIterator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/smap/resolve/inlineIterator.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/special")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Special extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInSpecial() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/special"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("identityCheck.kt")
        public void testIdentityCheck() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/special/identityCheck.kt");
            doTest(fileName);
        }

        @TestMetadata("ifBranches.kt")
        public void testIfBranches() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/special/ifBranches.kt");
            doTest(fileName);
        }

        @TestMetadata("iinc.kt")
        public void testIinc() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/special/iinc.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineChain.kt")
        public void testInlineChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/special/inlineChain.kt");
            doTest(fileName);
        }

        @TestMetadata("plusAssign.kt")
        public void testPlusAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/special/plusAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("stackHeightBug.kt")
        public void testStackHeightBug() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/special/stackHeightBug.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/stackOnReturn")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StackOnReturn extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInStackOnReturn() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/stackOnReturn"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("elvis.kt")
        public void testElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/elvis.kt");
            doTest(fileName);
        }

        @TestMetadata("ifThenElse.kt")
        public void testIfThenElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/ifThenElse.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11499.kt")
        public void testKt11499() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/kt11499.kt");
            doTest(fileName);
        }

        @TestMetadata("mixedTypesOnStack1.kt")
        public void testMixedTypesOnStack1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack1.kt");
            doTest(fileName);
        }

        @TestMetadata("mixedTypesOnStack2.kt")
        public void testMixedTypesOnStack2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack2.kt");
            doTest(fileName);
        }

        @TestMetadata("mixedTypesOnStack3.kt")
        public void testMixedTypesOnStack3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack3.kt");
            doTest(fileName);
        }

        @TestMetadata("nonLocalReturn1.kt")
        public void testNonLocalReturn1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn1.kt");
            doTest(fileName);
        }

        @TestMetadata("nonLocalReturn2.kt")
        public void testNonLocalReturn2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn2.kt");
            doTest(fileName);
        }

        @TestMetadata("nonLocalReturn3.kt")
        public void testNonLocalReturn3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn3.kt");
            doTest(fileName);
        }

        @TestMetadata("returnLong.kt")
        public void testReturnLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/returnLong.kt");
            doTest(fileName);
        }

        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/stackOnReturn/tryFinally.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/syntheticAccessors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SyntheticAccessors extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInSyntheticAccessors() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constField.kt")
        public void testConstField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/constField.kt");
            doTest(fileName);
        }

        @TestMetadata("packagePrivateMembers.kt")
        public void testPackagePrivateMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/packagePrivateMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyModifiers.kt")
        public void testPropertyModifiers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/propertyModifiers.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedMembers.kt")
        public void testProtectedMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedMembersFromSuper.kt")
        public void testProtectedMembersFromSuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembersFromSuper.kt");
            doTest(fileName);
        }

        @TestMetadata("superCall.kt")
        public void testSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/superCall.kt");
            doTest(fileName);
        }

        @TestMetadata("superProperty.kt")
        public void testSuperProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/superProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class WithinInlineLambda extends AbstractBlackBoxInlineCodegenTest {
            public void testAllFilesPresentInWithinInlineLambda() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("directFieldAccess.kt")
            public void testDirectFieldAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccess.kt");
                doTest(fileName);
            }

            @TestMetadata("directFieldAccessInCrossInline.kt")
            public void testDirectFieldAccessInCrossInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccessInCrossInline.kt");
                doTest(fileName);
            }

            @TestMetadata("privateCall.kt")
            public void testPrivateCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateCall.kt");
                doTest(fileName);
            }

            @TestMetadata("privateInCrossInline.kt")
            public void testPrivateInCrossInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInCrossInline.kt");
                doTest(fileName);
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superCall.kt");
                doTest(fileName);
            }

            @TestMetadata("superInCrossInline.kt")
            public void testSuperInCrossInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superInCrossInline.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/trait")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Trait extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInTrait() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/trait"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("trait.kt")
        public void testTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/trait/trait.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/boxInline/tryCatchFinally")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TryCatchFinally extends AbstractBlackBoxInlineCodegenTest {
        public void testAllFilesPresentInTryCatchFinally() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/boxInline/tryCatchFinally"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt5863.kt")
        public void testKt5863() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/tryCatchFinally/kt5863.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatch.kt")
        public void testTryCatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatch2.kt")
        public void testTryCatch2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch2.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatchFinally.kt");
            doTest(fileName);
        }
    }
}
