/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/bytecodeText")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BytecodeTextTestGenerated extends AbstractBytecodeTextTest {
    @TestMetadata("accessorForOverridenVal.kt")
    public void testAccessorForOverridenVal() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/accessorForOverridenVal.kt");
        doTest(fileName);
    }

    @TestMetadata("accessorForProtected.kt")
    public void testAccessorForProtected() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/accessorForProtected.kt");
        doTest(fileName);
    }

    @TestMetadata("accessorNaming.kt")
    public void testAccessorNaming() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/accessorNaming.kt");
        doTest(fileName);
    }

    public void testAllFilesPresentInBytecodeText() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("annotationDefaultValue.kt")
    public void testAnnotationDefaultValue() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/annotationDefaultValue.kt");
        doTest(fileName);
    }

    @TestMetadata("annotationJavaRetentionPolicyRuntime.kt")
    public void testAnnotationJavaRetentionPolicyRuntime() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/annotationJavaRetentionPolicyRuntime.kt");
        doTest(fileName);
    }

    @TestMetadata("annotationRetentionPolicyClass.kt")
    public void testAnnotationRetentionPolicyClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyClass.kt");
        doTest(fileName);
    }

    @TestMetadata("annotationRetentionPolicyRuntime.kt")
    public void testAnnotationRetentionPolicyRuntime() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyRuntime.kt");
        doTest(fileName);
    }

    @TestMetadata("annotationRetentionPolicySource.kt")
    public void testAnnotationRetentionPolicySource() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/annotationRetentionPolicySource.kt");
        doTest(fileName);
    }

    @TestMetadata("bridgeForFakeOverride.kt")
    public void testBridgeForFakeOverride() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/bridgeForFakeOverride.kt");
        doTest(fileName);
    }

    @TestMetadata("callableReferenceInline.kt")
    public void testCallableReferenceInline() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/callableReferenceInline.kt");
        doTest(fileName);
    }

    @TestMetadata("charConstant.kt")
    public void testCharConstant() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/charConstant.kt");
        doTest(fileName);
    }

    @TestMetadata("componentEvaluatesOnlyOnce.kt")
    public void testComponentEvaluatesOnlyOnce() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/componentEvaluatesOnlyOnce.kt");
        doTest(fileName);
    }

    @TestMetadata("constClosureOptimization.kt")
    public void testConstClosureOptimization() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constClosureOptimization.kt");
        doTest(fileName);
    }

    @TestMetadata("constCoroutine.kt")
    public void testConstCoroutine() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constCoroutine.kt");
        doTest(fileName);
    }

    @TestMetadata("falseSmartCast.kt")
    public void testFalseSmartCast() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/falseSmartCast.kt");
        doTest(fileName);
    }

    @TestMetadata("inlineFromOtherModule.kt")
    public void testInlineFromOtherModule() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inlineFromOtherModule.kt");
        doTest(fileName);
    }

    @TestMetadata("inlineJavaStaticFields.kt")
    public void testInlineJavaStaticFields() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inlineJavaStaticFields.kt");
        doTest(fileName);
    }

    @TestMetadata("intConstantNotNull.kt")
    public void testIntConstantNotNull() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/intConstantNotNull.kt");
        doTest(fileName);
    }

    @TestMetadata("intConstantNullable.kt")
    public void testIntConstantNullable() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/intConstantNullable.kt");
        doTest(fileName);
    }

    @TestMetadata("intConstantNullableSafeCall.kt")
    public void testIntConstantNullableSafeCall() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/intConstantNullableSafeCall.kt");
        doTest(fileName);
    }

    @TestMetadata("intConstantSafeCall.kt")
    public void testIntConstantSafeCall() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/intConstantSafeCall.kt");
        doTest(fileName);
    }

    @TestMetadata("intRangeNoBoxing.kt")
    public void testIntRangeNoBoxing() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/intRangeNoBoxing.kt");
        doTest(fileName);
    }

    @TestMetadata("interfaceDefaultImpl.kt")
    public void testInterfaceDefaultImpl() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/interfaceDefaultImpl.kt");
        doTest(fileName);
    }

    @TestMetadata("isArrayOf.kt")
    public void testIsArrayOf() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/isArrayOf.kt");
        doTest(fileName);
    }

    @TestMetadata("javaExtensionPropertyIntrinsic.kt")
    public void testJavaExtensionPropertyIntrinsic() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/javaExtensionPropertyIntrinsic.kt");
        doTest(fileName);
    }

    @TestMetadata("javaStatics.kt")
    public void testJavaStatics() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/javaStatics.kt");
        doTest(fileName);
    }

    @TestMetadata("jvmField.kt")
    public void testJvmField() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/jvmField.kt");
        doTest(fileName);
    }

    @TestMetadata("kt10259.kt")
    public void testKt10259() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt10259.kt");
        doTest(fileName);
    }

    @TestMetadata("kt10259_2.kt")
    public void testKt10259_2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt10259_2.kt");
        doTest(fileName);
    }

    @TestMetadata("kt10259_3.kt")
    public void testKt10259_3() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt10259_3.kt");
        doTest(fileName);
    }

    @TestMetadata("kt2202.kt")
    public void testKt2202() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt2202.kt");
        doTest(fileName);
    }

    @TestMetadata("kt2887.kt")
    public void testKt2887() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt2887.kt");
        doTest(fileName);
    }

    @TestMetadata("kt3845.kt")
    public void testKt3845() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt3845.kt");
        doTest(fileName);
    }

    @TestMetadata("kt5016.kt")
    public void testKt5016() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt5016.kt");
        doTest(fileName);
    }

    @TestMetadata("kt5016int.kt")
    public void testKt5016int() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt5016int.kt");
        doTest(fileName);
    }

    @TestMetadata("kt5016intOrNull.kt")
    public void testKt5016intOrNull() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt5016intOrNull.kt");
        doTest(fileName);
    }

    @TestMetadata("kt7769.kt")
    public void testKt7769() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt7769.kt");
        doTest(fileName);
    }

    @TestMetadata("kt9603.kt")
    public void testKt9603() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/kt9603.kt");
        doTest(fileName);
    }

    @TestMetadata("noFlagAnnotations.kt")
    public void testNoFlagAnnotations() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/noFlagAnnotations.kt");
        doTest(fileName);
    }

    @TestMetadata("noNumberCheckCast.kt")
    public void testNoNumberCheckCast() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/noNumberCheckCast.kt");
        doTest(fileName);
    }

    @TestMetadata("noSuperCheckInDefaultConstuctor.kt")
    public void testNoSuperCheckInDefaultConstuctor() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/noSuperCheckInDefaultConstuctor.kt");
        doTest(fileName);
    }

    @TestMetadata("noWrapperForMethodReturningPrimitive.kt")
    public void testNoWrapperForMethodReturningPrimitive() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/noWrapperForMethodReturningPrimitive.kt");
        doTest(fileName);
    }

    @TestMetadata("partMembersCall.kt")
    public void testPartMembersCall() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/partMembersCall.kt");
        doTest(fileName);
    }

    @TestMetadata("partMembersInline.kt")
    public void testPartMembersInline() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/partMembersInline.kt");
        doTest(fileName);
    }

    @TestMetadata("preEvaluateInlineJavaStaticFields.kt")
    public void testPreEvaluateInlineJavaStaticFields() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/preEvaluateInlineJavaStaticFields.kt");
        doTest(fileName);
    }

    @TestMetadata("prefixIntVarIncrement.kt")
    public void testPrefixIntVarIncrement() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/prefixIntVarIncrement.kt");
        doTest(fileName);
    }

    @TestMetadata("privateDefaultArgs.kt")
    public void testPrivateDefaultArgs() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/privateDefaultArgs.kt");
        doTest(fileName);
    }

    @TestMetadata("redundantGotoRemoving.kt")
    public void testRedundantGotoRemoving() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/redundantGotoRemoving.kt");
        doTest(fileName);
    }

    @TestMetadata("redundantInitializer.kt")
    public void testRedundantInitializer() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/redundantInitializer.kt");
        doTest(fileName);
    }

    @TestMetadata("redundantInitializerNumber.kt")
    public void testRedundantInitializerNumber() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/redundantInitializerNumber.kt");
        doTest(fileName);
    }

    @TestMetadata("reifiedAsCheck.kt")
    public void testReifiedAsCheck() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/reifiedAsCheck.kt");
        doTest(fileName);
    }

    @TestMetadata("reifiedAsCheckWithNullable.kt")
    public void testReifiedAsCheckWithNullable() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/reifiedAsCheckWithNullable.kt");
        doTest(fileName);
    }

    @TestMetadata("reifiedIsCheck.kt")
    public void testReifiedIsCheck() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/reifiedIsCheck.kt");
        doTest(fileName);
    }

    @TestMetadata("reifiedIsCheckWithNullable.kt")
    public void testReifiedIsCheckWithNullable() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/reifiedIsCheckWithNullable.kt");
        doTest(fileName);
    }

    @TestMetadata("safeAsWithMutable.kt")
    public void testSafeAsWithMutable() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/safeAsWithMutable.kt");
        doTest(fileName);
    }

    @TestMetadata("superFlagInMultiFileFacade.kt")
    public void testSuperFlagInMultiFileFacade() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/superFlagInMultiFileFacade.kt");
        doTest(fileName);
    }

    @TestMetadata("topLevelFunWithDefaultArgs.kt")
    public void testTopLevelFunWithDefaultArgs() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/topLevelFunWithDefaultArgs.kt");
        doTest(fileName);
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArgumentOrder extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("argumentReorder.kt")
        public void testArgumentReorder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/argumentOrder/argumentReorder.kt");
            doTest(fileName);
        }

        @TestMetadata("argumentReorderWithDefault.kt")
        public void testArgumentReorderWithDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/argumentOrder/argumentReorderWithDefault.kt");
            doTest(fileName);
        }

        @TestMetadata("sameOrder.kt")
        public void testSameOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("sameOrderWithDefault.kt")
        public void testSameOrderWithDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrderWithDefault.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BoxingOptimization extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInBoxingOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("casts.kt")
        public void testCasts() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/casts.kt");
            doTest(fileName);
        }

        @TestMetadata("checkcastAndInstanceOf.kt")
        public void testCheckcastAndInstanceOf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/checkcastAndInstanceOf.kt");
            doTest(fileName);
        }

        @TestMetadata("fold.kt")
        public void testFold() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/fold.kt");
            doTest(fileName);
        }

        @TestMetadata("kClassInAnnotation.kt")
        public void testKClassInAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotation.kt");
            doTest(fileName);
        }

        @TestMetadata("kClassInAnnotationEscaping.kt")
        public void testKClassInAnnotationEscaping() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotationEscaping.kt");
            doTest(fileName);
        }

        @TestMetadata("kt6842.kt")
        public void testKt6842() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/kt6842.kt");
            doTest(fileName);
        }

        @TestMetadata("kt7224.kt")
        public void testKt7224() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/kt7224.kt");
            doTest(fileName);
        }

        @TestMetadata("nullCheck.kt")
        public void testNullCheck() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/nullCheck.kt");
            doTest(fileName);
        }

        @TestMetadata("progressions.kt")
        public void testProgressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/progressions.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCallWithElvis.kt")
        public void testSafeCallWithElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvis.kt");
            doTest(fileName);
        }

        @TestMetadata("severalInlines.kt")
        public void testSeveralInlines() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/severalInlines.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleUninitializedMerge.kt")
        public void testSimpleUninitializedMerge() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/simpleUninitializedMerge.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeRemoving.kt")
        public void testUnsafeRemoving() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/unsafeRemoving.kt");
            doTest(fileName);
        }

        @TestMetadata("variableClash.kt")
        public void testVariableClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/variableClash.kt");
            doTest(fileName);
        }

        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization/variables.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BuiltinFunctions extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInBuiltinFunctions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("charSequence.kt")
        public void testCharSequence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/charSequence.kt");
            doTest(fileName);
        }

        @TestMetadata("contains.kt")
        public void testContains() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/contains.kt");
            doTest(fileName);
        }

        @TestMetadata("removeAt.kt")
        public void testRemoveAt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/removeAt.kt");
            doTest(fileName);
        }

        @TestMetadata("size.kt")
        public void testSize() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/size.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class GenericParameterBridge extends AbstractBytecodeTextTest {
            @TestMetadata("abstractList.kt")
            public void testAbstractList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/abstractList.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInGenericParameterBridge() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("IntMC.kt")
            public void testIntMC() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/IntMC.kt");
                doTest(fileName);
            }

            @TestMetadata("mutableCollection.kt")
            public void testMutableCollection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableCollection.kt");
                doTest(fileName);
            }

            @TestMetadata("mutableSetInterfaces.kt")
            public void testMutableSetInterfaces() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableSetInterfaces.kt");
                doTest(fileName);
            }

            @TestMetadata("notNullAnyMC.kt")
            public void testNotNullAnyMC() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullAnyMC.kt");
                doTest(fileName);
            }

            @TestMetadata("notNullParamMC.kt")
            public void testNotNullParamMC() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullParamMC.kt");
                doTest(fileName);
            }

            @TestMetadata("nullableAnyMC.kt")
            public void testNullableAnyMC() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/nullableAnyMC.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CoercionToUnitOptimization extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInCoercionToUnitOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt14360.kt")
        public void testKt14360() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/kt14360.kt");
            doTest(fileName);
        }

        @TestMetadata("nopInlineFuns.kt")
        public void testNopInlineFuns() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/nopInlineFuns.kt");
            doTest(fileName);
        }

        @TestMetadata("returnsUnit.kt")
        public void testReturnsUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/returnsUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCallWithReturnValue.kt")
        public void testSafeCallWithReturnValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCallWithReturnValue.kt");
            doTest(fileName);
        }

        @TestMetadata("safeLet.kt")
        public void testSafeLet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeLet.kt");
            doTest(fileName);
        }

        @TestMetadata("tryInlined.kt")
        public void testTryInlined() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/tryInlined.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/conditions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Conditions extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInConditions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/conditions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("conjuction.kt")
        public void testConjuction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/conditions/conjuction.kt");
            doTest(fileName);
        }

        @TestMetadata("disjunction.kt")
        public void testDisjunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/conditions/disjunction.kt");
            doTest(fileName);
        }

        @TestMetadata("negatedConjuction.kt")
        public void testNegatedConjuction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/conditions/negatedConjuction.kt");
            doTest(fileName);
        }

        @TestMetadata("negatedDisjunction.kt")
        public void testNegatedDisjunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/conditions/negatedDisjunction.kt");
            doTest(fileName);
        }

        @TestMetadata("negatedNullCompare.kt")
        public void testNegatedNullCompare() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompare.kt");
            doTest(fileName);
        }

        @TestMetadata("negatedZeroCompare.kt")
        public void testNegatedZeroCompare() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompare.kt");
            doTest(fileName);
        }

        @TestMetadata("nullCompare.kt")
        public void testNullCompare() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/conditions/nullCompare.kt");
            doTest(fileName);
        }

        @TestMetadata("zeroCompare.kt")
        public void testZeroCompare() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/conditions/zeroCompare.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/constProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConstProperty extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInConstProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("noInline.kt")
        public void testNoInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constProperty/noInline.kt");
            doTest(fileName);
        }

        @TestMetadata("noInlineInCmp.kt")
        public void testNoInlineInCmp() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constProperty/noInlineInCmp.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/constants")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constants extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInConstants() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constants"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("byte.kt")
        public void testByte() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constants/byte.kt");
            doTest(fileName);
        }

        @TestMetadata("kt9532.kt")
        public void testKt9532() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constants/kt9532.kt");
            doTest(fileName);
        }

        @TestMetadata("noInlineNonConst.kt")
        public void testNoInlineNonConst() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constants/noInlineNonConst.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableByteAndShort.kt")
        public void testNullableByteAndShort() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constants/nullableByteAndShort.kt");
            doTest(fileName);
        }

        @TestMetadata("partialString.kt")
        public void testPartialString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constants/partialString.kt");
            doTest(fileName);
        }

        @TestMetadata("short.kt")
        public void testShort() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constants/short.kt");
            doTest(fileName);
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/constants/string.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Coroutines extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInCoroutines() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTable.kt");
            doTest(fileName);
        }

        @TestMetadata("varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTableSameSort.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntLikeVarSpilling extends AbstractBytecodeTextTest {
            public void testAllFilesPresentInIntLikeVarSpilling() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("complicatedMerge.kt")
            public void testComplicatedMerge() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/complicatedMerge.kt");
                doTest(fileName);
            }

            @TestMetadata("i2bResult.kt")
            public void testI2bResult() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/i2bResult.kt");
                doTest(fileName);
            }

            @TestMetadata("loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
                doTest(fileName);
            }

            @TestMetadata("loadFromByteArray.kt")
            public void testLoadFromByteArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
                doTest(fileName);
            }

            @TestMetadata("noVariableInTable.kt")
            public void testNoVariableInTable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/noVariableInTable.kt");
                doTest(fileName);
            }

            @TestMetadata("sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
                doTest(fileName);
            }

            @TestMetadata("usedInArrayStore.kt")
            public void testUsedInArrayStore() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
                doTest(fileName);
            }

            @TestMetadata("usedInMethodCall.kt")
            public void testUsedInMethodCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
                doTest(fileName);
            }

            @TestMetadata("usedInPutfield.kt")
            public void testUsedInPutfield() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInPutfield.kt");
                doTest(fileName);
            }

            @TestMetadata("usedInVarStore.kt")
            public void testUsedInVarStore() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInVarStore.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeadCodeElimination extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInDeadCodeElimination() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayConstructor.kt")
        public void testArrayConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination/arrayConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("boxing.kt")
        public void testBoxing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxing.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyVariableRange.kt")
        public void testEmptyVariableRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination/emptyVariableRange.kt");
            doTest(fileName);
        }

        @TestMetadata("kt14357.kt")
        public void testKt14357() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination/kt14357.kt");
            doTest(fileName);
        }

        @TestMetadata("lastReturn.kt")
        public void testLastReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination/lastReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("literal.kt")
        public void testLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination/literal.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleConstructor.kt")
        public void testSimpleConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleConstructorNotRedundant.kt")
        public void testSimpleConstructorNotRedundant() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundant.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/directInvoke")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DirectInvoke extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInDirectInvoke() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/directInvoke"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callableReference.kt")
        public void testCallableReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/directInvoke/callableReference.kt");
            doTest(fileName);
        }

        @TestMetadata("inplaceClosure.kt")
        public void testInplaceClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/directInvoke/inplaceClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/directInvoke/localFun.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ForLoop extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInForLoop() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("forInRangeWithImplicitReceiver.kt")
        public void testForInRangeWithImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithImplicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("forIntInDownTo.kt")
        public void testForIntInDownTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/forIntInDownTo.kt");
            doTest(fileName);
        }

        @TestMetadata("loopVarInterval.kt")
        public void testLoopVarInterval() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/loopVarInterval.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveLiteralRange1.kt")
        public void testPrimitiveLiteralRange1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange1.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveLiteralRange2.kt")
        public void testPrimitiveLiteralRange2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange2.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveProgression.kt")
        public void testPrimitiveProgression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/primitiveProgression.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveRange.kt")
        public void testPrimitiveRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/primitiveRange.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIndices")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInIndices extends AbstractBytecodeTextTest {
            public void testAllFilesPresentInForInIndices() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIndices"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("forInCharSequenceIndices.kt")
            public void testForInCharSequenceIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forInCollectionImplicitReceiverIndices.kt")
            public void testForInCollectionImplicitReceiverIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionImplicitReceiverIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forInCollectionIndices.kt")
            public void testForInCollectionIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forInNonOptimizedIndices.kt")
            public void testForInNonOptimizedIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInNonOptimizedIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forInObjectArrayIndices.kt")
            public void testForInObjectArrayIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInObjectArrayIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("forInPrimitiveArrayIndices.kt")
            public void testForInPrimitiveArrayIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInPrimitiveArrayIndices.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/inline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inline extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inlineReturnsNothing1.kt")
        public void testInlineReturnsNothing1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing1.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineReturnsNothing2.kt")
        public void testInlineReturnsNothing2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing2.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineReturnsNothing3.kt")
        public void testInlineReturnsNothing3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing3.kt");
            doTest(fileName);
        }

        @TestMetadata("linenumberForNoParametersArgumentCallInExpression.kt")
        public void testLinenumberForNoParametersArgumentCallInExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/linenumberForNoParametersArgumentCallInExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("linenumberForOneParametersArgumentCall.kt")
        public void testLinenumberForOneParametersArgumentCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/linenumberForOneParametersArgumentCall.kt");
            doTest(fileName);
        }

        @TestMetadata("noSynAccessor.kt")
        public void testNoSynAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/noSynAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("noSynAccessorToDirectFieldAccess.kt")
        public void testNoSynAccessorToDirectFieldAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToDirectFieldAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("noSynAccessorToSuper.kt")
        public void testNoSynAccessorToSuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToSuper.kt");
            doTest(fileName);
        }

        @TestMetadata("notSplitedExceptionTable.kt")
        public void testNotSplitedExceptionTable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/notSplitedExceptionTable.kt");
            doTest(fileName);
        }

        @TestMetadata("reifiedSafeAsWithMutable.kt")
        public void testReifiedSafeAsWithMutable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/reifiedSafeAsWithMutable.kt");
            doTest(fileName);
        }

        @TestMetadata("remappedLocalVar.kt")
        public void testRemappedLocalVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/remappedLocalVar.kt");
            doTest(fileName);
        }

        @TestMetadata("removedFinallyMarkers.kt")
        public void testRemovedFinallyMarkers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/removedFinallyMarkers.kt");
            doTest(fileName);
        }

        @TestMetadata("splitedExceptionTable.kt")
        public void testSplitedExceptionTable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/splitedExceptionTable.kt");
            doTest(fileName);
        }

        @TestMetadata("whenMappingOnCallSite.kt")
        public void testWhenMappingOnCallSite() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/whenMappingOnCallSite.kt");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/inline/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractBytecodeTextTest {
            public void testAllFilesPresentInProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/inline/property/simple.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/interfaces")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Interfaces extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInInterfaces() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/interfaces"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("firstInheritedMethodIsAbstract.kt")
        public void testFirstInheritedMethodIsAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/interfaces/firstInheritedMethodIsAbstract.kt");
            doTest(fileName);
        }

        @TestMetadata("noAnyMethodsOnInterfaceInheritance.kt")
        public void testNoAnyMethodsOnInterfaceInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/interfaces/noAnyMethodsOnInterfaceInheritance.kt");
            doTest(fileName);
        }

        @TestMetadata("noPrivateMemberInJavaInterface.kt")
        public void testNoPrivateMemberInJavaInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/interfaces/noPrivateMemberInJavaInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("traitImplGeneratedOnce.kt")
        public void testTraitImplGeneratedOnce() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/interfaces/traitImplGeneratedOnce.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/jackAndJill")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JackAndJill extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInJackAndJill() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jackAndJill"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inlineDefaultBody.kt")
        public void testInlineDefaultBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/jackAndJill/inlineDefaultBody.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineDefaultBodyInClass.kt")
        public void testInlineDefaultBodyInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/jackAndJill/inlineDefaultBodyInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inlinedConstuctor.kt")
        public void testInlinedConstuctor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/jackAndJill/inlinedConstuctor.kt");
            doTest(fileName);
        }

        @TestMetadata("inlinedConstuctorWithSuperCallParams.kt")
        public void testInlinedConstuctorWithSuperCallParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/jackAndJill/inlinedConstuctorWithSuperCallParams.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/lazyCodegen")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LazyCodegen extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInLazyCodegen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lazyCodegen"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("negateConst.kt")
        public void testNegateConst() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/lazyCodegen/negateConst.kt");
            doTest(fileName);
        }

        @TestMetadata("negateConstantCompare.kt")
        public void testNegateConstantCompare() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/lazyCodegen/negateConstantCompare.kt");
            doTest(fileName);
        }

        @TestMetadata("negateObjectComp.kt")
        public void testNegateObjectComp() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectComp.kt");
            doTest(fileName);
        }

        @TestMetadata("negateObjectCompChaing.kt")
        public void testNegateObjectCompChaing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectCompChaing.kt");
            doTest(fileName);
        }

        @TestMetadata("negateVar.kt")
        public void testNegateVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVar.kt");
            doTest(fileName);
        }

        @TestMetadata("negateVarChain.kt")
        public void testNegateVarChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVarChain.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/lineNumbers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LineNumbers extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInLineNumbers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lineNumbers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ifElse.kt")
        public void testIfElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/lineNumbers/ifElse.kt");
            doTest(fileName);
        }

        @TestMetadata("singleThen.kt")
        public void testSingleThen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/lineNumbers/singleThen.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatch.kt")
        public void testTryCatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/lineNumbers/tryCatch.kt");
            doTest(fileName);
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/lineNumbers/when.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultifileClasses extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("optimizedMultifileClassFacadeMethods.kt")
        public void testOptimizedMultifileClassFacadeMethods() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/multifileClasses/optimizedMultifileClassFacadeMethods.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/ranges")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Ranges extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInRanges() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ranges"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inNonMatchingRange.kt")
        public void testInNonMatchingRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/ranges/inNonMatchingRange.kt");
            doTest(fileName);
        }

        @TestMetadata("inOptimizableRange.kt")
        public void testInOptimizableRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/ranges/inOptimizableRange.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/statements")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Statements extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInStatements() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/statements"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ifSingleBranch.kt")
        public void testIfSingleBranch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/statements/ifSingleBranch.kt");
            doTest(fileName);
        }

        @TestMetadata("ifThenElse.kt")
        public void testIfThenElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/statements/ifThenElse.kt");
            doTest(fileName);
        }

        @TestMetadata("ifThenElseEmpty.kt")
        public void testIfThenElseEmpty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/statements/ifThenElseEmpty.kt");
            doTest(fileName);
        }

        @TestMetadata("labeled.kt")
        public void testLabeled() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/statements/labeled.kt");
            doTest(fileName);
        }

        @TestMetadata("statementsComposition.kt")
        public void testStatementsComposition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/statements/statementsComposition.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/statements/tryCatchFinally.kt");
            doTest(fileName);
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/statements/when.kt");
            doTest(fileName);
        }

        @TestMetadata("whenSubject.kt")
        public void testWhenSubject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/statements/whenSubject.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/staticFields")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StaticFields extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInStaticFields() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/staticFields"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/staticFields/classObject.kt");
            doTest(fileName);
        }

        @TestMetadata("classObjectSyntheticAccessor.kt")
        public void testClassObjectSyntheticAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/staticFields/classObjectSyntheticAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/staticFields/object.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/storeStackBeforeInline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StoreStackBeforeInline extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInStoreStackBeforeInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/storeStackBeforeInline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("differentTypes.kt")
        public void testDifferentTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/differentTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveMerge.kt")
        public void testPrimitiveMerge() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/primitiveMerge.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("unreachableMarker.kt")
        public void testUnreachableMarker() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/unreachableMarker.kt");
            doTest(fileName);
        }

        @TestMetadata("withLambda.kt")
        public void testWithLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/withLambda.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/stringOperations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StringOperations extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInStringOperations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/stringOperations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("concat.kt")
        public void testConcat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/stringOperations/concat.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolation.kt")
        public void testInterpolation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/stringOperations/interpolation.kt");
            doTest(fileName);
        }

        @TestMetadata("nonNullableStringPlus.kt")
        public void testNonNullableStringPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/stringOperations/nonNullableStringPlus.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableStringPlus.kt")
        public void testNullableStringPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/stringOperations/nullableStringPlus.kt");
            doTest(fileName);
        }

        @TestMetadata("plusAssign.kt")
        public void testPlusAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/stringOperations/plusAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveToString.kt")
        public void testPrimitiveToString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToString.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/when")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class When extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInWhen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/when"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("exhaustiveWhenInitialization.kt")
        public void testExhaustiveWhenInitialization() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenInitialization.kt");
            doTest(fileName);
        }

        @TestMetadata("exhaustiveWhenReturn.kt")
        public void testExhaustiveWhenReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("exhaustiveWhenUnit.kt")
        public void testExhaustiveWhenUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("exhaustiveWhenUnitStatement.kt")
        public void testExhaustiveWhenUnitStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnitStatement.kt");
            doTest(fileName);
        }

        @TestMetadata("integralWhenWithNoInlinedConstants.kt")
        public void testIntegralWhenWithNoInlinedConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/when/integralWhenWithNoInlinedConstants.kt");
            doTest(fileName);
        }

        @TestMetadata("sealedWhenInitialization.kt")
        public void testSealedWhenInitialization() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/when/sealedWhenInitialization.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WhenEnumOptimization extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInWhenEnumOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenEnumOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("bigEnum.kt")
        public void testBigEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization/bigEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("duplicatingItems.kt")
        public void testDuplicatingItems() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization/duplicatingItems.kt");
            doTest(fileName);
        }

        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization/expression.kt");
            doTest(fileName);
        }

        @TestMetadata("functionLiteralInTopLevel.kt")
        public void testFunctionLiteralInTopLevel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization/functionLiteralInTopLevel.kt");
            doTest(fileName);
        }

        @TestMetadata("importedEnumEntry.kt")
        public void testImportedEnumEntry() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization/importedEnumEntry.kt");
            doTest(fileName);
        }

        @TestMetadata("manyWhensWithinClass.kt")
        public void testManyWhensWithinClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization/manyWhensWithinClass.kt");
            doTest(fileName);
        }

        @TestMetadata("nonConstantEnum.kt")
        public void testNonConstantEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nonConstantEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("nullability.kt")
        public void testNullability() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nullability.kt");
            doTest(fileName);
        }

        @TestMetadata("subjectAny.kt")
        public void testSubjectAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization/subjectAny.kt");
            doTest(fileName);
        }

        @TestMetadata("withoutElse.kt")
        public void testWithoutElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization/withoutElse.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WhenStringOptimization extends AbstractBytecodeTextTest {
        public void testAllFilesPresentInWhenStringOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenStringOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("denseHashCode.kt")
        public void testDenseHashCode() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization/denseHashCode.kt");
            doTest(fileName);
        }

        @TestMetadata("duplicatingItems.kt")
        public void testDuplicatingItems() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItems.kt");
            doTest(fileName);
        }

        @TestMetadata("duplicatingItemsSameHashCode.kt")
        public void testDuplicatingItemsSameHashCode() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCode.kt");
            doTest(fileName);
        }

        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization/expression.kt");
            doTest(fileName);
        }

        @TestMetadata("nonInlinedConst.kt")
        public void testNonInlinedConst() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization/nonInlinedConst.kt");
            doTest(fileName);
        }

        @TestMetadata("nullability.kt")
        public void testNullability() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization/nullability.kt");
            doTest(fileName);
        }

        @TestMetadata("sameHashCode.kt")
        public void testSameHashCode() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization/sameHashCode.kt");
            doTest(fileName);
        }

        @TestMetadata("statement.kt")
        public void testStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization/statement.kt");
            doTest(fileName);
        }
    }
}
