/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.ir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/ir/irCfg")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class IrCfgTestCaseGenerated extends AbstractIrCfgTestCase {
    public void testAllFilesPresentInIrCfg() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/ir/irCfg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("expressionFun.kt")
    public void testExpressionFun() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/expressionFun.kt");
        doTest(fileName);
    }

    @TestMetadata("expressionUnit.kt")
    public void testExpressionUnit() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/expressionUnit.kt");
        doTest(fileName);
    }

    @TestMetadata("returnUnit.kt")
    public void testReturnUnit() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/returnUnit.kt");
        doTest(fileName);
    }

    @TestMetadata("sequentialFun.kt")
    public void testSequentialFun() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/sequentialFun.kt");
        doTest(fileName);
    }

    @TestMetadata("simpleFun.kt")
    public void testSimpleFun() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/simpleFun.kt");
        doTest(fileName);
    }

    @TestMetadata("simpleReturn.kt")
    public void testSimpleReturn() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/simpleReturn.kt");
        doTest(fileName);
    }

    @TestMetadata("compiler/testData/ir/irCfg/loop")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Loop extends AbstractIrCfgTestCase {
        public void testAllFilesPresentInLoop() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/ir/irCfg/loop"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("digitCount.kt")
        public void testDigitCount() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/loop/digitCount.kt");
            doTest(fileName);
        }

        @TestMetadata("factorial.kt")
        public void testFactorial() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/loop/factorial.kt");
            doTest(fileName);
        }

        @TestMetadata("isPerfect.kt")
        public void testIsPerfect() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/loop/isPerfect.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/ir/irCfg/when")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class When extends AbstractIrCfgTestCase {
        public void testAllFilesPresentInWhen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/ir/irCfg/when"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("cascadeIf.kt")
        public void testCascadeIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/when/cascadeIf.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyWhen.kt")
        public void testEmptyWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/when/emptyWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionIf.kt")
        public void testExpressionIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/when/expressionIf.kt");
            doTest(fileName);
        }

        @TestMetadata("ifChain.kt")
        public void testIfChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/when/ifChain.kt");
            doTest(fileName);
        }

        @TestMetadata("whenReturn.kt")
        public void testWhenReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/ir/irCfg/when/whenReturn.kt");
            doTest(fileName);
        }
    }
}
