/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.jvm.runtime;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class JvmRuntimeDescriptorLoaderTestGenerated extends AbstractJvmRuntimeDescriptorLoaderTest {
    @TestMetadata("compiler/testData/loadJava/compiledKotlin")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CompiledKotlin extends AbstractJvmRuntimeDescriptorLoaderTest {
        public void testAllFilesPresentInCompiledKotlin() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/annotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotations extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AnnotatedAnnotation.kt")
            public void testAnnotatedAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/AnnotatedAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedMethod.kt")
            public void testAnnotatedMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/AnnotatedMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("AnnotationInAnnotationArguments.kt")
            public void testAnnotationInAnnotationArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/AnnotationInAnnotationArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("EnumArgumentWithCustomToString.kt")
            public void testEnumArgumentWithCustomToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/EnumArgumentWithCustomToString.kt");
                doTest(fileName);
            }

            @TestMetadata("MultiDimensionalArrayMethod.kt")
            public void testMultiDimensionalArrayMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/MultiDimensionalArrayMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("SimpleAnnotation.kt")
            public void testSimpleAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/SimpleAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("TargetedAnnotation.kt")
            public void testTargetedAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/TargetedAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classMembers")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ClassMembers extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInClassMembers() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/annotations/classMembers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ClassObjectPropertyField.kt")
                public void testClassObjectPropertyField() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classMembers/ClassObjectPropertyField.kt");
                    doTest(fileName);
                }

                @TestMetadata("Constructor.kt")
                public void testConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classMembers/Constructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("DelegatedProperty.kt")
                public void testDelegatedProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classMembers/DelegatedProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("EnumArgument.kt")
                public void testEnumArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classMembers/EnumArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("EnumEntry.kt")
                public void testEnumEntry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classMembers/EnumEntry.kt");
                    doTest(fileName);
                }

                @TestMetadata("Function.kt")
                public void testFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classMembers/Function.kt");
                    doTest(fileName);
                }

                @TestMetadata("Getter.kt")
                public void testGetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classMembers/Getter.kt");
                    doTest(fileName);
                }

                @TestMetadata("PropertyField.kt")
                public void testPropertyField() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classMembers/PropertyField.kt");
                    doTest(fileName);
                }

                @TestMetadata("Setter.kt")
                public void testSetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classMembers/Setter.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Classes extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInClasses() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/annotations/classes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("AnnotationInClassObject.kt")
                public void testAnnotationInClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/AnnotationInClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassInClassObject.kt")
                public void testClassInClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/ClassInClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassObject.kt")
                public void testClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/ClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassObjectInStaticNestedClass.kt")
                public void testClassObjectInStaticNestedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/ClassObjectInStaticNestedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("DataClass.kt")
                public void testDataClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/DataClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("Deprecated.kt")
                public void testDeprecated() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/Deprecated.kt");
                    doTest(fileName);
                }

                @TestMetadata("DollarsInAnnotationName.kt")
                public void testDollarsInAnnotationName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/DollarsInAnnotationName.kt");
                    doTest(fileName);
                }

                @TestMetadata("EnumArgument.kt")
                public void testEnumArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/EnumArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("MultipleAnnotations.kt")
                public void testMultipleAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/MultipleAnnotations.kt");
                    doTest(fileName);
                }

                @TestMetadata("NestedAnnotation.kt")
                public void testNestedAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/NestedAnnotation.kt");
                    doTest(fileName);
                }

                @TestMetadata("NestedClass.kt")
                public void testNestedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/NestedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("Retention.kt")
                public void testRetention() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/Retention.kt");
                    doTest(fileName);
                }

                @TestMetadata("Simple.kt")
                public void testSimple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/Simple.kt");
                    doTest(fileName);
                }

                @TestMetadata("WithArgument.kt")
                public void testWithArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/WithArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("WithMultipleArguments.kt")
                public void testWithMultipleArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/classes/WithMultipleArguments.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/annotations/packageMembers")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PackageMembers extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInPackageMembers() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/annotations/packageMembers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("DelegatedProperty.kt")
                public void testDelegatedProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/packageMembers/DelegatedProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("EnumArgument.kt")
                public void testEnumArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/packageMembers/EnumArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("EnumArrayArgument.kt")
                public void testEnumArrayArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/packageMembers/EnumArrayArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("Function.kt")
                public void testFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/packageMembers/Function.kt");
                    doTest(fileName);
                }

                @TestMetadata("Getter.kt")
                public void testGetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/packageMembers/Getter.kt");
                    doTest(fileName);
                }

                @TestMetadata("PropertyField.kt")
                public void testPropertyField() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/packageMembers/PropertyField.kt");
                    doTest(fileName);
                }

                @TestMetadata("Setter.kt")
                public void testSetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/packageMembers/Setter.kt");
                    doTest(fileName);
                }

                @TestMetadata("StringArrayArgument.kt")
                public void testStringArrayArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/packageMembers/StringArrayArgument.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Parameters extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInParameters() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/annotations/parameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("Constructor.kt")
                public void testConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/Constructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("EnumConstructor.kt")
                public void testEnumConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/EnumConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("ExtensionFunction.kt")
                public void testExtensionFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/ExtensionFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("ExtensionFunctionInClass.kt")
                public void testExtensionFunctionInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/ExtensionFunctionInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("ExtensionPropertySetter.kt")
                public void testExtensionPropertySetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/ExtensionPropertySetter.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunctionInClass.kt")
                public void testFunctionInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/FunctionInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunctionInTrait.kt")
                public void testFunctionInTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/FunctionInTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("InnerClassConstructor.kt")
                public void testInnerClassConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/InnerClassConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("ManyAnnotations.kt")
                public void testManyAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/ManyAnnotations.kt");
                    doTest(fileName);
                }

                @TestMetadata("PropertySetterInClass.kt")
                public void testPropertySetterInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/PropertySetterInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("TopLevelFunction.kt")
                public void testTopLevelFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/TopLevelFunction.kt");
                    doTest(fileName);
                }

                @TestMetadata("TopLevelPropertySetter.kt")
                public void testTopLevelPropertySetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/parameters/TopLevelPropertySetter.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/annotations/propertiesWithoutBackingFields")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PropertiesWithoutBackingFields extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInPropertiesWithoutBackingFields() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/annotations/propertiesWithoutBackingFields"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("Class.kt")
                public void testClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/propertiesWithoutBackingFields/Class.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassObject.kt")
                public void testClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/propertiesWithoutBackingFields/ClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("ExtensionsWithSameNameClass.kt")
                public void testExtensionsWithSameNameClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/propertiesWithoutBackingFields/ExtensionsWithSameNameClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("ExtensionsWithSameNamePackage.kt")
                public void testExtensionsWithSameNamePackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/propertiesWithoutBackingFields/ExtensionsWithSameNamePackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("NestedTrait.kt")
                public void testNestedTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/propertiesWithoutBackingFields/NestedTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("TopLevel.kt")
                public void testTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/propertiesWithoutBackingFields/TopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("Trait.kt")
                public void testTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/propertiesWithoutBackingFields/Trait.kt");
                    doTest(fileName);
                }

                @TestMetadata("TraitClassObject.kt")
                public void testTraitClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/propertiesWithoutBackingFields/TraitClassObject.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/annotations/types")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Types extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/annotations/types"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ReceiverParameter.kt")
                public void testReceiverParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/types/ReceiverParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("SimpleTypeAnnotation.kt")
                public void testSimpleTypeAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/types/SimpleTypeAnnotation.kt");
                    doTest(fileName);
                }

                @TestMetadata("SupertypesAndBounds.kt")
                public void testSupertypesAndBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/types/SupertypesAndBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("TypeAnnotationWithArguments.kt")
                public void testTypeAnnotationWithArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/types/TypeAnnotationWithArguments.kt");
                    doTest(fileName);
                }

                @TestMetadata("TypeArgument.kt")
                public void testTypeArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/types/TypeArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("TypeParameterAnnotation.kt")
                public void testTypeParameterAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/types/TypeParameterAnnotation.kt");
                    doTest(fileName);
                }

                @TestMetadata("TypeParameterAnnotationWithArguments.kt")
                public void testTypeParameterAnnotationWithArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/types/TypeParameterAnnotationWithArguments.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/annotations/withUseSiteTarget")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WithUseSiteTarget extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInWithUseSiteTarget() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/annotations/withUseSiteTarget"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("DelegateTarget.kt")
                public void testDelegateTarget() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/withUseSiteTarget/DelegateTarget.kt");
                    doTest(fileName);
                }

                @TestMetadata("FieldTarget.kt")
                public void testFieldTarget() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/withUseSiteTarget/FieldTarget.kt");
                    doTest(fileName);
                }

                @TestMetadata("ReceiverTarget.kt")
                public void testReceiverTarget() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/annotations/withUseSiteTarget/ReceiverTarget.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/class")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Class extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/class"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("Class.kt")
            public void testClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/Class.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassInParam.kt")
            public void testClassInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassInParam.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassInnerClass.kt")
            public void testClassInnerClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassInnerClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassMemberConflict.kt")
            public void testClassMemberConflict() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassMemberConflict.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassOutParam.kt")
            public void testClassOutParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassOutParam.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassParam.kt")
            public void testClassParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassParam.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassParamReferencesParam.kt")
            public void testClassParamReferencesParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassParamReferencesParam.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassParamReferencesParam2.kt")
            public void testClassParamReferencesParam2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassParamReferencesParam2.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassParamReferencesSelf.kt")
            public void testClassParamReferencesSelf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassParamReferencesSelf.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassParamUpperClassBound.kt")
            public void testClassParamUpperClassBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassParamUpperClassBound.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassParamUpperClassInterfaceBound.kt")
            public void testClassParamUpperClassInterfaceBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassParamUpperClassInterfaceBound.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassParamUpperInterfaceBound.kt")
            public void testClassParamUpperInterfaceBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassParamUpperInterfaceBound.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassTwoParams.kt")
            public void testClassTwoParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassTwoParams.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassTwoParams2.kt")
            public void testClassTwoParams2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/ClassTwoParams2.kt");
                doTest(fileName);
            }

            @TestMetadata("EnumWithGenericConstructorParameter.kt")
            public void testEnumWithGenericConstructorParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/EnumWithGenericConstructorParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("EnumWithPrimitiveConstructorParameter.kt")
            public void testEnumWithPrimitiveConstructorParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/EnumWithPrimitiveConstructorParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritClassSimple.kt")
            public void testInheritClassSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/InheritClassSimple.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritClassWithParam.kt")
            public void testInheritClassWithParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/InheritClassWithParam.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritSubstitutedMethod.kt")
            public void testInheritSubstitutedMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/InheritSubstitutedMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritTraitWithFunctionParam.kt")
            public void testInheritTraitWithFunctionParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/InheritTraitWithFunctionParam.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritTraitWithParam.kt")
            public void testInheritTraitWithParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/InheritTraitWithParam.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerClassExtendInnerClass.kt")
            public void testInnerClassExtendInnerClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/InnerClassExtendInnerClass.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerGenericClass.kt")
            public void testInnerGenericClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/InnerGenericClass.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerTypes.kt")
            public void testInnerTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/InnerTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("NamedObject.kt")
            public void testNamedObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/NamedObject.kt");
                doTest(fileName);
            }

            @TestMetadata("NamedObjectInClass.kt")
            public void testNamedObjectInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/NamedObjectInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("NamedObjectInClassObject.kt")
            public void testNamedObjectInClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/NamedObjectInClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("NamedObjectInNamedObject.kt")
            public void testNamedObjectInNamedObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/NamedObjectInNamedObject.kt");
                doTest(fileName);
            }

            @TestMetadata("NamedObjectWithAnotherTopLevelProperty.kt")
            public void testNamedObjectWithAnotherTopLevelProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/NamedObjectWithAnotherTopLevelProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("NestedClass.kt")
            public void testNestedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/NestedClass.kt");
                doTest(fileName);
            }

            @TestMetadata("NestedClassExtendNestedClass.kt")
            public void testNestedClassExtendNestedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/NestedClassExtendNestedClass.kt");
                doTest(fileName);
            }

            @TestMetadata("NestedGenericClass.kt")
            public void testNestedGenericClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/NestedGenericClass.kt");
                doTest(fileName);
            }

            @TestMetadata("RecursiveGeneric.kt")
            public void testRecursiveGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/RecursiveGeneric.kt");
                doTest(fileName);
            }

            @TestMetadata("SingleAbstractMethod.kt")
            public void testSingleAbstractMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/SingleAbstractMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("Trait.kt")
            public void testTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/Trait.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/class/javaBean")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class JavaBean extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInJavaBean() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/class/javaBean"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("DifferentGetterAndSetter.kt")
                public void testDifferentGetterAndSetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/javaBean/DifferentGetterAndSetter.kt");
                    doTest(fileName);
                }

                @TestMetadata("JavaBeanAbstractGetter.kt")
                public void testJavaBeanAbstractGetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/javaBean/JavaBeanAbstractGetter.kt");
                    doTest(fileName);
                }

                @TestMetadata("JavaBeanVal.kt")
                public void testJavaBeanVal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/javaBean/JavaBeanVal.kt");
                    doTest(fileName);
                }

                @TestMetadata("JavaBeanVar.kt")
                public void testJavaBeanVar() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/javaBean/JavaBeanVar.kt");
                    doTest(fileName);
                }

                @TestMetadata("JavaBeanVarOfGenericType.kt")
                public void testJavaBeanVarOfGenericType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/javaBean/JavaBeanVarOfGenericType.kt");
                    doTest(fileName);
                }

                @TestMetadata("TwoSetters.kt")
                public void testTwoSetters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/class/javaBean/TwoSetters.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/classFun")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassFun extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInClassFun() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/classFun"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ClassInParamUsedInFun.kt")
            public void testClassInParamUsedInFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classFun/ClassInParamUsedInFun.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassParamUsedInFun.kt")
            public void testClassParamUsedInFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classFun/ClassParamUsedInFun.kt");
                doTest(fileName);
            }

            @TestMetadata("FunDelegationToTraitImpl.kt")
            public void testFunDelegationToTraitImpl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classFun/FunDelegationToTraitImpl.kt");
                doTest(fileName);
            }

            @TestMetadata("FunInParamSuper.kt")
            public void testFunInParamSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classFun/FunInParamSuper.kt");
                doTest(fileName);
            }

            @TestMetadata("TraitOpenFun.kt")
            public void testTraitOpenFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classFun/TraitOpenFun.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/classObject")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassObject extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInClassObject() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/classObject"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ClassObjectDeclaresVal.kt")
            public void testClassObjectDeclaresVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/ClassObjectDeclaresVal.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectDeclaresVar.kt")
            public void testClassObjectDeclaresVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/ClassObjectDeclaresVar.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectDefaultVisibility.kt")
            public void testClassObjectDefaultVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/ClassObjectDefaultVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectExplicitVisibility.kt")
            public void testClassObjectExplicitVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/ClassObjectExplicitVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectExtendsTrait.kt")
            public void testClassObjectExtendsTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/ClassObjectExtendsTrait.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectExtendsTraitWithTP.kt")
            public void testClassObjectExtendsTraitWithTP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/ClassObjectExtendsTraitWithTP.kt");
                doTest(fileName);
            }

            @TestMetadata("classObjectInClassStaticFields.kt")
            public void testClassObjectInClassStaticFields() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/classObjectInClassStaticFields.kt");
                doTest(fileName);
            }

            @TestMetadata("classObjectInTraitStaticFields.kt")
            public void testClassObjectInTraitStaticFields() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/classObjectInTraitStaticFields.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectPropertyInClass.kt")
            public void testClassObjectPropertyInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/ClassObjectPropertyInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("Delegation.kt")
            public void testDelegation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/Delegation.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerClassInClassObject.kt")
            public void testInnerClassInClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/InnerClassInClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("NamedClassObject.kt")
            public void testNamedClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/NamedClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("SimpleClassObject.kt")
            public void testSimpleClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/classObject/SimpleClassObject.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/constructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructor extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInConstructor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/constructor"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("Constructor0.kt")
            public void testConstructor0() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/Constructor0.kt");
                doTest(fileName);
            }

            @TestMetadata("Constructor1.kt")
            public void testConstructor1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/Constructor1.kt");
                doTest(fileName);
            }

            @TestMetadata("Constructor1WithParamDefaultValue.kt")
            public void testConstructor1WithParamDefaultValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/Constructor1WithParamDefaultValue.kt");
                doTest(fileName);
            }

            @TestMetadata("Constructor2WithOneParamDefaultValue.kt")
            public void testConstructor2WithOneParamDefaultValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/Constructor2WithOneParamDefaultValue.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorCollectionParameter.kt")
            public void testConstructorCollectionParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/ConstructorCollectionParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorGenericDeep.kt")
            public void testConstructorGenericDeep() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/ConstructorGenericDeep.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorGenericSimple.kt")
            public void testConstructorGenericSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/ConstructorGenericSimple.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorGenericUpperBound.kt")
            public void testConstructorGenericUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/ConstructorGenericUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorWithTwoDefArgs.kt")
            public void testConstructorWithTwoDefArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/ConstructorWithTwoDefArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorWithTwoTypeParameters.kt")
            public void testConstructorWithTwoTypeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/ConstructorWithTwoTypeParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorWithTwoTypeParametersAndOneIntValueParameter.kt")
            public void testConstructorWithTwoTypeParametersAndOneIntValueParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/ConstructorWithTwoTypeParametersAndOneIntValueParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorWithTwoTypeParametersAndOnePValueParameter.kt")
            public void testConstructorWithTwoTypeParametersAndOnePValueParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/ConstructorWithTwoTypeParametersAndOnePValueParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorWithTypeParameter.kt")
            public void testConstructorWithTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/ConstructorWithTypeParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("ConstructorWithTypeParametersEAndOnePValueParameter.kt")
            public void testConstructorWithTypeParametersEAndOnePValueParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/ConstructorWithTypeParametersEAndOnePValueParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerClassConstructorWithDefArgs.kt")
            public void testInnerClassConstructorWithDefArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/InnerClassConstructorWithDefArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("PrivateConstructor1WithParamDefaultValue.kt")
            public void testPrivateConstructor1WithParamDefaultValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/PrivateConstructor1WithParamDefaultValue.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/constructor/vararg")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Vararg extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInVararg() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/constructor/vararg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ConstructorNonLastVararg.kt")
                public void testConstructorNonLastVararg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/vararg/ConstructorNonLastVararg.kt");
                    doTest(fileName);
                }

                @TestMetadata("ConstructorVararg.kt")
                public void testConstructorVararg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/constructor/vararg/ConstructorVararg.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/coroutines")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Coroutines extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInCoroutines() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/coroutines"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("Basic.kt")
            public void testBasic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/coroutines/Basic.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/dataClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DataClass extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInDataClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/dataClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("MixedComponents.kt")
            public void testMixedComponents() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/dataClass/MixedComponents.kt");
                doTest(fileName);
            }

            @TestMetadata("OneVal.kt")
            public void testOneVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/dataClass/OneVal.kt");
                doTest(fileName);
            }

            @TestMetadata("TwoVals.kt")
            public void testTwoVals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/dataClass/TwoVals.kt");
                doTest(fileName);
            }

            @TestMetadata("TwoVars.kt")
            public void testTwoVars() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/dataClass/TwoVars.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/enum")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Enum extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInEnum() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/enum"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("enumVisibility.kt")
            public void testEnumVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/enum/enumVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("enumWithConstuctor.kt")
            public void testEnumWithConstuctor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/enum/enumWithConstuctor.kt");
                doTest(fileName);
            }

            @TestMetadata("enumWithInnerClasses.kt")
            public void testEnumWithInnerClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/enum/enumWithInnerClasses.kt");
                doTest(fileName);
            }

            @TestMetadata("innerEnum.kt")
            public void testInnerEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/enum/innerEnum.kt");
                doTest(fileName);
            }

            @TestMetadata("innerEnumExistingClassObject.kt")
            public void testInnerEnumExistingClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/enum/innerEnumExistingClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleEnum.kt")
            public void testSimpleEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/enum/simpleEnum.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FromLoadJava extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInFromLoadJava() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fromLoadJava"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ArrayTypeVariance.kt")
            public void testArrayTypeVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/ArrayTypeVariance.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassDoesNotOverrideMethod.kt")
            public void testClassDoesNotOverrideMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/ClassDoesNotOverrideMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassObject.kt")
            public void testClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/ClassObject.kt");
                doTest(fileName);
            }

            @TestMetadata("classObjectAnnotation.kt")
            public void testClassObjectAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/classObjectAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassWithConstVal.kt")
            public void testClassWithConstVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/ClassWithConstVal.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassWithTypeP.kt")
            public void testClassWithTypeP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/ClassWithTypeP.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassWithTypePExtendsIterableP.kt")
            public void testClassWithTypePExtendsIterableP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/ClassWithTypePExtendsIterableP.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassWithTypePP.kt")
            public void testClassWithTypePP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/ClassWithTypePP.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassWithTypePRefNext.kt")
            public void testClassWithTypePRefNext() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/ClassWithTypePRefNext.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassWithTypePRefSelf.kt")
            public void testClassWithTypePRefSelf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/ClassWithTypePRefSelf.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassWithTypePRefSelfAndClass.kt")
            public void testClassWithTypePRefSelfAndClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/ClassWithTypePRefSelfAndClass.kt");
                doTest(fileName);
            }

            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/enum.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldAsVar.kt")
            public void testFieldAsVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/FieldAsVar.kt");
                doTest(fileName);
            }

            @TestMetadata("FieldOfArrayType.kt")
            public void testFieldOfArrayType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/FieldOfArrayType.kt");
                doTest(fileName);
            }

            @TestMetadata("FinalFieldAsVal.kt")
            public void testFinalFieldAsVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/FinalFieldAsVal.kt");
                doTest(fileName);
            }

            @TestMetadata("genericFunction.kt")
            public void testGenericFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/genericFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritMethodsDifferentReturnTypes.kt")
            public void testInheritMethodsDifferentReturnTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/InheritMethodsDifferentReturnTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritMethodsDifferentReturnTypesGeneric.kt")
            public void testInheritMethodsDifferentReturnTypesGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/InheritMethodsDifferentReturnTypesGeneric.kt");
                doTest(fileName);
            }

            @TestMetadata("InnerClass.kt")
            public void testInnerClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/InnerClass.kt");
                doTest(fileName);
            }

            @TestMetadata("MethodTypePOneUpperBound.kt")
            public void testMethodTypePOneUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/MethodTypePOneUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("MethodTypePTwoUpperBounds.kt")
            public void testMethodTypePTwoUpperBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/MethodTypePTwoUpperBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("MethodWithTypeP.kt")
            public void testMethodWithTypeP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/MethodWithTypeP.kt");
                doTest(fileName);
            }

            @TestMetadata("MethodWithTypePP.kt")
            public void testMethodWithTypePP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/MethodWithTypePP.kt");
                doTest(fileName);
            }

            @TestMetadata("MethodWithTypePRefClassP.kt")
            public void testMethodWithTypePRefClassP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/MethodWithTypePRefClassP.kt");
                doTest(fileName);
            }

            @TestMetadata("MethosWithPRefTP.kt")
            public void testMethosWithPRefTP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/MethosWithPRefTP.kt");
                doTest(fileName);
            }

            @TestMetadata("MyException.kt")
            public void testMyException() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/MyException.kt");
                doTest(fileName);
            }

            @TestMetadata("NestedClass.kt")
            public void testNestedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/NestedClass.kt");
                doTest(fileName);
            }

            @TestMetadata("objectInClass.kt")
            public void testObjectInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/objectInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("objectMembers.kt")
            public void testObjectMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/objectMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("packageLevelObject.kt")
            public void testPackageLevelObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/packageLevelObject.kt");
                doTest(fileName);
            }

            @TestMetadata("RemoveRedundantProjectionKind.kt")
            public void testRemoveRedundantProjectionKind() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/RemoveRedundantProjectionKind.kt");
                doTest(fileName);
            }

            @TestMetadata("Simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/Simple.kt");
                doTest(fileName);
            }

            @TestMetadata("TwoFields.kt")
            public void testTwoFields() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/TwoFields.kt");
                doTest(fileName);
            }

            @TestMetadata("UnboundWildcard.kt")
            public void testUnboundWildcard() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/UnboundWildcard.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class KotlinSignature extends AbstractJvmRuntimeDescriptorLoaderTest {
                @TestMetadata("AllBoundsInWhen.kt")
                public void testAllBoundsInWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/AllBoundsInWhen.kt");
                    doTest(fileName);
                }

                public void testAllFilesPresentInKotlinSignature() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ArrayType.kt")
                public void testArrayType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/ArrayType.kt");
                    doTest(fileName);
                }

                @TestMetadata("ConstructorWithNewTypeParams.kt")
                public void testConstructorWithNewTypeParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/ConstructorWithNewTypeParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("ConstructorWithParentTypeParams.kt")
                public void testConstructorWithParentTypeParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/ConstructorWithParentTypeParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("ConstructorWithSeveralParams.kt")
                public void testConstructorWithSeveralParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/ConstructorWithSeveralParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("ConstructorWithoutParams.kt")
                public void testConstructorWithoutParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/ConstructorWithoutParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("CustomProjectionKind.kt")
                public void testCustomProjectionKind() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/CustomProjectionKind.kt");
                    doTest(fileName);
                }

                @TestMetadata("MethodWithFunctionTypes.kt")
                public void testMethodWithFunctionTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/MethodWithFunctionTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("MethodWithGenerics.kt")
                public void testMethodWithGenerics() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/MethodWithGenerics.kt");
                    doTest(fileName);
                }

                @TestMetadata("MethodWithMappedClasses.kt")
                public void testMethodWithMappedClasses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/MethodWithMappedClasses.kt");
                    doTest(fileName);
                }

                @TestMetadata("MethodWithTypeParameters.kt")
                public void testMethodWithTypeParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/MethodWithTypeParameters.kt");
                    doTest(fileName);
                }

                @TestMetadata("MethodWithVararg.kt")
                public void testMethodWithVararg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/MethodWithVararg.kt");
                    doTest(fileName);
                }

                @TestMetadata("PropertyArrayTypes.kt")
                public void testPropertyArrayTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/PropertyArrayTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("PropertyComplexTypes.kt")
                public void testPropertyComplexTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/PropertyComplexTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("PropertySimpleType.kt")
                public void testPropertySimpleType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/PropertySimpleType.kt");
                    doTest(fileName);
                }

                @TestMetadata("StarProjection.kt")
                public void testStarProjection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/StarProjection.kt");
                    doTest(fileName);
                }

                @TestMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Error extends AbstractJvmRuntimeDescriptorLoaderTest {
                    @TestMetadata("AddingNullability.kt")
                    public void testAddingNullability() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/AddingNullability.kt");
                        doTest(fileName);
                    }

                    public void testAllFilesPresentInError() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("ConflictingProjectionKind.kt")
                    public void testConflictingProjectionKind() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/ConflictingProjectionKind.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("ExplicitFieldGettersAndSetters.kt")
                    public void testExplicitFieldGettersAndSetters() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/ExplicitFieldGettersAndSetters.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("ExtraUpperBound.kt")
                    public void testExtraUpperBound() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/ExtraUpperBound.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("MissingUpperBound.kt")
                    public void testMissingUpperBound() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/MissingUpperBound.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("NoFieldTypeRef.kt")
                    public void testNoFieldTypeRef() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/NoFieldTypeRef.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("NotVarargReplacedWithVararg.kt")
                    public void testNotVarargReplacedWithVararg() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/NotVarargReplacedWithVararg.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("RedundantProjectionKind.kt")
                    public void testRedundantProjectionKind() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/RedundantProjectionKind.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("ReturnTypeMissing.kt")
                    public void testReturnTypeMissing() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/ReturnTypeMissing.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("SyntaxError.kt")
                    public void testSyntaxError() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/SyntaxError.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("SyntaxErrorInFieldAnnotation.kt")
                    public void testSyntaxErrorInFieldAnnotation() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/SyntaxErrorInFieldAnnotation.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("VarargReplacedWithNotVararg.kt")
                    public void testVarargReplacedWithNotVararg() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/VarargReplacedWithNotVararg.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongFieldInitializer.kt")
                    public void testWrongFieldInitializer() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongFieldInitializer.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongFieldMutability.kt")
                    public void testWrongFieldMutability() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongFieldMutability.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongFieldName.kt")
                    public void testWrongFieldName() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongFieldName.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongMethodName.kt")
                    public void testWrongMethodName() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongMethodName.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongProjectionKind.kt")
                    public void testWrongProjectionKind() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongProjectionKind.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongReturnTypeStructure.kt")
                    public void testWrongReturnTypeStructure() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongReturnTypeStructure.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongTypeName1.kt")
                    public void testWrongTypeName1() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongTypeName1.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongTypeName2.kt")
                    public void testWrongTypeName2() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongTypeName2.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongTypeName3.kt")
                    public void testWrongTypeName3() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongTypeName3.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongTypeParameterBoundStructure1.kt")
                    public void testWrongTypeParameterBoundStructure1() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongTypeParameterBoundStructure1.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongTypeParameterBoundStructure2.kt")
                    public void testWrongTypeParameterBoundStructure2() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongTypeParameterBoundStructure2.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongTypeParametersCount.kt")
                    public void testWrongTypeParametersCount() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongTypeParametersCount.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongValueParameterStructure1.kt")
                    public void testWrongValueParameterStructure1() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongValueParameterStructure1.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongValueParameterStructure2.kt")
                    public void testWrongValueParameterStructure2() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongValueParameterStructure2.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("WrongValueParametersCount.kt")
                    public void testWrongValueParametersCount() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/error/WrongValueParametersCount.kt");
                        doTest(fileName);
                    }
                }

                @TestMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Propagation extends AbstractJvmRuntimeDescriptorLoaderTest {
                    public void testAllFilesPresentInPropagation() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("PropagateTypeArgumentNullable.kt")
                    public void testPropagateTypeArgumentNullable() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/PropagateTypeArgumentNullable.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Parameter extends AbstractJvmRuntimeDescriptorLoaderTest {
                        public void testAllFilesPresentInParameter() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("ChangeProjectionKind1.kt")
                        public void testChangeProjectionKind1() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/ChangeProjectionKind1.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("ChangeProjectionKind2.kt")
                        public void testChangeProjectionKind2() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/ChangeProjectionKind2.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("DeeplySubstitutedClassParameter.kt")
                        public void testDeeplySubstitutedClassParameter() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/DeeplySubstitutedClassParameter.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("DeeplySubstitutedClassParameter2.kt")
                        public void testDeeplySubstitutedClassParameter2() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/DeeplySubstitutedClassParameter2.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritMutability.kt")
                        public void testInheritMutability() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritMutability.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritNotVararg.kt")
                        public void testInheritNotVararg() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritNotVararg.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritNotVarargInteger.kt")
                        public void testInheritNotVarargInteger() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritNotVarargInteger.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritNotVarargNotNull.kt")
                        public void testInheritNotVarargNotNull() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritNotVarargNotNull.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritNotVarargPrimitive.kt")
                        public void testInheritNotVarargPrimitive() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritNotVarargPrimitive.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritNullability.kt")
                        public void testInheritNullability() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritNullability.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritProjectionKind.kt")
                        public void testInheritProjectionKind() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritProjectionKind.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritReadOnliness.kt")
                        public void testInheritReadOnliness() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritReadOnliness.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritVararg.kt")
                        public void testInheritVararg() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritVararg.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritVarargInteger.kt")
                        public void testInheritVarargInteger() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritVarargInteger.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritVarargNotNull.kt")
                        public void testInheritVarargNotNull() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritVarargNotNull.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritVarargPrimitive.kt")
                        public void testInheritVarargPrimitive() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/InheritVarargPrimitive.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("Kt3302.kt")
                        public void testKt3302() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/Kt3302.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("MutableToReadOnly.kt")
                        public void testMutableToReadOnly() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/MutableToReadOnly.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("NotNullToNullable.kt")
                        public void testNotNullToNullable() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/NotNullToNullable.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("NullableToNotNull.kt")
                        public void testNullableToNotNull() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/NullableToNotNull.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("NullableToNotNullKotlinSignature.kt")
                        public void testNullableToNotNullKotlinSignature() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/NullableToNotNullKotlinSignature.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("OverrideWithErasedParameter.kt")
                        public void testOverrideWithErasedParameter() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/OverrideWithErasedParameter.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("ReadOnlyToMutable.kt")
                        public void testReadOnlyToMutable() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/ReadOnlyToMutable.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("SubclassFromGenericAndNot.kt")
                        public void testSubclassFromGenericAndNot() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/SubclassFromGenericAndNot.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("SubstitutedClassParameter.kt")
                        public void testSubstitutedClassParameter() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/SubstitutedClassParameter.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("SubstitutedClassParameters.kt")
                        public void testSubstitutedClassParameters() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/parameter/SubstitutedClassParameters.kt");
                            doTest(fileName);
                        }
                    }

                    @TestMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Return extends AbstractJvmRuntimeDescriptorLoaderTest {
                        @TestMetadata("AddNotNullJavaSubtype.kt")
                        public void testAddNotNullJavaSubtype() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/AddNotNullJavaSubtype.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("AddNotNullSameJavaType.kt")
                        public void testAddNotNullSameJavaType() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/AddNotNullSameJavaType.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("AddNullabilityJavaSubtype.kt")
                        public void testAddNullabilityJavaSubtype() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/AddNullabilityJavaSubtype.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("AddNullabilitySameGenericType1.kt")
                        public void testAddNullabilitySameGenericType1() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/AddNullabilitySameGenericType1.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("AddNullabilitySameGenericType2.kt")
                        public void testAddNullabilitySameGenericType2() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/AddNullabilitySameGenericType2.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("AddNullabilitySameJavaType.kt")
                        public void testAddNullabilitySameJavaType() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/AddNullabilitySameJavaType.kt");
                            doTest(fileName);
                        }

                        public void testAllFilesPresentInReturn() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("CantMakeImmutableInSubclass.kt")
                        public void testCantMakeImmutableInSubclass() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/CantMakeImmutableInSubclass.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("DeeplySubstitutedClassParameter.kt")
                        public void testDeeplySubstitutedClassParameter() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/DeeplySubstitutedClassParameter.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("DeeplySubstitutedClassParameter2.kt")
                        public void testDeeplySubstitutedClassParameter2() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/DeeplySubstitutedClassParameter2.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("HalfSubstitutedTypeParameters.kt")
                        public void testHalfSubstitutedTypeParameters() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/HalfSubstitutedTypeParameters.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritNullabilityGenericSubclassSimple.kt")
                        public void testInheritNullabilityGenericSubclassSimple() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/InheritNullabilityGenericSubclassSimple.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritNullabilityJavaSubtype.kt")
                        public void testInheritNullabilityJavaSubtype() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/InheritNullabilityJavaSubtype.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritNullabilitySameGenericType.kt")
                        public void testInheritNullabilitySameGenericType() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/InheritNullabilitySameGenericType.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritNullabilitySameJavaType.kt")
                        public void testInheritNullabilitySameJavaType() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/InheritNullabilitySameJavaType.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritProjectionKind.kt")
                        public void testInheritProjectionKind() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/InheritProjectionKind.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritReadOnlinessOfArgument.kt")
                        public void testInheritReadOnlinessOfArgument() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/InheritReadOnlinessOfArgument.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritReadOnlinessSameClass.kt")
                        public void testInheritReadOnlinessSameClass() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/InheritReadOnlinessSameClass.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritReadOnlinessSubclass.kt")
                        public void testInheritReadOnlinessSubclass() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/InheritReadOnlinessSubclass.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("SameProjectionKind.kt")
                        public void testSameProjectionKind() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/SameProjectionKind.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("SubclassFromGenericAndNot.kt")
                        public void testSubclassFromGenericAndNot() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/SubclassFromGenericAndNot.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("SubclassOfCollection.kt")
                        public void testSubclassOfCollection() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/SubclassOfCollection.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("SubclassOfMapEntry.kt")
                        public void testSubclassOfMapEntry() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/SubclassOfMapEntry.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("SubstitutedClassParameter.kt")
                        public void testSubstitutedClassParameter() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/SubstitutedClassParameter.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("SubstitutedClassParameters.kt")
                        public void testSubstitutedClassParameters() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/SubstitutedClassParameters.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TwoSuperclassesConflictingProjectionKinds.kt")
                        public void testTwoSuperclassesConflictingProjectionKinds() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/TwoSuperclassesConflictingProjectionKinds.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TwoSuperclassesInvariantAndCovariantInferMutability.kt")
                        public void testTwoSuperclassesInvariantAndCovariantInferMutability() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/TwoSuperclassesInvariantAndCovariantInferMutability.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TwoSuperclassesInvariantAndCovariantInferNullability.kt")
                        public void testTwoSuperclassesInvariantAndCovariantInferNullability() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/TwoSuperclassesInvariantAndCovariantInferNullability.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TwoSuperclassesMutableAndNot.kt")
                        public void testTwoSuperclassesMutableAndNot() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/TwoSuperclassesMutableAndNot.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TwoSuperclassesReturnJavaSubtype.kt")
                        public void testTwoSuperclassesReturnJavaSubtype() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/TwoSuperclassesReturnJavaSubtype.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TwoSuperclassesReturnSameJavaType.kt")
                        public void testTwoSuperclassesReturnSameJavaType() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/TwoSuperclassesReturnSameJavaType.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TwoSuperclassesSupplementNotNull.kt")
                        public void testTwoSuperclassesSupplementNotNull() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/TwoSuperclassesSupplementNotNull.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TypeParamOfClass.kt")
                        public void testTypeParamOfClass() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/TypeParamOfClass.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TypeParamOfClassSubstituted.kt")
                        public void testTypeParamOfClassSubstituted() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/TypeParamOfClassSubstituted.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TypeParamOfFun.kt")
                        public void testTypeParamOfFun() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/return/TypeParamOfFun.kt");
                            doTest(fileName);
                        }
                    }

                    @TestMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class TypeParameter extends AbstractJvmRuntimeDescriptorLoaderTest {
                        public void testAllFilesPresentInTypeParameter() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("InheritMutability.kt")
                        public void testInheritMutability() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter/InheritMutability.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritNullability.kt")
                        public void testInheritNullability() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter/InheritNullability.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("InheritReadOnliness.kt")
                        public void testInheritReadOnliness() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter/InheritReadOnliness.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TwoBounds.kt")
                        public void testTwoBounds() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter/TwoBounds.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TwoSuperclasses.kt")
                        public void testTwoSuperclasses() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter/TwoSuperclasses.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("TwoTypeParameters.kt")
                        public void testTwoTypeParameters() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter/TwoTypeParameters.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("UseParameterAsUpperBound.kt")
                        public void testUseParameterAsUpperBound() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter/UseParameterAsUpperBound.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("UseParameterInUpperBound.kt")
                        public void testUseParameterInUpperBound() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter/UseParameterInUpperBound.kt");
                            doTest(fileName);
                        }

                        @TestMetadata("UseParameterInUpperBoundWithKotlinSignature.kt")
                        public void testUseParameterInUpperBoundWithKotlinSignature() throws Exception {
                            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/kotlinSignature/propagation/typeParameter/UseParameterInUpperBoundWithKotlinSignature.kt");
                            doTest(fileName);
                        }
                    }
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/library")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Library extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInLibrary() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fromLoadJava/library"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("LoadIterable.kt")
                public void testLoadIterable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/library/LoadIterable.kt");
                    doTest(fileName);
                }

                @TestMetadata("LoadIterator.kt")
                public void testLoadIterator() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/library/LoadIterator.kt");
                    doTest(fileName);
                }

                @TestMetadata("Max.kt")
                public void testMax() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/library/Max.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/modality")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Modality extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInModality() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fromLoadJava/modality"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ModalityOfFakeOverrides.kt")
                public void testModalityOfFakeOverrides() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/modality/ModalityOfFakeOverrides.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/notNull")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NotNull extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInNotNull() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fromLoadJava/notNull"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("NotNullField.kt")
                public void testNotNullField() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/notNull/NotNullField.kt");
                    doTest(fileName);
                }

                @TestMetadata("NotNullIntArray.kt")
                public void testNotNullIntArray() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/notNull/NotNullIntArray.kt");
                    doTest(fileName);
                }

                @TestMetadata("NotNullMethod.kt")
                public void testNotNullMethod() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/notNull/NotNullMethod.kt");
                    doTest(fileName);
                }

                @TestMetadata("NotNullObjectArray.kt")
                public void testNotNullObjectArray() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/notNull/NotNullObjectArray.kt");
                    doTest(fileName);
                }

                @TestMetadata("NotNullParameter.kt")
                public void testNotNullParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fromLoadJava/notNull/NotNullParameter.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/fun")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Fun extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInFun() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fun"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("Assert.kt")
            public void testAssert() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/Assert.kt");
                doTest(fileName);
            }

            @TestMetadata("DeclaredMemberOverridesDelegated.kt")
            public void testDeclaredMemberOverridesDelegated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/DeclaredMemberOverridesDelegated.kt");
                doTest(fileName);
            }

            @TestMetadata("InfixKeyword.kt")
            public void testInfixKeyword() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/InfixKeyword.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritMethodsDifferentReturnTypesAndVisibilities.kt")
            public void testInheritMethodsDifferentReturnTypesAndVisibilities() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/InheritMethodsDifferentReturnTypesAndVisibilities.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritValAndVar.kt")
            public void testInheritValAndVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/InheritValAndVar.kt");
                doTest(fileName);
            }

            @TestMetadata("InheritValsDifferentTypes.kt")
            public void testInheritValsDifferentTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/InheritValsDifferentTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("NoSamAdapter.kt")
            public void testNoSamAdapter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/NoSamAdapter.kt");
                doTest(fileName);
            }

            @TestMetadata("NoSamConstructor.kt")
            public void testNoSamConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/NoSamConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("OperatorKeyword.kt")
            public void testOperatorKeyword() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/OperatorKeyword.kt");
                doTest(fileName);
            }

            @TestMetadata("PropagateDeepSubclass.kt")
            public void testPropagateDeepSubclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/PropagateDeepSubclass.kt");
                doTest(fileName);
            }

            @TestMetadata("PropagateSubclassOfComparable.kt")
            public void testPropagateSubclassOfComparable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/PropagateSubclassOfComparable.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class GenericWithTypeVariables extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInGenericWithTypeVariables() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("FunGenericParam.kt")
                public void testFunGenericParam() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables/FunGenericParam.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunParamParam.kt")
                public void testFunParamParam() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables/FunParamParam.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunParamParamErased.kt")
                public void testFunParamParamErased() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables/FunParamParamErased.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunParamReferencesParam.kt")
                public void testFunParamReferencesParam() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables/FunParamReferencesParam.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunParamTwoUpperBounds.kt")
                public void testFunParamTwoUpperBounds() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables/FunParamTwoUpperBounds.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunParamUpperClassBound.kt")
                public void testFunParamUpperClassBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables/FunParamUpperClassBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunParamUpperClassInterfaceBound.kt")
                public void testFunParamUpperClassInterfaceBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables/FunParamUpperClassInterfaceBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunParamUpperInterfaceBound.kt")
                public void testFunParamUpperInterfaceBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables/FunParamUpperInterfaceBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunParamVaragParam.kt")
                public void testFunParamVaragParam() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables/FunParamVaragParam.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunTwoTypeParams.kt")
                public void testFunTwoTypeParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithTypeVariables/FunTwoTypeParams.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithoutTypeVariables")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class GenericWithoutTypeVariables extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInGenericWithoutTypeVariables() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fun/genericWithoutTypeVariables"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("FunClassParamNotNull.kt")
                public void testFunClassParamNotNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithoutTypeVariables/FunClassParamNotNull.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunClassParamNullable.kt")
                public void testFunClassParamNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithoutTypeVariables/FunClassParamNullable.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunParamNullable.kt")
                public void testFunParamNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithoutTypeVariables/FunParamNullable.kt");
                    doTest(fileName);
                }

                @TestMetadata("ReturnTypeClassParamNotNull.kt")
                public void testReturnTypeClassParamNotNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithoutTypeVariables/ReturnTypeClassParamNotNull.kt");
                    doTest(fileName);
                }

                @TestMetadata("ReturnTypeClassParamNullable.kt")
                public void testReturnTypeClassParamNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/genericWithoutTypeVariables/ReturnTypeClassParamNullable.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NonGeneric extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInNonGeneric() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ClassFun.kt")
                public void testClassFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/ClassFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassFunGetFoo.kt")
                public void testClassFunGetFoo() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/ClassFunGetFoo.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassFunGetFooSetFoo.kt")
                public void testClassFunGetFooSetFoo() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/ClassFunGetFooSetFoo.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassFunSetFoo.kt")
                public void testClassFunSetFoo() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/ClassFunSetFoo.kt");
                    doTest(fileName);
                }

                @TestMetadata("ExtFun.kt")
                public void testExtFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/ExtFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("ExtFunInClass.kt")
                public void testExtFunInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/ExtFunInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunDefaultArg.kt")
                public void testFunDefaultArg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/FunDefaultArg.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunParamNotNull.kt")
                public void testFunParamNotNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/FunParamNotNull.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunVarargInt.kt")
                public void testFunVarargInt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/FunVarargInt.kt");
                    doTest(fileName);
                }

                @TestMetadata("FunVarargInteger.kt")
                public void testFunVarargInteger() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/FunVarargInteger.kt");
                    doTest(fileName);
                }

                @TestMetadata("ModifierAbstract.kt")
                public void testModifierAbstract() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/ModifierAbstract.kt");
                    doTest(fileName);
                }

                @TestMetadata("ModifierOpen.kt")
                public void testModifierOpen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/ModifierOpen.kt");
                    doTest(fileName);
                }

                @TestMetadata("NsFun.kt")
                public void testNsFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/NsFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("NsFunGetFoo.kt")
                public void testNsFunGetFoo() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/NsFunGetFoo.kt");
                    doTest(fileName);
                }

                @TestMetadata("ReturnTypeNotNull.kt")
                public void testReturnTypeNotNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/ReturnTypeNotNull.kt");
                    doTest(fileName);
                }

                @TestMetadata("ReturnTypeNullable.kt")
                public void testReturnTypeNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/nonGeneric/ReturnTypeNullable.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/fun/vararg")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Vararg extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInVararg() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/fun/vararg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("nonLastVararg.kt")
                public void testNonLastVararg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/vararg/nonLastVararg.kt");
                    doTest(fileName);
                }

                @TestMetadata("VarargInt.kt")
                public void testVarargInt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/vararg/VarargInt.kt");
                    doTest(fileName);
                }

                @TestMetadata("VarargString.kt")
                public void testVarargString() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/fun/vararg/VarargString.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/inline")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inline extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInInline() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/inline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("inlineFunction.kt")
            public void testInlineFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/inline/inlineFunction.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/memberOrder")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MemberOrder extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInMemberOrder() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/memberOrder"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callablesNameClash.kt")
            public void testCallablesNameClash() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/memberOrder/callablesNameClash.kt");
                doTest(fileName);
            }

            @TestMetadata("enumEntries.kt")
            public void testEnumEntries() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/memberOrder/enumEntries.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionMembers.kt")
            public void testExtensionMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/memberOrder/extensionMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionPropertiesNameClash.kt")
            public void testExtensionPropertiesNameClash() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/memberOrder/extensionPropertiesNameClash.kt");
                doTest(fileName);
            }

            @TestMetadata("innerClasses.kt")
            public void testInnerClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/memberOrder/innerClasses.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelCallables.kt")
            public void testTopLevelCallables() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/memberOrder/topLevelCallables.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/nested")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Nested extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInNested() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/nested"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("deepInnerGeneric.kt")
            public void testDeepInnerGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/nested/deepInnerGeneric.kt");
                doTest(fileName);
            }

            @TestMetadata("innerClassReferencesOuterTP.kt")
            public void testInnerClassReferencesOuterTP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/nested/innerClassReferencesOuterTP.kt");
                doTest(fileName);
            }

            @TestMetadata("membersReferenceOuterTP.kt")
            public void testMembersReferenceOuterTP() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/nested/membersReferenceOuterTP.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/platformTypes")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PlatformTypes extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInPlatformTypes() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/platformTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("notnullTypeArgument.kt")
            public void testNotnullTypeArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/platformTypes/notnullTypeArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("nullableTypeArgument.kt")
            public void testNullableTypeArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/platformTypes/nullableTypeArgument.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/prop")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Prop extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInProp() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/prop"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ClassVal.kt")
            public void testClassVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ClassVal.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassValAbstract.kt")
            public void testClassValAbstract() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ClassValAbstract.kt");
                doTest(fileName);
            }

            @TestMetadata("ClassVar.kt")
            public void testClassVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ClassVar.kt");
                doTest(fileName);
            }

            @TestMetadata("CollectionSize.kt")
            public void testCollectionSize() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/CollectionSize.kt");
                doTest(fileName);
            }

            @TestMetadata("Const.kt")
            public void testConst() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/Const.kt");
                doTest(fileName);
            }

            @TestMetadata("Constants.kt")
            public void testConstants() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/Constants.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtValClass.kt")
            public void testExtValClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtValClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtValInClass.kt")
            public void testExtValInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtValInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtValInt.kt")
            public void testExtValInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtValInt.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtValIntCharSequence.kt")
            public void testExtValIntCharSequence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtValIntCharSequence.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtValIntCharSequenceQ.kt")
            public void testExtValIntCharSequenceQ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtValIntCharSequenceQ.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtValIntListQOfIntInClass.kt")
            public void testExtValIntListQOfIntInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtValIntListQOfIntInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtValIntTInClass.kt")
            public void testExtValIntTInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtValIntTInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtValIntTQInClass.kt")
            public void testExtValIntTQInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtValIntTQInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtValTIntInClass.kt")
            public void testExtValTIntInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtValTIntInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtVarClass.kt")
            public void testExtVarClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtVarClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtVarInClass.kt")
            public void testExtVarInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtVarInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtVarInt.kt")
            public void testExtVarInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtVarInt.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtVarIntTInClass.kt")
            public void testExtVarIntTInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtVarIntTInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtVarIntTQInClass.kt")
            public void testExtVarIntTQInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtVarIntTQInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtVarMapPQInt.kt")
            public void testExtVarMapPQInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtVarMapPQInt.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtVarTIntInClass.kt")
            public void testExtVarTIntInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtVarTIntInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtVarTQIntInClass.kt")
            public void testExtVarTQIntInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtVarTQIntInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("ExtVarl.kt")
            public void testExtVarl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/ExtVarl.kt");
                doTest(fileName);
            }

            @TestMetadata("NsVal.kt")
            public void testNsVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/NsVal.kt");
                doTest(fileName);
            }

            @TestMetadata("NsVar.kt")
            public void testNsVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/NsVar.kt");
                doTest(fileName);
            }

            @TestMetadata("OverrideClassVal.kt")
            public void testOverrideClassVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/OverrideClassVal.kt");
                doTest(fileName);
            }

            @TestMetadata("OverrideTraitVal.kt")
            public void testOverrideTraitVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/OverrideTraitVal.kt");
                doTest(fileName);
            }

            @TestMetadata("PropFromSuperclass.kt")
            public void testPropFromSuperclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/PropFromSuperclass.kt");
                doTest(fileName);
            }

            @TestMetadata("TraitFinalVar.kt")
            public void testTraitFinalVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/TraitFinalVar.kt");
                doTest(fileName);
            }

            @TestMetadata("TraitOpenVal.kt")
            public void testTraitOpenVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/TraitOpenVal.kt");
                doTest(fileName);
            }

            @TestMetadata("VarDelegationToTraitImpl.kt")
            public void testVarDelegationToTraitImpl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/VarDelegationToTraitImpl.kt");
                doTest(fileName);
            }

            @TestMetadata("VarWithDelegated.kt")
            public void testVarWithDelegated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/VarWithDelegated.kt");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DefaultAccessors extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInDefaultAccessors() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ClassVal.kt")
                public void testClassVal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors/ClassVal.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassValParams.kt")
                public void testClassValParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors/ClassValParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassValWithGet.kt")
                public void testClassValWithGet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors/ClassValWithGet.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassVar.kt")
                public void testClassVar() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors/ClassVar.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassVarModality.kt")
                public void testClassVarModality() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors/ClassVarModality.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassVarParams.kt")
                public void testClassVarParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors/ClassVarParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassVarWithGet.kt")
                public void testClassVarWithGet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors/ClassVarWithGet.kt");
                    doTest(fileName);
                }

                @TestMetadata("ClassVarWithSet.kt")
                public void testClassVarWithSet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors/ClassVarWithSet.kt");
                    doTest(fileName);
                }

                @TestMetadata("ExtValLong.kt")
                public void testExtValLong() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors/ExtValLong.kt");
                    doTest(fileName);
                }

                @TestMetadata("ExtVarLong.kt")
                public void testExtVarLong() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/prop/defaultAccessors/ExtVarLong.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/type")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Type extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInType() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/type"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("Any.kt")
            public void testAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/Any.kt");
                doTest(fileName);
            }

            @TestMetadata("AnyQ.kt")
            public void testAnyQ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/AnyQ.kt");
                doTest(fileName);
            }

            @TestMetadata("ArrayOfInNumber.kt")
            public void testArrayOfInNumber() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ArrayOfInNumber.kt");
                doTest(fileName);
            }

            @TestMetadata("ArrayOfInt.kt")
            public void testArrayOfInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ArrayOfInt.kt");
                doTest(fileName);
            }

            @TestMetadata("ArrayOfInteger.kt")
            public void testArrayOfInteger() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ArrayOfInteger.kt");
                doTest(fileName);
            }

            @TestMetadata("ArrayOfOutNumber.kt")
            public void testArrayOfOutNumber() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ArrayOfOutNumber.kt");
                doTest(fileName);
            }

            @TestMetadata("ArrayOfOutT.kt")
            public void testArrayOfOutT() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ArrayOfOutT.kt");
                doTest(fileName);
            }

            @TestMetadata("ArrayOfString.kt")
            public void testArrayOfString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ArrayOfString.kt");
                doTest(fileName);
            }

            @TestMetadata("Function1IntString.kt")
            public void testFunction1IntString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/Function1IntString.kt");
                doTest(fileName);
            }

            @TestMetadata("Int.kt")
            public void testInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/Int.kt");
                doTest(fileName);
            }

            @TestMetadata("IntArray.kt")
            public void testIntArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/IntArray.kt");
                doTest(fileName);
            }

            @TestMetadata("IntQ.kt")
            public void testIntQ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/IntQ.kt");
                doTest(fileName);
            }

            @TestMetadata("jlInteger.kt")
            public void testJlInteger() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/jlInteger.kt");
                doTest(fileName);
            }

            @TestMetadata("jlIntegerQ.kt")
            public void testJlIntegerQ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/jlIntegerQ.kt");
                doTest(fileName);
            }

            @TestMetadata("jlNumber.kt")
            public void testJlNumber() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/jlNumber.kt");
                doTest(fileName);
            }

            @TestMetadata("jlObject.kt")
            public void testJlObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/jlObject.kt");
                doTest(fileName);
            }

            @TestMetadata("jlObjectQ.kt")
            public void testJlObjectQ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/jlObjectQ.kt");
                doTest(fileName);
            }

            @TestMetadata("jlString.kt")
            public void testJlString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/jlString.kt");
                doTest(fileName);
            }

            @TestMetadata("jlStringQ.kt")
            public void testJlStringQ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/jlStringQ.kt");
                doTest(fileName);
            }

            @TestMetadata("ListOfAny.kt")
            public void testListOfAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ListOfAny.kt");
                doTest(fileName);
            }

            @TestMetadata("ListOfAnyQ.kt")
            public void testListOfAnyQ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ListOfAnyQ.kt");
                doTest(fileName);
            }

            @TestMetadata("ListOfStar.kt")
            public void testListOfStar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ListOfStar.kt");
                doTest(fileName);
            }

            @TestMetadata("ListOfString.kt")
            public void testListOfString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ListOfString.kt");
                doTest(fileName);
            }

            @TestMetadata("ListOfjlString.kt")
            public void testListOfjlString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/ListOfjlString.kt");
                doTest(fileName);
            }

            @TestMetadata("Nothing.kt")
            public void testNothing() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/Nothing.kt");
                doTest(fileName);
            }

            @TestMetadata("NothingQ.kt")
            public void testNothingQ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/NothingQ.kt");
                doTest(fileName);
            }

            @TestMetadata("platform.kt")
            public void testPlatform() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/platform.kt");
                doTest(fileName);
            }

            @TestMetadata("String.kt")
            public void testString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/String.kt");
                doTest(fileName);
            }

            @TestMetadata("StringQ.kt")
            public void testStringQ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/StringQ.kt");
                doTest(fileName);
            }

            @TestMetadata("Unit.kt")
            public void testUnit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/type/Unit.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/typealias")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Typealias extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInTypealias() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/typealias"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("Annotations.kt")
            public void testAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/typealias/Annotations.kt");
                doTest(fileName);
            }

            @TestMetadata("Basic.kt")
            public void testBasic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/typealias/Basic.kt");
                doTest(fileName);
            }

            @TestMetadata("Generic.kt")
            public void testGeneric() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/typealias/Generic.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledKotlin/visibility")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Visibility extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInVisibility() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledKotlin/visibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("InternalClass.kt")
            public void testInternalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/InternalClass.kt");
                doTest(fileName);
            }

            @TestMetadata("InternalConstructor.kt")
            public void testInternalConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/InternalConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("InternalTopLevelMembers.kt")
            public void testInternalTopLevelMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/InternalTopLevelMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("PrivateClass.kt")
            public void testPrivateClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/PrivateClass.kt");
                doTest(fileName);
            }

            @TestMetadata("PrivateClassMembers.kt")
            public void testPrivateClassMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/PrivateClassMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("PrivateToThis.kt")
            public void testPrivateToThis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/PrivateToThis.kt");
                doTest(fileName);
            }

            @TestMetadata("PrivateTopLevelFun.kt")
            public void testPrivateTopLevelFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/PrivateTopLevelFun.kt");
                doTest(fileName);
            }

            @TestMetadata("PrivateTopLevelVal.kt")
            public void testPrivateTopLevelVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/PrivateTopLevelVal.kt");
                doTest(fileName);
            }

            @TestMetadata("PropertyInConstructor.kt")
            public void testPropertyInConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/PropertyInConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("PropertyInConstructorExplicitVisibility.kt")
            public void testPropertyInConstructorExplicitVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/PropertyInConstructorExplicitVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("TopLevelVarWithPrivateSetter.kt")
            public void testTopLevelVarWithPrivateSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledKotlin/visibility/TopLevelVarWithPrivateSetter.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/loadJava/compiledJava")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CompiledJava extends AbstractJvmRuntimeDescriptorLoaderTest {
        public void testAllFilesPresentInCompiledJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true, "sam", "kotlinSignature/propagation");
        }

        @TestMetadata("ArrayTypeVariance.java")
        public void testArrayTypeVariance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/ArrayTypeVariance.java");
            doTest(fileName);
        }

        @TestMetadata("ClassDoesNotOverrideMethod.java")
        public void testClassDoesNotOverrideMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/ClassDoesNotOverrideMethod.java");
            doTest(fileName);
        }

        @TestMetadata("ClassWithConstVal.java")
        public void testClassWithConstVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/ClassWithConstVal.java");
            doTest(fileName);
        }

        @TestMetadata("ClassWithTypeP.java")
        public void testClassWithTypeP() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/ClassWithTypeP.java");
            doTest(fileName);
        }

        @TestMetadata("ClassWithTypePExtendsIterableP.java")
        public void testClassWithTypePExtendsIterableP() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/ClassWithTypePExtendsIterableP.java");
            doTest(fileName);
        }

        @TestMetadata("ClassWithTypePP.java")
        public void testClassWithTypePP() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/ClassWithTypePP.java");
            doTest(fileName);
        }

        @TestMetadata("ClassWithTypePRefNext.java")
        public void testClassWithTypePRefNext() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/ClassWithTypePRefNext.java");
            doTest(fileName);
        }

        @TestMetadata("ClassWithTypePRefSelf.java")
        public void testClassWithTypePRefSelf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/ClassWithTypePRefSelf.java");
            doTest(fileName);
        }

        @TestMetadata("ClassWithTypePRefSelfAndClass.java")
        public void testClassWithTypePRefSelfAndClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/ClassWithTypePRefSelfAndClass.java");
            doTest(fileName);
        }

        @TestMetadata("FieldAsVar.java")
        public void testFieldAsVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/FieldAsVar.java");
            doTest(fileName);
        }

        @TestMetadata("FieldOfArrayType.java")
        public void testFieldOfArrayType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/FieldOfArrayType.java");
            doTest(fileName);
        }

        @TestMetadata("FinalFieldAsVal.java")
        public void testFinalFieldAsVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/FinalFieldAsVal.java");
            doTest(fileName);
        }

        @TestMetadata("InheritMethodsDifferentReturnTypes.java")
        public void testInheritMethodsDifferentReturnTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/InheritMethodsDifferentReturnTypes.java");
            doTest(fileName);
        }

        @TestMetadata("InheritMethodsDifferentReturnTypesGeneric.java")
        public void testInheritMethodsDifferentReturnTypesGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/InheritMethodsDifferentReturnTypesGeneric.java");
            doTest(fileName);
        }

        @TestMetadata("InnerClass.java")
        public void testInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/InnerClass.java");
            doTest(fileName);
        }

        @TestMetadata("InnerClassReferencesOuterTP.java")
        public void testInnerClassReferencesOuterTP() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/InnerClassReferencesOuterTP.java");
            doTest(fileName);
        }

        @TestMetadata("InnerClassTypeMultipleGeneric.java")
        public void testInnerClassTypeMultipleGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/InnerClassTypeMultipleGeneric.java");
            doTest(fileName);
        }

        @TestMetadata("InnerClassesInGeneric.java")
        public void testInnerClassesInGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/InnerClassesInGeneric.java");
            doTest(fileName);
        }

        @TestMetadata("InnerOfGeneric.java")
        public void testInnerOfGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/InnerOfGeneric.java");
            doTest(fileName);
        }

        @TestMetadata("IntrinsicCompanionObject.java")
        public void testIntrinsicCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/IntrinsicCompanionObject.java");
            doTest(fileName);
        }

        @TestMetadata("MethodReferencesOuterClassTP.java")
        public void testMethodReferencesOuterClassTP() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/MethodReferencesOuterClassTP.java");
            doTest(fileName);
        }

        @TestMetadata("MethodTypePOneUpperBound.java")
        public void testMethodTypePOneUpperBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/MethodTypePOneUpperBound.java");
            doTest(fileName);
        }

        @TestMetadata("MethodTypePTwoUpperBounds.java")
        public void testMethodTypePTwoUpperBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/MethodTypePTwoUpperBounds.java");
            doTest(fileName);
        }

        @TestMetadata("MethodWithTypeP.java")
        public void testMethodWithTypeP() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/MethodWithTypeP.java");
            doTest(fileName);
        }

        @TestMetadata("MethodWithTypePP.java")
        public void testMethodWithTypePP() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/MethodWithTypePP.java");
            doTest(fileName);
        }

        @TestMetadata("MethodWithTypePRefClassP.java")
        public void testMethodWithTypePRefClassP() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/MethodWithTypePRefClassP.java");
            doTest(fileName);
        }

        @TestMetadata("MethosWithPRefTP.java")
        public void testMethosWithPRefTP() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/MethosWithPRefTP.java");
            doTest(fileName);
        }

        @TestMetadata("MyException.java")
        public void testMyException() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/MyException.java");
            doTest(fileName);
        }

        @TestMetadata("NestedClass.java")
        public void testNestedClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/NestedClass.java");
            doTest(fileName);
        }

        @TestMetadata("OverrideMethod.java")
        public void testOverrideMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/OverrideMethod.java");
            doTest(fileName);
        }

        @TestMetadata("PackageLocalVisibility.java")
        public void testPackageLocalVisibility() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/PackageLocalVisibility.java");
            doTest(fileName);
        }

        @TestMetadata("PrivateMembers.java")
        public void testPrivateMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/PrivateMembers.java");
            doTest(fileName);
        }

        @TestMetadata("PrivateMembersInHierarchy.java")
        public void testPrivateMembersInHierarchy() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/PrivateMembersInHierarchy.java");
            doTest(fileName);
        }

        @TestMetadata("RawOverrides.java")
        public void testRawOverrides() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/RawOverrides.java");
            doTest(fileName);
        }

        @TestMetadata("RawTypeWithUpperBound.java")
        public void testRawTypeWithUpperBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/RawTypeWithUpperBound.java");
            doTest(fileName);
        }

        @TestMetadata("RawUpperBound.java")
        public void testRawUpperBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/RawUpperBound.java");
            doTest(fileName);
        }

        @TestMetadata("RecursiveRawUpperBound.java")
        public void testRecursiveRawUpperBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/RecursiveRawUpperBound.java");
            doTest(fileName);
        }

        @TestMetadata("RecursiveWildcardUpperBound.java")
        public void testRecursiveWildcardUpperBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/RecursiveWildcardUpperBound.java");
            doTest(fileName);
        }

        @TestMetadata("RemoveRedundantProjectionKind.java")
        public void testRemoveRedundantProjectionKind() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/RemoveRedundantProjectionKind.java");
            doTest(fileName);
        }

        @TestMetadata("Simple.java")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/Simple.java");
            doTest(fileName);
        }

        @TestMetadata("SubclassFromNested.java")
        public void testSubclassFromNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/SubclassFromNested.java");
            doTest(fileName);
        }

        @TestMetadata("TwoFields.java")
        public void testTwoFields() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/TwoFields.java");
            doTest(fileName);
        }

        @TestMetadata("UnboundWildcard.java")
        public void testUnboundWildcard() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/UnboundWildcard.java");
            doTest(fileName);
        }

        @TestMetadata("WildcardBounds.java")
        public void testWildcardBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/WildcardBounds.java");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/annotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotations extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/annotations"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AnnotatedAnnotation.java")
            public void testAnnotatedAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/AnnotatedAnnotation.java");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedConstructor.java")
            public void testAnnotatedConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/AnnotatedConstructor.java");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedEnumEntry.java")
            public void testAnnotatedEnumEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/AnnotatedEnumEntry.java");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedField.java")
            public void testAnnotatedField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/AnnotatedField.java");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedMethod.java")
            public void testAnnotatedMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/AnnotatedMethod.java");
                doTest(fileName);
            }

            @TestMetadata("AnnotatedValueParameter.java")
            public void testAnnotatedValueParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/AnnotatedValueParameter.java");
                doTest(fileName);
            }

            @TestMetadata("AnnotationInParam.java")
            public void testAnnotationInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/AnnotationInParam.java");
                doTest(fileName);
            }

            @TestMetadata("AnnotationRetentions.java")
            public void testAnnotationRetentions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/AnnotationRetentions.java");
                doTest(fileName);
            }

            @TestMetadata("AnnotationTargets.java")
            public void testAnnotationTargets() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/AnnotationTargets.java");
                doTest(fileName);
            }

            @TestMetadata("ArithmeticExpressionInParam.java")
            public void testArithmeticExpressionInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/ArithmeticExpressionInParam.java");
                doTest(fileName);
            }

            @TestMetadata("ArrayOfEnumInParam.java")
            public void testArrayOfEnumInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/ArrayOfEnumInParam.java");
                doTest(fileName);
            }

            @TestMetadata("ArrayOfStringInParam.java")
            public void testArrayOfStringInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/ArrayOfStringInParam.java");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectArrayInParam.java")
            public void testClassObjectArrayInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/ClassObjectArrayInParam.java");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectInParam.java")
            public void testClassObjectInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/ClassObjectInParam.java");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectInParamRaw.java")
            public void testClassObjectInParamRaw() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/ClassObjectInParamRaw.java");
                doTest(fileName);
            }

            @TestMetadata("ClassObjectInParamVariance.java")
            public void testClassObjectInParamVariance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/ClassObjectInParamVariance.java");
                doTest(fileName);
            }

            @TestMetadata("CustomAnnotation.java")
            public void testCustomAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/CustomAnnotation.java");
                doTest(fileName);
            }

            @TestMetadata("CustomAnnotationWithDefaultParameter.java")
            public void testCustomAnnotationWithDefaultParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/CustomAnnotationWithDefaultParameter.java");
                doTest(fileName);
            }

            @TestMetadata("EmptyArrayInParam.java")
            public void testEmptyArrayInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/EmptyArrayInParam.java");
                doTest(fileName);
            }

            @TestMetadata("EnumArgumentWithCustomToString.java")
            public void testEnumArgumentWithCustomToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/EnumArgumentWithCustomToString.java");
                doTest(fileName);
            }

            @TestMetadata("EnumConstructorParameter.java")
            public void testEnumConstructorParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/EnumConstructorParameter.java");
                doTest(fileName);
            }

            @TestMetadata("EnumInParam.java")
            public void testEnumInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/EnumInParam.java");
                doTest(fileName);
            }

            @TestMetadata("JavaDocDeprecated.java")
            public void testJavaDocDeprecated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/JavaDocDeprecated.java");
                doTest(fileName);
            }

            @TestMetadata("NestedEnumArgument.java")
            public void testNestedEnumArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/NestedEnumArgument.java");
                doTest(fileName);
            }

            @TestMetadata("PrimitiveValueInParam.java")
            public void testPrimitiveValueInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/PrimitiveValueInParam.java");
                doTest(fileName);
            }

            @TestMetadata("RecursiveAnnotation.java")
            public void testRecursiveAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/RecursiveAnnotation.java");
                doTest(fileName);
            }

            @TestMetadata("RecursiveAnnotation2.java")
            public void testRecursiveAnnotation2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/RecursiveAnnotation2.java");
                doTest(fileName);
            }

            @TestMetadata("SimpleAnnotation.java")
            public void testSimpleAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/SimpleAnnotation.java");
                doTest(fileName);
            }

            @TestMetadata("StringConcatenationInParam.java")
            public void testStringConcatenationInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/StringConcatenationInParam.java");
                doTest(fileName);
            }

            @TestMetadata("StringConstantInParam.java")
            public void testStringConstantInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/StringConstantInParam.java");
                doTest(fileName);
            }

            @TestMetadata("StringInParam.java")
            public void testStringInParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/annotations/StringInParam.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/constructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructor extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInConstructor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/constructor"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ConstructorGenericDeep.java")
            public void testConstructorGenericDeep() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/constructor/ConstructorGenericDeep.java");
                doTest(fileName);
            }

            @TestMetadata("ConstructorGenericSimple.java")
            public void testConstructorGenericSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/constructor/ConstructorGenericSimple.java");
                doTest(fileName);
            }

            @TestMetadata("ConstructorGenericUpperBound.java")
            public void testConstructorGenericUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/constructor/ConstructorGenericUpperBound.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/enum")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Enum extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInEnum() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/enum"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("EnumMembers.java")
            public void testEnumMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/enum/EnumMembers.java");
                doTest(fileName);
            }

            @TestMetadata("EnumWithSpecializedEntry.java")
            public void testEnumWithSpecializedEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/enum/EnumWithSpecializedEntry.java");
                doTest(fileName);
            }

            @TestMetadata("JavaEnum.java")
            public void testJavaEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/enum/JavaEnum.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/javaBean")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaBean extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInJavaBean() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/javaBean"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("DifferentGetterAndSetter.java")
            public void testDifferentGetterAndSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/javaBean/DifferentGetterAndSetter.java");
                doTest(fileName);
            }

            @TestMetadata("JavaBeanAbstractGetter.java")
            public void testJavaBeanAbstractGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/javaBean/JavaBeanAbstractGetter.java");
                doTest(fileName);
            }

            @TestMetadata("JavaBeanVal.java")
            public void testJavaBeanVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/javaBean/JavaBeanVal.java");
                doTest(fileName);
            }

            @TestMetadata("JavaBeanVar.java")
            public void testJavaBeanVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/javaBean/JavaBeanVar.java");
                doTest(fileName);
            }

            @TestMetadata("JavaBeanVarOfGenericType.java")
            public void testJavaBeanVarOfGenericType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/javaBean/JavaBeanVarOfGenericType.java");
                doTest(fileName);
            }

            @TestMetadata("TwoSetters.java")
            public void testTwoSetters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/javaBean/TwoSetters.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KotlinSignature extends AbstractJvmRuntimeDescriptorLoaderTest {
            @TestMetadata("AllBoundsInWhen.java")
            public void testAllBoundsInWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/AllBoundsInWhen.java");
                doTest(fileName);
            }

            public void testAllFilesPresentInKotlinSignature() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/kotlinSignature"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true, "propagation");
            }

            @TestMetadata("ArrayType.java")
            public void testArrayType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/ArrayType.java");
                doTest(fileName);
            }

            @TestMetadata("ConstructorWithNewTypeParams.java")
            public void testConstructorWithNewTypeParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/ConstructorWithNewTypeParams.java");
                doTest(fileName);
            }

            @TestMetadata("ConstructorWithParentTypeParams.java")
            public void testConstructorWithParentTypeParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/ConstructorWithParentTypeParams.java");
                doTest(fileName);
            }

            @TestMetadata("ConstructorWithSeveralParams.java")
            public void testConstructorWithSeveralParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/ConstructorWithSeveralParams.java");
                doTest(fileName);
            }

            @TestMetadata("ConstructorWithoutParams.java")
            public void testConstructorWithoutParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/ConstructorWithoutParams.java");
                doTest(fileName);
            }

            @TestMetadata("CustomProjectionKind.java")
            public void testCustomProjectionKind() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/CustomProjectionKind.java");
                doTest(fileName);
            }

            @TestMetadata("MethodWithFunctionTypes.java")
            public void testMethodWithFunctionTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/MethodWithFunctionTypes.java");
                doTest(fileName);
            }

            @TestMetadata("MethodWithGenerics.java")
            public void testMethodWithGenerics() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/MethodWithGenerics.java");
                doTest(fileName);
            }

            @TestMetadata("MethodWithMappedClasses.java")
            public void testMethodWithMappedClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/MethodWithMappedClasses.java");
                doTest(fileName);
            }

            @TestMetadata("MethodWithTypeParameters.java")
            public void testMethodWithTypeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/MethodWithTypeParameters.java");
                doTest(fileName);
            }

            @TestMetadata("MethodWithVararg.java")
            public void testMethodWithVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/MethodWithVararg.java");
                doTest(fileName);
            }

            @TestMetadata("PropertyArrayTypes.java")
            public void testPropertyArrayTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/PropertyArrayTypes.java");
                doTest(fileName);
            }

            @TestMetadata("PropertyComplexTypes.java")
            public void testPropertyComplexTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/PropertyComplexTypes.java");
                doTest(fileName);
            }

            @TestMetadata("PropertySimpleType.java")
            public void testPropertySimpleType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/PropertySimpleType.java");
                doTest(fileName);
            }

            @TestMetadata("StarProjection.java")
            public void testStarProjection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/StarProjection.java");
                doTest(fileName);
            }

            @TestMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/error")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Error extends AbstractJvmRuntimeDescriptorLoaderTest {
                public void testAllFilesPresentInError() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/kotlinSignature/error"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
                }

                @TestMetadata("WrongProjectionKind.java")
                public void testWrongProjectionKind() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/error/WrongProjectionKind.java");
                    doTest(fileName);
                }

                @TestMetadata("WrongReturnTypeStructure.java")
                public void testWrongReturnTypeStructure() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/error/WrongReturnTypeStructure.java");
                    doTest(fileName);
                }

                @TestMetadata("WrongTypeParameterBoundStructure1.java")
                public void testWrongTypeParameterBoundStructure1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/error/WrongTypeParameterBoundStructure1.java");
                    doTest(fileName);
                }

                @TestMetadata("WrongValueParameterStructure1.java")
                public void testWrongValueParameterStructure1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/kotlinSignature/error/WrongValueParameterStructure1.java");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/library")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Library extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInLibrary() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/library"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("LoadIterable.java")
            public void testLoadIterable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/library/LoadIterable.java");
                doTest(fileName);
            }

            @TestMetadata("LoadIterator.java")
            public void testLoadIterator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/library/LoadIterator.java");
                doTest(fileName);
            }

            @TestMetadata("Max.java")
            public void testMax() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/library/Max.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/modality")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Modality extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInModality() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/modality"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ModalityOfFakeOverrides.java")
            public void testModalityOfFakeOverrides() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/modality/ModalityOfFakeOverrides.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/mutability")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Mutability extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInMutability() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/mutability"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("LoadIterable.java")
            public void testLoadIterable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/mutability/LoadIterable.java");
                doTest(fileName);
            }

            @TestMetadata("LoadIterableWithConflict.java")
            public void testLoadIterableWithConflict() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/mutability/LoadIterableWithConflict.java");
                doTest(fileName);
            }

            @TestMetadata("LoadIterableWithNullability.java")
            public void testLoadIterableWithNullability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/mutability/LoadIterableWithNullability.java");
                doTest(fileName);
            }

            @TestMetadata("LoadIterableWithPropagation.java")
            public void testLoadIterableWithPropagation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/mutability/LoadIterableWithPropagation.java");
                doTest(fileName);
            }

            @TestMetadata("ReadOnlyExtendsWildcard.java")
            public void testReadOnlyExtendsWildcard() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/mutability/ReadOnlyExtendsWildcard.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/notNull")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NotNull extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInNotNull() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/notNull"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("NotNullField.java")
            public void testNotNullField() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/notNull/NotNullField.java");
                doTest(fileName);
            }

            @TestMetadata("NotNullIntArray.java")
            public void testNotNullIntArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/notNull/NotNullIntArray.java");
                doTest(fileName);
            }

            @TestMetadata("NotNullMethod.java")
            public void testNotNullMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/notNull/NotNullMethod.java");
                doTest(fileName);
            }

            @TestMetadata("NotNullObjectArray.java")
            public void testNotNullObjectArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/notNull/NotNullObjectArray.java");
                doTest(fileName);
            }

            @TestMetadata("NotNullParameter.java")
            public void testNotNullParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/notNull/NotNullParameter.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/protectedPackage")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProtectedPackage extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInProtectedPackage() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/protectedPackage"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ProtectedPackageConstructor.java")
            public void testProtectedPackageConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/protectedPackage/ProtectedPackageConstructor.java");
                doTest(fileName);
            }

            @TestMetadata("ProtectedPackageFun.java")
            public void testProtectedPackageFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/protectedPackage/ProtectedPackageFun.java");
                doTest(fileName);
            }

            @TestMetadata("ProtectedPackageProperty.java")
            public void testProtectedPackageProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/protectedPackage/ProtectedPackageProperty.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/protectedStatic")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ProtectedStatic extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInProtectedStatic() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/protectedStatic"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ConstructorInProtectedStaticNestedClass.java")
            public void testConstructorInProtectedStaticNestedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/protectedStatic/ConstructorInProtectedStaticNestedClass.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/rendering")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Rendering extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInRendering() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/rendering"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("Rendering.java")
            public void testRendering() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/rendering/Rendering.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/signaturePropagation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SignaturePropagation extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInSignaturePropagation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/signaturePropagation"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ArraysInSubtypes.java")
            public void testArraysInSubtypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/signaturePropagation/ArraysInSubtypes.java");
                doTest(fileName);
            }

            @TestMetadata("MethodTypeParameterErased.java")
            public void testMethodTypeParameterErased() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/signaturePropagation/MethodTypeParameterErased.java");
                doTest(fileName);
            }

            @TestMetadata("RawSuperType.java")
            public void testRawSuperType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/signaturePropagation/RawSuperType.java");
                doTest(fileName);
            }

            @TestMetadata("RawSuperTypeWithBound.java")
            public void testRawSuperTypeWithBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/signaturePropagation/RawSuperTypeWithBound.java");
                doTest(fileName);
            }

            @TestMetadata("RawSuperTypeWithRecursiveBound.java")
            public void testRawSuperTypeWithRecursiveBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/signaturePropagation/RawSuperTypeWithRecursiveBound.java");
                doTest(fileName);
            }

            @TestMetadata("RawSuperTypeWithRecursiveBoundMultipleParameters.java")
            public void testRawSuperTypeWithRecursiveBoundMultipleParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/signaturePropagation/RawSuperTypeWithRecursiveBoundMultipleParameters.java");
                doTest(fileName);
            }

            @TestMetadata("ReturnInnerSubclassOfSupersInner.java")
            public void testReturnInnerSubclassOfSupersInner() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/signaturePropagation/ReturnInnerSubclassOfSupersInner.java");
                doTest(fileName);
            }

            @TestMetadata("SubclassWithRawType.java")
            public void testSubclassWithRawType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/signaturePropagation/SubclassWithRawType.java");
                doTest(fileName);
            }

            @TestMetadata("TwoSuperclassesInconsistentGenericTypes.java")
            public void testTwoSuperclassesInconsistentGenericTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/signaturePropagation/TwoSuperclassesInconsistentGenericTypes.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/static")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Static extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInStatic() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/static"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("DeeplyInnerClass.java")
            public void testDeeplyInnerClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/DeeplyInnerClass.java");
                doTest(fileName);
            }

            @TestMetadata("DeeplyNestedStatic.java")
            public void testDeeplyNestedStatic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/DeeplyNestedStatic.java");
                doTest(fileName);
            }

            @TestMetadata("Enum.java")
            public void testEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/Enum.java");
                doTest(fileName);
            }

            @TestMetadata("InnerClass.java")
            public void testInnerClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/InnerClass.java");
                doTest(fileName);
            }

            @TestMetadata("Simple.java")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/Simple.java");
                doTest(fileName);
            }

            @TestMetadata("StaticFinal.java")
            public void testStaticFinal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/StaticFinal.java");
                doTest(fileName);
            }

            @TestMetadata("StaticMembersFromParentClass.java")
            public void testStaticMembersFromParentClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/StaticMembersFromParentClass.java");
                doTest(fileName);
            }

            @TestMetadata("StaticMembersFromParentClassVisibility.java")
            public void testStaticMembersFromParentClassVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/StaticMembersFromParentClassVisibility.java");
                doTest(fileName);
            }

            @TestMetadata("StaticMembersFromParentInterface.java")
            public void testStaticMembersFromParentInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/StaticMembersFromParentInterface.java");
                doTest(fileName);
            }

            @TestMetadata("StaticMembersInEnum.java")
            public void testStaticMembersInEnum() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/StaticMembersInEnum.java");
                doTest(fileName);
            }

            @TestMetadata("StaticMembersInEnumFromParents.java")
            public void testStaticMembersInEnumFromParents() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/static/StaticMembersInEnumFromParents.java");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/loadJava/compiledJava/vararg")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Vararg extends AbstractJvmRuntimeDescriptorLoaderTest {
            public void testAllFilesPresentInVararg() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/loadJava/compiledJava/vararg"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("VarargInt.java")
            public void testVarargInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/vararg/VarargInt.java");
                doTest(fileName);
            }

            @TestMetadata("VarargString.java")
            public void testVarargString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/loadJava/compiledJava/vararg/VarargString.java");
                doTest(fileName);
            }
        }
    }
}
