/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.parsing;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class ParsingTestGenerated extends AbstractParsingTest {
    @TestMetadata("compiler/testData/psi")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Psi extends AbstractParsingTest {
        @TestMetadata("AbsentInnerType.kt")
        public void testAbsentInnerType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/AbsentInnerType.kt");
            doParsingTest(fileName);
        }

        public void testAllFilesPresentInPsi() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AnonymousInitializer.kt")
        public void testAnonymousInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/AnonymousInitializer.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("AssertNotNull.kt")
        public void testAssertNotNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/AssertNotNull.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("BabySteps.kt")
        public void testBabySteps() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/BabySteps.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("BabySteps_ERR.kt")
        public void testBabySteps_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/BabySteps_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("BackslashInString.kt")
        public void testBackslashInString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/BackslashInString.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("BlockCommentAtBeginningOfFile1.kt")
        public void testBlockCommentAtBeginningOfFile1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/BlockCommentAtBeginningOfFile1.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("BlockCommentAtBeginningOfFile2.kt")
        public void testBlockCommentAtBeginningOfFile2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/BlockCommentAtBeginningOfFile2.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("BlockCommentAtBeginningOfFile3.kt")
        public void testBlockCommentAtBeginningOfFile3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/BlockCommentAtBeginningOfFile3.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("BlockCommentAtBeginningOfFile4.kt")
        public void testBlockCommentAtBeginningOfFile4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/BlockCommentAtBeginningOfFile4.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("BlockCommentUnmatchedClosing_ERR.kt")
        public void testBlockCommentUnmatchedClosing_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/BlockCommentUnmatchedClosing_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("ByClauses.kt")
        public void testByClauses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/ByClauses.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("CallWithManyClosures.kt")
        public void testCallWithManyClosures() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/CallWithManyClosures.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("CallsInWhen.kt")
        public void testCallsInWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/CallsInWhen.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("CommentsBinding.kt")
        public void testCommentsBinding() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/CommentsBinding.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("CommentsBindingInLambda.kt")
        public void testCommentsBindingInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/CommentsBindingInLambda.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("CommentsBindingInStatementBlock.kt")
        public void testCommentsBindingInStatementBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/CommentsBindingInStatementBlock.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Constructors.kt")
        public void testConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Constructors.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("ControlStructures.kt")
        public void testControlStructures() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/ControlStructures.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DefaultKeyword.kt")
        public void testDefaultKeyword() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DefaultKeyword.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("destructuringInLambdas.kt")
        public void testDestructuringInLambdas() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/destructuringInLambdas.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("destructuringInLambdas_ERR.kt")
        public void testDestructuringInLambdas_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/destructuringInLambdas_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DocCommentAfterFileAnnotations.kt")
        public void testDocCommentAfterFileAnnotations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DocCommentAfterFileAnnotations.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DocCommentForFirstDeclaration.kt")
        public void testDocCommentForFirstDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DocCommentForFirstDeclaration.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DocCommentOnPackageDirectiveLine.kt")
        public void testDocCommentOnPackageDirectiveLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DocCommentOnPackageDirectiveLine.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DocCommentsBinding.kt")
        public void testDocCommentsBinding() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DocCommentsBinding.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DoubleColon.kt")
        public void testDoubleColon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DoubleColon.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DoubleColonWhitespaces.kt")
        public void testDoubleColonWhitespaces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DoubleColonWhitespaces.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DoubleColon_ERR.kt")
        public void testDoubleColon_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DoubleColon_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DuplicateAccessor.kt")
        public void testDuplicateAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DuplicateAccessor.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DynamicReceiver.kt")
        public void testDynamicReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DynamicReceiver.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DynamicSoftKeyword.kt")
        public void testDynamicSoftKeyword() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DynamicSoftKeyword.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("DynamicTypes.kt")
        public void testDynamicTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/DynamicTypes.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EOLsInComments.kt")
        public void testEOLsInComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EOLsInComments.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EOLsOnRollback.kt")
        public void testEOLsOnRollback() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EOLsOnRollback.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EmptyFile.kt")
        public void testEmptyFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EmptyFile.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EmptyName.kt")
        public void testEmptyName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EmptyName.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumCommas.kt")
        public void testEnumCommas() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumCommas.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumEntryCommaAnnotatedMember.kt")
        public void testEnumEntryCommaAnnotatedMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumEntryCommaAnnotatedMember.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumEntryCommaInlineMember.kt")
        public void testEnumEntryCommaInlineMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumEntryCommaInlineMember.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumEntryCommaMember.kt")
        public void testEnumEntryCommaMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumEntryCommaMember.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumEntryCommaPublicMember.kt")
        public void testEnumEntryCommaPublicMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumEntryCommaPublicMember.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumEntrySemicolonInlineMember.kt")
        public void testEnumEntrySemicolonInlineMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumEntrySemicolonInlineMember.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumEntrySemicolonMember.kt")
        public void testEnumEntrySemicolonMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumEntrySemicolonMember.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumEntrySpaceInlineMember.kt")
        public void testEnumEntrySpaceInlineMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumEntrySpaceInlineMember.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumEntrySpaceMember.kt")
        public void testEnumEntrySpaceMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumEntrySpaceMember.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumEntryTwoCommas.kt")
        public void testEnumEntryTwoCommas() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumEntryTwoCommas.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumIn.kt")
        public void testEnumIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumIn.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumInline.kt")
        public void testEnumInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumInline.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumInlinePublic.kt")
        public void testEnumInlinePublic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumInlinePublic.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumMissingName.kt")
        public void testEnumMissingName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumMissingName.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumOldConstructorSyntax.kt")
        public void testEnumOldConstructorSyntax() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumOldConstructorSyntax.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumShortCommas.kt")
        public void testEnumShortCommas() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumShortCommas.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumShortWithOverload.kt")
        public void testEnumShortWithOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumShortWithOverload.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("EnumWithAnnotationKeyword.kt")
        public void testEnumWithAnnotationKeyword() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/EnumWithAnnotationKeyword.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Enums.kt")
        public void testEnums() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Enums.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Expressions_ERR.kt")
        public void testExpressions_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Expressions_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("ExtensionsWithQNReceiver.kt")
        public void testExtensionsWithQNReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/ExtensionsWithQNReceiver.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FileStart_ERR.kt")
        public void testFileStart_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FileStart_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FloatingPointLiteral.kt")
        public void testFloatingPointLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FloatingPointLiteral.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("ForWithMultiDecl.kt")
        public void testForWithMultiDecl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/ForWithMultiDecl.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FunctionCalls.kt")
        public void testFunctionCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FunctionCalls.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FunctionExpressions.kt")
        public void testFunctionExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FunctionExpressions.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FunctionExpressions_ERR.kt")
        public void testFunctionExpressions_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FunctionExpressions_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FunctionLiterals.kt")
        public void testFunctionLiterals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FunctionLiterals.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FunctionLiterals_ERR.kt")
        public void testFunctionLiterals_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FunctionLiterals_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FunctionNoParameterList.kt")
        public void testFunctionNoParameterList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FunctionNoParameterList.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FunctionTypes.kt")
        public void testFunctionTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FunctionTypes.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FunctionTypes_ERR.kt")
        public void testFunctionTypes_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FunctionTypes_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Functions.kt")
        public void testFunctions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Functions.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FunctionsWithoutName.kt")
        public void testFunctionsWithoutName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FunctionsWithoutName.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("FunctionsWithoutName_ERR.kt")
        public void testFunctionsWithoutName_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/FunctionsWithoutName_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Functions_ERR.kt")
        public void testFunctions_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Functions_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("HangOnLonelyModifier.kt")
        public void testHangOnLonelyModifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/HangOnLonelyModifier.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("IfWithPropery.kt")
        public void testIfWithPropery() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/IfWithPropery.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("ImportSoftKW.kt")
        public void testImportSoftKW() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/ImportSoftKW.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Imports.kt")
        public void testImports() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Imports.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Imports_ERR.kt")
        public void testImports_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Imports_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("IncompleteFunctionLiteral.kt")
        public void testIncompleteFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/IncompleteFunctionLiteral.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Inner.kt")
        public void testInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Inner.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("IntegerLiteral.kt")
        public void testIntegerLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/IntegerLiteral.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Interface.kt")
        public void testInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Interface.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("InterfaceWithEnumKeyword.kt")
        public void testInterfaceWithEnumKeyword() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/InterfaceWithEnumKeyword.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Labels.kt")
        public void testLabels() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Labels.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("LineCommentAfterFileAnnotations.kt")
        public void testLineCommentAfterFileAnnotations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/LineCommentAfterFileAnnotations.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("LineCommentForFirstDeclaration.kt")
        public void testLineCommentForFirstDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/LineCommentForFirstDeclaration.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("LineCommentsInBlock.kt")
        public void testLineCommentsInBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/LineCommentsInBlock.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("LocalDeclarations.kt")
        public void testLocalDeclarations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/LocalDeclarations.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("LongPackageName.kt")
        public void testLongPackageName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/LongPackageName.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("ModifierAsSelector.kt")
        public void testModifierAsSelector() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/ModifierAsSelector.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("MultiVariableDeclarations.kt")
        public void testMultiVariableDeclarations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/MultiVariableDeclarations.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("NamedClassObject.kt")
        public void testNamedClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/NamedClassObject.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("namelessObjectAsEnumMember.kt")
        public void testNamelessObjectAsEnumMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/namelessObjectAsEnumMember.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("NestedComments.kt")
        public void testNestedComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/NestedComments.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("NewLinesValidOperations.kt")
        public void testNewLinesValidOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/NewLinesValidOperations.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("NewlinesInParentheses.kt")
        public void testNewlinesInParentheses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/NewlinesInParentheses.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("NonTypeBeforeDotInBaseClass.kt")
        public void testNonTypeBeforeDotInBaseClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/NonTypeBeforeDotInBaseClass.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("NotIsAndNotIn.kt")
        public void testNotIsAndNotIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/NotIsAndNotIn.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("ObjectLiteralAsStatement.kt")
        public void testObjectLiteralAsStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/ObjectLiteralAsStatement.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("ParameterNameMising.kt")
        public void testParameterNameMising() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/ParameterNameMising.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("ParameterType.kt")
        public void testParameterType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/ParameterType.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("ParameterType_ERR.kt")
        public void testParameterType_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/ParameterType_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Precedence.kt")
        public void testPrecedence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Precedence.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("PrimaryConstructorModifiers_ERR.kt")
        public void testPrimaryConstructorModifiers_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/PrimaryConstructorModifiers_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Properties.kt")
        public void testProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Properties.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("PropertiesFollowedByInitializers.kt")
        public void testPropertiesFollowedByInitializers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/PropertiesFollowedByInitializers.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Properties_ERR.kt")
        public void testProperties_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Properties_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("PropertyInvokes.kt")
        public void testPropertyInvokes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/PropertyInvokes.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("QuotedIdentifiers.kt")
        public void testQuotedIdentifiers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/QuotedIdentifiers.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Reserved.kt")
        public void testReserved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Reserved.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("SemicolonAfterIf.kt")
        public void testSemicolonAfterIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/SemicolonAfterIf.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("semicolonBetweenDeclarations.kt")
        public void testSemicolonBetweenDeclarations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/semicolonBetweenDeclarations.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("SimpleClassMembers.kt")
        public void testSimpleClassMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/SimpleClassMembers.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("SimpleClassMembers_ERR.kt")
        public void testSimpleClassMembers_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/SimpleClassMembers_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("SimpleExpressions.kt")
        public void testSimpleExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/SimpleExpressions.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("SimpleModifiers.kt")
        public void testSimpleModifiers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/SimpleModifiers.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("SoftKeywords.kt")
        public void testSoftKeywords() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/SoftKeywords.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("SoftKeywordsInTypeArguments.kt")
        public void testSoftKeywordsInTypeArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/SoftKeywordsInTypeArguments.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("StringTemplates.kt")
        public void testStringTemplates() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/StringTemplates.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("Super.kt")
        public void testSuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/Super.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("TraitConstructor.kt")
        public void testTraitConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/TraitConstructor.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("TripleDot.kt")
        public void testTripleDot() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/TripleDot.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("TryRecovery.kt")
        public void testTryRecovery() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/TryRecovery.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("TypeAlias.kt")
        public void testTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/TypeAlias.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("TypeAlias_ERR.kt")
        public void testTypeAlias_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/TypeAlias_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("TypeConstraints.kt")
        public void testTypeConstraints() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/TypeConstraints.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("TypeExpressionAmbiguities_ERR.kt")
        public void testTypeExpressionAmbiguities_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/TypeExpressionAmbiguities_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("TypeParametersBeforeName.kt")
        public void testTypeParametersBeforeName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/TypeParametersBeforeName.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("TypealiasIsKeyword.kt")
        public void testTypealiasIsKeyword() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/TypealiasIsKeyword.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("When.kt")
        public void testWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/When.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("When_ERR.kt")
        public void testWhen_ERR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/When_ERR.kt");
            doParsingTest(fileName);
        }

        @TestMetadata("compiler/testData/psi/annotation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotation extends AbstractParsingTest {
            public void testAllFilesPresentInAnnotation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/annotation"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AnnotatedExpressions.kt")
            public void testAnnotatedExpressions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/AnnotatedExpressions.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Annotations.kt")
            public void testAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/Annotations.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("annotationsOnNullableTypes.kt")
            public void testAnnotationsOnNullableTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/annotationsOnNullableTypes.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("AnnotationsOnPatterns.kt")
            public void testAnnotationsOnPatterns() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/AnnotationsOnPatterns.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Annotations_ERR.kt")
            public void testAnnotations_ERR() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/Annotations_ERR.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("forParameters.kt")
            public void testForParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/forParameters.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/lambda.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("lambdaRecovery.kt")
            public void testLambdaRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/lambdaRecovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("multiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/multiDeclaration.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("noParameterYet.kt")
            public void testNoParameterYet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/noParameterYet.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("oldAnnotationsRecovery.kt")
            public void testOldAnnotationsRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/oldAnnotationsRecovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ShortAnnotations.kt")
            public void testShortAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/ShortAnnotations.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("compiler/testData/psi/annotation/at")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class At extends AbstractParsingTest {
                public void testAllFilesPresentInAt() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/annotation/at"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationAtFileStart.kt")
                public void testAnnotationAtFileStart() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/annotationAtFileStart.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("annotationValueArgumentsAmbiguity.kt")
                public void testAnnotationValueArgumentsAmbiguity() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/annotationValueArgumentsAmbiguity.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("blockLevelExpressions.kt")
                public void testBlockLevelExpressions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/blockLevelExpressions.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("blockLevelExpressionsNoNewLine.kt")
                public void testBlockLevelExpressionsNoNewLine() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/blockLevelExpressionsNoNewLine.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("danglingBlockLevelAnnotations.kt")
                public void testDanglingBlockLevelAnnotations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/danglingBlockLevelAnnotations.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("declarationsJustAtTyped.kt")
                public void testDeclarationsJustAtTyped() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/declarationsJustAtTyped.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("enumEntries.kt")
                public void testEnumEntries() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/enumEntries.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("expressionJustAtTyped.kt")
                public void testExpressionJustAtTyped() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/expressionJustAtTyped.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("modifierAtFileStart.kt")
                public void testModifierAtFileStart() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/modifierAtFileStart.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("primaryConstructor.kt")
                public void testPrimaryConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/primaryConstructor.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("validDeclarations.kt")
                public void testValidDeclarations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/validDeclarations.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("validExpressions.kt")
                public void testValidExpressions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/at/validExpressions.kt");
                    doParsingTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/psi/annotation/list")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class List extends AbstractParsingTest {
                public void testAllFilesPresentInList() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/annotation/list"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("basic.kt")
                public void testBasic() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/list/basic.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("recovery.kt")
                public void testRecovery() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/list/recovery.kt");
                    doParsingTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/psi/annotation/modifiersMigration")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ModifiersMigration extends AbstractParsingTest {
                public void testAllFilesPresentInModifiersMigration() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/annotation/modifiersMigration"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("newModifiers.kt")
                public void testNewModifiers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/modifiersMigration/newModifiers.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("oldUsages.kt")
                public void testOldUsages() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/modifiersMigration/oldUsages.kt");
                    doParsingTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/psi/annotation/options")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Options extends AbstractParsingTest {
                public void testAllFilesPresentInOptions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/annotation/options"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationAsArg.kt")
                public void testAnnotationAsArg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/options/annotationAsArg.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("annotationAsArgComplex.kt")
                public void testAnnotationAsArgComplex() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/options/annotationAsArgComplex.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("java.kt")
                public void testJava() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/options/java.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("local.kt")
                public void testLocal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/options/local.kt");
                    doParsingTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/psi/annotation/targeted")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Targeted extends AbstractParsingTest {
                public void testAllFilesPresentInTargeted() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/annotation/targeted"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/testData/psi/annotation/targeted/onField")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnField extends AbstractParsingTest {
                    public void testAllFilesPresentInOnField() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/annotation/targeted/onField"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("delegate.kt")
                    public void testDelegate() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onField/delegate.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("fqName.kt")
                    public void testFqName() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onField/fqName.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("inWrongPlace.kt")
                    public void testInWrongPlace() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onField/inWrongPlace.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("manyInOneAnnotationBlock.kt")
                    public void testManyInOneAnnotationBlock() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onField/manyInOneAnnotationBlock.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("simpleFieldAnnotation.kt")
                    public void testSimpleFieldAnnotation() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onField/simpleFieldAnnotation.kt");
                        doParsingTest(fileName);
                    }
                }

                @TestMetadata("compiler/testData/psi/annotation/targeted/onFile")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnFile extends AbstractParsingTest {
                    public void testAllFilesPresentInOnFile() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/annotation/targeted/onFile"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("fileAnnotationInWrongPlace.kt")
                    public void testFileAnnotationInWrongPlace() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onFile/fileAnnotationInWrongPlace.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("manyAnnotationBlocks.kt")
                    public void testManyAnnotationBlocks() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onFile/manyAnnotationBlocks.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("manyInOneAnnotationBlock.kt")
                    public void testManyInOneAnnotationBlock() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onFile/manyInOneAnnotationBlock.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("nonFIleAnnotationBeforePackage.kt")
                    public void testNonFIleAnnotationBeforePackage() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onFile/nonFIleAnnotationBeforePackage.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("single.kt")
                    public void testSingle() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onFile/single.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("withoutFileAnnotationAndPackageDeclaration.kt")
                    public void testWithoutFileAnnotationAndPackageDeclaration() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onFile/withoutFileAnnotationAndPackageDeclaration.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("withoutPackage.kt")
                    public void testWithoutPackage() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onFile/withoutPackage.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("withoutPackageWithSimpleAnnotation.kt")
                    public void testWithoutPackageWithSimpleAnnotation() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onFile/withoutPackageWithSimpleAnnotation.kt");
                        doParsingTest(fileName);
                    }
                }

                @TestMetadata("compiler/testData/psi/annotation/targeted/onGetSetSparam")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnGetSetSparam extends AbstractParsingTest {
                    public void testAllFilesPresentInOnGetSetSparam() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/annotation/targeted/onGetSetSparam"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("inWrongPlace.kt")
                    public void testInWrongPlace() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onGetSetSparam/inWrongPlace.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("simple.kt")
                    public void testSimple() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onGetSetSparam/simple.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("twoAnnotationLists.kt")
                    public void testTwoAnnotationLists() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onGetSetSparam/twoAnnotationLists.kt");
                        doParsingTest(fileName);
                    }
                }

                @TestMetadata("compiler/testData/psi/annotation/targeted/onParam")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class OnParam extends AbstractParsingTest {
                    public void testAllFilesPresentInOnParam() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/annotation/targeted/onParam"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("modifiers.kt")
                    public void testModifiers() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onParam/modifiers.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("recovery.kt")
                    public void testRecovery() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onParam/recovery.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("simple.kt")
                    public void testSimple() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onParam/simple.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("targetExpected.kt")
                    public void testTargetExpected() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/annotation/targeted/onParam/targetExpected.kt");
                        doParsingTest(fileName);
                    }
                }
            }
        }

        @TestMetadata("compiler/testData/psi/examples")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Examples extends AbstractParsingTest {
            public void testAllFilesPresentInExamples() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/examples"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AnonymousObjects.kt")
            public void testAnonymousObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/AnonymousObjects.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("BinaryTree.kt")
            public void testBinaryTree() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/BinaryTree.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("BitArith.kt")
            public void testBitArith() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/BitArith.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Builder.kt")
            public void testBuilder() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/Builder.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Color.kt")
            public void testColor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/Color.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("FunctionsAndTypes.kt")
            public void testFunctionsAndTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/FunctionsAndTypes.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Graph.kt")
            public void testGraph() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/Graph.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IPushPop.kt")
            public void testIPushPop() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/IPushPop.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("LINQ.kt")
            public void testLINQ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/LINQ.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Queue.kt")
            public void testQueue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/Queue.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Stack.kt")
            public void testStack() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/Stack.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("UnionFind.kt")
            public void testUnionFind() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/UnionFind.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("UpdateOperation.kt")
            public void testUpdateOperation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/UpdateOperation.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("With.kt")
            public void testWith() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/With.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("compiler/testData/psi/examples/array")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Array extends AbstractParsingTest {
                public void testAllFilesPresentInArray() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/examples/array"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("MutableArray.kt")
                public void testMutableArray() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/array/MutableArray.kt");
                    doParsingTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/psi/examples/collections")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Collections extends AbstractParsingTest {
                public void testAllFilesPresentInCollections() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/examples/collections"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ArrayList.kt")
                public void testArrayList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/ArrayList.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("HashMap.kt")
                public void testHashMap() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/HashMap.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("IIterable.kt")
                public void testIIterable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/IIterable.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("IIterator.kt")
                public void testIIterator() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/IIterator.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("IList.kt")
                public void testIList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/IList.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("IMutableIterable.kt")
                public void testIMutableIterable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/IMutableIterable.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("IMutableIterator.kt")
                public void testIMutableIterator() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/IMutableIterator.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("IMutableList.kt")
                public void testIMutableList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/IMutableList.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("IMutableSet.kt")
                public void testIMutableSet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/IMutableSet.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("ISet.kt")
                public void testISet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/ISet.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("ISized.kt")
                public void testISized() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/ISized.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("LinkedList.kt")
                public void testLinkedList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/collections/LinkedList.kt");
                    doParsingTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/psi/examples/io")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Io extends AbstractParsingTest {
                public void testAllFilesPresentInIo() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/examples/io"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("IOSamples.kt")
                public void testIOSamples() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/io/IOSamples.kt");
                    doParsingTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/psi/examples/map")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Map extends AbstractParsingTest {
                public void testAllFilesPresentInMap() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/examples/map"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("IMap.kt")
                public void testIMap() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/map/IMap.kt");
                    doParsingTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/psi/examples/priorityqueues")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Priorityqueues extends AbstractParsingTest {
                public void testAllFilesPresentInPriorityqueues() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/examples/priorityqueues"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("BinaryHeap.kt")
                public void testBinaryHeap() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/priorityqueues/BinaryHeap.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("IPriorityQueue.kt")
                public void testIPriorityQueue() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/priorityqueues/IPriorityQueue.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("PriorityQueueAsPushPop.kt")
                public void testPriorityQueueAsPushPop() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/priorityqueues/PriorityQueueAsPushPop.kt");
                    doParsingTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/psi/examples/util")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Util extends AbstractParsingTest {
                public void testAllFilesPresentInUtil() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/examples/util"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("Comparison.kt")
                public void testComparison() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/util/Comparison.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("IComparable.kt")
                public void testIComparable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/examples/util/IComparable.kt");
                    doParsingTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/psi/functionReceivers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionReceivers extends AbstractParsingTest {
            public void testAllFilesPresentInFunctionReceivers() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/functionReceivers"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("FunctionTypesWithFunctionReceivers.kt")
            public void testFunctionTypesWithFunctionReceivers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/functionReceivers/FunctionTypesWithFunctionReceivers.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("FunctionsWithFunctionReceivers.kt")
            public void testFunctionsWithFunctionReceivers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/functionReceivers/FunctionsWithFunctionReceivers.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("FunctionsWithFunctionReceiversAnnotations.kt")
            public void testFunctionsWithFunctionReceiversAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/functionReceivers/FunctionsWithFunctionReceiversAnnotations.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("FunctionsWithFunctionReceiversRecovery.kt")
            public void testFunctionsWithFunctionReceiversRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/functionReceivers/FunctionsWithFunctionReceiversRecovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PropertiesWithFunctionReceivers.kt")
            public void testPropertiesWithFunctionReceivers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/functionReceivers/PropertiesWithFunctionReceivers.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PropertiesWithFunctionReceiversAnnotations.kt")
            public void testPropertiesWithFunctionReceiversAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/functionReceivers/PropertiesWithFunctionReceiversAnnotations.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PropertiesWithFunctionReceiversRecovery.kt")
            public void testPropertiesWithFunctionReceiversRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/functionReceivers/PropertiesWithFunctionReceiversRecovery.kt");
                doParsingTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/psi/greatSyntacticShift")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class GreatSyntacticShift extends AbstractParsingTest {
            public void testAllFilesPresentInGreatSyntacticShift() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/greatSyntacticShift"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("functionLiterals.kt")
            public void testFunctionLiterals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/greatSyntacticShift/functionLiterals.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("functionTypes.kt")
            public void testFunctionTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/greatSyntacticShift/functionTypes.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("FunctionTypesAsArguments.kt")
            public void testFunctionTypesAsArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/greatSyntacticShift/FunctionTypesAsArguments.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("nullableTypes.kt")
            public void testNullableTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/greatSyntacticShift/nullableTypes.kt");
                doParsingTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/psi/kdoc")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Kdoc extends AbstractParsingTest {
            public void testAllFilesPresentInKdoc() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/kdoc"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("AtTags.kt")
            public void testAtTags() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/AtTags.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("DocCommentAtBeginningOfFile1.kt")
            public void testDocCommentAtBeginningOfFile1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/DocCommentAtBeginningOfFile1.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("DocCommentAtBeginningOfFile2.kt")
            public void testDocCommentAtBeginningOfFile2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/DocCommentAtBeginningOfFile2.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("DocCommentAtBeginningOfFile3.kt")
            public void testDocCommentAtBeginningOfFile3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/DocCommentAtBeginningOfFile3.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("DocCommentAtBeginningOfFile4.kt")
            public void testDocCommentAtBeginningOfFile4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/DocCommentAtBeginningOfFile4.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("EndOnLeadingAsterisks.kt")
            public void testEndOnLeadingAsterisks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/EndOnLeadingAsterisks.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("EndRightAfterText.kt")
            public void testEndRightAfterText() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/EndRightAfterText.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("HttpLink.kt")
            public void testHttpLink() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/HttpLink.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Incomplete.kt")
            public void testIncomplete() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/Incomplete.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Markdown.kt")
            public void testMarkdown() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/Markdown.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("MarkdownLinkWithError.kt")
            public void testMarkdownLinkWithError() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/MarkdownLinkWithError.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("MarkdownLinkWithLabel.kt")
            public void testMarkdownLinkWithLabel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/MarkdownLinkWithLabel.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("MarkdownQualifiedName.kt")
            public void testMarkdownQualifiedName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/MarkdownQualifiedName.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ParamTag.kt")
            public void testParamTag() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/ParamTag.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ParamTagAtStart.kt")
            public void testParamTagAtStart() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/ParamTagAtStart.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ReturnWithBrackets.kt")
            public void testReturnWithBrackets() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/ReturnWithBrackets.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Sections.kt")
            public void testSections() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/Sections.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("SeeEmpty.kt")
            public void testSeeEmpty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/SeeEmpty.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("SeeLink.kt")
            public void testSeeLink() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/SeeLink.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/Simple.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("TextRightAfterLeadAsterisks.kt")
            public void testTextRightAfterLeadAsterisks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/TextRightAfterLeadAsterisks.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("TwoTags.kt")
            public void testTwoTags() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/kdoc/TwoTags.kt");
                doParsingTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/psi/newLabels")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NewLabels extends AbstractParsingTest {
            public void testAllFilesPresentInNewLabels() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/newLabels"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/newLabels/basic.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("oldSyntaxExpressions.kt")
            public void testOldSyntaxExpressions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/newLabels/oldSyntaxExpressions.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("recovery.kt")
            public void testRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/newLabels/recovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("spaceBeforeLabelReference.kt")
            public void testSpaceBeforeLabelReference() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/newLabels/spaceBeforeLabelReference.kt");
                doParsingTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/psi/packages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Packages extends AbstractParsingTest {
            public void testAllFilesPresentInPackages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/packages"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("PackageBlockFirst.kt")
            public void testPackageBlockFirst() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageBlockFirst.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageLeadingDotDoubleID.kt")
            public void testPackageLeadingDotDoubleID() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageLeadingDotDoubleID.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageLongNameBetweenDots.kt")
            public void testPackageLongNameBetweenDots() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageLongNameBetweenDots.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageLongNameDoubleID.kt")
            public void testPackageLongNameDoubleID() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageLongNameDoubleID.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageLongNameLeadingDot.kt")
            public void testPackageLongNameLeadingDot() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageLongNameLeadingDot.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageLongNameLeadingDoubleDot.kt")
            public void testPackageLongNameLeadingDoubleDot() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageLongNameLeadingDoubleDot.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageModifiers.kt")
            public void testPackageModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageModifiers.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageNameDoubleDot.kt")
            public void testPackageNameDoubleDot() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageNameDoubleDot.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageNameJustDot.kt")
            public void testPackageNameJustDot() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageNameJustDot.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageSimpleNameLeadingDot.kt")
            public void testPackageSimpleNameLeadingDot() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageSimpleNameLeadingDot.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageSimpleNameLeadingDoubleDot.kt")
            public void testPackageSimpleNameLeadingDoubleDot() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/packages/PackageSimpleNameLeadingDoubleDot.kt");
                doParsingTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/psi/platformTypesRecovery")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PlatformTypesRecovery extends AbstractParsingTest {
            public void testAllFilesPresentInPlatformTypesRecovery() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/platformTypesRecovery"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("Array.kt")
            public void testArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/platformTypesRecovery/Array.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("BeforeDot.kt")
            public void testBeforeDot() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/platformTypesRecovery/BeforeDot.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Collections.kt")
            public void testCollections() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/platformTypesRecovery/Collections.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("FunctionsNotPlatform.kt")
            public void testFunctionsNotPlatform() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/platformTypesRecovery/FunctionsNotPlatform.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("MapEntry.kt")
            public void testMapEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/platformTypesRecovery/MapEntry.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ParenthesizedNotPlatform.kt")
            public void testParenthesizedNotPlatform() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/platformTypesRecovery/ParenthesizedNotPlatform.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Qualified.kt")
            public void testQualified() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/platformTypesRecovery/Qualified.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("QualifiedCollections.kt")
            public void testQualifiedCollections() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/platformTypesRecovery/QualifiedCollections.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("Simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/platformTypesRecovery/Simple.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("WrongWordInParentheses.kt")
            public void testWrongWordInParentheses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/platformTypesRecovery/WrongWordInParentheses.kt");
                doParsingTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/psi/primaryConstructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PrimaryConstructor extends AbstractParsingTest {
            public void testAllFilesPresentInPrimaryConstructor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/primaryConstructor"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/primaryConstructor/local.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("nestedClassAmbiguity.kt")
            public void testNestedClassAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/primaryConstructor/nestedClassAmbiguity.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("recovery.kt")
            public void testRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/primaryConstructor/recovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("recoveryNestedClassAmbiguity.kt")
            public void testRecoveryNestedClassAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/primaryConstructor/recoveryNestedClassAmbiguity.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("valid.kt")
            public void testValid() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/primaryConstructor/valid.kt");
                doParsingTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/psi/propertyDelegate")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PropertyDelegate extends AbstractParsingTest {
            public void testAllFilesPresentInPropertyDelegate() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/propertyDelegate"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("BracketsInDelegate.kt")
            public void testBracketsInDelegate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/BracketsInDelegate.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("DelegateAndInitializer.kt")
            public void testDelegateAndInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/DelegateAndInitializer.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("GetterInSameLine.kt")
            public void testGetterInSameLine() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/GetterInSameLine.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("LocalProperty.kt")
            public void testLocalProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/LocalProperty.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("OnlyBy.kt")
            public void testOnlyBy() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/OnlyBy.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PropertyInClass.kt")
            public void testPropertyInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/PropertyInClass.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PropertyWithGetter.kt")
            public void testPropertyWithGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/PropertyWithGetter.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PropertyWithInitializer.kt")
            public void testPropertyWithInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/PropertyWithInitializer.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PropertyWithoutTypeRef.kt")
            public void testPropertyWithoutTypeRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/PropertyWithoutTypeRef.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("TopLevelProperty.kt")
            public void testTopLevelProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/TopLevelProperty.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("TwoProperties.kt")
            public void testTwoProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/propertyDelegate/TwoProperties.kt");
                doParsingTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/psi/recovery")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Recovery extends AbstractParsingTest {
            @TestMetadata("AbsentLeftHandSide.kt")
            public void testAbsentLeftHandSide() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/AbsentLeftHandSide.kt");
                doParsingTest(fileName);
            }

            public void testAllFilesPresentInRecovery() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/recovery"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("BareVal.kt")
            public void testBareVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/BareVal.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("BrokenFunctionSuperType.kt")
            public void testBrokenFunctionSuperType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/BrokenFunctionSuperType.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("CatchKeywordRBrace.kt")
            public void testCatchKeywordRBrace() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/CatchKeywordRBrace.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("CloseBraceAtTopLevel.kt")
            public void testCloseBraceAtTopLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/CloseBraceAtTopLevel.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("DeclarationAfterDotSelectorExpected.kt")
            public void testDeclarationAfterDotSelectorExpected() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/DeclarationAfterDotSelectorExpected.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("DeclarationAfterIncompleteElvis.kt")
            public void testDeclarationAfterIncompleteElvis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/DeclarationAfterIncompleteElvis.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("DoWhileWithEmptyCondition.kt")
            public void testDoWhileWithEmptyCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/DoWhileWithEmptyCondition.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("DoWhileWithoutLPar.kt")
            public void testDoWhileWithoutLPar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/DoWhileWithoutLPar.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ForEmptyParentheses.kt")
            public void testForEmptyParentheses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ForEmptyParentheses.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ForEmptyWithoutBody.kt")
            public void testForEmptyWithoutBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ForEmptyWithoutBody.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ForNoBodyBeforeRBrace.kt")
            public void testForNoBodyBeforeRBrace() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ForNoBodyBeforeRBrace.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ForRecovery.kt")
            public void testForRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ForRecovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ForWithOnlyOneLParInEOF.kt")
            public void testForWithOnlyOneLParInEOF() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ForWithOnlyOneLParInEOF.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ForWithoutBodyInEOF.kt")
            public void testForWithoutBodyInEOF() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ForWithoutBodyInEOF.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ForWithoutLPar.kt")
            public void testForWithoutLPar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ForWithoutLPar.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ForWithoutLParInEOF.kt")
            public void testForWithoutLParInEOF() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ForWithoutLParInEOF.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ForWithoutParamButWithRange.kt")
            public void testForWithoutParamButWithRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ForWithoutParamButWithRange.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ForWithoutRange.kt")
            public void testForWithoutRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ForWithoutRange.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("FunFun.kt")
            public void testFunFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/FunFun.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IfKeywordRBrace.kt")
            public void testIfKeywordRBrace() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IfKeywordRBrace.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IfWithEmptyCondition.kt")
            public void testIfWithEmptyCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IfWithEmptyCondition.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IfWithoutLPar.kt")
            public void testIfWithoutLPar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IfWithoutLPar.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ImportRecovery.kt")
            public void testImportRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ImportRecovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteAccessor1.kt")
            public void testIncompleteAccessor1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteAccessor1.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteAccessor2.kt")
            public void testIncompleteAccessor2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteAccessor2.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteClassDeclaration.kt")
            public void testIncompleteClassDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteClassDeclaration.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteClassTypeParameters.kt")
            public void testIncompleteClassTypeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteClassTypeParameters.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteForRBrace.kt")
            public void testIncompleteForRBrace() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteForRBrace.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteFun.kt")
            public void testIncompleteFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteFun.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteFunDeclaration.kt")
            public void testIncompleteFunDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteFunDeclaration.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteFunTypeParameters.kt")
            public void testIncompleteFunTypeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteFunTypeParameters.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteTypeParameters.kt")
            public void testIncompleteTypeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteTypeParameters.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteTypeRefWithPackageKeyword.kt")
            public void testIncompleteTypeRefWithPackageKeyword() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteTypeRefWithPackageKeyword.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteValTypeParameters.kt")
            public void testIncompleteValTypeParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteValTypeParameters.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteWhenElse.kt")
            public void testIncompleteWhenElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteWhenElse.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteWhere.kt")
            public void testIncompleteWhere() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteWhere.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("IncompleteWhere2.kt")
            public void testIncompleteWhere2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/IncompleteWhere2.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("initRecovery.kt")
            public void testInitRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/initRecovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("InterfaceInExpressionPosition.kt")
            public void testInterfaceInExpressionPosition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/InterfaceInExpressionPosition.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("InvalidCharAfterPropertyName.kt")
            public void testInvalidCharAfterPropertyName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/InvalidCharAfterPropertyName.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("InvalidCharInSingleLineLambda.kt")
            public void testInvalidCharInSingleLineLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/InvalidCharInSingleLineLambda.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("kt2172.kt")
            public void testKt2172() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/kt2172.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("kt5102.kt")
            public void testKt5102() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/kt5102.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("MissingCommaInConstructorValueParameterList.kt")
            public void testMissingCommaInConstructorValueParameterList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/MissingCommaInConstructorValueParameterList.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("MissingCommaInValueArgumentList.kt")
            public void testMissingCommaInValueArgumentList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/MissingCommaInValueArgumentList.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("MissingCommaInValueParameterList.kt")
            public void testMissingCommaInValueParameterList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/MissingCommaInValueParameterList.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("MissingCommaInValueParameterListWithValOrVar.kt")
            public void testMissingCommaInValueParameterListWithValOrVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/MissingCommaInValueParameterListWithValOrVar.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("NoArrowInWhen.kt")
            public void testNoArrowInWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/NoArrowInWhen.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageNewLineRecovery.kt")
            public void testPackageNewLineRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/PackageNewLineRecovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("PackageRecovery.kt")
            public void testPackageRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/PackageRecovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("SameLineStatementRecovery.kt")
            public void testSameLineStatementRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/SameLineStatementRecovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ValNoName.kt")
            public void testValNoName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ValNoName.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ValWithNoNameBeforeNextDeclarationWithModifiers.kt")
            public void testValWithNoNameBeforeNextDeclarationWithModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ValWithNoNameBeforeNextDeclarationWithModifiers.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ValWithNoNameInBlock.kt")
            public void testValWithNoNameInBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ValWithNoNameInBlock.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("ValueParameterNoTypeRecovery.kt")
            public void testValueParameterNoTypeRecovery() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/ValueParameterNoTypeRecovery.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("WhenWithoutBraces.kt")
            public void testWhenWithoutBraces() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/WhenWithoutBraces.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("WhileWithEmptyCondition.kt")
            public void testWhileWithEmptyCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/WhileWithEmptyCondition.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("WhileWithoutLPar.kt")
            public void testWhileWithoutLPar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/WhileWithoutLPar.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("WithWithoutInAndMultideclaration.kt")
            public void testWithWithoutInAndMultideclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/WithWithoutInAndMultideclaration.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("compiler/testData/psi/recovery/objects")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Objects extends AbstractParsingTest {
                public void testAllFilesPresentInObjects() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/recovery/objects"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/testData/psi/recovery/objects/declarations")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Declarations extends AbstractParsingTest {
                    public void testAllFilesPresentInDeclarations() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/recovery/objects/declarations"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("ConstructorModifiers.kt")
                    public void testConstructorModifiers() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/declarations/ConstructorModifiers.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("EmptyParentheses.kt")
                    public void testEmptyParentheses() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/declarations/EmptyParentheses.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("Everything.kt")
                    public void testEverything() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/declarations/Everything.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("FollowedByModifiers.kt")
                    public void testFollowedByModifiers() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/declarations/FollowedByModifiers.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("ParametersInParentheses.kt")
                    public void testParametersInParentheses() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/declarations/ParametersInParentheses.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("TypeParametersAndParentheses.kt")
                    public void testTypeParametersAndParentheses() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/declarations/TypeParametersAndParentheses.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("TypeParameterss.kt")
                    public void testTypeParameterss() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/declarations/TypeParameterss.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("Where.kt")
                    public void testWhere() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/declarations/Where.kt");
                        doParsingTest(fileName);
                    }
                }

                @TestMetadata("compiler/testData/psi/recovery/objects/expressions")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Expressions extends AbstractParsingTest {
                    public void testAllFilesPresentInExpressions() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/recovery/objects/expressions"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("ConstructorModifiers.kt")
                    public void testConstructorModifiers() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/expressions/ConstructorModifiers.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("ConstructorModifiersAndName.kt")
                    public void testConstructorModifiersAndName() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/expressions/ConstructorModifiersAndName.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("EmptyParentheses.kt")
                    public void testEmptyParentheses() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/expressions/EmptyParentheses.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("Everything.kt")
                    public void testEverything() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/expressions/Everything.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("InFunction.kt")
                    public void testInFunction() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/expressions/InFunction.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("ParametersInParentheses.kt")
                    public void testParametersInParentheses() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/expressions/ParametersInParentheses.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("TypeParametersAndParentheses.kt")
                    public void testTypeParametersAndParentheses() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/expressions/TypeParametersAndParentheses.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("TypeParameterss.kt")
                    public void testTypeParameterss() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/expressions/TypeParameterss.kt");
                        doParsingTest(fileName);
                    }

                    @TestMetadata("Where.kt")
                    public void testWhere() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/objects/expressions/Where.kt");
                        doParsingTest(fileName);
                    }
                }
            }

            @TestMetadata("compiler/testData/psi/recovery/qualifiedExpression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class QualifiedExpression extends AbstractParsingTest {
                public void testAllFilesPresentInQualifiedExpression() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/recovery/qualifiedExpression"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("noQualifiedExpression.kt")
                public void testNoQualifiedExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/qualifiedExpression/noQualifiedExpression.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("noSafeQualifiedExpression.kt")
                public void testNoSafeQualifiedExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/qualifiedExpression/noSafeQualifiedExpression.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("qualifiedExpressionWithSelector.kt")
                public void testQualifiedExpressionWithSelector() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/qualifiedExpression/qualifiedExpressionWithSelector.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("qualifiedExpressionWithoutSelector.kt")
                public void testQualifiedExpressionWithoutSelector() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/qualifiedExpression/qualifiedExpressionWithoutSelector.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("safeQualifiedExpressionWithSelector.kt")
                public void testSafeQualifiedExpressionWithSelector() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/qualifiedExpression/safeQualifiedExpressionWithSelector.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("safeQualifiedExpressionWithoutSelector.kt")
                public void testSafeQualifiedExpressionWithoutSelector() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/qualifiedExpression/safeQualifiedExpressionWithoutSelector.kt");
                    doParsingTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/psi/recovery/unnamedParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class UnnamedParameter extends AbstractParsingTest {
                public void testAllFilesPresentInUnnamedParameter() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/recovery/unnamedParameter"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
                }

                @TestMetadata("firstInFunction.kt")
                public void testFirstInFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/firstInFunction.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("firstInFunctionalType.kt")
                public void testFirstInFunctionalType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/firstInFunctionalType.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("firstInLambda.kt")
                public void testFirstInLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/firstInLambda.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("firstInPrimaryConstructor.kt")
                public void testFirstInPrimaryConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/firstInPrimaryConstructor.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("firstInSecondaryConstructor.kt")
                public void testFirstInSecondaryConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/firstInSecondaryConstructor.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("firstInSetter.kt")
                public void testFirstInSetter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/firstInSetter.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("secondInFunction.kt")
                public void testSecondInFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/secondInFunction.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("secondInFunctionalType.kt")
                public void testSecondInFunctionalType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/secondInFunctionalType.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("secondInLambda.kt")
                public void testSecondInLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/secondInLambda.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("secondInPrimaryConstructor.kt")
                public void testSecondInPrimaryConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/secondInPrimaryConstructor.kt");
                    doParsingTest(fileName);
                }

                @TestMetadata("secondInSecondaryConstructor.kt")
                public void testSecondInSecondaryConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/recovery/unnamedParameter/secondInSecondaryConstructor.kt");
                    doParsingTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/psi/script")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Script extends AbstractParsingTest {
            public void testAllFilesPresentInScript() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/script"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ComplexScript.kts")
            public void testComplexScript() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/script/ComplexScript.kts");
                doParsingTest(fileName);
            }

            @TestMetadata("Import.kts")
            public void testImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/script/Import.kts");
                doParsingTest(fileName);
            }

            @TestMetadata("manyAnnotationsOnFile.kts")
            public void testManyAnnotationsOnFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/script/manyAnnotationsOnFile.kts");
                doParsingTest(fileName);
            }

            @TestMetadata("Shebang.kts")
            public void testShebang() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/script/Shebang.kts");
                doParsingTest(fileName);
            }

            @TestMetadata("ShebangIncorrect.kts")
            public void testShebangIncorrect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/script/ShebangIncorrect.kts");
                doParsingTest(fileName);
            }

            @TestMetadata("SimpleScript.kts")
            public void testSimpleScript() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/script/SimpleScript.kts");
                doParsingTest(fileName);
            }

            @TestMetadata("unexpectedSymbol.kts")
            public void testUnexpectedSymbol() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/script/unexpectedSymbol.kts");
                doParsingTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/psi/secondaryConstructors")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SecondaryConstructors extends AbstractParsingTest {
            public void testAllFilesPresentInSecondaryConstructors() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/secondaryConstructors"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("anonymousInitializer.kt")
            public void testAnonymousInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/anonymousInitializer.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/basic.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("emptyBody.kt")
            public void testEmptyBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/emptyBody.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("enumParsing.kt")
            public void testEnumParsing() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/enumParsing.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("recoveryEmptyDelegationType.kt")
            public void testRecoveryEmptyDelegationType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/recoveryEmptyDelegationType.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("recoveryJustConstructorKeyword.kt")
            public void testRecoveryJustConstructorKeyword() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/recoveryJustConstructorKeyword.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("recoveryJustConstructorKeywordSameLineBrace.kt")
            public void testRecoveryJustConstructorKeywordSameLineBrace() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/recoveryJustConstructorKeywordSameLineBrace.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("recoveryNoDelegationCallAfterColon.kt")
            public void testRecoveryNoDelegationCallAfterColon() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/recoveryNoDelegationCallAfterColon.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("recoveryWithoutBodyWrongDelegationName.kt")
            public void testRecoveryWithoutBodyWrongDelegationName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/recoveryWithoutBodyWrongDelegationName.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("recoveryWithoutParameterList.kt")
            public void testRecoveryWithoutParameterList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/recoveryWithoutParameterList.kt");
                doParsingTest(fileName);
            }

            @TestMetadata("recoveryWrongDelegationName.kt")
            public void testRecoveryWrongDelegationName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/secondaryConstructors/recoveryWrongDelegationName.kt");
                doParsingTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/psi/stringTemplates")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StringTemplates extends AbstractParsingTest {
            public void testAllFilesPresentInStringTemplates() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/psi/stringTemplates"), Pattern.compile("^(.*)\\.kts?$"), TargetBackend.ANY, true);
            }

            @TestMetadata("RawStringsWithManyQuotes.kt")
            public void testRawStringsWithManyQuotes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/psi/stringTemplates/RawStringsWithManyQuotes.kt");
                doParsingTest(fileName);
            }
        }
    }

    @TestMetadata("compiler/testData/parseCodeFragment/expression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Expression extends AbstractParsingTest {
        public void testAllFilesPresentInExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/parseCodeFragment/expression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("error.kt")
        public void testError() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/expression/error.kt");
            doExpressionCodeFragmentParsingTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/expression/simple.kt");
            doExpressionCodeFragmentParsingTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/parseCodeFragment/block")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Block extends AbstractParsingTest {
        public void testAllFilesPresentInBlock() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/parseCodeFragment/block"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("expressionOnTopLevel.kt")
        public void testExpressionOnTopLevel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/block/expressionOnTopLevel.kt");
            doBlockCodeFragmentParsingTest(fileName);
        }

        @TestMetadata("imports.kt")
        public void testImports() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/block/imports.kt");
            doBlockCodeFragmentParsingTest(fileName);
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/block/localFun.kt");
            doBlockCodeFragmentParsingTest(fileName);
        }

        @TestMetadata("oneLine.kt")
        public void testOneLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/block/oneLine.kt");
            doBlockCodeFragmentParsingTest(fileName);
        }

        @TestMetadata("oneStatement.kt")
        public void testOneStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/block/oneStatement.kt");
            doBlockCodeFragmentParsingTest(fileName);
        }

        @TestMetadata("packageAndImport.kt")
        public void testPackageAndImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/block/packageAndImport.kt");
            doBlockCodeFragmentParsingTest(fileName);
        }

        @TestMetadata("packageDirective.kt")
        public void testPackageDirective() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/block/packageDirective.kt");
            doBlockCodeFragmentParsingTest(fileName);
        }

        @TestMetadata("severalExpressions.kt")
        public void testSeveralExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/block/severalExpressions.kt");
            doBlockCodeFragmentParsingTest(fileName);
        }

        @TestMetadata("severalStatements.kt")
        public void testSeveralStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/block/severalStatements.kt");
            doBlockCodeFragmentParsingTest(fileName);
        }

        @TestMetadata("unexpectedSymbol.kt")
        public void testUnexpectedSymbol() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/parseCodeFragment/block/unexpectedSymbol.kt");
            doBlockCodeFragmentParsingTest(fileName);
        }
    }
}
