/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.renderer;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/renderFunctionDescriptorInExpression")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class FunctionDescriptorInExpressionRendererTestGenerated extends AbstractFunctionDescriptorInExpressionRendererTest {
    public void testAllFilesPresentInRenderFunctionDescriptorInExpression() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/renderFunctionDescriptorInExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("basicFunExpr.kt")
    public void testBasicFunExpr() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/renderFunctionDescriptorInExpression/basicFunExpr.kt");
        doTest(fileName);
    }

    @TestMetadata("basicFunExprArgs.kt")
    public void testBasicFunExprArgs() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/renderFunctionDescriptorInExpression/basicFunExprArgs.kt");
        doTest(fileName);
    }

    @TestMetadata("basicLambda.kt")
    public void testBasicLambda() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/renderFunctionDescriptorInExpression/basicLambda.kt");
        doTest(fileName);
    }

    @TestMetadata("labeledLambda.kt")
    public void testLabeledLambda() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/renderFunctionDescriptorInExpression/labeledLambda.kt");
        doTest(fileName);
    }

    @TestMetadata("parenthesizedFunExpr.kt")
    public void testParenthesizedFunExpr() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/renderFunctionDescriptorInExpression/parenthesizedFunExpr.kt");
        doTest(fileName);
    }

    @TestMetadata("parenthesizedLambda.kt")
    public void testParenthesizedLambda() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/renderFunctionDescriptorInExpression/parenthesizedLambda.kt");
        doTest(fileName);
    }
}
