/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.resolve.annotation;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/resolveAnnotations/parameters")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class AnnotationParameterTestGenerated extends AbstractAnnotationParameterTest {
    public void testAllFilesPresentInParameters() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/resolveAnnotations/parameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("byte.kt")
    public void testByte() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/byte.kt");
        doTest(fileName);
    }

    @TestMetadata("char.kt")
    public void testChar() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/char.kt");
        doTest(fileName);
    }

    @TestMetadata("double.kt")
    public void testDouble() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/double.kt");
        doTest(fileName);
    }

    @TestMetadata("float.kt")
    public void testFloat() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/float.kt");
        doTest(fileName);
    }

    @TestMetadata("int.kt")
    public void testInt() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/int.kt");
        doTest(fileName);
    }

    @TestMetadata("long.kt")
    public void testLong() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/long.kt");
        doTest(fileName);
    }

    @TestMetadata("short.kt")
    public void testShort() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/short.kt");
        doTest(fileName);
    }

    @TestMetadata("compiler/testData/resolveAnnotations/parameters/expressions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Expressions extends AbstractAnnotationParameterTest {
        public void testAllFilesPresentInExpressions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/resolveAnnotations/parameters/expressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("andAnd.kt")
        public void testAndAnd() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/andAnd.kt");
            doTest(fileName);
        }

        @TestMetadata("boolean.kt")
        public void testBoolean() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/boolean.kt");
            doTest(fileName);
        }

        @TestMetadata("char.kt")
        public void testChar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/char.kt");
            doTest(fileName);
        }

        @TestMetadata("compositeCallBinary.kt")
        public void testCompositeCallBinary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/compositeCallBinary.kt");
            doTest(fileName);
        }

        @TestMetadata("divide.kt")
        public void testDivide() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/divide.kt");
            doTest(fileName);
        }

        @TestMetadata("double.kt")
        public void testDouble() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/double.kt");
            doTest(fileName);
        }

        @TestMetadata("eqeq.kt")
        public void testEqeq() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/eqeq.kt");
            doTest(fileName);
        }

        @TestMetadata("escapedString.kt")
        public void testEscapedString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/escapedString.kt");
            doTest(fileName);
        }

        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/float.kt");
            doTest(fileName);
        }

        @TestMetadata("gt.kt")
        public void testGt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/gt.kt");
            doTest(fileName);
        }

        @TestMetadata("gteq.kt")
        public void testGteq() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/gteq.kt");
            doTest(fileName);
        }

        @TestMetadata("intrincics.kt")
        public void testIntrincics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/intrincics.kt");
            doTest(fileName);
        }

        @TestMetadata("labeled.kt")
        public void testLabeled() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/labeled.kt");
            doTest(fileName);
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/long.kt");
            doTest(fileName);
        }

        @TestMetadata("lt.kt")
        public void testLt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/lt.kt");
            doTest(fileName);
        }

        @TestMetadata("lteq.kt")
        public void testLteq() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/lteq.kt");
            doTest(fileName);
        }

        @TestMetadata("maxValue.kt")
        public void testMaxValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/maxValue.kt");
            doTest(fileName);
        }

        @TestMetadata("maxValueByte.kt")
        public void testMaxValueByte() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/maxValueByte.kt");
            doTest(fileName);
        }

        @TestMetadata("maxValueInt.kt")
        public void testMaxValueInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/maxValueInt.kt");
            doTest(fileName);
        }

        @TestMetadata("miltiply.kt")
        public void testMiltiply() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/miltiply.kt");
            doTest(fileName);
        }

        @TestMetadata("minus.kt")
        public void testMinus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/minus.kt");
            doTest(fileName);
        }

        @TestMetadata("mod.kt")
        public void testMod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/mod.kt");
            doTest(fileName);
        }

        @TestMetadata("multilineString.kt")
        public void testMultilineString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/multilineString.kt");
            doTest(fileName);
        }

        @TestMetadata("not.kt")
        public void testNot() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/not.kt");
            doTest(fileName);
        }

        @TestMetadata("noteq.kt")
        public void testNoteq() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/noteq.kt");
            doTest(fileName);
        }

        @TestMetadata("orOr.kt")
        public void testOrOr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/orOr.kt");
            doTest(fileName);
        }

        @TestMetadata("paranthesized.kt")
        public void testParanthesized() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/paranthesized.kt");
            doTest(fileName);
        }

        @TestMetadata("plus.kt")
        public void testPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/plus.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleCallBinary.kt")
        public void testSimpleCallBinary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/simpleCallBinary.kt");
            doTest(fileName);
        }

        @TestMetadata("stringPlusInt.kt")
        public void testStringPlusInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/stringPlusInt.kt");
            doTest(fileName);
        }

        @TestMetadata("stringTemplate.kt")
        public void testStringTemplate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/stringTemplate.kt");
            doTest(fileName);
        }

        @TestMetadata("strings.kt")
        public void testStrings() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/strings.kt");
            doTest(fileName);
        }

        @TestMetadata("unaryMinus.kt")
        public void testUnaryMinus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/unaryMinus.kt");
            doTest(fileName);
        }

        @TestMetadata("unaryPlus.kt")
        public void testUnaryPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/resolveAnnotations/parameters/expressions/unaryPlus.kt");
            doTest(fileName);
        }
    }
}
