/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.resolve.constraintSystem;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/constraintSystem")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class ConstraintSystemTestGenerated extends AbstractConstraintSystemTest {
    public void testAllFilesPresentInConstraintSystem() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
    }

    @TestMetadata("compiler/testData/constraintSystem/checkStatus")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CheckStatus extends AbstractConstraintSystemTest {
        public void testAllFilesPresentInCheckStatus() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/checkStatus"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
        }

        @TestMetadata("conflictingConstraints.constraints")
        public void testConflictingConstraints() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/checkStatus/conflictingConstraints.constraints");
            doTest(fileName);
        }

        @TestMetadata("successful.constraints")
        public void testSuccessful() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/checkStatus/successful.constraints");
            doTest(fileName);
        }

        @TestMetadata("typeConstructorMismatch.constraints")
        public void testTypeConstructorMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/checkStatus/typeConstructorMismatch.constraints");
            doTest(fileName);
        }

        @TestMetadata("unknownParameters.constraints")
        public void testUnknownParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/checkStatus/unknownParameters.constraints");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/constraintSystem/computeValues")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ComputeValues extends AbstractConstraintSystemTest {
        public void testAllFilesPresentInComputeValues() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/computeValues"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
        }

        @TestMetadata("contradiction.constraints")
        public void testContradiction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/computeValues/contradiction.constraints");
            doTest(fileName);
        }

        @TestMetadata("subTypeOfUpperBounds.constraints")
        public void testSubTypeOfUpperBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/computeValues/subTypeOfUpperBounds.constraints");
            doTest(fileName);
        }

        @TestMetadata("superTypeOfLowerBounds1.constraints")
        public void testSuperTypeOfLowerBounds1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/computeValues/superTypeOfLowerBounds1.constraints");
            doTest(fileName);
        }

        @TestMetadata("superTypeOfLowerBounds2.constraints")
        public void testSuperTypeOfLowerBounds2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/computeValues/superTypeOfLowerBounds2.constraints");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/constraintSystem/integerValueTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntegerValueTypes extends AbstractConstraintSystemTest {
        public void testAllFilesPresentInIntegerValueTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/integerValueTypes"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
        }

        @TestMetadata("byteOverflow.constraints")
        public void testByteOverflow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/integerValueTypes/byteOverflow.constraints");
            doTest(fileName);
        }

        @TestMetadata("defaultLong.constraints")
        public void testDefaultLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/integerValueTypes/defaultLong.constraints");
            doTest(fileName);
        }

        @TestMetadata("numberAndAny.constraints")
        public void testNumberAndAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/integerValueTypes/numberAndAny.constraints");
            doTest(fileName);
        }

        @TestMetadata("numberAndString.constraints")
        public void testNumberAndString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/integerValueTypes/numberAndString.constraints");
            doTest(fileName);
        }

        @TestMetadata("severalNumbers.constraints")
        public void testSeveralNumbers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/integerValueTypes/severalNumbers.constraints");
            doTest(fileName);
        }

        @TestMetadata("simpleByte.constraints")
        public void testSimpleByte() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/integerValueTypes/simpleByte.constraints");
            doTest(fileName);
        }

        @TestMetadata("simpleInt.constraints")
        public void testSimpleInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/integerValueTypes/simpleInt.constraints");
            doTest(fileName);
        }

        @TestMetadata("simpleShort.constraints")
        public void testSimpleShort() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/integerValueTypes/simpleShort.constraints");
            doTest(fileName);
        }
    }

    @TestMetadata("compiler/testData/constraintSystem/severalVariables")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SeveralVariables extends AbstractConstraintSystemTest {
        public void testAllFilesPresentInSeveralVariables() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simpleDependency.constraints")
        public void testSimpleDependency() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/simpleDependency.constraints");
            doTest(fileName);
        }

        @TestMetadata("simpleEquality.constraints")
        public void testSimpleEquality() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/simpleEquality.constraints");
            doTest(fileName);
        }

        @TestMetadata("simpleEquality1.constraints")
        public void testSimpleEquality1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/simpleEquality1.constraints");
            doTest(fileName);
        }

        @TestMetadata("simpleReversedDependency.constraints")
        public void testSimpleReversedDependency() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/simpleReversedDependency.constraints");
            doTest(fileName);
        }

        @TestMetadata("simpleSubtype.constraints")
        public void testSimpleSubtype() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/simpleSubtype.constraints");
            doTest(fileName);
        }

        @TestMetadata("simpleSubtype1.constraints")
        public void testSimpleSubtype1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/simpleSubtype1.constraints");
            doTest(fileName);
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/direct")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Direct extends AbstractConstraintSystemTest {
            public void testAllFilesPresentInDirect() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/direct"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Contravariant extends AbstractConstraintSystemTest {
                public void testAllFilesPresentInContravariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/direct/contravariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varEqDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varEqDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varEqDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSubDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSubDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSubDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSuperDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSuperDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/contravariant/varSuperDepSuper.constraints");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Covariant extends AbstractConstraintSystemTest {
                public void testAllFilesPresentInCovariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/direct/covariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant/varEqDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant/varEqDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant/varEqDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSubDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSubDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSubDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSuperDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSuperDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/covariant/varSuperDepSuper.constraints");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invariant extends AbstractConstraintSystemTest {
                public void testAllFilesPresentInInvariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/direct/invariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant/varEqDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant/varEqDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant/varEqDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSubDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSubDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSubDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSuperDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSuperDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/direct/invariant/varSuperDepSuper.constraints");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/interdependency")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Interdependency extends AbstractConstraintSystemTest {
            public void testAllFilesPresentInInterdependency() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/interdependency"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("interdependency1.constraints")
            public void testInterdependency1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/interdependency/interdependency1.constraints");
                doTest(fileName);
            }

            @TestMetadata("interdependency2.constraints")
            public void testInterdependency2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/interdependency/interdependency2.constraints");
                doTest(fileName);
            }

            @TestMetadata("interdependency3.constraints")
            public void testInterdependency3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/interdependency/interdependency3.constraints");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/nullable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Nullable extends AbstractConstraintSystemTest {
            public void testAllFilesPresentInNullable() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/nullable"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Contravariant extends AbstractConstraintSystemTest {
                public void testAllFilesPresentInContravariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/nullable/contravariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varEqDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varEqDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varEqDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSubDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSubDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSubDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSuperDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSuperDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/contravariant/varSuperDepSuper.constraints");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Covariant extends AbstractConstraintSystemTest {
                public void testAllFilesPresentInCovariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/nullable/covariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varEqDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varEqDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varEqDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSubDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSubDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSubDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSuperDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSuperDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/covariant/varSuperDepSuper.constraints");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invariant extends AbstractConstraintSystemTest {
                public void testAllFilesPresentInInvariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/nullable/invariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varEqDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varEqDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varEqDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSubDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSubDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSubDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSuperDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSuperDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/nullable/invariant/varSuperDepSuper.constraints");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/other")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Other extends AbstractConstraintSystemTest {
            public void testAllFilesPresentInOther() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/other"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("constraintForNullables.constraints")
            public void testConstraintForNullables() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/constraintForNullables.constraints");
                doTest(fileName);
            }

            @TestMetadata("nestedConsumer.constraints")
            public void testNestedConsumer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/nestedConsumer.constraints");
                doTest(fileName);
            }

            @TestMetadata("nestedConsumer1.constraints")
            public void testNestedConsumer1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/nestedConsumer1.constraints");
                doTest(fileName);
            }

            @TestMetadata("nestedInvConsumer.constraints")
            public void testNestedInvConsumer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/nestedInvConsumer.constraints");
                doTest(fileName);
            }

            @TestMetadata("nestedInvProducer.constraints")
            public void testNestedInvProducer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/nestedInvProducer.constraints");
                doTest(fileName);
            }

            @TestMetadata("nestedProducer.constraints")
            public void testNestedProducer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/nestedProducer.constraints");
                doTest(fileName);
            }

            @TestMetadata("nestedProducerAndConsumer.constraints")
            public void testNestedProducerAndConsumer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/nestedProducerAndConsumer.constraints");
                doTest(fileName);
            }

            @TestMetadata("severalOccurrences.constraints")
            public void testSeveralOccurrences() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/severalOccurrences.constraints");
                doTest(fileName);
            }

            @TestMetadata("simpleFun.constraints")
            public void testSimpleFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/simpleFun.constraints");
                doTest(fileName);
            }

            @TestMetadata("simpleThreeVars.constraints")
            public void testSimpleThreeVars() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/simpleThreeVars.constraints");
                doTest(fileName);
            }

            @TestMetadata("simpleThreeVarsNoIncorporation.constraints")
            public void testSimpleThreeVarsNoIncorporation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/simpleThreeVarsNoIncorporation.constraints");
                doTest(fileName);
            }

            @TestMetadata("simpleThreeVarsNoIncorporationFixed.constraints")
            public void testSimpleThreeVarsNoIncorporationFixed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/other/simpleThreeVarsNoIncorporationFixed.constraints");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/recursive")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Recursive extends AbstractConstraintSystemTest {
            public void testAllFilesPresentInRecursive() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/recursive"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("implicitlyRecursive.constraints")
            public void testImplicitlyRecursive() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/recursive/implicitlyRecursive.constraints");
                doTest(fileName);
            }

            @TestMetadata("kt8879.constraints")
            public void testKt8879() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/recursive/kt8879.constraints");
                doTest(fileName);
            }

            @TestMetadata("mutuallyRecursive.constraints")
            public void testMutuallyRecursive() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/recursive/mutuallyRecursive.constraints");
                doTest(fileName);
            }

            @TestMetadata("simpleRecursive.constraints")
            public void testSimpleRecursive() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/recursive/simpleRecursive.constraints");
                doTest(fileName);
            }
        }

        @TestMetadata("compiler/testData/constraintSystem/severalVariables/reversed")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Reversed extends AbstractConstraintSystemTest {
            public void testAllFilesPresentInReversed() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/reversed"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Contravariant extends AbstractConstraintSystemTest {
                public void testAllFilesPresentInContravariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/reversed/contravariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varEqDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varEqDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varEqDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSubDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSubDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSubDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSuperDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSuperDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/contravariant/varSuperDepSuper.constraints");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Covariant extends AbstractConstraintSystemTest {
                public void testAllFilesPresentInCovariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/reversed/covariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varEqDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varEqDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varEqDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSubDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSubDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSubDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSuperDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSuperDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/covariant/varSuperDepSuper.constraints");
                    doTest(fileName);
                }
            }

            @TestMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invariant extends AbstractConstraintSystemTest {
                public void testAllFilesPresentInInvariant() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/severalVariables/reversed/invariant"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varEqDepEq.constraints")
                public void testVarEqDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varEqDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSub.constraints")
                public void testVarEqDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varEqDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varEqDepSuper.constraints")
                public void testVarEqDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varEqDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepEq.constraints")
                public void testVarSubDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSubDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSub.constraints")
                public void testVarSubDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSubDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSubDepSuper.constraints")
                public void testVarSubDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSubDepSuper.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepEq.constraints")
                public void testVarSuperDepEq() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSuperDepEq.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSub.constraints")
                public void testVarSuperDepSub() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSuperDepSub.constraints");
                    doTest(fileName);
                }

                @TestMetadata("varSuperDepSuper.constraints")
                public void testVarSuperDepSuper() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/severalVariables/reversed/invariant/varSuperDepSuper.constraints");
                    doTest(fileName);
                }
            }
        }
    }

    @TestMetadata("compiler/testData/constraintSystem/variance")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Variance extends AbstractConstraintSystemTest {
        public void testAllFilesPresentInVariance() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/constraintSystem/variance"), Pattern.compile("^(.+)\\.constraints$"), TargetBackend.ANY, true);
        }

        @TestMetadata("consumer.constraints")
        public void testConsumer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/variance/consumer.constraints");
            doTest(fileName);
        }

        @TestMetadata("invariant.constraints")
        public void testInvariant() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/variance/invariant.constraints");
            doTest(fileName);
        }

        @TestMetadata("producer.constraints")
        public void testProducer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/constraintSystem/variance/producer.constraints");
            doTest(fileName);
        }
    }
}
