/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.serialization;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/serialization/local")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class LocalClassProtoTestGenerated extends AbstractLocalClassProtoTest {
    public void testAllFilesPresentInLocal() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/serialization/local"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("annotationsInLocalClass.kt")
    public void testAnnotationsInLocalClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/serialization/local/annotationsInLocalClass.kt");
        doTest(fileName);
    }

    @TestMetadata("anonymousObject.kt")
    public void testAnonymousObject() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/serialization/local/anonymousObject.kt");
        doTest(fileName);
    }

    @TestMetadata("deepInnerChain.kt")
    public void testDeepInnerChain() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/serialization/local/deepInnerChain.kt");
        doTest(fileName);
    }

    @TestMetadata("innerOfLocal.kt")
    public void testInnerOfLocal() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/serialization/local/innerOfLocal.kt");
        doTest(fileName);
    }

    @TestMetadata("localClassInSignature.kt")
    public void testLocalClassInSignature() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/serialization/local/localClassInSignature.kt");
        doTest(fileName);
    }

    @TestMetadata("simpleInMemberFunction.kt")
    public void testSimpleInMemberFunction() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/serialization/local/simpleInMemberFunction.kt");
        doTest(fileName);
    }

    @TestMetadata("simpleInTopLevelFunction.kt")
    public void testSimpleInTopLevelFunction() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("compiler/testData/serialization/local/simpleInTopLevelFunction.kt");
        doTest(fileName);
    }
}
