/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.completion.test;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/idea-completion/testData/smartMultiFile")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class MultiFileSmartCompletionTestGenerated extends AbstractMultiFileSmartCompletionTest {
    public void testAllFilesPresentInSmartMultiFile() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/smartMultiFile"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, false);
    }

    @TestMetadata("AnonymousObjectGenericJava")
    public void testAnonymousObjectGenericJava() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/AnonymousObjectGenericJava/");
        doTest(fileName);
    }

    @TestMetadata("CallableReferenceNotImported")
    public void testCallableReferenceNotImported() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/CallableReferenceNotImported/");
        doTest(fileName);
    }

    @TestMetadata("CallablesInExcludedPackage")
    public void testCallablesInExcludedPackage() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/CallablesInExcludedPackage/");
        doTest(fileName);
    }

    @TestMetadata("FunctionFromAnotherPackage")
    public void testFunctionFromAnotherPackage() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/FunctionFromAnotherPackage/");
        doTest(fileName);
    }

    @TestMetadata("GenericInheritors1")
    public void testGenericInheritors1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/GenericInheritors1/");
        doTest(fileName);
    }

    @TestMetadata("GenericInheritors2")
    public void testGenericInheritors2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/GenericInheritors2/");
        doTest(fileName);
    }

    @TestMetadata("GenericInheritors3")
    public void testGenericInheritors3() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/GenericInheritors3/");
        doTest(fileName);
    }

    @TestMetadata("GenericInheritors4")
    public void testGenericInheritors4() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/GenericInheritors4/");
        doTest(fileName);
    }

    @TestMetadata("InheritorInTheSameFile")
    public void testInheritorInTheSameFile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/InheritorInTheSameFile/");
        doTest(fileName);
    }

    @TestMetadata("Inheritors")
    public void testInheritors() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/Inheritors/");
        doTest(fileName);
    }

    @TestMetadata("InheritorsAndMultipleExpectedTypes")
    public void testInheritorsAndMultipleExpectedTypes() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/InheritorsAndMultipleExpectedTypes/");
        doTest(fileName);
    }

    @TestMetadata("JavaStaticMethodArgument")
    public void testJavaStaticMethodArgument() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/JavaStaticMethodArgument/");
        doTest(fileName);
    }

    @TestMetadata("JavaStaticMethodArgument2")
    public void testJavaStaticMethodArgument2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/JavaStaticMethodArgument2/");
        doTest(fileName);
    }

    @TestMetadata("KT_8751")
    public void testKT_8751() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/KT_8751/");
        doTest(fileName);
    }

    @TestMetadata("KT_8751_2")
    public void testKT_8751_2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/KT_8751_2/");
        doTest(fileName);
    }

    @TestMetadata("NestedClassAfterAs")
    public void testNestedClassAfterAs() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/NestedClassAfterAs/");
        doTest(fileName);
    }

    @TestMetadata("NoObjectDuplication")
    public void testNoObjectDuplication() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/NoObjectDuplication/");
        doTest(fileName);
    }

    @TestMetadata("NotImportedContains")
    public void testNotImportedContains() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/NotImportedContains/");
        doTest(fileName);
    }

    @TestMetadata("NotImportedGetValue")
    public void testNotImportedGetValue() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/NotImportedGetValue/");
        doTest(fileName);
    }

    @TestMetadata("StaticMembers1")
    public void testStaticMembers1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/StaticMembers1/");
        doTest(fileName);
    }

    @TestMetadata("StaticMembers2")
    public void testStaticMembers2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/smartMultiFile/StaticMembers2/");
        doTest(fileName);
    }
}
